//						fileload.cpp
//
// most of the file functions
// - loading and saving databases overall control
// - loading executable files, initial bootstrap and identify structure and start disasm
// note: some of this has grown too big, need to consider some new classes/ routines/ files ?
// eg PE file routine is a right mess......

#include <windows.h>
#include <stdio.h>

#include "fileload.h"
#include "schedule.h"
#include "proctab.h"
#include "debug.h"
#include "dasm.h"
#include "disio.h"
#include "savefile.h"
#include "menuids.rh"
#include "fileload.h"
#include "data.h"
#include "disasm.h"
#include "imports.h"
#include "exports.h"
#include "relocs.h"
#include "names.h"
#include "xref.h"
#include "decrypt.h"

BOOL FAR PASCAL loadmessbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);
BOOL FAR PASCAL checktypebox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);
BOOL FAR PASCAL helpbox1(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);
BOOL FAR PASCAL moreoptions(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);

fileloader::fileloader(void)
{ efile=INVALID_HANDLE_VALUE;
  exetype=0;
  fbuff=NULL;
}

fileloader::~fileloader(void)
{ if(fbuff!=NULL) delete fbuff;
  CloseHandle(efile);
}

// added Borg v2.19
// returns file offset of a loc, or 0 if cant find.
dword fileloader::fileoffset(lptr loc)
{ dsegitem *ds;
  ds=dta.findseg(loc);
  if(ds==NULL) return 0;
  return (loc-ds->addr)+(ds->data-fbuff);
}

// file patcher function added v2.19
void fileloader::patchfile(dword file_offs,dword num,byte *dat)
{ dword written;
  SetFilePointer(efile,file_offs,NULL,FILE_BEGIN);
  WriteFile(efile,dat,num,&written,NULL);
}

void fileloader::reloadfile(dword file_offs,dword num,byte *dat)
{ dword rd;
  SetFilePointer(efile,file_offs,NULL,FILE_BEGIN);
  ReadFile(efile,dat,num,&rd,NULL);
}

//checks header info, puts up initial loading dialog box and
//selects info routine for file.
BOOL fileloader::load(char *fname)
{ char mzhead[2],exthead[2];
  dword pe_offset;
  dword num;
  dword fsize;
  if(efile!=INVALID_HANDLE_VALUE)return FALSE;
  efile=CreateFile(fname,GENERIC_READ|GENERIC_WRITE,1,NULL,OPEN_EXISTING,0,NULL);
  if(efile==INVALID_HANDLE_VALUE)
  { efile=CreateFile(fname,GENERIC_READ,1,NULL,OPEN_EXISTING,0,NULL);
    if(efile==INVALID_HANDLE_VALUE)
      return FALSE;
    options.readonly=TRUE;
    MessageBox(mainwindow,"Couldn't obtain write permission to file\nFile opened readonly - will not be able to apply any patches",
      "Borg Message",MB_OK);
  }
  if(GetFileType(efile)!=FILE_TYPE_DISK)return FALSE;
  exetype=BIN_EXE;
  if(ReadFile(efile,mzhead,2,&num,NULL))
  { if((num==2)&&(((mzhead[0]=='M')&&(mzhead[1]=='Z'))||
		 ((mzhead[0]=='Z')&&(mzhead[1]=='M'))))
	 { SetFilePointer(efile,0x3c,NULL,FILE_BEGIN);
		if(ReadFile(efile,&pe_offset,4,&num,NULL))
		SetFilePointer(efile,pe_offset,NULL,FILE_BEGIN);
		if(ReadFile(efile,exthead,2,&num,NULL))
		{ if(((short int *)exthead)[0]==0x4550)exetype=PE_EXE;
		  else if(((short int *)exthead)[0]==0x454e)exetype=NE_EXE;
		  else if(((short int *)exthead)[0]==0x454c)exetype=LE_EXE;
		  else if(((short int *)exthead)[0]==0x584c)exetype=OS2_EXE;
		  else exetype=MZ_EXE;
		}
	 }
	 else
	 { if(strlen(fname)>3)
		{ if(!lstrcmpi(fname+strlen(fname)-3,"com"))
		  { SetFilePointer(efile,0,NULL,FILE_BEGIN);
			 exetype=COM_EXE;
		  }
		  else if(!lstrcmpi(fname+strlen(fname)-3,"sys"))
		  { SetFilePointer(efile,0,NULL,FILE_BEGIN);
			 exetype=SYS_EXE;
		  }
		}
	 }
  }
  fsize=GetFileSize(efile,NULL);
  fbuff=new byte[fsize];
  SetFilePointer(efile,0x00,NULL,FILE_BEGIN);
  ReadFile(efile,fbuff,fsize,&num,NULL);
  DialogBox(hInst,MAKEINTRESOURCE(D_checktype),mainwindow,(DLGPROC)checktypebox);
  if(!options.loadaddr.segm)
  { options.loadaddr.segm=0x1000;
	 MessageBox(mainwindow,"Sorry - Can't use a zero segment base.\nSegment Base has been set to 0x1000"
		,"Borg Message",MB_OK);
  }
  dsm.dissettable();
  switch(exetype)
  { case BIN_EXE:
		readbinfile(fsize);
		break;
	 case PE_EXE:
		readpefile(pe_offset);
		break;
	 case MZ_EXE:
		readmzfile(fsize);
		break;
	 case OS2_EXE:
		reados2file();
		CloseHandle(efile);
		efile=INVALID_HANDLE_VALUE;
		exetype=0;
		return FALSE; // at the moment;
	 case COM_EXE:
		readcomfile(fsize);
		break;
	 case SYS_EXE:
		readsysfile(fsize);
		break;
	 case LE_EXE:
		readlefile();
		CloseHandle(efile);
		efile=INVALID_HANDLE_VALUE;
		exetype=0;
		return FALSE; // at the moment;
	 case NE_EXE:
		readnefile(pe_offset);
		break;
	 default:
		CloseHandle(efile);
		efile=INVALID_HANDLE_VALUE;
		exetype=0;
		return FALSE;
  }
  return TRUE;
}

//marks data as com file.
// sets up entry point
// and data objects (only one here)
void fileloader::readcomfile(dword fsize)
{ options.loadaddr.offs=0x100;
  options.dseg=options.loadaddr.segm;
  dta.addseg(options.loadaddr,fsize,fbuff,code16,NULL);
  dta.possibleentrycode(options.loadaddr);
  options.mode16=TRUE;
  options.mode32=FALSE;
  dio.setcuraddr(options.loadaddr);
  scheduler.addtask(dis_code,priority_definitecode,options.loadaddr,NULL);
  scheduler.addtask(nameloc,priority_nameloc,options.loadaddr,"start");
  scheduler.addtask(windowupdate,priority_window,nlptr,NULL);
}

void fileloader::readsysfile(dword fsize)
{ lptr t;
  options.loadaddr.offs=0x00;
  options.dseg=options.loadaddr.segm;
  dta.addseg(options.loadaddr,fsize,fbuff,code16,NULL);
  dta.possibleentrycode(options.loadaddr);
  options.mode16=TRUE;
  options.mode32=FALSE;
  dio.setcuraddr(options.loadaddr);
  scheduler.addtask(dis_dataword,priority_data,options.loadaddr,NULL);
  scheduler.addtask(dis_dataword,priority_data,options.loadaddr+2,NULL);
  scheduler.addtask(dis_dataword,priority_data,options.loadaddr+4,NULL);
  scheduler.addtask(dis_dataword,priority_data,options.loadaddr+6,NULL);
  scheduler.addtask(dis_dataword,priority_data,options.loadaddr+8,NULL);
  if((((word *)fbuff)[0])&&((((word *)fbuff)[0])<fsize))
  { t.assign(options.loadaddr.segm,((word *)fbuff)[0]);
	 scheduler.addtask(dis_code,priority_definitecode,t,NULL);
	 scheduler.addtask(nameloc,priority_nameloc,t,"interrupt_routine");
  }
  if((((word *)fbuff)[3])&&((((word *)fbuff)[3])<fsize))
  { t.assign(options.loadaddr.segm,((word *)fbuff)[3]);
	 scheduler.addtask(dis_code,priority_definitecode,t,NULL);
	 scheduler.addtask(nameloc,priority_nameloc,t,"strategy");
  }
  if((((word *)fbuff)[4])&&((((word *)fbuff)[4])<fsize))
  { t.assign(options.loadaddr.segm,((word *)fbuff)[4]);
	 scheduler.addtask(dis_code,priority_definitecode,t,NULL);
	 scheduler.addtask(nameloc,priority_nameloc,t,"interrupt");
  }
  scheduler.addtask(windowupdate,priority_window,nlptr,NULL);
}

void fileloader::readpefile(dword peoffs)
{ peheader *peh;
  peobjdata *pdata;
  byte *pestart,*impname,*expname;
  unsigned char *chktable;
  lptr lef,leo,len,start_addr;
  dword *fnaddr,*nnaddr;
  word *onaddr,*rdata;
  dword numsymbols,numitems,numrelocs;
  char impbuff[100],inum[10],*newimpname;
  lptr sseg,t;
  dword j;
  int i,k,k1,clen;
  peimportdirentry *impdir;
  byte *uinit;
  peexportdirentry *expdir;
  perelocheader *per;
  dword thunkrva,*imphint,impaddr,impaddr2,numtmp;
  BOOL peobjdone;
  perestable *resdir;
  perestableentry *rentry;
  start_addr=nlptr;
  options.dseg=options.loadaddr.segm;
  sseg.segm=options.loadaddr.segm;
  sseg.offs=0;
  pestart=&fbuff[peoffs];
  peh=(peheader *)pestart;
  options.loadaddr.offs=peh->image_base; // bugfix build 14
  // this is not right - ver 2.19 bugfix below
  //  pdata=(peobjdata *)(pestart+sizeof(peheader)+(peh->numintitems-0x0a)*8);
  // 24=standard header size and add nt_hdr_size to it.
  pdata=(peobjdata *)(pestart+24+peh->nt_hdr_size);
  for(i=0;i<peh->objects;i++)
  { peobjdone=FALSE;
	 if((pdata[i].rva==peh->exporttable_rva)  // export info
		||((peh->exporttable_rva>pdata[i].rva)&&(peh->exporttable_rva<pdata[i].rva+pdata[i].phys_size)))
	 { expdir=(peexportdirentry *)&fbuff[pdata[i].phys_offset+peh->exporttable_rva-pdata[i].rva];
		t.assign(options.loadaddr.segm,peh->image_base+peh->exporttable_rva);
		scheduler.addtask(dis_datadword,priority_data,t,NULL);
		scheduler.addtask(dis_datadword,priority_data,t+4,NULL);
		scheduler.addtask(dis_dataword,priority_data,t+8,NULL);
		scheduler.addtask(dis_dataword,priority_data,t+10,NULL);
		scheduler.addtask(dis_datadword,priority_data,t+12,NULL);
		scheduler.addtask(dis_datadword,priority_data,t+16,NULL);
		scheduler.addtask(dis_datadword,priority_data,t+20,NULL);
		scheduler.addtask(dis_datadword,priority_data,t+24,NULL);
		scheduler.addtask(dis_datadword,priority_data,t+28,NULL);
		for(k1=0;k1<peh->objects;k1++)
		{ if((expdir->namerva>=pdata[k1].rva)&&(expdir->namerva<pdata[k1].rva+pdata[k1].phys_size))
		  { expname=&fbuff[expdir->namerva-pdata[k1].rva+pdata[k1].phys_offset];
			 break;
		  }
		}
		t.offs=expdir->namerva+peh->image_base;
		scheduler.addtask(dis_datastring,priority_data,t,NULL);
		numsymbols=expdir->numfunctions;
		chktable=new unsigned char [numsymbols];
		for(j=0;j<numsymbols;j++)chktable[j]=0;
		if(expdir->numnames<numsymbols)numsymbols=expdir->numnames;
		for(k=0;k<peh->objects;k++)
		{ if((expdir->nameaddrrva>=pdata[k].rva)&&(expdir->nameaddrrva<pdata[k].rva+pdata[k].phys_size))
		  { nnaddr=(dword *)&fbuff[expdir->nameaddrrva-pdata[k].rva+pdata[k].phys_offset];
			 break;
		  }
		}
		for(k=0;k<peh->objects;k++)
		{ if((expdir->funcaddrrva>=pdata[k].rva)&&(expdir->funcaddrrva<pdata[k].rva+pdata[k].phys_size))
		  { fnaddr=(dword *)&fbuff[expdir->funcaddrrva-pdata[k].rva+pdata[k].phys_offset];
			 break;
		  }
		}
		for(k=0;k<peh->objects;k++)
		{ if((expdir->ordsaddrrva>=pdata[k].rva)&&(expdir->ordsaddrrva<pdata[k].rva+pdata[k].phys_size))
		  { onaddr=(word *)&fbuff[expdir->ordsaddrrva-pdata[k].rva+pdata[k].phys_offset];
			 break;
		  }
		}
		lef.assign(options.loadaddr.segm,expdir->funcaddrrva+peh->image_base);
		leo.assign(options.loadaddr.segm,expdir->ordsaddrrva+peh->image_base);
		len.assign(options.loadaddr.segm,expdir->nameaddrrva+peh->image_base);
		while(numsymbols)
		{ scheduler.addtask(dis_datadword,priority_data,lef,NULL);
		  scheduler.addtask(dis_dataword,priority_data,leo,NULL);
		  scheduler.addtask(dis_datadword,priority_data,len,NULL);
		  chktable[onaddr[0]]=1;
		  t.assign(options.loadaddr.segm,peh->image_base+fnaddr[onaddr[0]]);
		  scheduler.addtask(dis_export,priority_export,t,(char *)&fbuff[(*nnaddr)+pdata[k].phys_offset-pdata[k].rva]);
		  t.assign(options.loadaddr.segm,(*nnaddr)+peh->image_base);
		  scheduler.addtask(dis_datastring,priority_data,t,NULL);
        // actually not definite code since data can be exported too, eg a debug hook address
        // so uses dis_exportcode which will disassemble if its in a code segment only.
		  t.assign(options.loadaddr.segm,peh->image_base+fnaddr[onaddr[0]]);
		  scheduler.addtask(dis_exportcode,priority_definitecode,t,NULL);
		  numsymbols--;
		  onaddr++;
		  nnaddr++;
		  lef+=4;
		  leo+=2;
		  len+=4;
		}
		if(expdir->numfunctions>expdir->numnames)
		{ for(j=0;j<expdir->numfunctions;j++)
		  { if(!chktable[j])
			 { numtmp=j+expdir->base;
				wsprintf(inum,"%02d",numtmp);
				lstrcpyn(impbuff,(char *)expname,GNAME_MAXLEN-8);
				k=0;
				while((impbuff[k])&&(k<GNAME_MAXLEN-8))
				{ if(impbuff[k]=='.')break;
				  k++;
				}
				strcpy(&impbuff[k],"::ord_");
				strcat(impbuff,inum);
				newimpname=new char[strlen(impbuff)+1];
				strcpy(newimpname,impbuff);
				if(fnaddr[j])
				{ t.assign(options.loadaddr.segm,fnaddr[j]+peh->image_base);
				  scheduler.addtask(dis_ordexport,priority_export,t,newimpname);
				  scheduler.addtask(dis_code,priority_definitecode,t,NULL);
				}
			 }
		  }
		}
		delete chktable;
	 }
	 if((pdata[i].rva==peh->importtable_rva) // import info
		||((peh->importtable_rva>pdata[i].rva)&&(peh->importtable_rva<pdata[i].rva+pdata[i].phys_size)))
	 { impdir=(peimportdirentry *)&fbuff[pdata[i].phys_offset+peh->importtable_rva-pdata[i].rva];
		j=0;
		while(impdir[j].firstthunkrva)
		{ t.assign(options.loadaddr.segm,
			 peh->image_base+peh->importtable_rva+j*sizeof(struct peimportdirentry));
		  scheduler.addtask(dis_datadword,priority_data,t,NULL);
		  scheduler.addtask(dis_datadword,priority_data,t+4,NULL);
		  scheduler.addtask(dis_datadword,priority_data,t+8,NULL);
		  scheduler.addtask(dis_datadword,priority_data,t+12,NULL);
		  scheduler.addtask(dis_datadword,priority_data,t+16,NULL);
		  for(k1=0;k1<peh->objects;k1++)
		  { if((impdir[j].namerva>=pdata[k1].rva)&&(impdir[j].namerva<pdata[k1].rva+pdata[k1].phys_size))
			 { impname=&fbuff[impdir[j].namerva-pdata[k1].rva+pdata[k1].phys_offset];
				break;
			 }
		  }
		  t.assign(options.loadaddr.segm,impdir[j].namerva+peh->image_base);
		  scheduler.addtask(dis_datastring,priority_data,t,NULL);
		  if(!impdir[j].originalthunkrva)thunkrva=impdir[j].firstthunkrva;
		  else thunkrva=impdir[j].originalthunkrva;
		  for(k=0;k<peh->objects;k++)
		  { if((thunkrva>=pdata[k].rva)&&(thunkrva<pdata[k].rva+pdata[k].phys_size))
			 { imphint=(dword *)&fbuff[thunkrva-pdata[k].rva+pdata[k].phys_offset];
				break;
			 }
		  }
		  impaddr=impdir[j].firstthunkrva+peh->image_base;
		  impaddr2=impdir[j].originalthunkrva+peh->image_base;
		  while(*imphint)
		  { if((*imphint)&0x80000000)
			 { numtmp=(*imphint)&0x7fffffff;
				wsprintf(inum,"%02d",numtmp);
				strcpy(impbuff,(char *)impname);
				k=0;
				while(impbuff[k])
				{ if(impbuff[k]=='.')break;
				  k++;
				}
				strcpy(&impbuff[k],"::ord_");
				strcat(impbuff,inum);
				newimpname=new char[strlen(impbuff)+1];
				strcpy(newimpname,impbuff);
				t.assign(options.loadaddr.segm,impaddr);
				scheduler.addtask(dis_ordimport,priority_import,t,newimpname);
			 }
			 else
			 { t.assign(options.loadaddr.segm,impaddr);
				scheduler.addtask(dis_import,priority_import,t,(char *)&fbuff[(*imphint)+2+pdata[k1].phys_offset-pdata[k1].rva]);
			 }
			 t.assign(options.loadaddr.segm,peh->image_base+(*imphint));
			 scheduler.addtask(dis_dataword,priority_data,t,NULL);
			 scheduler.addtask(dis_datastring,priority_data,t+2,NULL);
			 t.assign(options.loadaddr.segm,impaddr);
			 scheduler.addtask(dis_datadword,priority_data,t,NULL);
			 t.assign(options.loadaddr.segm,impaddr2);
			 scheduler.addtask(dis_datadword,priority_data,t,NULL);
			 imphint++;
			 impaddr+=4;
			 impaddr2+=4;
		  }
		  t.assign(options.loadaddr.segm,impaddr);
		  scheduler.addtask(dis_datadword,priority_data,t,NULL);
		  t.assign(options.loadaddr.segm,impaddr2);
		  scheduler.addtask(dis_datadword,priority_data,t,NULL);
		  j++;
		}
		t.assign(options.loadaddr.segm,
		  peh->image_base+peh->importtable_rva+j*sizeof(struct peimportdirentry));
		scheduler.addtask(dis_datadword,priority_data,t,NULL);
		scheduler.addtask(dis_datadword,priority_data,t+4,NULL);
		scheduler.addtask(dis_datadword,priority_data,t+8,NULL);
		scheduler.addtask(dis_datadword,priority_data,t+12,NULL);
		scheduler.addtask(dis_datadword,priority_data,t+16,NULL);
	 }
	 if(pdata[i].rva==peh->tls_rva)peobjdone=TRUE; // tls info
	 if((pdata[i].rva==peh->resourcetable_rva) // resource info
		||((peh->resourcetable_rva>pdata[i].rva)&&(peh->resourcetable_rva<pdata[i].rva+pdata[i].phys_size)))
	 { // RESOURCE_DATA;
		if((pdata[i].phys_size)&&(options.loadresources))
		{ resdir=(perestable *)&fbuff[pdata[i].phys_offset+peh->resourcetable_rva-pdata[i].rva];
		  pdatarva=peh->resourcetable_rva;  // bugfix  build 14
		  rawdata=(byte *)resdir;
		  numitems=resdir->numnames+resdir->numids;
		  rentry=(struct perestableentry *)(resdir+1);
		  while(numitems)
		  { if((rentry->id)&0x80000000)
			 { impname=rawdata+((rentry->id)&0x7fffffff);
				clen=((word *)impname)[0];
				WideCharToMultiByte(CP_ACP,0,(const wchar_t *)(impname+2),clen,impbuff,100,NULL,NULL);
				impbuff[clen]=0;
			 }
			 else
			 { switch(rentry->id)
				{ case 1:
					 strcpy(impbuff,"Cursor");
					 break;
				  case 2:
					 strcpy(impbuff,"Bitmap");
					 break;
				  case 3:
					 strcpy(impbuff,"Icon");
					 break;
				  case 4:
					 strcpy(impbuff,"Menu");
					 break;
				  case 5:
					 strcpy(impbuff,"Dialog");
					 break;
				  case 6:
					 strcpy(impbuff,"String Table");
					 break;
				  case 7:
					 strcpy(impbuff,"Font Directory");
					 break;
				  case 8:
					 strcpy(impbuff,"Font");
					 break;
				  case 9:
					 strcpy(impbuff,"Accelerators");
					 break;
				  case 10:
					 strcpy(impbuff,"Unformatted Resource Data");
					 break;
				  case 11:
					 strcpy(impbuff,"Message Table");
					 break;
				  case 12:
					 strcpy(impbuff,"Group Cursor");
					 break;
				  case 14:
					 strcpy(impbuff,"Group Icon");
					 break;
				  case 16:
					 strcpy(impbuff,"Version Information");
					 break;
				  case 0x2002:
					 strcpy(impbuff,"New Bitmap");
					 break;
				  case 0x2004:
					 strcpy(impbuff,"New Menu");
					 break;
				  case 0x2005:
					 strcpy(impbuff,"New Dialog");
					 break;
				  default:
					 strcpy(impbuff,"User Defined Id:");
					 numtmp=rentry->id&0x7fffffff;
					 wsprintf(inum,"%02lx",numtmp);
					 strcat(impbuff,inum);
					 break;
				}
			 }
			 if(rentry->offset&0x80000000)
			 { subdirsummary(rawdata+((rentry->offset)&0x7fffffff),impbuff,peh->image_base,rentry->id);
			 }
			 else
			 { leafnodesummary(rawdata+((rentry->offset)&0x7fffffff),impbuff,peh->image_base,0);
			 }
			 rentry++;
			 numitems--;
		  }
		}
		if(pdata[i].rva==peh->resourcetable_rva)peobjdone=TRUE;
	 }
	 if(pdata[i].rva==peh->fixuptable_rva) // fixup info
	 { per=(perelocheader *)&fbuff[pdata[i].phys_offset];
		while(per->rva)
		{ rdata=(word *)per+sizeof(perelocheader)/2;
		  numrelocs=(per->len-sizeof(perelocheader))/2;
		  while((numrelocs)&&(rdata[0]))
		  { t.assign(options.loadaddr.segm,((dword)(rdata[0])&0x0fff)+per->rva+peh->image_base);
			 reloc.addreloc(t,RELOC_NONE);
			 rdata++;
			 numrelocs--;
		  }
        per=(perelocheader *)((byte *)(per)+per->len);
		}
		peobjdone=TRUE;
	 }
	 if(pdata[i].rva==peh->debugtable_rva) // debug info
	 { // DEBUG_DATA;
		if((pdata[i].phys_size)&&(options.loaddebug))
		{ sseg.offs=pdata[i].rva+peh->image_base;
		  dta.addseg(sseg,pdata[i].phys_size,&fbuff[pdata[i].phys_offset],debugdata,NULL);
		}
		peobjdone=TRUE;
	 }
	 if((pdata[i].obj_flags&0x40)&&(!(pdata[i].obj_flags&0x20))&&(!peobjdone))
	 { // INIT_DATA;
		if((pdata[i].phys_size)&&(options.loaddata))
		{ sseg.offs=pdata[i].rva+peh->image_base;
		  dta.addseg(sseg,pdata[i].phys_size,&fbuff[pdata[i].phys_offset],data32,NULL);
		}
		if((pdata[i].virt_size>pdata[i].phys_size)&&(options.loaddata))
		{ sseg.offs=pdata[i].rva+peh->image_base+pdata[i].phys_size;
		  uinit=new byte[pdata[i].virt_size-pdata[i].phys_size];
		  for(j=0;j<pdata[i].virt_size-pdata[i].phys_size;j++) uinit[j]=0;
		  dta.addseg(sseg,pdata[i].virt_size-pdata[i].phys_size,uinit,uninitdata,NULL);
		}
	 }
	 else if((pdata[i].obj_flags&0x80)&&(!peobjdone))
	 { // UNINIT_DATA;
		if(options.loaddata)
		{ sseg.offs=pdata[i].rva+peh->image_base;
		  uinit=new byte[pdata[i].virt_size];
		  for(j=0;j<pdata[i].virt_size;j++) uinit[j]=0;
		  dta.addseg(sseg,pdata[i].virt_size,uinit,uninitdata,NULL);
		}
	 }
	 else if(!peobjdone)
	 { // CODE_DATA;
		if(pdata[i].phys_size)
		{ sseg.offs=pdata[i].rva+peh->image_base;
		  dta.addseg(sseg,pdata[i].phys_size,&fbuff[pdata[i].phys_offset],code32,NULL);
		  dta.possibleentrycode(sseg);
		}
	 }
    // default start addr=first seg, in the case of no entry point
    // (eg some dll files). added version 2.20
    if(!start_addr.segm)
    { start_addr.assign(options.loadaddr.segm,pdata[i].rva+peh->image_base);
      dio.setcuraddr(start_addr);
    }
  }
  start_addr.assign(options.loadaddr.segm,peh->entrypoint_rva+peh->image_base);
  dio.setcuraddr(start_addr);
  scheduler.addtask(dis_code,priority_definitecode,start_addr,NULL);
  scheduler.addtask(nameloc,priority_nameloc,start_addr,"start");
  scheduler.addtask(windowupdate,priority_window,nlptr,NULL);
}

int mzcmp(const void *a1,const void *a2)
{ if(((word *)a1)[0]<((word *)a2)[0]) return -1;
  if(((word *)a1)[0]>((word *)a2)[0]) return 1;
  return 0;
}

void fileloader::readmzfile(dword fsize)
{ mzheader *mzh;
  dword fs;
  byte *roffs;
  byte *poffs;
  word nrelocs,nr;
  word *ritem;
  word *rchange;
  word *rtable;
  lptr sseg,tseg;  // current segment limits
  lptr ip;
  dword saddr,taddr,ipaddr;
  options.loadaddr.offs=0;
  mzh=(mzheader *)fbuff;
  fs=(mzh->numpages-1)*512L+mzh->numbytes;
  if(fs>fsize)fs=fsize;
  fs-=mzh->headersize*16L;
  roffs=fbuff+mzh->relocoffs;
  poffs=fbuff+mzh->headersize*16L;
  nrelocs=mzh->numrelocs;
  if(nrelocs)rtable=new word[nrelocs];
  if(!nrelocs)
  { MessageBox(mainwindow,"Relocation table is empty\nThis file is probably packed"
	 "\nBorg will not be able to create the segments properly","Borg Warning",MB_OK|MB_ICONEXCLAMATION);
  }
  while(nrelocs)
  { ritem=(word *)(&roffs[(mzh->numrelocs-nrelocs)*4L]);
	 if((ritem[0])||(ritem[1]))
	 { rchange=(word *)(&poffs[ritem[0]+ritem[1]*16L]);
		rchange[0]+=(word)options.loadaddr.segm;
		rtable[mzh->numrelocs-nrelocs]=rchange[0];
	 }
	 else rtable[mzh->numrelocs-nrelocs]=options.loadaddr.segm;
	 nrelocs--;
  }
  qsort(rtable,mzh->numrelocs,2,mzcmp);
  sseg=options.loadaddr;
  options.dseg=options.loadaddr.segm;   // need to look for better value for dseg later
  ip=options.loadaddr;
  ipaddr=(((word)mzh->csip)+((word)(mzh->csip/0x10000L)+options.loadaddr.segm)*16L+options.loadaddr.offs)&0xfffff;
  for(nrelocs=0;nrelocs<mzh->numrelocs;nrelocs++)
  { if(rtable[nrelocs]!=sseg.segm)
	 { tseg.assign(rtable[nrelocs],0);
		saddr=sseg.segm*16L+sseg.offs;
		taddr=tseg.segm*16L+tseg.offs;
		if((ipaddr>=saddr)&&(ipaddr<taddr))
		{ ip.assign(sseg.segm,ipaddr-ip.segm*16L);
		}
		if((saddr<taddr)&&(sseg.segm>=options.loadaddr.segm))
		{ dta.addseg(sseg,taddr-saddr,fbuff+mzh->headersize*16
			 +(sseg.segm-options.loadaddr.segm)*16L,code16,NULL);
		  dta.possibleentrycode(sseg);
		  // go through the reloc items, check if any lie in the seg
		  // if they do - add to reloc entries.
		  for(nr=0;nr<mzh->numrelocs;nr++)
		  { ritem=(word *)(&roffs[(mzh->numrelocs-nr)*4L]);
			 if((ritem[0])||(ritem[1]))
			 { rchange=(word *)(&poffs[ritem[0]+ritem[1]*16L]);
				if(((byte *)rchange>=fbuff+mzh->headersize*16+(sseg.segm-options.loadaddr.segm)*16L)
				  &&((byte *)rchange<fbuff+mzh->headersize*16+(sseg.segm-options.loadaddr.segm)*16L+taddr-saddr))
				  reloc.addreloc(sseg+(dword)((byte *)rchange-
					 (fbuff+mzh->headersize*16+(sseg.segm-options.loadaddr.segm)*16L)),RELOC_SEG);
			 }
		  }
		  sseg.segm=tseg.segm;
		}
	 }
  }
  if((sseg.segm-options.loadaddr.segm)*16UL<fs)
  { saddr=sseg.segm*16L+sseg.offs;
	 if(ipaddr>=saddr)
	 { ip.assign(sseg.segm,ipaddr-ip.segm*16L);
	 }
	 dta.addseg(sseg,fs-(sseg.segm-options.loadaddr.segm)*16L,
		fbuff+mzh->headersize*16+(sseg.segm-options.loadaddr.segm)*16L,code16,NULL);
	 for(nr=0;nr<mzh->numrelocs;nr++)
	 { ritem=(word *)(&roffs[(mzh->numrelocs-nr)*4L]);
		if((ritem[0])||(ritem[1]))
		{ rchange=(word *)(&poffs[ritem[0]+ritem[1]*16L]);
		  if(((byte *)rchange>=fbuff+mzh->headersize*16+(sseg.segm-options.loadaddr.segm)*16L)
			 &&((byte *)rchange<fbuff+mzh->headersize*16+fs))
			 reloc.addreloc(sseg+(dword)((byte *)rchange-
				(fbuff+mzh->headersize*16+(sseg.segm-options.loadaddr.segm)*16L)),RELOC_SEG);
		}
	 }
	 dta.possibleentrycode(sseg);
  }
  // need to search for dseg better value.
  options.mode16=TRUE;
  options.mode32=FALSE;
  dio.setcuraddr(ip);
  scheduler.addtask(dis_code,priority_definitecode,ip,NULL);
  scheduler.addtask(nameloc,priority_nameloc,ip,"start");
  scheduler.addtask(windowupdate,priority_window,nlptr,NULL);
  if(mzh->numrelocs)delete rtable;
}

void fileloader::readlefile(void)
{
}

void fileloader::readnefile(dword neoffs)
{ neheader *neh;
  byte *nestart,*importnames,*modoffsets;
  word nsegs;
  nesegtable *nesegt;
  int i,j,k;
  lptr sseg,iaddr,inum;
  dword slen,soffs;
  word numrelocs;
  word *stable;
  nesegtablereloc *reloctable;
  char iname[80];
  options.dseg=options.loadaddr.segm;
  sseg.assign(options.loadaddr.segm,0);
  nestart=&fbuff[neoffs];
  neh=(neheader *)nestart;
  if(!neh->csip)
  { MessageBox(mainwindow,"No entry point to executable - assume that Executable"
		"is a resource only\nUse a resource viewer","Borg Warning",MB_OK|MB_ICONEXCLAMATION);
	 CloseHandle(efile);
	 efile=INVALID_HANDLE_VALUE;
	 exetype=0;
	 return;
  }
  nsegs=neh->numsegs;
  stable=new word[nsegs];
  nesegt=(nesegtable *)(nestart+neh->offs_segments);
  importnames=(byte *)(nestart+neh->offs_imports);
  modoffsets=(byte *)(nestart+neh->offs_module);
  // add segments
  for(i=0;i<nsegs;i++)
  { slen=nesegt[i].seglength;
	 if(!slen) slen=0x10000;
	 soffs=nesegt[i].sectoroffs;
    // added uninit data borg 2.20
	 if(soffs)
	 { if(nesegt[i].segflags&1)
		{ dta.addseg(sseg,slen,&fbuff[soffs<<(dword)neh->shiftcount],data16,NULL);
		  options.dseg=sseg.segm;
		}
		else
		{ dta.addseg(sseg,slen,&fbuff[soffs<<(dword)neh->shiftcount],code16,NULL);
		  dta.possibleentrycode(sseg);
		}
	 }
	 else dta.addseg(sseg,slen,NULL,uninitdata,NULL); // uninit data
	 stable[i]=sseg.segm;
	 sseg.segm+=(word)((slen+15)/16L);
  }
  // relocate data
  // approach to imports:
  // - start with a new segment 0xffff, to be created later, size 0.
  // - for each import, if its an ordinal add it at the current addr in the import segment,
  // - and increase the size of the segment, name it = name+ordinal num
  // - otherwise name=importnames table name, check for if it is already an import
  // - and only add if necessary.
  // - finally create the segment at the end.
  iaddr.segm=0xffff;
  inum.segm=0xffff;
  iaddr.offs=0;
  for(i=0;i<nsegs;i++)
  { slen=nesegt[i].seglength;
	 if(!slen) slen=0x10000;
	 soffs=nesegt[i].sectoroffs;
	 if((nesegt[i].segflags&100)&&(soffs))
	 { // reloc data present
		numrelocs=((word *)&fbuff[(soffs<<(dword)neh->shiftcount)+slen])[0];
		reloctable=(nesegtablereloc *)&fbuff[(soffs<<(dword)neh->shiftcount)+slen+2];
		for(j=0;j<numrelocs;j++)
		{ switch(reloctable[j].reloctype)
		  { case 0:      //low byte
				break;
			 case 2:      //16bit selector
				if((!reloctable[j].relocsort)&&(reloctable[j].index<0xff))
				{ ((word *)&fbuff[(soffs<<(dword)neh->shiftcount)+reloctable[j].segm_offs])[0]=stable[reloctable[j].index-1];
				}
				break;
			 case 3:      //32bit pointer
				if((!reloctable[j].relocsort)&&(reloctable[j].index<0xff))
				{ ((word *)&fbuff[(soffs<<(dword)neh->shiftcount)+reloctable[j].segm_offs+2])[0]=stable[reloctable[j].index-1];
				  ((word *)&fbuff[(soffs<<(dword)neh->shiftcount)+reloctable[j].segm_offs])[0]=reloctable[j].indexoffs;
				}
            else if(reloctable[j].relocsort==2) // import by name
            { for(k=0;(k<importnames[reloctable[j].indexoffs])&&(k<79);k++)
              { iname[k]=importnames[reloctable[j].indexoffs+1+k];
                iname[k+1]=0;
              }
              inum.offs=import.importaddr(iname);
              if(!inum.offs)
              { iaddr++;
                import.addname(iaddr,iname);
                inum.offs=iaddr.offs;
              }
              ((word *)&fbuff[(soffs<<(dword)neh->shiftcount)+reloctable[j].segm_offs+2])[0]=inum.segm;
				  ((word *)&fbuff[(soffs<<(dword)neh->shiftcount)+reloctable[j].segm_offs])[0]=(word)inum.offs;
            }
				break;
			 case 5:      //16bit offset
				if((!reloctable[j].relocsort)&&(reloctable[j].index<0xff))
				{ ((word *)&fbuff[(soffs<<(dword)neh->shiftcount)+reloctable[j].segm_offs])[0]=reloctable[j].indexoffs;
				}
				break;
			 case 11:     //48bit pointer
				if((!reloctable[j].relocsort)&&(reloctable[j].index<0xff))
				{ ((word *)&fbuff[(soffs<<(dword)neh->shiftcount)+reloctable[j].segm_offs+4])[0]=stable[reloctable[j].index-1];
				  ((dword *)&fbuff[(soffs<<(dword)neh->shiftcount)+reloctable[j].segm_offs])[0]=reloctable[j].indexoffs;
				}
				break;
			 case 13:     //32bit offset
				if((!reloctable[j].relocsort)&&(reloctable[j].index<0xff))
				{ ((dword *)&fbuff[(soffs<<(dword)neh->shiftcount)+reloctable[j].segm_offs])[0]=reloctable[j].indexoffs;
				}
				break;
			 default:
				break;
		  }
		}
	 }
  }
  inum.offs=0;
  if(iaddr.offs)
    dta.addseg(inum,iaddr.offs+1,NULL,uninitdata,"Import Segment <Borg>");
  // set up disassembly
  options.loadaddr.assign(stable[(neh->csip>>16)-1],neh->csip&0xffff);
  dio.setcuraddr(options.loadaddr);
  scheduler.addtask(dis_code,priority_definitecode,options.loadaddr,NULL);
  scheduler.addtask(nameloc,priority_nameloc,options.loadaddr,"start");
  scheduler.addtask(windowupdate,priority_window,nlptr,NULL);
  delete stable;
}

void fileloader::reados2file(void)
{
}

//marks data as a binary file.
// sets up entry point and
// data objects (jusr one here)
void fileloader::readbinfile(dword fsize)
{ options.mode32=!options.mode16;
  options.dseg=options.loadaddr.segm;
  dta.addseg(options.loadaddr,fsize,fbuff,options.mode32 ? code32:code16,NULL);
  dta.possibleentrycode(options.loadaddr);
  dio.setcuraddr(options.loadaddr);
  scheduler.addtask(dis_code,priority_definitecode,options.loadaddr,NULL);
  scheduler.addtask(nameloc,priority_nameloc,options.loadaddr,"start");
  scheduler.addtask(windowupdate,priority_window,nlptr,NULL);
}

int fileloader::getexetype(void)
{ return exetype;
}

void fileloader::setexetype(int etype)
{ exetype=etype;
}
#ifdef __BORLANDC__
#pragma warn -par
#endif
//dialog proc for verifying type and
// initial options
BOOL FAR PASCAL checktypebox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  char segtext[20],offstext[20];
  static int exetype;
  int i;
  dword segd;
  switch(message)
  { case WM_INITDIALOG:
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		exetype=floader.getexetype();
		i=0;
		options.loadaddr.segm=0x1000;
		options.loadaddr.offs=0x00;
		switch(exetype)
		{ case NE_EXE:
			 SetDlgItemText(hdwnd,IDC_DEFAULTBUTTON,"NE Executable");
			 CheckDlgButton(hdwnd,IDC_DEFAULTBUTTON,TRUE);
			 options.processor=PROC_80486;
			 options.mode16=TRUE;
			 break;
		  case COM_EXE:
			 SetDlgItemText(hdwnd,IDC_DEFAULTBUTTON,"COM File");
			 CheckDlgButton(hdwnd,IDC_DEFAULTBUTTON,TRUE);
			 options.processor=PROC_80386;
			 options.mode16=TRUE;
			 options.loadaddr.offs=0x100;
			 break;
		  case SYS_EXE:
			 SetDlgItemText(hdwnd,IDC_DEFAULTBUTTON,"SYS File");
			 CheckDlgButton(hdwnd,IDC_DEFAULTBUTTON,TRUE);
			 options.processor=PROC_80386;
			 options.mode16=TRUE;
			 options.loadaddr.offs=0x00;
			 break;
		  case PE_EXE:
			 SetDlgItemText(hdwnd,IDC_DEFAULTBUTTON,"PE Executable");
			 CheckDlgButton(hdwnd,IDC_DEFAULTBUTTON,TRUE);
			 options.processor=PROC_PENTIUM;
			 options.mode16=FALSE;
			 break;
		  case OS2_EXE:
			 SetDlgItemText(hdwnd,IDC_DEFAULTBUTTON,"OS2 Executable");
			 CheckDlgButton(hdwnd,IDC_DEFAULTBUTTON,TRUE);
			 options.processor=PROC_PENTIUM;
			 options.mode16=FALSE;
			 break;
		  case LE_EXE:
			 SetDlgItemText(hdwnd,IDC_DEFAULTBUTTON,"LE Executable");
			 CheckDlgButton(hdwnd,IDC_DEFAULTBUTTON,TRUE);
			 options.processor=PROC_80486;
			 options.mode16=FALSE;
			 break;
		  case MZ_EXE:
			 SetDlgItemText(hdwnd,IDC_DEFAULTBUTTON,"COM File");
			 CheckDlgButton(hdwnd,IDC_DOSBUTTON,TRUE);
			 options.processor=PROC_80386;
			 options.mode16=TRUE;
			 break;
		  default:
		  case BIN_EXE:
			 SetDlgItemText(hdwnd,IDC_DEFAULTBUTTON,"COM File");
			 CheckDlgButton(hdwnd,IDC_BINBUTTON,TRUE);
			 options.processor=PROC_8086;
			 options.mode16=TRUE;
			 break;
		}
		options.mode32=!options.mode16;
		CheckDlgButton(hdwnd,load_debug,options.loaddebug);
		CheckDlgButton(hdwnd,demangle_names,options.demangle);
		CheckDlgButton(hdwnd,IDC_16DASM,options.mode16);
		CheckDlgButton(hdwnd,IDC_32DASM,options.mode32);
		CheckDlgButton(hdwnd,IDC_LOADDATA,options.loaddata);
		CheckDlgButton(hdwnd,IDC_LOADRESOURCES,options.loadresources);
		while(procnames[i].num)
		{ SendDlgItemMessage(hdwnd,IDC_LISTBOX1,LB_ADDSTRING,0,(LPARAM) (LPCTSTR)procnames[i].name);
		  if(options.processor==procnames[i].num)
			 SendDlgItemMessage(hdwnd,IDC_LISTBOX1,LB_SETCURSEL,i,0);
		  i++;
		}
		segd=options.loadaddr.segm;
		wsprintf(segtext,"%x",segd);
		wsprintf(offstext,"%lx",options.loadaddr.offs);
		SendDlgItemMessage(hdwnd,IDC_SEGEDIT,WM_SETTEXT,0,(LPARAM)segtext);
		SendDlgItemMessage(hdwnd,IDC_OFFSEDIT,WM_SETTEXT,0,(LPARAM)offstext);
		return TRUE;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORDLG:
	 case WM_CTLCOLORBTN:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
	 case WM_COMMAND:
		switch(LOWORD(wParam))
		{ case IDOK:
			 if(!IsDlgButtonChecked(hdwnd,IDC_DEFAULTBUTTON))
			 { if(IsDlgButtonChecked(hdwnd,IDC_DOSBUTTON)) floader.setexetype(MZ_EXE);
				else floader.setexetype(BIN_EXE);
			 }
			 else if((exetype==BIN_EXE)||(exetype==MZ_EXE)) floader.setexetype(COM_EXE);
			 options.processor=procnames[SendDlgItemMessage(hdwnd,IDC_LISTBOX1,LB_GETCURSEL,0,0)].num;
			 EndDialog(hdwnd,NULL);
			 return TRUE;
		  case IDC_SEGEDIT:
			 if(HIWORD(wParam)==EN_CHANGE)
			 { SendDlgItemMessage(hdwnd,IDC_SEGEDIT,WM_GETTEXT,(WPARAM)18,(LPARAM)segtext);
				sscanf(segtext,"%x",&options.loadaddr.segm);
			 }
			 return TRUE;
		  case IDC_OFFSEDIT:
			 if(HIWORD(wParam)==EN_CHANGE)
			 { SendDlgItemMessage(hdwnd,IDC_OFFSEDIT,WM_GETTEXT,(WPARAM)18,(LPARAM)offstext);
				sscanf(offstext,"%lx",&options.loadaddr.offs);
			 }
			 return TRUE;
		  case IDC_HELPBUTTON1:
			 DialogBox(hInst,MAKEINTRESOURCE(HELPDIALOG_1),hdwnd,(DLGPROC)helpbox1);
			 return TRUE;
		  case more_options:
			 DialogBox(hInst,MAKEINTRESOURCE(Advanced_Options),hdwnd,(DLGPROC)moreoptions);
			 return TRUE;
		  case load_debug:
			 options.loaddebug=!options.loaddebug;
			 CheckDlgButton(hdwnd,load_debug,options.loaddebug);
			 return TRUE;
		  case demangle_names:
			 options.demangle=!options.demangle;
			 CheckDlgButton(hdwnd,demangle_names,options.demangle);
			 return TRUE;
		  case IDC_16DASM:
			 options.mode16=!options.mode16;
			 CheckDlgButton(hdwnd,IDC_16DASM,options.mode16);
			 return TRUE;
		  case IDC_32DASM:
			 options.mode32=!options.mode32;
			 CheckDlgButton(hdwnd,IDC_32DASM,options.mode32);
			 return TRUE;
		  case IDC_LOADDATA:
			 options.loaddata=!options.loaddata;
			 CheckDlgButton(hdwnd,IDC_LOADDATA,options.loaddata);
			 return TRUE;
		  case IDC_LOADRESOURCES:
			 options.loadresources=!options.loadresources;
			 CheckDlgButton(hdwnd,IDC_LOADRESOURCES,options.loadresources);
			 return TRUE;
		}
  }
  return FALSE;
}

BOOL FAR PASCAL helpbox1(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  switch(message)
  { case WM_COMMAND:
		{	switch(wParam)
		  { case IDOK:
				EndDialog(hdwnd,NULL);
				return TRUE;
			 default:
				break;
		  }
		}
		break;
	 case WM_INITDIALOG:
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		return 0;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORDLG:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
	 default:
		break;
  }
  return FALSE;
}
#ifdef __BORLANDC__
#pragma warn +par
#endif

void fileloader::subdirsummary(byte *data,char *impname,dword image_base,dword rtype)
{ struct perestable *resdir;
  struct perestableentry *rentry;
  unsigned char *name;
  char nbuff[100],nbuff2[100],inum[10];
  int clen;
  dword numtmp;
  unsigned long numitems;
  resdir=(struct perestable *)data;
  numitems=resdir->numnames+resdir->numids;
  rentry=(struct perestableentry *)(resdir+1);
  while(numitems)
  { if(rentry->id&0x80000000)
	 { name=rawdata+((rentry->id)&0x7fffffff);
		clen=((short int *)name)[0];
		WideCharToMultiByte(CP_ACP,0,(const wchar_t *)(name+2),clen,nbuff,100,NULL,NULL);
		nbuff[clen]=0;
		if(impname!=NULL)
		{ strcpy(nbuff2,nbuff);
		  strcpy(nbuff,impname);
		  strcat(nbuff," ");
		  strcat(nbuff,nbuff2);
		}
	 }
	 else
	 { numtmp=rentry->id&0x7fffffff;
		wsprintf(inum,"%02lx",numtmp);
		strcpy(nbuff,impname);
		strcat(nbuff," Id:");
		strcat(nbuff,inum);
	 }
	 if(rentry->offset&0x80000000) leaf2summary(rawdata+((rentry->offset)&0x7fffffff),nbuff,image_base,rtype);
	 else leafnodesummary(rawdata+((rentry->offset)&0x7fffffff),nbuff,image_base,rtype);
	 rentry++;
	 numitems--;
  }
}

void fileloader::leaf2summary(byte *data,char *name,dword image_base,dword rtype)
{ struct perestable *resdir;
  struct perestableentry *rentry;
  unsigned long numitems;
  resdir=(struct perestable *)data;
  numitems=resdir->numnames+resdir->numids;
  rentry=(struct perestableentry *)(resdir+1);
  while(numitems)
  { leafnodesummary(rawdata+((rentry->offset)&0x7fffffff),name,image_base,rtype);
	 rentry++;
	 numitems--;
  }
}

void fileloader::leafnodesummary(byte *data,char *resname,dword image_base,dword rtype)
{ struct peleafnode *leaf;
  char *rname;
  lptr t;
  leaf=(struct peleafnode *)data;
  t.assign(options.loadaddr.segm,leaf->datarva+image_base);
  // bugfix to third arg - build 14
  dta.addseg(t,leaf->size,&rawdata[leaf->datarva-pdatarva],resourcedata,resname);
  switch(rtype)
  { case 5: // dialog
      rname=new char[strlen(resname)+1];
      strcpy(rname,resname);
      scheduler.addtask(dis_dialog,priority_data,t,rname);
      break;
    case 6: // stringtable
      rname=new char[strlen(resname)+1];
      strcpy(rname,resname);
      scheduler.addtask(dis_stringtable,priority_data,t,rname);
      break;
    default:
      break;
  }
}

#ifdef __BORLANDC__
#pragma warn -par
#endif
BOOL FAR PASCAL moreoptions(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  switch(message)
  { case WM_COMMAND:
		{	switch(wParam)
		  { case IDOK:
				options.codedetect=0;
				if(IsDlgButtonChecked(hdwnd,advanced_pushbp))options.codedetect|=CD_PUSHBP;
				if(IsDlgButtonChecked(hdwnd,advanced_aggressive))options.codedetect|=CD_AGGRESSIVE;
				if(IsDlgButtonChecked(hdwnd,advanced_enter))options.codedetect|=CD_ENTER;
				if(IsDlgButtonChecked(hdwnd,advanced_movbx))options.codedetect|=CD_MOVBX;
				if(IsDlgButtonChecked(hdwnd,advanced_moveax))options.codedetect|=CD_MOVEAX;
				if(IsDlgButtonChecked(hdwnd,advanced_eaxfromesp))options.codedetect|=CD_EAXFROMESP;
				EndDialog(hdwnd,NULL);
				return TRUE;
			 default:
				break;
		  }
		}
		break;
	 case WM_INITDIALOG:
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		CheckDlgButton(hdwnd,advanced_pushbp,options.codedetect&CD_PUSHBP);
		CheckDlgButton(hdwnd,advanced_aggressive,options.codedetect&CD_AGGRESSIVE);
		CheckDlgButton(hdwnd,advanced_enter,options.codedetect&CD_ENTER);
		CheckDlgButton(hdwnd,advanced_movbx,options.codedetect&CD_MOVBX);
		CheckDlgButton(hdwnd,advanced_moveax,options.codedetect&CD_MOVEAX);
		CheckDlgButton(hdwnd,advanced_eaxfromesp,options.codedetect&CD_EAXFROMESP);
		return 0;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORBTN:
	 case WM_CTLCOLORDLG:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
	 default:
		break;
  }
  return FALSE;
}
#ifdef __BORLANDC__
#pragma warn +par
#endif

void fileloader::savedb(char *fname,char *exename)
{ savefile sf;
  dword flen;
  dword bver;
  HWND sbox;
  // open file
  sbox=CreateDialog(hInst,MAKEINTRESOURCE(save_box),mainwindow,(DLGPROC)savemessbox);
  if(!sf.sopen(fname,GENERIC_WRITE,1,CREATE_ALWAYS,0))
  { DestroyWindow(sbox);
	 return;
  }
  // save header to identify as a database file
  if(!sf.swrite("BORG",4))
  { DestroyWindow(sbox);
	 MessageBox(mainwindow,"Header Info[1]:File write failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return;
  }
  // save BORG_VERSION
  bver=BORG_VER;
  if(!sf.swrite(&bver,sizeof(bver)))
  { DestroyWindow(sbox);
	 MessageBox(mainwindow,"Header Info[2]:File write failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return;
  }
  // save filename of exe file.
  flen=strlen(exename)+1;
  if(!sf.swrite(&flen,sizeof(dword)))
  { DestroyWindow(sbox);
	 MessageBox(mainwindow,"Header Info[3]:File write failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return;
  }
  if(!sf.swrite(exename,flen))
  { DestroyWindow(sbox);
	 MessageBox(mainwindow,"Header Info[4]:File write failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return;
  }
  // save options.
  if(!sf.swrite(&options,sizeof(globaloptions)))
  { DestroyWindow(sbox);
	 MessageBox(mainwindow,"Options:File write failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return;
  }
  if(!sf.swrite(&exetype,sizeof(int)))
  { DestroyWindow(sbox);
	 MessageBox(mainwindow,"Exetype:File write failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return;
  }
  // save segment info
  if(!dta.savedb(&sf,fbuff))
  { DestroyWindow(sbox);
	 MessageBox(mainwindow,"Segments:File write failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return;
  }
  // save import info
  if(!import.savedb(&sf))
  { DestroyWindow(sbox);
	 MessageBox(mainwindow,"Imports:File write failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return;
  }
  // save export info
  if(!expt.savedb(&sf))
  { DestroyWindow(sbox);
	 MessageBox(mainwindow,"Exports:File write failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return;
  }
  // save names
  if(!name.savedb(&sf))
  { DestroyWindow(sbox);
	 MessageBox(mainwindow,"Names:File write failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return;
  }
  // save relocs
  if(!reloc.savedb(&sf))
  { DestroyWindow(sbox);
	 MessageBox(mainwindow,"Relocs:File write failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return;
  }
  // save xrefs
  if(!xrefs.savedb(&sf))
  { DestroyWindow(sbox);
	 MessageBox(mainwindow,"Xrefs:File write failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return;
  }
  // save asm database
  if(!dio.savedb(&sf,fbuff))
  { DestroyWindow(sbox);
	 MessageBox(mainwindow,"Database:File write failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return;
  }
  // save decrypter list
  if(!decrypter.savedb(&sf))
  { DestroyWindow(sbox);
    MessageBox(mainwindow,"Decryptors:File write failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
    return;
  }
  sf.flushfilewrite();
  // close file
  DestroyWindow(sbox);
}

BOOL fileloader::loaddb(char *fname,char *exename)
{ savefile sf;
  char tbuff[20];
  dword num;
  dword flen,fsize;
  dword bver;
  HWND lbox;
  // open file
  lbox=CreateDialog(hInst,MAKEINTRESOURCE(load_box),mainwindow,(DLGPROC)loadmessbox);
  if(!sf.sopen(fname,GENERIC_READ,1,OPEN_EXISTING,0))
  { DestroyWindow(lbox);
	 return FALSE;
  }
  // load header check its a database file
  tbuff[4]=0;
  if(!sf.sread(tbuff,4,&num))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"File read failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return FALSE;
  }
  if(strcmp(tbuff,"BORG"))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"Not A Borg Database File",fname,MB_OK|MB_ICONEXCLAMATION);
	 return FALSE;
  }
  // read BORG_VERSION
  if(!sf.sread(&bver,sizeof(bver),&num))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"File read failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return FALSE;
  }
  if(bver>BORG_VER)
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"Savefile from a later version [or very early version]!",fname,MB_OK|MB_ICONEXCLAMATION);
	 return FALSE;
  }
  if(bver<BORG_VER)
  { MessageBox(mainwindow,"Warning:earlier version savefile [will attempt load]",fname,MB_OK|MB_ICONEXCLAMATION);
  }
  // load filename of exe file.
  flen=strlen(exename)+1;
  if(!sf.sread(&flen,sizeof(dword),&num))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"File read failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return FALSE;
  }
  if(!sf.sread(exename,flen,&num))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"File read failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return FALSE;
  }
  // load options.
  if(!sf.sread(&options,sizeof(globaloptions),&num))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"File read failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return FALSE;
  }
  if(!sf.sread(&exetype,sizeof(int),&num))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"File read failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 return FALSE;
  }
  // load exe file.
  // - any errors from here on will now be fatal, and Borg will need to exit
  efile=CreateFile(exename,GENERIC_READ|GENERIC_WRITE,1,NULL,OPEN_EXISTING,0,NULL);
  if(efile==INVALID_HANDLE_VALUE)
  { efile=CreateFile(fname,GENERIC_READ,1,NULL,OPEN_EXISTING,0,NULL);
    if(efile==INVALID_HANDLE_VALUE)
    { DestroyWindow(lbox);
	   MessageBox(mainwindow,"File open failed ?",exename,MB_OK|MB_ICONEXCLAMATION);
	   return FALSE;
    }
    options.readonly=TRUE;
    MessageBox(mainwindow,"Couldn't obtain write permission to file\nFile opened readonly - will not be able to apply any patches",
      "Borg Message",MB_OK);
  }
  if(GetFileType(efile)!=FILE_TYPE_DISK)
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"File open failed ?",exename,MB_OK|MB_ICONEXCLAMATION);
	 CloseHandle(efile);
	 return FALSE;
  }
  fsize=GetFileSize(efile,NULL);
  fbuff=new byte[fsize];
  SetFilePointer(efile,0x00,NULL,FILE_BEGIN);
  if(!ReadFile(efile,fbuff,fsize,&num,NULL))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"File read failed ?",exename,MB_OK|MB_ICONEXCLAMATION);
	 CloseHandle(efile);
	 delete fbuff;
	 return FALSE;
  }
  // load segment info
  if(!dta.loaddb(&sf,fbuff))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"Fatal Error\nSegments:File read failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 DestroyWindow(mainwindow);
	 return FALSE;
  }
  // load import info
  if(!import.loaddb(&sf))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"Fatal Error\nImports:File read failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 DestroyWindow(mainwindow);
	 return FALSE;
  }
  // load export info
  if(!expt.loaddb(&sf))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"Fatal Error\nExports:File read failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 DestroyWindow(mainwindow);
	 return FALSE;
  }
  // load names
  if(!name.loaddb(&sf))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"Fatal Error\nNames:File read failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 DestroyWindow(mainwindow);
	 return FALSE;
  }
  // load relocs
  if(!reloc.loaddb(&sf))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"Fatal Error\nRelocs:File read failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 DestroyWindow(mainwindow);
	 return FALSE;
  }
  // load xrefs
  if(!xrefs.loaddb(&sf))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"Fatal Error\nXrefs:File read failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 DestroyWindow(mainwindow);
	 return FALSE;
  }
  // load asm database
  if(!dio.loaddb(&sf,fbuff))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"Fatal Error\nDatabase:File read failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 DestroyWindow(mainwindow);
	 return FALSE;
  }
  if(!reloc.relocfile())
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"Fatal Error\nRelocating File",fname,MB_OK|MB_ICONEXCLAMATION);
	 DestroyWindow(mainwindow);
	 return FALSE;
  }
  if(!decrypter.loaddb(&sf))
  { DestroyWindow(lbox);
	 MessageBox(mainwindow,"Fatal Error\nDecryptors:File read failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
	 DestroyWindow(mainwindow);
	 return FALSE;
  }
  DestroyWindow(lbox);
  return TRUE;
}

#ifdef __BORLANDC__
#pragma warn -par
#endif
BOOL FAR PASCAL savemessbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  RECT drect;
  switch(message)
  { case WM_INITDIALOG:
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		GetWindowRect(hdwnd,&drect);
		MoveWindow(hdwnd,((mainwnd.right+mainwnd.left)-(drect.right-drect.left))/2,
		  ((mainwnd.bottom+mainwnd.top)-(drect.bottom-drect.top))/2,drect.right-drect.left,drect.bottom-drect.top,TRUE);
		return 0;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORDLG:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
  }
  return FALSE;
}
#ifdef __BORLANDC__
#pragma warn +par
#endif

#ifdef __BORLANDC__
#pragma warn -par
#endif
BOOL FAR PASCAL loadmessbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  RECT drect;
  switch(message)
  { case WM_INITDIALOG:
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		GetWindowRect(hdwnd,&drect);
		MoveWindow(hdwnd,((mainwnd.right+mainwnd.left)-(drect.right-drect.left))/2,
		  ((mainwnd.bottom+mainwnd.top)-(drect.bottom-drect.top))/2,drect.right-drect.left,drect.bottom-drect.top,TRUE);
		return 0;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORDLG:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
  }
  return FALSE;
}
#ifdef __BORLANDC__
#pragma warn +par
#endif
