/************************************************************************
*                 imports.cpp                                           *
* This is the imports class extension of the generic names class gname  *
* Imports were implemented as a separate class to normal names because  *
* this allowed a slightly different treatment of them                   *
* Also exports and imports have been given different dialogs, and can   *
* be treated differently in disassembly and display. I suppose this     *
* could have been implemented as a property of the names class but I    *
* decided early on to separate the classes out                          *
************************************************************************/

#include <windows.h>

#include "menuids.rh"
#include "imports.h"
#include "disasm.h"
#include "schedule.h"
#include "mainwind.h"
#include "names.h"
#include "data.h"
#include "debug.h"
#include "dasm.h"

/************************************************************************
* forward declarations                                                  *
************************************************************************/
BOOL FAR PASCAL importsbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);

/************************************************************************
* additional constructor - currently null                               *
************************************************************************/
imports::imports()
{
}

/************************************************************************
* additional destructor - currently null                                *
************************************************************************/
imports::~imports()
{
}

/************************************************************************
* importaddr                                                            *
* - this checks to see if a name is an import, and if it is then it     *
*   returns the offset of its loc otherwise it returns 0. This function *
*   is used in generating the segment for imports in an NE file.        *
************************************************************************/
dword imports::importaddr(char *nm)
{ gnameitem *t;
  resetiterator();
  t=(gnameitem *)nextiterator();
  while(t!=NULL)
  { if(!strcmp(t->name,nm)) return t->addr.offs;
    t=(gnameitem *)nextiterator();
  }
  return 0;
}

/************************************************************************
* importsviewer                                                         *
* - stops the thread and displays the imports viewer dialog. Although   *
*   this supports the repeater variable, as for the names class, it is  *
*   currently unused                                                    *
************************************************************************/
void imports::importsviewer(void)
{ repeater=TRUE;
  while(repeater)
  { if(!numlistitems())
	 { MessageBox(mainwindow,"There are no imports in the list","Borg Message",MB_OK);
		return;
	 }
	 scheduler.stopthread();
	 repeater=FALSE;
	 DialogBox(hInst,MAKEINTRESOURCE(Imports_Viewer),mainwindow,(DLGPROC)importsbox);
	 scheduler.continuethread();
  }
}

/************************************************************************
* demangle                                                              *
* - this is a gname function, overridden for the imports class. Name    *
*   damangling is currently not very good, and I have some old Borland  *
*   source code which could improve this greatly......... just need to  *
*   dig it out, rework it for Borg, and put it in here now......        *
************************************************************************/
void imports::demangle(char **nme)
{ unsigned char buff[256],buff2[256],*name;
  unsigned int namelen,i,j,k,atcount,bpoint;
  BOOL brac,pointer,rpointer;
  if(!options.demangle)return;
  atcount=0;
  i=0;
  j=0;
  bpoint=0;
  brac=FALSE;
  name=(unsigned char *)(*nme);
  while(name[i])
  { if(name[i]=='@')
	 { atcount++;
		if(atcount>1)
		{ buff[j++]=':';
		  buff[j++]=':';
		}
	 }
	 else if((name[i]=='$')&&(name[i+1]=='q')&&(!brac))
	 { brac=TRUE;
		bpoint=j;
		buff[j++]='(';
		i+=1;
	 }
	 else if((name[i]=='$')&&(name[i+1]=='x')&&(name[i+2]=='q')&&(!brac))
	 { brac=TRUE;
		bpoint=j;
		buff[j++]='(';
		i+=2;
	 }
	 else if(!strnicmp((char *)&name[i],"$bctr",5))
	 { k=0;
		while((buff[k]!=':')&&(k<20))
		{ buff[j++]=buff[k++];
		}
		i+=4;
	 }
	 else if(!strnicmp((char *)&name[i],"$bdtr",5))
	 { k=0;
		buff[j++]='~';
		while((buff[k]!=':')&&(k<20))
		{ buff[j++]=buff[k++];
		}
		i+=4;
	 }
	 else if(!strnicmp((char *)&name[i],"$bdla",5))
	 { strcpy((char *)&buff[j],"delete");
		j+=6;
		i+=4;
	 }
	 else if(!strnicmp((char *)&name[i],"$bnwa",5))
	 { strcpy((char *)&buff[j],"new");
		j+=3;
		i+=4;
	 }
	 else if(!strnicmp((char *)&name[i],"$bdele",6))
	 { strcpy((char *)&buff[j],"delete");
		j+=6;
		i+=5;
	 }
	 else if(!strnicmp((char *)&name[i],"$bnew",5))
	 { strcpy((char *)&buff[j],"new");
		j+=5;
		i+=4;
	 }
	 else buff[j++]=name[i];
	 i++;
  }
  if(brac)buff[j++]=')';
  buff[j]=0;
  strcpy((char *)buff2,(char *)buff);
  if(brac)
  { j=bpoint;
	 k=bpoint;
	 i=0;
	 pointer=FALSE;
	 rpointer=FALSE;
	 while(buff[j])
	 { if((buff[j]=='p')&&(!i))
		{ pointer=TRUE;
		  j++;
		}
		if((buff[j]=='r')&&(!i))
		{ rpointer=TRUE;
		  j++;
		}
		else if((buff[j]=='i')&&(!i))
		{ i=1;
		  strcpy((char *)&buff2[k],"int");
		  k+=3;
		  j+=1;
		}
		else if((buff[j]=='c')&&(!i))
		{ i=1;
		  strcpy((char *)&buff2[k],"char");
		  k+=4;
		  j+=1;
		}
		else if((buff[j]=='v')&&(!i))
		{ i=1;
		  strcpy((char *)&buff2[k],"void");
		  k+=4;
		  j+=1;
		}
		else if((buff[j]=='l')&&(!i))
		{ i=1;
		  strcpy((char *)&buff2[k],"long");
		  k+=4;
		  j+=1;
		}
		else if((buff[j]=='u')&&(buff[j+1]=='i')&&(!i))
		{ i=1;
		  strcpy((char *)&buff2[k],"uint");
		  k+=4;
		  j+=2;
		}
		else if((buff[j]==':')&&(buff[j+1]==':')&&(i))
		{ strcpy((char *)&buff2[k],"::");
		  k+=2;
		  j+=2;
		}
		else if((buff[j]=='t')&&((buff[j+1]>='0')&&(buff[j+1]<='9'))&&(!i))
		{ buff2[k++]=buff[j++];
		  buff2[k++]=buff[j++];
		  i=1;
		}
		else if(((buff[j]>='0')&&(buff[j]<='9'))&&(!i))
		{ i=buff[j]-'0';
		  j++;
		  if((buff[j]>='0')&&(buff[j]<='9'))
		  { i=i*10+buff[j]-'0';
			 j++;
		  }
		  i++;
		}
		else buff2[k++]=buff[j++];
		if(i)
		{ i--;
		  if(!i)
		  { if((pointer)&&(buff2[k-1]!=')'))buff2[k++]='*';
			 if((rpointer)&&(buff2[k-1]!=')'))buff2[k++]='&';
			 if((buff[j]!=')')&&(buff2[k-1]!=')'))
				buff2[k++]=',';
			 pointer=FALSE;
			 rpointer=FALSE;
		  }
		}
	 }
	 buff2[k]=0;
  }
  namelen=strlen((char *)buff2);
  //BugFix Build 15 nme-> *nme.
  delete *nme;
  name=new unsigned char[namelen+1];
  strcpy((char *)name,(char *)buff2);
  *nme=(char *)name;
}

/************************************************************************
* importsbox                                                            *
* - this is the imports viewer dialog box, it is similar to the exports *
*   and names dialog, although simpler since there is only an ok button *
*   Most of the code is for filling the list box and displaying info    *
*   when an item is selected                                            *
************************************************************************/
#ifdef __BORLANDC__
#pragma warn -par
#endif
BOOL FAR PASCAL importsbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  static char nseg[20],noffs[20];
  static gnameitem *t;
  dword st;
  dword i;
  RECT drect;
  switch(message)
  { case WM_COMMAND:
		{	switch(wParam)
		  { case IDC_OKBUTTON:
				EndDialog(hdwnd,NULL);
				return TRUE;
			 default:
				break;
		  }
		  switch(HIWORD(wParam))
		  { case LBN_SELCHANGE:
				i=SendDlgItemMessage(hdwnd,IDC_IMPORTSLISTBOX,LB_GETCURSEL,0,0);
				import.resetiterator();
				t=(gnameitem *)import.nextiterator();
				while(i)
				{ t=(gnameitem *)import.nextiterator();
				  i--;
				}
				st=t->addr.segm;
				wsprintf(nseg,"0x%lx",st);
				wsprintf(noffs,"0x%lx",t->addr.offs);
				SendDlgItemMessage(hdwnd,IMPORTS_TEXTSTART,WM_SETTEXT,0,(LPARAM)(LPCTSTR)nseg);
				SendDlgItemMessage(hdwnd,IMPORTS_TEXTEND,WM_SETTEXT,0,(LPARAM)(LPCTSTR)noffs);
				break;
			 default:
				break;
		  }
		}
		break;
	 case WM_INITDIALOG:
		GetWindowRect(hdwnd,&drect);
		MoveWindow(hdwnd,((mainwnd.right+mainwnd.left)-(drect.right-drect.left))/2,
		  ((mainwnd.bottom+mainwnd.top)-(drect.bottom-drect.top))/2,drect.right-drect.left,drect.bottom-drect.top,TRUE);
		import.resetiterator();
		for(i=0;i<import.numlistitems();i++)
		{ t=(gnameitem *)import.nextiterator();
		  SendDlgItemMessage(hdwnd,IDC_IMPORTSLISTBOX,LB_ADDSTRING,0,(LPARAM) (LPCTSTR)t->name);
		}
		SendDlgItemMessage(hdwnd,IDC_IMPORTSLISTBOX,LB_SETCURSEL,0,0);
		import.resetiterator();
		t=(gnameitem *)import.nextiterator();
		st=t->addr.segm;
		wsprintf(nseg,"0x%lx",st);
		wsprintf(noffs,"0x%lx",t->addr.offs);
		SendDlgItemMessage(hdwnd,IMPORTS_TEXTSTART,WM_SETTEXT,0,(LPARAM)(LPCTSTR)nseg);
		SendDlgItemMessage(hdwnd,IMPORTS_TEXTEND,WM_SETTEXT,0,(LPARAM)(LPCTSTR)noffs);
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		SetFocus(GetDlgItem(hdwnd,IDC_OKBUTTON));
		return 0;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORBTN:
	 case WM_CTLCOLORDLG:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
  }
  return FALSE;
}
#ifdef __BORLANDC__
#pragma warn +par
#endif

