//			list.h
//
// definition of basic list class
//
// first call setcomparefunc and delfunc
// -using struct xxx list becomes:
//  class slist xxxlist;
//  xxxlist.setcomparefunc(xxxcfunc);
//  xxxlist.setdelfunc(xxxdelfunc);
//  struct aaa *anitem;
//  xxxlist.addto((listitem)anitem);
//  xxxlist.addto((listitem)anitem);
//  anitem=(struct aaa *)xxxlist.find((listitem)anotheritem);
//  xxxlist.resetiterator;
//  anitem=(struct aaa *)xxxlist.nextiterator();
//  anitem=(struct aaa *)xxxlist.lastiterator();
//
//  xxxdelfunc and xxxcfunc are defined as
//  void xxxdelfunc(listitem i)
//  { delete (struct aaa *)i;
//  }
//  int xxxcfunc(listitem i,listitem j)
//  { if((struct aaa *)i->cmp==(struct aaa *)j->cmp)) return 0;
//    if((struct aaa *)i->cmp>(struct aaa *)j->cmp)) return 1;
//    return -1;
//  }

#ifndef list_h
#define list_h

#include "common.h"

typedef void * listitem;

class slist
{ private:
	 listitem *listptr;
	 int (*cfunc)(listitem,listitem);
	 void (*delfunc)(listitem);
	 dword listsize,maxsize,listiter;

  public:
	 slist(void);
	 ~slist(void);
	 void setcomparefunc(int (*vfunc)(listitem,listitem));
	 void setdelfunc(void (*dfunc)(listitem));
	 void addto(listitem);
	 void delfrom(listitem);
	 listitem find(listitem);
	 void resetiterator(void);
	 listitem nextiterator(void);
	 listitem lastiterator(void);
	 listitem processqueue(void);
    listitem peekfirst(void);
	 dword numlistitems(void);
};

#endif
