/************************************************************************
*                 names.cpp                                             *
* the names class is an extension of the generic names class gname.cpp  *
* for general names, as opposed to exports and imports which extend the *
* gname class slightly differently                                      *
************************************************************************/

#include <windows.h>

#include "menuids.rh"
#include "names.h"
#include "disasm.h"
#include "schedule.h"
#include "mainwind.h"
#include "dasm.h"

/************************************************************************
* forward declarations for dialogs                                      *
************************************************************************/
BOOL FAR PASCAL namesbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);
BOOL FAR PASCAL getnamebox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);

/************************************************************************
* global variables                                                      *
* nme is used to hold a name entered in a dialog                        *
************************************************************************/
char *nme;

/************************************************************************
* additional constructor - currently null
************************************************************************/
names::names()
{
}

/************************************************************************
* additional destructor - currently null                                *
************************************************************************/
names::~names()
{
}

/************************************************************************
* nameloc                                                               *
* - this calls the user dialog for a name to be entered for the current *
*   location, and then passes this to the scheduler for naming the      *
*   location within the secondary thread. the name is deleted in the    *
*   scheduler since the generic addname creates a new string            *
************************************************************************/
void names::nameloc(void)
{ nme=NULL;
  DialogBox(hInst,MAKEINTRESOURCE(Get_Name),mainwindow,(DLGPROC)getnamebox);
  // task comment is deleted in the scheduler.
  if(nme!=NULL)scheduler.addtask(namecurloc,priority_userrequest,nlptr,nme);
}

/************************************************************************
* namecurrloc                                                           *
* - this is a secondary thread function which gets the current location *
*   and then adds the name to the list                                  *
************************************************************************/
void names::namecurrloc(char *nameit)
{ lptr loc;
  dio.findcurrentaddr(&loc);
  addname(loc,nameit);
}

/************************************************************************
* namesviewer                                                           *
* - this controls the display of the names viewer dialog box. names are *
*   viewed in the dialog box in location order. the function here       *
*   stops the secondary thread in order to freeze the list of names and *
*   then displays them. should a name be deleted or renamed then the    *
*   repeater variable ensures that the dialog box is redisplayed after  *
*   a window update                                                     *
************************************************************************/
void names::namesviewer(void)
{ repeater=TRUE;
  while(repeater)
  { if(!numlistitems())
	 { MessageBox(mainwindow,"There are no names in the list","Borg Message",MB_OK);
		return;
	 }
	 scheduler.stopthread();
	 repeater=FALSE;
	 DialogBox(hInst,MAKEINTRESOURCE(Names_Viewer),mainwindow,(DLGPROC)namesbox);
	 scheduler.continuethread();
  }
}

/************************************************************************
* namesbox                                                              *
* - the dialog box for the names list. deleting and renaming sets the   *
*   repeater variable to TRUE. this should ensure that the request as a *
*   userrequest is performed and the dialog is regenerated again        *
* - the list is a simple location order of names, which is the same as  *
*   the underlying list class ordering                                  *
************************************************************************/
#ifdef __BORLANDC__
#pragma warn -par
#endif
BOOL FAR PASCAL namesbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  static char nseg[20],noffs[20];
  static gnameitem *t;
  dword st;
  dword i;
  RECT drect;
  switch(message)
  { case WM_COMMAND:
		{	switch(wParam)
		  { case IDC_OKBUTTON:
				EndDialog(hdwnd,NULL);
				return TRUE;
			 case IDC_JUMPTOBUTTON:
				scheduler.addtask(user_jumptoaddr,priority_userrequest,t->addr,NULL);
				EndDialog(hdwnd,NULL);
				return TRUE;
			 case NAMES_DELETE:
				name.delname(t->addr);
				EndDialog(hdwnd,NULL);
				name.repeater=TRUE;
				break;
			 case NAMES_RENAME:
				nme=NULL;
				DialogBox(hInst,MAKEINTRESOURCE(Get_Name),hdwnd,(DLGPROC)getnamebox);
				if(nme!=NULL)scheduler.addtask(namecurloc,priority_userrequest,t->addr,nme);
				EndDialog(hdwnd,NULL);
				name.repeater=TRUE;
				break;
			 default:
				break;
		  }
		  switch(HIWORD(wParam))
		  { case LBN_SELCHANGE:
				i=SendDlgItemMessage(hdwnd,IDC_NAMESLISTBOX,LB_GETCURSEL,0,0);
				name.resetiterator();
				t=(gnameitem *)name.nextiterator();
				while(i)
				{ t=(gnameitem *)name.nextiterator();
				  i--;
				}
				st=t->addr.segm;
				wsprintf(nseg,"0x%lx",st);
				wsprintf(noffs,"0x%lx",t->addr.offs);
				SendDlgItemMessage(hdwnd,NAMES_TEXTSTART,WM_SETTEXT,0,(LPARAM)(LPCTSTR)nseg);
				SendDlgItemMessage(hdwnd,NAMES_TEXTEND,WM_SETTEXT,0,(LPARAM)(LPCTSTR)noffs);
				break;
			 default:
				break;
		  }
		}
		break;
	 case WM_INITDIALOG:
		GetWindowRect(hdwnd,&drect);
		MoveWindow(hdwnd,((mainwnd.right+mainwnd.left)-(drect.right-drect.left))/2,
		  ((mainwnd.bottom+mainwnd.top)-(drect.bottom-drect.top))/2,drect.right-drect.left,drect.bottom-drect.top,TRUE);
		name.resetiterator();
		for(i=0;i<name.numlistitems();i++)
		{ t=(gnameitem *)name.nextiterator();
		  SendDlgItemMessage(hdwnd,IDC_NAMESLISTBOX,LB_ADDSTRING,0,(LPARAM) (LPCTSTR)t->name);
		}
		SendDlgItemMessage(hdwnd,IDC_NAMESLISTBOX,LB_SETCURSEL,0,0);
		name.resetiterator();
		t=(gnameitem *)name.nextiterator();
		st=t->addr.segm;
		wsprintf(nseg,"0x%lx",st);
		wsprintf(noffs,"0x%lx",t->addr.offs);
		SendDlgItemMessage(hdwnd,NAMES_TEXTSTART,WM_SETTEXT,0,(LPARAM)(LPCTSTR)nseg);
		SendDlgItemMessage(hdwnd,NAMES_TEXTEND,WM_SETTEXT,0,(LPARAM)(LPCTSTR)noffs);
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		SetFocus(GetDlgItem(hdwnd,IDC_OKBUTTON));
		return 0;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORBTN:
	 case WM_CTLCOLORDLG:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
  }
  return FALSE;
}
#ifdef __BORLANDC__
#pragma warn +par
#endif

/************************************************************************
* getnamebox                                                            *
* - this is a small dialog for the input of name for a location. the    *
*   name is stored (pointer) in the global variable nme for the caller  *
*   to process                                                          *
************************************************************************/
#ifdef __BORLANDC__
#pragma warn -par
#endif
BOOL FAR PASCAL getnamebox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  RECT drect;
  switch(message)
  { case WM_COMMAND:
		{	switch(wParam)
		  { case IDOK:
				EndDialog(hdwnd,NULL);
				nme=new char[GNAME_MAXLEN+1];
				SendDlgItemMessage(hdwnd,IDC_NAMEEDIT,WM_GETTEXT,(WPARAM)GNAME_MAXLEN,(LPARAM)nme);
				return TRUE;
			 case IDCANCEL:
				EndDialog(hdwnd,NULL);
				nme=NULL;
				return TRUE;
		  }
		}
		break;
	 case WM_INITDIALOG:
		GetWindowRect(hdwnd,&drect);
		MoveWindow(hdwnd,((mainwnd.right+mainwnd.left)-(drect.right-drect.left))/2,
		  ((mainwnd.bottom+mainwnd.top)-(drect.bottom-drect.top))/2,drect.right-drect.left,drect.bottom-drect.top,TRUE);
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		SetFocus(GetDlgItem(hdwnd,IDC_NAMEEDIT));
		return 0;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORBTN:
	 case WM_CTLCOLORDLG:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
  }
  return FALSE;
}
#ifdef __BORLANDC__
#pragma warn +par
#endif

