/************************************************************************
*              range.cpp                                                *
* This range class started out as just that - a range class for pairs   *
* of lptr's, but ended up as a class for defining a block more than a   *
* range. The block is set by the use in Borg, and then the block can be *
* undefined, exported as txt/asm, decrypted, etc. All of this was added *
* in Borg 2.15                                                          *
************************************************************************/

#include <windows.h>
#include "range.h"
#include "disio.h"
#include "dasm.h"
#include "disasm.h"
#include "schedule.h"
#include "menuids.rh"

/************************************************************************
* forward declarations                                                  *
************************************************************************/
BOOL FAR PASCAL blockbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);

/************************************************************************
* constructor                                                           *
* - sets the top and bottom of the range to the null pointer            *
************************************************************************/
range::range()
{ top=nlptr;
  bottom=nlptr;
}

/************************************************************************
* destructor                                                            *
* - currently null                                                      *
************************************************************************/
range::~range()
{
}

/************************************************************************
* checkblock                                                            *
* - This just checks that the top and bottom of the block have been set *
*   and returns true if they have, otherwise puts up a messagebox       *
************************************************************************/
BOOL range::checkblock(void)
{ if(top==nlptr)
  { MessageBox(mainwindow,"Set top of block first","Borg Disassembler",MB_OK);
    return FALSE;
  }
  if(bottom==nlptr)
  { MessageBox(mainwindow,"Set bottom of block first","Borg Disassembler",MB_OK);
    return FALSE;
  }
  if(top>bottom)
  { MessageBox(mainwindow,"Block empty ?","Borg Disassembler",MB_OK);
    return FALSE;
  }
  return TRUE;
}

/************************************************************************
* undefine                                                              *
* - this undefines a block if the block has been set                    *
************************************************************************/
void range::undefine(void)
{ if(!checkblock()) return;
  dsm.undefineblock(top,bottom);
}

/************************************************************************
* settop                                                                *
* - sets the top of the block to the current line                       *
************************************************************************/
void range::settop(void)
{ dio.findcurrentaddr(&top);
  MessageBox(mainwindow,"Top marked","Borg Disassembler",MB_OK);
}

/************************************************************************
* setbottom                                                             *
* - sets the bottom of the block to the current line                    *
************************************************************************/
void range::setbottom(void)
{ dio.findcurrentaddr(&bottom);
  MessageBox(mainwindow,"Bottom marked","Borg Disassembler",MB_OK);
}

/************************************************************************
* blockview                                                             *
* - this stops the secondary thread and puts up the dialog box for      *
*   viewing the extents of the block                                    *
************************************************************************/
void blockview(void)
{ scheduler.stopthread();
  DialogBox(hInst,MAKEINTRESOURCE(Block_Dialog),mainwindow,(DLGPROC)blockbox);
  scheduler.continuethread();
}

/************************************************************************
* blockbox                                                              *
* - this is the dialog which just shows the extents of the current      *
*   block                                                               *
************************************************************************/
#ifdef __BORLANDC__
#pragma warn -par
#endif
BOOL FAR PASCAL blockbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  RECT drect;
  static char s1[30],s2[30],s3[40];
  switch(message)
  { case WM_COMMAND:
		{	switch(wParam)
		  { case IDOK:
				EndDialog(hdwnd,NULL);
				return TRUE;
			 default:
				break;
		  }
		}
		break;
	 case WM_INITDIALOG:
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		GetWindowRect(hdwnd,&drect);
		MoveWindow(hdwnd,((mainwnd.right+mainwnd.left)-(drect.right-drect.left))/2,
		  ((mainwnd.bottom+mainwnd.top)-(drect.bottom-drect.top))/2,drect.right-drect.left,drect.bottom-drect.top,TRUE);
      wsprintf(s1,"%04x:%08lxh",blk.top.segm,blk.top.offs);
      wsprintf(s2,"%04x:%08lxh",blk.bottom.segm,blk.bottom.offs);
		SendDlgItemMessage(hdwnd,Text_Top,WM_SETTEXT,0,(LPARAM)(LPCTSTR)s1);
		SendDlgItemMessage(hdwnd,Text_Bottom,WM_SETTEXT,0,(LPARAM)(LPCTSTR)s2);
      if(blk.top==nlptr) strcpy(s3,"Top not set");
      else if(blk.bottom==nlptr) strcpy(s3,"Bottom not set");
      else if(blk.top>blk.bottom) strcpy(s3,"Range is empty");
      else strcpy(s3,"Range set");
		SendDlgItemMessage(hdwnd,Text_Status,WM_SETTEXT,0,(LPARAM)(LPCTSTR)s3);
		return 0;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORBTN:
	 case WM_CTLCOLORDLG:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
  }
  return FALSE;
}
#ifdef __BORLANDC__
#pragma warn +par
#endif

