//					relocs.h
//

#ifndef relocs_h
#define relocs_h

#include "list.h"
#include "common.h"
#include "savefile.h"

// relocation types, should be self explanatory. Most are not generally used by programs,
// mainly reloc_offs32 by the PE file format.
enum reloctype {RELOC_NONE=1,RELOC_SEG,RELOC_OFFS16,RELOC_OFFS32,RELOC_SEGOFFS16,RELOC_SEGOFFS32};

// we will keep track of relocation addresses and the type.
struct relocitem
{ lptr addr;
  reloctype type;
};

// class definition.
class relocs: public slist
{ public:
	 relocs();
	 ~relocs();
	 void addreloc(lptr loc,reloctype type);
	 BOOL isreloc(lptr loc);
	 BOOL savedb(savefile *sf);
	 BOOL loaddb(savefile *sf);
	 BOOL relocfile(void);
};

extern relocs reloc;

#endif