//			savefile.h
//

#ifndef savefile_h
#define savefile_h

#include "list.h"
#include "common.h"

#define RBUFF_MAXLEN 4096
#define rle_code 0x0f

class savefile
{  private:
      HANDLE sfile;
      unsigned long rbufflen;
      unsigned long rbuffptr;
      byte rbuff[RBUFF_MAXLEN+1];
      BOOL rbhigh;
      BOOL rlemode;
      BOOL rlestart;
      byte rlecount;
      byte rlebyte;

	private:
   	BOOL getnibble(byte *n);
	   BOOL getrlenibble(byte *n);
      BOOL putnibble(byte n);
      BOOL flushnibble(void);
      BOOL putrlenibble(byte n);
      BOOL flushrlenibble(void);

	public:
 		savefile();
		~savefile();
   	BOOL sopen(LPCTSTR lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,
			DWORD dwCreationDistribution,DWORD dwFlagsAndAttributes);
   	void sclose(void);
   	BOOL sread(LPVOID lpBuffer,DWORD nNumberOfBytesToRead,LPDWORD lpNumberOfBytesRead);
   	BOOL swrite(LPCVOID lpBuffer,DWORD nNumberOfBytesToWrite);
      BOOL flushfilewrite(void);
};

#endif