/************************************************************************
*                 search.cpp                                            *
* These are the functions which handle searching. I still have more     *
* work to do on searching (particularly regarding strings - unicode,    *
* etc), but the basic functionality is there. Other ideas for the       *
* future include wildcard searching. (Byte wildcard searching would be  *
* nice :))                                                              *
************************************************************************/

#include <windows.h>
#include <stdio.h>

#include "menuids.rh"
#include "srch.h"
#include "data.h"
#include "schedule.h"
#include "disasm.h"
#include "debug.h"
#include "dasm.h"

/************************************************************************
* global variables                                                      *
* - these just save the search dialog status, and allow us to fill in   *
*   the old options in the dialog box, and also do a second search, etc *
************************************************************************/
char oldsearchtext[200]="";
search_type lastsearchtype=SEARCH_STR;
BOOL lastfromstart=FALSE;

/************************************************************************
* forward declarations                                                  *
************************************************************************/
BOOL FAR PASCAL searchbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);
BOOL FAR PASCAL searchingbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);

/************************************************************************
* searchengine                                                          *
* - simply stops the secondary thread, puts up the search dialog box,   *
*   and restarts the thread again at the end                            *
************************************************************************/
void searchengine(void)
{ scheduler.stopthread();
  DialogBox(hInst,MAKEINTRESOURCE(Search_Dialog),mainwindow,(DLGPROC)searchbox);
  scheduler.continuethread();
}

/************************************************************************
* searchmore                                                            *
* - I basically ripped out the main search code from the original       *
*   dialog box, and created a searchmore function from it, which just   *
*   allows the user to press a key and search again (F3).               *
* - The function handles stopping and starting the secondary thread     *
************************************************************************/
void searchmore(void)
{ search_type searchtype;
  lptr s_seg,ssold;
  char srchtext[200];
  byte match[200],*segmtch,tmpbyte;
  int matchlen,i;
  dword mtch;
  BOOL found;
  HWND sbox;
  dsegitem *srchseg;
  if(!strlen(oldsearchtext))
  { searchengine();
  	 return;
  }
  scheduler.stopthread();
  searchtype=lastsearchtype;
  dio.findcurrentaddr(&s_seg);
  s_seg+=dsm.getlength(s_seg);
  sbox=CreateDialog(hInst,MAKEINTRESOURCE(S_Box),mainwindow,(DLGPROC)searchingbox);
  // get string,
  strcpy(srchtext,oldsearchtext);
  switch(searchtype)
  { case SEARCH_STR:
      matchlen=strlen(srchtext);
      strcpy((char *)match,srchtext);
      break;
    case SEARCH_HEX:
      sscanf(srchtext,"%x",&mtch);
      if(mtch<256)
      { matchlen=1;
        match[0]=(byte)mtch;
      }
      else if(mtch<65536)
      { matchlen=2;
        match[0]=(byte)(mtch&0xff);
        match[1]=(byte)(mtch/0x100);
      }
      else
      { matchlen=4;
        match[0]=(byte)(mtch&0xff);
        match[1]=(byte)(mtch/0x100);
        match[2]=(byte)(mtch/0x10000);
        match[3]=(byte)(mtch/0x1000000);
      }
      break;
    case SEARCH_DEC:
      sscanf(srchtext,"%d",&mtch);
      if(mtch<256)
      { matchlen=1;
        match[0]=(byte)mtch;
      }
      else if(mtch<65536)
      { matchlen=2;
        match[0]=(byte)(mtch&0xff);
        match[1]=(byte)(mtch/0x100);
      }
      else
      { matchlen=4;
        match[0]=(byte)(mtch&0xff);
        match[1]=(byte)(mtch/0x100);
        match[2]=(byte)(mtch/0x10000);
        match[3]=(byte)(mtch/0x1000000);
      }
      break;
    case SEARCH_BYTES:
      matchlen=strlen(srchtext)/2;
      for(i=0;i<matchlen;i++)
      { if(srchtext[i*2]>='a')tmpbyte=(byte)((srchtext[i*2]-'a'+10));
        else tmpbyte=(byte)((srchtext[i*2]-'0'));
        if(srchtext[i*2+1]>='a')tmpbyte=(byte)(tmpbyte*16+(srchtext[i*2+1]-'a'+10));
        else tmpbyte=(byte)(tmpbyte*16+(srchtext[i*2+1]-'0'));
        match[i]=tmpbyte;
      }
      break;
  }
  // string->data,
  // for each seg do .....
  found=FALSE;
  srchseg=dta.findseg(s_seg);
  while(srchseg!=NULL)
  { s_seg.segm=srchseg->addr.segm;
    if(s_seg<srchseg->addr)s_seg=srchseg->addr;
    while(s_seg<srchseg->addr+srchseg->size-matchlen)
    { segmtch=srchseg->data+(s_seg-srchseg->addr);
      found=TRUE;
      for(i=0;i<matchlen;i++)
      { if(segmtch[i]!=match[i])
        { found=FALSE;
          break;
        }
      }
      if(found)break;
      s_seg++;
    }
    if(found)break;
    s_seg.offs=0;
    ssold=srchseg->addr;
    srchseg=(dsegitem *)dta.nextiterator();
    // try not to do first segment twice.........
    if(srchseg!=NULL)
      if(ssold==srchseg->addr)
        srchseg=(dsegitem *)dta.nextiterator();
  }
  if(found)scheduler.addtask(user_jumptoaddr,priority_userrequest,s_seg,NULL);
  DestroyWindow(sbox);
  scheduler.continuethread();
}

/************************************************************************
* searchbox                                                             *
* - this is the main search dialog box.                                 *
* - it performs the search when we press ok, and the state of controls  *
*   is saved to global variables                                        *
************************************************************************/
#ifdef __BORLANDC__
#pragma warn -par
#endif
BOOL FAR PASCAL searchbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  search_type searchtype;
  char srchtext[200];
  byte match[200];
  dsegitem *srchseg;
  int matchlen,i;
  byte tmpbyte;
  byte *segmtch;
  dword mtch;
  lptr s_seg,ssold;
  RECT drect;
  BOOL found;
  HWND sbox;
  BOOL fromstart;  // added plus code, bug fix build 14
  switch(message)
  { case WM_COMMAND:
		{	switch(wParam)
		  { case IDOK:
				if(SendDlgItemMessage(hdwnd,search_string,BM_GETCHECK,(WPARAM)0,(LPARAM)0))
				  searchtype=SEARCH_STR;
				else if(SendDlgItemMessage(hdwnd,search_hex,BM_GETCHECK,(WPARAM)0,(LPARAM)0))
				  searchtype=SEARCH_HEX;
				else if(SendDlgItemMessage(hdwnd,search_decimal,BM_GETCHECK,(WPARAM)0,(LPARAM)0))
				  searchtype=SEARCH_DEC;
				else searchtype=SEARCH_BYTES;
				if(SendDlgItemMessage(hdwnd,search_fromstart,BM_GETCHECK,(WPARAM)0,(LPARAM)0))
				{ s_seg=options.loadaddr;
				  fromstart=TRUE;
				}
				else
				{ dio.findcurrentaddr(&s_seg);
				  s_seg+=dsm.getlength(s_seg);
				  fromstart=FALSE;
				}
				sbox=CreateDialog(hInst,MAKEINTRESOURCE(S_Box),hdwnd,(DLGPROC)searchingbox);
				// get string,
				SendDlgItemMessage(hdwnd,search_edit,WM_GETTEXT,(WPARAM)18,(LPARAM)srchtext);
            strcpy(oldsearchtext,srchtext);
				switch(searchtype)
				{ case SEARCH_STR:
					 matchlen=strlen(srchtext);
					 strcpy((char *)match,srchtext);
					 break;
				  case SEARCH_HEX:
					 sscanf(srchtext,"%x",&mtch);
					 if(mtch<256)
					 { matchlen=1;
						match[0]=(byte)mtch;
					 }
					 else if(mtch<65536)
					 { matchlen=2;
						match[0]=(byte)(mtch&0xff);
						match[1]=(byte)(mtch/0x100);
					 }
					 else
					 { matchlen=4;
						match[0]=(byte)(mtch&0xff);
						match[1]=(byte)(mtch/0x100);
						match[2]=(byte)(mtch/0x10000);
						match[3]=(byte)(mtch/0x1000000);
					 }
					 break;
				  case SEARCH_DEC:
					 sscanf(srchtext,"%d",&mtch);
					 if(mtch<256)
					 { matchlen=1;
						match[0]=(byte)mtch;
					 }
					 else if(mtch<65536)
					 { matchlen=2;
						match[0]=(byte)(mtch&0xff);
						match[1]=(byte)(mtch/0x100);
					 }
					 else
					 { matchlen=4;
						match[0]=(byte)(mtch&0xff);
						match[1]=(byte)(mtch/0x100);
						match[2]=(byte)(mtch/0x10000);
						match[3]=(byte)(mtch/0x1000000);
					 }
					 break;
				  case SEARCH_BYTES:
					 matchlen=strlen(srchtext)/2;
					 for(i=0;i<matchlen;i++)
					 { if(srchtext[i*2]>='a')tmpbyte=(byte)((srchtext[i*2]-'a'+10));
						else tmpbyte=(byte)((srchtext[i*2]-'0'));
						if(srchtext[i*2+1]>='a')tmpbyte=(byte)(tmpbyte*16+(srchtext[i*2+1]-'a'+10));
						else tmpbyte=(byte)(tmpbyte*16+(srchtext[i*2+1]-'0'));
						match[i]=tmpbyte;
					 }
					 break;
				}
				// string->data,
				// for each seg do .....
				found=FALSE;
				if(fromstart)
				{ dta.resetiterator();
				  srchseg=(dsegitem *)dta.nextiterator();
				  dta.resetiterator();
				}
				else
				{  srchseg=dta.findseg(s_seg);
            }
            lastfromstart=fromstart;
				while(srchseg!=NULL)
				{ s_seg.segm=srchseg->addr.segm;
              if(fromstart) s_seg=srchseg->addr;
              fromstart=FALSE;
				  if(s_seg<srchseg->addr)s_seg=srchseg->addr;
				  while(s_seg<srchseg->addr+srchseg->size-matchlen)
				  { segmtch=srchseg->data+(s_seg-srchseg->addr);
					 found=TRUE;
					 for(i=0;i<matchlen;i++)
					 { if(segmtch[i]!=match[i])
						{ found=FALSE;
						  break;
						}
					 }
					 if(found)break;
					 s_seg++;
				  }
				  if(found)break;
				  s_seg.offs=0;
              ssold=srchseg->addr;
				  srchseg=(dsegitem *)dta.nextiterator();
              // try not to do first segment twice.........
              if(srchseg!=NULL)
                if(ssold==srchseg->addr)
                  srchseg=(dsegitem *)dta.nextiterator();
				}
            lastsearchtype=searchtype;
				if(found)scheduler.addtask(user_jumptoaddr,priority_userrequest,s_seg,NULL);
				DestroyWindow(sbox);
				EndDialog(hdwnd,NULL);
				return TRUE;
			 case IDCANCEL:
				EndDialog(hdwnd,NULL);
				return TRUE;
			 default:
				break;
		  }
		}
		break;
	 case WM_INITDIALOG:
		GetWindowRect(hdwnd,&drect);
		MoveWindow(hdwnd,((mainwnd.right+mainwnd.left)-(drect.right-drect.left))/2,
		  ((mainwnd.bottom+mainwnd.top)-(drect.bottom-drect.top))/2,drect.right-drect.left,drect.bottom-drect.top,TRUE);
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
      fromstart=lastfromstart;
      searchtype=lastsearchtype;
	   if(searchtype==SEARCH_STR)
			SendDlgItemMessage(hdwnd,search_string,BM_SETCHECK,(WPARAM)1,(LPARAM)0);
	   else if(searchtype==SEARCH_HEX)
			SendDlgItemMessage(hdwnd,search_hex,BM_SETCHECK,(WPARAM)1,(LPARAM)0);
	   else if(searchtype==SEARCH_DEC)
			SendDlgItemMessage(hdwnd,search_decimal,BM_SETCHECK,(WPARAM)1,(LPARAM)0);
	   else
			SendDlgItemMessage(hdwnd,search_bytes,BM_SETCHECK,(WPARAM)1,(LPARAM)0);
      if(fromstart)
			SendDlgItemMessage(hdwnd,search_fromstart,BM_SETCHECK,(WPARAM)1,(LPARAM)0);
      else
			SendDlgItemMessage(hdwnd,search_fromcurr,BM_SETCHECK,(WPARAM)1,(LPARAM)0);
		SendDlgItemMessage(hdwnd,search_edit,WM_SETTEXT,(WPARAM)0,(LPARAM)oldsearchtext);
		SetFocus(GetDlgItem(hdwnd,search_edit));
		return 0;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORBTN:
	 case WM_CTLCOLORDLG:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
  }
  return FALSE;
}
#ifdef __BORLANDC__
#pragma warn +par
#endif

/************************************************************************
* searchingbox                                                          *
* - this is simply a small dialog box with only the text message        *
*   'searching' which is displayed while the search takes place. Note   *
*   that while a search is being done we are in the primary thread and  *
*   that the secondary thread is stopped, so nothing else happens       *
*   within Borg at all.                                                 *
************************************************************************/
#ifdef __BORLANDC__
#pragma warn -par
#endif
BOOL FAR PASCAL searchingbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  RECT drect;
  switch(message)
  { case WM_INITDIALOG:
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		GetWindowRect(hdwnd,&drect);
		MoveWindow(hdwnd,((mainwnd.right+mainwnd.left)-(drect.right-drect.left))/2,
		  ((mainwnd.bottom+mainwnd.top)-(drect.bottom-drect.top))/2,drect.right-drect.left,drect.bottom-drect.top,TRUE);
		return 0;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORDLG:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
  }
  return FALSE;
}
#ifdef __BORLANDC__
#pragma warn +par
#endif