/************************************************************************
*				xref.cpp                                                    *
*                                                                       *
* class to maintain xref list - xref items consist simply of an address *
* which is the location being referenced and a ref_by address which is  *
* where the reference is from. It is ordered by location and then by    *
* ref_by.                                                               *
************************************************************************/

// include files
#include <windows.h>
#include "menuids.rh"
#include "xref.h"
#include "schedule.h"
#include "dasm.h"
#include "disasm.h"
#include "data.h"
#include "debug.h"
#include "mainwind.h"

/************************************************************************
* forward declarations.                                                 *
************************************************************************/
BOOL FAR PASCAL xrefsbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);
int xrefcfunc(listitem i,listitem j);
void xrefdfunc(listitem i);

/************************************************************************
* constructor simply sets up compare and deletion functions             *
* for the xref lists.                                                   *
************************************************************************/
xref::xref()
{ setcomparefunc(xrefcfunc);
  setdelfunc(xrefdfunc);
}

/************************************************************************
* destructor - nothing is done here, the item can simply be freed       *
************************************************************************/
xref::~xref()
{
}

/************************************************************************
* basic function which adds an xref to the current list.                *
* - just need loc=location for which to create an xref                  *
* - and ref_by=where it is being referenced from                        *
* after the xref has been added we still need to add a line             *
* to the disassembly and so a task to do this is added using            *
* the scheduler.                                                        *
************************************************************************/
void xref::addxref(lptr loc,lptr ref_by)
{ xrefitem *newxref,*chk;
  newxref=new xrefitem;
  dsegitem *chkseg;
  chkseg=dta.findseg(loc);
  if(chkseg==NULL)
  { delete newxref;
    return;
  }
  newxref->addr=loc;
  newxref->refby=ref_by;
  chk=(xrefitem *)find((listitem)newxref);
  if(chk!=NULL)
	 if(!xrefcfunc((listitem)newxref,(listitem)chk))
	 { delete newxref;
		return;
	 }
  addto((listitem)newxref);
  scheduler.addtask(dis_xref,priority_xref,loc,NULL);
}

/************************************************************************
* compare function for list - uses address/referencing address          *
* to sort list                                                          *
************************************************************************/
int xrefcfunc(listitem i,listitem j)
{ if(((xrefitem *)i)->addr<((xrefitem *)j)->addr)
		return -1;
  if(((xrefitem *)i)->addr>((xrefitem *)j)->addr)
		return 1;
  if(((xrefitem *)i)->refby<((xrefitem *)j)->refby)
		return -1;
  if(((xrefitem *)i)->refby>((xrefitem *)j)->refby)
		return 1;
  return 0;
}

/************************************************************************
* deletion function for list                                            *
************************************************************************/
void xrefdfunc(listitem i)
{ delete(xrefitem *)i;
}

/************************************************************************
* function to delete an xref from the list                              *
* after the xref has been deleted we check if we need to                *
* delete anything from the disassembly as well if there are             *
* no xrefs left for that loc                                            *
************************************************************************/
void xref::delxref(lptr loc,lptr ref_by)
{ xrefitem xtmp,*xfind;
  xtmp.addr=loc;
  xtmp.refby=ref_by;
  xfind=(xrefitem *)find((listitem)&xtmp);
  if(xfind!=NULL)
	 if((xfind->addr==loc)&&(xfind->refby==ref_by))
	 {	delfrom((listitem)xfind);
		xtmp.refby=nlptr;
		xfind=(xrefitem *)find((listitem)&xtmp);
		if(xfind!=NULL)
		  if(xfind->addr!=loc)xfind=(xrefitem *)nextiterator();
		if(xfind!=NULL)
		  if(xfind->addr!=loc)xfind=(xrefitem *)nextiterator();
		if(xfind!=NULL)
		  if(xfind->addr==loc)return;
		dsm.delcomment(loc,dsmxref);
	 }
}

/************************************************************************
* prints the first xref for a given loc                                 *
************************************************************************/
void xref::printfirst(lptr loc)
{ dword numents=0;
  xrefitem findit,*chk;
  findit.addr=loc;
  findit.refby=nlptr;
  find((listitem)&findit);
  chk=(xrefitem *)nextiterator();
  if(chk==NULL) return;
  while(chk->addr!=loc)
  { chk=(xrefitem *)nextiterator();
	 if(chk==NULL)return;
  }
  if(options.mode32) LastPrintBuff("%04lx:%08lx",chk->refby.segm,chk->refby.offs);
  else LastPrintBuff("%04lx:%04lx",chk->refby.segm,chk->refby.offs);
  while(chk!=NULL)
  { if(chk->addr==loc)
	 { chk=(xrefitem *)nextiterator();
		numents++;
	 }
	 else break;
  }
  LastPrintBuff(" Number : %ld",numents);
}

/************************************************************************
* the xrefs viewer - stops the thread and continues it after            *
* displaying the dialog box                                             *
* the repeater variable allows the xref dialog to pop up again          *
* when an xref is deleted, rather than the user having to keep          *
* selecting 'view xrefs'                                                *
************************************************************************/
void xref::xrefsviewer(void)
{ xrefitem *findit,xtmp;
  repeater=TRUE;
  while(repeater)
  { scheduler.stopthread();
	 dio.findcurrentaddr(&xtmp.addr);
	 xtmp.refby=nlptr;
	 findit=(xrefitem *)find((listitem)&xtmp);
	 if(findit!=NULL)findit=(xrefitem *)nextiterator();
	 if(findit!=NULL)
    {	if(findit->addr!=xtmp.addr)
		  findit=(xrefitem *)nextiterator();
    }
    if(findit==NULL)
	 { scheduler.continuethread();
		MessageBox(mainwindow,"Unable to find any xrefs for the location","Borg Message",MB_OK);
		return;
	 }
	 if(findit->addr!=xtmp.addr)
	 { scheduler.continuethread();
		MessageBox(mainwindow,"There are no xrefs for the current location in the list","Borg Message",MB_OK);
		return;
	 }
	 repeater=FALSE;
	 DialogBox((struct HINSTANCE__ *)hInst,MAKEINTRESOURCE(Xrefs_Viewer),mainwindow,(DLGPROC)xrefsbox);
	 scheduler.continuethread();
  }
}

/************************************************************************
* dialog box controls and workings - most message processing is         *
* standardised across Borg (colorchanges, etc)                          *
************************************************************************/
#ifdef __BORLANDC__
#pragma warn -par
#endif
BOOL FAR PASCAL xrefsbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  static char nseg[20],noffs[20];
  static xrefitem *t,xtmp,*vt;
  dword st;
  dword i;
  RECT drect;
  switch(message)
  { case WM_COMMAND:
		{ switch(wParam)
		  { case IDC_OKBUTTON:
				EndDialog(hdwnd,NULL);
				return 0;
			 case IDC_JUMPTOBUTTON:
				scheduler.addtask(user_jumptoaddr,priority_userrequest,t->refby,NULL);
				xrefs.repeater=FALSE;
				EndDialog(hdwnd,NULL);
				return 0;
			 case XREFS_DELETE:
				xrefs.delxref(t->addr,t->refby);
	         scheduler.addtask(windowupdate,priority_window,nlptr,NULL);
				EndDialog(hdwnd,NULL);
				xrefs.repeater=TRUE;
				return 0;
			 default:
				break;
		  }
		  switch(HIWORD(wParam))
		  { case LBN_SELCHANGE:
				i=SendDlgItemMessage(hdwnd,IDC_XREFSLISTBOX,LB_GETCURSEL,0,0);
				t=(xrefitem *)xrefs.find((listitem)&xtmp);
				if(t!=NULL)t=(xrefitem *)xrefs.nextiterator();
				if(t->addr!=xtmp.addr)
				  t=(xrefitem *)xrefs.nextiterator();
				vt=t;
				while(i)
				{ vt=(xrefitem *)xrefs.nextiterator();
				  i--;
				}
				t=vt;
				break;
			 default:
				break;
		  }
		}
		break;
	 case WM_INITDIALOG:
		GetWindowRect(hdwnd,&drect);
		MoveWindow(hdwnd,((mainwnd.right+mainwnd.left)-(drect.right-drect.left))/2,
		  ((mainwnd.bottom+mainwnd.top)-(drect.bottom-drect.top))/2,drect.right-drect.left,drect.bottom-drect.top,TRUE);
		dio.findcurrentaddr(&xtmp.addr);
		xtmp.refby=nlptr;
		t=(xrefitem *)xrefs.find((listitem)&xtmp);
		if(t!=NULL)t=(xrefitem *)xrefs.nextiterator();
		if(t!=NULL)
      {	if(t->addr!=xtmp.addr)
		  		t=(xrefitem *)xrefs.nextiterator();
      }
		vt=t;
      if(vt!=NULL)
		{  while(vt->addr==xtmp.addr)
		  { st=vt->refby.segm;
		    wsprintf(nseg,"0x%lx",st);
		    wsprintf(noffs,"0x%lx",vt->refby.offs);
		    strcat(nseg,":");
		    strcat(nseg,noffs);
		    SendDlgItemMessage(hdwnd,IDC_XREFSLISTBOX,LB_ADDSTRING,0,(LPARAM) (LPCTSTR)nseg);
		    vt=(xrefitem *)xrefs.nextiterator();
          if(vt==NULL)break;
		  }
      }
		SendDlgItemMessage(hdwnd,IDC_XREFSLISTBOX,LB_SETCURSEL,0,0);
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		SetFocus(GetDlgItem(hdwnd,IDC_OKBUTTON));
		return 0;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORBTN:
	 case WM_CTLCOLORDLG:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
  }
  return FALSE;
}
#ifdef __BORLANDC__
#pragma warn +par
#endif

/************************************************************************
* save xref list to database file, simply writes the list item out      *
* consisting of loc and ref_by, ie two addresses                        *
************************************************************************/
BOOL xref::savedb(savefile *sf)
{ dword nxrefs;
  xrefitem *currxref;
  nxrefs=numlistitems();
  resetiterator();
  if(!sf->swrite(&nxrefs,sizeof(dword)))return FALSE;
  while(nxrefs)
  { currxref=(xrefitem *)nextiterator();
	 if(!sf->swrite(currxref,sizeof(xrefitem)))return FALSE;
	 nxrefs--;
  }
  return TRUE;
}

/************************************************************************
* load xref list to database file, simply reads the list item in        *
* consisting of loc and ref_by, ie two addresses                        *
* and adds it to the new list                                           *
************************************************************************/
BOOL xref::loaddb(savefile *sf)
{ dword nxrefs,num;
  xrefitem *currxref;
  if(!sf->sread(&nxrefs,sizeof(dword),&num))return FALSE;
  while(nxrefs)
  { currxref=new xrefitem;
	 if(!sf->sread(currxref,sizeof(xrefitem),&num))return FALSE;
	 addto((listitem)currxref);
	 nxrefs--;
  }
  return TRUE;
}

