/*
 *      Interactive disassembler (IDA).
 *      Version 2.09
 *      Copyright (c) 1990-93 by Ilfak Guilfanov. (2:5020/209@fidonet)
 *      ALL RIGHTS RESERVED.
 *
 */


extern instruc_t Instructions[];

enum nameNum {

NN_null = 0,            // Unknown Operation
NN_aaa,                 // ASCII Adjust after Addition
NN_aad,                 // ASCII Adjust AX before Division
NN_aam,                 // ASCII Adjust AX after Multiply
NN_aas,                 // ASCII Adjust AL after Subtraction
NN_adc,                 // Add with Carry
NN_add,                 // Add
NN_and,                 // Logical AND
NN_arpl,                // Adjust RPL Field of Selector
NN_bound,               // Check Array Index Against Bounds
NN_bsf,                 // Bit Scan Forward
NN_bsr,                 // Bit Scan Reverse
NN_bt,                  // Bit Test
NN_btc,                 // Bit Test and Complement
NN_btr,                 // Bit Test and Reset
NN_bts,                 // Bit Test and Set
NN_call,                // Call Procedure
NN_callfi,              // Indirect Call Far Procedure
NN_callni,              // Indirect Call Near Procedure
NN_cbw,                 // Convert Byte to Word
NN_cwde,                // Convert Word to Doubleword
NN_clc,                 // Clear Carry Flag
NN_cld,                 // Clear Direction Flag
NN_cli,                 // Clear Interrupt Flag
NN_clts,                // Clear Task-Switched Flag in CR0
NN_cmc,                 // Complement Carry Flag
NN_cmp,                 // Compare Two Operands
NN_cmps,                // Compare Strings
NN_cwd,                 // Convert Word to Doubleword
NN_cdq,                 // Convert Doubleword to Quadword
NN_daa,                 // Decimal Adjust AL after Addition
NN_das,                 // Decimal Adjust AL after Subtraction
NN_dec,                 // Decrement by 1
NN_div,                 // Unsigned Divide
NN_enterw,              // Make Stack Frame for Procedure Parameters
NN_enter,               // Make Stack Frame for Procedure Parameters
NN_enterd,              // Make Stack Frame for Procedure Parameters
NN_hlt,                 // Halt
NN_idiv,                // Signed Divide
NN_imul,                // Signed Multiply
NN_in,                  // Input from Port
NN_inc,                 // Increment by 1
NN_ins,                 // Input Byte(s) from Port to String
NN_int,                 // Call to Interrupt Procedure
NN_into,                // Call to Interrupt Procedure if Overflow Flag = 1
NN_int3,                // Trap to Debugger
NN_iretw,               // Interrupt Return
NN_iret,                // Interrupt Return
NN_iretd,               // Interrupt Return (use32)
NN_ja,                  // Jump if Above (CF=0 & ZF=0)
NN_jae,                 // Jump if Above or Equal (CF=0)
NN_jb,                  // Jump if Below (CF=1)
NN_jbe,                 // Jump if Below or Equal (CF=1 | ZF=1)
NN_jc,                  // Jump if Carry (CF=1)
NN_jcxz,                // Jump if CX is 0
NN_jecxz,               // Jump if ECX is 0
NN_je,                  // Jump if Equal (ZF=1)
NN_jg,                  // Jump if Greater (ZF=0 & SF=OF)
NN_jge,                 // Jump if Greater or Equal (SF=OF)
NN_jl,                  // Jump if Less (SF!=OF)
NN_jle,                 // Jump if Less or Equal (ZF=1 | SF!=OF)
NN_jna,                 // Jump if Not Above (CF=1 | ZF=1)
NN_jnae,                // Jump if Not Above or Equal (CF=1)
NN_jnb,                 // Jump if Not Below (CF=0)
NN_jnbe,                // Jump if Not Below or Equal (CF=0 & ZF=0)
NN_jnc,                 // Jump if Not Carry (CF=0)
NN_jne,                 // Jump if Not Equal (ZF=0)
NN_jng,                 // Jump if Not Greater (ZF=1 | SF!=OF)
NN_jnge,                // Jump if Not Greater or Equal (ZF=1)
NN_jnl,                 // Jump if Not Less (SF=OF)
NN_jnle,                // Jump if Not Less or Equal (ZF=0 & SF=OF)
NN_jno,                 // Jump if Not Overflow (OF=0)
NN_jnp,                 // Jump if Not Parity (PF=0)
NN_jns,                 // Jump if Not Sign (SF=0)
NN_jnz,                 // Jump if Not Zero (ZF=0)
NN_jo,                  // Jump if Overflow (OF=1)
NN_jp,                  // Jump if Parity (PF=1)
NN_jpe,                 // Jump if Parity Even (PF=1)
NN_jpo,                 // Jump if Parity Odd  (PF=0)
NN_js,                  // Jump if Sign (SF=1)
NN_jz,                  // Jump if Zero (ZF=1)
NN_jmp,                 // Jump
NN_jmpfi,               // Indirect Far Jump
NN_jmpni,               // Indirect Near Jump
NN_jmpshort,            // Jump Short
NN_lahf,                // Load Flags into AH Register
NN_lar,                 // Load Access Right Byte
NN_lea,                 // Load Effective Address
NN_leavew,              // High Level Procedure Exit
NN_leave,               // High Level Procedure Exit
NN_leaved,              // High Level Procedure Exit
NN_lgdt,                // Load Global Descriptor Table Register
NN_lidt,                // Load Interrupt Descriptor Table Register
NN_lgs,                 // Load Full Pointer to GS:xx
NN_lss,                 // Load Full Pointer to SS:xx
NN_lds,                 // Load Full Pointer to DS:xx
NN_les,                 // Load Full Pointer to ES:xx
NN_lfs,                 // Load Full Pointer to FS:xx
NN_lldt,                // Load Local Descriptor Table Register
NN_lmsw,                // Load Machine Status Word
NN_lock,                // Assert LOCK# Signal Prefix
NN_lods,                // Load String
NN_loopw,               // Loop while ECX != 0
NN_loop,                // Loop while CX != 0
NN_loopd,               // Loop while ECX != 0
NN_loopwe,              // Loop while CX != 0 and ZF=1
NN_loope,               // Loop while CX != 0 and ZF=1
NN_loopde,              // Loop while CX != 0 and ZF=1
NN_loopwne,             // Loop while CX != 0 and ZF=0
NN_loopne,              // Loop while CX != 0 and ZF=0
NN_loopdne,             // Loop while CX != 0 and ZF=0
NN_lsl,                 // Load Segment Limit
NN_ltr,                 // Load Task Register
NN_mov,                 // Move Data
NN_movsp,               // Move to/from Special Registers
NN_movs,                // Move Byte(s) from String to String
NN_movsx,               // Move with Sign-Extend
NN_movzx,               // Move with Zero-Extend
NN_mul,                 // Unsigned Multiplication of AL or AX
NN_neg,                 // Two's Complement Negation
NN_nop,                 // No Operation
NN_not,                 // One's Complement Negation
NN_or,                  // Logical Inclusive OR
NN_out,                 // Output to Port
NN_outs,                // Output Byte(s) to Port
NN_pop,                 // Pop a word from the Stack
NN_popaw,               // Pop all General Registers
NN_popa,                // Pop all General Registers
NN_popad,               // Pop all General Registers (use32)
NN_popfw,               // Pop Stack into Flags Register
NN_popf,                // Pop Stack into Flags Register
NN_popfd,               // Pop Stack into Eflags Register
NN_push,                // Push Operand onto the Stack
NN_pushaw,              // Push all General Registers
NN_pusha,               // Push all General Registers
NN_pushad,              // Push all General Registers (use32)
NN_pushfw,              // Push Flags Register onto the Stack
NN_pushf,               // Push Flags Register onto the Stack
NN_pushfd,              // Push Flags Register onto the Stack (use 32)
NN_rcl,                 // Rotate Through Carry Left
NN_rcr,                 // Rotate Through Carry Right
NN_rol,                 // Rotate Left
NN_ror,                 // Rotate Right
NN_rep,                 // Repeat String Operation
NN_repe,                // Repeat String Operation while ZF=1
NN_repne,               // Repeat String Operation while ZF=0
NN_retn,                // Return Near from Procedure
NN_retf,                // Return Far from Procedure
NN_sahf,                // Store AH into Flags Register
NN_sal,                 // Shift Arithmetic Left
NN_sar,                 // Shift Arithmetic Right
NN_shl,                 // Shift Logical Left
NN_shr,                 // Shift Logical Right
NN_sbb,                 // Integer Subtraction with Borrow
NN_scas,                // Compare String
NN_seta,                // Set Byte if Above (CF=0 & ZF=0)
NN_setae,               // Set Byte if Above or Equal (CF=0)
NN_setb,                // Set Byte if Below (CF=1)
NN_setbe,               // Set Byte if Below or Equal (CF=1 | ZF=1)
NN_setc,                // Set Byte if Carry (CF=1)
NN_sete,                // Set Byte if Equal (ZF=1)
NN_setg,                // Set Byte if Greater (ZF=0 & SF=OF)
NN_setge,               // Set Byte if Greater or Equal (SF=OF)
NN_setl,                // Set Byte if Less (SF!=OF)
NN_setle,               // Set Byte if Less or Equal (ZF=1 | SF!=OF)
NN_setna,               // Set Byte if Not Above (CF=1 | ZF=1)
NN_setnae,              // Set Byte if Not Above or Equal (CF=1)
NN_setnb,               // Set Byte if Not Below (CF=0)
NN_setnbe,              // Set Byte if Not Below or Equal (CF=0 & ZF=0)
NN_setnc,               // Set Byte if Not Carry (CF=0)
NN_setne,               // Set Byte if Not Equal (ZF=0)
NN_setng,               // Set Byte if Not Greater (ZF=1 | SF!=OF)
NN_setnge,              // Set Byte if Not Greater or Equal (ZF=1)
NN_setnl,               // Set Byte if Not Less (SF=OF)
NN_setnle,              // Set Byte if Not Less or Equal (ZF=0 & SF=OF)
NN_setno,               // Set Byte if Not Overflow (OF=0)
NN_setnp,               // Set Byte if Not Parity (PF=0)
NN_setns,               // Set Byte if Not Sign (SF=0)
NN_setnz,               // Set Byte if Not Zero (ZF=0)
NN_seto,                // Set Byte if Overflow (OF=1)
NN_setp,                // Set Byte if Parity (PF=1)
NN_setpe,               // Set Byte if Parity Even (PF=1)
NN_setpo,               // Set Byte if Parity Odd  (PF=0)
NN_sets,                // Set Byte if Sign (SF=1)
NN_setz,                // Set Byte if Zero (ZF=1)
NN_sgdt,                // Store Global Descriptor Table Register
NN_sidt,                // Store Interrupt Descriptor Table Register
NN_shld,                // Double Precision Shift Left
NN_shrd,                // Double Precision Shift Right
NN_sldt,                // Store Local Descriptor Table Register
NN_smsw,                // Store Machine Status Word
NN_stc,                 // Set Carry Flag
NN_std,                 // Set Direction Flag
NN_sti,                 // Set Interrupt Flag
NN_stos,                // Store String
NN_str,                 // Store Task Register
NN_sub,                 // Integer Subtraction
NN_test,                // Logical Compare
NN_verr,                // Verify a Segment for Reading
NN_verw,                // Verify a Segment for Writing
NN_wait,                // Wait until BUSY# Pin is Inactive (HIGH)
NN_xchg,                // Exchange Register/Memory with Register
NN_xlat,                // Table Lookup Translation
NN_xor,                 // Logical Exclusive OR

//
//      486 instructions
//

NN_cmpxchg,             // Compare and Exchange
NN_bswap,               // Swap bits in EAX
NN_xadd,                // t<-dest; dest<-src+dest; src<-t
NN_invd,                // Invalidate Data Cache
NN_wbinvd,              // Invalidate Data Cache (write changes)
NN_invlpg,              // Invalidate TLB entry

//
//      Pentium instructions
//

NN_rdmsr,               // Read Machine Status Register
NN_wrmsr,               // Write Machine Status Register
NN_cpuid,               // Get CPU ID
NN_cmpxchg8b,           // Compare and Exchange Eight Bytes
NN_rdtsc,               // Read Time Stamp Counter
NN_rsm,                 // Resume from System Management Mode

//
//      Pentium Pro instructions
//

NN_cmova,               // Move if Above (CF=0 & ZF=0)
NN_cmovb,               // Move if Below (CF=1)
NN_cmovbe,              // Move if Below or Equal (CF=1 | ZF=1)
NN_cmovg,               // Move if Greater (ZF=0 & SF=OF)
NN_cmovge,              // Move if Greater or Equal (SF=OF)
NN_cmovl,               // Move if Less (SF!=OF)
NN_cmovle,              // Move if Less or Equal (ZF=1 | SF!=OF)
NN_cmovnb,              // Move if Not Below (CF=0)
NN_cmovno,              // Move if Not Overflow (OF=0)
NN_cmovnp,              // Move if Not Parity (PF=0)
NN_cmovns,              // Move if Not Sign (SF=0)
NN_cmovnz,              // Move if Not Zero (ZF=0)
NN_cmovo,               // Move if Overflow (OF=1)
NN_cmovp,               // Move if Parity (PF=1)
NN_cmovs,               // Move if Sign (SF=1)
NN_cmovz,               // Move if Zero (ZF=1)
NN_fcmovb,              // Floating Move if Below
NN_fcmove,              // Floating Move if Equal
NN_fcmovbe,             // Floating Move if Below or Equal
NN_fcmovu,              // Floating Move if Unordered
NN_fcmovnb,             // Floating Move if Not Below
NN_fcmovne,             // Floating Move if Not Equal
NN_fcmovnbe,            // Floating Move if Not Below or Equal
NN_fcmovnu,             // Floating Move if Not Unordered
NN_fcomi,               // FP Compare, result in EFLAGS
NN_fucomi,              // FP Unordered Compare, result in EFLAGS
NN_fcomip,              // FP Compare, result in EFLAGS, pop stack
NN_fucomip,             // FP Unordered Compare, result in EFLAGS, pop stack
NN_rdpmc,               // Read Performance Monitor Counter

//
//      FPP instructuions
//

NN_fld,                 // Load Real
NN_fst,                 // Store Real
NN_fstp,                // Store Real and Pop
NN_fxch,                // Exchange Registers
NN_fild,                // Load Integer
NN_fist,                // Store Integer
NN_fistp,               // Store Integer and Pop
NN_fbld,                // Load BCD
NN_fbstp,               // Store BCD and Pop
NN_fadd,                // Add Real
NN_faddp,               // Add Real and Pop
NN_fiadd,               // Add Integer
NN_fsub,                // Subtract Real
NN_fsubp,               // Subtract Real and Pop
NN_fisub,               // Subtract Integer
NN_fsubr,               // Subtract Real Reversed
NN_fsubrp,              // Subtract Real Reversed and Pop
NN_fisubr,              // Subtract Integer Reversed
NN_fmul,                // Multiply Real
NN_fmulp,               // Multiply Real and Pop
NN_fimul,               // Multiply Integer
NN_fdiv,                // Divide Real
NN_fdivp,               // Divide Real and Pop
NN_fidiv,               // Divide Integer
NN_fdivr,               // Divide Real Reversed
NN_fdivrp,              // Divide Real Reversed and Pop
NN_fidivr,              // Divide Integer Reversed
NN_fsqrt,               // Square Root
NN_fscale,              // Scale:  st(0) <- st(0) * 2^st(1)
NN_fprem,               // Partial Remainder
NN_frndint,             // Round to Integer
NN_fxtract,             // Extract exponent and significand
NN_fabs,                // Absolute value
NN_fchs,                // Change Sign
NN_fcom,                // Compare Real
NN_fcomp,               // Compare Real and Pop
NN_fcompp,              // Compare Real and Pop Twice
NN_ficom,               // Compare Integer
NN_ficomp,              // Compare Integer and Pop
NN_ftst,                // Test
NN_fxam,                // Examine
NN_fptan,               // Partial tangent
NN_fpatan,              // Partial arctangent
NN_f2xm1,               // 2^x - 1
NN_fyl2x,               // Y * lg2(X)
NN_fyl2xp1,             // Y * lg2(X+1)
NN_fldz,                // Load +0.0
NN_fld1,                // Load +1.0
NN_fldpi,               // Load PI=3.14...
NN_fldl2t,              // Load lg2(10)
NN_fldl2e,              // Load lg2(e)
NN_fldlg2,              // Load lg10(2)
NN_fldln2,              // Load ln(2)
NN_finit,               // Initialize Processor
NN_fninit,              // Initialize Processor (no wait)
NN_fsetpm,              // Set Protected Mode
NN_fldcw,               // Load Control Word
NN_fstcw,               // Store Control Word
NN_fnstcw,              // Store Control Word (no wait)
NN_fstsw,               // Store Status Word
NN_fnstsw,              // Store Status Word (no wait)
NN_fclex,               // Clear Exceptions
NN_fnclex,              // Clear Exceptions (no wait)
NN_fstenv,              // Store Environment
NN_fnstenv,             // Store Environment (no wait)
NN_fldenv,              // Load Environment
NN_fsave,               // Save State
NN_fnsave,              // Save State (no wait)
NN_frstor,              // Restore State
NN_fincstp,             // Increment Stack Pointer
NN_fdecstp,             // Decrement Stack Pointer
NN_ffree,               // Free Register
NN_fnop,                // No Operation
NN_feni,                // (8087 only)
NN_fneni,               // (no wait) (8087 only)
NN_fdisi,               // (8087 only)
NN_fndisi,              // (no wait) (8087 only)

//
//      80387 instructions
//

NN_fprem1,              // Partial Remainder ( < half )
NN_fsincos,             // t<-cos(st); st<-sin(st); push t
NN_fsin,                // Sine
NN_fcos,                // Cosine
NN_fucom,               // Compare Unordered Real
NN_fucomp,              // Compare Unordered Real and Pop
NN_fucompp,             // Compare Unordered Real and Pop Twice

//
//      Instructions added 28.02.96
//

NN_setalc,              // Set AL to Carry Flag
NN_svdc,                // Save Register and Descriptor
NN_rsdc,                // Restore Register and Descriptor
NN_svldt,               // Save LDTR and Descriptor
NN_rsldt,               // Restore LDTR and Descriptor
NN_svts,                // Save TR and Descriptor
NN_rsts,                // Restore TR and Descriptor
NN_icebp,               // ICE Break Point
NN_loadall,             // Load the entire CPU state from ES:EDI

//
//      MMX instructions
//

NN_emms,                // Empty MMX state
NN_movd,                // Move 32 bits
NN_movq,                // Move 64 bits
NN_packsswb,            // Pack with Signed Saturation (Word->Byte)
NN_packssdw,            // Pack with Signed Saturation (Dword->Word)
NN_packuswb,            // Pack with Unsigned Saturation (Word->Byte)
NN_paddb,               // Packed Add Byte
NN_paddw,               // Packed Add Word
NN_paddd,               // Packed Add Dword
NN_paddsb,              // Packed Add with Saturation (Byte)
NN_paddsw,              // Packed Add with Saturation (Word)
NN_paddusb,             // Packed Add Unsigned with Saturation (Byte)
NN_paddusw,             // Packed Add Unsigned with Saturation (Word)
NN_pand,                // Bitwise Logical And
NN_pandn,               // Bitwise Logical And Not
NN_pcmpeqb,             // Packed Compare for Equal (Byte)
NN_pcmpeqw,             // Packed Compare for Equal (Word)
NN_pcmpeqd,             // Packed Compare for Equal (Dword)
NN_pcmpgtb,             // Packed Compare for Greater Than (Byte)
NN_pcmpgtw,             // Packed Compare for Greater Than (Word)
NN_pcmpgtd,             // Packed Compare for Greater Than (Dword)
NN_pmaddwd,             // Packed Multiply and Add
NN_pmulhw,              // Packed Multiply High
NN_pmullw,              // Packed Multiply Low
NN_por,                 // Bitwise Logical Or
NN_psllw,               // Packed Shift Left Logical (Word)
NN_pslld,               // Packed Shift Left Logical (Dword)
NN_psllq,               // Packed Shift Left Logical (Qword)
NN_psraw,               // Packed Shift Right Arithmetic (Word)
NN_psrad,               // Packed Shift Right Arithmetic (Dword)
NN_psrlw,               // Packed Shift Right Logical (Word)
NN_psrld,               // Packed Shift Right Logical (Dword)
NN_psrlq,               // Packed Shift Right Logical (Qword)
NN_psubb,               // Packed Subtract Byte
NN_psubw,               // Packed Subtract Word
NN_psubd,               // Packed Subtract Dword
NN_psubsb,              // Packed Subtract with Saturation (Byte)
NN_psubsw,              // Packed Subtract with Saturation (Word)
NN_psubusb,             // Packed Subtract Unsigned with Saturation (Byte)
NN_psubusw,             // Packed Subtract Unsigned with Saturation (Word)
NN_punpckhbw,           // Unpack High Packed Data (Byte->Word)
NN_punpckhwd,           // Unpack High Packed Data (Word->Dword)
NN_punpckhdq,           // Unpack High Packed Data (Dword->Qword)
NN_punpcklbw,           // Unpack Low Packed Data (Byte->Word)
NN_punpcklwd,           // Unpack Low Packed Data (Word->Dword)
NN_punpckldq,           // Unpack Low Packed Data (Dword->Qword)
NN_pxor,                // Bitwise Logical Exclusive Or

//
//      Undocumented Deschutes processor instructions
//

NN_fxsave,              // Fast save FP context
NN_fxrstor,             // Fast restore FP context

//      Pentium II instructions

NN_sysenter,            // Fast Transition to System Call Entry Point
NN_sysexit,             // Fast Transition from System Call Entry Point

//      3DNow! instructions

NN_pavgusb,             // Packed 8-bit Unsigned Integer Averaging
NN_pfadd,               // Packed Floating-Point Addition
NN_pfsub,               // Packed Floating-Point Subtraction
NN_pfsubr,              // Packed Floating-Point Reverse Subtraction
NN_pfacc,               // Packed Floating-Point Accumulate
NN_pfcmpge,             // Packed Floating-Point Comparison, Greater or Equal
NN_pfcmpgt,             // Packed Floating-Point Comparison, Greater
NN_pfcmpeq,             // Packed Floating-Point Comparison, Equal
NN_pfmin,               // Packed Floating-Point Minimum
NN_pfmax,               // Packed Floating-Point Maximum
NN_pi2fd,               // Packed 32-bit Integer to Floating-Point
NN_pf2id,               // Packed Floating-Point to 32-bit Integer
NN_pfrcp,               // Packed Floating-Point Reciprocal Approximation
NN_pfrsqrt,             // Packed Floating-Point Reciprocal Square Root Approximation
NN_pfmul,               // Packed Floating-Point Multiplication
NN_pfrcpit1,            // Packed Floating-Point Reciprocal First Iteration Step
NN_pfrsqit1,            // Packed Floating-Point Reciprocal Square Root First Iteration Step
NN_pfrcpit2,            // Packed Floating-Point Reciprocal Second Iteration Step
NN_pmulhrw,             // Packed Floating-Point 16-bit Integer Multiply with rounding
NN_femms,               // Faster entry/exit of the MMX or floating-point state
NN_prefetch,            // Prefetch at least a 32-byte line into L1 data cache
NN_prefetchw,           // Prefetch processor cache line into L1 data cache (mark as modified)


//      Pentium III instructions

NN_addps,               // Packed Single-FP Add
NN_addss,               // Scalar Single-FP Add
NN_andnps,              // Bitwise Logical And Not for Single-FP
NN_andps,               // Bitwise Logical And for Single-FP
NN_cmpps,               // Packed Single-FP Compare
NN_cmpss,               // Scalar Single-FP Compare
NN_comiss,              // Scalar Ordered Single-FP Compare and Set EFLAGS
NN_cvtpi2ps,            // Packed signed INT32 to Packed Single-FP conversion
NN_cvtps2pi,            // Packed Single-FP to Packed INT32 conversion
NN_cvtsi2ss,            // Scalar signed INT32 to Single-FP conversion
NN_cvtss2si,            // Scalar Single-FP to signed INT32 conversion
NN_cvttps2pi,           // Packed Single-FP to Packed INT32 conversion (truncate)
NN_cvttss2si,           // Scalar Single-FP to signed INT32 conversion (truncate)
NN_divps,               // Packed Single-FP Divide
NN_divss,               // Scalar Single-FP Divide
NN_ldmxcsr,             // Load Streaming SIMD Extensions Technology Control/Status Register
NN_maxps,               // Packed Single-FP Maximum
NN_maxss,               // Scalar Single-FP Maximum
NN_minps,               // Packed Single-FP Minimum
NN_minss,               // Scalar Single-FP Minimum
NN_movaps,              // Move Aligned Four Packed Single-FP
NN_movhlps,             // Move High to Low Packed Single-FP
NN_movhps,              // Move High Packed Single-FP
NN_movlhps,             // Move Low to High Packed Single-FP
NN_movlps,              // Move Low Packed Single-FP
NN_movmskps,            // Move Mask to Register
NN_movss,               // Move Scalar Single-FP
NN_movups,              // Move Unaligned Four Packed Single-FP
NN_mulps,               // Packed Single-FP Multiply
NN_mulss,               // Scalar Single-FP Multiply
NN_orps,                // Bitwise Logical OR for Single-FP Data
NN_rcpps,               // Packed Single-FP Reciprocal
NN_rcpss,               // Scalar Single-FP Reciprocal
NN_rsqrtps,             // Packed Single-FP Square Root Reciprocal
NN_rsqrtss,             // Scalar Single-FP Square Root Reciprocal
NN_shufps,              // Shuffle Single-FP
NN_sqrtps,              // Packed Single-FP Square Root
NN_sqrtss,              // Scalar Single-FP Square Root
NN_stmxcsr,             // Store Streaming SIMD Extensions Technology Control/Status Register
NN_subps,               // Packed Single-FP Subtract
NN_subss,               // Scalar Single-FP Subtract
NN_ucomiss,             // Scalar Unordered Single-FP Compare and Set EFLAGS
NN_unpckhps,            // Unpack High Packed Single-FP Data
NN_unpcklps,            // Unpack Low Packed Single-FP Data
NN_xorps,               // Bitwise Logical XOR for Single-FP Data
NN_pavgb,               // Packed Average (Byte)
NN_pavgw,               // Packed Average (Word)
NN_pextrw,              // Extract Word
NN_pinsrw,              // Insert Word
NN_pmaxsw,              // Packed Signed Integer Word Maximum
NN_pmaxub,              // Packed Unsigned Integer Byte Maximum
NN_pminsw,              // Packed Signed Integer Word Minimum
NN_pminub,              // Packed Unsigned Integer Byte Minimum
NN_pmovmskb,            // Move Byte Mask to Integer
NN_pmulhuw,             // Packed Multiply High Unsigned
NN_psadbw,              // Packed Sum of Absolute Differences
NN_pshufw,              // Packed Shuffle Word
NN_maskmovq,            // Byte Mask write
NN_movntps,             // Move Aligned Four Packed Single-FP Non Temporal
NN_movntq,              // Move 64 Bits Non Temporal
NN_prefetcht0,          // Prefetch to all cache levels
NN_prefetcht1,          // Prefetch to all cache levels
NN_prefetcht2,          // Prefetch to L2 cache
NN_prefetchnta,         // Prefetch to L1 cache
NN_sfence,              // Store Fence

// Pentium III Pseudo instructions

NN_cmpeqps,             // Packed Single-FP Compare EQ
NN_cmpltps,             // Packed Single-FP Compare LT
NN_cmpleps,             // Packed Single-FP Compare LE
NN_cmpunordps,          // Packed Single-FP Compare UNORD
NN_cmpneqps,            // Packed Single-FP Compare NOT EQ
NN_cmpnltps,            // Packed Single-FP Compare NOT LT
NN_cmpnleps,            // Packed Single-FP Compare NOT LE
NN_cmpordps,            // Packed Single-FP Compare ORDERED
NN_cmpeqss,             // Scalar Single-FP Compare EQ
NN_cmpltss,             // Scalar Single-FP Compare LT
NN_cmpless,             // Scalar Single-FP Compare LE
NN_cmpunordss,          // Scalar Single-FP Compare UNORD
NN_cmpneqss,            // Scalar Single-FP Compare NOT EQ
NN_cmpnltss,            // Scalar Single-FP Compare NOT LT
NN_cmpnless,            // Scalar Single-FP Compare NOT LE
NN_cmpordss,            // Scalar Single-FP Compare ORDERED

NN_last,

    };

/*
 *      Interactive disassembler (IDA).
 *      Version 2.09
 *      Copyright (c) 1990-93 by Ilfak Guilfanov. (2:5020/209@fidonet)
 *      ALL RIGHTS RESERVED.
 *
 */


extern instruc_t far Instructions[];

enum nameNum {

I5_null = 0,            // Unknown Operation

//
//      Intel 8080-8085 instructions
//

I5_aci,
I5_adc,
I5_add,
I5_adi,
I5_ana,
I5_ani,
I5_call,
I5_cnz,
I5_cz,
I5_cnc,
I5_cc,
I5_cpo,
I5_cpe,
I5_cp,
I5_cm,
I5_cmc,
I5_cmp,
I5_cpi,
I5_cma,
I5_daa,
I5_dad,
I5_dcr,
I5_dcx,
I5_di,
I5_ei,
I5_halt,
I5_in,
I5_inr,
I5_inx,
I5_jmp,
I5_jnz,
I5_jz,
I5_jnc,
I5_jc,
I5_jpo,
I5_jpe,
I5_jp,
I5_jm,
I5_lda,
I5_ldax,
I5_lhld,
I5_lxi,
I5_mov,
I5_mvi,
I5_nop,
I5_ora,
I5_ori,
I5_out,
I5_pchl,
I5_pop,
I5_push,
I5_ret,
I5_rnz,
I5_rz,
I5_rnc,
I5_rc,
I5_rpo,
I5_rpe,
I5_rp,
I5_rm,
I5_ral,
I5_rlc,
I5_rar,
I5_rrc,
I5_rst,
I5_sbb,
I5_sbi,
I5_stc,
I5_sphl,
I5_sta,
I5_stax,
I5_shld,
I5_sui,
I5_sub,
I5_xra,
I5_xri,
I5_xchg,
I5_xthl,

I5_rim,
I5_sim,

//
//      Z80 extnesions
//

Z80_and,
Z80_bit,
Z80_call,
Z80_ccf,
Z80_cp,
Z80_cpd,
Z80_cpdr,
Z80_cpi,
Z80_cpir,
Z80_cpl,
Z80_dec,
Z80_djnz,
Z80_ex,
Z80_exx,
Z80_halt,
Z80_im,
Z80_inc,
Z80_ind,
Z80_indr,
Z80_ini,
Z80_inir,
Z80_jp,
Z80_jr,
Z80_ld,
Z80_ldd,
Z80_lddr,
Z80_ldi,
Z80_ldir,
Z80_neg,
Z80_or,
Z80_otdr,
Z80_otir,
Z80_outd,
Z80_outi,
Z80_res,
Z80_ret,
Z80_reti,
Z80_retn,
Z80_rl,
Z80_rla,
Z80_rlc,
Z80_rlca,
Z80_rld,
Z80_rr,
Z80_rra,
Z80_rrc,
Z80_rrca,
Z80_rrd,
Z80_scf,
Z80_sbc,
Z80_set,
Z80_sla,
Z80_sra,
Z80_srl,
Z80_xor,
Z80_inp,                // undocumented
Z80_outp,               // undocumented
Z80_srr,                // undocumented

//
//      HD64180 extensions
//

HD_in0,
HD_mlt,
HD_otim,
HD_otimr,
HD_otdm,
HD_otdmr,
HD_out0,
HD_slp,
HD_tst,
HD_tstio,

//
//      A80 special instructions
//

A80_lbcd,
A80_lded,
A80_lspd,
A80_lixd,
A80_liyd,
A80_sbcd,
A80_sded,
A80_sspd,
A80_sixd,
A80_siyd,
A80_xtix,
A80_xtiy,
A80_spix,
A80_spiy,
A80_pcix,
A80_pciy,
A80_mvra,
A80_mvia,
A80_mvar,
A80_mvai,
A80_addix,
A80_addiy,
A80_addc,
A80_addcix,
A80_addciy,
A80_subc,
A80_subcix,
A80_subciy,
A80_jrc,
A80_jrnc,
A80_jrz,
A80_jrnz,
A80_cmpi,
A80_cmpd,
A80_im0,
A80_im1,
A80_im2,
A80_otd,
A80_oti,

I5_last,

    };

/*
 *      Interactive disassembler (IDA).
 *      Version 3.05
 *      Copyright (c) 1990-95 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              FIDO:   2:5020/209
 *                              E-mail: ig@estar.msk.su
 *
 */


extern instruc_t Instructions[];

enum nameNum {

I860_null = 0,          // Unknown Operation

//
//      Intel 860 XP instructions
//

I860_adds,
I860_addu,
I860_and,
I860_andh,
I860_andnot,
I860_andnoth,
I860_bc,
I860_bc_t,
I860_bla,
I860_bnc,
I860_bnc_t,
I860_br,
I860_bri,
I860_bte,
I860_btne,
I860_call,
I860_calli,
I860_fadd,
I860_faddp,
I860_faddz,
I860_famov,
I860_fiadd,
I860_fisub,
I860_fix,
I860_fld,
I860_flush,
I860_fmlow_dd,
I860_fmul,
I860_form,
I860_frcp,
I860_frsqr,
I860_fst,
I860_fsub,
I860_ftrunc,
I860_fxfr,
I860_fzchkl,
I860_fzchks,
I860_introvr,
I860_ixfr,
I860_ld_c,
I860_ld,
I860_ldint,
I860_ldio,
I860_lock,
I860_or,
I860_orh,
I860_pfadd,
I860_pfaddp,
I860_pfaddz,
I860_pfamov,
I860_pfeq,
I860_pfgt,
I860_pfiadd,
I860_pfisub,
I860_pfix,
I860_pfld,
I860_pfle,
I860_pfmul,
I860_pfmul3_dd,
I860_pform,
I860_pfsub,
I860_pftrunc,
I860_pfzchkl,
I860_pfzchks,
I860_pst_d,
I860_scyc,
I860_shl,
I860_shr,
I860_shra,
I860_shrd,
I860_st_c,
I860_st,
I860_stio,
I860_subs,
I860_subu,
I860_trap,
I860_unlock,
I860_xor,
I860_xorh,
//
// iNTEL 860 XP Pipelined F-P instructions
//
I860_r2p1,
I860_r2pt,
I860_r2ap1,
I860_r2apt,
I860_i2p1,
I860_i2pt,
I860_i2ap1,
I860_i2apt,
I860_rat1p2,
I860_m12apm,
I860_ra1p2,
I860_m12ttpa,
I860_iat1p2,
I860_m12tpm,
I860_ia1p2,
I860_m12tpa,
I860_r2s1,
I860_r2st,
I860_r2as1,
I860_r2ast,
I860_i2s1,
I860_i2st,
I860_i2as1,
I860_i2ast,
I860_rat1s2,
I860_m12asm,
I860_ra1s2,
I860_m12ttsa,
I860_iat1s2,
I860_m12tsm,
I860_ia1s2,
I860_m12tsa,
I860_mr2p1,
I860_mr2pt,
I860_mr2mp1,
I860_mr2mpt,
I860_mi2p1,
I860_mi2pt,
I860_mi2mp1,
I860_mi2mpt,
I860_mrmt1p2,
I860_mm12mpm,
I860_mrm1p2,
I860_mm12ttpm,
I860_mimt1p2,
I860_mm12tpm,
I860_mim1p2,
I860_mr2s1,
I860_mr2st,
I860_mr2ms1,
I860_mr2mst,
I860_mi2s1,
I860_mi2st,
I860_mi2ms1,
I860_mi2mst,
I860_mrmt1s2,
I860_mm12msm,
I860_mrm1s2,
I860_mm12ttsm,
I860_mimt1s2,
I860_mm12tsm,
I860_mim1s2,

I860_last,

    };

/*
 *      Interactive disassembler (IDA).
 *      Copyright (c) 1990-98 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              E-mail: ig@estar.msk.su, ig@datarescue.com
 *                              FIDO:   2:5020/209
 *
 */


extern instruc_t Instructions[];

enum nameNum {

I51_null = 0,   // Unknown Operation

I51_acall,      // Absolute Call
I51_add,        // Add Second Operand to Acc
I51_addc,       // Add Second Operand to Acc with carry
I51_ajmp,       // Absolute Jump
I51_anl,        // Logical AND (op1 &= op2)
I51_cjne,       // Compare Operands and JNE
I51_clr,        // Clear Operand (0)
I51_cpl,        // Complement Operand
I51_da,         // Decimal Adjust Accumulator
I51_dec,        // Decrement Operand
I51_div,        // Divide Acc by B
I51_djnz,       // Decrement Operand and JNZ
I51_inc,        // Increment Operand
I51_jb,         // Jump if Bit is set
I51_jbc,        // Jump if Bit is set & clear Bit
I51_jc,         // Jump if Carry is set
I51_jmp,        // Jump indirect relative to Data Pointer
I51_jnb,        // Jump if Bit is clear
I51_jnc,        // Jump if Carry is clear
I51_jnz,        // Jump if Acc is not zero
I51_jz,         // Jump if Acc is zero
I51_lcall,      // Long Subroutine Call
I51_ljmp,       // Long Jump
I51_mov,        // Move (Op1 <- Op2)
I51_movc,       // Move code byte relative to second op to Acc
I51_movx,       // Move from/to external RAM
I51_mul,        // Multiply Acc by B
I51_nop,        // No operation
I51_orl,        // Logical OR (op1 |= op2)
I51_pop,        // Pop  from Stack and put in Direct RAM
I51_push,       // Push from Direct RAM to Stack
I51_ret,        // Return from subroutine
I51_reti,       // Return from Interrupt
I51_rl,         // Rotate Acc left
I51_rlc,        // Rotate Acc left through Carry
I51_rr,         // Rotate Acc right
I51_rrc,        // Rotate Acc right through Carry
I51_setb,       // Set Direct Bit
I51_sjmp,       // Short jump
I51_subb,       // Subtract Second Operand from Acc with Borrow
I51_swap,       // Swap nibbles of Acc
I51_xch,        // Exchange Operands
I51_xchd,       // Exchange Digit in Acc with Indirect RAM
I51_xrl,        // Exclusive OR (op1 ^= op2)

// 80251 instructions

I51_jsle,       // Jump if less than or equal (signed)
I51_jsg,        // Jump if greater than (signed)
I51_jle,        // Jump if less than or equal
I51_jg,         // Jump if greater than
I51_jsl,        // Jump if less than (signed)
I51_jsge,       // Jump if greater than or equal (signed)
I51_je,         // Jump if equal
I51_jne,        // Jump if not equal
I51_trap,       // Trap
I51_ejmp,       // Extended jump
I51_ecall,      // Extended call
I51_eret,       // Extended return 
I51_movh,       // Move immediate 16-bit data to the high word of a dword (double-word) register
I51_movz,       // Move 8-bit register to 16-bit register with zero extension
I51_movs,       // Move 8-bit register to 16-bit register with sign extension
I51_srl,        // Shift logical right by 1 bit
I51_sra,        // Shift arithmetic right by 1 bit
I51_sll,        // Shift logical left by 1 bit
I51_sub,        // Subtract
I51_cmp,        // Compare

I51_last,

    };

/*
 *      Interactive disassembler (IDA).
 *      Version 3.05
 *      Copyright (c) 1990-95 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              FIDO:   2:5020/209
 *                              E-mail: ig@estar.msk.su
 *
 */


extern instruc_t Instructions[];

enum nameNum {

TMS_null = 0,   // Unknown Operation
TMS_abs,        // Absolute value of Acc
TMS_adcb,       // Add ACCB to Acc With Carry
TMS_add,        // Add to Acc
TMS_addb,       // Add ACCB to Acc
TMS_addc,       // Add to Acc With Carry
TMS_adds,       // Add to Acc With Sign-Extension Suppressed
TMS_addt,       // Add to Acc With Shift Specified by TREG1
TMS_adrk,       // Add to Aux Register With Short Immediate
TMS_and,        // AND With Acc
TMS_andb,       // AND ACCD With Acc
TMS_apac,       // Add P Register to Acc
TMS_apl,        // AND Data Memory Value With DBMR
TMS_apl2,       // AND Data Memory Value With Long Constant
TMS_b,          // Branch Unconditionally
TMS_bacc,       // Branch to Location (Acc)
TMS_baccd,      // Branch to Location (Acc) Delayed
TMS_banz,       // Branch on Aux Register Not Zero
TMS_banzd,      // Branch on Aux Register Not Zero Delayed
TMS_bcnd,       // Branch Conditionally
TMS_bcndd,      // Branch Conditionally Delayed
TMS_bd,         // Branch Unconditionally Delayed
TMS_bit,        // Test Bit
TMS_bitt,       // Test Bit Specified by TREG2
TMS_bldd,       // Block Move From Data Memory to Data Memory
TMS_bldp,       // Block Move From Data Memory to Program Memory
TMS_blpd,       // Block Move From Program Memory to Data Memory
TMS_bsar,       // Barrel Shift
TMS_cala,       // Call Subroutine at (Acc)
TMS_calad,      // Call Subroutine at (Acc) Delayed
TMS_call,       // Call Unconditionally
TMS_calld,      // Call Unconditionally Delayed
TMS_cc,         // Call Conditionally
TMS_ccd,        // Call Conditionally Delayed
TMS_clrc,       // Clear Control Bit
TMS_cmpl,       // Complement Acc
TMS_cmpr,       // Compare Aux Register With ARCR
TMS_cpl,        // Compare DBMR With Data Value
TMS_cpl2,       // Compare Long Immediate With Data Value
TMS_crgt,       // Test for Acc Greater Than ACCB
TMS_crlt,       // Test for Acc Smaller Than ACCB
TMS_dmov,       // Data Move in Data Memory
TMS_estop,      // Emulator Stop
TMS_exar,       // Exchange ACCB With Acc
TMS_idle,       // Idle Until Interrupt
TMS_idle2,      // Idle Until Interrupt - Low Power Mode
TMS_in,         // Input Data From Port
TMS_intr,       // Soft Interrupt
TMS_lacb,       // Load Acc With ACCB
TMS_lacc,       // Load Acc With Shift
TMS_lacl,       // Load Low Acc and Clear High Acc
TMS_lact,       // Load Acc With Shift Specified by TREG1
TMS_lamm,       // Load Acc With Memory-Mapped Register
TMS_lar,        // Load Aux Register
TMS_ldp,        // Load Data Memory Pointer
TMS_lmmr,       // Load Memory-Mapped Register
TMS_lph,        // Load Product High Register
TMS_lst,        // Load Status Register
TMS_lt,         // Load TREG0
TMS_lta,        // Load TREG0 and Accumulate Previous Product
TMS_ltd,        // Load TREG0,Accumulate Previous Product and Move Data
TMS_ltp,        // Load TREG0 and Store P -> Acc
TMS_lts,        // Load TREG0 and Subtract Previous Product
TMS_mac,        // Multiply and Accumulate
TMS_macd,       // Multiply and Accumulate With Data Move
TMS_madd,       // Multiply and Accumulate With Data Move and Dynamic Addressing
TMS_mads,       // Multiply and Accumulate With Dynamic Addressing
TMS_mar,        // Modify Aux Register
TMS_mpy,        // Multiply
TMS_mpya,       // Multiply and Accumulate Previous Product
TMS_mpys,       // Multiply and Subtract Previous Product
TMS_mpyu,       // Multiply Unsigned
TMS_neg,        // Negate Acc
TMS_nmi,        // Nonmaskable Interrupt
TMS_nop,        // No Operation
TMS_norm,       // Normalize Contents of Acc
TMS_opl,        // OR With DBMS
TMS_opl2,       // OR With Long Immediate
TMS_or,         // OR With Acc
TMS_orb,        // OR ACCB With Accumulator
TMS_out,        // Out Data to Port
TMS_pac,        // Load Acc <- P
TMS_pop,        // Pop Top of Stack to Low Acc
TMS_popd,       // Pop Top of Stack to Data Memory
TMS_pshd,       // Push Data Memory Value Onto Stack
TMS_push,       // Push Low Acc Onto Stack
TMS_ret,        // Return From Subroutine
TMS_retc,       // Return Conditionally
TMS_retcd,      // Return Conditionally Delayed
TMS_retd,       // Return From Subroutine Delayed
TMS_rete,       // Enable Interrupts and Return From Interrupt
TMS_reti,       // Return From Interrupt
TMS_rol,        // Rotate Acc Left
TMS_rolb,       // Rotate ACCB and Acc Left
TMS_ror,        // Rotate Acc Right
TMS_rorb,       // Rotate ACCB and Acc Right
TMS_rpt,        // Repeat Next Instruction
TMS_rptb,       // Repeat Block
TMS_rptz,       // Repeat Preceded by Clearing Acc and P
TMS_sacb,       // Store Acc in ACCB
TMS_sach,       // Store High Acc With Shift
TMS_sacl,       // Store Low Acc With Shift
TMS_samm,       // Store Acc in Memory-Mapped Register
TMS_sar,        // Store Aux Register
TMS_sath,       // Barrel Shift Acc as Specified by TREG1(4)
TMS_satl,       // Barrel Shift Acc as Specified by TREG1(3-0)
TMS_sbb,        // Subtract ACCB From Acc
TMS_sbbb,       // Subtract ACCB From Acc With Borrow
TMS_sbrk,       // Subtract From Aux Register Short Immediate
TMS_setc,       // Set Control Bit
TMS_sfl,        // Shift Acc Left
TMS_sflb,       // Shift ACCB and Acc Left
TMS_sfr,        // Shift Acc Right
TMS_sfrb,       // Shift ACCB and Acc Right
TMS_smmr,       // Store Memory-Mapped Register
TMS_spac,       // Subtract P From Acc
TMS_sph,        // Store High P Register
TMS_spl,        // Store Low P Register
TMS_splk,       // Store Parallel Long Immediate
TMS_spm,        // Store ACCB and Acc Right
TMS_sqra,       // Square and Accumulate Previous Product
TMS_sqrs,       // Square and Subtract Previous Product
TMS_sst,        // Store Status Register
TMS_sub,        // Subtract From Acc
TMS_subb,       // Subtract From Acc With Borrow
TMS_subc,       // Conditional Subtract
TMS_subs,       // Subtract From Acc With Sign-Extension Suppressed
TMS_subt,       // Subtract From Acc With Shift Specified by TREG1
TMS_tblr,       // Table Read
TMS_tblw,       // Table Write
TMS_trap,       // Software Interrupt
TMS_xc,         // Execute Conditionally
TMS_xor,        // Exclusive-OR With Acc
TMS_xorb,       // Exclusive-OR of ACCB With Acc
TMS_xpl,        // Exclusive-OR Data Memory Value
TMS_xpl2,       // Exclusive-OR Data Memory Value
TMS_zalr,       // Zero Low Acc Load High Acc With Rounding
TMS_zap,        // Zero Acc and P
TMS_zpr,        // Zero P Register

//
//      TMS320C2x instructions
//

TMS2_abs,               // Absolute value of accumulator
TMS2_add,               // Add to accumulator with shift
TMS2_addc,              // Add to accumulator with carry
TMS2_addh,              // Add to high accumulator
TMS2_addk,              // Add to accumulator short immediate
TMS2_adds,              // Add to low accumulator with sign extension suppressed
TMS2_addt,              // Add to accumulator with shift specified by T register
TMS2_adlk,              // Add to accumulator long immediate with shift
TMS2_adrk,              // Add to auxiliary register short immediate
TMS2_and,               // And with accumulator
TMS2_andk,              // And immediate with accumulator with shift
TMS2_apac,              // App P register to accumulator
TMS2_b,                 // Branch unconditionally
TMS2_bacc,              // Branch to address specified by accumulator
TMS2_banz,              // Bnrach on auxiliary register not zero
TMS2_bbnz,              // Branch if tc bit != 0
TMS2_bbz,               // Branch if tc bit = 0
TMS2_bc,                // Branch on carry
TMS2_bgez,              // Branch if accumulator >= 0
TMS2_bgz,               // Branch if accumulator > 0
TMS2_bioz,              // Branch on i/o status = 0
TMS2_bit,               // Test bit
TMS2_bitt,              // Test bit specifed by T register
TMS2_blez,              // Branch if accumulator <= 0
TMS2_blkd,              // Block move from data memory to data memory
TMS2_blkp,              // Block move from program memory to data memory
TMS2_blz,               // Branch if accumulator < 0
TMS2_bnc,               // Branch on no carry
TMS2_bnv,               // Branch if no overflow
TMS2_bnz,               // Branch if accumulator != 0
TMS2_bv,                // Branch on overflow
TMS2_bz,                // Branch if accumulator = 0
TMS2_cala,              // Call subroutine indirect
TMS2_call,              // Call subroutine
TMS2_cmpl,              // Complement accumulator
TMS2_cmpr,              // Compare auxiliary register with auxiliary register ar0
TMS2_cnfd,              // Configure block as data memory
TMS2_cnfp,              // Configure block as program memory
TMS2_conf,              // Configure block as data/program memory
TMS2_dint,              // Disable interrupt
TMS2_dmov,              // Data move in data memory
TMS2_eint,              // Enable interrupt
TMS2_fort,              // Format serial port registers
TMS2_idle,              // Idle until interrupt
TMS2_in,                // Input data from port
TMS2_lac,               // Load accumulator with shift
TMS2_lack,              // Load accumulator short immediate
TMS2_lact,              // Load accumulator with shift specified by T register
TMS2_lalk,              // Load accumulator long immediate with shift
TMS2_lar,               // Load auxiliary register
TMS2_lark,              // Load auxiliary register short immediate
TMS2_larp,              // Load auxiliary register pointer
TMS2_ldp,               // Load data memory page pointer
TMS2_ldpk,              // Load data memory page pointer immediate
TMS2_lph,               // Load high P register
TMS2_lrlk,              // Load auxiliary register long immediate
TMS2_lst,               // Load status register ST0
TMS2_lst1,              // Load status register ST1
TMS2_lt,                // Load T register
TMS2_lta,               // Load T register and accumulate previous product
TMS2_ltd,               // Load T register, accumulate previous product and move data
TMS2_ltp,               // Load T register and store P register in accumulator
TMS2_lts,               // Load T register and subtract previous product
TMS2_mac,               // Multiply and accumulate
TMS2_macd,              // Multiply and accumulate with data move
TMS2_mar,               // Modify auxiliary register
TMS2_mpy,               // Multiply (with T register, store product in P register)
TMS2_mpya,              // Multiply and accumulate previous product
TMS2_mpyk,              // Multiply immediate
TMS2_mpys,              // Multiply and subtract previous product
TMS2_mpyu,              // Multiply unsigned
TMS2_neg,               // Negate accumulator
TMS2_nop,               // No operation
TMS2_norm,              // Normalize contents of accumulator
TMS2_or,                // Or with accumulator
TMS2_ork,               // Or immediate with accumulator with shift
TMS2_out,               // Output data to port
TMS2_pac,               // Load accumulator with P register
TMS2_pop,               // Pop top of stack to low accumulator
TMS2_popd,              // Pop top of stack to data memory
TMS2_pshd,              // Push data memory value onto stack
TMS2_push,              // Push low accumulator onto stack
TMS2_rc,                // Reset carry bit
TMS2_ret,               // Return from subroutine
TMS2_rfsm,              // Reset serial port frame synchronization mode
TMS2_rhm,               // Reset hold mode
TMS2_rol,               // Rotate accumulator left
TMS2_ror,               // Rotate acuumulator right
TMS2_rovm,              // Reset overflow mode
TMS2_rpt,               // Repeat instruction as specified by data memory value
TMS2_rptk,              // Repeat instruction as specified by immediate value
TMS2_rsxm,              // Reset sign extension mode
TMS2_rtc,               // Reset test/control flag
TMS2_rtxm,              // Reset serial port transmit mode
TMS2_rxf,               // Reset external flag
TMS2_sach,              // Store high accumulator with shift
TMS2_sacl,              // Store low accumulator with shift
TMS2_sar,               // Store auxiliary register
TMS2_sblk,              // Subtract from accumulator long immediate with shift
TMS2_sbrk,              // Subtract from auxiliary register short immediate
TMS2_sc,                // Set carry bit
TMS2_sfl,               // Shift accumulator left
TMS2_sfr,               // Shift accumulator right
TMS2_sfsm,              // Set serial port frame synchronization mode
TMS2_shm,               // Set hold mode
TMS2_sovm,              // Set overflow mode
TMS2_spac,              // Subtract P register from accumulator
TMS2_sph,               // Store high P register
TMS2_spl,               // Store low P register
TMS2_spm,               // Set P register output shift mode
TMS2_sqra,              // Square and accumulate
TMS2_sqrs,              // Square and subtract previous product
TMS2_sst,               // Store status register ST0
TMS2_sst1,              // Store status register ST1
TMS2_ssxm,              // Set sign extension mode
TMS2_stc,               // Set test/control flag
TMS2_stxm,              // Set serial port transmit mode
TMS2_sub,               // Subtract from accumulator with shift
TMS2_subb,              // Subtract from accumulator with borrow
TMS2_subc,              // Conditional subtract
TMS2_subh,              // Subtract from high accumulator
TMS2_subk,              // Subtract from accumulator shoft immediate
TMS2_subs,              // Subtract from low accumulator with sign extension suppressed
TMS2_subt,              // Subtract from accumulator with shift specified by T register
TMS2_sxf,               // Set external flag
TMS2_tblr,              // Table read
TMS2_tblw,              // Table write
TMS2_trap,              // Software interrupt
TMS2_xor,               // Exclusive or with accumulator
TMS2_xork,              // Exclusive or immediate with accumulator with shift
TMS2_zac,               // Zero accumulator
TMS2_zalh,              // Zero low accumulator and load high accumulator
TMS2_zalr,              // Zero low accumulator and load high accumulator with rounding
TMS2_zals,              // Zero low accumulator and load high accumulator with sign extension suppressed

TMS_last,

    };

/*
 *      Interactive disassembler (IDA).
 *      Version 3.05
 *      Copyright (c) 1990-95 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              FIDO:   2:5020/209
 *                              E-mail: ig@estar.msk.su
 *
 */


extern instruc_t Instructions[];

enum nameNum {

M65_null = 0,           // Unknown Operation

// NMOS instructions

M65_adc,                // A <- (A) + M + C
M65_anc,                // A <- A /\ M, C <- ~A7
M65_and,                // A <- (A) /\ M
M65_ane,                // M <-[(A)\/$EE] /\ (X)/\(M)
M65_arr,                // A <- [(A /\ M) >> 1]
M65_asl,                // C <- A7, A <- (A) << 1
M65_asr,                // A <- [(A /\ M) >> 1]
M65_bcc,                // if C=0, PC = PC + offset
M65_bcs,                // if C=1, PC = PC + offset
M65_beq,                // if Z=1, PC = PC + offset
M65_bit,                // Z <- ~(A /\ M) N<-M7 V<-M6
M65_bmi,                // if N=1, PC = PC + offset
M65_bne,                // if Z=0, PC = PC + offset
M65_bpl,                // if N=0, PC = PC + offset
M65_brk,                // Stack <- PC, PC <- ($fffe)
M65_bvc,                // if V=0, PC = PC + offset
M65_bvs,                // if V=1, PC = PC + offset
M65_clc,                // C <- 0
M65_cld,                // D <- 0
M65_cli,                // I <- 0
M65_clv,                // V <- 0
M65_cmp,                // (A - M) -> NZC
M65_cpx,                // (X - M) -> NZC
M65_cpy,                // (Y - M) -> NZC
M65_dcp,                // M <- (M)-1, (A-M) -> NZC
M65_dec,                // M <- (M) - 1
M65_dex,                // X <- (X) - 1
M65_dey,                // Y <- (Y) - 1
M65_eor,                // A <- (A) \-/ M
M65_inc,                // M <- (M) + 1
M65_inx,                // X <- (X) +1
M65_iny,                // Y <- (Y) + 1
M65_isb,                // M <- (M) - 1,A <- (A)-M-~C
M65_jmp,                // PC <- Address
M65_jmpi,               // (PC <- Address)
M65_jsr,                // Stack <- PC, PC <- Address
M65_lae,                // X,S,A <- (S /\ M)
M65_lax,                // A <- M, X <- M
M65_lda,                // A <- M
M65_ldx,                // X <- M
M65_ldy,                // Y <- M
M65_lsr,                // C <- A0, A <- (A) >> 1
M65_lxa,                // X04 <- (X04) /\ M04, A04 <- (A04) /\ M04
M65_nop,                // [no operation]
M65_ora,                // A <- (A) V M
M65_pha,                // Stack <- (A)
M65_php,                // Stack <- (P)
M65_pla,                // A <- (Stack)
M65_plp,                // A <- (Stack)
M65_rla,                // M <- (M << 1) /\ (A)
M65_rol,                // C <- A7 & A <- A << 1 + C
M65_ror,                // C<-A0 & A<- (A7=C + A>>1)
M65_rra,                // M <- (M >> 1) + (A) + C
M65_rti,                // P <- (Stack), PC <-(Stack)
M65_rts,                // PC <- (Stack)
M65_sax,                // M <- (A) /\ (X)
M65_sbc,                // A <- (A) - M - ~C
M65_sbx,                // X <- (X)/\(A) - M
M65_sec,                // C <- 1
M65_sed,                // D <- 1
M65_sei,                // I <- 1
M65_sha,                // M <- (A) /\ (X) /\ (PCH+1)
M65_shs,                // X <- (A) /\ (X), S <- (X), M <- (X) /\ (PCH+1)
M65_shx,                // M <- (X) /\ (PCH+1)
M65_shy,                // M <- (Y) /\ (PCH+1)
M65_slo,                // M <- (M >> 1) + A + C
M65_sre,                // M <- (M >> 1) \-/ A
M65_sta,                // M <- (A)
M65_stx,                // M <- (X)
M65_sty,                // M <- (Y)
M65_tax,                // X <- (A)
M65_tay,                // Y <- (A)
M65_tsx,                // X <- (S)
M65_txa,                // A <- (X)
M65_txs,                // S <- (X)
M65_tya,                // A <- (Y)

// CMOS instructions

M65_bbr0,               // Branch if bit 0 reset
M65_bbr1,               // Branch if bit 1 reset
M65_bbr2,               // Branch if bit 2 reset
M65_bbr3,               // Branch if bit 3 reset
M65_bbr4,               // Branch if bit 4 reset
M65_bbr5,               // Branch if bit 5 reset
M65_bbr6,               // Branch if bit 6 reset
M65_bbr7,               // Branch if bit 7 reset
M65_bbs0,               // Branch if bit 0 set
M65_bbs1,               // Branch if bit 1 set
M65_bbs2,               // Branch if bit 2 set
M65_bbs3,               // Branch if bit 3 set
M65_bbs4,               // Branch if bit 4 set
M65_bbs5,               // Branch if bit 5 set
M65_bbs6,               // Branch if bit 6 set
M65_bbs7,               // Branch if bit 7 set
M65_rmb0,               // Reset memory bit 0
M65_rmb1,               // Reset memory bit 1
M65_rmb2,               // Reset memory bit 2
M65_rmb3,               // Reset memory bit 3
M65_rmb4,               // Reset memory bit 4
M65_rmb5,               // Reset memory bit 5
M65_rmb6,               // Reset memory bit 6
M65_rmb7,               // Reset memory bit 7
M65_smb0,               // Set memory bit 0
M65_smb1,               // Set memory bit 1
M65_smb2,               // Set memory bit 2
M65_smb3,               // Set memory bit 3
M65_smb4,               // Set memory bit 4
M65_smb5,               // Set memory bit 5
M65_smb6,               // Set memory bit 6
M65_smb7,               // Set memory bit 7
M65_stz,                // Store zero
M65_tsb,                // Test and set bits
M65_trb,                // Test and reset bits
M65_phy,                // Push Y register
M65_ply,                // Pull Y register
M65_phx,                // Push X register
M65_plx,                // Pull X register
M65_bra,                // Branch always

M65_last,

    };

/*
 *      Interactive disassembler (IDA).
 *      Version 3.05
 *      Copyright (c) 1990-95 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              FIDO:   2:5020/209
 *                              E-mail: ig@estar.msk.su
 *
 */


extern instruc_t Instructions[];

enum nameNum {

mc_null = 0,           // Unknown Operation

mc_abcd,       // summa with BCD correction
mc_add,        // summa with Dn
mc_adda,       // summa with An
mc_addi,       // summa with immediate
mc_addq,       // -"-
mc_addx,       // summa 2 reg and const
mc_and,        // logical and
mc_andi,       // logical and with immediate
mc_asl,        // shift by count
mc_asr,        // -"-
mc_b,          // branch if cond code
mc_bchg,       // bit chang
mc_bclr,       // bit clear
mc_bftst,     // bit field test
mc_bfchg,      // bit field change
mc_bfclr,      // bit field set in 0
mc_bfset,      // bit field set in 1
mc_bfextu,     // bit field extract (unsigned)
mc_bfexts,     // bit field extract (signed)
mc_bfffo,      // bit field offset
mc_bfins,      // bit field include
mc_bgnd,       // CPU32- enter backgound mode
mc_bkpt,       // disable TRAP at any cycles
mc_bra,        // branch
mc_bset,       // bit set
mc_bsr,        // relative call
mc_btst,       // bit test
mc_callm,      // call module [descrtiptor] (020)
mc_cas,        // compare and swap
mc_cas2,       // -"-
mc_chk,        // compare and trap
mc_chk2,       // -"-
mc_cinv,       // invalidate cache
mc_clr,        // clear data
mc_cmp,        // compare data
mc_cmp2,       // -"-
mc_cmpa,       // compare address
mc_cmpi,       // compare immediate
mc_cmpm,       // compare memmory
mc_cpush,      // invalidate cache
mc_db,         // (djnz) if cond code
mc_divs,       // sign divide
mc_divsl,      // -"-
mc_divu,       // unsign didide
mc_divul,      // -"-
mc_eor,        // logical xor
mc_eori,       // logical xor with immediate
mc_exg,        // exchange registers
mc_ext,        // analog cwd
mc_extb,       // analog cwq
mc_fabs,       // FP abs
mc_facos,      // FP acos
mc_fadd,       // FP add
mc_fasin,      // FP asin
mc_fatan,      // FP atan
mc_fatanh,     // FP atanh
mc_fb,         // fBcc
mc_fcmp,       // FP cmp
mc_fcos,       // FP cos
mc_fcosh,      // FP cosh
mc_fdabs,      // FP abs double rounded
mc_fdadd,      // FP add
mc_fdb,        // fDBcc
mc_fddiv,      // FP div double rounded
mc_fdiv,       // FP div
mc_fdmove,     // FP mov double rounded
mc_fdmul,      // FP mul double rounded
mc_fdneg,      // FP neg double rounded
mc_fdsqrt,     // FP sqrt double rounded
mc_fdsub,      // FP sub double rounded
mc_fetox,      // FP e**x
mc_fetoxm1,    // FP e**x-1
mc_fgetexp,    // FP extract exponent
mc_fgetman,    // FP extract mantissa
mc_fint,       // FP get integer part
mc_fintrz,     // FP get integer part by round
mc_flog2,      // FP log[2]
mc_flog10,     // FP log[10]
mc_flogn,      // FP log[e]
mc_flognp1,    // FP log[e] x+1
mc_fmod,       // FP mod
mc_fmove,      // move float
mc_fmovecr,    // move floating const
mc_fmovem,     // move float register list
mc_fmul,       // FM mul
mc_fneg,       // FP neg
mc_fnop,       // float nop
mc_frem,       // FP rem
mc_frestore,   // restore status
mc_fs,         // fScc
mc_fsabs,      // FP abs single rounded
mc_fsadd,      // FP add single rounded
mc_fsave,      // Fsave status
mc_fscale,     // FP *2**x
mc_fsdiv,      // FP div single rounded
mc_fsgldiv,    // FP single div
mc_fsglmul,    // FP single mul
mc_fsin,       // FP sin
mc_fsincos,    // FP sin & cos
mc_fsinh,      // FP sinh
mc_fsmove,     // FP mov single rounded
mc_fsmul,      // FP mul single rounded
mc_fsneg,      // FP neg single rounded
mc_fsqrt,      // FP sqrt
mc_fssqrt,     // FP sqrt single rounded
mc_fssub,      // FP sub single rounded
mc_fsub,       // FP sub
mc_ftan,       // FP tan
mc_ftanh,      // FP tanh
mc_ftentox,    // FP 10**x
mc_ftrap,      // fTRAPcc
mc_ftst,       // FP tst
mc_ftwotox,    // FP 2**x
mc_illegal,    // trap to vector
mc_jmp,        // absolute Jmp
mc_jsr,        // absoluten jsr
mc_lea,        // load effective address
mc_link,       // change sp context
mc_lpstop,     // cpu32 - stop
mc_lsl,        // logical shift
mc_lsr,        // -"-
mc_move,       // move memmory
mc_move16,     // move 16 byte
mc_movea,      // move move with address reg
mc_movec,      // move from/to control register
mc_movem,      // move register list
mc_movep,      // move with data register
mc_moveq,      // move with immediate
mc_moves,      // mtpd/mfpd
mc_muls,       // sign multiplication
mc_mulu,       // unsign multiplication
mc_nbcd,       // negative with BCD correct
mc_neg,        // negative
mc_negx,       // negative with immediate
mc_nop,        // null operation
mc_not,        // logical not
mc_or,         // logical or
mc_ori,        // logical or with immediate
mc_pack,       // UNP(bcd)+adj -> PACK(bcd)
mc_pea,        // lea into stack
mc_pb,         // 68851 pbcc
mc_pdb,        // 68851 pdbcc
mc_pflush,     // invalidate cache
mc_pflushr,    // 68851 load root entry
mc_ploadr,     // 68851
mc_ploadw,     // 68851
mc_pmove,      // move MMU register
mc_prestore,   // 68851
mc_psave,      // 68851
mc_ps,         // 68851 pscc
mc_ptestr,     // test a logical address
mc_ptestw,     // -"-
mc_ptrap,      // 68851 ptrapcc
mc_pvalid,     // 68851 move AL bit
mc_rol,        // cycl. shift
mc_ror,        // -"-
mc_roxl,       // two op cycl shift
mc_roxr,       // -"-
mc_reset,      // reset
mc_rtd,        // mark
mc_rte,        // return with SR
mc_rtm,        // reload save module state
mc_rtr,        // return with CCR
mc_rts,        // return
mc_sbcd,       // substract with BCD correction
mc_s,          // 1 if cond code else 0
mc_stop,       // halt
mc_sub,        // substract
mc_suba,       // substract address
mc_subi,       // substract immediate
mc_subq,       // -"-
mc_subx,       // substract memmory
mc_swap,       // hi and low word in register
mc_tas,        // test byte sign
mc_tbl,        // CPU32-tblu/tblun/tbls/tblsn
mc_trap,       // analog int(86) (or trap if cond code)
mc_trapv,      // if V then trap
mc_tst,        // test destination
mc_unlk,       // destroy address ?
mc_unpk,       // PACK(bcd)+adj -> UNPACK(bcd)

mc_last

    };

/*
 *      Interactive disassembler (IDA).
 *      Copyright (c) 1990-97 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              E-mail: ig@estar.msk.su
 *                              FIDO:   2:5020/209
 *
 */


extern instruc_t Instructions[];

enum nameNum {

ARM_null = 0,           // Unknown Operation
ARM_ret,                // Return from Subroutine
ARM_nop,                // No Operation
ARM_b,                  // Branch
ARM_bl,                 // Branch with Link
ARM_and,                // Rd = Op1 & Op2
ARM_eor,                // Rd = Op1 ^ Op2
ARM_sub,                // Rd = Op1 - Op2
ARM_rsb,                // Rd = Op2 - Op1
ARM_add,                // Rd = Op1 + Op2
ARM_adc,                // Rd = Op1 + Op2 + C
ARM_sbc,                // Rd = Op1 - Op2 + C - 1
ARM_rsc,                // Rd = Op2 - Op1 + C - 1
ARM_tst,                // Set cond. codes on Op1 & Op2
ARM_teq,                // Set cond. codes on Op1 ^ Op2
ARM_cmp,                // Set cond. codes on Op1 - Op2
ARM_cmn,                // Set cond. codes on Op1 + Op2
ARM_orr,                // Rd = Op2 | Op1
ARM_mov,                // Rd = Op2
ARM_bic,                // Rd = Op1 & ~Op2
ARM_mvn,                // Rd = ~Op2
ARM_mrs,                // Transfer PSR to Register
ARM_msr,                // Transfer Register to PSR
ARM_mul,                // Multiply
ARM_mla,                // Multiply-Accumulate
ARM_ldr,                // Load from Memory
ARM_ldrpc,              // Indirect Jump
ARM_str,                // Store to Memory
ARM_ldm,                // Load Block from Memory
ARM_stm,                // Store Block to Memory
ARM_swp,                // Single Data Swap
ARM_swi,                // Software interrupt
ARM_cdp,                // Coprocessor Data Operation
ARM_ldc,                // Load Coprocessor Register
ARM_stc,                // Store Coprocessor Register
ARM_mrc,                // Move from Coprocessor to ARM Register
ARM_mcr,                // Move from ARM to Coprocessor Register

ARM_last

    };

/*
 *      Interactive disassembler (IDA).
 *      Copyright (c) 1990-98 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              E-mail: ig@estar.msk.su
 *                              FIDO:   2:5020/209
 *
 *
 *      TMS320C6xx - VLIW (very long instruction word) architecture
 *
 */


extern instruc_t Instructions[];

enum nameNum {

TMS6_null = 0,  // Unknown Operation
TMS6_abs,       // Absolute value
TMS6_add,       // Integer addition without saturation (signed)
TMS6_addu,      // Integer addition without saturation (unsigned)
TMS6_addab,     // Integer addition using addressing mode (byte)
TMS6_addah,     // Integer addition using addressing mode (halfword)
TMS6_addaw,     // Integer addition using addressing mode (word)
TMS6_addk,      // Integer addition 16bit signed constant
TMS6_add2,      // Two 16bit Integer adds on register halves
TMS6_and,       // Logical AND
TMS6_b,         // Branch
TMS6_clr,       // Clear a bit field
TMS6_cmpeq,     // Compare for equality
TMS6_cmpgt,     // Compare for greater than (signed)
TMS6_cmpgtu,    // Compare for greater than (unsigned)
TMS6_cmplt,     // Compare for less than (signed)
TMS6_cmpltu,    // Compare for less than (unsigned)
TMS6_ext,       // Extract and sign-extend a bit filed
TMS6_extu,      // Extract an unsigned bit field
TMS6_idle,      // Multicycle NOP with no termination until interrupt
TMS6_ldb,       // Load from memory (signed 8bit)
TMS6_ldbu,      // Load from memory (unsigned 8bit)
TMS6_ldh,       // Load from memory (signed 16bit)
TMS6_ldhu,      // Load from memory (unsigned 16bit)
TMS6_ldw,       // Load from memory (32bit)
TMS6_lmbd,      // Leftmost bit detection
TMS6_mpy,       // Signed Integer Multiply (LSB16 x LSB16)
TMS6_mpyu,      // Unsigned Integer Multiply (LSB16 x LSB16)
TMS6_mpyus,     // Integer Multiply Signed*Unsigned (LSB16 x LSB16)
TMS6_mpysu,     // Integer Multiply Unsigned*Signed (LSB16 x LSB16)
TMS6_mpyh,      // Signed Integer Multiply (MSB16 x MSB16)
TMS6_mpyhu,     // Unsigned Integer Multiply (MSB16 x MSB16)
TMS6_mpyhus,    // Integer Multiply Unsigned*Signed (MSB16 x MSB16)
TMS6_mpyhsu,    // Integer Multiply Signed*Unsigned (MSB16 x MSB16)
TMS6_mpyhl,     // Signed Integer Multiply (MSB16 x LSB16)
TMS6_mpyhlu,    // Unsigned Integer Multiply (MSB16 x LSB16)
TMS6_mpyhuls,   // Integer Multiply Signed*Unsigned (MSB16 x LSB16)
TMS6_mpyhslu,   // Integer Multiply Unsigned*Signed (MSB16 x LSB16)
TMS6_mpylh,     // Signed Integer Multiply (LSB16 x MB16)
TMS6_mpylhu,    // Unsigned Integer Multiply (LSB16 x MSB16)
TMS6_mpyluhs,   // Integer Multiply Signed*Unsigned (LSB16 x MSB16)
TMS6_mpylshu,   // Integer Multiply Unsigned*Signed (LSB16 x MSB16)
TMS6_mv,        // Move from register to register
TMS6_mvc,       // Move between the control file & register file
TMS6_mvk,       // Move a 16bit signed constant into register
TMS6_mvkh,      // Move a 16bit constant into the upper bits of a register
TMS6_mvklh,     // Move a 16bit constant into the upper bits of a register
TMS6_neg,       // Negate
TMS6_nop,       // No operation
TMS6_norm,      // Normalize
TMS6_not,       // Bitwise NOT
TMS6_or,        // Logical or
TMS6_sadd,      // Integer addition with saturation
TMS6_sat,       // Saturate 40bit value to 32bits
TMS6_set,       // Set a bit field
TMS6_shl,       // Arithmetic shift left
TMS6_shr,       // Arithmetic shift right
TMS6_shru,      // Logical shift left
TMS6_smpy,      // Integer multiply with left shift & saturation (LSB16*LSB16)
TMS6_smpyhl,    // Integer multiply with left shift & saturation (MSB16*LSB16)
TMS6_smpylh,    // Integer multiply with left shift & saturation (LSB16*MSB16)
TMS6_smpyh,     // Integer multiply with left shift & saturation (MSB16*MSB16)
TMS6_sshl,      // Shift left with saturation
TMS6_ssub,      // Integer substraction with saturation
TMS6_stb,       // Store to memory (signed 8bit)
TMS6_stbu,      // Store to memory (unsigned 8bit)
TMS6_sth,       // Store to memory (signed 16bit)
TMS6_sthu,      // Store to memory (unsigned 16bit)
TMS6_stw,       // Store to memory (32bit)
TMS6_sub,       // Integer substaraction without saturation (signed)
TMS6_subu,      // Integer substaraction without saturation (unsigned)
TMS6_subab,     // Integer subtraction using addressing mode (byte)
TMS6_subah,     // Integer subtraction using addressing mode (halfword)
TMS6_subaw,     // Integer subtraction using addressing mode (word)
TMS6_subc,      // Conditional subtract & shift (for division)
TMS6_sub2,      // Two 16bit integer subtractions on register halves
TMS6_xor,       // Exclusive OR
TMS6_zero,      // Zero a register

TMS6_last,

    };

/*
 *      Interactive disassembler (IDA).
 *      Version 3.05
 *      Copyright (c) 1990-95 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              FIDO:   2:5020/209
 *                              E-mail: ig@estar.msk.su
 *
 */


extern instruc_t far Instructions[];

enum nameNum {

pdp_null = 0,           // Unknown Operation

pdp_halt,       // Stop CPU
pdp_wait,       // Wait interrupt
pdp_rti,        // Interrupt return
pdp_bpt,        // Trap to Debbuger
pdp_iot,        // Trap to 20 (i/o)
pdp_reset,      // Reset CPU and device
pdp_rtt,        // Interrupt return and ignore dbg-flag
pdp_mfpt,       // Load Processor Type          (* hi model)
pdp_jmp,        // Absolute jmp
pdp_rts,        // Return into subroutine
pdp_spl,        // Set Prior.
pdp_nop,        // Not operation
pdp_clc,        // Clear C bit in PSW
pdp_clv,        // Clear V bit in PSW
pdp_clz,        // Clear Z bit in PSW
pdp_cln,        // Clear N bit in PSW
pdp_ccc,        // Clear All Condition bits in PSW
pdp_sec,        // Set C bit in PSW
pdp_sev,        // Set V bit in PSW
pdp_sez,        // Set Z bit in PSW
pdp_sen,        // Set N bit in PSW
pdp_scc,        // Set All Condition bits bit in PSW
pdp_swab,       // Exchange byte in word
pdp_br,         // Relative jmp
pdp_bne,        // Jump if Z=0
pdp_beq,        // Jump if Z=1
pdp_bge,        // Jump if N^V=0
pdp_blt,        // Jump if N^V=1
pdp_bgt,        // Jump if Z|(N^V)=0
pdp_ble,        // Jump if Z|(N^V)=1
pdp_jsr,        // Call procedure
pdp_clr,        // Clear operand
pdp_com,        // Inverse operand
pdp_inc,        // Increment operand
pdp_dec,        // Decrement operand
pdp_neg,        // op = -op
pdp_adc,        // Add with Carry
pdp_sbc,        // Substract with Carry
pdp_tst,        // Test operand
pdp_ror,        // Cyclic shift rignt
pdp_rol,        // Cyclic shift left
pdp_asr,        // Arifmetic shift rignt
pdp_asl,        // Arifmetic shift left
pdp_mark,       // Return and empty stack
pdp_mfpi,       // Load from previous instruction space (*hi model)
pdp_mtpi,       // Store to previous instruction space  (*hi model)
pdp_sxt,        // N=>op
pdp_mov,        // Move operand
pdp_cmp,        // Compare operands
pdp_bit,        // Check Bit's
pdp_bic,        // Clear Bit's
pdp_bis,        // Set Bit's
pdp_add,        // Add operands
pdp_sub,        // Substract operands
pdp_mul,        // Multiple Reg          (*eis)
pdp_div,        // Divide Reg            (*eis)
pdp_ash,        // Multistep shift       (*eis)
pdp_ashc,       // Multistep shift 2 reg (*eis)
pdp_xor,        // Exclusive or          (*eis)
pdp_fadd,       // Floating Add         (*fis)
pdp_fsub,       // Floating Subtract    (*fis)
pdp_fmul,       // Floating Multiple    (*fis)
pdp_fdiv,       // Floating Divide      (*fis)
pdp_sob,        //
pdp_bpl,        // Jump if N=0
pdp_bmi,        // Jump if N=1
pdp_bhis,       // Jump if (!C)&(!Z)=0
pdp_blos,       // Jump if C|Z=1
pdp_bvc,        // Jump if V=0
pdp_bvs,        // Jump if V=1
pdp_bcc,        // Jump if C=0
pdp_bcs,        // Jump if C=1
pdp_emt,        // Trap to System
pdp_trap,       // Trap to user/compiler
pdp_mtps,       // Store PSW            (*lsi11 only)
pdp_mfpd,       // Load from previous data space (*hi model)
pdp_mtpd,       // Store to previous data space  (*hi model)
pdp_mfps,       // Load  PSW            (*lsi11 only)
    // FPU instruction
pdp_cfcc,       // Copy cond.codes into FPS to PSW
pdp_setf,       // Set Float
pdp_seti,       // Set Integer
pdp_setd,       // Set Double
pdp_setl,       // Set Long Integer
pdp_ldfps,      // Load FPS
pdp_stfps,      // Store FPS
pdp_stst,       // Load interrupt status
pdp_clrd,       // Clear
pdp_tstd,       // Test
pdp_absd,       // op = mod(op)
pdp_negd,       // op = -op
pdp_muld,       // Multiple
pdp_modd,       // Get int. part
pdp_addd,       // Add
pdp_ldd,        // Load in Acc
pdp_subd,       // Substract
pdp_cmpd,       // Compare
pdp_std,        // Store into Acc
pdp_divd,       // Divide
pdp_stexp,      // Store exponent
pdp_stcdi,      // Store and convert double/float to integer/long
pdp_stcdf,      // Store and convert double/float to float/double
pdp_ldexp,      // Load exponent
pdp_ldcif,      // Load and convert integer/long to double/float
pdp_ldcfd,      // Load and convert float/double to double/float
pdp_call,       // Jsr PC,
pdp_return,     // RTS PC
pdp_compcc,     // Complex Condition Codes

pdp_last

    };

/*
 *      Interactive disassembler (IDA).
 *      Version 3.05
 *      Copyright (c) 1990-95 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              FIDO:   2:5020/209
 *                              E-mail: ig@estar.msk.su
 *
 */


extern instruc_t Instructions[];

enum nameNum {

mc8_null = 0,           // Unknown Operation

mc8_aba,        // Add b to a                                  (11)
mc8_ab,         // Add b to index register
mc8_adc,        // Add with carry
mc8_add,        // Add without carry
mc8_addd,       // Add 16-bit to D                             (11)
mc8_ais,        // Add immediate value to stack pointer        (8)
mc8_aix,        // Add immediate value to index register (H:X) (8)
mc8_and,        // Logical AND
mc8_andcc,      // Logical AND immdiate with CCR (9)
mc8_asr,        // Ariphmetic shift right
mc8_bcc,        // Branch if carry bit clear
mc8_bclr,       // Clear bit in memory
mc8_bcs,        // Branch if carry bit set
mc8_beq,        // Branch if equal
mc8_bge,        // Branch if >= (signed)
mc8_bgt,        // Branch if > (signed)
mc8_bhcc,       // Branch if half carry bit clear (8)
mc8_bhcs,       // Branch if half carry bit set   (8)
mc8_bhi,        // Branch if > (unsigned)
mc8_bhs,        // Branch if >= (unsigned)        (11)
mc8_bih,        // Branch if IRQ pin high         (8)
mc8_bil,        // Branch if IRQ pin low          (8)
mc8_bit,        // Bit test                       (8)
mc8_ble,        // Branch if <= (signed)          (8)
mc8_blo,        // Branch if <  (unsigned)        (11)
mc8_bls,        // Branch if <= (unsigned)        (8)
mc8_blt,        // Branch if < (signed)           (8)
mc8_bmc,        // Branch if interrupt mask clear (8)
mc8_bmi,        // Branch if minus
mc8_bms,        // Branch if interrupt mask set   (8)
mc8_bne,        // Branch if not equal
mc8_bpl,        // Branch if not plus
mc8_bra,        // Branch always
mc8_brclr,      // Branch if bit (n) in memory clear
mc8_brn,        // Branch never
mc8_brset,      // Branch if bit (n) in memory set
mc8_bset,       // Set bit in memory
mc8_bsr,        // Branch to subroutine
mc8_bvc,        // Branch if overflow cleared     (11)
mc8_bvs,        // Branch if overflow set         (11)
mc8_cba,        // Compare A to B                 (11)
mc8_cbeq,       // Compare and branch if equal    (8)
mc8_clc,        // Clear carry bit
mc8_cli,        // Clear interrupt mask
mc8_clr,        // Clear
mc8_clv,        // Clear overflow flag            (11)
mc8_cmp,        // Compare accumulator with memory
mc8_com,        // Complement
mc8_cp,         // Compare index register 16 bit  (11)
mc8_cpd,        // Compare D 16 bit               (11)
mc8_cphx,       // Compare index register with memory          (8)
mc8_cpx,        // Compare X (index register low) with memory  (8)
mc8_cwai,       // Clear CC bits & wait for interrupt          (9)
mc8_daa,        // Decimal adjust accumulator
mc8_dbnz,       // Decrement and branch if not equal   (8)
mc8_de,         // Decrement index register            (11)
mc8_dec,        // Decrement
mc8_des,        // Decrement stack pointer             (11)
mc8_div,        // Divide                              (8)
mc8_eor,        // Excusive OR memory with accumulator
mc8_exg,        // Exchange register                   (9)
mc8_fdiv,       // Fractional divide 16 by 16          (11)
mc8_idiv,       // Integer divide 16 by 16             (11)
mc8_in,         // Increment index register            (11)
mc8_inc,        // Increment
mc8_ins,        // Increment stack pointer             (11)
mc8_jmp,        // Jump
mc8_jsr,        // Jump to subroutine
mc8_ld,         // Load index register                     (11)
mc8_lda,        // Load accumulator from memory
mc8_ldd,        // Load double accumulator                 (11)
mc8_ldhx,       // Load index register from memory         (8)
mc8_lds,        // Load stack pointer                      (11)
mc8_ldx,        // Load X (index register low) from memory (8)
mc8_lea,        // Load register from memory               (9)
mc8_lsl,        // Logical (or Ariphmetic) shift left
mc8_lsld,       // Logical (or Ariphmetic) shift left double (11)
mc8_lsr,        // Logical shift right
mc8_lsrd,       // Logical shift right double                (11)
mc8_mov,        // Move                          (8)
mc8_mul,        // Unsigned multiply
mc8_neg,        // Negate
mc8_nop,        // No Operation
mc8_nsa,        // Nibble swap accumulator       (8)
mc8_ora,        // Inclusive OR memory with accumulator
mc8_orcc,       // Inclusive OR immediate with CCR            (9)
mc8_psh,        // Push index register into stack (low first) (11)
mc8_psha,       // Push accumulator A into stack
mc8_pshb,       // Push accumulator B into stack              (11)
mc8_pshh,       // Push H (index register high) into stack    (8)
mc8_pshx,       // Push X (index register low) into stack     (8)
mc8_pul,        // Pull index register from stack (hi first)  (11)
mc8_pula,       // Pull accumulator A from stack
mc8_pulb,       // Pull accumulator B from stack              (11)
mc8_pulh,       // Pull H (index register high) from stack    (8)
mc8_pulx,       // Pull X (index register low) from stack     (8)
mc8_rol,        // Rotate left trough carry
mc8_ror,        // Rotate right trough carry
mc8_rsp,        // Reset stack pointer               (8)
mc8_rti,        // Reset from interrupt
mc8_rts,        // Reset from subroutine
mc8_sba,        // Subtract B from A                       (11)
mc8_sbc,        // Subtract with carry
mc8_sec,        // Set carry bit
mc8_sei,        // Set interrupt mask bit
mc8_sev,        // Set Overflow Flag                       (11)
mc8_sex,        // Sign extended                           (9)
mc8_slp,        // Sleep    (HD63701 extention)            (11)
mc8_st,         // Store index register in memory          (11)
mc8_sta,        // Store accumulator in memory
mc8_std,        // Store accumulators in memory            (11)
mc8_sthx,       // Store H:X (index reg)                   (8)
mc8_stop,       // Enable IRQ pin. Stop oscillator
mc8_sts,        // Store stack pointer                     (11)
mc8_stx,        // Store X (index register low) in memory  (8)
mc8_sub,        // Subtract
mc8_subd,       // Subtract 16-bit                         (11)
mc8_swi,        // Software interrupt
mc8_sync,       // Syncronisation with interrupt           (9)
mc8_tab,        // Transfer A to B                                (11)
mc8_tap,        // Transfer A to CCR
mc8_tax,        // Transfer accumulator to X (index register low) (8)
mc8_tba,        // Transfer B to A                                (11)
mc8_test,       // Address Bus Counts (in test mode)              (11)
mc8_tfr,        // Transfer register to register                  (9)
mc8_tpa,        // Transfer CCR to A
mc8_ts,         // Transfer SP to index reg                       (11)
mc8_tst,        // Test for negative or zero
mc8_tsx,        // Transfer SP to index reg                       (8)
mc8_txa,        // Transfer X (index reg low) to accumulator      (8)
mc8_txs,        // Transfer index reg X to SP
mc8_tys,        // Transfer index reg Y to SP                     (11)
mc8_wai,        // Wait for interrupt                   (11)
mc8_wait,       // Enable interrupt. Stop processor     (8)
mc8_xgd,        // Exchange D with index register       (11)
mc8_1,          // Special testing command              (11)
mc8_2,          // Special testing command              (11)
mc8_os9,        // OS9 system call                      (9)
// these group of commands MUST be last!!! (HD63701 extention)
mc8_aim,
mc8_oim,
mc8_eim,
mc8_tim,

mc8_last

    };

/*
 *      Interactive disassembler (IDA).
 *      Version 3.05
 *      Copyright (c) 1990-95 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              FIDO:   2:5020/209
 *                              E-mail: ig@estar.msk.su
 *
 */



extern instruc_t Instructions[];
enum nameNum {
//j_null = 0,           // Unknown Operation
j_nop = 0,      //  0   //Do nothing
j_aconst_null,  //  1   //Push null object reference
j_iconst_m1,    //  2   //Push integer constant -1
j_iconst_0,     //  3   //Push the integer 0
j_iconst_1,     //  4   //Push the integer 1
j_iconst_2,     //  5   //Push the integer 2
j_iconst_3,     //  6   //Push the integer 3
j_iconst_4,     //  7   //Push the integer 4
j_iconst_5,     //  8   //Push the integer 5
j_lconst_0,     //  9   //Push the long integer 0
j_lconst_1,     // 10   //Push the long integer 1
j_fconst_0,     // 11   //Push the single-precision foating point 0.0
j_fconst_1,     // 12   //Push the single-precision foating point 1.0
j_fconst_2,     // 13   //Push the single-precision foating point 2.0
j_dconst_0,     // 14   //Push the double-precision foating point 2.0
j_dconst_1,     // 15   //Push the double-precision foating point 2.0
j_bipush,       // 16   //Push one byte signed integer
j_sipush,       // 17   //Push two-byte signed integer
j_ldc1,         // 18   //Push item from constant pool (i1)
j_ldc2,         // 19   //Push item from constant pool (i2)
j_ldc2w,        // 20   //Push long or double from constant pool
j_iload,        // 21   //Push integer value of the local variable
j_lload,        // 22   //Push long value of the local variable
j_fload,        // 23   //Push single float value of the local variable
j_dload,        // 24   //Push double float value of the local variable
j_aload,        // 25   //Push object reference from the local variable
j_iload_0,      // 26   //Push integer value of the local variable #0
j_iload_1,      // 27   //Push integer value of the local variable #1
j_iload_2,      // 28   //Push integer value of the local variable #2
j_iload_3,      // 29   //Push integer value of the local variable #3
j_lload_0,      // 30   //Push long value of the local variable #0
j_lload_1,      // 31   //Push long value of the local variable #1
j_lload_2,      // 32   //Push long value of the local variable #2
j_lload_3,      // 33   //Push long value of the local variable #3
j_fload_0,      // 34   //Push single float value of the local variable #0
j_fload_1,      // 35   //Push single float value of the local variable #1
j_fload_2,      // 36   //Push single float value of the local variable #2
j_fload_3,      // 37   //Push single float value of the local variable #3
j_dload_0,      // 38   //Push double float value of the local variable #0
j_dload_1,      // 39   //Push double float value of the local variable #1
j_dload_2,      // 40   //Push double float value of the local variable #2
j_dload_3,      // 41   //Push double float value of the local variable #3
j_aload_0,      // 42   //Push object reference from the local variable #0
j_aload_1,      // 43   //Push object reference from the local variable #1
j_aload_2,      // 44   //Push object reference from the local variable #2
j_aload_3,      // 45   //Push object reference from the local variable #3
j_iaload,       // 46   //Push integer from array
j_laload,       // 47   //Push long from array
j_faload,       // 48   //Push single float from array
j_daload,       // 49   //Push double float from array
j_aaload,       // 50   //Push object refernce from array
j_baload,       // 51   //Push signed byte from array
j_caload,       // 52   //Push character from array
j_saload,       // 53   //Push short from array
j_istore,       // 54   //Pop integer value into local variable
j_lstore,       // 55   //Pop long value into local variable
j_fstore,       // 56   //Pop single float value into local variable
j_dstore,       // 57   //Pop double float value into local variable
j_astore,       // 58   //Pop object refernce into local variable
j_istore_0,     // 59   //Pop integer value into local variable #0
j_istore_1,     // 60   //Pop integer value into local variable #1
j_istore_2,     // 61   //Pop integer value into local variable #2
j_istore_3,     // 62   //Pop integer value into local variable #3
j_lstore_0,     // 63   //Pop long value into local variable #0
j_lstore_1,     // 64   //Pop long value into local variable #1
j_lstore_2,     // 65   //Pop long value into local variable #2
j_lstore_3,     // 66   //Pop long value into local variable #3
j_fstore_0,     // 67   //Pop single float value into local variable #0
j_fstore_1,     // 68   //Pop single float value into local variable #1
j_fstore_2,     // 69   //Pop single float value into local variable #2
j_fstore_3,     // 70   //Pop single float value into local variable #3
j_dstore_0,     // 71   //Pop double float value into local variable
j_dstore_1,     // 72   //Pop double float value into local variable #0
j_dstore_2,     // 73   //Pop double float value into local variable #1
j_dstore_3,     // 74   //Pop double float value into local variable #2
j_astore_0,     // 75   //Pop object refernce into local variable #0
j_astore_1,     // 76   //Pop object refernce into local variable #1
j_astore_2,     // 77   //Pop object refernce into local variable #2
j_astore_3,     // 78   //Pop object refernce into local variable #3
j_iastore,      // 79   //Pop integer from array
j_lastore,      // 80   //Pop long from array
j_fastore,      // 81   //Pop single float from array
j_dastore,      // 82   //Pop double float from array
j_aastore,      // 83   //Pop object refernce from array
j_bastore,      // 84   //Pop signed byte from array
j_castore,      // 85   //Pop character from array
j_sastore,      // 86   //Pop short from array
j_pop,          // 87   //Pop top stack word
j_pop2,         // 88   //Pop top two stack word
j_dup,          // 89   //Duplicate top stack word
j_dup_x1,       // 90   //Duplicate top stack word and put two down
j_dup_x2,       // 91   //Duplicate top stack word and put three down
j_dup2,         // 92   //Duplicate top two stack word
j_dup2_x1,      // 93   //Duplicate top two stack words and put two down
j_dup2_x2,      // 94   //Duplicate top two stack words and put three down
j_swap,         // 95   //Swap two top stack words
j_iadd,         // 96   //Integer add
j_ladd,         // 97   //Long add
j_fadd,         // 98   //Single float add
j_dadd,         // 99   //Double float add
j_isub,         //100   //Integer subtract
j_lsub,         //101   //Long subtract
j_fsub,         //102   //Single float subtract
j_dsub,         //103   //Double Float subtract
j_imul,         //104   //Integer multiply
j_lmul,         //105   //Long multiply
j_fmul,         //106   //Single float multiply
j_dmul,         //107   //Double Float multiply
j_idiv,         //108   //Integer divide
j_ldiv,         //109   //Long divide
j_fdiv,         //110   //Single float divide
j_ddiv,         //111   //Double Float divide
j_irem,         //112   //Integer reminder
j_lrem,         //113   //Long reminder
j_frem,         //114   //Single float reminder
j_drem,         //115   //Double Float reminder
j_ineg,         //116   //Integer negate
j_lneg,         //117   //Long negate
j_fneg,         //118   //Single float negate
j_dneg,         //119   //Double Float negate
j_ishl,         //120   //Integer shift left
j_lshl,         //121   //Long shift left
j_ishr,         //122   //Integer logical shift right
j_lshr,         //123   //Long logical shift right
j_iushr,        //124   //Integer arithmetic shift right
j_lushr,        //125   //Long arithmeticshift right
j_iand,         //126   //Integer boolean AND
j_land,         //127   //Long boolean AND
j_ior,          //128   //Integer boolean OR
j_lor,          //129   //Long boolean OR
j_ixor,         //130   //Integer boolean XOR
j_lxor,         //131   //Long boolean XOR
j_iinc,         //132   //Add 8-bit signed const to local variable
j_i2l,          //133   //Integer to Long conversion
j_i2f,          //134   //Integer to single float conversion
j_i2d,          //135   //Integer to double float conversion
j_l2i,          //136   //Long to Integer conversion
j_l2f,          //137   //Long to single float conversion
j_l2d,          //138   //Long to double float conversion
j_f2i,          //139   //Single float to Integer conversion
j_f2l,          //140   //Single float to Long conversion
j_f2d,          //141   //Single float to double float conversion
j_d2i,          //142   //Double float to Integer conversion
j_d2l,          //143   //Double float to Long conversion
j_d2f,          //144   //Double float to double float conversion
j_int2byte,     //145   //Integer to signed byte conversion
j_int2char,     //146   //Integer to unsigned short conversion
j_int2short,    //147   //Integer to signed short conversion
j_lcmp,         //148   //Long compare
j_fcmpl,        //149   //Single float compare (-1 on NaN)
j_fcmpg,        //150   //Single float compare (1 on NaN)
j_dcmpl,        //151   //Double float compare (-1 on NaN)
j_dcmpg,        //152   //Double float compare (1 on NaN)
j_ifeq,         //153   //Branch if equal to 0
j_ifne,         //154   //Branch if not equal to 0
j_iflt,         //155   //Branch if less then 0
j_ifge,         //156   //Branch if greater than or equal to 0
j_ifgt,         //157   //Branch if greater than 0
j_ifle,         //158   //Branch if less than or equal to 0
j_if_icmpeq,    //159   //Branch if integers equal
j_if_icmpne,    //160   //Branch if integers not equal
j_if_icmplt,    //161   //Branch if integers less than
j_if_icmpge,    //162   //Branch if integers grater than or equal to
j_if_icmpgt,    //163   //Branch if integers grater than
j_if_icmple,    //164   //Branch if integers less than or equal to
j_if_acmpeq,    //165   //Branch if object references are equal
j_if_acmpne,    //166   //Branch if object references not equal
j_goto,         //167   //Branch always
j_jsr,          //168   //Jump subroutine
j_ret,          //169   //Return from subroutine
j_tableswitch,  //170   //Access jump table by index and jump
j_lookupswitch, //171   //Access jump table by key match and jump
j_ireturn,      //172   //Return integer from function
j_lreturn,      //173   //Return long from function
j_freturn,      //174   //Return single floatr from function
j_dreturn,      //175   //Return double float from function
j_areturn,      //176   //Return object reference from function
j_return,       //177   //Return (void) from procedure
j_getstatic,    //178   //Set static field from class
j_putstatic,    //179   //Set static field in class
j_getfield,     //180   //Fetch field from object
j_putfield,     //181   //Set field in object
j_invokevirtual, //182  //invoke instance method (run-time type)
j_invokenonvirtual, //183  //invoke instance method (compile-time type)
j_invokestatic, //184  //invoke a class (static) method
j_invokeinterface, //185  //invoke interface method
j_xxxunusedxxx, //186   // RESERVED CODE (ignored?)
j_new,          //187   //Create new object
j_newarray,     //188   //Allocate new array
j_anewarray,    //189   //Allocate new array of refernces to object
j_arraylength,  //190   //Get length of array
j_athrow,       //191   //Throw exception or error
j_checkcast,    //192   //Make sure object is of given type
j_instanceof,   //193   //Determine if an object is of given type
j_monitorenter, //194   //Enter monitored region of code
j_monitorexit,  //195   //Exit monitored region of code
j_wide,         //196   //wide (prefix of command)
j_multianewarray, //197 //Allocate new multi-dimensional array
j_ifnull,       //198   //Branch if NULL-ptr
j_ifnonnull,    //199   //Branch if not NULL-ptr
j_goto_w,       //200   //Branch always (wide index)
j_jsr_w,        //201   //Jump subroutine (wide index)
j_breakpoint,   //202   //Stop and pass control to breakpoint handler
//
//j_ret_w,        //209   //Return from subroutine (wide index)
//
j_lastnorm,
j_a_invokesuper = j_lastnorm,
j_a_invokevirtualobject,
j_a_invokeignored,
//bottom of table ! (emu)
j_a_software,
j_a_hardware,
//
j_last
    };

enum name_quick {
j_ldc_quick = j_lastnorm,       //203     (18)
j_ldc2_quick,                   //204     (19)
j_ldc2w_quick,                  //205     (20)
j_getfield_quick,               //206     (180)
j_putfield_quick,               //207     (181)
j_getfield2_quick,              //208
j_putfield2_quick,              //209
j_getstatic_quick,              //210     (178)
j_putstatic_quick,              //211     (179)
j_getstatic2_quick,             //212
j_putstatic2_quick,             //213
j_invokevirtual_quick,          //214     (182)
j_invokenonvirtual_quick,       //215     (183)
j_invokesuper_quick,            //216
j_invokestatic_quick,           //217     (184)
j_invokeinterface_quick,        //218     (185)
j_invokevirtualobject_quick,    //219
j_invokeignored_quick,          //220
j_new_quick,                    //221     (187)
j_anewarray_quick,              //222     (189)
j_multianewarray_quick,         //223     (197)
j_checkcast_quick,              //224     (192)
j_instanceof_quick,             //225     (193)
j_invokevirtual_quick_w,        //226
j_getfield_quick_w,             //227
j_putfield_quick_w,             //228
j_quick_last
    };

/*
 *      Interactive disassembler (IDA).
 *      Copyright (c) 1990-98 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              E-mail: ig@estar.msk.su, ig@datarescue.com
 *
 *
 *      PowerPC - RISC with very complex instructions
 *
 */


extern instruc_t Instructions[];

enum nameNum {

PPC_null = 0,   // Unknown Operation
PPC_add,        // Add
PPC_addc,       // Add Carrying 
PPC_adde,       // Add Extended
PPC_addi,       // Add Immediate
PPC_addic,      // Add Immediate Carrying
PPC_addis,      // Add Immediate Shifted
PPC_addme,      // Add to Minus One Extended
PPC_addze,      // Add to Zero Extended
PPC_and,        // AND
PPC_andc,       // AND with Complement
PPC_andi,       // AND Immediate
PPC_andis,      // AND Immediate Shifted
PPC_b,          // Branch
PPC_bc,         // Branch Conditional
PPC_bcctr,      // Branch Conditional to Count Register
PPC_bclr,       // Branch Conditional to Link Register
PPC_cmp,        // Compare
PPC_cmpi,       // Compare Immediate
PPC_cmpl,       // Compare Logical
PPC_cmpli,      // Compare Logical Immediate
PPC_cntlzd,     // Count Leading Zeros Double Word
PPC_cntlzw,     // Count Leading Zeros Word
PPC_crand,      // Condition Register AND
PPC_crandc,     // Condition Register AND with Complement 
PPC_creqv,      // Condition Register Equivalent
PPC_crnand,     // Condition Register NAND
PPC_crnor,      // Condition Register NOR
PPC_cror,       // Condiiton Register OR
PPC_crorc,      // Condition Register OR with Comlement
PPC_crxor,      // Condition Register XOR
PPC_dcba,       // 
PPC_dcbf,       // Data Cache Block Flush
PPC_dcbi,       // Data Cache Block Invalidate
PPC_dcbst,      // Data Cache Block Store
PPC_dcbt,       // Data Cache Block Touch
PPC_dcbtst,     // Data Cache Block Touch for Store
PPC_dcbz,       // Data Cache Block Set to Zero
PPC_divd,       // Divide Double Word
PPC_divdu,      // Divide Double Word Unsigned
PPC_divw,       // Divide Word
PPC_divwu,      // Divide Word Unsigned
PPC_eciwx,      // External Control In Word Indexed
PPC_ecowx,      // External Control Out Word Indexed
PPC_eieio,      // Enforce In-Order Execution of I/O
PPC_eqv,        // Equivalent
PPC_extsb,      // Extend Sign Byte
PPC_extsh,      // Extend Sign Half Word
PPC_extsw,      // Extend Sign Word
PPC_fabs,       // Floating-Point Absolute Value
PPC_fadd,       // Floating-Point Add
PPC_fadds,      // Floating-Point Add (Single-Precision)
PPC_fcfid,      // Floating-Point Convert from Integer Double Word
PPC_fcmpo,      // Floating-Point Compare Ordered
PPC_fcmpu,      // Floating-Point Compare Unordered
PPC_fctid,      // Floating-Point Convert to Integer Double Word
PPC_fctidz,     // Floating-Point Convert to Integer Double Word with Round toward Zero
PPC_fctiw,      // Floating-Point Convert to Integer Word
PPC_fctiwz,     // Floating-Point Convert to Integer Word with Round toward Zero
PPC_fdiv,       // Floating-Point Divide
PPC_fdivs,      // Floating-Point Divide Single-Precision
PPC_fmadd,      // Floating-Point Multiply-Add
PPC_fmadds,     // Floating-Point Multiply-Add Single-Precision
PPC_fmr,        // Floating-Point Move Register
PPC_fmsub,      // Floating-Point Multiply-Subtract
PPC_fmsubs,     // Floating-Point Multiply-Subtract (Single-Precision)
PPC_fmul,       // Floating-Point Multiply
PPC_fmuls,      // Floating-Point Multiply Single-Precision
PPC_fnabs,      // Floating-Point Negative Absolute Value
PPC_fneg,       // Floating-Point Negate
PPC_fnmadd,     // Floating-Point Negative Multiply-Add
PPC_fnmadds,    // Floating-Point Negative Multiply-Add Single-Precision
PPC_fnmsub,     // Floating-Point Negative Multiply-Subtract
PPC_fnmsubs,    // Floating-Point Negative Multiply-Subtract Single-Precision
PPC_fres,       // Floating-Point Reciprocal Estimate Single-Precision
PPC_frsp,       // Floating-Point Round to Single-Precision
PPC_frsqrte,    // Floating-Point Reciprocal Square Root Estimate
PPC_fsel,       // Floating-Point Select
PPC_fsqrt,      // Floating-Point Square Root
PPC_fsqrts,     // Floating-Point Square Root Single-Precision
PPC_fsub,       // Floating-Point Subtract
PPC_fsubs,      // Floating-Point Subtract Single-Precision
PPC_icbi,       // Instruction Cache Block Invalidate
PPC_isync,      // Instruction Synchronize
PPC_lbz,        // Load Byte and Zero
PPC_lbzu,       // Load Byte and Zero with Update
PPC_lbzux,      // Load Byte and Zero with Update Indexed
PPC_lbzx,       // Load Byte and Zero Indexed                    
PPC_ld,         // Load Double Word
PPC_ldarx,      // Load Double Word and Reserve Indexed
PPC_ldu,        // Load Double Word with Update
PPC_ldux,       // Load Double Word with Update Indexed
PPC_ldx,        // Load Double Word Indexed
PPC_lfd,        // Load Floating-Point Double-Precision
PPC_lfdu,       // Load Floating-Point Double-Precision with Update
PPC_lfdux,      // Load Floating-Point Double-Precision with Update Indexed
PPC_lfdx,       // Load Floating-Point Double-Precision Indexed
PPC_lfs,        // Load Floating-Point Single-Precision
PPC_lfsu,       // Load Floating-Point Single-Precision with Update
PPC_lfsux,      // Load Floating-Point Single-Precision with Update Indexed
PPC_lfsx,       // Load Floating-Point Single-Precision Indexed
PPC_lha,        // Load Half Word Algebraic
PPC_lhau,       // Load Half Word Algebraic with Update
PPC_lhaux,      // Load Half Word Algebraic with Update Indexed
PPC_lhax,       // Load Half Word Algebraic Indexed
PPC_lhbrx,      // Load Half Word Byte-reverse Indexed
PPC_lhz,        // Load Half Word and Zero
PPC_lhzu,       // Load Half Word and Zero with Update
PPC_lhzux,      // Load Half Word and Zero with Update Indexed
PPC_lhzx,       // Load Half Word and Zero Indexed
PPC_lmw,        // Load Multiple Word
PPC_lswi,       // Load String Word Immediate
PPC_lswx,       // Load String Word Indexed
PPC_lwa,        // Load Word Algebraic
PPC_lwarx,      // Load Word and Reserve Indexed
PPC_lwaux,      // Load Word Algebraic with Update Indexed
PPC_lwax,       // Load Word Algebraic Indexed
PPC_lwbrx,      // Load Word Byte-Reverse Indexed
PPC_lwz,        // Load Word and Zero
PPC_lwzu,       // Load Word and Zero with Update
PPC_lwzux,      // Load Word and Zero with Update Indexed
PPC_lwzx,       // Load Word and Zero Indexed
PPC_mcrf,       // Move Condition register Field
PPC_mcrfs,      // Move to Condition Register from FPSCR
PPC_mcrxr,      // Move to Condition Register from XER
PPC_mfcr,       // Move from Condition Register
PPC_mffs,       // Move from FPSCR
PPC_mfmsr,      // Move from Machine State Register 
PPC_mfspr,      // Move from Special Purpose Register 
PPC_mfsr,       // Move from Segment Register
PPC_mfsrin,     // Move from Segment Register Indexed
PPC_mftb,       // Move from Time Base
PPC_mtcrf,      // Move to Condition Register Fields 
PPC_mtfsb0,     // Move to FPSCR Bit 0
PPC_mtfsb1,     // Move to FPSCR Bit 1
PPC_mtfsf,      // Move to FPSCR Fields
PPC_mtfsfi,     // Move to FPSCR Field Immediate 
PPC_mtmsr,      // Move to Machine State Register
PPC_mtmsrd,     // Move to Machine State Register Double Word
PPC_mtspr,      // Move to Special Purpose Register
PPC_mtsr,       // Move to Segment Register
PPC_mtsrd,      // Move to Segment Register Double Word
PPC_mtsrdin,    // Move to Segment Register Indirect Double
PPC_mtsrin,     // Move to Segment Register Indirect
PPC_mulhd,      // Multiply High Double Word
PPC_mulhdu,     // Multiply High Double Word Unsigned
PPC_mulhw,      // Multiply High Word           
PPC_mulhwu,     // Multiply High Word Unsigned
PPC_mulld,      // Multiply Low Double Word
PPC_mulli,      // Multiply Low Immediate       
PPC_mullw,      // Multiply Low
PPC_nand,       // NAND (not AND)
PPC_neg,        // Negate
PPC_nor,        // NOR (not OR)
PPC_or,         // OR
PPC_orc,        // OR with Complement
PPC_ori,        // OR Immediate
PPC_oris,       // OR Immediate Shifted
PPC_rfi,        // Return from Interrupt
PPC_rfid,       // Return from Interrupt Double Word
PPC_rldcl,      // Rotate Left Double Word then Clear Left
PPC_rldcr,      // Rotate Left Double Word then Clear Right
PPC_rldic,      // Rotate Left Double Word Immediate then Clear
PPC_rldicl,     // Rotate Left Double Word Immediate then Clear Left
PPC_rldicr,     // Rotate Left Double Word Immediate then Clear Right
PPC_rldimi,     // Rotate Left Double Word Immediate then Mask Insert
PPC_rlwimi,     // Rotate Left Word Immediate then Mask Insert
PPC_rlwinm,     // Rotate Left Word Immediate then AND with Mask
PPC_rlwnm,      // Rotate Left Word then AND with Mask
PPC_sc,         // System Call
PPC_slbia,      // SLB Invalidate All
PPC_slbie,      // SLB Invalidate Entry
PPC_sld,        // Shift Left Double Word
PPC_slw,        // Shift Left Word
PPC_srad,       // Shift Right Algebraic Double Word
PPC_sradi,      // Shift Right Algebraic Double Word Immediate
PPC_sraw,       // Shift Right Algebraic Word
PPC_srawi,      // Shift Right Algebraic Word Immediate
PPC_srd,        // Shift Right Double Word
PPC_srw,        // Shift Right Word
PPC_stb,        // Store Byte
PPC_stbu,       // Store Byte with Update
PPC_stbux,      // Store Byte with Update Indexed
PPC_stbx,       // Store Byte Indexed
PPC_std,        // Store Double Word
PPC_stdcx,      // Store Double Word Conditional Indexed
PPC_stdu,       // Store Double Word with Update
PPC_stdux,      // Store Double Word with Update Indexed
PPC_stdx,       // Store Double Word Indexed
PPC_stfd,       // Store Floating-Point Double-Precision
PPC_stfdu,      // Store Floating-Point Double-Precision wiht Update
PPC_stfdux,     // Store Floating-Point Double-Precision wiht Update Indexed
PPC_stfdx,      // Store Floating-Point Double-Precision Indexed
PPC_stfiwx,     // Store Floating-Point as Integer Word Indexed
PPC_stfs,       // Store Floating-Point Single-Precision
PPC_stfsu,      // Store Floating-Point Single-Precision with Update
PPC_stfsux,     // Store Floating-Point Single-Precision with Update Indexed 
PPC_stfsx,      // Store Floating-Point Single-Precision Indexed
PPC_sth,        // Store Half Word
PPC_sthbrx,     // Store Half Word Byte-Reverse Indexed
PPC_sthu,       // Store Half Word with Update
PPC_sthux,      // Store Half Word with Update Indexed
PPC_sthx,       // Store Half Word Indexed
PPC_stmw,       // Store Multiple Word
PPC_stswi,      // Store String Word Immediate
PPC_stswx,      // Store String Word Indexed
PPC_stw,        // Store Word
PPC_stwbrx,     // Store Word Byte-Reverse Indexed
PPC_stwcx,      // Store Word Conditional Indexed
PPC_stwu,       // Store Word with Update
PPC_stwux,      // Store Word with Update Indexed
PPC_stwx,       // Store Word Indexed
PPC_subf,       // Subtract from
PPC_subfc,      // Subtract from Carrying
PPC_subfe,      // Subtract from Extended
PPC_subfic,     // Subtract from Immediate Carrying
PPC_subfme,     // Subtract from Minus One Extended
PPC_subfze,     // Subtract from Zero Extended
PPC_sync,       // Synchronize
PPC_td,         // Trap Double Word
PPC_tdi,        // Trap Double Word Immediate   
PPC_tlbia,      // TLB Invalidate All
PPC_tlbie,      // TLB Invalidate Entry
PPC_tlbsync,    // TLB Synchronize
PPC_tw,         // Trap Word
PPC_twi,        // Trap Word Immediate          
PPC_xor,        // XOR 
PPC_xori,       // XOR Immediate        
PPC_xoris,      // XOR Immediate Shifted

PPC_last_basic = PPC_xoris,

//
//      Simplified mnemonics
//

PPC_cmpwi,      // Compare Word Immediate
PPC_cmpw,       // Compare Word
PPC_cmplwi,     // Compare Logical Word Immediate
PPC_cmplw,      // Compare Logical Word
PPC_cmpdi,      // Compare Double Word Immediate
PPC_cmpd,       // Compare Double Word
PPC_cmpldi,     // Compare Logical Double Word Immediate
PPC_cmpld,      // Compare Logical Double Word

PPC_trap,       // Trap Word Unconditionally
PPC_trapd,      // Trap Double Word Unconditionally
PPC_twlgt,      // Trap Word if Logically Greater Than
PPC_twllt,      // Trap Word if Logically Less Than
PPC_tweq,       // Trap Word if Equal
PPC_twlge,      // Trap Word if Logically Greater Than or Equal
PPC_twlle,      // Trap Word if Logically Less Than or Equal
PPC_twgt,       // Trap Word if Greater Than
PPC_twge,       // Trap Word if Greater Than or Equal
PPC_twlt,       // Trap Word if Less Than
PPC_twle,       // Trap Word if Less Than oe Equal
PPC_twne,       // Trap Word if Not Equal
PPC_twlgti,     // Trap Word Immediate if Logically Greater Than
PPC_twllti,     // Trap Word Immediate if Logically Less Than
PPC_tweqi,      // Trap Word Immediate if Equal
PPC_twlgei,     // Trap Word Immediate if Logically Greater Than or Equal
PPC_twllei,     // Trap Word Immediate if Logically Less Than or Equal
PPC_twgti,      // Trap Word Immediate if Greater Than
PPC_twgei,      // Trap Word Immediate if Greater Than or Equal
PPC_twlti,      // Trap Word Immediate if Less Than
PPC_twlei,      // Trap Word Immediate if Less Than oe Equal
PPC_twnei,      // Trap Word Immediate if Not Equal
PPC_tdlgt,      // Trap Double Word if Logically Greater Than
PPC_tdllt,      // Trap Double Word if Logically Less Than
PPC_tdeq,       // Trap Double Word if Equal
PPC_tdlge,      // Trap Double Word if Logically Greater Than or Equal
PPC_tdlle,      // Trap Double Word if Logically Less Than or Equal
PPC_tdgt,       // Trap Double Word if Greater Than
PPC_tdge,       // Trap Double Word if Greater Than or Equal
PPC_tdlt,       // Trap Double Word if Less Than
PPC_tdle,       // Trap Double Word if Less Than oe Equal
PPC_tdne,       // Trap Double Word if Not Equal
PPC_tdlgti,     // Trap Double Word Immediate if Logically Greater Than
PPC_tdllti,     // Trap Double Word Immediate if Logically Less Than
PPC_tdeqi,      // Trap Double Word Immediate if Equal
PPC_tdlgei,     // Trap Double Word Immediate if Logically Greater Than or Equal
PPC_tdllei,     // Trap Double Word Immediate if Logically Less Than or Equal
PPC_tdgti,      // Trap Double Word Immediate if Greater Than
PPC_tdgei,      // Trap Double Word Immediate if Greater Than or Equal
PPC_tdlti,      // Trap Double Word Immediate if Less Than
PPC_tdlei,      // Trap Double Word Immediate if Less Than oe Equal
PPC_tdnei,      // Trap Double Word Immediate if Not Equal

PPC_nop,        // No Operation
PPC_not,        // Complement Register
PPC_mr,         // Move Register

PPC_subi,       // Subtract Immediate
PPC_subic,      // Subtract Immediate Carrying
PPC_subis,      // Subtract Immediate Shifted
PPC_li,         // Load Immediate
PPC_lis,        // Load Immediate Shifted

PPC_crset,      // Condition Register Set
PPC_crnot,      // Condition Register NOT
PPC_crmove,     // Condition Register Move
PPC_crclr,      // Condition Register Clear

PPC_mtxer,      // Move to integer unit exception register
PPC_mtlr,       // Move to link register
PPC_mtctr,      // Move to count register
PPC_mtdsisr,    // Move to DAE/source instruction service register
PPC_mtdar,      // Move to data address register
PPC_mtdec,      // Move to decrementer register
PPC_mtsrr0,     // Move to status save/restore register 0
PPC_mtsrr1,     // Move to status save/restore register 1
PPC_mtsprg0,    // Move to general special purpose register 0
PPC_mtsprg1,    // Move to general special purpose register 1
PPC_mtsprg2,    // Move to general special purpose register 2
PPC_mtsprg3,    // Move to general special purpose register 3
PPC_mttbl,      // Move to time base register (lower)
PPC_mttbu,      // Move to time base register (upper)
PPC_mfxer,      // Move from integer unit exception register
PPC_mflr,       // Move from link register
PPC_mfctr,      // Move from count register
PPC_mfdsisr,    // Move from DAE/source instruction service register
PPC_mfdar,      // Move from data address register
PPC_mfdec,      // Move from decrementer register
PPC_mfsrr0,     // Move from status save/restore register 0
PPC_mfsrr1,     // Move from status save/restore register 1
PPC_mfsprg0,    // Move from general special purpose register 0
PPC_mfsprg1,    // Move from general special purpose register 1
PPC_mfsprg2,    // Move from general special purpose register 2
PPC_mfsprg3,    // Move from general special purpose register 3
PPC_mftbl,      // Move from time base register (lower)
PPC_mftbu,      // Move from time base register (upper)
PPC_mfpvr,      // Move from processor version register

// suffixes:
//      lr      - goto lr
//      ctr     - goto ctr
//      l       - update lr
//      a       - absolute

PPC_balways,    // Branch unconditionally
PPC_bt,         // Branch if true
PPC_bf,         // Branch if false
PPC_bdnz,       // CTR--; branch if CTR non-zero
PPC_bdnzt,      // CTR--; branch if CTR non-zero and condition is true
PPC_bdnzf,      // CTR--; branch if CTR non-zero and condition is false
PPC_bdz,        // CTR--; branch if CTR zero
PPC_bdzt,       // CTR--; branch if CTR zero and condition is true
PPC_bdzf,       // CTR--; branch if CTR zero and condition is false

PPC_blt,        // Branch if less than
PPC_ble,        // Branch if less than or equal
PPC_beq,        // Branch if equal
PPC_bge,        // Branch if greater than or equal
PPC_bgt,        // Branch if greater than
PPC_bne,        // Branch if not equal
PPC_bso,        // Branch if summary overflow
PPC_bns,        // Branch if not summary overflow

PPC_extlwi,     // Extract and Left Justify Immediate
PPC_extrwi,     // Extract and Right Justify Immediate
PPC_inslwi,     // Insert from Left Immediate
PPC_insrwi,     // Insert from Right Immediate
PPC_rotlwi,     // Rotate Left Immediate
PPC_rotrwi,     // Rotate Right Immediate
PPC_rotlw,      // Rotate Left
PPC_slwi,       // Shift Left Immediate
PPC_srwi,       // Shift Right Immediate
PPC_clrlwi,     // Clear Left Immediate
PPC_clrrwi,     // Clear Right Immediate
PPC_clrlslwi,   // Clear Left and Shift Left Immediate

PPC_last,

    };

/*
 *  Interactive disassembler (IDA).
 *  Intel 80196 module
 *
 */


extern instruc_t Instructions[];

enum nameNum {
  I196_null = 0,    // Unknown Operation

  I196_add2,        // Add words (2 operands)
  I196_add3,        // Add words (3 operands)
  I196_addb2,       // Add bytes (2 operands)
  I196_addb3,       // Add bytes (3 operands)

  I196_addc,        // Add words with carry
  I196_addcb,       // Add bytes with carry

  I196_and2,        // Logical AND words (2 operands)
  I196_and3,        // Logical AND words (3 operands)
  I196_andb2,       // Logical AND bytes (2 operands)
  I196_andb3,       // Logical AND bytes (3 operands)

  I196_bmov,        // Block move
  I196_bmovi,       // Interruptable block move

  I196_br,          // Branch indirect

  I196_clr,         // Clear word
  I196_clrb,        // Clear byte
  I196_clrc,        // Clear carry flag
  I196_clrvt,       // Clear overflow-trap flag

  I196_cmp,         // Compare words
  I196_cmpb,        // Compare bytes
  I196_cmpl,        // Compare long

  I196_dec,         // Decrement word
  I196_decb,        // Decrement byte

  I196_di,          // Disable interrupts

  I196_div,         // Divide integers
  I196_divb,        // Divide short-integers
  I196_divu,        // Divide words, unsigned
  I196_divub,       // Divide bytes, unsigned

  I196_djnz,        // Decrement and jump if not zero
  I196_djnzw,       // Decrement and jump if not zero word

  I196_dpts,        // Disable peripheral transaction server

  I196_ei,          // Enable interrupts

  I196_epts,        // Enable peripheral transaction server

  I196_ext,         // Sign-extend integer into long-integer
  I196_extb,        // Sign-extend short-integer into integer

  I196_idlpd,       // Idle/powerdown

  I196_inc,         // Increment word
  I196_incb,        // Increment byte

  I196_jbc,         // Jump if bit is clear
  I196_jbs,         // Jump if bit is set
  I196_jc,          // Jump if carry flag is set
  I196_je,          // Jump if equal
  I196_jge,         // Jump if signed greater than or equal
  I196_jgt,         // Jump if signed greater than
  I196_jh,          // Jump if higher (unsigned)
  I196_jle,         // Jump if signed less than or equal
  I196_jlt,         // Jump if signed less than
  I196_jnc,         // Jump if carry flag is clear
  I196_jne,         // Jump if not equal
  I196_jnh,         // Jump if not higher (unsigned)
  I196_jnst,        // Jump if sticky bit flag is clear
  I196_jnv,         // Jump if overflow flag is clear
  I196_jnvt,        // Jump if overflow-trap flag is clear
  I196_jst,         // Jump if sticky bit flag is set
  I196_jv,          // Jump if overflow flag is set
  I196_jvt,         // Jump if overflow-trap flag is set

  I196_lcall,       // Long call

  I196_ld,          // Load word
  I196_ldb,         // Load byte
  I196_ldbse,       // Load byte sign-extended
  I196_ldbze,       // Load byte zero-extended

  I196_ljmp,        // Long jump

  I196_mul2,        // Multiply integers (2 operands)
  I196_mul3,        // Multiply integers (3 operands)
  I196_mulb2,       // Multiply short-integers (2 operands)
  I196_mulb3,       // Multiply short-integers (3 operands)
  I196_mulu2,       // Multiply words, unsigned (2 operands)
  I196_mulu3,       // Multiply words, unsigned (3 operands)
  I196_mulub2,      // Multiply bytes, unsigned (2 operands)
  I196_mulub3,      // Multiply bytes, unsigned (3 operands)

  I196_neg,         // Negate integer
  I196_negb,        // Negate short-integer

  I196_nop,         // No operation

  I196_norml,       // Normalize long-integer

  I196_not,         // Complement word
  I196_notb,        // Complement byte

  I196_or,          // Logical OR words
  I196_orb,         // Logical OR bytes

  I196_pop,         // Pop word
  I196_popa,        // Pop all
  I196_popf,        // Pop flags
  I196_push,        // Push word
  I196_pusha,       // Push all
  I196_pushf,       // Push flags

  I196_ret,         // Return from subroutine

  I196_rst,         // Reset system

  I196_scall,       // Short call

  I196_setc,        // Set carry flag

  I196_shl,         // Shift word left
  I196_shlb,        // Shift byte left
  I196_shll,        // Shift double-word left
  I196_shr,         // Logical right shift word
  I196_shra,        // Arithmetic right shift word
  I196_shrab,       // Arithmetic right shift byte
  I196_shral,       // Arithmetic right shift double-word
  I196_shrb,        // Logical right shift byte
  I196_shrl,        // Logical right shift double-word

  I196_sjmp,        // Short jump

  I196_skip,        // Two byte no-operation

  I196_st,          // Store word
  I196_stb,         // Store byte

  I196_sub2,        // Subtract words (2 operands)
  I196_sub3,        // Subtract words (3 operands)
  I196_subb2,       // Subtract bytes (2 operands)
  I196_subb3,       // subtract bytes (3 operands)

  I196_subc,        // Subtract words with borrow
  I196_subcb,       // Subtract bytes with borrow

  I196_tijmp,       // Table indirect jump

  I196_trap,        // Software trap

  I196_xch,         // Exchange word
  I196_xchb,        // Exchange byte

  I196_xor,         // Logical exclusive-or words
  I196_xorb,        // Logical exclusive-or bytes

  I196_last
};

/*
 *      Interactive disassembler (IDA).
 *      Copyright (c) 1990-98 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              E-mail: ig@estar.msk.su, ig@datarescue.com
 *
 *
 *      Hitachi SH3 - RISC with 16bit instructions
 *
 */


extern instruc_t Instructions[];


enum nameNum {

SH3_null = 0,     // Unknown Operation

SH3_add,          // Add binary
SH3_addc,         // Add with Carry
SH3_addv,         // Add with V Flag Overflow Check
SH3_and,          // AND Logical
SH3_and_b,        // AND Byte Logical
SH3_bf,           // Branch if False
SH3_bf_s,         // Branch of False with Delay Slot
SH3_bra,          // Branch
SH3_braf,         // Branch Far
SH3_bsr,          // Branch to Subroutine
SH3_bsrf,         // Bracnh to Subroutine Far
SH3_bt,           // Branch if True
SH3_bt_s,         // Branch if True with Delay Slot
SH3_clrmac,       // Clear MAC register
SH3_clrs,         // Clear S Bit
SH3_clrt,         // Clear T Bit
SH3_cmp_eq,       // Compare: Equal
SH3_cmp_ge,       // Compare: Signed Greater or Equal
SH3_cmp_gt,       // Compare: Signed Greater
SH3_cmp_hi,       // Compare: Unsigned Greater
SH3_cmp_hs,       // Compare: Unsigned Greater or Equal
SH3_cmp_pl,       // Compare: Positive
SH3_cmp_pz,       // Compare: Positive or Zero
SH3_cmp_str,      // Compare: Equal Bytes
SH3_div0s,        // Divide Step 0 as Signed
SH3_div0u,        // Divide Step 0 as Unsigned
SH3_div1,         // Divide Step 1
SH3_dmuls_l,      // Double-Length Multiply as Signed
SH3_dmulu_l,      // Double-Length Multiply as Unsigned
SH3_dt,           // Decrement and Test
SH3_exts_b,       // Extend as Signed (Byte)
SH3_exts_w,       // Extend as Signed (Word)
SH3_extu_b,       // Extend as Unsigned (Byte)
SH3_extu_w,       // Extend as Unsigned (Word)
SH3_jmp,          // Jump
SH3_jsr,          // Jump to Subroutine
SH3_ldc,          // Load to Control Register
SH3_ldc_l,        // Load to Control Register Long
SH3_lds,          // Load to System Register
SH3_lds_l,        // Load to System Register Long
SH3_ldtlb,        // Load PTEH/PTEL/PTEA to TLB
SH3_mac_w,        // Multiply and Accumulate Word
SH3_mac_l,        // Multiply and Accumulate Long
SH3_mov,          // Move Data
SH3_mov_b,        // Move Byte Data
SH3_mov_w,        // Move Word Data
SH3_mov_l,        // Move Long Data
SH3_movi,         // Move Immediate Byte Data
SH3_movi_w,       // Move Immediate Word Data
SH3_movi_l,       // Move Immediate Long Data
SH3_movp_b,       // Move Peripherial Byte Data
SH3_movp_w,       // Move Peripherial Word Data
SH3_movp_l,       // Move Peripherial Long Data
SH3_movs_b,       // Move Structure Byte Data
SH3_movs_w,       // Move Structure Word Data
SH3_movs_l,       // Move Structure Long Data
SH3_mova,         // Move Effective Address
SH3_movt,         // Move T Bit
SH3_mul,          // Multiply Long
SH3_muls,         // Multiply as Signed Word
SH3_mulu,         // Multiply as Unsigned Word
SH3_neg,          // Negate
SH3_negc,         // Negate with Carry
SH3_nop,          // No Operation
SH3_not,          // NOT - Logical Complement
SH3_or,           // OR Logical
SH3_or_b,         // OR Byte Logical
SH3_pref,         // Prefetch Data to the Cache
SH3_rotcl,        // Rotate with Carry Left
SH3_rotcr,        // Rotate with Carry Right
SH3_rotl,         // Rotate Left
SH3_rotr,         // Rotate Right
SH3_rte,          // Return from Exception
SH3_rts,          // Return from Subroutine
SH3_sets,         // Set S Bit
SH3_sett,         // Set T Bit
SH3_shad,         // Shift Arithmetic Dynamically
SH3_shal,         // Shift Arithmetic Left
SH3_shar,         // Shift Arithmetic Right
SH3_shld,         // Shift Logical Dynamically
SH3_shll,         // Shift Logical Left
SH3_shll2,        // Shift Logical Left 2
SH3_shll8,        // Shift Logical Left 8
SH3_shll16,       // Shift Logical Left 16
SH3_shlr,         // Shift Logical Right
SH3_shlr2,        // Shift Logical Right 2
SH3_shlr8,        // Shift Logical Right 8
SH3_shlr16,       // Shift Logical Right 16
SH3_sleep,        // Sleep
SH3_stc,          // Store Control Register
SH3_stc_l,        // Store Control Register Long
SH3_sts,          // Store System Register
SH3_sts_l,        // Store System Register Long
SH3_sub,          // Subtract Binary
SH3_subc,         // Subtract with Carry
SH3_subv,         // Subtract with V Flag Underflow Check
SH3_swap_b,       // Swap Register Halves (Byte)
SH3_swap_w,       // Swap Register Halves (Word)
SH3_tas_b,        // Test and Set
SH3_trapa,        // Trap Always
SH3_tst,          // Test Logical
SH3_tst_b,        // Test Byte Logical
SH3_xor,          // Exclusive OR Logical
SH3_xor_b,        // Exclusive OR Byte Logical
SH3_xtrct,        // Extract

SH4_fabs,         // Floating-point absolute value
SH4_fadd,         // Floating-point add
SH4_fcmp_eq,      // Floating-point compare eqaul
SH4_fcmp_gt,      // Floating-point compare greater than
SH4_fcnvds,       // Floating-point convert double to single precision
SH4_fcnvsd,       // Floating-point convert single to double precision
SH4_fdiv,         // Floating-point divide
SH4_fipr,         // Floating-point inner product
SH4_fldi0,        // Floating-point Load Immediate 0.0
SH4_fldi1,        // Floating-point Load Immediate 1.0
SH4_flds,         // Floating-point Load to system register
SH4_float,        // Floating-point convert from integer
SH4_fmac,         // Floating-point multiply and accumulate
SH4_fmov,         // Floating-point move
SH4_fmov_s,       // Floating-point move single precision
SH4_fmovex,       // Floating-point move extension
SH4_fmul,         // Floating-point multiply
SH4_fneg,         // Floating-Point sign inversion
SH4_frchg,        // FR-bit change
SH4_fschg,        // SZ-bit change
SH4_fsqrt,        // Floating-point square root
SH4_fsts,         // Floating-point store system register
SH4_fsub,         // Floating-point subtract
SH4_ftrc,         // Floating-point truncate and convert to integer
SH4_ftrv,         // Floating-point transform vector
SH4_ftstn,        // Floating point square root reciprocal approximate
SH4_movca_l,      // Move with cache block allocation
SH4_ocbi,         // Operand Cache Block Invalidate
SH4_ocbp,         // Operand Cache Block Purge
SH4_ocbwb,        // Operand Cache Block Write Back
SH4_fsca,         // Floating point sine and cosine approximate

SH4_last,

    };

/*
 *  Interactive disassembler (IDA).
 *  Zilog Z8 module
 *
 */


extern instruc_t Instructions[];

enum nameNum {
  Z8_null = 0,    // Unknown Operation

  Z8_adc,         // Add with carry
  Z8_add,         // Add
  Z8_and,         // Logical AND
  Z8_call,        // Call procedure
  Z8_ccf,         // Complement carry flag
  Z8_clr,         // Clear
  Z8_com,         // Complement
  Z8_cp,          // Compare
  Z8_da,          // Decimal adjust
  Z8_dec,         // Decrement
  Z8_decw,        // Decrement word
  Z8_di,          // Disable interrupts
  Z8_djnz,        // Decrement and jump if non-zero
  Z8_ei,          // Enable interrupts
  Z8_halt,        // Enter HALT mode
  Z8_inc,         // Increment
  Z8_incw,        // Increment word
  Z8_iret,        // Return from interrupt
  Z8_jp,          // Unconditional jump
  Z8_jpcond,      // Conditional jump
  Z8_jr,          // Relative jump
  Z8_jrcond,      // Conditional relative jump
  Z8_ld,          // Load data
  Z8_ldc,         // Load constant
  Z8_ldci,        // Load constant with auto-increment
  Z8_lde,         // Load external data
  Z8_ldei,        // Load external data with auto-increment
  Z8_nop,         // NOP
  Z8_or,          // Logical OR
  Z8_pop,         // Pop
  Z8_push,        // Push
  Z8_rcf,         // Reset carry flag
  Z8_ret,         // Return
  Z8_rl,          // Rotate left
  Z8_rlc,         // Rotate left through carry
  Z8_rr,          // Rotate right
  Z8_rrc,         // Rotate right through carry
  Z8_sbc,         // Subtract with carry
  Z8_scf,         // Set carry flag
  Z8_sra,         // Shift right arithmetic
  Z8_srp,         // Set register pointer
  Z8_stop,        // Enter STOP mode
  Z8_sub,         // Subtract
  Z8_swap,        // Swap nibbles
  Z8_tm,          // Test under mask
  Z8_tcm,         // Test complement under mask
  Z8_xor,         // Logical EXCLUSIVE OR
  Z8_wdh,         // Enable WATCH-DOG in HALT mode
  Z8_wdt,         // Clear WATCH-DOG timer

  Z8_last
};

/*
 *      Interactive disassembler (IDA).
 *      Copyright (c) 1990-99 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              E-mail: ig@datarescue.com
 *
 *      Atmel AVR - 8-bit RISC processor
 *
 */


extern instruc_t Instructions[];

enum nameNum {

AVR_null = 0,     // Unknown Operation

// ARITHMETIC AND LOGIC INSTRUCTIONS
AVR_add,          // Add without Carry
AVR_adc,          // Add with Carry
AVR_adiw,         // Add Immediate to Word
AVR_sub,          // Subtract without Carry
AVR_subi,         // Subtract Immediate
AVR_sbc,          // Subtract with Carry
AVR_sbci,         // Subtract Immediate with Carry
AVR_sbiw,         // Subtract Immediate from Word
AVR_and,          // Logical AND
AVR_andi,         // Logical AND with Immediate
AVR_or,           // Logical OR
AVR_ori,          // Logical OR with Immediate
AVR_eor,          // Exclusive OR
AVR_com,          // One's Complement
AVR_neg,          // Two's Complement
AVR_sbr,          // Set Bit(s) in Register
AVR_cbr,          // Clear Bit(s) in Register
AVR_inc,          // Increment
AVR_dec,          // Decrement
AVR_tst,          // Test for Zero or Minus
AVR_clr,          // Clear Register
AVR_ser,          // Set Register
AVR_cp,           // Compare
AVR_cpc,          // Compare with Carry
AVR_cpi,          // Compare with Immediate
AVR_mul,          // Multiply

// BRANCH INSTRUCTIONS
AVR_rjmp,         // Relative Jump
AVR_ijmp,         // Indirect Jump to (Z)
AVR_jmp,          // Jump
AVR_rcall,        // Relative Call Subroutine
AVR_icall,        // Indirect Call to (Z)
AVR_call,         // Call Subroutine
AVR_ret,          // Subroutine Return
AVR_reti,         // Interrupt Return
AVR_cpse,         // Compare, Skip if Equal
AVR_sbrc,         // Skip if Bit in Register Cleared
AVR_sbrs,         // Skip if Bit in Register Set
AVR_sbic,         // Skip if Bit in I/O Register Cleared
AVR_sbis,         // Skip if Bit in I/O Register Set
AVR_brbs,         // Branch if Status Flag Set
AVR_brbc,         // Branch if Status Flag Cleared
AVR_breq,         // Branch if Equal
AVR_brne,         // Branch if Not Equal
AVR_brcs,         // Branch if Carry Set
AVR_brcc,         // Branch if Carry Cleared
AVR_brsh,         // Branch if Same or Higher
AVR_brlo,         // Branch if Lower
AVR_brmi,         // Branch if Minus
AVR_brpl,         // Branch if Plus
AVR_brge,         // Branch if Greater or Equal
AVR_brlt,         // Branch if Less Than
AVR_brhs,         // Branch if Half Carry Flag Set
AVR_brhc,         // Branch if Half Carry Flag Cleared
AVR_brts,         // Branch if T Flag Set
AVR_brtc,         // Branch if T Flag Cleared
AVR_brvs,         // Branch if Overflow Flag is Set
AVR_brvc,         // Branch if Overflow Flag is Cleared
AVR_brie,         // Branch if Interrupt Enabled
AVR_brid,         // Branch if Interrupt Disabled

// DATA TRANSFER INSTRUCTIONS
AVR_mov,          // Copy Register
AVR_ldi,          // Load Immediate
AVR_lds,          // Load Direct
AVR_ld,           // Load Indirect
AVR_ldd,          // Load Indirect with Displacement
AVR_sts,          // Store Direct to SRAM
AVR_st,           // Store Indirect
AVR_std,          // Store Indirect with Displacement
AVR_lpm,          // Load Program Memory
AVR_in,           // In Port
AVR_out,          // Out Port
AVR_push,         // Push Register on Stack
AVR_pop,          // Pop Register from Stack

// BIT AND BIT-TEST INSTRUCTIONS
AVR_lsl,          // Logical Shift Left
AVR_lsr,          // Logical Shift Right
AVR_rol,          // Rotate Left Through Carry
AVR_ror,          // Rotate Right Through Carry
AVR_asr,          // Arithmetic Shift Right
AVR_swap,         // Swap Nibbles
AVR_bset,         // Flag Set
AVR_bclr,         // Flag Clear
AVR_sbi,          // Set Bit in I/O Register
AVR_cbi,          // Clear Bit in I/O Register
AVR_bst,          // Bit Store from Register to T
AVR_bld,          // Bit load from T to Register
AVR_sec,          // Set Carry
AVR_clc,          // Clear Carry
AVR_sen,          // Set Negative Flag
AVR_cln,          // Clear Negative Flag
AVR_sez,          // Set Zero Flag
AVR_clz,          // Clear Zero Flag
AVR_sei,          // Global Interrupt Enable
AVR_cli,          // Global Interrupt Disable
AVR_ses,          // Set Signed Test Flag
AVR_cls,          // Clear Signed Test Flag
AVR_sev,          // Set Two's Complement Overflow
AVR_clv,          // Clear Two's Complement Overflow
AVR_set,          // Set T in SREG
AVR_clt,          // Clear T in SREG
AVR_seh,          // Set Half Carry Flag in SREG
AVR_clh,          // Clear Half Carry Flag in SREG
AVR_nop,          // No Operation
AVR_sleep,        // Sleep
AVR_wdr,          // Watchdog Reset

AVR_last,

    };

