;_kickgtr v0.1 by iLUVATAR
;
;identifies some GTR versions by checking IDT/GDT limits and base addresses

code    segment
        assume  cs:code
        org     100h

.386p

start:  db      'IC4M'           ; badge
        dw      0                ; header version
        db      '_kickgtr  '     ; name of the modul
        dw      20 dup (0ffffh)  ; ffffh = no entry

        sub     sp,12
        mov     bp,sp
        sidt    qword ptr [bp]
        sgdt    qword ptr [bp+6]
        cmp     word ptr [bp],17fh      ;IDT limit
        jne     noGTR
        mov     eax,dword ptr [bp+2]
        sub     eax,dword ptr [bp+8]
        shl     eax,16
        jc      noGTR                   ;overflow ?
        mov     ax,word ptr [bp+6]
        xor     ecx,ecx
checkGTR:
        cmp     eax,dword ptr cs:[ecx*4+offset GTRtbl]
        je      halt
        inc     cx
        cmp     cl,4
        jb      checkGTR

noGTR:  lea     sp,[bp+12]
        ret

halt:   cli
        mov     ax,0ffffh
        out     21h,ax
        mov     dx,0cf9h                ;supported by many Intel Chipsets
        mov     al,10b                  ;= hard reset
        out     dx,al
        mov     al,100b                 ;perform reset (not traped by GTR)
        out     dx,al
        mov     al,0feh
        out     64h,al
        jmp     halt

gtrtbl  equ     $
        dw      9fh,255ch               ;GTR v1.CI ?
        dw      97h,1548h               ;GTR v1.B0 ?
        dw      67h,4814h               ;GTR v1.A0 ?
        dw      67h,4804h               ;GTR v1.9X/1.84 ?

code    ends
        end     start