; Program name: PESHiELD 0.2b2 Unpacker
; Version:      1.00 (supports files smaller than ~60kb)
; Author:       Unknown One/[TMG]
; Target:       PESHiELD 0.2b2 encrypted files
; Music:        Metallica (all), Offspring, W.A.S.P.
; Greetings (in alphabetical order ;):
;   ANAKiN, Ambijambi, CHRiSTOPH, Cyber Daemon, DaFixer, exit_2, gamumba,
;   hutch, Iczelion, LightDruid, merlin, NetWalker!, Quantico, r!sc, reus,
;   ROSE, SnowPanther, Stonehead, tE!, VAG, Virogen, xOANON,
;   all people in #win32asm, #cracking4newbies, #cracking, #ug2000,
;   #phm (UniBG irc) and everyone I forgot :)

; Group greets: TMG, ECL, UCF, UG, AOI, PHM

; Compile with TASM (1.0 should work?)
;   tasm /z/m unpes
;   tlink /x/t unpes
; Usage:
;   unpes <filename>

; Personal note to author of PESHiELD:
; ANAKiN, we are waiting for the new PESHiELD (3 months over a long time ago after 0.25 version;).
; I hope it will be again the best protector! BTW is PE-Pack updated/improved?

; History
; ~~~~~~~
; 10-12-2000    - written decryptor for PESHiELD layer
; 10-13-2000    - reading more about PE files :)
; 10-14-2000    - fixed decryptor of first layer because I found that it is mutated
; 10-15-2000    - added sections unpacking
;               - added import rebuild
; 10-16-2000    - fixed the buggy import section detection and few bugs
;               - added multiple PESHiELD layers support
; 10-17-2000    - recoded some parts of the unpacker to look better as source code ;)
;               - added command line parameter (before it was static name)
;               - cleaning and fixing the comments on source
; 10-18-2000    - test with more encrypted files - successfull ;)
;               - recoded the PESHiELD layer detection (now it uses the EntryPoint RVA)
;               - added displaying of layers information (ideas from PEUNLOCK-NT by xOANINO)
;               - sent to EXE List v1.00 :)

.model tiny             ; Yeah, it is COM file :)
.code                   ; Only 1 segment
.386c                   ; 32-bit instructions used

crlf    equ     0dh,0ah

        org     100h
start   proc
        jmp     begin

copyright       db      'PESHiELD 0.2b2 Unpacker v1.00',crlf
                db      'Coded by Unknown One/[TMG]',crlf,crlf,'$'
not_mz_err      db      'Not valid EXE file (''MZ'' signature does not present)!',crlf,'$'
not_pe_err      db      'Not valid PE file (''PE'' signature does not present)!',crlf,'$'
no_peshield_err db      'PESHiELD v0.2b2 layer not found!',crlf,'$'
import_err      db      'Cannot rebuild import section (not found)!',crlf,'$'
cant_open_err   db      'Cannot open input file!',crlf,'$'
file_big_err    db      'File is too big (supported file size is < 60kb)',crlf,'$'

success_msg     db      'File successfully unpacked!',crlf,'$'
layer_num_msg   db      'Unpacking layer          : 99',crlf,'$'
entry_rva_msg   db      'Original Entry Point RVA : 12345678',crlf,crlf,'$'
new_line        db      crlf,'$'

usage_msg       db      'Usage: unpes <filename>',crlf
                db      '  where <filename> is 8.3 format file name',crlf,crlf
                db      'NOTE: This unpacker can unpack only files smaller than ~60kb!',crlf
                db      '      Next version will be coded in win32asm and will support all files.',crlf
                db      '      If you find file protected with PESHiELD 0.2b2 and this unpacker',crlf
                db      '      fails (the file size should be <60kb), please send me e-mail with',crlf
                db      '      the file to: unknone@mail.com',crlf
                db      '$'

infname         db      80h dup(?)      ; Input file name buffer
outfname        db      'out.exe',00h   ; Output file name
f_len           dw      ?               ; File length (max 60kb files are supported!)

sections_start  dw      ?               ; Pointer to sections headers start in memory
pe_start        dw      ?               ; Pointer to PE header start in memory
decr_section_offset     dw      ?       ; Offset of decrypted section to start from

import_rva      dw      ?               ; Import table RVA
import_addr     dw      ?               ; Offset in my memory

decr_num        db      ?               ; Number of decrypted PESHiELD layers (for info)

begin:  push    cs              ; Not needed at all because this is .COM file
        pop     ds              ;

        mov     ah,09h          ; Show copyright message ;)
        lea     dx,copyright    ;
        int     21h             ;

;------ Scan command line and get file name
        mov     si,0081h        ; DS:SI points to command line parameters
        cld
; Trim leading spaces
cl_1:   lodsb                   ; Get char
        cmp     al,' '          ; Space?
        je      cl_1
        dec     si              ; Correct SI to point to previous char in command line
        lea     di,infname      ; ES:DI points to file name buffer
cl_2:   lodsb
        cmp     al,' '          ; If space reached - exit
        je      end_of_name
        cmp     al,0dh          ; CR?
        je      end_of_name
        cmp     al,0ah          ; LF?
        je      end_of_name
        stosb
        jmp     cl_2

end_of_name:
        xor     al,al           ; Create zero terminated string
        stosb                   ;

        cmp     byte ptr [infname],00h  ; No file name entered?
        jne     open_the_file

        mov     ah,09h          ; Show help message
        lea     dx,usage_msg    ;
        int     21h             ;
        mov     ax,4c00h
        int     21h

open_the_file:
        mov     ax,3d00h        ; Open file for reading function
        lea     dx,infname      ; DS:DX points to file name
        int     21h             ; Do it
        jnc     fopen_ok        ; If not error - continue

        mov     ah,09h          ; Show error message
        lea     dx,cant_open_err
        int     21h

        mov     ax,4c01h        ; Exit program with error code 1
        int     21h             ;

;------ File is opened OK, check size now (supported files up to 60 kilos)
fopen_ok:
        xchg    ax,bx           ; BX is the file handle

        mov     ax,4202h        ; Go to end of file to get it's length in DX:AX
        sub     cx,cx           ;
        sub     dx,dx           ;
        int     21h             ;

        or      dx,dx           ; Check if file is greater than 64 kilos
        jz      fsize_check_1

file_is_too_big:
        mov     ah,09h          ; Show error message
        lea     dx,file_big_err
        int     21h
        mov     ax,4c02h        ; Exit program with error code 2
        int     21h             ;

fsize_check_1:
        cmp     ax,0ea00h       ; <~60000 bytes?
        ja      file_is_too_big

;------ Go to beginning of file
        mov     ax,4200h
        sub     cx,cx
        sub     dx,dx
        int     21h

;------ Read file in memory
        mov     ah,3fh          ; Read from file
        mov     cx,0ffffh       ; Max 64kb (already checked file size)
        lea     dx,buffer       ; DS:DX points to read buffer
        int     21h             ;
        mov     f_len,ax

        mov     ah,3eh          ; Close file
        int     21h             ;


        mov     decr_num,00h    ; Set number of decrypted PESHiELD layers to 0

.radix 16d                      ; Ripped parts may have hex numbers left without 'h'

;------ Check for valid EXE file
check_exe:
        lea     bp,buffer       ; EBP points to EXE file start (EXE header) in memory
        cmp     word ptr [bp],'ZM'      ; Check for valid EXE file
        je      valid_exe

        mov     ah,09h          ; Show error message
        lea     dx,not_mz_err   ;
        int     21h             ;

        mov     ax,4c03h        ;
        int     21h             ; Exit

;------ Check for valid PE file
valid_exe:
        mov     si,word ptr [bp+3ch]    ; Get PE header start
        add     si,bp                   ; SI points to PE header
        cmp     word ptr [si],'EP'      ; Check for valid PE file
        je      valid_pe

        mov     ah,09h                  ; Show error message
        lea     dx,not_pe_err           ;
        int     21h                     ;

        mov     ax,4c04h                ; Exit
        int     21h                     ;

;------ Find the still unpacked PESHiELD layer in file
valid_pe:
        mov     pe_start,si

;------ Find the section where is the PESHiELD layer (lame detection, must use entry point)
        mov     di,word ptr [si+14h]    ; get NT Header Size
        add     di,18h                  ; Add offset of Flags field
        add     di,si                   ; make edi = Object Table Address

        mov     sections_start,di       ; Save for later use

        mov     eax,dword ptr [si+28h]  ; EAX is Entry Point RVA

; Find the section where is placed entry point
        mov     cx,word ptr [si+06h]    ; CX=sections number
        mov     si,di
scan_1: cmp     eax,dword ptr [si+000ch]; Compare import RVA with this section RVA
        je      ep_found
        jb      ep_prev_sect
        add     si,0028h                ; SI points to next section
        loop    scan_1
        jmp     write_file              ; Go to write file (there is check for number of
                                        ; decrypted PESHiELD layers :)
ep_prev_sect:
        sub     si,0028h
ep_found:
        sub     eax,dword ptr [si+000ch]; EAX is offset of entry point within
        mov     ebp,dword ptr [si+0014h]; SI is file offset of import section
        add     bp,offset buffer        ; Correct to memory address
        add     bp,ax                   ; Correct pointer to real offset

;------ Check first instruction(s) of code
        cmp     dword ptr [bp],0000e860h; First instruction(s) of PESHiELD 0.2b2
        jne     go_write_file

;------ Check if 'ANAKIN' ID is here
        cmp     dword ptr [bp+0006h],'KANA'
        je      peshield_found          ; Found it :)
go_write_file:
        jmp     write_file              ; Go to write output file (all/none layers unpacked)

; Let's start unpacking (danger process because may crash)
peshield_found:
;#####################################################################
;------ First layer decrypting (re-coded for 16-bit regs :)
; IMPORTANT NOTE!!!
; The first layer is mutated very little (the decryption instructions only)
; Instruction example (in hex):
; 80 c7 xx - add bh,xx
; 80 f7 xx - xor bh,xx
; the 1st byte is constant prefix, the 3rd byte is data used
; the 2nd byte has this format:
;  7 6 5 4 3 2 1 0
; +-+-+-+-+-+-+-+-+
; | | | | | | | | |
; +-+-+-+-+-+-+-+-+
;  | | | | | | | |
;  | | | | | +-+-+----- Register/Modifier - shows which reg is used
;  | | +-+-+----------- Instruction modifier - shows which instruction is
;  | |                  used: 000-add*, 001-or, 010-adc, 011-sbb,
;  | |                        100-and, 101-sub*, 110-xor*, 111-cmp
;  | |                  Only marked with * are used
;  +-+----------------- Address method (11h if R/M is used as reg selector)
; The mutation is weak by several reasons:
; 1. It uses constant length decryptor (the main reason because it is easy
;    to copy the decryptor layer and execute it (dangerous!) as Iczelion did in his
;    unpacker for PESHiELD 0.25)
; 2. No A/D tricks are used (very easy to trace with every debugger)
; 3. No random length garbage instructions between decryption instructions and
;    that makes possible to obtain the used instruction and to make pure
;    ungeneric unpacker using simple emulation (this method is used below)
; 4. Junk/fake macros (nebel-bombs as ROSE define them) can stop only
;    newbies (MOW can remove most of them even in win32 code :) and disassembly
;    is shit easy :((
;
; The used decryption secuence looks like this:
;       mov     ebx,byte_counter
; label1:
;       mov     dl,byte ptr [esi+ebx]   ; Get byte
;       xor     dl,bl           ; Constant
;      *sub     dl,constant1    ; MUTATED instruction
;      *xor     dl,constant2    ; MUTATED instruction
;       mov     byte ptr [esi+ebx],dl   ; Save decrypted byte
;       dec     ebx
;       jnz     label1
; All used registers are mutated. Only the marked two instructions are
; mutated to use different decryption in every file. ADD, XOR and SUB
; instructions are the only used for mutating (easy to analyze)

        lea si, dword ptr [bp+00000031h]; (E)SI points to data that will be decrypted
        mov bx,word ptr [bp+001bh]      ; length of processed data
u1:
        mov dl, byte ptr [si+bx]
        xor dl, bl

; These two instructions are mutated!
;       sub dl,byte ptr [bp+0026h]
;       xor dl,byte ptr [bp+0029h]

; Emulate the first mutated instruction
        mov     ax,word ptr [bp+25h]    ; Get the mutator byte and data
        call    mut_emulate             ; Emulate the mutated operation

; Emulate the second mutated instruction
        mov     ax,word ptr [bp+28h]    ; Get the mutator byte and data
        call    mut_emulate             ; Analyze and emulate

        mov byte ptr [si+bx], dl        ; Store decrypted byte
        dec bx
        jne u1

;------ Second layer decrypt (use of check sum for key calculation)
        std
        lea si, dword ptr [bp+000011D7h]
        mov edi, esi

        mov edx,0ffffffffh              ; mov dx,cs; lsl edx,edx (load selector limit)

        xor edx, dword ptr [bp+000011DBh]
        mov ecx, 0000043Ch              ; Bytes to decrypt (1084 dec)

u2:
        push ecx
        push eax
        mov ecx, 000000E8h

;------ Key calculation using check sum
u3:
        mov eax,0ffffffffh
        add edx, eax
        dec ebp
        add edx, dword ptr [ebp+ecx]
        inc ebp
        rol edx, cl
        dec ecx
        jne u3

        pop eax
        pop ecx

        xor eax,eax

        xor eax, dword ptr [esi]     ; EAX=57cfxxxxh
        sub esi, 00000004h
        xor eax, edx                 ; edx=b0286xxxh
        add edx, eax
        mov dword ptr [ebp+000000D8h], edx
        rol edx, cl
        stosd
        inc dword ptr [ebp+62h]
        dec ecx
        jne u2

;------ Layer 3
        cld
        lea si, dword ptr [bp+00000110h]
        mov ecx,dword ptr [bp+00fah]
        mov al,byte ptr[bp+0103h]
u5:
        xor byte ptr [si], al
        inc si
        dec cx
        jne u5

;------ Layer 4
        lea si, dword ptr [bp+00000134h]
        mov ecx,dword ptr [bp+0120h]
        mov al,byte ptr [bp+0129h]
u6:
        xor byte ptr [si], al
        inc si
        dec cx
        jne u6

;------ Layer 5
        lea si, dword ptr [bp+0000015C]
        mov ecx,dword ptr [bp+143h]
        mov al,byte ptr [bp+14eh]
u7:
        xor byte ptr [si], al
        inc si
        dec cx
        jne u7

;------ Layer 6
        lea si, dword ptr [bp+00000186h]
        mov ecx,dword ptr [bp+016dh]
        mov al,byte ptr [bp+0177h]
u8:
        xor byte ptr [si], al
        inc esi
        dec ecx
        jne u8

;------ Layer 7
        lea si, dword ptr [bp+000001ACh]
        mov ecx,dword ptr [bp+196h]
        mov al,byte ptr [bp+19fh]
u9:
        xor byte ptr [si], al
        inc esi
        dec ecx
        jne u9

;------ Layer 8 (final before peshield layer is decrypted)
        lea si, dword ptr [bp+000001D6h]
        mov ecx,dword ptr [bp+1bbh]
        mov al,byte ptr [bp+1c5h]
u10:
        xor byte ptr [si], al
        inc si
        dec cx
        jne u10

;------ Decrypt additional part inside PESHiELD layer
        lea si, dword ptr [bp+0000039Dh]
        mov di, si
        mov cx, 000000A1h              ; Always the same???
u11:
        lodsb
        xor al,byte ptr [bp+038ch]
        xor al, cl
        stosb
        dec cx
        jne u11

;#####################################################################
;------ Decrypt some data (strings) - used only for reverse engineering of PESHiELD :)
        mov ebx, dword ptr [bp+000011B9h]       ; Decryption key
        lea si, dword ptr [bp+00000E7Eh]        ; Pointer to encrypted data
        call decrypt_something                  ; See below the ripped procedure
        call decrypt_something                  ; Use ESI and EBX from previous call
        call decrypt_something
        call decrypt_something
        call decrypt_something
        call decrypt_something

        mov ebx, dword ptr [bp+000011CDh]
        lea si, dword ptr [bp+00001026h]
        call decrypt_something
        call decrypt_something
        call decrypt_something

;#####################################################################
;------ Decrypt the sections

; I found some files that doesnt use key correction and has a big
; amount of the code NOPed (not MOW-ed!). I made the check for
; correction of the encryption key by comparing the part of the
; code with NOPs. If someone know how to make better check, please mail me
        cmp     dword ptr [bp+04d8h],90909090h
        je      skip_key_correct

        mov bx,sections_start                   ; BX points to first section header
        movzx eax, byte ptr [bx+0024h]          ; Get section flags
        mov ah, al
        add dword ptr [bp+00001165h], eax       ; Correct encryption key

skip_key_correct:
        mov esi, dword ptr [bp+00001175h]       ; ESI -> ebp+00001268h
        add si, bp                              ;
        mov ebx, dword ptr [bp+00001165h]       ; EBX is ecnryption key

        push    sections_start                  ; Save sections start for later use

ds_1:   mov     decr_section_offset,0000h       ; Offset withing section of encrypted data
        mov     di,sections_start
        mov     edi,dword ptr [di+14h]  ; DI=physical offset of section
        add     di,offset buffer        ; Correct with buffer start

        lodsd                           ; Get section start address
        or eax, eax                     ; Check for last entry
        je ds_exit                      ; If so - exit

        push    si
        push    di

        mov edi, eax                    ; Decrypt start address
        xor edi, ebx                    ;
        rol ebx, 1                      ;
        add ebx, edi                    ;

; Check if the section is encrypted (the only way I found to check this
; is to check if section RVA in EDI is the same as in the
; section header). I am currently looking for better detection because
; infinite loop may occur (lazy to code one with more checks)
ds_3:
        mov     si,sections_start       ; SI points to section start
        cmp     edi,dword ptr [si+000ch]; Compare decrypted VA with SVA

        je      ds_encrypted
        jb      shit_offset
        add     sections_start,0028h    ; Skip to next section
        jmp     ds_3                    ; Go to check next section

shit_offset:
        sub     sections_start,0028h    ; Go to previous section

        mov     si,sections_start
        sub     edi,dword ptr [si+000ch]; Sub section RVA from calculated one
        mov     decr_section_offset,di  ; Save offset in section of the crypted data

ds_encrypted:
        pop     di
        pop     si

        mov     di,sections_start
        mov     edi,dword ptr [di+14h]  ; DI=physical offset
        add     di,offset buffer        ; Correct with buffer start
        add     di,decr_section_offset  ; Add offset where to start decrypt from

        lodsd
        mov     ecx, eax                ; ECX is length (in dwords)
        xor     ecx, ebx                ;

        lodsd                           ; EAX is 2nd encryption key
        add     eax, ebx                ;
        rol     ebx, 1                  ;

ds_2:
        xor     dword ptr [di], eax
        xor     dword ptr [di], ecx
        rol     eax, 02h
        add     eax, ecx
        add     edi, 00000004h
;       dec     ecx
        dec     cx
        jne     ds_2

        add     sections_start,0028h    ; Points to next section
        jmp ds_1

ds_exit:

        pop     sections_start          ; Restore sections header address


;#####################################################################
;------ Import section rebuilding (decrypt functions names)
; Everything in Import section is OK except all functions names are
; encrypted. Import section RVA is at [ebp+1195h]. Again sections
; scanning is performed to find where to decrypt
        mov     eax,dword ptr [bp+1195h]; EAX=import section RVA
        mov     si,sections_start

        mov     bx,pe_start
        mov     cx,word ptr [bx+06h]    ; CX is sections counter

is_1:   cmp     eax,dword ptr [si+000ch]; Compare import RVA with this section RVA
        je      is_found
        jb      imps_is_previous
        add     si,0028h                ; SI points to next section
        loop    is_1

        mov     ah,09h                  ; Show error message
        lea     dx,import_err           ;
        int     21h                     ;
        jmp     is_exit                 ; No import section found! Do not exit (for now)

imps_is_previous:
        sub     si,0028h                ; SI points to previous section

is_found:
        sub     eax,dword ptr [si+000ch]; EAX is offset of import withing
        push    ax                      ; the section (used below)

        mov     eax,dword ptr [si+000ch]; EAX is the import table RVA
        mov     import_rva,ax           ; used for find file offset of imported
                                        ; function

        mov     esi,dword ptr [si+0014h]; SI is file offset of import section
        add     si,offset buffer        ; Correct to memory address

        pop     ax                      ; AX is offset within section of
        mov     bx,si                   ; import stuff
        add     bx,ax                   ; Correct BX ;)

        mov     import_addr,si

is_start:
        mov     edx,dword ptr [bx+000ch]; EBX -> DLL name
        or      edx,edx                 ; NULL pointer?
        jz      is_exit                 ; If so - exit rebuilding of import section

        mov     esi,dword ptr [bx]      ; ESI=OriginalFirstThunk RVA
        mov     edi,dword ptr [bx+10h]  ; EDI=FirstThunk RVA
        or      esi,esi                 ; Is OriginalFirstThunk RVA NULL?
        jnz     is_2                    ;
        mov     esi,edi                 ; If NULL, then get FirstThunk RVA

is_2:
        add     si,import_addr          ; Make them real addresses
        add     di,import_addr          ; in my memory space

        sub     si,import_rva           ; Correct
        sub     di,import_rva           ;

is_3:
        mov     eax,dword ptr [si]      ; EAX=pointer to imported function
        or      eax,eax                 ; End of functions for this DLL?
        jz      is_next_dll             ; Go to process next DLL
        jns     is_4                    ; If named function - go to process it
        movzx   eax,ax                  ; Imported ordinal fn - unencrypted!
        jmp     is_5
is_4:
        inc     eax
        inc     eax

        push    si

        mov     esi,eax

        sub     si,import_rva           ;
        add     si,import_addr          ; Correct

        push    bx
        mov     ebx,dword ptr [ebp+11a9h]
        call    decrypt_something       ; Decrypt function name
        mov     dword ptr [ebp+11a9h],ebx
        pop     bx

        pop     si
is_5:
        add     esi, 00000004
        add     edi, 00000004
        jmp     is_3                    ; Process next function

is_next_dll:
        add     ebx, 00000014h          ; EDX points to next
        jmp     is_start

is_exit:

;#####################################################################
;------ Decrypt ORIGINAL ENTRY POINT and set directory entries in PE header
        mov     si,pe_start
;int 3
        mov     eax, dword ptr [bp+00001169h]   ; EAX -> encrypted OEP
        xor     eax, dword ptr [bp+000011C1h]   ; Decrypt OEP
        mov     dword ptr [si+28h],eax          ; Save new entry point

;;;;;;; dec     word ptr [si+0006h]             ; Decrement sections number (NO!!!)

        mov     eax,dword ptr [bp+1195h]        ; Get Import RVA
        mov     dword ptr [si+80h],eax          ; Save at directories data
        mov     eax,dword ptr [bp+11adh]        ; Get Import section size
        mov     dword ptr [si+84h],eax          ; Save at PE header

        inc     decr_num                        ; Increase decrypted PESHiELD layers number

        call    show_info                       ; Show current layer info

        jmp     check_exe                       ; Check for another layer

;------ Write file to disk
write_file:

        cmp     decr_num,0      ; Check if no PESHiELD layers are decrypted
        jne     real_write_file

        mov     ah,09h
        lea     dx,no_peshield_err
        int     21h
        mov     ax,4c00h
        int     21h

real_write_file:
        mov     ax,3c00h        ; Create file function
        mov     cx,0000h        ; Normal attributes
        lea     dx,outfname     ; DS:DX points to file name
        int     21h             ; Create output file

        xchg    ax,bx           ; BX is file handle

        mov     ah,40h
        mov     cx,f_len
        lea     dx,buffer
        int     21h             ; Write

        mov     ah,3eh
        int     21h             ; Close

        mov     ah,09h          ; Show successful unpacking message
        lea     dx,success_msg  ;
        int     21h             ;

        mov     ax,4c00h        ; Exit
        int     21h             ;
start   endp

mutate_error    db      'Mutation error! Execution aborted!',crlf,'$'

; This procedure emulates mutated instruction (only the modifier in AH)
; using the data from AL. Result returned in DL
; Only mutated instructions are marked with *
;  000-add*, 001-or, 010-adc, 011-sbb,
;  100-and, 101-sub*, 110-xor*, 111-cmp
mut_emulate     proc
        xchg    ah,al           ; Correct the data from little endian order

        and     ah,00111000b    ; Mask instruction selector
        shr     ah,03h          ;

        or      ah,ah           ; Is it ADD instruction?
        jz      mut_emul_add

        cmp     ah,05h          ; Is it SUB instruction?
        jz      mut_emul_sub

        cmp     ah,06h          ; Is it XOR instruction?
        jz      mut_emul_xor

; Abnormal termination!!!
        push    cs
        pop     ds
        mov     ah,09h
        lea     dx,mutate_error
        int     21h
        mov     ax,4cffh
        int     21h

mut_emul_xor:
        xor     dl,al
        ret

mut_emul_sub:
        sub     dl,al
        ret

mut_emul_add:
        add     dl,al
        ret
mut_emulate     endp

;=======================
; Decrypt some data (some strings)
;=======================
decrypt_something       proc
decr_smth_1:
        mov al, byte ptr [si]
        or al, al
        je decr_smth_2
        mov al, bl
        and al, 1Fh
        xor byte ptr [si], al
        rol ebx, 04h
        inc esi
        jmp decr_smth_1

decr_smth_2:
        inc esi
        ret
decrypt_something       endp

; Show information of decrypted layer (number of decryption layer, entry point RVA)
show_info       proc
        mov     al,decr_num
        aam
        add     ax,3030h
        xchg    ah,al
        cmp     decr_num,09h
        ja      show_info_1
        mov     al,' '
        xchg    ah,al
show_info_1:
        mov     word ptr [layer_num_msg+1bh],ax
        mov     ah,09h
        lea     dx,layer_num_msg
        int     21h

        mov     si,pe_start

        mov     eax,dword ptr [si+0028h]
        shr     eax,18h
        call    byte2hex
        mov     word ptr [entry_rva_msg+1bh],ax

        mov     eax,dword ptr [si+0028h]
        shr     eax,10h
        call    byte2hex
        mov     word ptr [entry_rva_msg+1dh],ax

        mov     eax,dword ptr [si+0028h]
        shr     eax,08h
        call    byte2hex
        mov     word ptr [entry_rva_msg+1fh],ax

        mov     eax,dword ptr [si+0028h]
        call    byte2hex
        mov     word ptr [entry_rva_msg+21h],ax

        mov     ah,09h
        lea     dx,entry_rva_msg
        int     21h
        ret
show_info       endp

; Word to ASCII hex number
byte2hex        proc
        aam
        org     $-1
        db      10h
b2h_3:
        daa
        cmp     al,0Fh
        sbb     al,0CFh
        xchg    ah,al
        test    al,0F0h
        je      b2h_3
        xchg    al,ah
        ret
byte2hex        endp


buffer  label   byte

        end     start
