;==================================================================================
;								PEShield Unpacker for PEShield 0.25
;==================================================================================
; Coded by Iczelion
; Release date: 28 March 2000
; Contact: Iczelion@galaxycorp.com
;------------------------------------------------------------------------------------------------------------------------------------------------
.386
.model flat,stdcall
include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\comdlg32.inc
include \masm32\include\user32.inc
includelib \masm32\lib\user32.lib
includelib \masm32\lib\comdlg32.lib
includelib \masm32\lib\kernel32.lib

SEH struct
	PrevLink dd ?		; the address of the previous seh structure
	CurrentHandler dd ?	; the address of the new exception handler
	SafeOffset dd ?	; The offset where it's safe to continue execution
	PrevEsp dd ?		; the old value in esp
	PrevEbp dd ?		; The old value in ebp
SEH ends


SectionInfo struct		; This is the structure I designed to keep track of the sections read into memory
	VirtualAddress dd ?
	RawSize dd ?
	BufferAddr dd ?
SectionInfo ends

.data
AppName db "UnPeShield v.0.25 by Iczelion - [version 1.1]",0
ofn   OPENFILENAME <>
FilterString db "Executable Files (*.exe)",0,"*.exe",0
             db "All Files",0,"*.*",0,0
NotValidPE db "This file is not a PE file",0             
NotEncryptedByPEShield db "This file is not encrypted by PESHiELD",0
OutputName db "output.exe",0
Finished db "Decryption finished!",0
SaveCancel db "Decryption Cancelled!",0
             
.data?
buffer db 512 dup(?)			; used to store the name of the file returned by common dialogs
hFile dd ?					; file handle returned by CreateFile
hMapping dd ?				; file mapping handle returned by CreateFileMapping
pMapping dd ?				; pointer to the memory mapped file
ValidPE dd ?				; a flag used to indicate whether the target is a valid PE file, TRUE/FALSE
SectionArray SectionInfo 30 dup(<>)		; array used to keep track of sections read into memory. Maximum 30 sections
pSectionTable dd ?			; pointer to the section table in memory mapped file
NumSection dd ?			; Number of sections in the target file
SizeOfDecrypterSection dd ?	; The size in bytes of the decrypter section

.code
start:
;======================================================================
;   Ask the user for the target file
;======================================================================
	mov ofn.lStructSize,SIZEOF ofn
	mov  ofn.lpstrFilter, OFFSET FilterString
	mov  ofn.lpstrFile, OFFSET buffer
	mov ofn.lpstrTitle,offset AppName
	mov  ofn.nMaxFile,512
	mov  ofn.Flags, OFN_FILEMUSTEXIST or \
                       OFN_PATHMUSTEXIST or OFN_LONGNAMES or\
                       OFN_EXPLORER or OFN_HIDEREADONLY
	invoke GetOpenFileName, ADDR ofn
	.if eax!=NULL
		invoke CreateFile,addr buffer, GENERIC_READ, FILE_SHARE_READ,NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL,NULL
		.if eax!=INVALID_HANDLE_VALUE
			mov hFile,eax
			invoke CreateFileMapping,hFile, NULL, PAGE_READONLY,0,0,0
			.if eax!=NULL
				mov hMapping,eax
				invoke MapViewOfFile,hMapping,FILE_MAP_READ,0,0,0
				.if eax!=NULL
					mov pMapping,eax
					call UnpackTheFile		; The real workhorse
					invoke UnmapViewOfFile,pMapping
				.else
					call ShowErrorMsg
				.endif
			.else
				call ShowErrorMsg
			.endif
			invoke CloseHandle,hFile
		.else
			call ShowErrorMsg
		.endif
	.endif	
	invoke ExitProcess, 0
	
ShowErrorMsg proc	
	invoke GetLastError
	mov edx,eax
	invoke FormatMessage,FORMAT_MESSAGE_FROM_SYSTEM,0,edx,0,addr buffer,1024,NULL
	invoke MessageBox,NULL,addr buffer,addr AppName,MB_OK+MB_ICONERROR
	ret
ShowErrorMsg endp

SEHHandler proc C uses edx pExcept:DWORD,pFrame:DWORD,pContext:DWORD,pDispatch:DWORD
	mov edx,pFrame		
	assume edx:ptr SEH
	mov eax,pContext
	assume eax:ptr CONTEXT
	push [edx].SafeOffset
	pop [eax].regEip
	push [edx].PrevEsp
	pop [eax].regEsp
	push [edx].PrevEbp
	pop [eax].regEbp
	mov ValidPE, FALSE
	mov eax,ExceptionContinueExecution
	ret
SEHHandler endp

IsPEFile proc
	LOCAL seh:SEH
	assume fs:nothing
	push fs:[0]
	pop seh.PrevLink
	mov seh.CurrentHandler,offset SEHHandler
	mov seh.SafeOffset,offset FinalExit
	lea eax,seh
	mov fs:[0], eax
	mov seh.PrevEsp,esp
	mov seh.PrevEbp,ebp
	mov edi, pMapping
	assume edi:ptr IMAGE_DOS_HEADER
	.if [edi].e_magic==IMAGE_DOS_SIGNATURE
		add edi, [edi].e_lfanew
		assume edi:ptr IMAGE_NT_HEADERS
		.if [edi].Signature==IMAGE_NT_SIGNATURE
			mov ValidPE, TRUE
		.else
			mov ValidPE, FALSE
		.endif
	.else
		mov ValidPE,FALSE
	.endif
FinalExit:
	push seh.PrevLink
	pop fs:[0]	
	mov eax,ValidPE
	ret
IsPEFile endp

DecryptMainBlock proc uses edi esi pDecrypter:DWORD
	push ebp
	mov ebp,pDecrypter	
	std
	xor edx,edx
	dec edx
	xor edx,[ebp+12B7h]
	lea esi,[ebp+12B3h]
	mov edi,esi
	mov ecx,469h
ModifyEncryptionSalt:
	push ecx
	push eax
	mov ecx,110h
InnerModificationLoop:
	xor eax,eax
	dec eax
	add edx,eax
	dec ebp
	add edx,[ebp+ecx]
	inc ebp
	rol edx,cl
	dec ecx
	jnz InnerModificationLoop
	pop eax
	pop ecx
	lodsd
	xor eax,edx
	add edx,eax
	mov [ebp+100h],edx
	rol edx,cl
	stosd	
	inc dword ptr [ebp+87h]
	dec ecx
	jnz ModifyEncryptionSalt
	cld
	pop ebp		
	ret
DecryptMainBlock endp

FirstDecryption proc uses edi esi pDecrypter
	LOCAL DecryptCode[31]:BYTE
	mov DecryptCode[30],0C3h
	lea esi, DecryptCode
	push ebp
	mov ebp,pDecrypter
	mov edi,ebp
	add edi,39h
	invoke RtlMoveMemory,esi,edi,30
	call esi
	pop ebp	
	ret
FirstDecryption endp

LayeredDecryption proc uses edi esi pDecrypter:DWORD
	pusha
	mov ebp,pDecrypter
	lea esi,[ebp+138h]
	mov ecx,dword ptr [ebp+122h]
	mov al,[ebp+12bh]
FifthLayerDecryption:	
	sub [esi],al
	inc esi
	loop FifthLayerDecryption
	lea esi,[ebp+15ch]
	mov ecx,dword ptr [ebp+148h]
	mov al,[ebp+151h]
FourthLayerDecryption:
	xor [esi],al
	inc esi
	loop FourthLayerDecryption
	lea esi,[ebp+184h]
	mov ecx,dword ptr [ebp+16bh]
	mov al,[ebp+176h]
ThirdLayerDecryption:
	add [esi],al
	inc esi
	loop ThirdLayerDecryption
	lea esi,[ebp+1aeh]
	mov ecx, dword ptr [ebp+195h]
	mov al,[ebp+19fh]
SecondLayerDecryption:
	xor [esi],al
	inc esi
	loop SecondLayerDecryption
	lea esi,[ebp+1d4h]
	mov ecx, dword ptr [ebp+1beh]
	mov al,[ebp+1c7h]
FirstLayerDecryption:
	add [esi],al
	inc esi
	loop FirstLayerDecryption
	lea esi,[ebp+1feh]
	mov ecx,dword ptr [ebp+1e3h]
	mov al,[ebp+1edh]
MainLayerDecryption:
	xor [esi],al
	inc esi
	loop MainLayerDecryption	
	popa
	ret
LayeredDecryption endp

DecryptVitalCode proc pDecrypter:DWORD
	pusha
	mov ebp,pDecrypter
	lea esi,[ebp+402h]
	mov edi,esi
	mov ecx,0A1h
	mov bl, [ebp+3f1h]
DecryptionLoop:
	lodsb
	xor al,cl
	xor al,bl
	stosb
	loop DecryptionLoop		
	popa
	ret
DecryptVitalCode endp

DecryptData proc
	mov al,[esi]
	or al,al
	jz IncrementSourceAndReturn
	mov al,bl
	and al,1Fh
	xor [esi],al
	rol ebx,4
	inc esi
	jmp DecryptData
IncrementSourceAndReturn:
	inc esi	
	ret
DecryptData endp

GetEncryptionInfoArraySalt proc
	mov eax,dword ptr [edi+129fh]
	mov ebx,8088405h
	imul eax,ebx
	inc eax
	ret
GetEncryptionInfoArraySalt endp

DecryptThisSection proc pSection:DWORD,pEncryptionInfo:DWORD,pDecrypter:DWORD
	LOCAL VirtualAddress:DWORD
	LOCAL EncryptionSalt:DWORD
	pushad
	mov edi,pSection
	mov esi,pEncryptionInfo
	push dword ptr [esi]
	pop VirtualAddress
	mov ecx,dword ptr [esi+4]
	mov edx,dword ptr [esi+8]
DecryptSec:
	xor dword ptr [edi],ecx
	xor dword ptr [edi],edx
	rol edx,3
	add edx,ecx
	add edi,4
	loop DecryptSec
	;================================================
	; Check if this section is import
	;================================================
	mov ebx,pDecrypter
	mov eax,[ebx+1273h]
	.if eax>=dword ptr [esi]
		mov ecx,dword ptr [esi]
		add ecx,dword ptr [esi+4]
		.if eax<=ecx
			mov edx,dword ptr [esi]
			sub eax,edx
			push [ebx+1287h]
			pop EncryptionSalt
			mov esi,pSection
			add esi,eax	; esi points to the import table
			assume esi:ptr IMAGE_IMPORT_DESCRIPTOR
ProcessEachEntry:
			.if [esi].Name1!=0			
				mov edx,[esi].OriginalFirstThunk
				.if edx==0
					mov edx,[esi].FirstThunk
				.endif
				sub edx,VirtualAddress
				add edx,pSection	; edx points to the thunk dwords
ProcessThunks:				
				mov ebx,dword ptr [edx]
				or ebx,ebx
				jz NextEntry
				js NextThunk
				pusha
				sub ebx,VirtualAddress
				add ebx,pSection
				add ebx,2
				mov esi,ebx
				mov ebx,EncryptionSalt
				invoke DecryptData
				mov EncryptionSalt,ebx
				popa
NextThunk:
				add edx,4				
				jmp ProcessThunks
NextEntry:
				add esi,sizeof IMAGE_IMPORT_DESCRIPTOR
				jmp ProcessEachEntry				
			.endif
		.endif
	.endif
	popad
	ret
DecryptThisSection endp

DecryptSections proc pEncryptionInfo:DWORD,pDecrypter:DWORD
	mov esi,offset SectionArray
	assume esi:ptr SectionInfo
	mov edi,pSectionTable
	assume edi:ptr IMAGE_SECTION_HEADER
	mov ecx,NumSection
	.while ecx>0
		push ecx
		;====================================================
		; Check if this section is encrypted
		;====================================================
		push edi
		mov edi,pEncryptionInfo
		.while dword ptr [edi]!=0
			mov eax,[esi].VirtualAddress
			.if dword ptr [edi]>=eax	; if the virtual addresses match
				add eax,dword ptr [esi].RawSize
				.if dword ptr [edi]<eax
					mov edx,dword ptr [edi]
					sub edx,dword ptr [esi].VirtualAddress
					add edx,dword ptr [esi].BufferAddr
					invoke DecryptThisSection,edx,edi,pDecrypter
					.break
				.endif
			.endif
			add edi,12
		.endw		
		pop edi
		add esi,sizeof SectionInfo
		add edi,sizeof IMAGE_SECTION_HEADER
		pop ecx
		dec ecx
	.endw
	ret
DecryptSections endp

DecryptStrings  proc uses esi ebx pDecrypter:DWORD
	push ebp
	mov ebp,pDecrypter
	mov ebx,[ebp+12abh]
	lea esi,[ebp+1100h]
	invoke DecryptData
	invoke DecryptData
	invoke DecryptData
	mov ebx,[ebp+1297h]
	lea esi,[ebp+0f58h]
	invoke DecryptData
	invoke DecryptData
	invoke DecryptData
	invoke DecryptData
	invoke DecryptData
	invoke DecryptData
	pop ebp
	ret
DecryptStrings endp

DeAllocateSections proc
	mov edi,offset SectionArray
	assume edi:ptr SectionInfo
	.while [edi].VirtualAddress!=0
		invoke VirtualFree,[edi].BufferAddr, [edi].RawSize,MEM_DECOMMIT
		add edi,sizeof SectionInfo
	.endw
	ret
DeAllocateSections endp

WriteToFile proc uses edi esi ebx pPEHdr:DWORD, EPRVA:DWORD,pDecrypter:DWORD
	LOCAL pHeaders:DWORD
	LOCAL hOutput:DWORD
	LOCAL BytesWritten:DWORD
	mov esi,pPEHdr
	assume esi:ptr IMAGE_NT_HEADERS
	invoke VirtualAlloc,0, [esi].OptionalHeader.SizeOfHeaders,MEM_COMMIT,PAGE_READWRITE
	mov pHeaders,eax	
	invoke RtlMoveMemory,eax,pMapping,[esi].OptionalHeader.SizeOfHeaders
	mov edi,pHeaders
	assume edi:ptr IMAGE_DOS_HEADER
	add edi,[edi].e_lfanew
	assume edi:ptr IMAGE_NT_HEADERS
	push EPRVA
	pop [edi].OptionalHeader.AddressOfEntryPoint
	mov ebx,pDecrypter
	push [ebx+1273h]
	pop dword ptr [edi].OptionalHeader.DataDirectory[8]
	push [ebx+128fh]
	pop dword ptr [edi].OptionalHeader.DataDirectory[12]
	;===============================================
	; ask the user for the name of the output file
	;===============================================
	mov ofn.lStructSize,SIZEOF ofn
	mov  ofn.lpstrFilter, OFFSET FilterString
	mov  ofn.lpstrFile, OFFSET buffer
	mov dword ptr ds:buffer,0	; no suggested filename
	mov  ofn.nMaxFile,512
	mov  ofn.Flags, OFN_PATHMUSTEXIST or OFN_LONGNAMES or  OFN_EXPLORER
	invoke GetSaveFileName, ADDR ofn
	.if eax==TRUE
		;=====================================================
		; Create the output file
		;=====================================================
		invoke CreateFile,addr buffer,GENERIC_READ+GENERIC_WRITE, 0, 0, CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL, NULL
		.if eax!=INVALID_HANDLE_VALUE
			mov hOutput,eax
			invoke WriteFile,hOutput,pHeaders,[edi].OptionalHeader.SizeOfHeaders,addr BytesWritten,0
			push esi
			mov esi,offset SectionArray
			assume esi:ptr SectionInfo
			.while [esi].VirtualAddress!=0
				invoke WriteFile,hOutput, [esi].BufferAddr, [esi].RawSize,addr BytesWritten,0
				add esi,sizeof SectionInfo
			.endw
			pop esi
			invoke CloseHandle,hOutput
			invoke MessageBox,0,addr Finished,addr AppName,MB_OK+MB_ICONINFORMATION
		.else
			call ShowErrorMsg
		.endif
	.else
		invoke MessageBox,0, addr SaveCancel, addr AppName,MB_OK+MB_ICONINFORMATION
	.endif
	assume esi:ptr IMAGE_NT_HEADERS
	invoke VirtualFree,pHeaders,[esi].OptionalHeader.SizeOfHeaders,MEM_DECOMMIT	
	ret
WriteToFile endp

IsPEShield proc uses edi ecx
	LOCAL Result:DWORD
	mov Result, FALSE
	assume edi:ptr IMAGE_SECTION_HEADER
	mov edi,pSectionTable
	mov ecx,NumSection
	.while ecx>0
		mov esi,pMapping
		add esi,[edi].PointerToRawData	; esi points to the section
		.if [edi].SizeOfRawData >= 4
			.if dword ptr [esi]==2be860h
				mov Result,TRUE
				push [edi].SizeOfRawData
				pop SizeOfDecrypterSection 
				.break
			.endif
		.endif
		dec ecx
		add edi,sizeof IMAGE_SECTION_HEADER
	.endw
	mov eax,Result
	ret
IsPEShield endp

CheckIfStillEncrypted proc uses edi ppDecrypter:DWORD
	LOCAL Result:DWORD
	LOCAL seh:SEH
	assume fs:nothing
	mov Result,FALSE
	push fs:[0]
	pop seh.PrevLink
	mov seh.CurrentHandler,offset SEHHandler
	mov seh.SafeOffset,offset FinalExit1
	lea eax,seh
	mov fs:[0], eax
	mov seh.PrevEsp,esp
	mov seh.PrevEbp,ebp
	mov edi,offset SectionArray
	assume edi:ptr SectionInfo
	.while [edi].VirtualAddress!=0
		mov eax,[edi].BufferAddr
		.if dword ptr [eax]==2be860h
			mov Result,TRUE
			mov edx,ppDecrypter
			mov dword ptr [edx],eax
			push [edi].RawSize
			pop SizeOfDecrypterSection
			.break
		.endif
		add edi,sizeof SectionInfo
	.endw
	push seh.PrevLink
	pop fs:[0]	
	mov eax,Result
	ret
FinalExit1:
	push seh.PrevLink
	pop fs:[0]	
	mov eax,FALSE
	ret	
CheckIfStillEncrypted endp

ReadSectionsIntoMemory proc pDecrypterData:DWORD
	mov esi,offset SectionArray
	assume esi:ptr SectionInfo
	mov edi,pSectionTable
	assume edi:ptr IMAGE_SECTION_HEADER
	mov ecx,NumSection
	.while ecx>0
		push ecx
		invoke VirtualAlloc,0, [edi].SizeOfRawData,MEM_COMMIT,PAGE_READWRITE
		push dword ptr [edi].VirtualAddress
		pop [esi].VirtualAddress
		push dword ptr [edi].SizeOfRawData
		pop [esi].RawSize
		mov [esi].BufferAddr,eax
		push esi
		mov esi,pMapping
		add esi,[edi].PointerToRawData
		invoke RtlMoveMemory,eax,esi,[edi].SizeOfRawData
		pop esi	
		.if [edi].SizeOfRawData > 4
			mov eax,dword ptr [esi+8]
			.if dword ptr [eax]==2be860h
				mov ecx,pDecrypterData
				mov dword ptr [ecx],eax
			.endif
		.endif
		pop ecx
		dec ecx
		add esi,sizeof SectionInfo
		add edi,sizeof IMAGE_SECTION_HEADER
	.endw
	mov dword ptr [esi],0
	ret
ReadSectionsIntoMemory endp

DecryptTheDecrypter proc pDecrypter:DWORD	; the decrypter section is encrypted several folds
	invoke FirstDecryption,pDecrypter
	invoke DecryptMainBlock,pDecrypter
	invoke LayeredDecryption,pDecrypter
	invoke DecryptVitalCode,pDecrypter
	invoke DecryptStrings,pDecrypter
	ret
DecryptTheDecrypter endp

UnpackTheFile proc
	LOCAL pDecrypter:DWORD		; pointer to the decrypter section in memory
	LOCAL pPEHdr:DWORD			; pointer to the pe header in memory mapped file
	LOCAL EPRVA:DWORD			; real entrypoint address of the target
	LOCAL pEncryptionInfo:DWORD	; pointer to the encryption info array
	call  IsPEFile		; Check if the target is a PE
	.if eax==TRUE	; edi points to the pe header if it's a valid pe file
		mov pPEHdr,edi
		;==============================================================;
		; Obtain the number of sections                                                                                     ;
		;==============================================================;
		assume edi:ptr IMAGE_NT_HEADERS
		mov ax,[edi].FileHeader.NumberOfSections
		movzx eax,ax
		mov NumSection,eax
		;==============================================================;
		; Obtain the address of the section table in memory mapped file                      ;
		;==============================================================;
		mov esi,edi
		add esi,sizeof IMAGE_NT_HEADERS	; esi points to the section table
		mov pSectionTable,esi
		invoke IsPEShield		; Check if the target is encrypted by PEShield
		.if eax==TRUE		; yes, this file is encrypted by PEShield
			invoke ReadSectionsIntoMemory, addr pDecrypter	; Read all sections in the target into memory
DecryptLoop:			
			invoke DecryptTheDecrypter,pDecrypter	; Decrypt the decrypter section
			;==============================================================
			; Obtain the real address of entrypoint
			;==============================================================
			mov edi,pDecrypter
			mov eax,dword ptr [edi+1247h]
			xor eax,dword ptr [edi+129fh]
			mov EPRVA,eax
			;=============================================================
			;  Obtain the address of the encryption info array
			;=============================================================
			mov esi,pDecrypter
			add esi,dword ptr [edi+1253h]		; esi points to the encryption info array
			mov pEncryptionInfo,esi
			;=============================================================
			; Decrypt the encryption info array
			;=============================================================
			call GetEncryptionInfoArraySalt
			.while dword ptr [esi]!=0
				xor dword ptr [esi],eax
				rol eax,1
				add eax,dword ptr [esi]
				xor dword ptr [esi+4],eax
				add dword ptr [esi+8],eax
				rol eax,1					
				add esi,12
			.endw
			invoke DecryptSections,pEncryptionInfo,pDecrypter	; decrypt all the encrypted sections
			;===========================================================================
			; Destroy the dword we use as the PEShield signature so we don't decrypt it over and over
			;===========================================================================
			mov eax,pDecrypter
			mov dword ptr [eax],0
			invoke CheckIfStillEncrypted,addr pDecrypter	; check if the target is encrypted multiple times by PEShield
			.if eax==TRUE
				jmp DecryptLoop
			.endif
			invoke WriteToFile, pPEHdr,EPRVA, pDecrypter	; write the final output to a file
			invoke DeAllocateSections	; free all allocated memory blocks
		.else
			invoke MessageBox,0,addr NotEncryptedByPEShield,addr AppName,MB_OK+MB_ICONERROR
		.endif
	.else
		invoke MessageBox,0,addr NotValidPE,addr AppName,MB_OK+MB_ICONERROR
	.endif
	ret
UnpackTheFile endp

end start
