;*****************************************************************************S
;==============================================================================
; Test Department presents Win32 Assembly Tutorial 000		01.03.1999
;==============================================================================
; This is the basic mask for our assembler programs.
; It is always the same procedure if we create a program, we must INCLUDE *inc
; and *lib files, declare API FUNCTIONS, define CONSTANTS, define DATA and at
; last write the new CODE into the code area.
; Feel free to assemble and link this program but do not be afraid if nothing
; happens, it is only a basic mask with no other functions than start & exit.
;==============================================================================
;******************************************************************************

.386			; specifies the processor our program want run on
.Model Flat ,StdCall	; always the same for Win95 (32 Bit)

;------------------------------------------------------------------------------
; Include all files where API functins resist you want use
; You must set the correct path to the include and library files
;------------------------------------------------------------------------------
include \masm32\include\windows.inc
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib

;------------------------------------------------------------------------------
; Declaration of used API functions,take a look into WIN32.HLP and *.inc files
; GetModulHandle= the API function, add "A" because YOU push the parameter(s)
; PROTO 	= one or more parameter must pushed to the stack before call
; :DWORD 	= the parameter, in this case doubleword (32 Bit)
;------------------------------------------------------------------------------
GetModuleHandleA	PROTO :DWORD
ExitProcess		PROTO :DWORD

;------------------------------------------------------------------------------
; .const 	= the constants area starts here,constants are defined & fixed
; no_const_used	= the constant name
; equ 		= the value for this constant name follows
; 0Ah 		= the value in hexadezimal
;------------------------------------------------------------------------------
.const
example_const		equ 0Ah		;not used, example only

;------------------------------------------------------------------------------
; .Data		= the data area starts here, datas are defined but not fixed
; db		= databyte 	1 Byte (8 Bit)
; dw		= dataword 	2 Byte (16 Bit)
; dd		= doubleword	4 Byte (32 Bit)
; Textstrings are databytes and must be terminated by ,0
; ,13,10 means control and line feed
; db 41h dup (0)= reserves 41 hexadezimal databytes initialized to zero
;------------------------------------------------------------------------------
.Data
example_text 		db "First row",13,10		;not used,example only
			db "Second row",0		;
hInstance		dd 0h				;our program handle

;------------------------------------------------------------------------------
; .Data?	= the data? area starts here, not defined and not fixed
;------------------------------------------------------------------------------
.data?
example_data?		dd ?		;not used,example only

;------------------------------------------------------------------------------
; .CODE		= our code area starts here
; Main		= label of our program code
;------------------------------------------------------------------------------
.Code
Main:

;==============================================================================
; Always get your program ID first (API=GetModuleHandleA)
;------------------------------------------------------------------------------
push	0h				;lpModuleHandle, 0=get program handle
call 	GetModuleHandleA		;- API Function -
mov	hInstance,eax			;value in eax=handle of our program
;==============================================================================



;==============================================================================
; Next we terminate our program (API=ExitProcess)
;------------------------------------------------------------------------------
ExitPrg:				;label for later use
push	hInstance			;push our programm handle to exit
call	ExitProcess			;- API Function -
;==============================================================================


;------------------------------------------------------------------------------
; end Main	= end of our program code
;------------------------------------------------------------------------------
end Main				;end of our program code, entry point

;******************************************************************************
;==============================================================================
;To create the exe file use this commands with your Microsoft Assembler/Linker
;------------------------------------------------------------------------------
; ml.exe /c /coff testdep0.asm					;asm command
; rc.exe /v rsrc.rc						;rc command
; cvtres.exe rsrc.res
; link.exe /subsystem:windows testdep0.obj rsrc.obj		;link command
;==============================================================================
; Test Department presents Win32 Assembly Tutorial 000		01.03.1999
;==============================================================================
;*****************************************************************************E