;*****************************************************************************S
;==============================================================================
; Test Department presents Win32 Assembly Tutorial 001		01.03.1999
;==============================================================================
; In this tutorial 001 we create our first window using the basic asm mask
; from tutorial 000 and adding the code for the window.
; You can also see this file testdep1.asm as a basic mask to create a window.
; All the action code relating to this window (like menu bar items) resist in
; the WindowProc lpfnWndProc.
; "lpfnWndProc" is a pointer to the subroutine label "WindowProc" where all the
; action code for this window resist.
; "lpfnWndProc" is part of WndClassEx structure used by API RegisterClassEx. 
;------------------------------------------------------------------------------
; First we declare 11 more API functions:
; LoadIconA		PROTO :DWORD,:DWORD
; LoadCursorA		PROTO :DWORD,:DWORD
; RegisterClassExA	PROTO :DWORD
; CreateWindowExA	PROTO :DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,
; 			      :DWORD,:DWORD,:DWORD,:DWORD,:DWORD
; ShowWindow		PROTO :DWORD,:DWORD
; UpdateWindow		PROTO :DWORD
; GetMessageA 		PROTO :DWORD,:DWORD,:DWORD,:DWORD
; TranslateMessage 	PROTO :DWORD
; DispatchMessageA 	PROTO :DWORD
; PostQuitMessage 	PROTO :DWORD
; DefWindowProcA 	PROTO :DWORD,:DWORD,:DWORD,:DWORD
;
; We also nee some datas:
; .Data
; ClassName		db "TestDepWinClass",0	;name of windows class
; WindowName		db "Test Department",0  ;window name titel bar
;
; - WndClassEx Structure ( API=RegisterClassExA ) -
;cbSize			dd 0h		;size in bytes of this structure
;style			dd 0h		;window style
;lpfnWndProc		dd 0h		;address of user proc function
;cbclsExtra		dd 0h		;extra bytes to allocate set to 0
;cbWndExtra		dd 0h		;extra bytes class directive, rc file
;hInstance		dd 0h		;program handle(API=GetModuleHandleA)
;hIcon			dd 0h		;handle of icon (API=LoadIconA)
;hCursor		dd 0h		;handle of cursor (API=LoadCursor)
;hbrBackground		dd 2h		;background color, 0=transparent
;lpszMenuName 		dd 0h		;name of menu class in resource file
;lpszClassName		dd 0h		;name of windows this window class
;hIconSm		dd 0h		;iconhandle 0=search in resource file

; - Push Parameter done by lpfnWndProc Function ( API=RegisterClassExA )
; - Windows gives this parameter to our WindowProc routine on the stack !
;WP1_CallBack		dd 0h		;return address of calling routine
;WP1_hwnd		dd 0h		;handle of window who receives mesg.
;WP1_uMsg		dd 0h		;the message number 
;WP1_wParam		dd 0h		;extra info about the message 
;WP1_lParam		dd 0h		;extra info about the message 

; - Msg Structure ( API=GetMessageA ) -
;hwnd			dd 0h		;handle of window who receives message
;message		dd 0h		;the message number
;wParam			dd 0h		;extra info about the message
;lParam			dd 0h		;extra info about the message 
;time			dd 0h		;time the message was posted 
;pt			dd 0h		;cursor position message posted
;	
;==============================================================================
;******************************************************************************

.386			; specifies the processor our program want run on
.Model Flat ,StdCall	; always the same for Win95 (32 Bit)

;------------------------------------------------------------------------------
; Include all files where API functins resist you want use
; You must set the correct path to the include and library files
;------------------------------------------------------------------------------
include \masm32\include\windows.inc
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib

;------------------------------------------------------------------------------
; Declaration of used API functions,take a look into WIN32.HLP and *.inc files
; GetModulHandle= the API function, add "A" because YOU push the parameter(s)
; PROTO 	= one or more parameter must pushed to the stack before call
; :DWORD 	= the parameter, in this case doubleword (32 Bit)
;------------------------------------------------------------------------------
GetModuleHandleA	PROTO :DWORD
LoadIconA		PROTO :DWORD,:DWORD
LoadCursorA		PROTO :DWORD,:DWORD
RegisterClassExA	PROTO :DWORD
CreateWindowExA		PROTO :DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,
			      :DWORD,:DWORD,:DWORD,:DWORD,:DWORD
ShowWindow		PROTO :DWORD,:DWORD
UpdateWindow		PROTO :DWORD
GetMessageA 		PROTO :DWORD,:DWORD,:DWORD,:DWORD
TranslateMessage 	PROTO :DWORD
DispatchMessageA 	PROTO :DWORD
PostQuitMessage 	PROTO :DWORD
DefWindowProcA 		PROTO :DWORD,:DWORD,:DWORD,:DWORD
ExitProcess		PROTO :DWORD

;------------------------------------------------------------------------------
; .const 	= the constants area starts here,constants are defined & fixed
; example_const	= the constant name
; equ 		= the value for this constant name follows
; 0Ah 		= the value in hexadezimal
;------------------------------------------------------------------------------
.const
example_const		equ 0Ah		;not used, example only

;------------------------------------------------------------------------------
; .Data		= the data area starts here, datas are defined but not fixed
; db		= databyte 	1 Byte (8 Bit)
; dw		= dataword 	2 Byte (16 Bit)
; dd		= doubleword	4 Byte (32 Bit)
; Textstrings are databyte and must be terminated by ,0
; ,13,10 means control and line feed
; db 41h dup (0)= reserved 41 hexadezimal databytes initialized to zero
;------------------------------------------------------------------------------
.Data
example_text 		db "First row",13,10	;not used,example only
			db "Second row",0	;
IconName		db "TDIcon",0		;icon name in rc file
MenuName		db "TDMenu",0		;menu name in rc file
ClassName		db "TestDepWinClass",0	;name of windows class
WindowName		db "Test Department",0  ;window name titel bar

; - WndClassEx Structure ( API=RegisterClassExA ) -
cbSize			dd 0h		;size in bytes of this structure
style			dd 0h		;window style
lpfnWndProc		dd 0h		;address of user proc function
cbclsExtra		dd 0h		;extra bytes to allocate set to 0
cbWndExtra		dd 0h		;extra bytes class directive, rc file
hInstance		dd 0h		;program handle(API=GetModuleHandleA)
hIcon			dd 0h		;handle of icon (API=LoadIconA)
hCursor			dd 0h		;handle of cursor (API=LoadCursor)
hbrBackground		dd 2h		;background color, 0=transparent
lpszMenuName 		dd 0h		;name of menu class in resource file
lpszClassName		dd 0h		;name of windows this window class
hIconSm			dd 0h		;iconhandle 0=search in resource file

; - Push Parameter done by lpfnWndProc Function ( API=RegisterClassExA )
WP1_CallBack		dd 0h		;return address of calling routine
WP1_hwnd		dd 0h		;handle of window who receives message
WP1_uMsg		dd 0h		;the message number 
WP1_wParam		dd 0h		;extra info about the message 
WP1_lParam		dd 0h		;extra info about the message 

; - Msg Structure ( API=GetMessageA ) -
hwnd			dd 0h		;handle of window who receives message
message			dd 0h		;the message number
wParam			dd 0h		;extra info about the message
lParam			dd 0h		;extra info about the message 
time			dd 0h		;time the message was posted 
pt			dd 0h		;cursor position message posted	

;------------------------------------------------------------------------------
; .Data?	= the data? area starts here, not defined and not fixed
;------------------------------------------------------------------------------
.data?
example_data?		dd ?		;not used, example only

;------------------------------------------------------------------------------
; .CODE		= our code area starts here
; Main		= label of our program code
;------------------------------------------------------------------------------
.Code
Main:

;==============================================================================
; Always get your program ID first (API=GetModuleHandleA)
;------------------------------------------------------------------------------
push	0h				;lpModuleHandle, 0=get program handle
call 	GetModuleHandleA		;- API Function -
mov	hInstance,eax			;return value in eax=handle of program
;==============================================================================


;==============================================================================
; The API function "RegisterClassExA" registers a window class
; This API needs a "WNDCLASSEX" structure so we fill it with correct values
;------------------------------------------------------------------------------
mov	cbSize,30h			;size in bytes of WNDCLASSEX structure
mov	style,3h			;window style
mov	lpfnWndProc,OFFSET WP1		;address of user lpfnWndProc function
mov	cbclsExtra,0h			;extra bytes to allocate set to 0
mov	cbWndExtra,0h			;class directive in rc file
mov	hbrBackground,2h		;background,1=background(parameter+1)
mov	lpszMenuName,OFFSET MenuName	;menu name in resource file
mov	lpszClassName,OFFSET ClassName	;name of windows class
mov	hIconSm,0h			;iconhandle 0=search in rc file
;------------------------------------------------------------------------------
; API "LoadIconA" loads an icon defined in the resource file and store the
; handle in the "WNDCLASSEX" structure
;------------------------------------------------------------------------------
push	OFFSET IconName 		;icon-string or icon resource id
push	hInstance			;our program handle
call 	LoadIconA			;- API Function -
mov	hIcon,eax			;handle of newly loaded icon
;------------------------------------------------------------------------------
; API "LoadCursorA" loads a default system cursor, in this case we must set
; hInstance to 0 and lpCursorName to a default system cursor value, here 32512
; Then we store the cursor handle in the "WNDCLASSEX" structure
;------------------------------------------------------------------------------
push	32512				;lpCursorName,default value in dezimal
push	0h				;hInstance, 0=default system cursor
call	LoadCursorA			;- API Function -
mov	hcursor,eax			;handle of the cursor
;------------------------------------------------------------------------------
; Now, after filled the "WNDCLASSEX" structure we call API "RegisterClassEx"
;------------------------------------------------------------------------------
push	OFFSET cbSize			;pointer to WNDCLASSEX structure
call 	RegisterClassExA		;- API Function -
;==============================================================================


;==============================================================================
; API "CreateWindowExA" creates an overlapped, pop-up, or child window with an
; extended style. The return value in EAX is the handle of the new window.
;------------------------------------------------------------------------------			
push	0h				;lpParam, extra pointer data 0=no data
push	hInstance			;hInstance, handle of our program
push 	0h				;hMenu, handle window menu 0=class menu
push	0h				;hWndParent, handle parent window 0=no
push	000000F8h			;intnHeight, window height pixel
push	0000020Ah			;intnWidth, window width pixel
push	000000A0h			;inty, vertical position window
push	000000B0h			;intx, horizontal position window
push	04CA0000h			;dwStyle, 0=no sysmenu/close buttons
push	OFFSET WindowName		;lpWindowName, pointer to window name
push	OFFSET ClassName		;lpClassName, pointer to class name
push	0300h				;dwExStyle, extra window style 0=no
call	CreateWindowExA			;- API Function -
mov	hwnd,eax			;hwnd,return value=handle of window
;==============================================================================


;==============================================================================
; API "ShowWindow" function sets the specified window's show state. 
;------------------------------------------------------------------------------
push 	1h				;nCmdShow, show state 1=SW_SHOWNORMAL
push 	hwnd				;hwnd, handle of window
call 	ShowWindow			;- API Function -
;==============================================================================


;==============================================================================
; API "UpdateWindow" updates the area of the specified window by sending a
; WM_PAINT message to the window if the window's update region is not empty.
;------------------------------------------------------------------------------
push 	hwnd				;hwnd, handle of window
call	UpdateWindow			;- API Function -
;==============================================================================


;==============================================================================
; API "GetMessageA" retrieves a message & places it in the specified structure.
;------------------------------------------------------------------------------
LoopGetMessage:
push	0h				;wMsgFilterMax, highest message value
push	0h				;wMsgFilterMin, lowest message value
push	0h				;hWnd, handle of window who gets msg.
push	OFFSET hwnd			;lpMsg, pointer to MSG structure
call	GetMessageA			;- API Function -
cmp	eax,0h				;check if return value=0 (exit)
je	ExitPrg				;if return value is 0 goto LABEL
;==============================================================================


;==============================================================================
; API "TranslateMessage" translates key code into ASCII character messages
;------------------------------------------------------------------------------
push	OFFSET hwnd			;lpMSG, pointer to msg structure
call	TranslateMessage		;- API Function - keyboard code
;==============================================================================


;==============================================================================
; API "DispatchMessageA" function dispatches a message to a window procedure.
;------------------------------------------------------------------------------
push	OFFSET hwnd			;lpMSG, pointer to msg structure
call	DispatchMessageA		;- API Function -
jmp	LoopGetMessage			;check for message again, goto LABEL
;==============================================================================


;==============================================================================
; Next we terminate our program (API=ExitProcess)
;------------------------------------------------------------------------------
ExitPrg:
push	hInstance			;push our programm handle to exit
call	ExitProcess			;- API Function -
;==============================================================================


;##############################################################################
;==============================================================================
; This is the Window Procedure lpfnWndProc (API=RegisterClassExA) for this
; registered window.
; The WindowProc function is an application-defined callback function that
; processes messages sent to a window. 
; Here our code for checking the receiving messages resist.
; In the future it is the main work for us to react to the recieved messages.
; First we POP all parameter given by Windows from the stack and store them in
; variables for later use.
; It is also a good idea to PUSHAD all register, because than we are free to
; use all register in this window procedure.
; Before we leave this subroutine we must POPAD them back. 
;------------------------------------------------------------------------------
WP1:
pop 	WP1_CallBack			;return address lpfnWndProc
pop	WP1_hwnd			;handle of window who receives message
pop	WP1_uMsg			;the message number
pop	WP1_wParam			;extra info about the message
pop	WP1_lParam			;extra info about the message
pushad					;push all register to the stack
mov	eax,WP1_uMsg			;move the message number in eax
cmp	eax,2h				;check if value=2h (WM_DESTROY)
jne	WP1_0Fh				;if not 2h go to LABEL
;------------------------------------------------------------------------------
; API "PostQuitMessage" indicates to Windows a request to terminate
;------------------------------------------------------------------------------
popad					;pop all register back from stack
push	0h				;nExitCode, exit code=wParam
call 	PostQuitMessage			;- API Function -
xor	eax,eax				;set eax to 0 to exit our program
push	WP1_CallBack			;return address lpfnWndProc
ret					;return to lpfnWndProc


;==============================================================================
; WM_PAINT (value=0Fh) message, used to repaint the window area
;------------------------------------------------------------------------------
WP1_0Fh:
cmp	eax,0Fh				;check if WP_PAINT message recieved
jne	WP1_111h			;if not goto label

jmp	WP1_return


;==============================================================================
; WM_COMMAND (value=111h) message recieved ?
;------------------------------------------------------------------------------
WP1_111h:				;WM_COMMAND message, value=111h
cmp	eax,111h			;check if WM_COMMAND message recieved
jne	WP1_return			;if not goto label


;==============================================================================
; Check for extra message information, "&Exit" item in menu bar
;------------------------------------------------------------------------------
WP1_1h:
mov	eax,WP1_wParam			;extra info about the message
cmp	eax,1h				;ID of "&Exit" item in rc file
jne	WP1_2h				;if not 1h goto LABEL


;==============================================================================
; Check for extra message information, "&Copy" item in menu bar
;------------------------------------------------------------------------------
WP1_2h:
cmp	eax,2h				;ID of "&Copy" item in rc file
jne	WP1_return			;if not 2h goto LABEL


;==============================================================================
; API "DefWindowProcA" calls the window procedure to provide default processing
; for any window messages that an application does not process.
; This function ensures that every message is processed.
; It is called with the same parameters received by the window procedure. 
;------------------------------------------------------------------------------
WP1_return:
popad					;pop all register from stack
push	WP1_lParam			;extra info about the message
push	WP1_wParam			;extra info about the message
push	WP1_uMsg			;the message number
push	WP1_hwnd			;handle of window who receives message
call	DefWindowProcA			;- API Function -
push	WP1_CallBack			;return address lpfnWndProc
ret					;return to lpfnWndProc (multitask os)
;==============================================================================
;##############################################################################

;------------------------------------------------------------------------------
; end Main	= end of our program code
;------------------------------------------------------------------------------
end Main				;end of our program code, entry point


;******************************************************************************
;==============================================================================
;To create the exe File use this Commands with your Microsoft Assembler/Linker
;------------------------------------------------------------------------------
; ml.exe /c /coff testdep1.asm					;asm command
; rc.exe /v rsrc.rc						;rc command
; cvtres.exe rsrc.res
; link.exe /subsystem:windows testdep1.obj rsrc.obj		;link command
;==============================================================================
; Test Department presents Win32 Assembly Tutorial 001		01.03.1999
;==============================================================================
;*****************************************************************************E