/*--------------------------------------------------------------------------*/
// Example code by Miz (CodeRage@bigfoot.com)
// Windoze 'Pre-Patcher' For Beginners ;)
// LSG-Ware - If you like/use please listen to the genius of Oliver Lieb ;)
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
#define	WIN32_LEAN_AND_MEAN			//	Eliminate some unnecessary headers
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
#include	<windows.h>
#include	<windowsx.h>
#include	<stdlib.H>
#include	"resource.h"
#include	"commctrl.h"
#include	"commdlg.h"
#include	"stdio.h"
#include	"commctrl.h"
#include	"commdlg.h"
#include	"io.h"
#include	"string.h"

#include	"Inc\File.h"
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
typedef struct s_PatchDef
{
	long			Offset;
	int				Count;
	unsigned char	Data[];
}t_PatchDef;

typedef struct
{
	char			NoDamage_State;
	char			NoObjCol_State;
	char			Expert_State;
	char			ModifyTime_State;
	char			RepairTime_State;
	char			AllCars_State;
	char			TimeOfDay_State;
	char			Weather_State;
	char			Shift_State;
	char			QuickRestart_State;
	char			TrackDetail_State;
	char			ObjDetail_State;
}t_PatchConfig;
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
extern HINSTANCE	MainInstance;
STARTUPINFO			StartupInfo;
PROCESS_INFORMATION	ProcessInfo;

t_PatchConfig		PatchCfg;
char				DayTexSelection[14][_MAX_PATH];
int					FileRequestOn;
int					ChangedTextureInfo;
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
// No Damage
t_PatchDef		Patch1_Off  = {0x0001D3E3, 5, {0x8b, 0x45, 0x08, 0x05, 0xcc}};
t_PatchDef		Patch1_On   = {0x0001D3E3, 5, {0xe9, 0xf2, 0x01, 0x00, 0x00}};

// No Object Collision
t_PatchDef		Patch2_Off  = {0x0003FF2F, 4, {0x68, 0xc0, 0xcb, 0x75}};
t_PatchDef		Patch2_On   = {0x0003FF2F, 4, {0x33, 0xc0, 0xeb, 0x06}};

// Infinite Modify Time
t_PatchDef		Patch4a_Off = {0x000880C4, 2, {0x2b, 0xd1}};
t_PatchDef		Patch4b_Off = {0x0008806F, 2, {0x03, 0xc8}};
t_PatchDef		Patch4a_On  = {0x000880C4, 2, {0x90, 0x90}};
t_PatchDef		Patch4b_On  = {0x0008806F, 2, {0x90, 0x90}};

// Infinite Repair Time
t_PatchDef		Patch5a_Off = {0x0008820C, 2, {0x2b, 0xc2}};
t_PatchDef		Patch5b_Off = {0x00088168, 2, {0x03, 0xc8}};
t_PatchDef		Patch5a_On  = {0x0008820C, 2, {0x90, 0x90}};
t_PatchDef		Patch5b_On  = {0x00088168, 2, {0x90, 0x90}};

// All Cars In All Difficulty Levels
t_PatchDef		Patch6a_Off = {0x000F8E8A, 8, {0xc7, 0x45, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xa1}};
t_PatchDef		Patch6b_Off = {0x000FCE90, 8, {0x74, 0x09, 0x8a, 0x4d, 0xe8, 0x80, 0xc9, 0x0f}};
t_PatchDef		Patch6a_On  = {0x000F8E8A, 8, {0x33, 0xc0, 0x40, 0xe9, 0xc3, 0x00, 0x00, 0x00}};
t_PatchDef		Patch6b_On  = {0x000FCE90, 8, {0x90, 0x90, 0x8a, 0x4d, 0xe8, 0x80, 0xc9, 0x3f}};

//User Selectable Time Of Day
t_PatchDef		Patch7_Off  = {0x000772EE, 4, {0x74, 0x07, 0xb8, 0x08}};
t_PatchDef		Patch7_On   = {0x000772EE, 4, {0x90, 0x90, 0xb8, 0x00}};

//User Selectable Weather
t_PatchDef		Patch8_Off  = {0x00077221, 4, {0x74, 0x07, 0xb8, 0x01}};
t_PatchDef		Patch8_On   = {0x00077221, 4, {0x90, 0x90, 0xb8, 0x00}};

//Single Shift (Like GP2!)
t_PatchDef		Patch9_Off  = {0x0004E1C3, 26,
							  {0x74, 0x0a, 0x8b, 0x45, 0x08, 0xc6, 0x80, 0x14,
							   0x03, 0x00, 0x00, 0x01, 0x33, 0xc9, 0x66, 0x8b,
                               0x0d, 0x40, 0x76, 0x5b, 0x00, 0x8b, 0x55, 0xf8,
                               0x23, 0xd1}};

t_PatchDef		Patch9_On   = {0x0004E1C3, 26,
							  {0x74, 0x26, 0x8b, 0x45, 0x08, 0xb2, 0x01, 0x8b,
							   0x4d, 0xfc, 0x80, 0xe1, 0x14, 0x75, 0x03, 0x80,
							   0xea, 0x02, 0x88, 0x90, 0x14, 0x03, 0x00, 0x00,
							   0xeb, 0x0e}};

//QuickRestart
t_PatchDef		Patch10_Off  = {0x00073A64, 9, {0x6a, 0x00, 0x6a, 0x00, 0x68, 0xd2, 0x4e, 0x47, 0x00}};
t_PatchDef		Patch10_On   = {0x00073A64, 9, {0x6a, 0x00, 0x68, 0x94, 0x51, 0x47, 0x00, 0xeb, 0x26}};

//Track Detail - Modify Draw Engine DrawDistances For Fast 3DCards
t_PatchDef		Patch11a_Off  = {0x000F1251, 1, {0x03}};
t_PatchDef		Patch11b_Off  = {0x000394CF, 1, {0x04}};
t_PatchDef		Patch11c_Off  = {0x000394EA, 1, {0x04}};
t_PatchDef		Patch11a_On   = {0x000F1251, 1, {0x07}};
t_PatchDef		Patch11b_On   = {0x000394CF, 1, {0x06}};
t_PatchDef		Patch11c_On   = {0x000394EA, 1, {0x08}};

//Object Detail -  - Modify Draw Engine DrawDistances For Fast 3DCards
t_PatchDef		Patch12a_Off  = {0x000F121E, 1, {0x03}};
t_PatchDef		Patch12b_Off  = {0x000393A3, 1, {0x04}};
t_PatchDef		Patch12c_Off  = {0x000393BE, 1, {0x04}};
t_PatchDef		Patch12a_On   = {0x000F121E, 1, {0x07}};
t_PatchDef		Patch12b_On   = {0x000393A3, 1, {0x06}};
t_PatchDef		Patch12c_On   = {0x000393BE, 1, {0x08}};

char	*CheatCodes[] = {
						"1.\t'FREEWAY'\t Unlock All Stages",
				  		"2.\t'LOTTOWIN'\t Enables Bonus Cars",
						"3.\t'ROCKETMAN'\t Turbo Boost",
						"4.\t'PASSEDOUT'\t CoDriver Controls",
						"5.\t'GIANTLEAP'\t Low Gravity Mode",
						"6.\t'BIGGUNS'\t Double Power",
						"7.\t'BORROWERS'\t Micro-Machines Mode",
						"8.\t'BACKAGAIN'\t Drive Finish->Start",
						"9.\t'TURNBACK'\t Rear Wheel Steer",
						"10.\t'ONTHEWALL'\t Mirror Track Mode",
						"11.\t'WHITEOUT'\t Drive Stages In Fog",
						"12.\t'DARKSIDE'\t Drive Stages At Night",
						"13.\t'ALIENGOO'\t Jelly Car",
						"14.\t'DELOREAN'\t Hovercraft Mode",
						"15.\t'PRESSFAST'\t Pedal Power",
						"16.\t'CHOIRBOY'\t Squeaky CoDriver",
						"17.\t'ALLWHEELS'\t Super (4WD) Steer",
						"18.\t'SPECIALED'\t Replay Transition Mode",
						"19.\t'BUNGEENET'\t Attach Bungee In NetGame",
						"20.\t'HIPPO'\t\t Concept Rally Car",
						"21.\t'BEEFCAKE'\t Toyota Celica GT4",
						"22.\t'QUARRYVILLE'\t Secret Track #1",
						"23.\t'INTHECLOUDS'\t Secret Track #2",
						"24.\t'TROLLEYPARK'\t Secret Track #3",
						"25.\t'WILDAYWORLD'\t Secret Track #4",
						"26.\t'XCREDITSX'\t See Credits In Demo",
					   };

char	*DayTexDestNames[] =
					   {
						".\\game\\objects\\cars\\SubDay.c3d",		//1
						".\\game\\objects\\cars\\MitDay.c3d",		//2
						".\\game\\objects\\cars\\CosDay.c3d",		//3
						".\\game\\objects\\cars\\ToyDay.c3d",		//4
						".\\game\\objects\\cars\\MegDay.c3d",		//5
						".\\game\\objects\\cars\\SeaDay.c3d", 		//6
						".\\game\\objects\\cars\\VWDay.c3d", 		//7
						".\\game\\objects\\cars\\SkoDay.c3d", 		//8
						".\\game\\objects\\cars\\Mk2Day.c3d", 		//9
						".\\game\\objects\\cars\\Rs2Day.c3d", 		//10
						".\\game\\objects\\cars\\IntDay.c3d", 		//11
						".\\game\\objects\\cars\\QuaDay.c3d", 		//12
						".\\game\\objects\\cars\\M4RDay.c3d", 		//13
						".\\game\\objects\\cars\\CelDay.c3d" 		//14
					   };

char	*DayTexDefaults[] =
					   {
						".\\Miz_Data\\SubDay_Original.c3d",		//1
						".\\Miz_Data\\MitDay_Original.c3d",		//2
						".\\Miz_Data\\CosDay_Original.c3d",		//3
						".\\Miz_Data\\ToyDay_Original.c3d",		//4
						".\\Miz_Data\\MegDay_Original.c3d",		//5
						".\\Miz_Data\\SeaDay_Original.c3d", 	//6
						".\\Miz_Data\\VWDay_Original.c3d", 		//7
						".\\Miz_Data\\SkoDay_Original.c3d", 	//8
						".\\Miz_Data\\Mk2Day_Original.c3d", 	//9
						".\\Miz_Data\\Rs2Day_Original.c3d", 	//10
						".\\Miz_Data\\IntDay_Original.c3d", 	//11
						".\\Miz_Data\\QuaDay_Original.c3d", 	//12
						".\\Miz_Data\\M4RDay_Original.c3d", 	//13
						".\\Miz_Data\\CelDay_Original.c3d" 		//14
					   };

int		DayTexIDs[14] =
					  {
						IDC_DAYTEXNAME1,
						IDC_DAYTEXNAME2,
						IDC_DAYTEXNAME3,
						IDC_DAYTEXNAME4,
						IDC_DAYTEXNAME5,
						IDC_DAYTEXNAME6,
						IDC_DAYTEXNAME7,
						IDC_DAYTEXNAME8,
						IDC_DAYTEXNAME9,
						IDC_DAYTEXNAME10,
						IDC_DAYTEXNAME11,
						IDC_DAYTEXNAME12,
						IDC_DAYTEXNAME13,
						IDC_DAYTEXNAME14
					  };
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void MyLongSeek(long offset)
{
	fseek(fp, offset, SEEK_SET);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void	DoPatch(t_PatchDef *Patch)
{
int	i;

	MyLongSeek(Patch->Offset);
	for (i=0; i<Patch->Count; i++)
		Putb(Patch->Data[i]);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void PatchFile()
{
unsigned char	byte;

//Do Rally.exe Patches

	fp = fopen("rally.exe", "r+b");
	if (!fp) return;

	// No Damage
	if (PatchCfg.NoDamage_State == TRUE)
		DoPatch(&Patch1_On);
	else
		DoPatch(&Patch1_Off);

	// No Object Collision
	if (PatchCfg.NoObjCol_State == TRUE)
		DoPatch(&Patch2_On);
	else
		DoPatch(&Patch2_Off);

	// Infinite Modify Time
	if (PatchCfg.ModifyTime_State == TRUE)
	{
		DoPatch(&Patch4a_On);
		DoPatch(&Patch4b_On);
	}
	else
	{
		DoPatch(&Patch4a_Off);
		DoPatch(&Patch4b_Off);
	}

	// Infinite Repair Time
	if (PatchCfg.RepairTime_State == TRUE)
	{
		DoPatch(&Patch5a_On);
		DoPatch(&Patch5b_On);
	}
	else
	{
		DoPatch(&Patch5a_Off);
		DoPatch(&Patch5b_Off);
	}

	// All Cars In All Difficulty Levels
	if (PatchCfg.AllCars_State == TRUE)
	{
		DoPatch(&Patch6a_On);
		DoPatch(&Patch6b_On);
	}
	else
	{
		DoPatch(&Patch6a_Off);
		DoPatch(&Patch6b_Off);
	}

	// Do TimeOfDay Patch
	if (PatchCfg.TimeOfDay_State == 0)
		DoPatch(&Patch7_Off);
	else
	{
		Patch7_On.Data[3] = PatchCfg.TimeOfDay_State;
		DoPatch(&Patch7_On);
	}

	// Do Weather Patch
	if (PatchCfg.Weather_State == 0)
		DoPatch(&Patch8_Off);
	else
	{
		Patch8_On.Data[3] = PatchCfg.Weather_State;
		DoPatch(&Patch8_On);
	}

	// Do Single Shift Patch
	if (PatchCfg.Shift_State == TRUE)
		DoPatch(&Patch9_On);
	else
		DoPatch(&Patch9_Off);

	// Do Quick Restart
	if (PatchCfg.QuickRestart_State == TRUE)
		DoPatch(&Patch10_On);
	else
		DoPatch(&Patch10_Off);

	// Do TrackDistance
	if (PatchCfg.TrackDetail_State == TRUE)
	{
		DoPatch(&Patch11a_On);
		DoPatch(&Patch11b_On);
		DoPatch(&Patch11c_On);
	}
	else
	{
		DoPatch(&Patch11a_Off);
		DoPatch(&Patch11b_Off);
		DoPatch(&Patch11c_Off);
	}

	// Do ObjectDistance
	if (PatchCfg.ObjDetail_State == TRUE)
	{
		DoPatch(&Patch12a_On);
		DoPatch(&Patch12b_On);
		DoPatch(&Patch12c_On);
	}
	else
	{
		DoPatch(&Patch12a_Off);
		DoPatch(&Patch12b_Off);
		DoPatch(&Patch12c_Off);
	}

	fseek(fp, 0L, SEEK_END);
	fclose(fp);

//Do Save/cmRally.cfg Patches

	// Expert Mode
	fp = fopen("save\\cmrally.cfg", "r+b");
	if (!fp) return;

	MyLongSeek(0x0000002B);
	byte = Getb();
	if (PatchCfg.Expert_State == TRUE)
		byte |= 0x01;
	else
		byte &= 0xFE;

	MyLongSeek(0x0000002B);
	Putb(byte);
	MyLongSeek(0x0000002B);

/*
	//Extra Fudge For NightTime
	MyLongSeek(0x0000,0x002D);
	byte = Getb();
	if (PatchCfg.TimeOfDay_State == 0x08)		// 8 = Night
		byte |= 0x80;
	else
		byte &= 0x7f;

	MyLongSeek(0x0000,0x002D);
	Putb(byte);
	MyLongSeek(0x0000,0x002D);
*/

	fseek(fp, 0L, SEEK_END);
	fclose(fp);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void CopyNewTextures(void)
{
FILE	*source_fp;
FILE	*dest_fp;
char	source_name[_MAX_PATH];
char	dest_name[_MAX_PATH];
int		source_handle;
long	filesize;
char	*filebuf;
int		i;

	for (i=0; i<14; i++)
	{
		strcpy(&source_name[0], &DayTexSelection[i][0]);
		strcpy(&dest_name[0],   DayTexDestNames[i]);
		source_fp = fopen(source_name, "r+b");
		if (source_fp)
		{
			source_handle = _fileno(source_fp);
			filesize      = _filelength(source_handle);
			filebuf       = malloc(filesize);
			if (filebuf)
			{
				fread(filebuf, filesize, 1, source_fp);
				fflush(source_fp);
				dest_fp = fopen(dest_name, "w+b");
				if (dest_fp)
				{
					fwrite(filebuf, filesize, 1, dest_fp);
					fflush(dest_fp);
					fclose(dest_fp);
				}
				free(filebuf);
			}
			fclose(source_fp);
		}
	}
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
BOOL GetFileNameLoad(HWND hDlg, char *fileName, char *filter)
{
OPENFILENAME	ofn;
char			strfilter[128];
int				i;
int				c;
int				len;
int				returnval;

	FileRequestOn = TRUE;

	len = strlen(filter);
	c   = 0;
	for (i=0; i<len; i++)
		strfilter[c++] = filter[i];
	strfilter[c++] = 0;
	for (i=0; i<len; i++)
		strfilter[c++] = filter[i];
	strfilter[c++] = 0;
	strfilter[c++] = 0;

	memset(&ofn, 0, sizeof(OPENFILENAME));

	fileName[0]           = 0;
	ofn.lStructSize		  =	sizeof(OPENFILENAME);
	ofn.hwndOwner	  	  = hDlg;
	ofn.hInstance		  = MainInstance;
	ofn.lpstrFilter		  = strfilter;
	ofn.lpstrCustomFilter = NULL;				
	ofn.nMaxCustFilter	  = 0;
	ofn.nFilterIndex	  = 0;
	ofn.lpstrFile	  	  = fileName;
	ofn.nMaxFile		  = _MAX_PATH;
	ofn.lpstrFileTitle	  = NULL;
	ofn.nMaxFileTitle	  = 0;
	ofn.lpstrInitialDir   = ".//Miz_Data";
	ofn.lpstrTitle		  = "Load Texture File (.c3d)";
	ofn.lpstrDefExt		  = "c3d";
	ofn.Flags		  	  = OFN_FILEMUSTEXIST | OFN_NOCHANGEDIR | OFN_NONETWORKBUTTON | OFN_EXPLORER | OFN_HIDEREADONLY;
	returnval             = GetOpenFileName(&ofn);
	FileRequestOn         = FALSE;
	return(returnval);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
int GetC3DName(HWND hDlg, int index, char *filter)
{
char	filename[_MAX_PATH];
char	drive[_MAX_DRIVE];
char	dir[_MAX_DIR];
char	fname[_MAX_FNAME];
char	ext[_MAX_EXT];
 
	if (FileRequestOn == FALSE)
	{
		if (GetFileNameLoad(hDlg, filename, filter))
		{
			_splitpath(filename, drive, dir, fname, ext);
			strcat(fname, ext);
			SetDlgItemText(hDlg, DayTexIDs[index], fname);
			strcpy(&DayTexSelection[index][0], filename);
			return(TRUE);
		}
	}
	return(FALSE);
}
/*--------------------------------------------------------------------------*/
	
/*--------------------------------------------------------------------------*/
void InitDayTexDialog(HWND hDlg)
{
int		i;
char	filename[_MAX_PATH];
char	drive[_MAX_DRIVE];
char	dir[_MAX_DIR];
char	fname[_MAX_FNAME];
char	ext[_MAX_EXT];
 
	// Set Up Defaults
	for (i=0; i<14; i++)
	{
		strcpy(filename, DayTexDefaults[i]);
		_splitpath(filename, drive, dir, fname, ext);
		strcat(fname, ext);
		SetDlgItemText(hDlg, DayTexIDs[i], fname);
		strcpy(&DayTexSelection[i][0], DayTexDefaults[i]);
	}

	ChangedTextureInfo = TRUE;
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
BOOL CALLBACK	DayTexCallback(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
			InitDayTexDialog(hDlg);
			return 1;

		case WM_CLOSE:
			EndDialog(hDlg, 0);
			break;

		case WM_COMMAND:
			switch (LOWORD(wParam))
			{
				case IDC_BUTTON1:
					GetC3DName(hDlg, 0, "SubDay*.c3d");
					break;
				case IDC_BUTTON2:
					GetC3DName(hDlg, 1, "MitDay*.c3d");
					break;
				case IDC_BUTTON3:
					GetC3DName(hDlg, 2, "CosDay*.c3d");
					break;
				case IDC_BUTTON4:
					GetC3DName(hDlg, 3, "ToyDay*.c3d");
					break;
				case IDC_BUTTON5:
					GetC3DName(hDlg, 4, "MegDay*.c3d");
					break;
				case IDC_BUTTON6:
					GetC3DName(hDlg, 5, "SeaDay*.c3d");
					break;
				case IDC_BUTTON7:
					GetC3DName(hDlg, 6, "VWDay*.c3d");
					break;
				case IDC_BUTTON8:
					GetC3DName(hDlg, 7, "SkoDay*.c3d");
					break;
				case IDC_BUTTON9:
					GetC3DName(hDlg, 8, "Mk2Day*.c3d");
					break;
				case IDC_BUTTON10:
					GetC3DName(hDlg, 9, "Rs2Day*.c3d");
					break;
				case IDC_BUTTON11:
					GetC3DName(hDlg, 10, "IntDay*.c3d");
					break;
				case IDC_BUTTON12:
					GetC3DName(hDlg, 11, "QuaDay*.c3d");
					break;
				case IDC_BUTTON13:
					GetC3DName(hDlg, 12, "M4RDay*.c3d");
					break;
				case IDC_BUTTON14:
					GetC3DName(hDlg, 13, "CelDay*.c3d");
					break;
				case IDDAYTEXDEFAULTS:
					InitDayTexDialog(hDlg);
					break;
				case IDOK3:
					EndDialog(hDlg, 0);
					break;
			}
			return (1);
	}
	return(0);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void InitCheatList(HWND hDlg)
{
int	 l;

	// fill in cheat codes
	for (l=0; l<26; l++)
		SendDlgItemMessage(hDlg, IDC_CHEATS,  LB_ADDSTRING, 0, (LPARAM)CheatCodes[l]);
	SendDlgItemMessage(hDlg, IDC_CHEATS, LB_SETCURSEL, 0, 0);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
BOOL CALLBACK	CheatsCallback(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
			InitCheatList(hDlg);
			return(1);

		case WM_CLOSE:
			EndDialog(hDlg, 0);
			break;

		case WM_COMMAND:
			switch (LOWORD(wParam))
			{
				case IDOK2:
					EndDialog(hDlg, 0);
					break;
			}
			return(1);
	}
	return(0);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void InitDialogControls(HWND hDlg)
{
	//-------------------------------------
	// check boxes
	SendDlgItemMessage(hDlg, IDC_NODAMAGE,     BM_SETCHECK , PatchCfg.NoDamage_State,	  0);
	SendDlgItemMessage(hDlg, IDC_OBJCOLLISION, BM_SETCHECK , PatchCfg.NoObjCol_State,	  0);
	SendDlgItemMessage(hDlg, IDC_EXPERT,       BM_SETCHECK , PatchCfg.Expert_State,		  0);
	SendDlgItemMessage(hDlg, IDC_MODIFYTIME,   BM_SETCHECK , PatchCfg.ModifyTime_State,   0);
	SendDlgItemMessage(hDlg, IDC_REPAIRTIME,   BM_SETCHECK , PatchCfg.RepairTime_State,   0);
	SendDlgItemMessage(hDlg, IDC_ALLCARS,      BM_SETCHECK , PatchCfg.AllCars_State,	  0);
	SendDlgItemMessage(hDlg, IDC_SHIFT,        BM_SETCHECK , PatchCfg.Shift_State,		  0);
	SendDlgItemMessage(hDlg, IDC_QUICKRESTART, BM_SETCHECK , PatchCfg.QuickRestart_State, 0);
	SendDlgItemMessage(hDlg, IDC_TRACKDETAIL,  BM_SETCHECK , PatchCfg.TrackDetail_State,  0);
	SendDlgItemMessage(hDlg, IDC_OBJDETAIL,	   BM_SETCHECK , PatchCfg.ObjDetail_State,	  0);

	//------------------------------
	// Reset the list boxes
	SendDlgItemMessage(hDlg, IDC_TIMEOFDAY, LB_RESETCONTENT, 0, 0);
	SendDlgItemMessage(hDlg, IDC_WEATHER,	LB_RESETCONTENT, 0, 0);

	SendDlgItemMessage(hDlg, IDC_TIMEOFDAY, LB_ADDSTRING, 0, (LPARAM)"Default");
	SendDlgItemMessage(hDlg, IDC_TIMEOFDAY, LB_ADDSTRING, 0, (LPARAM)"Always Early Morning");
	SendDlgItemMessage(hDlg, IDC_TIMEOFDAY, LB_ADDSTRING, 0, (LPARAM)"Always Morning");
	SendDlgItemMessage(hDlg, IDC_TIMEOFDAY, LB_ADDSTRING, 0, (LPARAM)"Always Late Morning");
	SendDlgItemMessage(hDlg, IDC_TIMEOFDAY, LB_ADDSTRING, 0, (LPARAM)"Always Midday");
	SendDlgItemMessage(hDlg, IDC_TIMEOFDAY, LB_ADDSTRING, 0, (LPARAM)"Always Afternoon");
	SendDlgItemMessage(hDlg, IDC_TIMEOFDAY, LB_ADDSTRING, 0, (LPARAM)"Always Early Evening");
	SendDlgItemMessage(hDlg, IDC_TIMEOFDAY, LB_ADDSTRING, 0, (LPARAM)"Always Evening");
	SendDlgItemMessage(hDlg, IDC_TIMEOFDAY, LB_ADDSTRING, 0, (LPARAM)"Always Night");

	SendDlgItemMessage(hDlg, IDC_WEATHER,   LB_ADDSTRING, 0, (LPARAM)"Default");
	SendDlgItemMessage(hDlg, IDC_WEATHER,   LB_ADDSTRING, 0, (LPARAM)"Always Clear");
	SendDlgItemMessage(hDlg, IDC_WEATHER,   LB_ADDSTRING, 0, (LPARAM)"Always Cloudy");
	SendDlgItemMessage(hDlg, IDC_WEATHER,   LB_ADDSTRING, 0, (LPARAM)"Always Rain");
	SendDlgItemMessage(hDlg, IDC_WEATHER,   LB_ADDSTRING, 0, (LPARAM)"Always Snow");
	SendDlgItemMessage(hDlg, IDC_WEATHER,   LB_ADDSTRING, 0, (LPARAM)"Always Fog");

	SendDlgItemMessage(hDlg, IDC_TIMEOFDAY, CB_SETCURSEL, PatchCfg.TimeOfDay_State, 0);
	SendDlgItemMessage(hDlg, IDC_WEATHER,   CB_SETCURSEL, PatchCfg.Weather_State,   0);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
BOOL CALLBACK	MainDialogCallback(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
			ChangedTextureInfo          = FALSE;
			FileRequestOn               = FALSE;

			PatchCfg.NoDamage_State     = FALSE;
			PatchCfg.NoObjCol_State     = FALSE;
			PatchCfg.Expert_State       = FALSE;
			PatchCfg.ModifyTime_State   = FALSE;
			PatchCfg.RepairTime_State   = FALSE;
			PatchCfg.AllCars_State      = FALSE;
			PatchCfg.Shift_State        = FALSE;
			PatchCfg.QuickRestart_State = FALSE;
			PatchCfg.TrackDetail_State  = FALSE;
			PatchCfg.ObjDetail_State    = FALSE;
			PatchCfg.TimeOfDay_State    = 0;			//0 = Default
			PatchCfg.Weather_State      = 0;			//0 = Default
			PatchFile();
			InitDialogControls(hDlg);
			return 1;

		case WM_CLOSE:
			EndDialog(hDlg, 0);
			break;

		case IDCANCEL:
			EndDialog(hDlg, 0);
			break;

		case WM_COMMAND:
			switch (LOWORD(wParam))
			{
				case IDCHEATBUTTON:
					DialogBox(MainInstance, MAKEINTRESOURCE(IDD_CHEATS), hDlg, (DLGPROC)CheatsCallback);
					break;

				case IDDAYTEX:
					DialogBox(MainInstance, MAKEINTRESOURCE(IDD_DAYTEX), hDlg, (DLGPROC)DayTexCallback);
					break;

				case IDLAUNCH:
					// Get Tick Box States
					PatchCfg.NoDamage_State     = (Uint8)SendDlgItemMessage(hDlg, IDC_NODAMAGE,     BM_GETCHECK, 0, 0);
					PatchCfg.NoObjCol_State     = (Uint8)SendDlgItemMessage(hDlg, IDC_OBJCOLLISION, BM_GETCHECK, 0, 0);
					PatchCfg.Expert_State       = (Uint8)SendDlgItemMessage(hDlg, IDC_EXPERT,       BM_GETCHECK, 0, 0);
					PatchCfg.ModifyTime_State   = (Uint8)SendDlgItemMessage(hDlg, IDC_MODIFYTIME,   BM_GETCHECK, 0, 0);
					PatchCfg.RepairTime_State   = (Uint8)SendDlgItemMessage(hDlg, IDC_REPAIRTIME,   BM_GETCHECK, 0, 0);
					PatchCfg.AllCars_State      = (Uint8)SendDlgItemMessage(hDlg, IDC_ALLCARS,      BM_GETCHECK, 0, 0);
					PatchCfg.Shift_State        = (Uint8)SendDlgItemMessage(hDlg, IDC_SHIFT,        BM_GETCHECK, 0, 0);
					PatchCfg.QuickRestart_State = (Uint8)SendDlgItemMessage(hDlg, IDC_QUICKRESTART, BM_GETCHECK, 0, 0);
					PatchCfg.TrackDetail_State  = (Uint8)SendDlgItemMessage(hDlg, IDC_TRACKDETAIL,  BM_GETCHECK, 0, 0);
					PatchCfg.ObjDetail_State    = (Uint8)SendDlgItemMessage(hDlg, IDC_OBJDETAIL,	BM_GETCHECK, 0, 0);
					PatchCfg.TimeOfDay_State    = (Uint8)SendDlgItemMessage(hDlg, IDC_TIMEOFDAY,	LB_GETTOPINDEX, 0, 0);
					PatchCfg.Weather_State      = (Uint8)SendDlgItemMessage(hDlg, IDC_WEATHER,	    LB_GETTOPINDEX, 0, 0);

					PatchFile();

					if (ChangedTextureInfo == TRUE)
					{
						CopyNewTextures();
					}

					memset(&StartupInfo, 0, sizeof(STARTUPINFO));
					StartupInfo.cb = sizeof(STARTUPINFO);

					if ( CreateProcess("Rally.exe",
										NULL,				//cmd line
										NULL,				//security attr
										NULL,				//thread attr
										FALSE,				//inherit attr
										0,					//how
										NULL,				//environment
										NULL,				//dir
										&StartupInfo,		//start info
										&ProcessInfo) )		//process info
					{
						CloseHandle(ProcessInfo.hProcess);
						CloseHandle(ProcessInfo.hThread);
					}
					else
					{
						MessageBox(hDlg, "\n\nCan't find file 'rally.exe'!\n\n(This patch must be in the directory you installed the game!)\n\n", "Error!", MB_OK);
					}
 					
					EndDialog(hDlg, 0);
					break;
			}
			return(1);
	}
	return(0);
}
/*--------------------------------------------------------------------------*/

