;*****
;***** (c) 1999 by crayzee
;***** do not modify and distribute for your own purposes
;***** you are allowed to use some parts in your code but mention my name there
;***** if you'll make this code better, or comment it, send it to me please
;***** crayzee@mailbox.sk
;*****

.386
.model flat,STDCALL

extrn	GetCommandLineA:PROC
extrn	lstrcat:PROC
extrn	wsprintfA:PROC
extrn	MessageBoxA:PROC
extrn	CreateFileA:PROC
extrn	GetFileSize:PROC
extrn	GetFileTime:PROC
extrn	SetFileTime:PROC
extrn	GlobalAlloc:PROC
extrn	GlobalFree:PROC
extrn	ReadFile:PROC
extrn	WriteFile:PROC
extrn	SetFilePointer:PROC
extrn	MapFileAndCheckSumA:PROC
extrn	CloseHandle:PROC
extrn	ExitProcess:PROC

VER_MAJ			equ '1'
VER_MIN1		equ '1'
VER_MIN2		equ '0'

.data
progtitle	db 'crayzee''s PE tinystub v',VER_MAJ,'.',VER_MIN1,VER_MIN2,0
cantopen	db 'Fatal error: Cannot open the file.',13,10
		db 'Usage: tinystub',VER_MAJ,VER_MIN1,VER_MIN2,' [-s] <file_to_process>',0
cantwrite	db 'Fatal error: Cannot write to the file.',0
peinvalid	db 'Fatal error: The file is not a valid PE.',0

stuboksml	db 'The file just got a smallest possible stub!',0
stubokdef	db 'The file just got a tiny stub!',0
stubcant	db 'Error: A bigger stub would interfere with other data.',0

crcnotchanged	db 13,10,'Error: Couldn''t set correct CRC.',0
crcok		db 13,10,'A correct CRC has been set.',0

timenotrecovd	db 13,10,'Error: Couldn''t recover file''s previous time.',0
timeok		db 13,10,'File''s previous time has been recovered.',0

difference_form	db 13,10,10,'The PE header has been made %d bytes smaller.',0

text1		dd offset stubokdef
text2		dd offset crcok
text3		dd offset timeok

stubdef		db 77,90,0,0,2,0,0,0,2,0,30,0,30,0,0,0
		db 0,2,0,0,0,0,0,0,0,0,0,0,197,167,46,225
		db 14,31,186,14,0,180,9,205,33,184,255,76,205,33,87,105
		db 110,51,50,32,114,101,113,100,46,13,10,36,64,0,0,0
stubdef_size	equ $-stubdef

stubsml		db 77,90,197,167,46,225,0,116,115,116,117,98
stubsml_size	equ $-stubsml

usestub		dd offset stubdef
usestub_size	dd stubdef_size

newpeheaderpos	equ usestub_size

.data?
hfile		dd ?
cmdline		dd ?
filename	db 256 dup(?)
fsize		dd ?
alloc		dd ?
sth		dd ?
sectionscount	dw ?
peheaderpos	dd ?
filecrc		dd ?
fLastWriteTime	dd 2 dup (?)
fLastAccessTime	dd 2 dup (?)
fCreationTime	dd 2 dup (?)
sizedif		dd ?
difference	db 100 dup (?)
donetext	db 1024 dup(?)
espsave		dd ?

.code
start:
	call	GetCommandLineA
	mov	[cmdline], eax

;******* analyse the command line *******
	mov	edi, [cmdline]
	inc	edi
	mov	al, ' '
	repne	scasb	;look for first space
	cmp	word ptr [edi], 's-'	;check if the -s switch is present
	jne	go_cmdlineloop
	mov	[usestub], offset stubsml
	mov	[usestub_size], stubsml_size
	add	edi, 3	;there must be a space after the switch
	mov	[text1], offset stuboksml
    go_cmdlineloop:
	mov	esi, offset filename
	xchg	esi, edi
	mov	bl, 0	;lfn indicator
    cmdlineloop:
	lodsb
	test	al, al
	jz	cmddone	;if there is a NULL character, quit the loop
	cmp	al, '"'
	jne	noquotes
	test	bl, bl
	setz	bl	;if bl was 0, set to 1
	jnz	cmddone	;if bl was 1, the filename ends here and we quit this loop
	jmp	cmdlineloop
    noquotes:
	stosb
	jmp	cmdlineloop

;******* open the file *******
cmddone:
	push	0
	push	0
	push	80h;FILE_ATTRIBUTE_NORMAL
	push	3;OPEN_EXISTING
	push	0
	push	1;FILE_SHARE_READ
	push	0c0000000h;GENERIC_READ or GENERIC_WRITE
	push	offset filename
	call	CreateFileA
	mov	[hfile], eax
	cmp	eax, -1
	jne	processthefile

erroropeningfile:
	push	10h;MB_ICONERROR
	push	offset progtitle
	push	offset cantopen
	push	0
	call	MessageBoxA
	jmp	exit

;******* process the file *******
processthefile:
	push	0	;for GetFileSize
	push	eax	;for GetFileSize
	push	offset fLastWriteTime
	push	offset fLastAccessTime
	push	offset fCreationTime
	push	eax
	call	GetFileTime		;store the file's times to be recovered later
	call	GetFileSize
	mov	[fsize], eax
	cmp	eax, -1
	je	erroropeningfile

	push	eax
	push	40h;GMEM_ZEROINIT or GMEM_FIXED
	call	GlobalAlloc
	mov	[alloc], eax

	push	0
	push	offset sth
	push	[fsize]
	push	[alloc]
	push	[hfile]
	call	ReadFile

;------- check if the file is a valid PE -------
	mov	edi, [alloc]	;store the file start to edi
	mov	esi, edi
	lodsw
	cmp	ax, 5a4dh	;'MZ'
	jne	filenotpe
	add	esi, 3ah	;here should be the address of the PE header
	lodsd
	mov	[peheaderpos], eax
	mov	esi, edi
	add	esi, eax
	lodsd
	cmp	eax, 00004550h	;'PE',0,0 signature
	jne	filenotpe
;------- get the needed PE values -------
	lodsw
	lodsw			;now we have the number of sections
	mov	[sectionscount], ax

;------- write a new stub -------
makenewstub:
	;compute the size of headers
	mov	ecx, 0f8h	;size of PE headers
	xor	eax, eax
	mov	ax, [sectionscount]
	mov	ebx, 40		;size of a section header
	mul	ebx
	add	ecx, eax	;now in ecx is a total size of all headers

	;move the headers
	mov	edi, [newpeheaderpos]
	mov	esi, [peheaderpos]
	add	edi, [alloc]
	add	esi, [alloc]
	cmp	esi, edi	;if edi>esi (we are going to make a bigger stub),
	jae	domoveheaders	;we must do a decrement move
	std
	;but first test if we won't touch any other data	
	pushad
	mov	edx, edi
	add	edi, ecx
	dec	edi		;edi points to the future end of the headers
	mov	ecx, edx
	sub	ecx, esi
	inc	ecx		;ecx is the size of the move we are going to do
	xor	al, al
	repe	scasb		;now look for non-zero byte
	cmp	ecx, 0		;if we found any...
	popad
	jne	cantreplacestub	;...do not replace the stub then
	dec	ecx
	add	esi, ecx
	add	edi, ecx
	inc	ecx
    domoveheaders:
	rep	movsb
	cld

	;calculate the difference and null the rest
	mov	ecx, esi
	sub	ecx, edi
	mov	[sizedif], ecx
	jbe	dontnullrest	;if the stub was made greater, do not null anything
	xor	al, al
	rep	stosb
    dontnullrest:

	;copy the new stub
	mov	esi, [usestub]
	mov	edi, [alloc]
	mov	ecx, [usestub_size]
	rep	movsb

	;store the PE header offset to the stub
	mov	edi, [alloc]
	add	edi, 3ch
	mov	eax, [newpeheaderpos]
	stosd
	mov	[peheaderpos], eax
	jmp	writethefile

cantreplacestub:
	mov	[text1], offset stubcant
	jmp	setcrc

;------- write the file -------
writethefile:
	push	0
	push	0
	push	0
	push	hfile
	call	SetFilePointer

	;write whole file
	push	0
	push	offset sth
	push	[fsize]
	push	[alloc]
	push	hfile
	call	WriteFile
	test	eax, eax
	jz	writeerror

;------- set the correct checksum -------
setcrc:
	;get the correct file checksum (must be done after writing)
	push	offset filecrc
	push	offset sth
	push	offset filename
	call	MapFileAndCheckSumA
	cmp	[filecrc], 0
	je	crcnotset

	mov	eax, [newpeheaderpos]
	add	eax, 58h	;here should be the PE checksum
	
	;write the correct checksum
	push	0
	push	0
	push	eax
	push	hfile
	call	SetFilePointer
	cmp	eax, -1
	je	crcnotset

	push	0
	push	offset sth
	push	4
	push	offset filecrc
	push	hfile
	call	WriteFile
	test	eax, eax
	jz	crcnotset

	jmp	settime
crcnotset:
	mov	[text2], offset crcnotchanged

;------- set the time of file -------
settime:
	;recover the times of file
	push	offset fLastWriteTime
	push	offset fLastAccessTime
	push	offset fCreationTime
	push	hfile
	call	SetFileTime
	test	eax, eax
	jnz	done

	mov	[text3], offset timenotrecovd

;------- display the success message -------
done:
	mov	eax, offset donetext
	mov	ebx, offset difference
	push	ebx
	push	eax
	push	[text3]
	push	eax
	push	[text2]
	push	eax
	push	[text1]
	push	eax
		;copy the difference number to the final message
		mov	[espsave], esp		;there were some problems with the stack...
		push	dword ptr [sizedif]
		push	offset difference_form
		push	ebx
		call	wsprintfA		;...after calling wsprintfA...
		mov	esp, [espsave]		;...so i solved it this way
	call	lstrcat
	call	lstrcat
	call	lstrcat
	call	lstrcat

	push	40h;MB_ICONINFORMATION
	push	offset progtitle
	push	offset donetext
	push	0
	call	MessageBoxA
	jmp	exit

;------- display some failure messages if there was a fatal error -------
writeerror:
	push	10h;MB_ICONERROR
	push	offset progtitle
	push	offset cantwrite
	push	0
	call	MessageBoxA
	jmp	exit

filenotpe:
	push	10h;MB_ICONERROR
	push	offset progtitle
	push	offset peinvalid
	push	0
	call	MessageBoxA

;------- shutdown -------
exit:
	push	hfile
	call	CloseHandle
	push	[alloc]
	call	GlobalFree
	push	0
	call	ExitProcess
end start