 
#ifndef _CHIP_8_
#define _CHIP_8_

#include <windows.h>
#include "DirectDraw.h"

extern LPDIRECTDRAW        g_pDD;
extern LPDIRECTDRAWCLIPPER g_pClipper;
extern LPDIRECTDRAWSURFACE g_pDDS;
extern LPDIRECTDRAWSURFACE g_pDDSBack;
extern int                 Height,Width;

#define SCREEN_SIZE 2049
#define MEMORY_SIZE 0xFFF
#define MAX_REGS 16
#define MAX_KEYS MAX_REGS
#define MAX_STACK MAX_REGS
#define STRETCHX 18
#define STRETCHY 7

// Keys as defined by DirectDraw

#define KEY_0        0x52
#define KEY_1        0x4F
#define KEY_2        0x50
#define KEY_3        0x51
#define KEY_4        0x4B
#define KEY_5        0x4C
#define KEY_6        0x4D
#define KEY_7        0x47
#define KEY_8        0x48
#define KEY_9        0x49
#define KEY_SLASH    0xB5
#define KEY_ASTERISK 0x37
#define KEY_MINUS    0x4A
#define KEY_DEL      0xD3
#define KEY_ENTER    0x1C
#define KEY_PLUS     0x4E

typedef unsigned char CHAR8;

WORD Keys[]=

	{
		KEY_7,KEY_8,KEY_9,KEY_SLASH,
		KEY_4,KEY_5,KEY_6,KEY_ASTERISK,
		KEY_1,KEY_2,KEY_3,KEY_MINUS,
		KEY_0,KEY_DEL,KEY_ENTER,KEY_PLUS
	};


// ====================
// Chip8 Specifications
// ====================
//
// Chip8 Contains Total Size of 0xFFF (4094) Bytes to store
// The ROM Code and the Text Fonts.
//
// The Screen Size (resolution) of the Chip8 is: 64x32 (2048 bytes)
// 
// There are 16 Registers used at Chip8.
// PC (Program Counter, Marks the current executing instruction), StackPointer,
// I Register, 2 Timers (Sound / Delay).
//                                           __   __   1
// Chip8 Sound is a square generated Tone: _|  |_|  |_ 0
// Bit 1 : Speaker Tone
// Bit 0 : No Tone
//
// Chip8 GFX is Black & White, repersnted by bit 1 or 0 and uses XOR operation
// To toggle between off & on pixel.
//
// ROM is loaded at 0x200 - 0xF?? (Where 0xF??-0xFFF is for font set)

CHAR8   Memory[MEMORY_SIZE];   // 0xFFF
CHAR8   Screen[SCREEN_SIZE];   // 64x32
CHAR8   Registers[MAX_REGS];   // V0,V1..VF
DWORD   Stack[MAX_STACK];      // Stack, holds return addresses
CHAR8   DelayTimer,SoundTimer; // Timers
DWORD   CodeIndex,SP,RegI;     // PC,SP,I

// Emulator Related Variables
HANDLE  hDisasmThread;
DWORD   DisasmThreadId;
DWORD   FileSize;
DWORD   ClockSpeed;
bool    PauseCpu;
bool    SoundOn;

//////////////////////////////////////////////////////////////////////////
//                      Emulator Functions                              //
//////////////////////////////////////////////////////////////////////////
void Emulate();
void LoadRom(HWND hWnd);


//////////////////////////////////////////////////////////////////////////
//                         GFX Functions                                //
//////////////////////////////////////////////////////////////////////////
void DrawScene();

//////////////////////////////////////////////////////////////////////////
//                            Disassembler                              //
//////////////////////////////////////////////////////////////////////////
void Disasm8Chip(WORD wOpcode,char *Assembly);

//////////////////////////////////////////////////////////////////////////
//                        Iunput Functions                              //
//////////////////////////////////////////////////////////////////////////
CHAR8 ScanKeys();
int CheckKey(WORD key);

//////////////////////////////////////////////////////////////////////////
//                          CPU Functions                               //
//////////////////////////////////////////////////////////////////////////
void CPU();
void Init_CPU();
void CPU_STEP();
//////////////////////////////////////////////////////////////////////////
//                         CPU Operations                               //
//////////////////////////////////////////////////////////////////////////
void Chip8_cls();
void Chip8_rts();
void Chip8_jmp(WORD Address);
void Chip8_jsr(WORD wOpcode);
void Chip8_Skip_Reg_eq_Constant(WORD wOpcode);
void Chip8_Skip_Reg_not_eq_Constant(WORD wOpcode);
void Chip8_Skip_Reg_r_eq_Reg_y(WORD wOpcode);
void Chip8_Mov_Reg_r_Constant(WORD wOpcode);
void Chip8_Add_Reg_r_Constant(WORD wOpcode);
void Chip8_Mov_Reg_y_to_Reg_r(WORD wOpcode);
void Chip8_Or_Reg_y_to_Reg_r(WORD wOpcode);
void Chip8_And_Reg_y_to_Reg_r(WORD wOpcode);
void Chip8_Xor_Reg_y_to_Reg_r(WORD wOpcode);
void Chip8_Add_Reg_y_to_Reg_r(WORD wOpcode);
void Chip8_Sub_Reg_y_to_Reg_r(WORD wOpcode);
void Chip8_Shift_Left_Reg_r(WORD wOpcode);
void Chip8_Reg_r_rsb_Reg_y(WORD wOpcode);
void Chip8_Shift_Right_Reg_r(WORD wOpcode);
void Chip8_Skip_Reg_r_not_eq_Reg_y(WORD wOpcode);
void Chip8_Load_RegI_with_Constant(WORD wOpcode);
void Chip8_Jmp_To_Address_with_Reg0(WORD wOpcode);
void Chip8_Random_Number_less_or_eq_Constant(WORD wOpcode);
void Chip8_Skip_if_key_pressed(WORD wOpcode);
void Chip8_Skip_if_key_not_pressed(WORD wOpcode);
void Chip8_Get_delay_timer(WORD wOpcode);
void Chip8_Scan_Keys(WORD wOpcode);
void Chip8_Set_delay_timer(WORD wOpcode);
void Chip8_Set_sound_timer(WORD wOpcode);
void Chip8_Add_Reg_r_to_Reg_i(WORD wOpcode);
void Chip8_Set_i_to_hex_character(WORD wOpcode);
void Chip8_Set_i_to_hex_character_super(WORD wOpcode);
void Chip8_Store_bcd_at_ram(WORD wOpcode);
void Chip8_Set_Regs_at_Memory(WORD wOpcode);
void Chip8_Load_Regs_from_Memory(WORD wOpcode);
void Chip8_Put_8Bit_Pixel_On_Screen(WORD wOpcode);
void Chip8_Put_16it_Pixel_On_Screen(WORD wOpcode);

#endif