     
#include "DirectDraw.h"

extern int        Height,Width;
 
LPDIRECTDRAW        g_pDD          = NULL;  // The DirectDraw object
LPDIRECTDRAWCLIPPER g_pClipper     = NULL;  // Clipper for primary surface
LPDIRECTDRAWSURFACE g_pDDS         = NULL;  // Primary surface
LPDIRECTDRAWSURFACE g_pDDSBack     = NULL;  // Back surface
HWND                g_hWnd         = NULL;  // To store the main windows handle
bool                g_bFullScreen  = false; // Full-screen mode?
int                 g_iBpp         = 0;     // Remember the main surface bit depth

#define INIT_WIDTH  250
#define INIT_HEIGHT 216

bool DirectDrawInit(HWND hWnd)
{
   	HRESULT hr;
    
    g_hWnd = hWnd;
    
    // Initialize DirectDraw
    hr = DirectDrawCreate( NULL, &g_pDD, NULL );
    
    if (hr!=DD_OK)
        return false;
    
    return true; 
}

bool CreateDirectDrawSurfaces(bool bFullScreen)
{
    HRESULT hr; // Holds return values for DirectX function calls
    
    g_bFullScreen = bFullScreen;
    
    // If we want to be in full-screen mode
    if (g_bFullScreen)
    {
        // Set the "cooperative level" so we can use full-screen mode
        hr = g_pDD->SetCooperativeLevel(g_hWnd, DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN|DDSCL_NOWINDOWCHANGES);
        if (hr!=DD_OK)
            return false;
        
        // Set 640x480x16 full-screen mode
        Width=640;
        Height=480;
        hr = g_pDD->SetDisplayMode(Width, Height, 16);
        if (hr!=DD_OK)
            return false;
    }
    else
    {
        // Set DDSCL_NORMAL to use windowed mode
        hr = g_pDD->SetCooperativeLevel(g_hWnd, DDSCL_NORMAL);
        if (hr!=DD_OK)
            return false;
    }
    
    DDSURFACEDESC ddsd; // A structure to describe the surfaces we want
    // Clear all members of the structure to 0
    memset(&ddsd, 0, sizeof(ddsd));
    // The first parameter of the structure must contain the size of the structure
    ddsd.dwSize = sizeof(ddsd);
    
    if (g_bFullScreen)
    {
        ddsd.dwSize = sizeof( ddsd );                
        ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;                
        ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|DDSCAPS_COMPLEX;                
        ddsd.dwBackBufferCount = 1;
        g_pDD->CreateSurface(&ddsd, &g_pDDS, NULL);
        ddsd.ddsCaps.dwCaps = DDSCAPS_BACKBUFFER;        
        g_pDDS->GetAttachedSurface(&ddsd.ddsCaps,&g_pDDSBack);
    }
    else
    {               
        // The dwFlags paramater tell DirectDraw which DDSURFACEDESC
        // fields will contain valid values
        ddsd.dwFlags = DDSD_CAPS;
        ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
        
        hr = g_pDD->CreateSurface(&ddsd, &g_pDDS, NULL);
        if (hr!=DD_OK)
            return false;
        
        //-- Create the back buffer
        
        ddsd.dwFlags = DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS;
        // Make our off-screen surface 320x240 (?)
        ddsd.dwWidth = 320;
        ddsd.dwHeight = 240;
        // Create an offscreen surface
        ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
        
        hr = g_pDD->CreateSurface(&ddsd, &g_pDDSBack, NULL);
        if (hr!=DD_OK)
            return false;
        
    }
        
    // Window Clipper
    if (!g_bFullScreen)
    {
        
        // Create the clipper using the DirectDraw object
        hr = g_pDD->CreateClipper(0, &g_pClipper, NULL);
        if (hr!=DD_OK)
            return false;
        
        // Assign your window's HWND to the clipper
        hr = g_pClipper->SetHWnd(0, g_hWnd);
        if (hr!=DD_OK)
            return false;
        
        // Attach the clipper to the primary surface
        hr = g_pDDS->SetClipper(g_pClipper);
        if (hr!=DD_OK)
            return false;

        //IDirectDraw_Release(g_pClipper);
        //g_pClipper=NULL;
    }
    
    if SUCCEEDED(IDirectDrawSurface_Lock(g_pDDSBack, NULL, &ddsd, 
		DDLOCK_WRITEONLY | DDLOCK_WAIT | DDLOCK_SURFACEMEMORYPTR, NULL))
	{
		memset(ddsd.lpSurface, 0, ddsd.lPitch * ddsd.dwHeight);
		IDirectDrawSurface_Unlock(g_pDDSBack, NULL);	
	}
    
    //-- Lock back buffer to retrieve surface information
    if (g_pDDSBack)
    {
        hr= g_pDDSBack->Lock( NULL, &ddsd, DDLOCK_WAIT, NULL );
        if (hr!=DD_OK)
            return false;
        
        // Store bit depth of surface
        g_iBpp = ddsd.ddpfPixelFormat.dwRGBBitCount;
        
        // Unlock surface
        hr = g_pDDSBack->Unlock( NULL );
        if (hr!=DD_OK)
            return false;
    }
    
    ZeroMemory(&ddsd,sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    
    return TRUE;  
}

void CheckSurfaces()
{
	// Check the primary surface
	if (g_pDDS)
	{
		if (g_pDDS->IsLost() == DDERR_SURFACELOST)
			g_pDDS->Restore();
	}
	// Check the back buffer
	if (g_pDDSBack)
	{
		if (g_pDDSBack->IsLost() == DDERR_SURFACELOST)
			g_pDDSBack->Restore();
	}
}

void DDClear( LPDIRECTDRAWSURFACE pDDS, int x1, int y1, int x2, int y2 )
{	    
	DDBLTFX ddbfx;
	RECT    rcDest;
	
	if (pDDS == NULL)
		return;
	
    memset(&ddbfx,0,sizeof(DDBLTFX));
	ddbfx.dwSize = sizeof( ddbfx );
	ddbfx.dwFillColor = (DWORD)CreateRGB( 0, 0, 0 ); // Black
	
	SetRect( &rcDest, x1, y1, x2, y2 );
	pDDS->Blt( &rcDest, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &ddbfx );    
}

void DDFlip()
{
    
	// if we're windowed do the blit, else just Flip
	if (!g_bFullScreen)
	{
		RECT    rcSrc;  // source blit rectangle
		RECT    rcDest; // destination blit rectangle
		POINT   p;
		
		// find out where on the primary surface our window lives
        
		p.x = 0; p.y = 0;
		ClientToScreen(g_hWnd, &p);
		GetClientRect(g_hWnd, &rcDest);
		OffsetRect(&rcDest, p.x, p.y);
		SetRect(&rcSrc, 0, 0, 320, 240);
        
		g_pDDS->Blt(&rcDest, g_pDDSBack, &rcSrc, DDBLT_WAIT, NULL);         
	}
	else
	{
		g_pDDS->Flip(NULL, DDFLIP_WAIT);
	}

}

void DDPutPixel( LPDIRECTDRAWSURFACE pDDS, int x, int y, int r, int g, int b )
{
	HRESULT hr;
	DDBLTFX ddbfx;
	RECT    rcDest;
	
	if (pDDS == NULL)
		return;
	
	// Initialize the DDBLTFX structure with the pixel color
	ddbfx.dwSize = sizeof( ddbfx );
	ddbfx.dwFillColor = (DWORD)CreateRGB( r, g, b );
	
	// Prepare the destination rectangle as a 1x1 (1 pixel) rectangle
	SetRect( &rcDest, x, y, x+1, y+1 );
	
	// Blit 1x1 rectangle using solid color op
	hr = pDDS->Blt( &rcDest, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &ddbfx );
    
}

// Create color from RGB triple
unsigned int CreateRGB( int r, int g, int b )
{
	switch (g_iBpp)
	{
	case 8:
		// Here you should do a palette lookup to find the closes match.
		// I'm not going to bother with that. Many modern games no
		// longer support 256-color modes, and neither should you :)
		return 0;
	case 16:
		// Break down r,g,b into 5-6-5 format.
		return ((r/8)<<11) | ((g/4)<<5) | (b/8);
	case 24:
	case 32:
		return (r<<16) | (g<<8) | (b);
	}
	return 0;
}

void DestroyDirectDrawObjects()
{
    if(g_pDD!=NULL)
    {
        if(g_pDDS!=NULL)
        {
            g_pDDS->Release();
            g_pDDS=NULL;
        }

        if(g_pDDSBack!=NULL)
        {
            g_pDDSBack->Release();
            g_pDDSBack=NULL;
        }

        if(g_pClipper!=NULL)
        {
            g_pClipper->Release();
            g_pClipper=NULL;
        }

        g_pDD->Release();
        g_pDD=NULL;
    }
}