
#include "DirectInput.h"

LPDIRECTINPUT InputDevice;
LPDIRECTINPUTDEVICE m_keyboard;
unsigned char keys[256];

bool DirectInputInit(HINSTANCE hInst)
{
    if(FAILED(DirectInput8Create(hInst,DIRECTINPUT_VERSION,IID_IDirectInput8,(void**)&InputDevice,NULL)))
    {
        return FALSE;
    }  

    return TRUE;
}

bool CreateDirectInputDevice(HWND hWnd)
{
    if (FAILED(InputDevice->CreateDevice(GUID_SysKeyboard, &m_keyboard, NULL)))
        return FALSE;

    if (FAILED(m_keyboard->SetDataFormat(&c_dfDIKeyboard)))
        return FALSE;

    if (FAILED(m_keyboard->SetCooperativeLevel(hWnd, DISCL_BACKGROUND |DISCL_NONEXCLUSIVE)))
        return FALSE;
    
    if (FAILED(m_keyboard->Acquire()))
        return FALSE;

    return TRUE;
}

void DestroyDirectInputDevices()
{
  if (m_keyboard!=NULL)
    m_keyboard->Release();
  
  if (InputDevice!=NULL)
    InputDevice->Release();
}