 
/*
     8888888b.                  888     888 d8b                        
     888   Y88b                 888     888 Y8P                        
     888    888                 888     888                            
     888   d88P 888d888  .d88b. Y88b   d88P 888  .d88b.  888  888  888 
     8888888P"  888P"   d88""88b Y88b d88P  888 d8P  Y8b 888  888  888 
     888        888     888  888  Y88o88P   888 88888888 888  888  888 
     888        888     Y88..88P   Y888P    888 Y8b.     Y88b 888 d88P 
     888        888      "Y88P"     Y8P     888  "Y8888   "Y8888888P"  


     This code is a part of the Proview Plugin SDK.
     Coded by Bengaly 2003-2004
*/

//////////////////////////////////////////////////////////////////////////
//                         INCLUDES                                     //
//////////////////////////////////////////////////////////////////////////
#include "Main.h"

extern void LoadRom(HWND hWnd);
extern void Emulate();
extern void Init_CPU();
extern void DrawScene();

extern bool  PauseCpu,SoundOn;
extern bool  EmulatorRunning;    
extern bool  g_bFullScreen;
extern DWORD ClockSpeed;

//////////////////////////////////////////////////////////////////////////
//                    GLOBAL VARIABLES                                  //
//////////////////////////////////////////////////////////////////////////

HINSTANCE hDllInstance; // dll instance handler
PLUGINFO  PlgData;      // Global, add 'const' to avoid ovveride
WNDPROC   OldWndProc;   // Used for SubClassing Controls
HWND      Main_hWnd;    // Main Plugin's Dialog HWND

void InitEmulator()
{
    HMENU hMenu=GetMenu(g_MainhWnd),hSubMenu;

    hSubMenu=GetSubMenu(hMenu,1);
    hSubMenu=GetSubMenu(hSubMenu,1);

    SoundOn=TRUE;
    PauseCpu=FALSE;
    CheckMenuItem(hMenu,ID_PAUSE,MF_UNCHECKED);
    CheckMenuItem(hSubMenu,ID_SOUND_ON,MF_CHECKED);
    CheckMenuItem(hSubMenu,ID_SOUND_OFF,MF_UNCHECKED);
}

//////////////////////////////////////////////////////////////////////////
//                         FUNCTIONS                                    //
//////////////////////////////////////////////////////////////////////////

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    switch(msg)
    {
        case WM_CLOSE:
        {          
          DestroyDirectInputDevices();
          DestroyDirectDrawObjects();
          DestroyWindow(hWnd);
        }
        break;

        case WM_DESTROY:
        {    
            g_Running = FALSE;
            PostQuitMessage(0);
        }
        break;

        case WM_SIZE:
        {
            RECT rc,rcMain;
            
            GetWindowRect(g_MainhWnd,&rc); // Get Rect of Window
            GetClientRect(hWnd,&rcMain);           
            // Calculate Width / Height
            Height = rc.bottom - rc.top;
            Width =  rc.right - rc.left;
        }
        break;
        
        case WM_CREATE:
        {
            HMENU hMenu, hSubMenu,hPopUp[2];
            
            hMenu = CreateMenu();

            hSubMenu = CreatePopupMenu();
            AppendMenu(hSubMenu, MF_STRING, ID_LOAD,  "L&oad Rom...");
            AppendMenu(hSubMenu, MF_SEPARATOR,NULL,NULL);
            AppendMenu(hSubMenu, MF_STRING, ID_RESET, "R&eset Cpu");
            AppendMenu(hSubMenu, MF_STRING, ID_PAUSE, "P&ause Emulation");
            AppendMenu(hSubMenu, MF_SEPARATOR,NULL,NULL);
            AppendMenu(hSubMenu, MF_STRING, ID_EXIT,  "E&xit");            
            AppendMenu(hMenu, MF_STRING | MF_POPUP, (UINT)hSubMenu, "E&mulation");

            hSubMenu = CreatePopupMenu();            
            hPopUp[0]=CreatePopupMenu();
            AppendMenu(hSubMenu, MF_STRING|MF_POPUP, (UINT)hPopUp[0], "V&ideo");
            AppendMenu(hPopUp[0], MF_STRING, ID_SIZE_X1, "x1");
            AppendMenu(hPopUp[0], MF_STRING, ID_SIZE_X2, "x2");
            AppendMenu(hPopUp[0], MF_STRING, ID_SIZE_X3, "x3");
            AppendMenu(hPopUp[0], MF_STRING, ID_SIZE_X4, "x4");

            hPopUp[1]=CreatePopupMenu();
            AppendMenu(hSubMenu, MF_STRING|MF_POPUP, (UINT)hPopUp[1], "S&ound");
            AppendMenu(hPopUp[1], MF_STRING, ID_SOUND_ON, "On");
            AppendMenu(hPopUp[1], MF_STRING, ID_SOUND_OFF, "Off");

            AppendMenu(hMenu, MF_STRING|MF_POPUP, (UINT)hSubMenu, "O&ptions");

            hSubMenu = CreatePopupMenu(); 
            AppendMenu(hSubMenu, MF_STRING, ID_DEBUG,  "De&bugger");
            AppendMenu(hSubMenu, MF_STRING, ID_CPU_SPEED,  "S&et CPU Speed");
            AppendMenu(hMenu, MF_STRING | MF_POPUP, (UINT)hSubMenu, "T&ools");

            hSubMenu = CreatePopupMenu(); 
            AppendMenu(hSubMenu, MF_STRING, ID_ABOUT,  "A&bout");
            AppendMenu(hMenu, MF_STRING | MF_POPUP, (UINT)hSubMenu, "H&elp");

            SetMenu(hWnd, hMenu);
            SendMessage(hWnd,WM_SETICON,(WPARAM) 1,(LPARAM) LoadIconA(hDllInstance,MAKEINTRESOURCE(IDI_CHIP8)));
        }
        break;
        
        case WM_PAINT:
        {     
            // Draw in FullScreen only
            if(!g_bFullScreen){                            		
                //DDClear( g_pDDSBack, 0, 0, Width, 240 );
                CheckSurfaces();
                DDFlip();                                    
                ValidateRect( hWnd, NULL );
            }
            return false;
        }
        break;
        
        case WM_COMMAND:
        {
            switch(wParam)
            {
                case ID_EXIT: 
                {
                    SendMessage(hWnd,WM_CLOSE,0,0); 
                }
                break;
                
                case ID_LOAD: 
                {       
                  LoadRom(hWnd); 
                }
                break;
                
                case ID_PAUSE:
                {   
                    if(EmulatorRunning==TRUE){
                    
                        if(!PauseCpu)
                        {
                            CheckMenuItem(GetMenu(hWnd),ID_PAUSE,MF_CHECKED);
                            PauseCpu=TRUE;
                        }
                        else 
                        {
                            CheckMenuItem(GetMenu(hWnd),ID_PAUSE,MF_UNCHECKED);
                            PauseCpu=FALSE; 
                        }                                             
                    }
                }
                break;

                case ID_RESET: 
                {
                  Init_CPU(); 
                }
                break;

                case ID_DEBUG:
                {
                  PauseCpu=TRUE;
                  DialogBox(hDllInstance,MAKEINTRESOURCE(IDD_DEBUGGER), hWnd, DebugDlgProc);
                  PauseCpu=FALSE;
                }
                break;

                case ID_SIZE_X1:
                {
                    RECT rc;                    
                    Height = INIT_HEIGHT;
                    Width = INIT_WIDTH;
                    GetWindowRect(hWnd,&rc);
                    MoveWindow(hWnd,rc.left,rc.top,Width,Height,TRUE);
                }
                break;

                case ID_SIZE_X2:
                {
                    RECT rc;
                    Height = INIT_HEIGHT*2;
                    Width = INIT_WIDTH*2;
                    GetWindowRect(hWnd,&rc);
                    MoveWindow(hWnd,rc.left,rc.top,Width,Height,TRUE);
                }
                break;

                case ID_SIZE_X3:
                {
                    RECT rc;
                    Height = INIT_HEIGHT*3;
                    Width = INIT_WIDTH*3;
                    GetWindowRect(hWnd,&rc);
                    MoveWindow(hWnd,rc.left,rc.top,Width,Height,TRUE);
                }
                break;

                case ID_SIZE_X4:
                {
                    RECT rc;
                    Height = INIT_HEIGHT*4;
                    Width = INIT_WIDTH*4;
                    GetWindowRect(hWnd,&rc);
                    MoveWindow(hWnd,rc.left,rc.top,Width,Height,TRUE);
                }
                break;

                case ID_SOUND_ON:
                {
                    HMENU hMenu=GetMenu(g_MainhWnd),hSubMenu;                    
                    hSubMenu=GetSubMenu(hMenu,1);
                    hSubMenu=GetSubMenu(hSubMenu,1);                    
                    CheckMenuItem(hSubMenu,ID_SOUND_ON,MF_CHECKED);
                    CheckMenuItem(hSubMenu,ID_SOUND_OFF,MF_UNCHECKED);
                    SoundOn=TRUE;
                }
                break;

                case ID_SOUND_OFF:
                {
                    HMENU hMenu=GetMenu(g_MainhWnd),hSubMenu;                    
                    hSubMenu=GetSubMenu(hMenu,1);
                    hSubMenu=GetSubMenu(hSubMenu,1);                    
                    CheckMenuItem(hSubMenu,ID_SOUND_ON,MF_UNCHECKED);
                    CheckMenuItem(hSubMenu,ID_SOUND_OFF,MF_CHECKED);
                    SoundOn=FALSE;
                }
                break;

                case ID_ABOUT:
                {                
                  DialogBox(hDllInstance,MAKEINTRESOURCE(IDD_ABOUT), hWnd, AboutDlgProc);
                }
                break;

                case ID_CPU_SPEED:
                {
                  DialogBox(hDllInstance,MAKEINTRESOURCE(IDD_CPU_SPEED), hWnd, CpuSpeedDlgProc);
                }
                break;

            }
        }
        break;
        
        default:return DefWindowProc(hWnd, msg, wParam, lParam);
    }
    
    return FALSE;
}


BOOL CALLBACK AboutDlgProc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
    switch(Message)
    {
        case WM_INITDIALOG:
        {

        }
        break;
        
        case WM_PAINT:
        {
            return false; //no paint
        }
        break;
        
    
        case WM_CLOSE:
        {
            EndDialog(hWnd,0); // kill dialog
        }
        break;
    }
    return 0;
}

BOOL CALLBACK CpuSpeedDlgProc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
    switch(Message)
    {
        case WM_INITDIALOG:
        {
            char Speed[20];
            SendDlgItemMessage(hWnd,IDC_CPU_SPEED,TBM_SETRANGE,(WPARAM)TRUE,(LPARAM) MAKELONG(0, 60));
            SendDlgItemMessage(hWnd,IDC_CPU_SPEED,TBM_SETPOS,(WPARAM)TRUE,(LPARAM)ClockSpeed);
            wsprintf(Speed,"%d",ClockSpeed);
            SetDlgItemText(hWnd,IDC_SPEED_SIZE,Speed);
        }
        break;
        
        case WM_PAINT:
        {
            return false; //no paint
        }
        break;
        
        case WM_NOTIFY:
        {
            switch(LOWORD(wParam))
            {
                
                case IDC_CPU_SPEED:
                {
                    char Speed[10];
                    
                    ClockSpeed = SendDlgItemMessage(hWnd,IDC_CPU_SPEED,TBM_GETPOS,(WPARAM)0,(LPARAM)0);
                    
                    if(!ClockSpeed)
                        wsprintf(Speed,"Fastest");
                    else if(ClockSpeed==60)
                        wsprintf(Speed,"Slowest");
                        else
                            wsprintf(Speed,"%dHz",60-ClockSpeed);

                    SetDlgItemText(hWnd,IDC_SPEED_SIZE,Speed);                    
                }
                break;
            }
        }
        break;

        case WM_COMMAND:
        {
            switch(wParam)
            {
                case IDC_EXIT_SPEED:
                {                    
                    SendMessage(hWnd,WM_CLOSE,0,0);
                }
                break;
            }
        }
        break;
    
        case WM_CLOSE:
        {
            EndDialog(hWnd,0); // kill dialog
        }
        break;
    }
    return 0;
}

int CreateDxWindow()
{
    WNDCLASSEX wc;
    HWND hWnd;
    MSG Msg;
    
    wc.cbSize        = sizeof(WNDCLASSEX);
    wc.style         = 0;
    wc.lpfnWndProc   = WndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hDllInstance;
    wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = g_hWndClass;
    wc.hIconSm       = LoadIcon(NULL, IDI_APPLICATION);

    if(!RegisterClassEx(&wc))
    {
        MessageBox(NULL, "Window Registration Failed!", "Error!",
            MB_ICONEXCLAMATION | MB_OK);
        return FALSE;
    }

    Height = INIT_HEIGHT;
    Width = INIT_WIDTH;

    // Step 2: Creating the Window
    hWnd = CreateWindowEx(NULL,g_hWndClass,CRAZYCHIP8,
        WS_OVERLAPPEDWINDOW,CW_USEDEFAULT, CW_USEDEFAULT, Width, Height,
        NULL, NULL, hDllInstance, NULL);

    if(hWnd == NULL)
    {
        MessageBox(NULL, "Window Creation Failed!", "Error!",
            MB_ICONEXCLAMATION | MB_OK);
        return FALSE;
    }

    g_MainhWnd=hWnd;
    FileSize=NULL;

    //////////////////////////
    // Initalize DirectDraw //
    // ///////////////////////
    if(DirectDrawInit(hWnd)==FALSE)
        return FALSE;

    if(CreateDirectDrawSurfaces(FALSE)==FALSE)
        return FALSE;
    
    if(DirectInputInit(hDllInstance)==FALSE)
        return FALSE;

    if(CreateDirectInputDevice(hWnd)==FALSE)
        return FALSE;

    //CheckSurfaces();		
	DDClear( g_pDDSBack, 0, 0, 480, 320 );
    CheckSurfaces();
    DDFlip(); // Double Buffer
    
    //////////////////////////

    ShowWindow(hWnd, SW_NORMAL);   
    UpdateWindow(hWnd);    

    ////////////////////////
    // Intialize Emulator //
    ////////////////////////  
    InitEmulator();
    g_Running=TRUE;
    EmulatorRunning=FALSE;    
    ////////////////////////


    ////////////////////////
    //    Message Pump    //
    ////////////////////////
    while(g_Running){             
      
        if(EmulatorRunning)
            Emulate();
        
        while (PeekMessage(&Msg, g_MainhWnd, 0, 0, PM_NOREMOVE))
        {
            BOOL bGetResult = GetMessage(&Msg, NULL, 0, 0);
            TranslateMessage(&Msg);
            DispatchMessage(&Msg);
            if (bGetResult==0)
                g_Running = FALSE;           
        }
    }
    ///////////////////////
    
    DestroyDirectDrawObjects();
    DestroyDirectInputDevices();
    return Msg.wParam;    
}

int WINAPI DllMain(HINSTANCE hInstance,DWORD  reason, LPVOID Reserved)
{
	// Store the instance we get
	hDllInstance = hInstance;

	// Return true, we are ready for hook on the system
	return TRUE;
}

//////////////////////////////////////////////////////////////////////////
//                         PLUGIN CORE                                  //
//////////////////////////////////////////////////////////////////////////
// Plugin Instalation
void InstallDll(PLUGINFO plg)
{
    PlgData.DisasmReady = plg.DisasmReady; // Access BOOL  with: PlgData.DisasmReady
    PlgData.FilePtr     = plg.FilePtr;     // Access BYTE* with: Address: PlgData.FilePtr / Data: *PlgData.FilePtr
    PlgData.LoadedPe    = plg.LoadedPe;    // Access BOOL  with: PlgData.LoadedPe 
    PlgData.Parent_hWnd = plg.Parent_hWnd; // Access HWND  with: *PlgData.Parent_hWnd
    PlgData.FileSize    = plg.FileSize;    // Access DWORD with: PlgData.FileSize    
    
    CreateDxWindow();
}

// Returns the PLUGIN_NAME to PVDasm
char* PluginInfo()
{
    return PLUGIN_NAME; 
}