#ifndef _DLL_H_
#define _DLL_H_

//////////////////////////////////////////////////////////////////////////
//                         INCLUDES                                     //
//////////////////////////////////////////////////////////////////////////
#include "Res/resource.h"
#include <windows.h>
#include <COMMCTRL.H>
#include "DirectDraw.h"
#include "DirectInput.h"
#include "Debugger.h"

extern LPDIRECTINPUT InputDevice;
extern LPDIRECTINPUTDEVICE m_keyboard;
extern unsigned char keystate[256];
extern LPDIRECTDRAW        g_pDD;
extern LPDIRECTDRAWCLIPPER g_pClipper;
extern LPDIRECTDRAWSURFACE g_pDDS;
extern LPDIRECTDRAWSURFACE g_pDDSBack;
extern int                 Height,Width;


#define CRAZYCHIP8 "CrazyChip8 v0.2"

// MENUS
#define ID_LOAD       9001
#define ID_STUFF_GO   9002
#define ID_EXIT       9003
#define ID_PAUSE      9004
#define ID_RESET      9005
#define ID_SIZE_X1    9006
#define ID_SIZE_X2    9007
#define ID_SIZE_X3    9008
#define ID_SIZE_X4    9009
#define ID_SOUND_ON   9010
#define ID_SOUND_OFF  9011
#define ID_ABOUT      9012
#define ID_CPU_SPEED  9013
#define ID_DEBUG      9014

#define INIT_WIDTH  250
#define INIT_HEIGHT 216

// Export Type
#define DLL_EXPORT __declspec(dllexport)


// This is the Plugin Description which will be 
// Shown inside PVDasm
#define PLUGIN_NAME "CrazyChip8 PvDasm Plugin v0.2" 

//////////////////////////////////////////////////////////////////////////
//                          MESSAGES                                    //
//////////////////////////////////////////////////////////////////////////

// PLUGIN MESSAGES
#define PI_BASE_MSG 200
#define PI_GETASMFROMINDEX WM_USER+PI_BASE_MSG+1
#define PI_GETASM          WM_USER+PI_BASE_MSG


// PVDasm Control IDs
#define ID_DISASM        1072
#define ID_DEBUG_WINDOW  1060

//////////////////////////////////////////////////////////////////////////
//                          STRUCTS                                     //
//////////////////////////////////////////////////////////////////////////

typedef struct tagPluginInfo{

    HWND* Parent_hWnd;
    BYTE* FilePtr;
    DWORD FileSize;
    bool  DisasmReady;
    bool  LoadedPe;

}PLUGINFO; // Plugin Struct

typedef struct Code_Flow{

    bool Jump;   // Instruction is a Jxx
    bool Call;   // Instruction is a Call

} CODE_FLOW;

typedef struct Decoded{
	
	// Define Decoded instruction struct

    DWORD     Address;       // Current address of decoded instruction
    CODE_FLOW CodeFlow;      // InstructionS: Jump or Call 
    BYTE      OpcodeSize;    // Opcode Size
	BYTE      PrefixSize;    // Size of all prefixes used
    char      Assembly[128]; // Menemonics
    char      Remarks[256];  // Menemonic addons
    char      Opcode[25];    // Opcode Byte forms

} DISASSEMBLY;

//////////////////////////////////////////////////////////////////////////
//                        FUNCTION EXPORTS                              //
//////////////////////////////////////////////////////////////////////////

extern "C" { 
    
    DLL_EXPORT void  InstallDll(PLUGINFO);  
    DLL_EXPORT char* PluginInfo();
};

//////////////////////////////////////////////////////////////////////////
//                           PROTOTYPES                                 //
//////////////////////////////////////////////////////////////////////////

//BOOL CALLBACK DlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

const char g_hWndClass[]="DirectDrawClass";
HINSTANCE  hInst;
HWND       g_MainhWnd;
bool       g_Running;
int        Height,Width;
bool       EmulatorRunning;

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK AboutDlgProc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK CpuSpeedDlgProc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam);
int CreateDxWindow();
void InitEmulator();
#endif