#include <windows.h>
#include <STDIO.H>
#include <STDLIB.H>

//////////////////////////////////////////////////////////////////////////
//                        TYPE DEFINES                                  //
//////////////////////////////////////////////////////////////////////////

typedef struct Decoded{
	
	// Define Decoded instruction struct

    char Assembly[256]; // Menemonics
    char Remarks[256];  // Menemonic addons
    char Opcode[30];    // Opcode Byte forms
    DWORD Address;      // Current address of decoded instruction
    BYTE  OpcodeSize;   // Opcode Size
	BYTE  PrefixSize;   // Size of all prefixes used

} DISASSEMBLY;

typedef void (*DISASM_FUNCTION)(DISASSEMBLY*,char*,DWORD*);

//////////////////////////////////////////////////////////////////////////
//                             DEFINES                                  //
//////////////////////////////////////////////////////////////////////////
#define BYTES_TO_DECODE 16

//////////////////////////////////////////////////////////////////////////
//     	  					  PROTOTYPES                                //
//////////////////////////////////////////////////////////////////////////
void ShowDecoded(DISASSEMBLY Disasm);
void FlushDecoded(DISASSEMBLY *Disasm);


//////////////////////////////////////////////////////////////////////////
//							  FUNCTIONS                                 //
//////////////////////////////////////////////////////////////////////////

/*
   FUNCTION: ShowDecoded
*/
void ShowDecoded(DISASSEMBLY Disasm)
{
	// Printed all information regarding a 
	// Decoded instruction

    char space[]="      ";
    printf("%08X: %s %s %s / Size=%d ; %s\n",Disasm.Address,
			                           Disasm.Opcode,
									   space,
									   Disasm.Assembly,
									   Disasm.OpcodeSize+Disasm.PrefixSize,
									   Disasm.Remarks
          );
}

/*
   FUNCTION: FlushDecoded
*/
void FlushDecoded(DISASSEMBLY *Disasm)
{
	// Clear all information of an decoded 
	// Instruction

    strcpy(Disasm->Assembly,""); // Clear menemonic
    strcpy(Disasm->Remarks,"");  // Clear commets
    strcpy(Disasm->Opcode,"");   // Clear opcodes linear
    Disasm->OpcodeSize=1;        // Smallest opcode size
	Disasm->PrefixSize=0;        // No Prefixes
}

/*
   FUNCTION: main
*/
void main()
{
	DISASSEMBLY DisasmData;
	HMODULE hDll;
	DWORD Index=0;
	char *Linear="";	
    BYTE Opcodes[BYTES_TO_DECODE]={0x81,0xC4,0xE4,0xFE,0xFF,0xFF,0x00,0x00,0x03,0x01,0x04,0x60,0x88,0xF7,0x12,0x13};

	hDll = LoadLibrary("DisasmEngineDLL.dll"); // Load the DLL.
	if(hDll == NULL)
		return;

	Linear=(char*)Opcodes; // pointer to the instructions

	// Get Fucntion Pointer
	DISASM_FUNCTION Decode = (DISASM_FUNCTION)GetProcAddress((HINSTANCE)hDll,"Disassemble");

	if(Decode==NULL) // no pointer
	{
		FreeLibrary(hDll);
		return;
	}

	printf("Disassemble of Vector: ");
    for(Index=0;Index<BYTES_TO_DECODE;Index++){    
        printf("%02X",(BYTE)Opcodes[Index]);
	}
    printf("\n\n");
    
	DisasmData.Address=0x00401000; // intial address
	FlushDecoded(&DisasmData);     // clear the struct

    for(Index=0;Index<BYTES_TO_DECODE;Index++)
    {
		// Decode Instruction(s)
        Decode(&DisasmData,Linear,&Index);
		
		// Upper case Assembly (Optional)
        CharUpper(DisasmData.Assembly);
		// Show Decoded instruction, size, remarks...
        ShowDecoded(DisasmData);
		// Calculate total Size of an instruction + Prefixes, and
		// Fix the address of eIP 
        DisasmData.Address+=DisasmData.OpcodeSize+DisasmData.PrefixSize;
		// Clear all information
        FlushDecoded(&DisasmData);
    }

	// free libray in the end
	// of the process
	if(hDll!=NULL)
		FreeLibrary(hDll);
}