
/*
     8888888b.                  888     888 d8b                        
     888   Y88b                 888     888 Y8P                        
     888    888                 888     888                            
     888   d88P 888d888  .d88b. Y88b   d88P 888  .d88b.  888  888  888 
     8888888P"  888P"   d88""88b Y88b d88P  888 d8P  Y8b 888  888  888 
     888        888     888  888  Y88o88P   888 88888888 888  888  888 
     888        888     Y88..88P   Y888P    888 Y8b.     Y88b 888 d88P 
     888        888      "Y88P"     Y8P     888  "Y8888   "Y8888888P"  


     This code is a part of the Proview Plugin SDK.
     Coded by Bengaly 2003-2004
*/

//////////////////////////////////////////////////////////////////////////
//                         INCLUDES                                     //
//////////////////////////////////////////////////////////////////////////
#include "Main.h"

//////////////////////////////////////////////////////////////////////////
//                    GLOBAL VARIABLES                                  //
//////////////////////////////////////////////////////////////////////////

HINSTANCE hDllInstance; // dll instance handler
PLUGINFO  PlgData;      // Global, add 'const' to avoid ovveride
WNDPROC   OldWndProc;   // Used for SubClassing Controls
HWND      Main_hWnd;    // Main Plugin's Dialog HWND

//////////////////////////////////////////////////////////////////////////
////////////////////// Do Not Alter Below Code Section ///////////////////
//////////////////////////////////////////////////////////////////////////

int WINAPI DllMain(HINSTANCE hInstance,DWORD  reason, LPVOID Reserved)
{
	// Store the instance we get
	hDllInstance = hInstance;

	// Return true, we are ready for hook on the system
	return TRUE;
}

// 
void InstallDll(PLUGINFO plg)
{
    PlgData.DisasmReady = plg.DisasmReady; // Access BOOL  with: PlgData.DisasmReady
    PlgData.FilePtr     = plg.FilePtr;     // Access BYTE* with: Address: PlgData.FilePtr / Data: *PlgData.FilePtr
    PlgData.LoadedPe    = plg.LoadedPe;    // Access BOOL  with: PlgData.LoadedPe 
    PlgData.Parent_hWnd = plg.Parent_hWnd; // Access HWND  with: *PlgData.Parent_hWnd
    PlgData.FileSize    = plg.FileSize;    // Access DWORD with: PlgData.FileSize
    
    DialogBoxParam(hDllInstance, MAKEINTRESOURCE(IDD_MAIN_PLUGIN), NULL, (DLGPROC)DlgProc,0);
}

// Returns the PLUGIN_NAME to PVDasm
char* PluginInfo()
{
    return PLUGIN_NAME; 
}

//////////////////////////////////////////////////////////////////////////
//                         FUNCTIONS                                    //
//////////////////////////////////////////////////////////////////////////

// Main Plugin Dialog
BOOL CALLBACK DlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) // what are we doing ?
	{ 	 
		case WM_INITDIALOG: 
		{
            Main_hWnd = hWnd;
            InitCommonControls();     
            LVCOLUMN LvCol;
			HWND hList=GetDlgItem(hWnd,IDC_LIST);
			ZeroMemory(&LvCol,0);                  // Zero Members
			LvCol.mask=LVCF_TEXT|LVCF_WIDTH|LVCF_SUBITEM;    // Type of mask
			LvCol.cx=0x7;                                   // width between each coloum
			LvCol.pszText="ROM Information:";                // First Header Text
			LvCol.cx=0x100;                                   // width of column
            SendMessage(hList,LVM_SETEXTENDEDLISTVIEWSTYLE,0,LVS_EX_FULLROWSELECT);
			SendMessage(hList,LVM_INSERTCOLUMN,0,(LPARAM)&LvCol); // Insert/Show the coloum
			SendMessage(hList,LVM_SETBKCOLOR,0,(LPARAM)RGB(0,0,0)); // Insert/Show the coloum
			SendMessage(hList,LVM_SETTEXTBKCOLOR,0,(LPARAM)RGB(0,0,0));
			SendMessage(hList,LVM_SETTEXTCOLOR,0,(LPARAM)RGB(255,200,0));
            ShowWindow(hWnd,SW_NORMAL); 
            
            Read_Game_Boy_Header(hWnd,hList,(char*)PlgData.FilePtr);
		}
		break;

		case WM_LBUTTONDOWN: 
		{
			ReleaseCapture(); 
			SendMessage(hWnd,WM_NCLBUTTONDOWN,HTCAPTION,0); 
		}
		break;

		case WM_PAINT: // constantly painting the window
		{
			return 0;
		}
		break;
		        
		case WM_COMMAND:
		{
		   switch(LOWORD(wParam)) // what we press on?
           {
                case IDC_EXIT:
                {
                    SendMessage(hWnd,WM_CLOSE,0,0);
                }
                break;
           }
		}
		break;
        
        case WM_CLOSE: // We colsing the Dialog
        {
          EndDialog(hWnd,0); 
        }
	    break;
	}
	return 0;
}


void Read_Game_Boy_Header(HWND hWnd,HWND hList,char *GB_Pointer)
{
	DWORD i,Manufacture=0,csum;
	char RomName[17]="",Info[256]="",*originalPtr=GB_Pointer;

    OutDebug(hWnd,"",hList);

    // Check ROM Signature
    if(CheckGameBoySignature(originalPtr)==TRUE)
        OutDebug(hWnd,"GameBoy Header: Valid",hList);
    else{
        OutDebug(hWnd,"GameBoy Header: InValid",hList);
        return;
    }
    
	// Every Gameboy ROM header starts off at the HEX offset 0x134
	GB_Pointer+=0x134;
	
	for(i=0;i<16;i++)
	{
		RomName[i]=*GB_Pointer;
		GB_Pointer++;		
	}
    
	wsprintf(Info,"ROM Name: %s",RomName);
	OutDebug(hWnd,Info,hList);
	
	// strip the manufacture code licence
	Manufacture=(DWORD)((*GB_Pointer)-0x30)*10+((*(GB_Pointer+1))-0x30);
	switch(Manufacture)
	{
	case 0:  OutDebug(hWnd, "Manufacture: Unknown/None"	        ,hList);  break;
	case 1:  OutDebug(hWnd, "Manufacture: Nintendo"		        ,hList);  break;
	case 8:  OutDebug(hWnd, "Manufacture: Capcom"			    ,hList);  break;
	case 13: OutDebug(hWnd, "Manufacture: EA (Electronic Arts)" ,hList);  break;
	case 18: OutDebug(hWnd, "Manufacture: Hudsonsoft"		    ,hList);  break;
	case 19: OutDebug(hWnd, "Manufacture: B-AI"				    ,hList);  break;
	case 20: OutDebug(hWnd, "Manufacture: KSS"				    ,hList);  break;
	case 22: OutDebug(hWnd, "Manufacture: POW"				    ,hList);  break;
	case 24: OutDebug(hWnd, "Manufacture: PCM Complete"		    ,hList);  break;
	case 25: OutDebug(hWnd, "Manufacture: San-X"				,hList);  break;
	case 28: OutDebug(hWnd, "Manufacture: Kemco Japan"			,hList);  break;
	case 29: OutDebug(hWnd, "Manufacture: Seta"					,hList);  break;
	case 30: OutDebug(hWnd, "Manufacture: Viacom"				,hList);  break;
	case 31: OutDebug(hWnd, "Manufacture: Nintendo"				,hList);  break;
	case 32: OutDebug(hWnd, "Manufacture: Bandia"				,hList);  break;
	case 33: OutDebug(hWnd, "Manufacture: Ocean/Acclaim"		,hList);  break;
	case 34: OutDebug(hWnd, "Manufacture: Konami"				,hList);  break;
	case 35: OutDebug(hWnd, "Manufacture: Hector"				,hList);  break;
	case 37: OutDebug(hWnd, "Manufacture: Taito"				,hList);  break;
	case 38: OutDebug(hWnd, "Manufacture: Hudson"				,hList);  break;
	case 39: OutDebug(hWnd, "Manufacture: BanPresto"			,hList);  break;
	case 41: OutDebug(hWnd, "Manufacture: Ubi-Soft"				,hList);  break;
	case 42: OutDebug(hWnd, "Manufacture: Atlus"				,hList);  break;
	case 44: OutDebug(hWnd, "Manufacture: Malibu"				,hList);  break;
	case 46: OutDebug(hWnd, "Manufacture: Angel"				,hList);  break;
	case 47: OutDebug(hWnd, "Manufacture: Pullet-Proof"			,hList);  break;
	case 49: OutDebug(hWnd, "Manufacture: Irem"					,hList);  break;
	case 50: OutDebug(hWnd, "Manufacture: Absolute"				,hList);  break;
	case 51: OutDebug(hWnd, "Manufacture: Acclaim"				,hList);  break;
	case 52: OutDebug(hWnd, "Manufacture: Activision"			,hList);  break;
	case 53: OutDebug(hWnd, "Manufacture: American Sammy"		,hList);  break;
	case 54: OutDebug(hWnd, "Manufacture: Konami"				,hList);  break;
	case 55: OutDebug(hWnd, "Manufacture: Hi Tech Entertainment",hList);  break;
	case 56: OutDebug(hWnd, "Manufacture: IJN"					,hList);  break;
	case 57: OutDebug(hWnd, "Manufacture: MatchBox"				,hList);  break;
	case 58: OutDebug(hWnd, "Manufacture: Mattel"				,hList);  break;
	case 59: OutDebug(hWnd, "Manufacture: Milton Bradley"		,hList);  break;
	case 60: OutDebug(hWnd, "Manufacture: Titus"				,hList);  break;
	case 61: OutDebug(hWnd, "Manufacture: Virgin"				,hList);  break;
	case 64: OutDebug(hWnd, "Manufacture: LucasArts"			,hList);  break;
	case 67: OutDebug(hWnd, "Manufacture: Ocean"				,hList);  break;
	case 69: OutDebug(hWnd, "Manufacture: EA (Electronic Arts)" ,hList);  break;
	case 70: OutDebug(hWnd, "Manufacture: InfoGrames"			,hList);  break;
	case 71: OutDebug(hWnd, "Manufacture: InterPlay"			,hList);  break;
	case 72: OutDebug(hWnd, "Manufacture: BroderBund"			,hList);  break;
	case 73: OutDebug(hWnd, "Manufacture: Sculptured"			,hList);  break;
	case 75: OutDebug(hWnd, "Manufacture: SCI"					,hList);  break;
	case 78: OutDebug(hWnd, "Manufacture: T*HQ"					,hList);  break;
	case 79: OutDebug(hWnd, "Manufacture: Accolade"				,hList);  break;
	case 80: OutDebug(hWnd, "Manufacture: Misawa"				,hList);  break;
	case 83: OutDebug(hWnd, "Manufacture: LOZC"					,hList);  break;
	case 86: OutDebug(hWnd, "Manufacture: Tokuma Shoten I*"		,hList);  break;
	case 87: OutDebug(hWnd, "Manufacture: Tsukuda Ori*"			,hList);  break;
	case 91: OutDebug(hWnd, "Manufacture: Chun Soft"			,hList);  break;
	case 92: OutDebug(hWnd, "Manufacture: Video Systems"		,hList);  break;
	case 93: OutDebug(hWnd, "Manufacture: Ocean/Acclaim"		,hList);  break;
	case 95: OutDebug(hWnd, "Manufacture: Varie"				,hList);  break;
	case 96: OutDebug(hWnd, "Manufacture: Yonezawa/S'Pal"		,hList);  break;
	case 97: OutDebug(hWnd, "Manufacture: Kaneko"				,hList);  break;
	case 99: OutDebug(hWnd, "Manufacture: Pack in Soft"			,hList);  break;
	}
	
	GB_Pointer+=2;
	
	// check for Super GameBoy features
	switch(*GB_Pointer)
	{
	case 3:  OutDebug(hWnd, "SGB features: added  features for Super Gameboy",hList);    break;
	default: OutDebug(hWnd, "SGB features: non-SGB cart",hList);                         break;
	}
	
	GB_Pointer++;
	// get Cartridge type
	switch(*GB_Pointer)
	{
	case 0:     OutDebug(hWnd, "Cartridge type: ROM"					,hList);    break;
	case 1:     OutDebug(hWnd, "Cartridge type: MBC1"					,hList);    break;
	case 2:     OutDebug(hWnd, "Cartridge type: MBC1+RAM"				,hList);    break;
	case 3:     OutDebug(hWnd, "Cartridge type: MBC1+RAM+BATTERY"		,hList);    break;
	case 5:     OutDebug(hWnd, "Cartridge type: MBC2"					,hList);    break;
	case 6:     OutDebug(hWnd, "Cartridge type: MBC2+BATTERY"			,hList);    break;
	case 8:     OutDebug(hWnd, "Cartridge type: ROM+RAM"				,hList);    break;
	case 9:     OutDebug(hWnd, "Cartridge type: ROM+RAM+BATTERY"		,hList);    break;
	case 0x0B:  OutDebug(hWnd, "Cartridge type: MMM01"					,hList);    break;
	case 0x0C:  OutDebug(hWnd, "Cartridge type: MMM01+RAM"				,hList);    break;
	case 0x0D:  OutDebug(hWnd, "Cartridge type: MMM01+RAM+BATTERY"		,hList);    break;
	case 0x0F:  OutDebug(hWnd, "Cartridge type: MBC3+TIMER+BATTERY"		,hList);    break;
	case 0x10:  OutDebug(hWnd, "Cartridge type: MBC3+TIMER+RAM+BATTERY" ,hList);    break;
	case 0x11:  OutDebug(hWnd, "Cartridge type: MBC3"                   ,hList);    break;
	case 0x12:  OutDebug(hWnd, "Cartridge type: MBC3+RAM"               ,hList);    break;
	case 0x13:  OutDebug(hWnd, "Cartridge type: MBC3+RAM+BATTERY"       ,hList);    break;
	case 0x15:  OutDebug(hWnd, "Cartridge type: MBC4"                   ,hList);    break;
	case 0x16:  OutDebug(hWnd, "Cartridge type: MBC4+RAM"               ,hList);    break;
	case 0x17:  OutDebug(hWnd, "Cartridge type: MBC4+RAM+BATTERY"       ,hList);    break;
	case 0x19:  OutDebug(hWnd, "Cartridge type: MBC5"                   ,hList);    break;
	case 0x1A:  OutDebug(hWnd, "Cartridge type: MBC5+RAM"               ,hList);    break;
	case 0x1B:  OutDebug(hWnd, "Cartridge type: MBC5+RAM+BATTERY"       ,hList);    break;
	case 0x1C:  OutDebug(hWnd, "Cartridge type: MBC5+RUMBLE"            ,hList);    break;
	case 0x1D:  OutDebug(hWnd, "Cartridge type: MBC5+RUMBLE+RAM"        ,hList);    break;
	case 0x1E:  OutDebug(hWnd, "Cartridge type: MBC5+RUMBLE+RAM+BATTERY",hList);    break;
	case 0xFC:  OutDebug(hWnd, "Cartridge type: POCKET CAMERA"          ,hList);    break;
	case 0xFD:  OutDebug(hWnd, "Cartridge type: Bandai TAMA5"           ,hList);    break;
	case 0xFE:  OutDebug(hWnd, "Cartridge type: HuC3"                   ,hList);    break;
	case 0xFF:  OutDebug(hWnd, "Cartridge type: HuC1+RAM+BATTERY"       ,hList);    break;
	default: break;
	}
	
	GB_Pointer++;
	// get ROM size
	switch(*GB_Pointer)
	{
	case 0:     OutDebug(hWnd, "ROM size: 32k"			,hList);    break;
	case 1:     OutDebug(hWnd, "ROM size: 64k"			,hList);    break;
	case 2:     OutDebug(hWnd, "ROM size: 128k"			,hList);    break;
	case 3:     OutDebug(hWnd, "ROM size: 256k"	    	,hList);    break;
	case 4:     OutDebug(hWnd, "ROM size: 512k"			,hList);    break;
	case 5:     OutDebug(hWnd, "ROM size: 1024k (1 MB)"	,hList);    break;
	case 6:     OutDebug(hWnd, "ROM size: 2048k (2 MB)"	,hList);    break;
	case 7:     OutDebug(hWnd, "ROM size: 4096k (4 MB)"	,hList);    break;
	default:break;	
	}
	
	GB_Pointer++;
	// get Save ROM size
	switch(*GB_Pointer)
	{
	case 0:     OutDebug(hWnd, "Save ROM size: 0k"			,hList);    break;
	case 1:     OutDebug(hWnd, "Save ROM size: 2k"			,hList);    break;
	case 2:     OutDebug(hWnd, "Save ROM size: 8k"			,hList);    break;
	case 3:     OutDebug(hWnd, "Save ROM size: 32k"	    	,hList);    break;
	default:break;	
	}

	GB_Pointer++;
	// get Country code
	switch(*GB_Pointer)
	{
	case 0:     OutDebug(hWnd, "Country code: Japan"			   ,hList);    break;
	case 1:     OutDebug(hWnd, "Country code: Non-Japan (USA/EUR)" ,hList);    break;
	}
	
	GB_Pointer++;
	// get License
	switch(*GB_Pointer)
	{
	case 0x00:     OutDebug(hWnd, "License: None                 "			,hList);    break;
	case 0x09:     OutDebug(hWnd, "License: Hot-b                "			,hList);    break;
	case 0x0C:     OutDebug(hWnd, "License: Elite systems        "			,hList);    break;
	case 0x19:     OutDebug(hWnd, "License: Itc entertainment    "			,hList);    break;
	case 0x1F:     OutDebug(hWnd, "License: Virgin               "			,hList);    break;
	case 0x28:     OutDebug(hWnd, "License: Kotobuki systems     "			,hList);    break;
	case 0x31:     OutDebug(hWnd, "License: Nintendo             "			,hList);    break;
	case 0x34:     OutDebug(hWnd, "License: Konami               "			,hList);    break;
	case 0x39:     OutDebug(hWnd, "License: Banpresto            "			,hList);    break;
	case 0x41:     OutDebug(hWnd, "License: Ubi soft             "			,hList);    break;
	case 0x46:     OutDebug(hWnd, "License: Angel                "			,hList);    break;
	case 0x4A:     OutDebug(hWnd, "License: Virgin               "			,hList);    break;
	case 0x50:     OutDebug(hWnd, "License: Absolute             "			,hList);    break;
	case 0x53:     OutDebug(hWnd, "License: American sammy       "			,hList);    break;
	case 0x56:     OutDebug(hWnd, "License: Ljn                  "			,hList);    break;
	case 0x5A:     OutDebug(hWnd, "License: Mindscape            "			,hList);    break;
	case 0x5D:     OutDebug(hWnd, "License: Tradewest            "			,hList);    break;
	case 0x67:     OutDebug(hWnd, "License: Ocean                "			,hList);    break;
	case 0x6F:     OutDebug(hWnd, "License: Electro brain        "			,hList);    break;
	case 0x72:     OutDebug(hWnd, "License: Broderbund           "			,hList);    break;
	case 0x78:     OutDebug(hWnd, "License: T*hq                 "			,hList);    break;
	case 0x7C:     OutDebug(hWnd, "License: Microprose           "			,hList);    break;
	case 0x83:     OutDebug(hWnd, "License: Lozc                 "			,hList);    break;
	case 0x8C:     OutDebug(hWnd, "License: Vic tokai            "			,hList);    break;
	case 0x91:     OutDebug(hWnd, "License: Chun soft            "			,hList);    break;
	case 0x95:     OutDebug(hWnd, "License: Varie                "			,hList);    break;
	case 0x99:     OutDebug(hWnd, "License: Arc                  "			,hList);    break;
	case 0x9C:     OutDebug(hWnd, "License: Imagineer            "			,hList);    break;
	case 0xA1:     OutDebug(hWnd, "License: Hori electric        "			,hList);    break;
	case 0xA6:     OutDebug(hWnd, "License: Kawada               "			,hList);    break;
	case 0xAA:     OutDebug(hWnd, "License: Broderbund           "			,hList);    break;
	case 0xAF:     OutDebug(hWnd, "License: Namco                "			,hList);    break;
	case 0xB2:     OutDebug(hWnd, "License: Bandai               "			,hList);    break;
	case 0xB7:     OutDebug(hWnd, "License: Snk                  "			,hList);    break;
	case 0xBB:     OutDebug(hWnd, "License: Sunsoft              "			,hList);    break;
	case 0xC0:     OutDebug(hWnd, "License: Taito                "			,hList);    break;
	case 0xC4:     OutDebug(hWnd, "License: *tokuma shoten i     "			,hList);    break;
	case 0xC8:     OutDebug(hWnd, "License: Koei                 "			,hList);    break;
	case 0xCB:     OutDebug(hWnd, "License: Vap                  "			,hList);    break;
	case 0xCE:     OutDebug(hWnd, "License: *pony canyon or      "			,hList);    break;
	case 0xD1:     OutDebug(hWnd, "License: Sofel                "			,hList);    break;
	case 0xD4:     OutDebug(hWnd, "License: Ask kodansha         "			,hList);    break;
	case 0xD9:     OutDebug(hWnd, "License: Banpresto            "			,hList);    break;
	case 0xDD:     OutDebug(hWnd, "License: Ncs                  "			,hList);    break;
	case 0xE0:     OutDebug(hWnd, "License: Jaleco               "			,hList);    break;
	case 0xE3:     OutDebug(hWnd, "License: Varie                "			,hList);    break;
	case 0xE8:     OutDebug(hWnd, "License: Asmik                "			,hList);    break;
	case 0xEB:     OutDebug(hWnd, "License: Atlus                "			,hList);    break;
	case 0xF0:     OutDebug(hWnd, "License: A wave               "			,hList);    break;
	case 0x01:     OutDebug(hWnd, "License: Nintendo             "			,hList);    break;
	case 0x0A:     OutDebug(hWnd, "License: Jaleco               "			,hList);    break;
	case 0x13:     OutDebug(hWnd, "License: Electronic arts      "			,hList);    break;
	case 0x1A:     OutDebug(hWnd, "License: Yanoman              "			,hList);    break;
	case 0x24:     OutDebug(hWnd, "License: Pcm complete         "			,hList);    break;
	case 0x29:     OutDebug(hWnd, "License: Seta                 "			,hList);    break;
	case 0x32:     OutDebug(hWnd, "License: Bandai               "			,hList);    break;
	case 0x35:     OutDebug(hWnd, "License: Hector               "			,hList);    break;
	case 0x3C:     OutDebug(hWnd, "License: *entertainment i     "			,hList);    break;
	case 0x42:     OutDebug(hWnd, "License: Atlus                "			,hList);    break;
	case 0x47:     OutDebug(hWnd, "License: Spectrum holoby      "			,hList);    break;
	case 0x4D:     OutDebug(hWnd, "License: Malibu               "			,hList);    break;
	case 0x51:     OutDebug(hWnd, "License: Acclaim              "			,hList);    break;
	case 0x54:     OutDebug(hWnd, "License: Gametek              "			,hList);    break;
	case 0x57:     OutDebug(hWnd, "License: Matchbox             "			,hList);    break;
	case 0x5B:     OutDebug(hWnd, "License: Romstar              "			,hList);    break;
	case 0x60:     OutDebug(hWnd, "License: Titus                "			,hList);    break;
	case 0x69:     OutDebug(hWnd, "License: Electronic arts      "			,hList);    break;
	case 0x70:     OutDebug(hWnd, "License: Infogrames           "			,hList);    break;
	case 0x73:     OutDebug(hWnd, "License: Sculptered soft      "			,hList);    break;
	case 0x79:     OutDebug(hWnd, "License: Accolade             "			,hList);    break;
	case 0x7F:     OutDebug(hWnd, "License: Kemco                "			,hList);    break;
	case 0x86:     OutDebug(hWnd, "License: *tokuma shoten i     "			,hList);    break;
	case 0x8E:     OutDebug(hWnd, "License: Ape                  "			,hList);    break;
	case 0x92:     OutDebug(hWnd, "License: Video system         "			,hList);    break;
	case 0x96:     OutDebug(hWnd, "License: Yonezawa/s'pal       "			,hList);    break;
	case 0x9A:     OutDebug(hWnd, "License: Nihon bussan         "			,hList);    break;
	case 0x9D:     OutDebug(hWnd, "License: Banpresto            "			,hList);    break;
	case 0xA2:     OutDebug(hWnd, "License: Bandai               "			,hList);    break;
	case 0xA7:     OutDebug(hWnd, "License: Takara               "			,hList);    break;
	case 0xAC:     OutDebug(hWnd, "License: Toei animation       "			,hList);    break;
	case 0xB0:     OutDebug(hWnd, "License: Acclaim              "			,hList);    break;
	case 0xB4:     OutDebug(hWnd, "License: Enix                 "			,hList);    break;
	case 0xB9:     OutDebug(hWnd, "License: Pony canyon          "			,hList);    break;
	case 0xBD:     OutDebug(hWnd, "License: Sony imagesoft       "			,hList);    break;
	case 0xC2:     OutDebug(hWnd, "License: Kemco                "			,hList);    break;
	case 0xC5:     OutDebug(hWnd, "License: Data east            "			,hList);    break;
	case 0xC9:     OutDebug(hWnd, "License: Ufl                  "			,hList);    break;
	case 0xCC:     OutDebug(hWnd, "License: Use                  "			,hList);    break;
	case 0xCF:     OutDebug(hWnd, "License: Angel                "			,hList);    break;
	case 0xD2:     OutDebug(hWnd, "License: Quest                "			,hList);    break;
	case 0xD6:     OutDebug(hWnd, "License: Naxat soft           "			,hList);    break;
	case 0xDA:     OutDebug(hWnd, "License: Tomy                 "			,hList);    break;
	case 0xDE:     OutDebug(hWnd, "License: Human                "			,hList);    break;
	case 0xE1:     OutDebug(hWnd, "License: Towachiki            "			,hList);    break;
	case 0xE5:     OutDebug(hWnd, "License: Epoch                "			,hList);    break;
	case 0xE9:     OutDebug(hWnd, "License: Natsume              "			,hList);    break;
	case 0xEC:     OutDebug(hWnd, "License: Epic/sony records    "			,hList);    break;
	case 0xF3:     OutDebug(hWnd, "License: Extreme entertainment"			,hList);    break;
	case 0x08:     OutDebug(hWnd, "License: Capcom               "			,hList);    break;
	case 0x0B:     OutDebug(hWnd, "License: Coconuts             "			,hList);    break;
	case 0x18:     OutDebug(hWnd, "License: Hudsonsoft           "			,hList);    break;
	case 0x1D:     OutDebug(hWnd, "License: Clary                "			,hList);    break;
	case 0x25:     OutDebug(hWnd, "License: San-x                "			,hList);    break;
	case 0x30:     OutDebug(hWnd, "License: Infogrames           "			,hList);    break;
	case 0x33:     OutDebug(hWnd, "License: Infogrames           "			,hList);    break;
	case 0x38:     OutDebug(hWnd, "License: Capcom               "			,hList);    break;
	case 0x3E:     OutDebug(hWnd, "License: Gremlin              "			,hList);    break;
	case 0x44:     OutDebug(hWnd, "License: Malibu               "			,hList);    break;
	case 0x49:     OutDebug(hWnd, "License: Irem                 "			,hList);    break;
	case 0x4F:     OutDebug(hWnd, "License: U.s. gold            "			,hList);    break;
	case 0x52:     OutDebug(hWnd, "License: Activision           "			,hList);    break;
	case 0x55:     OutDebug(hWnd, "License: Park place           "			,hList);    break;
	case 0x59:     OutDebug(hWnd, "License: Milton bradley       "			,hList);    break;
	case 0x5C:     OutDebug(hWnd, "License: Naxat soft           "			,hList);    break;
	case 0x61:     OutDebug(hWnd, "License: Virgin               "			,hList);    break;
	case 0x6E:     OutDebug(hWnd, "License: Elite systems        "			,hList);    break;
	case 0x71:     OutDebug(hWnd, "License: Interplay            "			,hList);    break;
	case 0x75:     OutDebug(hWnd, "License: The sales curve      "			,hList);    break;
	case 0x7A:     OutDebug(hWnd, "License: Triffix entertainment"			,hList);    break;
	case 0x80:     OutDebug(hWnd, "License: Misawa entertainment "			,hList);    break;
	case 0x8B:     OutDebug(hWnd, "License: Bullet-proof software"			,hList);    break;
	case 0x8F:     OutDebug(hWnd, "License: I'max                "			,hList);    break;
	case 0x93:     OutDebug(hWnd, "License: Tsuburava            "			,hList);    break;
	case 0x97:     OutDebug(hWnd, "License: Kaneko               "			,hList);    break;
	case 0x9B:     OutDebug(hWnd, "License: Tecmo                "			,hList);    break;
	case 0x9F:     OutDebug(hWnd, "License: Nova                 "			,hList);    break;
	case 0xA4:     OutDebug(hWnd, "License: Konami               "			,hList);    break;
	case 0xA9:     OutDebug(hWnd, "License: Technos japan        "			,hList);    break;
	case 0xAD:     OutDebug(hWnd, "License: Toho                 "			,hList);    break;
	case 0xB1:     OutDebug(hWnd, "License: Ascii or nexoft      "			,hList);    break;
	case 0xB6:     OutDebug(hWnd, "License: Hal                  "			,hList);    break;
	case 0xBA:     OutDebug(hWnd, "License: *culture brain o     "			,hList);    break;
	case 0xBF:     OutDebug(hWnd, "License: Sammy                "			,hList);    break;
	case 0xC3:     OutDebug(hWnd, "License: Squaresoft           "			,hList);    break;
	case 0xC6:     OutDebug(hWnd, "License: Tonkin house         "			,hList);    break;
	case 0xCA:     OutDebug(hWnd, "License: Ultra                "			,hList);    break;
	case 0xCD:     OutDebug(hWnd, "License: Meldac               "			,hList);    break;
	case 0xD0:     OutDebug(hWnd, "License: Taito                "			,hList);    break;
	case 0xD3:     OutDebug(hWnd, "License: Sigma enterprises    "			,hList);    break;
	case 0xD7:     OutDebug(hWnd, "License: Copya systems        "			,hList);    break;
	case 0xDB:     OutDebug(hWnd, "License: Ljn                  "			,hList);    break;
	case 0xDF:     OutDebug(hWnd, "License: Altron               "			,hList);    break;
	case 0xE2:     OutDebug(hWnd, "License: Uutaka               "			,hList);    break;
	case 0xE7:     OutDebug(hWnd, "License: Athena               "			,hList);    break;
	case 0xEA:     OutDebug(hWnd, "License: King records         "			,hList);    break;
	case 0xEE:     OutDebug(hWnd, "License: Igs                  "			,hList);    break;
	case 0xFF:     OutDebug(hWnd, "License: Ljn                  "			,hList);    break;
	}

	GB_Pointer++;
	wsprintf(Info,"ROM Version: %X",*GB_Pointer);
	OutDebug(hWnd,Info,hList);

	GB_Pointer++;
	wsprintf(Info,"CRC: %X",*GB_Pointer);
	OutDebug(hWnd,Info,hList);

    GB_Pointer++;
	csum=*GB_Pointer;
	csum=csum<<24;
	csum=csum>>16;
    csum+=*(GB_Pointer+1);
	wsprintf(Info,"CheckSum: %X",csum);
	OutDebug(hWnd,Info,hList);

}

void OutDebug(HWND hWnd,char* debug,HWND hList)
{
   LVITEM LvItem;
   ZeroMemory(&LvItem,0); 
   LvItem.mask=LVIF_TEXT;   // Text Style
   LvItem.cchTextMax = 256; // Max size of test
   LvItem.iItem=500000000;  // choose item  
   LvItem.iSubItem=0;       // Put in first coluom
   LvItem.pszText=debug;    // Text to display (can be from a char variable) (Items)
   SendMessage(hList,LVM_INSERTITEM,0,(LPARAM)&LvItem); 
}

bool CheckGameBoySignature(char *FilePtr)
{
    int i;
    char* GB_Pointer = FilePtr; 
    bool SigCheck=FALSE;

    BYTE GBxSignature[]={
        0xCE, 0xED, 0x66, 0x66 ,0xCC, 0x0D, 0x00, 0x0B, 
        0x03, 0x73, 0x00, 0x83, 0x00, 0x0C, 0x00, 0x0D,
        0x00, 0x08, 0x11, 0x1F, 0x88, 0x89, 0x00, 0x0E,
        0xDC, 0xCC, 0x6E, 0xE6, 0xDD, 0xDD, 0xD9, 0x99,
        0xBB, 0xBB, 0x67, 0x63, 0x6E, 0x0E, 0xEC, 0xCC,
        0xDD, 0xDC, 0x99, 0x9F, 0xBB, 0xB9, 0x33, 0x3E
    };

    // Check Signature
    GB_Pointer+=0x104;
    
    _asm pushad
    _asm lea esi,GBxSignature
    _asm mov edi,GB_Pointer

    for(i=0;i<0x30;i+=4)
    {
        _asm{                       
            mov eax, dword ptr [esi]
            mov ecx, dword ptr [edi]
            bswap eax
            bswap ecx
            cmp eax,ecx
            jnz bad
            mov SigCheck,0
            jmp end
        bad:
            mov SigCheck,1
        end: 
            add esi,4            
            add edi,4
        }

        if(SigCheck==TRUE)
        {
            _asm popad
            return FALSE;
        }
    }
    _asm popad
    return TRUE;
}