                             #include "Main.h"

//////////////////////////////////////////////////////////////////////////
//                    GLOBAL VARIABLES                                  //
//////////////////////////////////////////////////////////////////////////

HINSTANCE hDllInstance;
PLUGINFO  PlgData;
WNDPROC   OldWndProc;
HWND      Main_hWnd;

int WINAPI DllMain(HINSTANCE hInstance,DWORD  reason, LPVOID Reserved)
{
	// Store the instance we get
	hDllInstance = hInstance;

	// Return true, we are ready for hook on the system
	return TRUE;
}

void InstallDll(PLUGINFO plg)
{
    PlgData.DisasmReady = plg.DisasmReady;
    PlgData.FilePtr     = plg.FilePtr;
    PlgData.LoadedPe    = plg.LoadedPe;
    PlgData.Parent_hWnd = plg.Parent_hWnd;
    PlgData.FileSize    = plg.FileSize;
    
    DialogBoxParam(hDllInstance, MAKEINTRESOURCE(IDD_MAIN_PLUGIN), NULL, (DLGPROC)DlgProc,0);
}

char* PluginInfo()
{
    return PLUGIN_NAME;
}

BOOL GoodChars(LONG wParam)
{
    switch(wParam)
    {
      case 0x61: case 0x62:
      case 0x63: case 0x64:
      case 0x65: case 0x66:
      case 0x30: case 0x31:
      case 0x32: case 0x33:
      case 0x34: case 0x35:
      case 0x36: case 0x37:
      case 0x38: case 0x39:
      case 0x41: case 0x42:
      case 0x43: case 0x44:
      case 0x45: case 0x46:
      {          
        return true;    
      }
      break;

      default: return false; break;
    }

    return false;
}

BOOL CALLBACK DlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) // what are we doing ?
	{ 	 
		case WM_INITDIALOG: 
		{
            Main_hWnd = hWnd;
            InitCommonControls();
            // SubClass the EditControl
            SendDlgItemMessage(hWnd,IDC_COMMAND,EM_SETLIMITTEXT,(WPARAM)50,0);            
            SendMessage(GetDlgItem(hWnd,IDC_COMMAND),EM_SETSEL,(WPARAM)0,(LPARAM)1);  
            SetFocus(GetDlgItem(hWnd,IDC_COMMAND));            
            
            OldWndProc=(WNDPROC)SetWindowLong(GetDlgItem(hWnd,IDC_COMMAND),GWL_WNDPROC,(LONG)EditBoxSubClass);

            ShowWindow(hWnd,SW_NORMAL);                      
		}
		break;

		case WM_LBUTTONDOWN: 
		{
			ReleaseCapture(); 
			SendMessage(hWnd,WM_NCLBUTTONDOWN,HTCAPTION,0); 
		}
		break;

		case WM_PAINT: // constantly painting the window
		{
			return 0;
		}
		break;
		
        
		case WM_COMMAND:
		{
		   switch(LOWORD(wParam)) // what we press on?
           {
                case IDC_CLEAR:
                {
                    SendDlgItemMessage(hWnd,IDC_LIST,LB_RESETCONTENT,0,0);
                }
                break;
           }
		}
		break;
        

        case WM_CLOSE: // We colsing the Dialog
        {
          EndDialog(hWnd,0); 
        }
	    break;
	}
	return 0;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

LRESULT CALLBACK EditBoxSubClass(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    switch(uMsg)
    {
	    case WM_GETDLGCODE:
		{
			return DLGC_WANTALLKEYS;
		}
		break;

        case WM_INITDIALOG:
        {
            SetFocus(hWnd);
            HideCaret(hWnd);
        }
        break;

        case WM_SETCURSOR:
        {           
            SetClassLong(hWnd,GCL_HCURSOR, (LONG)LoadCursor(NULL,IDC_ARROW));                       
        }
        break; 

        
        case WM_MOUSEMOVE:
        {
            if(wParam & MK_LBUTTON)
                return false;
        }
        break;

        case WM_CHAR:
        {
           if(GoodChars(wParam)==FALSE) return false;
        }
        break;

        
        case WM_CONTEXTMENU:
        {
            return false;
        }
        break;

        case WM_KEYDOWN:
        {                                
            switch(wParam)
            {
                case VK_RIGHT: case VK_DOWN:
                case VK_UP: case VK_LEFT:
                {
                    if(GetKeyState(VK_SHIFT) & 0x8000) return false;
                }
                break;

                case VK_DELETE:
                {
                   // return false;
                }
                break; 
                
                default:
                {
                    int res=0;                      
                    res=SendMessage(hWnd,EM_GETSEL,(WPARAM)0,(LPARAM)0);
                    res&=0x0FFFF;  // Get Starting Point  
                    res++;

                    if(res%3==0 && res!=0)                                                                                      
                    {
                        char buff[256];                                     
                        SendMessage(hWnd,WM_GETTEXT,(WPARAM)256,(LPARAM)buff);
                        lstrcat(buff," ");
                        SendMessage(hWnd,WM_SETTEXT,(WPARAM)FALSE,(LPARAM)buff);
                        SendMessage(hWnd,EM_SETSEL,(WPARAM)res,(LPARAM)res+1);
                    }
                }
                break;
            }
            break;            
        }
        break;

        case WM_KEYUP:
        {
            switch(wParam)
            {                
                case VK_HOME:
                {
                    SendMessage(hWnd,EM_SETSEL,(WPARAM)0,(LPARAM)1);
                }
                break;

                case VK_RIGHT:  case VK_DOWN:
                {
                    int res=0;                    
                    res=SendMessage(hWnd,EM_GETSEL,(WPARAM)0,(LPARAM)0);
                    res&=0x0FFFF;  // Get Starting Point 
                    if(res%3!=0)                        
                     res--;
                    SendMessage(hWnd,EM_SETSEL,(WPARAM)res,(LPARAM)res+1);
                }
                break;

                case VK_UP: case VK_LEFT:case VK_END:
                {
                    int res=0;                      
                    res=SendMessage(hWnd,EM_GETSEL,(WPARAM)0,(LPARAM)0);
                    res&=0x0FFFF;  // Get Starting Point                       
                    
                    if((res-1)==-1)
                    {
                        SendMessage(hWnd,EM_SETSEL,(WPARAM)0,(LPARAM)1);
                        break;
                    } 
                    
                    if(res%3==0)                        
                     res--;

                    SendMessage(hWnd,EM_SETSEL,(WPARAM)res,(LPARAM)res-1);
                }
                break;

                case VK_RETURN:
                {
                    DisassembleCode(hWnd);
                }
                break;

                default:
                {
                    int res=0,pos;                    
                    res=SendMessage(hWnd,EM_GETSEL,(WPARAM)0,(LPARAM)0);
                    res&=0x0FFFF;  // Get Starting Point 
                    res++;

                    if(res%3!=0)                        
                     res--;

                    if(res%3==0 && res!=0)                                                                                      
                    {
                        char buff[256];                                     
                        SendMessage(hWnd,WM_GETTEXT,(WPARAM)256,(LPARAM)buff);
                        lstrcat(buff," ");
                        SendMessage(hWnd,WM_SETTEXT,(WPARAM)FALSE,(LPARAM)buff);
                    }
                        
                    SendMessage(hWnd,EM_SETSEL,(WPARAM)res,(LPARAM)res+1);
                    pos=SendMessage(hWnd,EM_LINELENGTH,0,(LPARAM)-1);
                    if(res>pos)
                        SendMessage(hWnd,EM_SETSEL,(WPARAM)pos-1,(LPARAM)pos);
                }
                break;
            }
            break;
        }
        break;        

        case WM_UNDO:
        case WM_PASTE:
        {
            return false;
        }
        break;
            

        case WM_LBUTTONUP:
        {
            int res=0;  
            SetFocus(hWnd);
            HideCaret(hWnd);
            res=SendMessage(hWnd,EM_GETSEL,(WPARAM)0,(LPARAM)0);
            res&=0x0FFFF;  // Get Starting Point 
            if(res%3!=0)                        
                res--;
            SendMessage(hWnd,EM_SETSEL,(WPARAM)res,(LPARAM)res+1);
        }
        break;
    }   

    return CallWindowProc(OldWndProc, hWnd, uMsg, wParam, lParam);
}

void DisassembleCode(HWND hWnd)
{
    DISASSEMBLY DisasmData;
    DWORD Index=0,Size,k=0,x=0;
    byte table[]={0,1,2,3,4,5,6,7,8,9,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F}; 
    char Temp[128]="";
    char Text[256]="";
    char *DisasmPtr;

    SendMessage(hWnd,WM_GETTEXT,(WPARAM)256,(LPARAM)Temp);
    x=lstrlen(Temp);
    Temp[x-1]='\0';

    x=0;
    // Remove Spaces
    for(;k<(DWORD)lstrlen(Temp);k++,x++)
    {
        if(Temp[k]==' ')
            k++;
        
        Text[x]=Temp[k];
    }

    Size =lstrlen(Text)/2; 
    // Allocate Size bytes
    byte *op=new byte[Size*3]; 
    
    for(x=0;x<Size*3;x++)
        op[x]=0x00;
    
    // Format New Changes
    for(k=0,x=0;k<(DWORD)lstrlen(Text);k+=2,x++)
    {
        if(Text[k]>=0x30 && Text[k]<=0x39)
            op[x]=(table[Text[k]-0x30])<<4;
        
        if(Text[k]>='A' && Text[k]<='F')
            op[x] = (table[Text[k]-0x37])<<4;
        
        if(Text[k+1]>=0x30 && Text[k+1]<=0x39)                      
            op[x]|=(table[Text[k+1]-0x30]);                          
        
        
        if(Text[k+1]>='A' && Text[k+1]<='F')                      
            op[x] |= table[Text[k+1]-0x37];                                                
    }
        
    // Create On the fly Disassembly
    DisasmPtr = (char*)op;

    // Send Message to Main Gui   
    ZeroMemory(&DisasmData,sizeof(DISASSEMBLY));
    SendMessage(*PlgData.Parent_hWnd,PI_GETASM,(WPARAM)DisasmPtr,(LPARAM)&DisasmData);

    wsprintf(Text,"%s -> %s",DisasmData.Opcode+2,DisasmData.Assembly+2);
    SendDlgItemMessage(Main_hWnd,IDC_LIST,LB_ADDSTRING,0,(LPARAM)Text);
    
    delete[] op;
    
    
}