#ifndef _DLL_H_
#define _DLL_H_

// ================================================================
// ========================== INCLUDES ============================
// ================================================================
#include <windows.h>
#include <COMMCTRL.H>
#include "Res/resource.h"

// Here we declare our functions for the outsite, that they can be called.
#define DLL_EXPORT __declspec(dllexport)

#define PLUGIN_NAME "Command Line Disassembler" // No More than 128 characters!!

// PLUGIN MESSAGES
#define PI_GETASM WM_USER+200
#define PI_FLUSHDISASM WM_USER+202

//////////////////////////////////////////////////////////////////////////
//                          STRUCTS                                     //
//////////////////////////////////////////////////////////////////////////

typedef struct tagPluginInfo{

    HWND* Parent_hWnd;
    BYTE* FilePtr;
    DWORD FileSize;
    bool  DisasmReady;
    bool  LoadedPe;

}PLUGINFO;

typedef struct Code_Flow{

    bool Jump;   // Instruction is a Jcc / jmp
    bool Call;   // Instruction is a Call

} CODE_FLOW;

typedef struct Decoded{
	
	// Define Decoded instruction struct

    DWORD     Address;       // Current address of decoded instruction
    CODE_FLOW CodeFlow;      // InstructionS: Jump or Call 
    BYTE      OpcodeSize;    // Opcode Size
	BYTE      PrefixSize;    // Size of all prefixes used
    char      Assembly[128]; // Menemonics
    char      Remarks[256];  // Menemonic addons
    char      Opcode[25];    // Opcode Byte forms

} DISASSEMBLY;

// ================================================================
// =====================  EXTERNAL FUNCTIONS  =====================
// ================================================================
extern "C" { 
    
    DLL_EXPORT void  InstallDll(PLUGINFO);  
    DLL_EXPORT char* PluginInfo();
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

BOOL GoodChars(LONG wParam);
void DisassembleCode(HWND hWnd);
BOOL CALLBACK DlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK EditBoxSubClass(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

#endif