; Searcher implemented - with "advanced" search - 1.0 BETA
; simple patcher implemented and working
; Compiled with tasm 3.2 - you might need to modify it slightly to compile with
; newer tasm
; tasm /m stnsdp.asm
; tlink /3 stnsdp

.model SMALL
.stack 100h
.386

.data         
;*****************************************************************************
; All This is what needs modification
;*****************************************************************************

input  DB 'input.com',0			; Insert dos-filename here

findme DB '2nd',0,'ni'			; String to search for
lenght DB 6				; number of bytes in this string

patchme DB '&'				; String to patch
nobytes DB 1				; Number of bytes to patch
negdisp DB 3				; How far behind the end of the search
					; string the program will patch

;*****************************************************************************
; From here down is "Fixed" values you do not need to bother yourself about
;*****************************************************************************

;------------------------- various texts
perstag DB '2nd&mi'			; Personal tag - not used

introtxt DB '     Stone''s Search & Destroy Patch      ',10,13
         DB '|   STONE   |',10,13
         DB '                 ',10,13
         DB '                          ',10,13
         DB '                           ',10,13
         DB '                    ',10,13
         DB '',10,13
         DB 'u N I T E D  c R  C K I N G  f O R C E  ',10,13
         DB '[wIN95/NT][oCT 1997]',10,13,'$'

openerr DB 'An error seem to have occured opening the file',13,10,'$'
nothere DB 'Search string was NOT found - patch not applied',13,10,'$'
itshere DB 'Search string found - applying patch',10,13,'$'

;----- filehandling
inputhnd 	DD 0 
byteread  	DD 0				; how many bytes to search thru?`
position  	DD 0		
BUFFER 		DB 0ffh dup (?) 		; read buffer!

;*****************************************************************************
; Code starts here 
;*****************************************************************************

.CODE
	MOV AX,@DATA			; Make DS & ES point to the data
	MOV ES,AX
	MOV DS,AX
	LEA edx, introtxt
	mov ah,9h
	int 21h

	LEA EDX, [input]		; open the inputfile
	MOV AL,2
	CALL open
	MOV inputhnd, EBX		; save handle

	JMP firstblock			; start searching

nextblock:
	CALL movefilep
firstblock:
	CALL readfile			; read file
	CMP EAX,6			; too few bytes read for it to be anything
	JL nope
	CMP EAX,40h			; Not a very good check for done reading
	JZ nope

	LEA ESI, [findme]		; setup search registers
	LEA EDI, [BUFFER]
searchmore:
	LEA EDX, [BUFFER]		; this is how far we wanna go
	ADD EDX, [byteread]
	PUSH EDX
	MOV ECX,EDI			; this is how far we have yet to go
	SUB EDX,ECX
	XCHG ECX,EDX
	POP EDX				; restore edx

	MOV AL, BYTE PTR [findme]
	REPNZ SCASB			; Why won't this work with SCASW?
	CMP EDI,EDX
	JGE nextblock
	DEC EDI				; Move pointer back
	MOVZX ECX, [lenght]		; Compare strings
continue:
	REPZ CMPSB
	JZ found
	DEC ESI				; String compare rejected - check further
	LODSB				; Get what it rejected on
	CMP AL,0			; was it 0?
	JZ continue			; If it rejected on "blank char" then 
					; Check the rest

	LEA ESI, [findme]		; restore search string
	JMP searchmore			; continiue hunt in this block

found:					; WOooHOoo we found the string
	LEA EDX, [itshere]		; Give the user the joyable news
	MOV AH,9
	INT 21h
	CALL patch			; patch it
	CALL EXIT			; terminate
nope:
	LEA EDX, [nothere]		; apparently we did not find the string
	MOV AH,9
	INT 21h
	CALL EXIT			; Exit

patch PROC
	LEA EDX, BUFFER			; Calculate how far down in block
	SUB EDI, EDX			; the string was
	ADD [position],EDI		; add this to current position in file
	MOV EDX, [byteread]		; move back the file pointer since
	SUB [position], EDX		; we read bytes to compare them
	MOVZX EDX,[negdisp]		; adjust for displacement
	SUB [position], EDX

	CALL setfilep			; set the file pointer
	MOVZX ECX, [nobytes]		; patch this many bytes
	LEA EDX, [patchme]		; from this buffer
	MOV AH,40h			
	INT 21h				; patch
	RET
patch ENDP

EXIT PROC
	CALL close			; Close the file
	MOV AX,4c00h			; terminate - errorcode 0
	INT 21h
EXIT ENDP

setfilep PROC
	MOV AH,42h			; Set file pointer
	MOV AL,0h			; from start of file
	MOV EDX, DWORD PTR [position]	; to this offset
	XOR ECX,ECX			; not a *HUGE* file
	INT 21h				; do it
	RET
setfilep ENDP

movefilep	PROC
	MOV AH,42h			; move the file pointer back
	MOV AL,0h
	SUB DWORD PTR [position],40h	; 40h spaces from what it is now
	MOV EDX, DWORD PTR [position]	
	XOR ECX,ECX			; not a huge file
	INT 21h
	RET
movefilep ENDP
	
OPEN	PROC				; Open file in edx - return handle in
	MOV AH,3dh			; ebx
	INT 21h
	JC erroropen			; did an error occour?
	XCHG EAX,EBX
	RET
erroropen:				
	LEA EDX, [openerr]		; Write the error message
	MOV AH,9h
	INT 21h

	MOV AX,4c01h			; terminate error code = 1
	INT 21h
	RET
OPEN    ENDP

close   PROC
	MOV EBX, inputhnd		; close input file
	MOV AH,3eh
	INT 21h
	RET
close ENDP

readfile PROC
	MOV EBX, inputhnd		; fetch the handle of inputfile
	MOV ECX,0ffh			; number of bytes to read
	LEA EDX, [BUFFER]	 	; where to read it to
	MOV AH,3fh
	INT 21h
	MOV [byteread],EAX		; this many bytes were actually read
	ADD DWORD PTR [position],EAX
	RET
readfile ENDP


END
