
#include <stdio.h>
#include <fcntl.h>
#include <io.h>

struct infostruct {
  char *filename;
  unsigned long filesize;
  unsigned long ps_size;
};

struct patchstruct {
  unsigned long pos;
  unsigned char old_byte;
  unsigned char new_byte;
};

int do_patch(struct infostruct is, struct patchstruct ps[]);

char *msg_welcome = "Welcome to this Crack by Quantico of  Mexelite'98.\n\n";
char *msg_completed = "\nmex98.home.ml.org\n";

#define PATCHSIZE_1 8
struct infostruct is_1 = { "Dirtkt.exe" , 0x9E000 , PATCHSIZE_1 };
struct patchstruct ps_1 [PATCHSIZE_1] = {
  { 0xC733, 0xE8, 0x40 },
  { 0xC734, 0xC8, 0x48 },
  { 0xC735, 0x0F, 0x40 },
  { 0xC736, 0x00, 0x48 },
  { 0xC737, 0x00, 0x90 },
  { 0xC74B, 0x74, 0xEB },
  { 0xC79F, 0x7D, 0x00 },
  { 0xC7A0, 0x08, 0x00 },
};

int main(void) {
  printf("UU   UU    U   U                \n");
  printf("UUUU UU UU UU UU _U    UU UU '97\n");
  printf("UU U UU UU  _U UY UU  _U    UU UU     \n");
  printf("UU   UU UU   _UUY  UU  _U    UU  UY     UU     \n");
  printf("UU   UU UU   _U UY UU   _U      UY     UU      \n");
  printf("UU   UU UU  _U UY UU  _U UY UY     UU     \n");
  printf("UU   UU UU _U UY UU _U UY UY     UU    \n");
  printf("UU                 UY UY [mP]     \n");
  printf("UU                                      UU                  \n");
  printf("U U                                      U U                    \n");
  printf("U U                                                          \n");
  printf(" \n");
  printf("%s", msg_welcome);
  do_patch(is_1, ps_1);
  printf("%s", msg_completed);
  return 0;
}

int do_patch(struct infostruct is, struct patchstruct ps[]) {
  int handle;
  unsigned long counter;
  unsigned char value;

  printf("checking for %s... ", is.filename);

  if ((handle = open(is.filename, O_RDWR | O_BINARY)) == -1) {
    printf("not found.\n");
    return -1;
  } else printf("found... ");

  if (filelength(handle) != is.filesize) {
    printf("incorrect filesize.\n");
    return -1;
  } else printf("now patching... ");

  for (counter=0; counter<is.ps_size; counter++) {
    lseek(handle, ps[counter].pos, SEEK_SET);
    read(handle, &value, 1);
    if (value != ps[counter].old_byte) {
      if (value == ps[counter].new_byte) {
        printf("file already patched.\n");
        return -2;
      }
      printf("incompatible file.\n");
      return -2;
    }
    lseek(handle, ps[counter].pos, SEEK_SET);
    write(handle, &ps[counter].new_byte, 1);
  }
  printf("done.\n");
  close(handle);
  return 0;
}
