;
;	________________________________________________________________
;
;	                          W32Main.inc
;	                  Win32 Main Header File V2.00
;	        06-07-1996 Sven B. Schreiber sbs@psbs.franken.de
;	                 This is Public Domain Software
;	________________________________________________________________
;
.386
;
;==============================================================================
;
;	DISCLAIMER
;
;==============================================================================
;
; This software is provided "as is" and any express or implied warranties,
; including, but not limited to, the implied warranties of merchantibility and
; fitness for a particular purpose are disclaimed. In no event shall the
; author Sven B. Schreiber be liable for any direct, indirect, incidental,
; special, exemplary, or consequential damages (including, but not limited to,
; procurement of substitute goods or services; loss of use, data, or profits;
; or business interruption) however caused and on any theory of liability,
; whether in contract, strict liability, or tort (including negligence or
; otherwise) arising in any way out of the use of this software, even if
; advised of the possibility of such damage.
;
;==============================================================================
;
;	LINKER DEFINITIONS
;
;==============================================================================
;
W32LINK_SUBSYS			equ	00001111b	;subsystem bitmask
W32LINK_UNICODE			equ	00010000b	;unicode flag
W32LINK_DLL			equ	00100000b	;dll flag
W32LINK_OVERRIDE		equ	1		;1 = override defaults
;
;------------------------------------------------------------------------------
;
PE_SUBSYS_UNKNOWN		equ	0		;unknown subsystem
PE_SUBSYS_NATIVE		equ	1		;no subsystem required
PE_SUBSYS_WINDOWS_GUI		equ	2		;windows graphical app
PE_SUBSYS_WINDOWS_CUI		equ	3		;windows console app
PE_SUBSYS_OS2_CUI		equ	5		;os/2 console app
PE_SUBSYS_POSIX_CUI		equ	7		;posix console app
;
;------------------------------------------------------------------------------
;
IMPORT			macro	s00,s01,s02,s03,s04,s05,s06,s07,s08,s09,\
				s10,s11,s12,s13,s14,s15,s16,s17,s18,s19
;
			if	W32LINK_OVERRIDE
;
			if	CONSOLE
;
_STYLE_			equ	(W32LINK_SUBSYS  and PE_SUBSYS_WINDOWS_CUI) +\
				(W32LINK_UNICODE  *  UNICODE)+\
				(W32LINK_DLL      *  DLL)
;
			else
;
_STYLE_			equ	(W32LINK_SUBSYS  and PE_SUBSYS_WINDOWS_GUI) +\
				(W32LINK_UNICODE  *  UNICODE)+\
				(W32LINK_DLL      *  DLL)
;
			endif
;
_IMPORT_		textequ	<>
;
			irp	sxx,<s00,s01,s02,s03,s04,s05,s06,s07,s08,s09,\
				     s10,s11,s12,s13,s14,s15,s16,s17,s18,s19>
			ifnb	<sxx>
;
_IMPORT1_		=	0
_IMPORT2_		=	sxx
;
			while	_IMPORT2_
_IMPORT1_		=	(_IMPORT1_ * 256) + (_IMPORT2_ mod 256)
_IMPORT2_		=	_IMPORT2_ / 256
			endm
;
_IMPORT_		catstr	_IMPORT_,<$>,%_IMPORT1_
;
			endif
			endm
;
_CLASS_			catstr	<">,%W32LINK_OVERRIDE,<$>,%_STYLE_,_IMPORT_,<">
;
			else
;
_CLASS_			catstr	<">,%W32LINK_OVERRIDE,<">
;
			endif
;
			endm
;==============================================================================
;
;	BASIC TYPES
;
;==============================================================================
;
ACHAR				typedef	BYTE	;ansi character
ATOM				typedef DWORD	;string atom
BOOL				typedef DWORD	;boolean variable
COLORREF			typedef	DWORD	;rgb color
DWORDLONG			typedef	QWORD	;long double word
FARPROC				typedef	DWORD	;far pointer to procedure
GLOBALHANDLE			typedef	DWORD	;global handle
HACCEL				typedef DWORD	;accelerator handle
HANDLE				typedef DWORD	;unspecified handle
HBITMAP				typedef	DWORD	;bitmap handle
HBRUSH				typedef	DWORD	;brush handle
HCOLORSPACE			typedef	DWORD	;color space handle
HCURSOR				typedef	DWORD	;cursor handle
HDC				typedef	DWORD	;device context handle
HDWP				typedef	DWORD	;defer win pos handle
HENHMETAFILE			typedef	DWORD	;enhanced metafile handle
HFILE				typedef	DWORD	;file handle
HFONT				typedef	DWORD	;font handle
HGLOBAL				typedef	DWORD	;global handle
HHOOK				typedef	DWORD	;hook handle
HICON				typedef	DWORD	;icon handle
HINSTANCE			typedef	DWORD	;instance handle
HINTERNET			typedef	DWORD	;internet handle
HLOCAL				typedef	DWORD	;local handle
HMENU				typedef	DWORD	;menu handle
HMETAFILE			typedef	DWORD	;metafile handle
HMODULE				typedef	DWORD	;module handle
HPALETTE			typedef	DWORD	;palette handle
HPEN				typedef	DWORD	;pen handle
HRGN				typedef	DWORD	;region handle
HRSRC				typedef	DWORD	;resource handle
HSTR				typedef	DWORD	;string handle
HTASK				typedef	DWORD	;task handle
HTREEITEM			typedef	DWORD	;tree view item handle
HWND				typedef	DWORD	;window handle
NWCCODE				typedef	DWORD	;completion code
NWCONN_HANDLE			typedef	DWORD	;connection handle
NWCONN_NUM			typedef	WORD	;connection number
NWDIR_HANDLE			typedef	BYTE	;directory handle
NWOBJ_ID			typedef	DWORD	;object id
NWOBJ_TYPE			typedef	WORD	;object type
NWSTATION_NUM			typedef	BYTE	;station number
NWSTATION_NUM2			typedef	DWORD	;long station number
INTEGER				typedef	DWORD	;standard integer
INTERNET_PORT			typedef	WORD	;internet port
LOCALHANDLE			typedef	DWORD	;local handle
LONG				typedef	DWORD	;long integer
LONGINT				typedef	DWORD	;long integer
LPARAM				typedef	DWORD	;long parameter
LPASTR				typedef	DWORD	;long pointer to ansi string
LPBOOL				typedef DWORD	;long pointer to boolean
LPBYTE				typedef DWORD	;long pointer to byte
LPCSTR				typedef DWORD	;long pointer to string
LPCTSTR				typedef DWORD	;long pointer to string
LPCVOID				typedef	DWORD	;long pointer to buffer
LPDWORD				typedef	DWORD	;long pointer to dword
LPFN				typedef DWORD	;long pointer to function
LPINT				typedef DWORD	;long pointer to integer
LPLONG				typedef DWORD	;long pointer to long integer
LPSHORT				typedef DWORD	;long pointer to short integer
LPSTR				typedef DWORD	;long pointer to string
LPTSTR				typedef DWORD	;long pointer to string
LPVOID				typedef	DWORD	;long pointer to buffer
LPWORD				typedef	DWORD	;long pointer to word
LPWSTR				typedef	DWORD	;long pointer to unicode string
LRESULT				typedef DWORD	;long result
NTSTATUS			typedef DWORD	;nt status code
PADDR				typedef DWORD	;pointer to address
PASTR				typedef DWORD	;pointer to ansi string
PBOOL				typedef DWORD	;pointer to boolean
PBYTE				typedef DWORD	;pointer to byte
PDWORD				typedef	DWORD	;pointer to dword
PFN				typedef DWORD	;pointer to function
PINT				typedef DWORD	;pointer to integer
PLONG				typedef DWORD	;pointer to long integer
POINTER				typedef DWORD	;pointer to anything
PPADDR				typedef DWORD	;pointer to address pointer
PPASTR				typedef DWORD	;pointer to ansi string pointer
PPBOOL				typedef DWORD	;pointer to boolean pointer
PPBYTE				typedef DWORD	;pointer to byte pointer
PPDWORD				typedef	DWORD	;pointer to dword pointer
PPFN				typedef DWORD	;pointer to function pointer
PPINT				typedef DWORD	;pointer to integer pointer
PPLONG				typedef DWORD	;pointer to long integer ptr
PPOINTER			typedef DWORD	;pointer to anything pointer
PPSHORT				typedef DWORD	;pointer to short integer ptr
PPSTR				typedef DWORD	;pointer to string pointer
PPVOID				typedef DWORD	;pointer to buffer pointer
PPWORD				typedef	DWORD	;pointer to word pointer
PPWSTR				typedef DWORD	;pointer to unicode string ptr
PSHORT				typedef DWORD	;pointer to short integer
PSTR				typedef DWORD	;pointer to string
PVOID				typedef DWORD	;pointer to buffer
PWORD				typedef	DWORD	;pointer to word
PWSTR				typedef DWORD	;pointer to unicode string
SHORTINT			typedef	WORD	;short integer
SOCKET				typedef	DWORD	;socket
u_char				typedef	BYTE	;unsigned character
u_int				typedef	DWORD	;unsigned integer
u_long				typedef	DWORD	;unsigned long integer
u_short				typedef	WORD	;unsigned short integer
UACHAR				typedef	BYTE	;unsigned ansi character
UINT				typedef	DWORD	;unsigned integer
ULONG				typedef	DWORD	;unsigned long integer
USHORT				typedef	WORD	;unsigned short integer
UWCHAR				typedef	WORD	;unsigned unicode character
WCHAR				typedef	WORD	;unicode character
WNDPROC				typedef	DWORD	;window procedure
WPARAM				typedef	DWORD	;word parameter
;
;==============================================================================
;
;	COMPLEX TYPES
;
;==============================================================================
;
ASTRING		macro	_STRING_
;
_ESC_		=	0
		forc	_CHAR_,<_STRING_>
;
		if	_ESC_
_ESC_		=	0
;
		if	"&_CHAR_" eq "/"
		BYTE	"/"
		elseif	"&_CHAR_" eq "n"
		BYTE	0Dh, 0Ah
		elseif	"&_CHAR_" eq "r"
		BYTE	0Dh
		elseif	"&_CHAR_" eq "l"
		BYTE	0Ah
		elseif	"&_CHAR_" eq "t"
		BYTE	09h
		elseif	"&_CHAR_" eq ":"
		BYTE	"!"
		elseif	"&_CHAR_" eq "-"
		BYTE	"'"
		elseif	"&_CHAR_" eq "="
		BYTE	'"'
		elseif	"&_CHAR_" eq "|"
		BYTE	"\"
		elseif	"&_CHAR_" eq "#"
		BYTE	"%"
		elseif	"&_CHAR_" eq "+"
		BYTE	"&"
		elseif	"&_CHAR_" eq "("
		BYTE	"<"
		elseif	"&_CHAR_" eq ")"
		BYTE	">"
		elseif	"&_CHAR_" eq "0"
		BYTE	0
		elseif	"&_CHAR_" eq "1"
		BYTE	1
		else
		BYTE	"/", "&_CHAR_"
		endif
;
		else
;
		if	"&_CHAR_" eq "/"
_ESC_		=	1
		else
_ESC_		=	0
		BYTE	"&_CHAR_"
		endif
;
		endif
;
		endm
;
		endm
;
;------------------------------------------------------------------------------
;
WSTRING		macro	_STRING_
;
_ESC_		=	0
		forc	_CHAR_,<_STRING_>
;
		if	_ESC_
_ESC_		=	0
;
		if	"&_CHAR_" eq "/"
		WORD	"/"
		elseif	"&_CHAR_" eq "n"
		WORD	0Dh, 0Ah
		elseif	"&_CHAR_" eq "r"
		WORD	0Dh
		elseif	"&_CHAR_" eq "l"
		WORD	0Ah
		elseif	"&_CHAR_" eq "t"
		WORD	09h
		elseif	"&_CHAR_" eq ":"
		WORD	"!"
		elseif	"&_CHAR_" eq "-"
		WORD	"'"
		elseif	"&_CHAR_" eq "="
		WORD	'"'
		elseif	"&_CHAR_" eq "|"
		WORD	"\"
		elseif	"&_CHAR_" eq "#"
		WORD	"%"
		elseif	"&_CHAR_" eq "+"
		WORD	"&"
		elseif	"&_CHAR_" eq "("
		WORD	"<"
		elseif	"&_CHAR_" eq ")"
		WORD	">"
		elseif	"&_CHAR_" eq "0"
		WORD	0
		elseif	"&_CHAR_" eq "1"
		WORD	1
		else
		WORD	"/", "&_CHAR_"
		endif
;
		else
;
		if	"&_CHAR_" eq "/"
_ESC_		=	1
		else
_ESC_		=	0
		WORD	"&_CHAR_"
		endif
;
		endif
;
		endm
;
		endm
;
;------------------------------------------------------------------------------
;
STRING		macro	_STRING_
;
		if	UNICODE
		WSTRING	<_STRING_>
		else
		ASTRING	<_STRING_>
		endif
;
		endm
;
;------------------------------------------------------------------------------
;
DLGTEMPLATE	macro	_dtStyle, _dtItems, _dtX, _dtY, _dtCX, _dtCY, _dtText
;
_ADDR_		=	$
		DWORD	_dtStyle, 0
		WORD	_dtItems
		WORD	_dtX, _dtY, _dtCX, _dtCY
		WORD	0
		WORD	0
		WSTRING	<_dtText/0>
;
		if	($-_ADDR_) and 2
		WORD	0
		endif
;
		endm
;
;------------------------------------------------------------------------------
;
DLGITEMTEMPLATE	macro	_ditStyle, _ditX, _ditY, _ditCX, _ditCY,\
			_ditId, _ditClass, _ditText, _ditResId
;
_ADDR_		=	$
		DWORD	_ditStyle, 0
		WORD	_ditX, _ditY, _ditCX, _ditCY
		WORD	_ditId
		WORD	-1, _ditClass
		ifb	<_ditResId>
		WSTRING	<_ditText/0>
		else
		WORD	_ditText, _ditResId
		endif
		WORD	0
;
		if	($-_ADDR_) and 2
		WORD	0
		endif
;
		endm
;
;------------------------------------------------------------------------------
;
lodczx		macro	_from
;
		if	UNICODE
		movzx	eax,word ptr _from
		else
		movzx	eax,byte ptr _from
		endif
;
		endm
;
;------------------------------------------------------------------------------
;
lodc		macro	_from
;
		if	UNICODE
		mov	ax,_from
		else
		mov	al,_from
		endif
;
		endm
;
;------------------------------------------------------------------------------
;
stoc		macro	_to
;
		if	UNICODE
		mov	_to,ax
		else
		mov	_to,al
		endif
;
		endm
;
;------------------------------------------------------------------------------
;
xchc		macro	_with
;
		if	UNICODE
		xchg	ax,_with
		else
		xchg	al,_with
		endif
;
		endm
;
;------------------------------------------------------------------------------
;
cmpc		macro	_against
;
		if	UNICODE
		cmp	ax,_against
		else
		cmp	al,_against
		endif
;
		endm
;
;------------------------------------------------------------------------------
;
subc		macro	_what
;
		if	UNICODE
		sub	ax,_what
		else
		sub	al,_what
		endif
;
		endm
;
;------------------------------------------------------------------------------
;
addc		macro	_what
;
		if	UNICODE
		add	ax,_what
		else
		add	al,_what
		endif
;
		endm
;
;------------------------------------------------------------------------------
;
incc		macro	_what
;
		if	UNICODE
		inc	_what
		inc	_what
		else
		inc	_what
		endif
;
		endm
;
;------------------------------------------------------------------------------
;
decc		macro	_what
;
		if	UNICODE
		dec	_what
		dec	_what
		else
		dec	_what
		endif
;
		endm
;
;------------------------------------------------------------------------------
;
cc2bc		macro	_count
;
		if	UNICODE
		shl	_count,1
		endif
;
		endm
;
;------------------------------------------------------------------------------
;
bc2cc		macro	_count
;
		if	UNICODE
		shr	_count,1
		endif
;
		endm
;
;==============================================================================
;
;	BASIC CONSTANTS
;
;==============================================================================
;
ACHAR_				equ	1		;ansi char size
WCHAR_				equ	2		;unicode char size
;
				if	UNICODE
;
CHAR				textequ	<WCHAR>		;unicode char type
CHAR_				equ	WCHAR_		;unicode char size
;
UCHAR				textequ	<WCHAR>		;unicode char type
UCHAR_				equ	WCHAR_		;unicode char size
;
				else
;
CHAR				textequ	<ACHAR>		;ansi char type
CHAR_				equ	ACHAR_		;ansi char size
;
UCHAR				textequ	<ACHAR>		;ansi char type
UCHAR_				equ	ACHAR_		;ansi char size
;
				endif
;
;------------------------------------------------------------------------------
;
NULL				equ	0		;null
FALSE				equ	0		;boolean false
TRUE				equ	1		;boolean true
;
;------------------------------------------------------------------------------
;
BUTTON				equ	0080h		;button class
EDIT				equ	0081h		;edit class
STATIC				equ	0082h		;static class
LISTBOX				equ	0083h		;list box class
SCROLLBAR			equ	0084h		;scroll bar class
COMBOBOX			equ	0085h		;combo box class
;
;------------------------------------------------------------------------------
;
MAX_PATH			equ	 260		;max path length
MAXIMUM_FILENAME_LENGTH		equ	 256		;max file name length
OFS_MAXPATHNAME			equ	 128		;max OFSTRUCT path len
MIN_ALLOCATION			equ	4096		;min allocation size
;
LONG_DATE_LENGTH		equ	2+1+2+1+4+1	;long date string len
SHORT_DATE_LENGTH		equ	2+1+2+1+2+1	;short date string len
TIME_LENGTH			equ	2+1+2+1+2+1	;time string length
VERSION_NUMBER_LENGTH		equ	3+1+3+1		;version # string len
;
MAX_DECIMAL_8			equ	    3+1		;max 8-bit decimal len
MAX_DECIMAL_16			equ	    5+1		;max 16-bit decimal len
MAX_DECIMAL_32			equ	   10+1		;max 32-bit decimal len
MAX_HEX_8			equ	    2+1		;max 8-bit hex length
MAX_HEX_16			equ	    4+1		;max 16-bit hex length
MAX_HEX_32			equ	    8+1		;max 32-bit hex length
MAX_HEX_64			equ	   16+1		;max 64-bit hex length
;
IPVERSION			equ	    4		;ip version (rfc 792)
WSADESCRIPTION_LEN		equ	  256		;description length
WSASYS_STATUS_LEN		equ	  128		;system status length
WSAINPUTSIZE			equ	 8192		;input buffer size
WSAFTPCMDSIZE			equ	  128		;ftp command size
WSAMAXUSERNAME			equ	   64		;max user name length
WSAMAXPASSWORD			equ	   32		;max password length
WSAMAXFILENAME			equ	   64		;max file name length
WSAMAXHOSTNAME			equ	  255		;max host name length
WSAMAXADDRSTR			equ	   16		;max addr string length
WSAMAXGETHOSTSTRUCT		equ	 1024		;hostent buffer size
WSAMAXTTL			equ	  255		;max time to live
SOMINCONN			equ	    1		;min listen() queue
SOMAXCONN			equ	    5		;max listen() queue
FD_SETSIZE			equ	   64		;max number of sockets
UDP_MTU				equ	 1472		;max udp transmit units
TCP_MTU				equ	 1460		;max tcp transmit units
TCP_MSS				equ	  536		;max tcp segment size
;
NW_MAX_VOLUMES			equ	   64		;max number of volumes
NW_MAX_VOLUME_NAME_LEN		equ	   17		;max volume name length
NW_MAX_OBJECT_NAME_LEN		equ	   48		;max object name length
NW_MAX_USER_NAME_LEN		equ	   48		;max user name length
NW_MAX_PASSWORD_LEN		equ	  129		;max password length
NW_MAX_SERVER_NAME_LEN		equ	   48		;max server name length
NW_MAX_TREE_NAME_CHARS		equ	   32		;max tree name length
NW_MAX_TRAN_ADDR_LEN		equ	   30		;max transfer addr len
NW_MAX_SERVICE_TYPE_LEN		equ	   28		;max service type len
NW_MAX_WORKGROUP_NAME_LEN	equ	   16		;max workgroup name len
NW_MAX_PNW_USER_NAME_LEN	equ	   16		;max pnw user name len
NW_MAX_NET_ADDR_LEN		equ	  128		;max net address length
;
;------------------------------------------------------------------------------
;
INVALID_HANDLE_VALUE		equ	0FFFFFFFFh	;invalid handle
INVALID_FILE_SIZE		equ	0FFFFFFFFh	;invalid file size
INVALID_FILE_POINTER		equ	0FFFFFFFFh	;invalid file pointer
;
;==============================================================================
;
;	WIN32 CONSTANTS
;
;==============================================================================
;
; ===================
; ip address families
; ===================
;
AF_UNSPEC		equ	 0
AF_UNIX			equ	 1
AF_INET			equ	 2
AF_IMPLINK		equ	 3
AF_PUP			equ	 4
AF_CHAOS		equ	 5
AF_IPX			equ	 6
AF_NS			equ	 6
AF_ISO			equ	 7
AF_OSI			equ	 7
AF_ECMA			equ	 8
AF_DATAKIT		equ	 9
AF_CCITT		equ	10
AF_SNA			equ	11
AF_DECnet		equ	12
AF_DLI			equ	13
AF_LAT			equ	14
AF_HYLINK		equ	15
AF_APPLETALK		equ	16
AF_NETBIOS		equ	17
AF_VOICEVIEW		equ	18
AF_FIREFOX		equ	19
AF_UNKNOWN1		equ	20
AF_BAN			equ	21
;
AF_MAX			equ	22
;
;------------------------------------------------------------------------------
;
; =====================
; netware bindery flags
; =====================
;
BF_STATIC		equ	0
BF_DYNAMIC		equ	1
;
BF_ITEM			equ	0
BF_SET			equ	2
;
;------------------------------------------------------------------------------
;
; ========================
; bitmap compression types
; ========================
;
BI_RGB				equ	0
BI_RLE8				equ	1
BI_RLE4				equ	2
BI_BITFIELDS			equ	3
;
;------------------------------------------------------------------------------
;
; =======================
; button control messages
; =======================
;
BM_GETCHECK			equ	00F0h
BM_SETCHECK			equ	00F1h
BM_GETSTATE			equ	00F2h
BM_SETSTATE			equ	00F3h
BM_SETSTYLE			equ	00F4h
BM_CLICK			equ	00F5h
BM_GETIMAGE			equ	00F6h
BM_SETIMAGE			equ	00F7h
;
;------------------------------------------------------------------------------
;
; ============================
; button control notifications
; ============================
;
BN_CLICKED			equ	0000h
BN_PAINT			equ	0001h
BN_HILITE			equ	0002h
BN_UNHILITE			equ	0003h
BN_DISABLE			equ	0004h
BN_DOUBLECLICKED		equ	0005h
BN_SETFOCUS			equ	0006h
BN_KILLFOCUS			equ	0007h
;
BN_PUSHED			equ	BN_HILITE
BN_UNPUSHED			equ	BN_UNHILITE
BN_DBLCLK			equ	BN_DOUBLECLICKED
;
;------------------------------------------------------------------------------
;
; =====================
; button control styles
; =====================
;
BS_PUSHBUTTON			equ	0000h
BS_DEFPUSHBUTTON		equ	0001h
BS_CHECKBOX			equ	0002h
BS_AUTOCHECKBOX			equ	0003h
BS_RADIOBUTTON			equ	0004h
BS_3STATE			equ	0005h
BS_AUTO3STATE			equ	0006h
BS_GROUPBOX			equ	0007h
BS_USERBUTTON			equ	0008h
BS_AUTORADIOBUTTON		equ	0009h
BS_OWNERDRAW			equ	000Bh
BS_LEFTTEXT			equ	0020h
BS_TEXT				equ	0000h
BS_ICON				equ	0040h
BS_BITMAP			equ	0080h
BS_LEFT				equ	0100h
BS_RIGHT			equ	0200h
BS_CENTER			equ	0300h
BS_TOP				equ	0400h
BS_BOTTOM			equ	0800h
BS_VCENTER			equ	0C00h
BS_PUSHLIKE			equ	1000h
BS_MULTILINE			equ	2000h
BS_NOTIFY			equ	4000h
BS_FLAT				equ	8000h
;
BS_RIGHTBUTTON			equ	BS_LEFTTEXT
;
;------------------------------------------------------------------------------
;
; ========================
; netware bindery security
; ========================
;
BS_ANY_READ			equ	00h
BS_LOGGED_READ			equ	01h
BS_OBJECT_READ			equ	02h
BS_SUPER_READ			equ	03h
BS_BINDERY_READ			equ	04h
;
BS_ANY_WRITE			equ	00h
BS_LOGGED_WRITE			equ	10h
BS_OBJECT_WRITE			equ	20h
BS_SUPER_WRITE			equ	30h
BS_BINDERY_WRITE		equ	40h
;
;------------------------------------------------------------------------------
;
; =====================
; button control states
; =====================
;
BST_UNCHECKED			equ	0
BST_CHECKED			equ	1
BST_INDETERMINATE		equ	2
;
;------------------------------------------------------------------------------
;
; ==================
; combo box messages
; ==================
;
CB_GETEDITSEL			equ	0140h
CB_LIMITTEXT			equ	0141h
CB_SETEDITSEL			equ	0142h
CB_ADDSTRING			equ	0143h
CB_DELETESTRING			equ	0144h
CB_DIR				equ	0145h
CB_GETCOUNT			equ	0146h
CB_GETCURSEL			equ	0147h
CB_GETLBTEXT			equ	0148h
CB_GETLBTEXTLEN			equ	0149h
CB_INSERTSTRING			equ	014Ah
CB_RESETCONTENT			equ	014Bh
CB_FINDSTRING			equ	014Ch
CB_SELECTSTRING			equ	014Dh
CB_SETCURSEL			equ	014Eh
CB_SHOWDROPDOWN			equ	014Fh
CB_GETITEMDATA			equ	0150h
CB_SETITEMDATA			equ	0151h
CB_GETDROPPEDCONTROLRECT	equ	0152h
CB_SETITEMHEIGHT		equ	0153h
CB_GETITEMHEIGHT		equ	0154h
CB_SETEXTENDEDUI		equ	0155h
CB_GETEXTENDEDUI		equ	0156h
CB_GETDROPPEDSTATE		equ	0157h
CB_FINDSTRINGEXACT		equ	0158h
CB_SETLOCALE			equ	0159h
CB_GETLOCALE			equ	015Ah
CB_GETTOPINDEX			equ	015Bh
CB_SETTOPINDEX			equ	015Ch
CB_GETHORIZONTALEXTENT		equ	015Dh
CB_SETHORIZONTALEXTENT		equ	015Eh
CB_GETDROPPEDWIDTH		equ	015Fh
CB_SETDROPPEDWIDTH		equ	0160h
CB_INITSTORAGE			equ	0161h
CB_MSGMAX			equ	0162h
;
;------------------------------------------------------------------------------
;
; =======================
; combo box return values
; =======================
;
CB_OKAY				equ	 0
CB_ERR				equ	-1
CB_ERRSPACE			equ	-2
;
;------------------------------------------------------------------------------
;
; ======================
; CreateDIBitmap() codes
; ======================
;
CBM_INIT			equ	4
;
;------------------------------------------------------------------------------
;
; ============================
; combo box notification codes
; ============================
;
CBN_ERRSPACE			equ	-1
CBN_SELCHANGE			equ	 1
CBN_DBLCLK			equ	 2
CBN_SETFOCUS			equ	 3
CBN_KILLFOCUS			equ	 4
CBN_EDITCHANGE			equ	 5
CBN_EDITUPDATE			equ	 6
CBN_DROPDOWN			equ	 7
CBN_CLOSEUP			equ	 8
CBN_SELENDOK			equ	 9
CBN_SELENDCANCEL		equ	10
;
;------------------------------------------------------------------------------
;
; ================
; combo box styles
; ================
;
CBS_SIMPLE			equ	0001h
CBS_DROPDOWN			equ	0002h
CBS_DROPDOWNLIST		equ	0003h
CBS_OWNERDRAWFIXED		equ	0010h
CBS_OWNERDRAWVARIABLE		equ	0020h
CBS_AUTOHSCROLL			equ	0040h
CBS_OEMCONVERT			equ	0080h
CBS_SORT			equ	0100h
CBS_HASSTRINGS			equ	0200h
CBS_NOINTEGRALHEIGHT		equ	0400h
CBS_DISABLENOSCROLL		equ	0800h
CBS_UPPERCASE			equ	2000h
CBS_LOWERCASE			equ	4000h
;
;------------------------------------------------------------------------------
;
; =================
; clipboard formats
; =================
;
CF_TEXT				equ	0001h
CF_BITMAP			equ	0002h
CF_METAFILEPICT			equ	0003h
CF_SYLK				equ	0004h
CF_DIF				equ	0005h
CF_TIFF				equ	0006h
CF_OEMTEXT			equ	0007h
CF_DIB				equ	0008h
CF_PALETTE			equ	0009h
CF_PENDATA			equ	000Ah
CF_RIFF				equ	000Bh
CF_WAVE				equ	000Ch
CF_UNICODETEXT			equ	000Dh
CF_ENHMETAFILE			equ	000Eh
CF_HDROP			equ	000Fh
CF_LOCALE			equ	0010h
CF_MAX				equ	0011h
;
CF_OWNERDISPLAY			equ	0080h
CF_DSPTEXT			equ	0081h
CF_DSPBITMAP			equ	0082h
CF_DSPMETAFILEPICT		equ	0083h
CF_DSPENHMETAFILE		equ	008Eh
;
CF_PRIVATEFIRST			equ	0200h
CF_PRIVATELAST			equ	02FFh
;
CF_GDIOBJFIRST			equ	0300h
CF_GDIOBJLAST			equ	03FFh
;
;------------------------------------------------------------------------------
;
; ===========
; color types
; ===========
;
COLOR_SCROLLBAR			equ	 0
COLOR_BACKGROUND		equ	 1
COLOR_ACTIVECAPTION		equ	 2
COLOR_INACTIVECAPTION		equ	 3
COLOR_MENU			equ	 4
COLOR_WINDOW			equ	 5
COLOR_WINDOWFRAME		equ	 6
COLOR_MENUTEXT			equ	 7
COLOR_WINDOWTEXT		equ	 8
COLOR_CAPTIONTEXT		equ	 9
COLOR_ACTIVEBORDER		equ	10
COLOR_INACTIVEBORDER		equ	11
COLOR_APPWORKSPACE		equ	12
COLOR_HIGHLIGHT			equ	13
COLOR_HIGHLIGHTTEXT		equ	14
COLOR_BTNFACE			equ	15
COLOR_BTNSHADOW			equ	16
COLOR_GRAYTEXT			equ	17
COLOR_BTNTEXT			equ	18
COLOR_INACTIVECAPTIONTEXT	equ	19
COLOR_BTNHIGHLIGHT		equ	20
COLOR_3DDKSHADOW		equ	21
COLOR_3DLIGHT			equ	22
COLOR_INFOTEXT			equ	23
COLOR_INFOBK			equ	24
;
COLOR_DESKTOP			equ	COLOR_BACKGROUND
COLOR_3DFACE			equ	COLOR_BTNFACE
COLOR_3DSHADOW			equ	COLOR_BTNSHADOW
COLOR_3DHIGHLIGHT		equ	COLOR_BTNHIGHLIGHT
COLOR_3DHILIGHT			equ	COLOR_BTNHIGHLIGHT
COLOR_BTNHILIGHT		equ	COLOR_BTNHIGHLIGHT
;
;------------------------------------------------------------------------------
;
; ===================
; network connections
; ===================
;
CONNECT_UPDATE_PROFILE		equ	00000001h
CONNECT_UPDATE_RECENT		equ	00000002h
CONNECT_TEMPORARY		equ	00000004h
CONNECT_INTERACTIVE		equ	00000008h
CONNECT_PROMPT			equ	00000010h
CONNECT_NEED_DRIVE		equ	00000020h
CONNECT_REFCOUNT		equ	00000040h
CONNECT_REDIRECT		equ	00000080h
CONNECT_LOCALDRIVE		equ	00000100h
CONNECT_CURRENT_MEDIA		equ	00000200h
;
NETPROPERTY_PERSISTENT		equ	1
;
;------------------------------------------------------------------------------
;
; ====================
; thread context flags
; ====================
;
CONTEXT_i386			equ	00010000h
CONTEXT_i486			equ	00010000h
;
CONTEXT_CONTROL			equ	CONTEXT_i386+00000001h
CONTEXT_INTEGER			equ	CONTEXT_i386+00000002h
CONTEXT_SEGMENTS		equ	CONTEXT_i386+00000004h
CONTEXT_FLOATING_POINT		equ	CONTEXT_i386+00000008h
CONTEXT_DEBUG_REGISTERS		equ	CONTEXT_i386+00000010h
;
CONTEXT_FULL			equ	CONTEXT_CONTROL+\
					CONTEXT_INTEGER+\
					CONTEXT_SEGMENTS
;
SIZE_OF_80387_REGISTERS		equ	80
;
;------------------------------------------------------------------------------
;
; ==========
; code pages
; ==========
;
CP_ACP				equ	0
CP_OEMCP			equ	1
CP_MACCP			equ	2
;
;------------------------------------------------------------------------------
;
; ============
; class styles
; ============
;
CS_VREDRAW			equ	00000001h
CS_HREDRAW			equ	00000002h
CS_KEYCVTWINDOW			equ	00000004h
CS_DBLCLKS			equ	00000008h
CS_OWNDC			equ	00000020h
CS_CLASSDC			equ	00000040h
CS_PARENTDC			equ	00000080h
CS_NOKEYCVT			equ	00000100h
CS_NOCLOSE			equ	00000200h
CS_SAVEBITS			equ	00000800h
CS_BYTEALIGNCLIENT		equ	00001000h
CS_BYTEALIGNWINDOW		equ	00002000h
CS_GLOBALCLASS			equ	00004000h
CS_IME				equ	00010000h
;
;------------------------------------------------------------------------------
;
; ===================
; control color types
; ===================
;
CTLCOLOR_MSGBOX			equ	0
CTLCOLOR_EDIT			equ	1
CTLCOLOR_LISTBOX		equ	2
CTLCOLOR_BTN			equ	3
CTLCOLOR_DLG			equ	4
CTLCOLOR_SCROLLBAR		equ	5
CTLCOLOR_STATIC			equ	6
CTLCOLOR_MAX			equ	7
;
;------------------------------------------------------------------------------
;
; =======================
; CreateWindow() commands
; =======================
;
CW_USEDEFAULT			equ	80000000h
;
;------------------------------------------------------------------------------
;
; ===================
; device capabilities
; ===================
;
DC_FIELDS			equ	 1
DC_PAPERS			equ	 2
DC_PAPERSIZE			equ	 3
DC_MINEXTENT			equ	 4
DC_MAXEXTENT			equ	 5
DC_BINS				equ	 6
DC_DUPLEX			equ	 7
DC_SIZE				equ	 8
DC_EXTRA			equ	 9
DC_VERSION			equ	10
DC_DRIVER			equ	11
DC_BINNAMES			equ	12
DC_ENUMRESOLUTIONS		equ	13
DC_FILEDEPENDENCIES		equ	14
DC_TRUETYPE			equ	15
DC_PAPERNAMES			equ	16
DC_ORIENTATION			equ	17
DC_COPIES			equ	18
;
;------------------------------------------------------------------------------
;
; ====================
; dib color table id's
; ====================
;
DIB_RGB_COLORS			equ	0
DIB_PAL_COLORS			equ	1
;
;------------------------------------------------------------------------------
;
; ====================
; DLL LibMain() events
; ====================
;
DLL_PROCESS_DETACH		equ	0
DLL_PROCESS_ATTACH		equ	1
DLL_THREAD_ATTACH		equ	2
DLL_THREAD_DETACH		equ	3
;
;------------------------------------------------------------------------------
;
; ======================
; device mode selections
; ======================
;
DM_UPDATE			equ	1
DM_COPY				equ	2
DM_PROMPT			equ	4
DM_MODIFY			equ	8
;
DM_IN_BUFFER			equ	DM_MODIFY
DM_IN_PROMPT			equ	DM_PROMPT
DM_OUT_BUFFER			equ	DM_COPY
DM_OUT_DEFAULT			equ	DM_UPDATE
;
;------------------------------------------------------------------------------
;
; =============
; dialog styles
; =============
;
DS_ABSALIGN			equ	0001h
DS_SYSMODAL			equ	0002h
DS_3DLOOK			equ	0004h
DS_FIXEDSYS			equ	0008h
DS_NOFAILCREATE			equ	0010h
DS_LOCALEDIT			equ	0020h	;edit items get local storage
DS_SETFONT			equ	0040h	;user specified font
DS_MODALFRAME			equ	0080h	;combinable with WS_CAPTION
DS_NOIDLEMSG			equ	0100h	;don't send WM_ENTERIDLE
DS_SETFOREGROUND		equ	0200h
DS_CONTROL			equ	0400h
DS_CENTER			equ	0800h
DS_CENTERMOUSE			equ	1000h
DS_CONTEXTHELP			equ	2000h
;
DS_MODAL			equ	DS_ABSALIGN+DS_MODALFRAME
DS_MODELESS			equ	DS_ABSALIGN
;
;------------------------------------------------------------------------------
;
; =======================
; DrawText() format flags
; =======================
;
DT_TOP				equ	00000000h
DT_LEFT				equ	00000000h
DT_CENTER			equ	00000001h
DT_RIGHT			equ	00000002h
DT_VCENTER			equ	00000004h
DT_BOTTOM			equ	00000008h
DT_WORDBREAK			equ	00000010h
DT_SINGLELINE			equ	00000020h
DT_EXPANDTABS			equ	00000040h
DT_TABSTOP			equ	00000080h
DT_NOCLIP			equ	00000100h
DT_EXTERNALLEADING		equ	00000200h
DT_CALCRECT			equ	00000400h
DT_NOPREFIX			equ	00000800h
DT_INTERNAL			equ	00001000h
DT_EDITCONTROL			equ	00002000h
DT_PATH_ELLIPSIS		equ	00004000h
DT_END_ELLIPSIS			equ	00008000h
DT_MODIFYSTRING			equ	00010000h
DT_RTLREADING			equ	00020000h
DT_WORD_ELLIPSIS		equ	00040000h
;
;------------------------------------------------------------------------------
;
; =====================
; edit control messages
; =====================
;
EM_GETSEL			equ	00B0h
EM_SETSEL			equ	00B1h
EM_GETRECT			equ	00B2h
EM_SETRECT			equ	00B3h
EM_SETRECTNP			equ	00B4h
EM_SCROLL			equ	00B5h
EM_LINESCROLL			equ	00B6h
EM_SCROLLCARET			equ	00B7h
EM_GETMODIFY			equ	00B8h
EM_SETMODIFY			equ	00B9h
EM_GETLINECOUNT			equ	00BAh
EM_LINEINDEX			equ	00BBh
EM_SETHANDLE			equ	00BCh
EM_GETHANDLE			equ	00BDh
EM_GETTHUMB			equ	00BEh
EM_LINELENGTH			equ	00C1h
EM_REPLACESEL			equ	00C2h
EM_GETLINE			equ	00C4h
EM_LIMITTEXT			equ	00C5h
EM_CANUNDO			equ	00C6h
EM_UNDO				equ	00C7h
EM_FMTLINES			equ	00C8h
EM_LINEFROMCHAR			equ	00C9h
EM_SETTABSTOPS			equ	00CBh
EM_SETPASSWORDCHAR		equ	00CCh
EM_EMPTYUNDOBUFFER		equ	00CDh
EM_GETFIRSTVISIBLELINE		equ	00CEh
EM_SETREADONLY			equ	00CFh
EM_SETWORDBREAKPROC		equ	00D0h
EM_GETWORDBREAKPROC		equ	00D1h
EM_GETPASSWORDCHAR		equ	00D2h
EM_SETMARGINS			equ	00D3h
EM_GETMARGINS			equ	00D4h
EM_GETLIMITTEXT			equ	00D5h
EM_POSFROMCHAR			equ	00D6h
EM_CHARFROMPOS			equ	00D7h
;
EM_SETLIMITTEXT			equ	EM_LIMITTEXT
;
;------------------------------------------------------------------------------
;
; ==========================
; edit control notifications
; ==========================
;
EN_SETFOCUS			equ	0100h
EN_KILLFOCUS			equ	0200h
EN_CHANGE			equ	0300h
EN_UPDATE			equ	0400h
EN_ERRSPACE			equ	0500h
EN_MAXTEXT			equ	0501h
EN_HSCROLL			equ	0601h
EN_VSCROLL			equ	0602h
;
;------------------------------------------------------------------------------
;
; ===========
; error codes
; ===========
;
ERROR_SUCCESS				equ	   0
NO_ERROR				equ	   0
;
ERROR_INVALID_FUNCTION			equ	   1
ERROR_FILE_NOT_FOUND			equ	   2
ERROR_PATH_NOT_FOUND			equ	   3
ERROR_TOO_MANY_OPEN_FILES		equ	   4
ERROR_ACCESS_DENIED			equ	   5
ERROR_INVALID_HANDLE			equ	   6
ERROR_ARENA_TRASHED			equ	   7
ERROR_NOT_ENOUGH_MEMORY			equ	   8
ERROR_INVALID_BLOCK			equ	   9
ERROR_BAD_ENVIRONMENT			equ	  10
ERROR_BAD_FORMAT			equ	  11
ERROR_INVALID_ACCESS			equ	  12
ERROR_INVALID_DATA			equ	  13
ERROR_OUTOFMEMORY			equ	  14
ERROR_INVALID_DRIVE			equ	  15
ERROR_CURRENT_DIRECTORY			equ	  16
ERROR_NOT_SAME_DEVICE			equ	  17
ERROR_NO_MORE_FILES			equ	  18
ERROR_WRITE_PROTECT			equ	  19
ERROR_BAD_UNIT				equ	  20
ERROR_NOT_READY				equ	  21
ERROR_BAD_COMMAND			equ	  22
ERROR_CRC				equ	  23
ERROR_BAD_LENGTH			equ	  24
ERROR_SEEK				equ	  25
ERROR_NOT_DOS_DISK			equ	  26
ERROR_SECTOR_NOT_FOUND			equ	  27
ERROR_OUT_OF_PAPER			equ	  28
ERROR_WRITE_FAULT			equ	  29
ERROR_READ_FAULT			equ	  30
ERROR_GEN_FAILURE			equ	  31
ERROR_SHARING_VIOLATION			equ	  32
ERROR_LOCK_VIOLATION			equ	  33
ERROR_WRONG_DISK			equ	  34
ERROR_SHARING_BUFFER_EXCEEDED		equ	  36
ERROR_HANDLE_EOF			equ	  38
ERROR_HANDLE_DISK_FULL			equ	  39
ERROR_NOT_SUPPORTED			equ	  50
ERROR_REM_NOT_LIST			equ	  51
ERROR_DUP_NAME				equ	  52
ERROR_BAD_NETPATH			equ	  53
ERROR_NETWORK_BUSY			equ	  54
ERROR_DEV_NOT_EXIST			equ	  55
ERROR_TOO_MANY_CMDS			equ	  56
ERROR_ADAP_HDW_ERR			equ	  57
ERROR_BAD_NET_RESP			equ	  58
ERROR_UNEXP_NET_ERR			equ	  59
ERROR_BAD_REM_ADAP			equ	  60
ERROR_PRINTQ_FULL			equ	  61
ERROR_NO_SPOOL_SPACE			equ	  62
ERROR_PRINT_CANCELLED			equ	  63
ERROR_NETNAME_DELETED			equ	  64
ERROR_NETWORK_ACCESS_DENIED		equ	  65
ERROR_BAD_DEV_TYPE			equ	  66
ERROR_BAD_NET_NAME			equ	  67
ERROR_TOO_MANY_NAMES			equ	  68
ERROR_TOO_MANY_SESS			equ	  69
ERROR_SHARING_PAUSED			equ	  70
ERROR_REQ_NOT_ACCEP			equ	  71
ERROR_REDIR_PAUSED			equ	  72
ERROR_FILE_EXISTS			equ	  80
ERROR_CANNOT_MAKE			equ	  82
ERROR_FAIL_I24				equ	  83
ERROR_OUT_OF_STRUCTURES			equ	  84
ERROR_ALREADY_ASSIGNED			equ	  85
ERROR_INVALID_PASSWORD			equ	  86
ERROR_INVALID_PARAMETER			equ	  87
ERROR_NET_WRITE_FAULT			equ	  88
ERROR_NO_PROC_SLOTS			equ	  89
ERROR_TOO_MANY_SEMAPHORES		equ	 100
ERROR_EXCL_SEM_ALREADY_OWNED		equ	 101
ERROR_SEM_IS_SET			equ	 102
ERROR_TOO_MANY_SEM_REQUESTS		equ	 103
ERROR_INVALID_AT_INTERRUPT_TIME		equ	 104
ERROR_SEM_OWNER_DIED			equ	 105
ERROR_SEM_USER_LIMIT			equ	 106
ERROR_DISK_CHANGE			equ	 107
ERROR_DRIVE_LOCKED			equ	 108
ERROR_BROKEN_PIPE			equ	 109
ERROR_OPEN_FAILED			equ	 110
ERROR_BUFFER_OVERFLOW			equ	 111
ERROR_DISK_FULL				equ	 112
ERROR_NO_MORE_SEARCH_HANDLES		equ	 113
ERROR_INVALID_TARGET_HANDLE		equ	 114
ERROR_INVALID_CATEGORY			equ	 117
ERROR_INVALID_VERIFY_SWITCH		equ	 118
ERROR_BAD_DRIVER_LEVEL			equ	 119
ERROR_CALL_NOT_IMPLEMENTED		equ	 120
ERROR_SEM_TIMEOUT			equ	 121
ERROR_INSUFFICIENT_BUFFER		equ	 122
ERROR_INVALID_NAME			equ	 123
ERROR_INVALID_LEVEL			equ	 124
ERROR_NO_VOLUME_LABEL			equ	 125
ERROR_MOD_NOT_FOUND			equ	 126
ERROR_PROC_NOT_FOUND			equ	 127
ERROR_WAIT_NO_CHILDREN			equ	 128
ERROR_CHILD_NOT_COMPLETE		equ	 129
ERROR_DIRECT_ACCESS_HANDLE		equ	 130
ERROR_NEGATIVE_SEEK			equ	 131
ERROR_SEEK_ON_DEVICE			equ	 132
ERROR_IS_JOIN_TARGET			equ	 133
ERROR_IS_JOINED				equ	 134
ERROR_IS_SUBSTED			equ	 135
ERROR_NOT_JOINED			equ	 136
ERROR_NOT_SUBSTED			equ	 137
ERROR_JOIN_TO_JOIN			equ	 138
ERROR_SUBST_TO_SUBST			equ	 139
ERROR_JOIN_TO_SUBST			equ	 140
ERROR_SUBST_TO_JOIN			equ	 141
ERROR_BUSY_DRIVE			equ	 142
ERROR_SAME_DRIVE			equ	 143
ERROR_DIR_NOT_ROOT			equ	 144
ERROR_DIR_NOT_EMPTY			equ	 145
ERROR_IS_SUBST_PATH			equ	 146
ERROR_IS_JOIN_PATH			equ	 147
ERROR_PATH_BUSY				equ	 148
ERROR_IS_SUBST_TARGET			equ	 149
ERROR_SYSTEM_TRACE			equ	 150
ERROR_INVALID_EVENT_COUNT		equ	 151
ERROR_TOO_MANY_MUXWAITERS		equ	 152
ERROR_INVALID_LIST_FORMAT		equ	 153
ERROR_LABEL_TOO_LONG			equ	 154
ERROR_TOO_MANY_TCBS			equ	 155
ERROR_SIGNAL_REFUSED			equ	 156
ERROR_DISCARDED				equ	 157
ERROR_NOT_LOCKED			equ	 158
ERROR_BAD_THREADID_ADDR			equ	 159
ERROR_BAD_ARGUMENTS			equ	 160
ERROR_BAD_PATHNAME			equ	 161
ERROR_SIGNAL_PENDING			equ	 162
ERROR_MAX_THRDS_REACHED			equ	 164
ERROR_LOCK_FAILED			equ	 167
ERROR_BUSY				equ	 170
ERROR_CANCEL_VIOLATION			equ	 173
ERROR_ATOMIC_LOCKS_NOT_SUPPORTED	equ	 174
ERROR_INVALID_SEGMENT_NUMBER		equ	 180
ERROR_INVALID_ORDINAL			equ	 182
ERROR_ALREADY_EXISTS			equ	 183
ERROR_INVALID_FLAG_NUMBER		equ	 186
ERROR_SEM_NOT_FOUND			equ	 187
ERROR_INVALID_STARTING_CODESEG		equ	 188
ERROR_INVALID_STACKSEG			equ	 189
ERROR_INVALID_MODULETYPE		equ	 190
ERROR_INVALID_EXE_SIGNATURE		equ	 191
ERROR_EXE_MARKED_INVALID		equ	 192
ERROR_BAD_EXE_FORMAT			equ	 193
ERROR_ITERATED_DATA_EXCEEDS_64k		equ	 194
ERROR_INVALID_MINALLOCSIZE		equ	 195
ERROR_DYNLINK_FROM_INVALID_RING		equ	 196
ERROR_IOPL_NOT_ENABLED			equ	 197
ERROR_INVALID_SEGDPL			equ	 198
ERROR_AUTODATASEG_EXCEEDS_64k		equ	 199
ERROR_RING2SEG_MUST_BE_MOVABLE		equ	 200
ERROR_RELOC_CHAIN_XEEDS_SEGLIM		equ	 201
ERROR_INFLOOP_IN_RELOC_CHAIN		equ	 202
ERROR_ENVVAR_NOT_FOUND			equ	 203
ERROR_NO_SIGNAL_SENT			equ	 205
ERROR_FILENAME_EXCED_RANGE		equ	 206
ERROR_RING2_STACK_IN_USE		equ	 207
ERROR_META_EXPANSION_TOO_LONG		equ	 208
ERROR_INVALID_SIGNAL_NUMBER		equ	 209
ERROR_THREAD_1_INACTIVE			equ	 210
ERROR_LOCKED				equ	 212
ERROR_TOO_MANY_MODULES			equ	 214
ERROR_NESTING_NOT_ALLOWED		equ	 215
ERROR_BAD_PIPE				equ	 230
ERROR_PIPE_BUSY				equ	 231
ERROR_NO_DATA				equ	 232
ERROR_PIPE_NOT_CONNECTED		equ	 233
ERROR_MORE_DATA				equ	 234
ERROR_VC_DISCONNECTED			equ	 240
ERROR_INVALID_EA_NAME			equ	 254
ERROR_EA_LIST_INCONSISTENT		equ	 255
ERROR_NO_MORE_ITEMS			equ	 259
ERROR_CANNOT_COPY			equ	 266
ERROR_DIRECTORY				equ	 267
ERROR_EAS_DIDNT_FIT			equ	 275
ERROR_EA_FILE_CORRUPT			equ	 276
ERROR_EA_TABLE_FULL			equ	 277
ERROR_INVALID_EA_HANDLE			equ	 278
ERROR_EAS_NOT_SUPPORTED			equ	 282
ERROR_NOT_OWNER				equ	 288
ERROR_TOO_MANY_POSTS			equ	 298
ERROR_PARTIAL_COPY			equ	 299
ERROR_MR_MID_NOT_FOUND			equ	 317
ERROR_INVALID_ADDRESS			equ	 487
ERROR_ARITHMETIC_OVERFLOW		equ	 534
ERROR_PIPE_CONNECTED			equ	 535
ERROR_PIPE_LISTENING			equ	 536
ERROR_EA_ACCESS_DENIED			equ	 994
ERROR_OPERATION_ABORTED			equ	 995
ERROR_IO_INCOMPLETE			equ	 996
ERROR_IO_PENDING			equ	 997
ERROR_NOACCESS				equ	 998
ERROR_SWAPERROR				equ	 999
ERROR_STACK_OVERFLOW			equ	1001
ERROR_INVALID_MESSAGE			equ	1002
ERROR_CAN_NOT_COMPLETE			equ	1003
ERROR_INVALID_FLAGS			equ	1004
ERROR_UNRECOGNIZED_VOLUME		equ	1005
ERROR_FILE_INVALID			equ	1006
ERROR_FULLSCREEN_MODE			equ	1007
ERROR_NO_TOKEN				equ	1008
ERROR_BADDB				equ	1009
ERROR_BADKEY				equ	1010
ERROR_CANTOPEN				equ	1011
ERROR_CANTREAD				equ	1012
ERROR_CANTWRITE				equ	1013
ERROR_REGISTRY_RECOVERED		equ	1014
ERROR_REGISTRY_CORRUPT			equ	1015
ERROR_REGISTRY_IO_FAILED		equ	1016
ERROR_NOT_REGISTRY_FILE			equ	1017
ERROR_KEY_DELETED			equ	1018
ERROR_NO_LOG_SPACE			equ	1019
ERROR_KEY_HAS_CHILDREN			equ	1020
ERROR_CHILD_MUST_BE_VOLATILE		equ	1021
ERROR_NOTIFY_ENUM_DIR			equ	1022
ERROR_DEPENDENT_SERVICES_RUNNING	equ	1051
ERROR_INVALID_SERVICE_CONTROL		equ	1052
ERROR_SERVICE_REQUEST_TIMEOUT		equ	1053
ERROR_SERVICE_NO_THREAD			equ	1054
ERROR_SERVICE_DATABASE_LOCKED		equ	1055
ERROR_SERVICE_ALREADY_RUNNING		equ	1056
ERROR_INVALID_SERVICE_ACCOUNT		equ	1057
ERROR_SERVICE_DISABLED			equ	1058
ERROR_CIRCULAR_DEPENDENCY		equ	1059
ERROR_SERVICE_DOES_NOT_EXIST		equ	1060
ERROR_SERVICE_CANNOT_ACCEPT_CTRL	equ	1061
ERROR_SERVICE_NOT_ACTIVE		equ	1062
ERROR_FAILED_SERVICE_CONTROLLER_CONNECT	equ	1063
ERROR_EXCEPTION_IN_SERVICE		equ	1064
ERROR_DATABASE_DOES_NOT_EXIST		equ	1065
ERROR_SERVICE_SPECIFIC_ERROR		equ	1066
ERROR_PROCESS_ABORTED			equ	1067
ERROR_SERVICE_DEPENDENCY_FAIL		equ	1068
ERROR_SERVICE_LOGON_FAILED		equ	1069
ERROR_SERVICE_START_HANG		equ	1070
ERROR_INVALID_SERVICE_LOCK		equ	1071
ERROR_SERVICE_MARKED_FOR_DELETE		equ	1072
ERROR_SERVICE_EXISTS			equ	1073
ERROR_ALREADY_RUNNING_LKG		equ	1074
ERROR_SERVICE_DEPENDENCY_DELETED	equ	1075
ERROR_BOOT_ALREADY_ACCEPTED		equ	1076
ERROR_SERVICE_NEVER_STARTED		equ	1077
ERROR_DUPLICATE_SERVICE_NAME		equ	1078
ERROR_END_OF_MEDIA			equ	1100
ERROR_FILEMARK_DETECTED			equ	1101
ERROR_BEGINNING_OF_MEDIA		equ	1102
ERROR_SETMARK_DETECTED			equ	1103
ERROR_NO_DATA_DETECTED			equ	1104
ERROR_PARTITION_FAILURE			equ	1105
ERROR_INVALID_BLOCK_LENGTH		equ	1106
ERROR_DEVICE_NOT_PARTITIONED		equ	1107
ERROR_UNABLE_TO_LOCK_MEDIA		equ	1108
ERROR_UNABLE_TO_UNLOAD_MEDIA		equ	1109
ERROR_MEDIA_CHANGED			equ	1110
ERROR_BUS_RESET				equ	1111
ERROR_NO_MEDIA_IN_DRIVE			equ	1112
ERROR_NO_UNICODE_TRANSLATION		equ	1113
ERROR_DLL_INIT_FAILED			equ	1114
ERROR_SHUTDOWN_IN_PROGRESS		equ	1115
ERROR_NO_SHUTDOWN_IN_PROGRESS		equ	1116
ERROR_IO_DEVICE				equ	1117
ERROR_SERIAL_NO_DEVICE			equ	1118
ERROR_IRQ_BUSY				equ	1119
ERROR_MORE_WRITES			equ	1120
ERROR_COUNTER_TIMEOUT			equ	1121
ERROR_FLOPPY_ID_MARK_NOT_FOUND		equ	1122
ERROR_FLOPPY_WRONG_CYLINDER		equ	1123
ERROR_FLOPPY_UNKNOWN_ERROR		equ	1124
ERROR_FLOPPY_BAD_REGISTERS		equ	1125
ERROR_DISK_RECALIBRATE_FAILED		equ	1126
ERROR_DISK_OPERATION_FAILED		equ	1127
ERROR_DISK_RESET_FAILED			equ	1128
ERROR_EOM_OVERFLOW			equ	1129
ERROR_NOT_ENOUGH_SERVER_MEMORY		equ	1130
ERROR_POSSIBLE_DEADLOCK			equ	1131
ERROR_MAPPED_ALIGNMENT			equ	1132
ERROR_SET_POWER_STATE_VETOED		equ	1140
ERROR_SET_POWER_STATE_FAILED		equ	1141
ERROR_OLD_WIN_VERSION			equ	1150
ERROR_APP_WRONG_OS			equ	1151
ERROR_SINGLE_INSTANCE_APP		equ	1152
ERROR_RMODE_APP				equ	1153
ERROR_INVALID_DLL			equ	1154
ERROR_NO_ASSOCIATION			equ	1155
ERROR_DDE_FAIL				equ	1156
ERROR_DLL_NOT_FOUND			equ	1157
ERROR_BAD_USERNAME			equ	2202
ERROR_NOT_CONNECTED			equ	2250
ERROR_OPEN_FILES			equ	2401
ERROR_ACTIVE_CONNECTIONS		equ	2402
ERROR_DEVICE_IN_USE			equ	2404
ERROR_BAD_DEVICE			equ	1200
ERROR_CONNECTION_UNAVAIL		equ	1201
ERROR_DEVICE_ALREADY_REMEMBERED		equ	1202
ERROR_NO_NET_OR_BAD_PATH		equ	1203
ERROR_BAD_PROVIDER			equ	1204
ERROR_CANNOT_OPEN_PROFILE		equ	1205
ERROR_BAD_PROFILE			equ	1206
ERROR_NOT_CONTAINER			equ	1207
ERROR_EXTENDED_ERROR			equ	1208
ERROR_INVALID_GROUPNAME			equ	1209
ERROR_INVALID_COMPUTERNAME		equ	1210
ERROR_INVALID_EVENTNAME			equ	1211
ERROR_INVALID_DOMAINNAME		equ	1212
ERROR_INVALID_SERVICENAME		equ	1213
ERROR_INVALID_NETNAME			equ	1214
ERROR_INVALID_SHARENAME			equ	1215
ERROR_INVALID_PASSWORDNAME		equ	1216
ERROR_INVALID_MESSAGENAME		equ	1217
ERROR_INVALID_MESSAGEDEST		equ	1218
ERROR_SESSION_CREDENTIAL_CONFLICT	equ	1219
ERROR_REMOTE_SESSION_LIMIT_EXCEEDED	equ	1220
ERROR_DUP_DOMAINNAME			equ	1221
ERROR_NO_NETWORK			equ	1222
ERROR_CANCELLED				equ	1223
ERROR_USER_MAPPED_FILE			equ	1224
ERROR_CONNECTION_REFUSED		equ	1225
ERROR_GRACEFUL_DISCONNECT		equ	1226
ERROR_ADDRESS_ALREADY_ASSOCIATED	equ	1227
ERROR_ADDRESS_NOT_ASSOCIATED		equ	1228
ERROR_CONNECTION_INVALID		equ	1229
ERROR_CONNECTION_ACTIVE			equ	1230
ERROR_NETWORK_UNREACHABLE		equ	1231
ERROR_HOST_UNREACHABLE			equ	1232
ERROR_PROTOCOL_UNREACHABLE		equ	1233
ERROR_PORT_UNREACHABLE			equ	1234
ERROR_REQUEST_ABORTED			equ	1235
ERROR_CONNECTION_ABORTED		equ	1236
ERROR_RETRY				equ	1237
ERROR_CONNECTION_COUNT_LIMIT		equ	1238
ERROR_LOGIN_TIME_RESTRICTION		equ	1239
ERROR_LOGIN_WKSTA_RESTRICTION		equ	1240
ERROR_INCORRECT_ADDRESS			equ	1241
ERROR_ALREADY_REGISTERED		equ	1242
ERROR_SERVICE_NOT_FOUND			equ	1243
ERROR_NOT_AUTHENTICATED			equ	1244
ERROR_NOT_LOGGED_ON			equ	1245
ERROR_CONTINUE				equ	1246
ERROR_ALREADY_INITIALIZED		equ	1247
ERROR_NO_MORE_DEVICES			equ	1248
ERROR_NOT_ALL_ASSIGNED			equ	1300
ERROR_SOME_NOT_MAPPED			equ	1301
ERROR_NO_QUOTAS_FOR_ACCOUNT		equ	1302
ERROR_LOCAL_USER_SESSION_KEY		equ	1303
ERROR_NULL_LM_PASSWORD			equ	1304
ERROR_UNKNOWN_REVISION			equ	1305
ERROR_REVISION_MISMATCH			equ	1306
ERROR_INVALID_OWNER			equ	1307
ERROR_INVALID_PRIMARY_GROUP		equ	1308
ERROR_NO_IMPERSONATION_TOKEN		equ	1309
ERROR_CANT_DISABLE_MANDATORY		equ	1310
ERROR_NO_LOGON_SERVERS			equ	1311
ERROR_NO_SUCH_LOGON_SESSION		equ	1312
ERROR_NO_SUCH_PRIVILEGE			equ	1313
ERROR_PRIVILEGE_NOT_HELD		equ	1314
ERROR_INVALID_ACCOUNT_NAME		equ	1315
ERROR_USER_EXISTS			equ	1316
ERROR_NO_SUCH_USER			equ	1317
ERROR_GROUP_EXISTS			equ	1318
ERROR_NO_SUCH_GROUP			equ	1319
ERROR_MEMBER_IN_GROUP			equ	1320
ERROR_MEMBER_NOT_IN_GROUP		equ	1321
ERROR_LAST_ADMIN			equ	1322
ERROR_WRONG_PASSWORD			equ	1323
ERROR_ILL_FORMED_PASSWORD		equ	1324
ERROR_PASSWORD_RESTRICTION		equ	1325
ERROR_LOGON_FAILURE			equ	1326
ERROR_ACCOUNT_RESTRICTION		equ	1327
ERROR_INVALID_LOGON_HOURS		equ	1328
ERROR_INVALID_WORKSTATION		equ	1329
ERROR_PASSWORD_EXPIRED			equ	1330
ERROR_ACCOUNT_DISABLED			equ	1331
ERROR_NONE_MAPPED			equ	1332
ERROR_TOO_MANY_LUIDS_REQUESTED		equ	1333
ERROR_LUIDS_EXHAUSTED			equ	1334
ERROR_INVALID_SUB_AUTHORITY		equ	1335
ERROR_INVALID_ACL			equ	1336
ERROR_INVALID_SID			equ	1337
ERROR_INVALID_SECURITY_DESCR		equ	1338
ERROR_BAD_INHERITANCE_ACL		equ	1340
ERROR_SERVER_DISABLED			equ	1341
ERROR_SERVER_NOT_DISABLED		equ	1342
ERROR_INVALID_ID_AUTHORITY		equ	1343
ERROR_ALLOTTED_SPACE_EXCEEDED		equ	1344
ERROR_INVALID_GROUP_ATTRIBUTES		equ	1345
ERROR_BAD_IMPERSONATION_LEVEL		equ	1346
ERROR_CANT_OPEN_ANONYMOUS		equ	1347
ERROR_BAD_VALIDATION_CLASS		equ	1348
ERROR_BAD_TOKEN_TYPE			equ	1349
ERROR_NO_SECURITY_ON_OBJECT		equ	1350
ERROR_CANT_ACCESS_DOMAIN_INFO		equ	1351
ERROR_INVALID_SERVER_STATE		equ	1352
ERROR_INVALID_DOMAIN_STATE		equ	1353
ERROR_INVALID_DOMAIN_ROLE		equ	1354
ERROR_NO_SUCH_DOMAIN			equ	1355
ERROR_DOMAIN_EXISTS			equ	1356
ERROR_DOMAIN_LIMIT_EXCEEDED		equ	1357
ERROR_INTERNAL_DB_CORRUPTION		equ	1358
ERROR_INTERNAL_ERROR			equ	1359
ERROR_GENERIC_NOT_MAPPED		equ	1360
ERROR_BAD_DESCRIPTOR_FORMAT		equ	1361
ERROR_NOT_LOGON_PROCESS			equ	1362
ERROR_LOGON_SESSION_EXISTS		equ	1363
ERROR_NO_SUCH_PACKAGE			equ	1364
ERROR_BAD_LOGON_SESSION_STATE		equ	1365
ERROR_LOGON_SESSION_COLLISION		equ	1366
ERROR_INVALID_LOGON_TYPE		equ	1367
ERROR_CANNOT_IMPERSONATE		equ	1368
ERROR_RXACT_INVALID_STATE		equ	1369
ERROR_RXACT_COMMIT_FAILURE		equ	1370
ERROR_SPECIAL_ACCOUNT			equ	1371
ERROR_SPECIAL_GROUP			equ	1372
ERROR_SPECIAL_USER			equ	1373
ERROR_MEMBERS_PRIMARY_GROUP		equ	1374
ERROR_TOKEN_ALREADY_IN_USE		equ	1375
ERROR_NO_SUCH_ALIAS			equ	1376
ERROR_MEMBER_NOT_IN_ALIAS		equ	1377
ERROR_MEMBER_IN_ALIAS			equ	1378
ERROR_ALIAS_EXISTS			equ	1379
ERROR_LOGON_NOT_GRANTED			equ	1380
ERROR_TOO_MANY_SECRETS			equ	1381
ERROR_SECRET_TOO_LONG			equ	1382
ERROR_INTERNAL_DB_ERROR			equ	1383
ERROR_TOO_MANY_CONTEXT_IDS		equ	1384
ERROR_LOGON_TYPE_NOT_GRANTED		equ	1385
ERROR_NT_CROSS_ENCRYPTION_REQUIRED	equ	1386
ERROR_NO_SUCH_MEMBER			equ	1387
ERROR_INVALID_MEMBER			equ	1388
ERROR_TOO_MANY_SIDS			equ	1389
ERROR_LM_CROSS_ENCRYPTION_REQUIRED	equ	1390
ERROR_NO_INHERITANCE			equ	1391
ERROR_FILE_CORRUPT			equ	1392
ERROR_DISK_CORRUPT			equ	1393
ERROR_NO_USER_SESSION_KEY		equ	1394
ERROR_LICENSE_QUOTA_EXCEEDED		equ	1395
ERROR_INVALID_WINDOW_HANDLE		equ	1400
ERROR_INVALID_MENU_HANDLE		equ	1401
ERROR_INVALID_CURSOR_HANDLE		equ	1402
ERROR_INVALID_ACCEL_HANDLE		equ	1403
ERROR_INVALID_HOOK_HANDLE		equ	1404
ERROR_INVALID_DWP_HANDLE		equ	1405
ERROR_TLW_WITH_WSCHILD			equ	1406
ERROR_CANNOT_FIND_WND_CLASS		equ	1407
ERROR_WINDOW_OF_OTHER_THREAD		equ	1408
ERROR_HOTKEY_ALREADY_REGISTERED		equ	1409
ERROR_CLASS_ALREADY_EXISTS		equ	1410
ERROR_CLASS_DOES_NOT_EXIST		equ	1411
ERROR_CLASS_HAS_WINDOWS			equ	1412
ERROR_INVALID_INDEX			equ	1413
ERROR_INVALID_ICON_HANDLE		equ	1414
ERROR_PRIVATE_DIALOG_INDEX		equ	1415
ERROR_LISTBOX_ID_NOT_FOUND		equ	1416
ERROR_NO_WILDCARD_CHARACTERS		equ	1417
ERROR_CLIPBOARD_NOT_OPEN		equ	1418
ERROR_HOTKEY_NOT_REGISTERED		equ	1419
ERROR_WINDOW_NOT_DIALOG			equ	1420
ERROR_CONTROL_ID_NOT_FOUND		equ	1421
ERROR_INVALID_COMBOBOX_MESSAGE		equ	1422
ERROR_WINDOW_NOT_COMBOBOX		equ	1423
ERROR_INVALID_EDIT_HEIGHT		equ	1424
ERROR_DC_NOT_FOUND			equ	1425
ERROR_INVALID_HOOK_FILTER		equ	1426
ERROR_INVALID_FILTER_PROC		equ	1427
ERROR_HOOK_NEEDS_HMOD			equ	1428
ERROR_GLOBAL_ONLY_HOOK			equ	1429
ERROR_JOURNAL_HOOK_SET			equ	1430
ERROR_HOOK_NOT_INSTALLED		equ	1431
ERROR_INVALID_LB_MESSAGE		equ	1432
ERROR_SETCOUNT_ON_BAD_LB		equ	1433
ERROR_LB_WITHOUT_TABSTOPS		equ	1434
ERROR_DESTROY_OBJECT_OF_OTHER_THREAD	equ	1435
ERROR_CHILD_WINDOW_MENU			equ	1436
ERROR_NO_SYSTEM_MENU			equ	1437
ERROR_INVALID_MSGBOX_STYLE		equ	1438
ERROR_INVALID_SPI_VALUE			equ	1439
ERROR_SCREEN_ALREADY_LOCKED		equ	1440
ERROR_HWNDS_HAVE_DIFF_PARENT		equ	1441
ERROR_NOT_CHILD_WINDOW			equ	1442
ERROR_INVALID_GW_COMMAND		equ	1443
ERROR_INVALID_THREAD_ID			equ	1444
ERROR_NON_MDICHILD_WINDOW		equ	1445
ERROR_POPUP_ALREADY_ACTIVE		equ	1446
ERROR_NO_SCROLLBARS			equ	1447
ERROR_INVALID_SCROLLBAR_RANGE		equ	1448
ERROR_INVALID_SHOWWIN_COMMAND		equ	1449
ERROR_NO_SYSTEM_RESOURCES		equ	1450
ERROR_NONPAGED_SYSTEM_RESOURCES		equ	1451
ERROR_PAGED_SYSTEM_RESOURCES		equ	1452
ERROR_WORKING_SET_QUOTA			equ	1453
ERROR_PAGEFILE_QUOTA			equ	1454
ERROR_COMMITMENT_LIMIT			equ	1455
ERROR_MENU_ITEM_NOT_FOUND		equ	1456
ERROR_EVENTLOG_FILE_CORRUPT		equ	1500
ERROR_EVENTLOG_CANT_START		equ	1501
ERROR_LOG_FILE_FULL			equ	1502
ERROR_EVENTLOG_FILE_CHANGED		equ	1503
ERROR_INVALID_USER_BUFFER		equ	1784
ERROR_UNRECOGNIZED_MEDIA		equ	1785
ERROR_NO_TRUST_LSA_SECRET		equ	1786
ERROR_NO_TRUST_SAM_ACCOUNT		equ	1787
ERROR_TRUSTED_DOMAIN_FAILURE		equ	1788
ERROR_TRUSTED_RELATIONSHIP_FAILURE	equ	1789
ERROR_TRUST_FAILURE			equ	1790
ERROR_NETLOGON_NOT_STARTED		equ	1792
ERROR_ACCOUNT_EXPIRED			equ	1793
ERROR_REDIRECTOR_HAS_OPEN_HANDLES	equ	1794
ERROR_PRINTER_DRIVER_ALREADY_INSTALLED	equ	1795
ERROR_UNKNOWN_PORT			equ	1796
ERROR_UNKNOWN_PRINTER_DRIVER		equ	1797
ERROR_UNKNOWN_PRINTPROCESSOR		equ	1798
ERROR_INVALID_SEPARATOR_FILE		equ	1799
ERROR_INVALID_PRIORITY			equ	1800
ERROR_INVALID_PRINTER_NAME		equ	1801
ERROR_PRINTER_ALREADY_EXISTS		equ	1802
ERROR_INVALID_PRINTER_COMMAND		equ	1803
ERROR_INVALID_DATATYPE			equ	1804
ERROR_INVALID_ENVIRONMENT		equ	1805
ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT	equ	1807
ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT	equ	1808
ERROR_NOLOGON_SERVER_TRUST_ACCOUNT	equ	1809
ERROR_DOMAIN_TRUST_INCONSISTENT		equ	1810
ERROR_SERVER_HAS_OPEN_HANDLES		equ	1811
ERROR_RESOURCE_DATA_NOT_FOUND		equ	1812
ERROR_RESOURCE_TYPE_NOT_FOUND		equ	1813
ERROR_RESOURCE_NAME_NOT_FOUND		equ	1814
ERROR_RESOURCE_LANG_NOT_FOUND		equ	1815
ERROR_NOT_ENOUGH_QUOTA			equ	1816
ERROR_INVALID_TIME			equ	1901
ERROR_INVALID_FORM_NAME			equ	1902
ERROR_INVALID_FORM_SIZE			equ	1903
ERROR_ALREADY_WAITING			equ	1904
ERROR_PRINTER_DELETED			equ	1905
ERROR_INVALID_PRINTER_STATE		equ	1906
ERROR_PASSWORD_MUST_CHANGE		equ	1907
ERROR_DOMAIN_CONTROLLER_NOT_FOUND	equ	1908
ERROR_ACCOUNT_LOCKED_OUT		equ	1909
ERROR_INVALID_PIXEL_FORMAT		equ	2000
ERROR_BAD_DRIVER			equ	2001
ERROR_INVALID_WINDOW_STYLE		equ	2002
ERROR_METAFILE_NOT_SUPPORTED		equ	2003
ERROR_TRANSFORM_NOT_SUPPORTED		equ	2004
ERROR_CLIPPING_NOT_SUPPORTED		equ	2005
ERROR_UNKNOWN_PRINT_MONITOR		equ	3000
ERROR_PRINTER_DRIVER_IN_USE		equ	3001
ERROR_SPOOL_FILE_NOT_FOUND		equ	3002
ERROR_SPL_NO_STARTDOC			equ	3003
ERROR_SPL_NO_ADDJOB			equ	3004
ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED	equ	3005
ERROR_PRINT_MONITOR_ALREADY_INSTALLED	equ	3006
ERROR_WINS_INTERNAL			equ	4000
ERROR_CAN_NOT_DEL_LOCAL_WINS		equ	4001
ERROR_STATIC_INIT			equ	4002
ERROR_INC_BACKUP			equ	4003
ERROR_FULL_BACKUP			equ	4004
ERROR_REC_NON_EXISTENT			equ	4005
ERROR_RPL_NOT_ALLOWED			equ	4006
ERROR_NO_BROWSER_SERVERS_FOUND		equ	6118
;
;------------------------------------------------------------------------------
;
; ====================
; internet error codes
; ====================
;
INTERNET_ERROR_BASE			equ	12000
;
ERROR_INTERNET_OUT_OF_HANDLES		equ	INTERNET_ERROR_BASE+01
ERROR_INTERNET_TIMEOUT			equ	INTERNET_ERROR_BASE+02
ERROR_INTERNET_EXTENDED_ERROR		equ	INTERNET_ERROR_BASE+03
ERROR_INTERNET_INTERNAL_ERROR		equ	INTERNET_ERROR_BASE+04
ERROR_INTERNET_INVALID_URL		equ	INTERNET_ERROR_BASE+05
ERROR_INTERNET_UNRECOGNIZED_SCHEME	equ	INTERNET_ERROR_BASE+06
ERROR_INTERNET_NAME_NOT_RESOLVED	equ	INTERNET_ERROR_BASE+07
ERROR_INTERNET_PROTOCOL_NOT_FOUND	equ	INTERNET_ERROR_BASE+08
ERROR_INTERNET_INVALID_OPTION		equ	INTERNET_ERROR_BASE+09
ERROR_INTERNET_BAD_OPTION_LENGTH	equ	INTERNET_ERROR_BASE+10
ERROR_INTERNET_OPTION_NOT_SETTABLE	equ	INTERNET_ERROR_BASE+11
ERROR_INTERNET_SHUTDOWN			equ	INTERNET_ERROR_BASE+12
ERROR_INTERNET_INCORRECT_USER_NAME	equ	INTERNET_ERROR_BASE+13
ERROR_INTERNET_INCORRECT_PASSWORD	equ	INTERNET_ERROR_BASE+14
ERROR_INTERNET_LOGIN_FAILURE		equ	INTERNET_ERROR_BASE+15
ERROR_INTERNET_INVALID_OPERATION	equ	INTERNET_ERROR_BASE+16
ERROR_INTERNET_OPERATION_CANCELLED	equ	INTERNET_ERROR_BASE+17
ERROR_INTERNET_INCORRECT_HANDLE_TYPE	equ	INTERNET_ERROR_BASE+18
ERROR_INTERNET_NOT_PROXY_REQUEST	equ	INTERNET_ERROR_BASE+20
ERROR_INTERNET_REGISTRY_VALUE_NOT_FOUND	equ	INTERNET_ERROR_BASE+21
ERROR_INTERNET_BAD_REGISTRY_PARAMETER	equ	INTERNET_ERROR_BASE+22
ERROR_INTERNET_NO_DIRECT_ACCESS		equ	INTERNET_ERROR_BASE+23
ERROR_INTERNET_NO_CONTEXT		equ	INTERNET_ERROR_BASE+24
ERROR_INTERNET_NO_CALLBACK		equ	INTERNET_ERROR_BASE+25
ERROR_INTERNET_REQUEST_PENDING		equ	INTERNET_ERROR_BASE+26
;
ERROR_FTP_TRANSFER_IN_PROGRESS		equ	INTERNET_ERROR_BASE+28
ERROR_FTP_DROPPED			equ	INTERNET_ERROR_BASE+29
;
ERROR_GOPHER_PROTOCOL_ERROR		equ	INTERNET_ERROR_BASE+30
ERROR_GOPHER_NOT_FILE			equ	INTERNET_ERROR_BASE+31
ERROR_GOPHER_DATA_ERROR			equ	INTERNET_ERROR_BASE+32
ERROR_GOPHER_END_OF_DATA		equ	INTERNET_ERROR_BASE+33
ERROR_GOPHER_INVALID_LOCATOR		equ	INTERNET_ERROR_BASE+34
ERROR_GOPHER_INCORRECT_LOCATOR_TYPE	equ	INTERNET_ERROR_BASE+35
ERROR_GOPHER_NOT_GOPHER_PLUS		equ	INTERNET_ERROR_BASE+36
ERROR_GOPHER_ATTRIBUTE_NOT_FOUND	equ	INTERNET_ERROR_BASE+37
ERROR_GOPHER_UNKNOWN_LOCATOR		equ	INTERNET_ERROR_BASE+38
;
ERROR_HTTP_HEADER_NOT_FOUND		equ	INTERNET_ERROR_BASE+40
ERROR_HTTP_DOWNLEVEL_SERVER		equ	INTERNET_ERROR_BASE+41
ERROR_HTTP_INVALID_SERVER_RESPONSE	equ	INTERNET_ERROR_BASE+42
;
;------------------------------------------------------------------------------
;
; ===================
; edit control styles
; ===================
;
ES_LEFT				equ	0000h
ES_CENTER			equ	0001h
ES_RIGHT			equ	0002h
ES_MULTILINE			equ	0004h
ES_UPPERCASE			equ	0008h
ES_LOWERCASE			equ	0010h
ES_PASSWORD			equ	0020h
ES_AUTOVSCROLL			equ	0040h
ES_AUTOHSCROLL			equ	0080h
ES_NOHIDESEL			equ	0100h
ES_OEMCONVERT			equ	0400h
ES_READONLY			equ	0800h
ES_WANTRETURN			equ	1000h
ES_NUMBER			equ	2000h
;
ES_DEFAULT			equ	ES_MULTILINE+ES_AUTOHSCROLL
;
;------------------------------------------------------------------------------
;
; =============
; socket events
; =============
;
FD_READ			equ	00000001h
FD_WRITE		equ	00000002h
FD_OOB			equ	00000004h
FD_ACCEPT		equ	00000008h
FD_CONNECT		equ	00000010h
FD_CLOSE		equ	00000020h
;
;------------------------------------------------------------------------------
;
; =============
; font families
; =============
;
FF_DONTCARE			equ	0000h
FF_ROMAN			equ	0010h
FF_SWISS			equ	0020h
FF_MODERN			equ	0030h
FF_SCRIPT			equ	0040h
FF_DECORATIVE			equ	0050h
;
;------------------------------------------------------------------------------
;
; ===============
; file attributes
; ===============
;
FILE_ATTRIBUTE_READONLY		equ	00000001h
FILE_ATTRIBUTE_HIDDEN		equ	00000002h
FILE_ATTRIBUTE_SYSTEM		equ	00000004h
FILE_ATTRIBUTE_DIRECTORY	equ	00000010h
FILE_ATTRIBUTE_ARCHIVE		equ	00000020h
FILE_ATTRIBUTE_NORMAL		equ	00000080h
FILE_ATTRIBUTE_TEMPORARY	equ	00000100h
FILE_ATTRIBUTE_RESERVED0	equ	00000200h
FILE_ATTRIBUTE_RESERVED1	equ	00000400h
FILE_ATTRIBUTE_COMPRESSED	equ	00000800h
;
FILE_ATTRIBUTE_VALID_FLAGS	equ	00001FB7h
FILE_ATTRIBUTE_VALID_SET_FLAGS	equ	00000FA7h
;
;------------------------------------------------------------------------------
;
; =========================
; file/device control codes
; =========================
;
FILE_DEVICE_BEEP		equ	0001h shl 16
FILE_DEVICE_CD_ROM		equ	0002h shl 16
FILE_DEVICE_CD_ROM_FILE_SYSTEM	equ	0003h shl 16
FILE_DEVICE_CONTROLLER		equ	0004h shl 16
FILE_DEVICE_DATALINK		equ	0005h shl 16
FILE_DEVICE_DFS			equ	0006h shl 16
FILE_DEVICE_DISK		equ	0007h shl 16
FILE_DEVICE_DISK_FILE_SYSTEM	equ	0008h shl 16
FILE_DEVICE_FILE_SYSTEM		equ	0009h shl 16
FILE_DEVICE_INPORT_PORT		equ	000Ah shl 16
FILE_DEVICE_KEYBOARD		equ	000Bh shl 16
FILE_DEVICE_MAILSLOT		equ	000Ch shl 16
FILE_DEVICE_MIDI_IN		equ	000Dh shl 16
FILE_DEVICE_MIDI_OUT		equ	000Eh shl 16
FILE_DEVICE_MOUSE		equ	000Fh shl 16
FILE_DEVICE_MULTI_UNC_PROVIDER	equ	0010h shl 16
FILE_DEVICE_NAMED_PIPE		equ	0011h shl 16
FILE_DEVICE_NETWORK		equ	0012h shl 16
FILE_DEVICE_NETWORK_BROWSER	equ	0013h shl 16
FILE_DEVICE_NETWORK_FILE_SYSTEM	equ	0014h shl 16
FILE_DEVICE_NULL		equ	0015h shl 16
FILE_DEVICE_PARALLEL_PORT	equ	0016h shl 16
FILE_DEVICE_PHYSICAL_NETCARD	equ	0017h shl 16
FILE_DEVICE_PRINTER		equ	0018h shl 16
FILE_DEVICE_SCANNER		equ	0019h shl 16
FILE_DEVICE_SERIAL_MOUSE_PORT	equ	001Ah shl 16
FILE_DEVICE_SERIAL_PORT		equ	001Bh shl 16
FILE_DEVICE_SCREEN		equ	001Ch shl 16
FILE_DEVICE_SOUND		equ	001Dh shl 16
FILE_DEVICE_STREAMS		equ	001Eh shl 16
FILE_DEVICE_TAPE		equ	001Fh shl 16
FILE_DEVICE_TAPE_FILE_SYSTEM	equ	0020h shl 16
FILE_DEVICE_TRANSPORT		equ	0021h shl 16
FILE_DEVICE_UNKNOWN		equ	0022h shl 16
FILE_DEVICE_VIDEO		equ	0023h shl 16
FILE_DEVICE_VIRTUAL_DISK	equ	0024h shl 16
FILE_DEVICE_WAVE_IN		equ	0025h shl 16
FILE_DEVICE_WAVE_OUT		equ	0026h shl 16
FILE_DEVICE_8042_PORT		equ	0027h shl 16
FILE_DEVICE_NETWORK_REDIRECTOR	equ	0028h shl 16
FILE_DEVICE_BATTERY		equ	0029h shl 16
FILE_DEVICE_BUS_EXTENDER	equ	002Ah shl 16
FILE_DEVICE_MODEM		equ	002Bh shl 16
;
FILE_ANY_ACCESS			equ	00b                 shl 14
FILE_READ_ACCESS		equ	FILE_READ_DATA      shl 14
FILE_WRITE_ACCESS		equ	FILE_WRITE_DATA     shl 14
FILE_READWRITE_ACCESS		equ	FILE_READWRITE_DATA shl 14
;
METHOD_BUFFERED			equ	00b
METHOD_IN_DIRECT		equ	01b
METHOD_OUT_DIRECT		equ	10b
METHOD_NEITHER			equ	11b
;
DEVICE_NWRDR			equ	FILE_DEVICE_NETWORK_FILE_SYSTEM+\
					FILE_ANY_ACCESS+\
					METHOD_NEITHER
;
DEVICE_NWRDR_NCP		equ	DEVICE_NWRDR + (0400h shl 2)
;
;------------------------------------------------------------------------------
;
; ===================
; file creation flags
; ===================
;
FILE_FLAG_WRITE_THROUGH		equ	80000000h
FILE_FLAG_OVERLAPPED		equ	40000000h
FILE_FLAG_NO_BUFFERING		equ	20000000h
FILE_FLAG_RANDOM_ACCESS		equ	10000000h
FILE_FLAG_SEQUENTIAL_SCAN	equ	08000000h
FILE_FLAG_DELETE_ON_CLOSE	equ	04000000h
FILE_FLAG_BACKUP_SEMANTICS	equ	02000000h
FILE_FLAG_POSIX_SEMANTICS	equ	01000000h
;
;------------------------------------------------------------------------------
;
; ==================
; file notifications
; ==================
;
FILE_NOTIFY_CHANGE_FILE_NAME	equ	00000001h
FILE_NOTIFY_CHANGE_DIR_NAME	equ	00000002h
FILE_NOTIFY_CHANGE_ATTRIBUTES	equ	00000004h
FILE_NOTIFY_CHANGE_SIZE		equ	00000008h
FILE_NOTIFY_CHANGE_LAST_WRITE	equ	00000010h
FILE_NOTIFY_CHANGE_SECURITY	equ	00000100h
;
;------------------------------------------------------------------------------
;
; ================
; file share modes
; ================
;
FILE_SHARE_NONE			equ	00000000h
FILE_SHARE_READ			equ	00000001h
FILE_SHARE_WRITE		equ	00000002h
FILE_SHARE_DELETE		equ	00000004h
;
FILE_SHARE_READWRITE		equ	FILE_SHARE_READ+\
					FILE_SHARE_WRITE
;
FILE_SHARE_ALL			equ	FILE_SHARE_READ+\
					FILE_SHARE_WRITE+\
					FILE_SHARE_DELETE
;
;------------------------------------------------------------------------------
;
; ==================
; file access rights
; ==================
;
FILE_READ_DATA			equ	00000001h
FILE_LIST_DIRECTORY		equ	00000001h
FILE_WRITE_DATA			equ	00000002h
FILE_ADD_FILE			equ	00000002h
FILE_APPEND_DATA		equ	00000004h
FILE_ADD_SUBDIRECTORY		equ	00000004h
FILE_CREATE_PIPE_INSTANCE	equ	00000004h
FILE_READ_EA			equ	00000008h
FILE_WRITE_EA			equ	00000010h
FILE_EXECUTE			equ	00000020h
FILE_TRAVERSE			equ	00000020h
FILE_DELETE_CHILD		equ	00000040h
FILE_READ_ATTRIBUTES		equ	00000080h
FILE_WRITE_ATTRIBUTES		equ	00000100h
;
FILE_READWRITE_DATA		equ	FILE_READ_DATA+FILE_WRITE_DATA
FILE_READ_PROPERTIES		equ	FILE_READ_EA
FILE_WRITE_PROPERTIES		equ	FILE_WRITE_EA
;
FILE_ALL_ACCESS			equ	STANDARD_RIGHTS_REQUIRED+\
					SYNCHRONIZE+\
					01FFh
;
FILE_GENERIC_READ		equ	STANDARD_RIGHTS_READ+\
					FILE_READ_DATA+\
					FILE_READ_ATTRIBUTES+\
					FILE_READ_EA+\
					SYNCHRONIZE
;
FILE_GENERIC_WRITE		equ	STANDARD_RIGHTS_WRITE+\
					FILE_WRITE_DATA+\
					FILE_WRITE_ATTRIBUTES+\
					FILE_WRITE_EA+\
					FILE_APPEND_DATA+\
					SYNCHRONIZE
;
FILE_GENERIC_EXECUTE		equ	STANDARD_RIGHTS_EXECUTE+\
					FILE_READ_ATTRIBUTES+\
					FILE_EXECUTE+\
					SYNCHRONIZE
;
;------------------------------------------------------------------------------
;
; =========================
; create disposition values
; =========================
;
FILE_SUPERSEDE			equ	00000000h
FILE_OPEN			equ	00000001h
FILE_CREATE			equ	00000002h
FILE_OPEN_IF			equ	00000003h
FILE_OVERWRITE			equ	00000004h
FILE_OVERWRITE_IF		equ	00000005h
FILE_MAXIMUM_DISPOSITION	equ	00000005h
;
;------------------------------------------------------------------------------
;
; ===================
; open/create options
; ===================
;
FILE_DIRECTORY_FILE		equ	00000001h
FILE_WRITE_THROUGH		equ	00000002h
FILE_SEQUENTIAL_ONLY		equ	00000004h
FILE_NO_INTERMEDIATE_BUFFERING	equ	00000008h
FILE_SYNCHRONOUS_IO_ALERT	equ	00000010h
FILE_SYNCHRONOUS_IO_NONALERT	equ	00000020h
FILE_NON_DIRECTORY_FILE		equ	00000040h
FILE_CREATE_TREE_CONNECTION	equ	00000080h
FILE_COMPLETE_IF_OPLOCKED	equ	00000100h
FILE_NO_EA_KNOWLEDGE		equ	00000200h
FILE_DISABLE_TUNNELING		equ	00000400h
FILE_RANDOM_ACCESS		equ	00000800h
FILE_DELETE_ON_CLOSE		equ	00001000h
FILE_OPEN_BY_FILE_ID		equ	00002000h
FILE_OPEN_FOR_BACKUP_INTENT	equ	00004000h
FILE_NO_COMPRESSION		equ	00008000h
;
FILE_VALID_OPTION_FLAGS		 equ	000FFFFFh
FILE_VALID_PIPE_OPTION_FLAGS	 equ	00000032h
FILE_VALID_MAILSLOT_OPTION_FLAGS equ	00000032h
FILE_VALID_SET_FLAGS		 equ	00001036h
;
;------------------------------------------------------------------------------
;
; ===============
; alignment codes
; ===============
;
FILE_BYTE_ALIGNMENT		equ	00000000h
FILE_WORD_ALIGNMENT		equ	00000001h
FILE_LONG_ALIGNMENT		equ	00000003h
FILE_QUAD_ALIGNMENT		equ	00000007h
FILE_OCTA_ALIGNMENT		equ	0000000Fh
FILE_32_BYTE_ALIGNMENT		equ	0000001Fh
FILE_64_BYTE_ALIGNMENT		equ	0000003Fh
FILE_128_BYTE_ALIGNMENT		equ	0000007Fh
FILE_256_BYTE_ALIGNMENT		equ	000000FFh
FILE_512_BYTE_ALIGNMENT		equ	000001FFh
;
;------------------------------------------------------------------------------
;
; ======================
; device characteristics
; ======================
;
FILE_REMOVABLE_MEDIA		equ	00000001h
FILE_READ_ONLY_DEVICE		equ	00000002h
FILE_FLOPPY_DISKETTE		equ	00000004h
FILE_WRITE_ONCE_MEDIA		equ	00000008h
FILE_REMOTE_DEVICE		equ	00000010h
FILE_DEVICE_IS_MOUNTED		equ	00000020h
FILE_VIRTUAL_VOLUME		equ	00000040h
;
;------------------------------------------------------------------------------
;
; ========================
; SetFilePointer() methods
; ========================
;
FILE_BEGIN			equ	0
FILE_CURRENT			equ	1
FILE_END			equ	2
;
;------------------------------------------------------------------------------
;
; =================
; file system flags
; =================
;
FILE_CASE_SENSITIVE_SEARCH	equ	00000001h
FILE_CASE_PRESERVED_NAMES	equ	00000002h
FILE_UNICODE_ON_DISK		equ	00000004h
FILE_PERSISTENT_ACLS		equ	00000008h
FILE_FILE_COMPRESSION		equ	00000010h
FILE_VOLUME_IS_COMPRESSED	equ	00008000h
;
FS_CASE_SENSITIVE		equ	FILE_CASE_SENSITIVE_SEARCH
FS_CASE_IS_PRESERVED		equ	FILE_CASE_PRESERVED_NAMES
FS_UNICODE_STORED_ON_DISK	equ	FILE_UNICODE_ON_DISK
FS_PERSISTENT_ACLS		equ	FILE_PERSISTENT_ACLS
FS_FILE_COMPRESSION		equ	FILE_FILE_COMPRESSION
FS_VOL_IS_COMPRESSED		equ	FILE_VOLUME_IS_COMPRESSED
;
;------------------------------------------------------------------------------
;
; =====================
; FormatMessage() flags
; =====================
;
FORMAT_MESSAGE_ALLOCATE_BUFFER	equ	00000100h
FORMAT_MESSAGE_IGNORE_INSERTS	equ	00000200h
FORMAT_MESSAGE_FROM_STRING	equ	00000400h
FORMAT_MESSAGE_FROM_HMODULE	equ	00000800h
FORMAT_MESSAGE_FROM_SYSTEM	equ	00001000h
FORMAT_MESSAGE_ARGUMENT_ARRAY	equ	00002000h
FORMAT_MESSAGE_MAX_WIDTH_MASK	equ	000000FFh
;
;------------------------------------------------------------------------------
;
; ===========================
; internet ftp transfer types
; ===========================
;
FTP_TRANSFER_TYPE_UNKNOWN	equ	0
FTP_TRANSFER_TYPE_ASCII		equ	1
FTP_TRANSFER_TYPE_BINARY	equ	2
FTP_TRANSFER_TYPE_MASK		equ	3
;
;------------------------------------------------------------------------------
;
; ============
; font weights
; ============
;
FW_DONTCARE			equ	000
FW_THIN				equ	100
FW_EXTRALIGHT			equ	200
FW_LIGHT			equ	300
FW_NORMAL			equ	400
FW_MEDIUM			equ	500
FW_SEMIBOLD			equ	600
FW_BOLD				equ	700
FW_EXTRABOLD			equ	800
FW_HEAVY			equ	900
;
FW_ULTRALIGHT			equ	FW_EXTRALIGHT
FW_REGULAR			equ	FW_NORMAL
FW_DEMIBOLD			equ	FW_SEMIBOLD
FW_ULTRABOLD			equ	FW_EXTRABOLD
FW_BLACK			equ	FW_HEAVY
;
;------------------------------------------------------------------------------
;
; ======================
; GetClassLong() offsets
; ======================
;
GCL_MENUNAME			equ	-08
GCL_HBRBACKGROUND		equ	-10
GCL_HCURSOR			equ	-12
GCL_HICON			equ	-14
GCL_HMODULE			equ	-16
GCL_CBWNDEXTRA			equ	-18
GCL_CBCLSEXTRA			equ	-20
GCL_WNDPROC			equ	-24
GCL_STYLE			equ	-26
GCW_ATOM			equ	-32
GCL_HICONSM			equ	-34
;
;------------------------------------------------------------------------------
;
; =================
; file access types
; =================
;
GENERIC_ALL			equ	10000000h
GENERIC_EXECUTE			equ	20000000h
GENERIC_WRITE			equ	40000000h
GENERIC_READ			equ	80000000h
;
GENERIC_READWRITE		equ	GENERIC_READ+GENERIC_WRITE
;
;------------------------------------------------------------------------------
;
; ===================
; global memory flags
; ===================
;
GMEM_FIXED			equ	0000h
GMEM_MOVEABLE			equ	0002h
GMEM_NOCOMPACT			equ	0010h
GMEM_NODISCARD			equ	0020h
GMEM_ZEROINIT			equ	0040h
GMEM_MODIFY			equ	0080h
GMEM_DISCARDABLE		equ	0100h
GMEM_NOT_BANKED			equ	1000h
GMEM_SHARE			equ	2000h
GMEM_DDESHARE			equ	2000h
GMEM_NOTIFY			equ	4000h
GMEM_INVALID_HANDLE		equ	8000h
;
GMEM_VALID_FLAGS		equ	7F72h
GMEM_LOWER			equ	GMEM_NOT_BANKED
;
;------------------------------------------------------------------------------
;
; ==============================
; internet gopher attribute id's
; ==============================
;
GOPHER_ATTRIBUTE_ID_BASE	equ	0ABCCCC00h
;
GOPHER_CATEGORY_ID_ALL		equ	GOPHER_ATTRIBUTE_ID_BASE+01
GOPHER_CATEGORY_ID_INFO		equ	GOPHER_ATTRIBUTE_ID_BASE+02
GOPHER_CATEGORY_ID_ADMIN	equ	GOPHER_ATTRIBUTE_ID_BASE+03
GOPHER_CATEGORY_ID_VIEWS	equ	GOPHER_ATTRIBUTE_ID_BASE+04
GOPHER_CATEGORY_ID_ABSTRACT	equ	GOPHER_ATTRIBUTE_ID_BASE+05
GOPHER_CATEGORY_ID_VERONICA	equ	GOPHER_ATTRIBUTE_ID_BASE+06
GOPHER_CATEGORY_ID_ASK		equ	GOPHER_ATTRIBUTE_ID_BASE+07
GOPHER_CATEGORY_ID_UNKNOWN	equ	GOPHER_ATTRIBUTE_ID_BASE+08
GOPHER_ATTRIBUTE_ID_ALL		equ	GOPHER_ATTRIBUTE_ID_BASE+09
GOPHER_ATTRIBUTE_ID_ADMIN	equ	GOPHER_ATTRIBUTE_ID_BASE+10
GOPHER_ATTRIBUTE_ID_MOD_DATE	equ	GOPHER_ATTRIBUTE_ID_BASE+11
GOPHER_ATTRIBUTE_ID_TTL		equ	GOPHER_ATTRIBUTE_ID_BASE+12
GOPHER_ATTRIBUTE_ID_SCORE	equ	GOPHER_ATTRIBUTE_ID_BASE+13
GOPHER_ATTRIBUTE_ID_RANGE	equ	GOPHER_ATTRIBUTE_ID_BASE+14
GOPHER_ATTRIBUTE_ID_SITE	equ	GOPHER_ATTRIBUTE_ID_BASE+15
GOPHER_ATTRIBUTE_ID_ORG		equ	GOPHER_ATTRIBUTE_ID_BASE+16
GOPHER_ATTRIBUTE_ID_LOCATION	equ	GOPHER_ATTRIBUTE_ID_BASE+17
GOPHER_ATTRIBUTE_ID_GEOG	equ	GOPHER_ATTRIBUTE_ID_BASE+18
GOPHER_ATTRIBUTE_ID_TIMEZONE	equ	GOPHER_ATTRIBUTE_ID_BASE+19
GOPHER_ATTRIBUTE_ID_PROVIDER	equ	GOPHER_ATTRIBUTE_ID_BASE+20
GOPHER_ATTRIBUTE_ID_VERSION	equ	GOPHER_ATTRIBUTE_ID_BASE+21
GOPHER_ATTRIBUTE_ID_ABSTRACT	equ	GOPHER_ATTRIBUTE_ID_BASE+22
GOPHER_ATTRIBUTE_ID_VIEW	equ	GOPHER_ATTRIBUTE_ID_BASE+23
GOPHER_ATTRIBUTE_ID_TREEWALK	equ	GOPHER_ATTRIBUTE_ID_BASE+24
GOPHER_ATTRIBUTE_ID_UNKNOWN	equ	GOPHER_ATTRIBUTE_ID_BASE+25
;
;------------------------------------------------------------------------------
;
; =====================
; internet gopher types
; =====================
;
GOPHER_TYPE_TEXT_FILE		equ	00000001h
GOPHER_TYPE_DIRECTORY		equ	00000002h
GOPHER_TYPE_CSO			equ	00000004h
GOPHER_TYPE_ERROR		equ	00000008h
GOPHER_TYPE_MAC_BINHEX		equ	00000010h
GOPHER_TYPE_DOS_ARCHIVE		equ	00000020h
GOPHER_TYPE_UNIX_UUENCODED	equ	00000040h
GOPHER_TYPE_INDEX_SERVER	equ	00000080h
GOPHER_TYPE_TELNET		equ	00000100h
GOPHER_TYPE_BINARY		equ	00000200h
GOPHER_TYPE_REDUNDANT		equ	00000400h
GOPHER_TYPE_TN3270		equ	00000800h
GOPHER_TYPE_GIF			equ	00001000h
GOPHER_TYPE_IMAGE		equ	00002000h
GOPHER_TYPE_BITMAP		equ	00004000h
GOPHER_TYPE_MOVIE		equ	00008000h
GOPHER_TYPE_SOUND		equ	00010000h
GOPHER_TYPE_HTML		equ	00020000h
GOPHER_TYPE_PDF			equ	00040000h
GOPHER_TYPE_CALENDAR		equ	00080000h
GOPHER_TYPE_INLINE		equ	00100000h
GOPHER_TYPE_UNKNOWN		equ	20000000h
GOPHER_TYPE_ASK			equ	40000000h
GOPHER_TYPE_GOPHER_PLUS		equ	80000000h
;
_GOPHER_TYPE_FILE_MASK1		equ	GOPHER_TYPE_TEXT_FILE+\
					GOPHER_TYPE_MAC_BINHEX+\
					GOPHER_TYPE_DOS_ARCHIVE+\
					GOPHER_TYPE_UNIX_UUENCODED+\
					GOPHER_TYPE_BINARY+\
					GOPHER_TYPE_GIF+\
					GOPHER_TYPE_IMAGE
;
_GOPHER_TYPE_FILE_MASK2		equ	GOPHER_TYPE_BITMAP+\
					GOPHER_TYPE_MOVIE+\
					GOPHER_TYPE_SOUND+\
					GOPHER_TYPE_HTML+\
					GOPHER_TYPE_PDF+\
					GOPHER_TYPE_CALENDAR+\
					GOPHER_TYPE_INLINE
;
GOPHER_TYPE_FILE_MASK		equ	_GOPHER_TYPE_FILE_MASK1+\
					_GOPHER_TYPE_FILE_MASK2
;
;------------------------------------------------------------------------------
;
; ====================================
; internet gopher attribute categories
; ====================================
;
GOPHER_INFO_CATEGORY		textequ	<+INFO>
GOPHER_ADMIN_CATEGORY		textequ	<+ADMIN>
GOPHER_VIEWS_CATEGORY		textequ	<+VIEWS>
GOPHER_ABSTRACT_CATEGORY	textequ	<+ABSTRACT>
GOPHER_VERONICA_CATEGORY	textequ	<+VERONICA>
;
;------------------------------------------------------------------------------
;
; ==========================
; internet gopher attributes
; ==========================
;
GOPHER_ADMIN_ATTRIBUTE		textequ	<Admin>
GOPHER_MOD_DATE_ATTRIBUTE	textequ	<Mod-Date>
GOPHER_TTL_ATTRIBUTE		textequ	<TTL>
GOPHER_SCORE_ATTRIBUTE		textequ	<Score>
GOPHER_RANGE_ATTRIBUTE		textequ	<Score-range>
GOPHER_SITE_ATTRIBUTE		textequ	<Site>
GOPHER_ORG_ATTRIBUTE		textequ	<Org>
GOPHER_LOCATION_ATTRIBUTE	textequ	<Loc>
GOPHER_GEOG_ATTRIBUTE		textequ	<Geog>
GOPHER_TIMEZONE_ATTRIBUTE	textequ	<TZ>
GOPHER_PROVIDER_ATTRIBUTE	textequ	<Provider>
GOPHER_VERSION_ATTRIBUTE	textequ	<Version>
GOPHER_ABSTRACT_ATTRIBUTE	textequ	<Abstract>
GOPHER_VIEW_ATTRIBUTE		textequ	<View>
GOPHER_TREEWALK_ATTRIBUTE	textequ	<treewalk>
;
;------------------------------------------------------------------------------
;
; ================
; GetWindow() id's
; ================
;
GW_HWNDFIRST			equ	0
GW_HWNDLAST			equ	1
GW_HWNDNEXT			equ	2
GW_HWNDPREV			equ	3
GW_OWNER			equ	4
GW_CHILD			equ	5
;
GW_MAX				equ	5
;
;------------------------------------------------------------------------------
;
; =======================
; GetWindowLong() offsets
; =======================
;
GWL_WNDPROC			equ	-04
GWL_HINSTANCE			equ	-06
GWL_HWNDPARENT			equ	-08
GWL_STYLE			equ	-16
GWL_EXSTYLE			equ	-20
GWL_USERDATA			equ	-21
GWL_ID				equ	-12
;
;------------------------------------------------------------------------------
;
; ==================
; WinHelp() commands
; ==================
;
HELP_CONTEXT			equ	0001h
HELP_QUIT			equ	0002h
HELP_INDEX			equ	0003h
HELP_CONTENTS			equ	0003h
HELP_HELPONHELP			equ	0004h
HELP_SETINDEX			equ	0005h
HELP_SETCONTENTS		equ	0005h
HELP_CONTEXTPOPUP		equ	0008h
HELP_FORCEFILE			equ	0009h
HELP_CONTEXTMENU		equ	000Ah
HELP_FINDER			equ	000Bh
HELP_WM_HELP			equ	000Ch
HELP_SETPOPUP_POS		equ	000Dh
HELP_TCARD_DATA			equ	0010h
HELP_TCARD_OTHER_CALLER		equ	0011h
HELP_KEY			equ	0101h
HELP_COMMAND			equ	0102h
HELP_PARTIALKEY			equ	0105h
HELP_MULTIKEY			equ	0201h
HELP_SETWINPOS			equ	0203h
HELP_TCARD			equ	8000h
;
;------------------------------------------------------------------------------
;
; =======================
; hit test position codes
; =======================
;
HTERROR				equ	-2
HTTRANSPARENT			equ	-1
HTNOWHERE			equ	 0
HTCLIENT			equ	 1
HTCAPTION			equ	 2
HTSYSMENU			equ	 3
HTGROWBOX			equ	 4
HTMENU				equ	 5
HTHSCROLL			equ	 6
HTVSCROLL			equ	 7
HTMINBUTTON			equ	 8
HTMAXBUTTON			equ	 9
;
HTSIZEFIRST			equ	HTLEFT
HTLEFT				equ	10
HTRIGHT				equ	11
HTTOP				equ	12
HTTOPLEFT			equ	13
HTTOPRIGHT			equ	14
HTBOTTOM			equ	15
HTBOTTOMLEFT			equ	16
HTBOTTOMRIGHT			equ	17
HTSIZELAST			equ	HTBOTTOMRIGHT
;
HTBORDER			equ	18
HTOBJECT			equ	19
HTCLOSE				equ	20
HTHELP				equ	21
;
HTSIZE				equ	HTGROWBOX
HTREDUCE			equ	HTMINBUTTON
HTZOOM				equ	HTMAXBUTTON
;
;------------------------------------------------------------------------------
;
; ===============================
; internet HttpQueryInfo() levels
; ===============================
;
HTTP_QUERY_MIME_VERSION			equ	0000h
HTTP_QUERY_CONTENT_TYPE			equ	0001h
HTTP_QUERY_CONTENT_TRANSFER_ENCODING	equ	0002h
HTTP_QUERY_CONTENT_ID			equ	0003h
HTTP_QUERY_CONTENT_DESCRIPTION		equ	0004h
HTTP_QUERY_CONTENT_LENGTH		equ	0005h
HTTP_QUERY_CONTENT_LANGUAGE		equ	0006h
HTTP_QUERY_ALLOW			equ	0007h
HTTP_QUERY_PUBLIC			equ	0008h
HTTP_QUERY_DATE				equ	0009h
HTTP_QUERY_EXPIRES			equ	000Ah
HTTP_QUERY_LAST_MODIFIED		equ	000Bh
HTTP_QUERY_MESSAGE_ID			equ	000Ch
HTTP_QUERY_URI				equ	000Dh
HTTP_QUERY_DERIVED_FROM			equ	000Eh
HTTP_QUERY_COST				equ	000Fh
HTTP_QUERY_LINK				equ	0010h
HTTP_QUERY_PRAGMA			equ	0011h
HTTP_QUERY_VERSION			equ	0012h
HTTP_QUERY_STATUS_CODE			equ	0013h
HTTP_QUERY_STATUS_TEXT			equ	0014h
HTTP_QUERY_RAW_HEADERS			equ	0015h
HTTP_QUERY_RAW_HEADERS_CRLF		equ	0016h
HTTP_QUERY_CONNECTION			equ	0017h
;
HTTP_QUERY_MIN				equ	0000h
HTTP_QUERY_MAX				equ	0017h
;
;------------------------------------------------------------------------------
;
; ==========================
; internet http status codes
; ==========================
;
HTTP_STATUS_OK				equ	200
HTTP_STATUS_CREATED			equ	201
HTTP_STATUS_ACCEPTED			equ	202
HTTP_STATUS_PARTIAL			equ	203
HTTP_STATUS_MOVED			equ	301
HTTP_STATUS_REDIRECT			equ	302
HTTP_STATUS_REDIRECT_METHOD		equ	303
HTTP_STATUS_BAD_REQUEST			equ	400
HTTP_STATUS_DENIED			equ	401
HTTP_STATUS_PAYMENT_REQ			equ	402
HTTP_STATUS_FORBIDDEN			equ	403
HTTP_STATUS_NOT_FOUND			equ	404
HTTP_STATUS_SERVER_ERROR		equ	500
HTTP_STATUS_NOT_SUPPORTED		equ	501
;
;------------------------------------------------------------------------------
;
; =====================
; internet http version
; =====================
;
HTTP_VERSION			textequ	<HTTP/1.0>
;
HTTP_MAJOR_VERSION		equ	1
HTTP_MINOR_VERSION		equ	0
;
;------------------------------------------------------------------------------
;
; ===================
; toolbar bitmap id's
; ===================
;
IDB_STD_SMALL_COLOR		equ	 0
IDB_STD_LARGE_COLOR		equ	 1
IDB_VIEW_SMALL_COLOR		equ	 4
IDB_VIEW_LARGE_COLOR		equ	 5
;
HINST_COMMCTRL			equ	-1
;
;------------------------------------------------------------------------------
;
; =============
; ip icmp types
; =============
;
ICMP_ECHOREPLY			equ	0
ICMP_ECHOREQ			equ	8
;
;------------------------------------------------------------------------------
;
; ====================
; standard cursor id's
; ====================
;
IDC_ARROW			equ	32512
IDC_IBEAM			equ	32513
IDC_WAIT			equ	32514
IDC_CROSS			equ	32515
IDC_UPARROW			equ	32516
IDC_SIZE			equ	32640	;obsolete, use IDC_SIZEALL
IDC_ICON			equ	32641	;obsolete, use IDC_ARROW
IDC_SIZENWSE			equ	32642
IDC_SIZENESW			equ	32643
IDC_SIZEWE			equ	32644
IDC_SIZENS			equ	32645
IDC_SIZEALL			equ	32646
IDC_NO				equ	32648
IDC_APPSTARTING			equ	32650
IDC_HELP			equ	32651
;
;------------------------------------------------------------------------------
;
; ==================
; standard icon id's
; ==================
;
IDI_APPLICATION			equ	32512
IDI_HAND			equ	32513
IDI_QUESTION			equ	32514
IDI_EXCLAMATION			equ	32515
IDI_ASTERISK			equ	32516
IDI_WINLOGO			equ	32517
;
;------------------------------------------------------------------------------
;
; ===================
; dialog command id's
; ===================
;
IDOK				equ	1
IDCANCEL			equ	2
IDABORT				equ	3
IDRETRY				equ	4
IDIGNORE			equ	5
IDYES				equ	6
IDNO				equ	7
IDCLOSE				equ	8
IDHELP				equ	9
;
;------------------------------------------------------------------------------
;
; ===============
; ip link numbers
; ===============
;
IMPLINK_IP			equ	155
IMPLINK_LOWEXPER		equ	156
IMPLINK_HIGHEXPER		equ	158
;
;------------------------------------------------------------------------------
;
; ========================
; internet address classes
; ========================
;
IN_CLASSA_ID			equ	000000000h
IN_CLASSA_MASK			equ	080000000h
IN_CLASSA_NETID			equ	07F000000h
IN_CLASSA_NET			equ	0FF000000h
IN_CLASSA_HOST			equ	000FFFFFFh
IN_CLASSA_NSHIFT		equ	24
;
IN_CLASSB_ID			equ	080000000h
IN_CLASSB_MASK			equ	0C0000000h
IN_CLASSB_NETID			equ	03FFF0000h
IN_CLASSB_NET			equ	0FFFF0000h
IN_CLASSB_HOST			equ	00000FFFFh
IN_CLASSB_NSHIFT		equ	16
;
IN_CLASSC_ID			equ	0C0000000h
IN_CLASSC_MASK			equ	0E0000000h
IN_CLASSC_NETID			equ	01FFFFF00h
IN_CLASSC_NET			equ	0FFFFFF00h
IN_CLASSC_HOST			equ	0000000FFh
IN_CLASSC_NSHIFT		equ	08
;
IN_CLASSD_ID			equ	0E0000000h
IN_CLASSD_MASK			equ	0F0000000h
IN_CLASSD_ADDRESS		equ	00FFFFFFFh
;
IN_CLASSE_ID			equ	0F0000000h
IN_CLASSE_MASK			equ	0F8000000h
IN_CLASSE_ADDRESS		equ	007FFFFFFh
;
IN_LOOPBACKNET			equ	127
IN_LOOPBACKHOST			equ	001
;
INADDR_ANY			equ	000000000h	;0.0.0.0
INADDR_LOOPBACK			equ	07F000001h	;127.0.0.1
INADDR_UNSPEC_GROUP		equ	0E0000000h	;224.0.0.0
INADDR_ALLHOSTS_GROUP		equ	0E0000001h	;224.0.0.1
INADDR_MAX_LOCAL_GROUP		equ	0E00000FFh	;224.0.0.255
INADDR_BROADCAST		equ	0FFFFFFFFh	;255.255.255.255
INADDR_NONE			equ	0FFFFFFFFh
;
;------------------------------------------------------------------------------
;
; ======================
; internet default ports
; ======================
;
INTERNET_INVALID_PORT_NUMBER	equ	 0
INTERNET_DEFAULT_FTP_PORT	equ	21
INTERNET_DEFAULT_GOPHER_PORT	equ	70
INTERNET_DEFAULT_HTTP_PORT	equ	80
;
HTTP_TCPIP_PORT			equ	INTERNET_DEFAULT_HTTP_PORT
;
;------------------------------------------------------------------------------
;
; ==============
; internet flags
; ==============
;
INTERNET_REQFLAG_FROM_CACHE	equ	00000001h
INTERNET_REQFLAG_ASYNC		equ	00000002h
INTERNET_FLAG_MAKE_PERSISTENT	equ	02000000h
INTERNET_FLAG_DONT_CACHE	equ	04000000h
INTERNET_FLAG_PASSIVE		equ	08000000h
INTERNET_FLAG_ASYNC		equ	10000000h
INTERNET_FLAG_EXISTING_CONNECT	equ	20000000h
INTERNET_FLAG_RAW_DATA		equ	40000000h
INTERNET_FLAG_RELOAD		equ	80000000h
;
INTERNET_FLAGS_MASK		equ	INTERNET_FLAG_MAKE_PERSISTENT+\
					INTERNET_FLAG_DONT_CACHE+\
					INTERNET_FLAG_PASSIVE+\
					INTERNET_FLAG_ASYNC+\
					INTERNET_FLAG_EXISTING_CONNECT+\
					INTERNET_FLAG_RAW_DATA+\
					INTERNET_FLAG_RELOAD
;					
INTERNET_OPTIONS_MASK		equ	INTERNET_FLAGS_MASK xor -1
;
;------------------------------------------------------------------------------
;
; =====================
; internet handle types
; =====================
;
INTERNET_HANDLE_TYPE_INTERNET		equ	 1
INTERNET_HANDLE_TYPE_CONNECT_FTP	equ	 2
INTERNET_HANDLE_TYPE_CONNECT_GOPHER	equ	 3
INTERNET_HANDLE_TYPE_CONNECT_HTTP	equ	 4
INTERNET_HANDLE_TYPE_FTP_FIND		equ	 5
INTERNET_HANDLE_TYPE_FTP_FIND_HTML	equ	 6
INTERNET_HANDLE_TYPE_FTP_FILE		equ	 7
INTERNET_HANDLE_TYPE_FTP_FILE_HTML	equ	 8
INTERNET_HANDLE_TYPE_GOPHER_FIND	equ	 9
INTERNET_HANDLE_TYPE_GOPHER_FIND_HTML	equ	10
INTERNET_HANDLE_TYPE_GOPHER_FILE	equ	11
INTERNET_HANDLE_TYPE_GOPHER_FILE_HTML	equ	12
INTERNET_HANDLE_TYPE_HTTP_REQUEST	equ	13
;
;------------------------------------------------------------------------------
;
; ===========================
; internet keep-alive options
; ===========================
;
INTERNET_KEEP_ALIVE_DISABLED		equ	 0
INTERNET_KEEP_ALIVE_ENABLED		equ	 1
INTERNET_KEEP_ALIVE_UNKNOWN		equ	-1
;
;------------------------------------------------------------------------------
;
; =====================
; internet buffer sizes
; =====================
;
INTERNET_MAX_HOST_NAME_LENGTH		equ	  256
INTERNET_MAX_USER_NAME_LENGTH		equ	  128
INTERNET_MAX_PASSWORD_LENGTH		equ	  128
INTERNET_MAX_PORT_NUMBER_LENGTH		equ	    5
INTERNET_MAX_PORT_NUMBER_VALUE		equ	65535
INTERNET_MAX_PATH_LENGTH		equ	 1024
INTERNET_MAX_URL_LENGTH			equ	   10+INTERNET_MAX_PATH_LENGTH
;
;------------------------------------------------------------------------------
;
; ================
; internet options
; ================
;
INTERNET_NO_CALLBACK			equ	 0
INTERNET_OPTION_CALLBACK		equ	 1
INTERNET_OPTION_CONNECT_TIMEOUT		equ	 2
INTERNET_OPTION_CONNECT_RETRIES		equ	 3
INTERNET_OPTION_CONNECT_BACKOFF		equ	 4
INTERNET_OPTION_SEND_TIMEOUT		equ	 5
INTERNET_OPTION_RECEIVE_TIMEOUT		equ	 6
INTERNET_OPTION_DATA_SEND_TIMEOUT	equ	 7
INTERNET_OPTION_DATA_RECEIVE_TIMEOUT	equ	 8
INTERNET_OPTION_HANDLE_TYPE		equ	 9
INTERNET_OPTION_CONTEXT_VALUE		equ	10
INTERNET_OPTION_NAME_RES_THREAD		equ	11
INTERNET_OPTION_READ_BUFFER_SIZE	equ	12
INTERNET_OPTION_WRITE_BUFFER_SIZE	equ	13
INTERNET_OPTION_GATEWAY_NAME		equ	14
INTERNET_OPTION_ASYNC_ID		equ	15
INTERNET_OPTION_ASYNC_PRIORITY		equ	16
INTERNET_OPTION_ASYNC_REQUEST_COUNT	equ	17
INTERNET_OPTION_MAXIMUM_WORKER_THREADS	equ	18
INTERNET_OPTION_ASYNC_QUEUE_DEPTH	equ	19
INTERNET_OPTION_WORKER_THREAD_TIMEOUT	equ	20
INTERNET_OPTION_PARENT_HANDLE		equ	21
INTERNET_OPTION_KEEP_CONNECTION		equ	22
INTERNET_OPTION_REQUEST_FLAGS		equ	23
;
INTERNET_OPTION_CONTROL_SEND_TIMEOUT	equ	INTERNET_OPTION_SEND_TIMEOUT
INTERNET_OPTION_CONTROL_RECEIVE_TIMEOUT	equ	INTERNET_OPTION_RECEIVE_TIMEOUT
;
INTERNET_FIRST_OPTION			equ	INTERNET_OPTION_CALLBACK
INTERNET_LAST_OPTION			equ	INTERNET_OPTION_REQUEST_FLAGS
;
INTERNET_PRIORITY_FOREGROUND		equ	1000
;
;------------------------------------------------------------------------------
;
; ======================
; internet service types
; ======================
;
INTERNET_SERVICE_FTP			equ	1
INTERNET_SERVICE_GOPHER			equ	2
INTERNET_SERVICE_HTTP			equ	3
;
;------------------------------------------------------------------------------
;
; =====================
; internet status codes
; =====================
;
INTERNET_STATUS_RESOLVING_NAME		equ	 10
INTERNET_STATUS_NAME_RESOLVED		equ	 11
INTERNET_STATUS_CONNECTING_TO_SERVER	equ	 20
INTERNET_STATUS_CONNECTED_TO_SERVER	equ	 21
INTERNET_STATUS_SENDING_REQUEST		equ	 30
INTERNET_STATUS_REQUEST_SENT		equ	 31
INTERNET_STATUS_RECEIVING_RESPONSE	equ	 40
INTERNET_STATUS_RESPONSE_RECEIVED	equ	 41
INTERNET_STATUS_CTL_RESPONSE_RECEIVED	equ	 42
INTERNET_STATUS_CLOSING_CONNECTION	equ	 50
INTERNET_STATUS_CONNECTION_CLOSED	equ	 51
INTERNET_STATUS_HANDLE_CREATED		equ	 60
INTERNET_STATUS_REQUEST_COMPLETE	equ	100
;
INTERNET_INVALID_STATUS_CALLBACK	equ	 -1
;
;------------------------------------------------------------------------------
;
; ======================
; ioctlsocket() commands
; ======================
;
IOC_VOID			equ	20000000h
IOC_OUT				equ	40000000h
IOC_IN				equ	80000000h
;
IOC_INOUT			equ	IOC_IN  + IOC_OUT
;
FIONREAD			equ	IOC_OUT + 04667Fh
FIONBIO				equ	IOC_IN  + 04667Eh
FIOASYNC			equ	IOC_IN  + 04667Dh
;
SIOCSHIWAT			equ	IOC_IN  + 047300h
SIOCGHIWAT			equ	IOC_OUT + 047301h
SIOCSLOWAT			equ	IOC_IN  + 047302h
SIOCGLOWAT			equ	IOC_OUT + 047303h
SIOCATMARK			equ	IOC_OUT + 047307h
;
;------------------------------------------------------------------------------
;
; =================
; ip socket options
; =================
;
IP_OPTIONS			equ	 1
IP_MULTICAST_IF			equ	 2
IP_MULTICAST_TTL		equ	 3
IP_MULTICAST_LOOP		equ	 4
IP_ADD_MEMBERSHIP		equ	 5
IP_DROP_MEMBERSHIP		equ	 6
IP_TTL				equ	 7
IP_TOS				equ	 8
IP_DONTFRAGMENT			equ	 9
;
IP_DEFAULT_MULTICAST_TTL	equ	 1
IP_DEFAULT_MULTICAST_LOOP	equ	 1
IP_MAX_MEMBERSHIPS		equ	20
;
;------------------------------------------------------------------------------
;
; ===============
; ip port numbers
; ===============
;
IPPORT_ECHO			equ	   7
IPPORT_DISCARD			equ	   9
IPPORT_SYSTAT			equ	  11
IPPORT_DAYTIME			equ	  13
IPPORT_NETSTAT			equ	  15
IPPORT_FTP			equ	  21
IPPORT_TELNET			equ	  23
IPPORT_SMTP			equ	  25
IPPORT_TIMESERVER		equ	  37
IPPORT_NAMESERVER		equ	  42
IPPORT_WHOIS			equ	  43
IPPORT_MTP			equ	  57
;
IPPORT_TFTP			equ	  69
IPPORT_RJE			equ	  77
IPPORT_FINGER			equ	  79
IPPORT_TTYLINK			equ	  87
IPPORT_SUPDUP			equ	  95
;
IPPORT_EXECSERVER		equ	 512
IPPORT_LOGINSERVER		equ	 513
IPPORT_CMDSERVER		equ	 514
IPPORT_EFSSERVER		equ	 520
;
IPPORT_BIFFUDP			equ	 512
IPPORT_WHOSERVER		equ	 513
IPPORT_ROUTESERVER		equ	 520
;
IPPORT_RESERVED			equ	1024
;
;------------------------------------------------------------------------------
;
; ===================
; ip protocol numbers
; ===================
;
IPPROTO_IP			equ	  0
IPPROTO_ICMP			equ	  1
IPPROTO_IGMP			equ	  2
IPPROTO_GGP			equ	  3
IPPROTO_TCP			equ	  6
IPPROTO_PUP			equ	 12
IPPROTO_UDP			equ	 17
IPPROTO_IDP			equ	 22
IPPROTO_ND			equ	 77
;
IPPROTO_RAW			equ	255
IPPROTO_MAX			equ	256
;
;------------------------------------------------------------------------------
;
; =============================
; keyboard message lParam flags
; =============================
;
KF_EXTENDED			equ	0100h
KF_DLGMODE			equ	0800h
KF_MENUMODE			equ	1000h
KF_ALTDOWN			equ	2000h
KF_REPEAT			equ	4000h
KF_UP				equ	8000h
;
;------------------------------------------------------------------------------
;
; =============
; language id's
; =============
;
LANG_NEUTRAL			equ	00h
LANG_BULGARIAN			equ	02h
LANG_CHINESE			equ	04h
LANG_CZECH			equ	05h
LANG_DANISH			equ	06h
LANG_GERMAN			equ	07h
LANG_GREEK			equ	08h
LANG_ENGLISH			equ	09h
LANG_SPANISH			equ	0Ah
LANG_FINNISH			equ	0Bh
LANG_FRENCH			equ	0Ch
LANG_HUNGARIAN			equ	0Eh
LANG_ICELANDIC			equ	0Fh
LANG_ITALIAN			equ	10h
LANG_JAPANESE			equ	11h
LANG_KOREAN			equ	12h
LANG_DUTCH			equ	13h
LANG_NORWEGIAN			equ	14h
LANG_POLISH			equ	15h
LANG_PORTUGUESE			equ	16h
LANG_ROMANIAN			equ	18h
LANG_RUSSIAN			equ	19h
LANG_CROATIAN			equ	1Ah
LANG_SLOVAK			equ	1Bh
LANG_SWEDISH			equ	1Dh
LANG_TURKISH			equ	1Fh
LANG_SLOVENIAN			equ	24h
;
;------------------------------------------------------------------------------
;
; ================
; listbox messages
; ================
;
LB_ADDSTRING			equ	0180h
LB_INSERTSTRING			equ	0181h
LB_DELETESTRING			equ	0182h
LB_SELITEMRANGEEX		equ	0183h
LB_RESETCONTENT			equ	0184h
LB_SETSEL			equ	0185h
LB_SETCURSEL			equ	0186h
LB_GETSEL			equ	0187h
LB_GETCURSEL			equ	0188h
LB_GETTEXT			equ	0189h
LB_GETTEXTLEN			equ	018Ah
LB_GETCOUNT			equ	018Bh
LB_SELECTSTRING			equ	018Ch
LB_DIR				equ	018Dh
LB_GETTOPINDEX			equ	018Eh
LB_FINDSTRING			equ	018Fh
LB_GETSELCOUNT			equ	0190h
LB_GETSELITEMS			equ	0191h
LB_SETTABSTOPS			equ	0192h
LB_GETHORIZONTALEXTENT		equ	0193h
LB_SETHORIZONTALEXTENT		equ	0194h
LB_SETCOLUMNWIDTH		equ	0195h
LB_ADDFILE			equ	0196h
LB_SETTOPINDEX			equ	0197h
LB_GETITEMRECT			equ	0198h
LB_GETITEMDATA			equ	0199h
LB_SETITEMDATA			equ	019Ah
LB_SELITEMRANGE			equ	019Bh
LB_SETANCHORINDEX		equ	019Ch
LB_GETANCHORINDEX		equ	019Dh
LB_SETCARETINDEX		equ	019Eh
LB_GETCARETINDEX		equ	019Fh
LB_SETITEMHEIGHT		equ	01A0h
LB_GETITEMHEIGHT		equ	01A1h
LB_FINDSTRINGEXACT		equ	01A2h
LB_SETLOCALE			equ	01A5h
LB_GETLOCALE			equ	01A6h
LB_SETCOUNT			equ	01A7h
LB_INITSTORAGE			equ	01A8h
LB_ITEMFROMPOINT		equ	01A9h
LB_MSGMAX			equ	01B0h
;
;------------------------------------------------------------------------------
;
; =====================
; listbox return values
; =====================
;
LB_OKAY				equ	 0
LB_ERR				equ	-1
LB_ERRSPACE			equ	-2
;
;------------------------------------------------------------------------------
;
; ==========================
; listbox notification codes
; ==========================
;
LBN_ERRSPACE			equ	-2
LBN_SELCHANGE			equ	 1
LBN_DBLCLK			equ	 2
LBN_SELCANCEL			equ	 3
LBN_SETFOCUS			equ	 4
LBN_KILLFOCUS			equ	 5
;
;------------------------------------------------------------------------------
;
; ==============
; listbox styles
; ==============
;
LBS_NOTIFY			equ	00000001h
LBS_SORT			equ	00000002h
LBS_NOREDRAW			equ	00000004h
LBS_MULTIPLESEL			equ	00000008h
LBS_OWNERDRAWFIXED		equ	00000010h
LBS_OWNERDRAWVARIABLE		equ	00000020h
LBS_HASSTRINGS			equ	00000040h
LBS_USETABSTOPS			equ	00000080h
LBS_NOINTEGRALHEIGHT		equ	00000100h
LBS_MULTICOLUMN			equ	00000200h
LBS_WANTKEYBOARDINPUT		equ	00000400h
LBS_EXTENDEDSEL			equ	00000800h
LBS_DISABLENOSCROLL		equ	00001000h
LBS_NODATA			equ	00002000h
LBS_NOSEL			equ	00004000h
;
LBS_STANDARD			equ	LBS_NOTIFY+LBS_SORT+\
					WS_VSCROLL+WS_BORDER
;
LBS_STANDARD_NOSORT		equ	LBS_NOTIFY+\
					WS_VSCROLL+WS_BORDER
;
;------------------------------------------------------------------------------
;
; ==================
; local memory flags
; ==================
;
LMEM_FIXED			equ	0000h
LMEM_MOVEABLE			equ	0002h
LMEM_NOCOMPACT			equ	0010h
LMEM_NODISCARD			equ	0020h
LMEM_ZEROINIT			equ	0040h
LMEM_MODIFY			equ	0080h
LMEM_LOCKCOUNT			equ	00FFh
LMEM_DISCARDABLE		equ	0F00h
LMEM_DISCARDED			equ	4000h
LMEM_INVALID_HANDLE		equ	8000h
;
LMEM_VALID_FLAGS		equ	0F72h
;
NONZEROLHND			equ	LMEM_MOVEABLE
NONZEROLPTR			equ	LMEM_FIXED
;
LHND				equ	LMEM_ZEROINIT+LMEM_MOVEABLE
LPTR				equ	LMEM_ZEROINIT+LMEM_FIXED
;
;------------------------------------------------------------------------------
;
; ==================
; list view messages
; ==================
;
LVM_FIRST			equ	1000h
;
LVM_GETBKCOLOR			equ	LVM_FIRST+000
LVM_SETBKCOLOR			equ	LVM_FIRST+001
LVM_GETIMAGELIST		equ	LVM_FIRST+002
LVM_SETIMAGELIST		equ	LVM_FIRST+003
LVM_GETITEMCOUNT		equ	LVM_FIRST+004
LVM_GETITEMA			equ	LVM_FIRST+005
LVM_SETITEMA			equ	LVM_FIRST+006
LVM_INSERTITEMA			equ	LVM_FIRST+007
LVM_DELETEITEM			equ	LVM_FIRST+008
LVM_DELETEALLITEMS		equ	LVM_FIRST+009
LVM_GETCALLBACKMASK		equ	LVM_FIRST+010
LVM_SETCALLBACKMASK		equ	LVM_FIRST+011
LVM_GETNEXTITEM			equ	LVM_FIRST+012
LVM_FINDITEMA			equ	LVM_FIRST+013
LVM_GETITEMRECT			equ	LVM_FIRST+014
LVM_SETITEMPOSITION		equ	LVM_FIRST+015
LVM_GETITEMPOSITION		equ	LVM_FIRST+016
LVM_GETSTRINGWIDTHA		equ	LVM_FIRST+017
LVM_HITTEST			equ	LVM_FIRST+018
LVM_ENSUREVISIBLE		equ	LVM_FIRST+019
LVM_SCROLL			equ	LVM_FIRST+020
LVM_REDRAWITEMS			equ	LVM_FIRST+021
LVM_ARRANGE			equ	LVM_FIRST+022
LVM_EDITLABELA			equ	LVM_FIRST+023
LVM_GETEDITCONTROL		equ	LVM_FIRST+024
LVM_GETCOLUMNA			equ	LVM_FIRST+025
LVM_SETCOLUMNA			equ	LVM_FIRST+026
LVM_INSERTCOLUMNA		equ	LVM_FIRST+027
LVM_DELETECOLUMN		equ	LVM_FIRST+028
LVM_GETCOLUMNWIDTH		equ	LVM_FIRST+029
LVM_SETCOLUMNWIDTH		equ	LVM_FIRST+030
LVM_CREATEDRAGIMAGE		equ	LVM_FIRST+033
LVM_GETVIEWRECT			equ	LVM_FIRST+034
LVM_GETTEXTCOLOR		equ	LVM_FIRST+035
LVM_SETTEXTCOLOR		equ	LVM_FIRST+036
LVM_GETTEXTBKCOLOR		equ	LVM_FIRST+037
LVM_SETTEXTBKCOLOR		equ	LVM_FIRST+038
LVM_GETTOPINDEX			equ	LVM_FIRST+039
LVM_GETCOUNTPERPAGE		equ	LVM_FIRST+040
LVM_GETORIGIN			equ	LVM_FIRST+041
LVM_UPDATE			equ	LVM_FIRST+042
LVM_SETITEMSTATE		equ	LVM_FIRST+043
LVM_GETITEMSTATE		equ	LVM_FIRST+044
LVM_GETITEMTEXTA		equ	LVM_FIRST+045
LVM_SETITEMTEXTA		equ	LVM_FIRST+046
LVM_SETITEMCOUNT		equ	LVM_FIRST+047
LVM_SORTITEMS			equ	LVM_FIRST+048
LVM_SETITEMPOSITION32		equ	LVM_FIRST+049
LVM_GETSELECTEDCOUNT		equ	LVM_FIRST+050
LVM_GETITEMSPACING		equ	LVM_FIRST+051
LVM_GETISEARCHSTRINGA		equ	LVM_FIRST+052
;
LVM_GETITEMW			equ	LVM_FIRST+075
LVM_SETITEMW			equ	LVM_FIRST+076
LVM_INSERTITEMW			equ	LVM_FIRST+077
LVM_FINDITEMW			equ	LVM_FIRST+083
LVM_GETSTRINGWIDTHW		equ	LVM_FIRST+087
LVM_GETCOLUMNW			equ	LVM_FIRST+095
LVM_SETCOLUMNW			equ	LVM_FIRST+096
LVM_INSERTCOLUMNW		equ	LVM_FIRST+097
LVM_GETITEMTEXTW		equ	LVM_FIRST+115
LVM_SETITEMTEXTW		equ	LVM_FIRST+116
LVM_GETISEARCHSTRINGW		equ	LVM_FIRST+117
LVM_EDITLABELW			equ	LVM_FIRST+118
;
				if	UNICODE
LVM_GETITEM			equ	LVM_GETITEMW
LVM_SETITEM			equ	LVM_SETITEMW
LVM_INSERTITEM			equ	LVM_INSERTITEMW
LVM_FINDITEM			equ	LVM_FINDITEMW
LVM_GETSTRINGWIDTH		equ	LVM_GETSTRINGWIDTHW
LVM_GETCOLUMN			equ	LVM_GETCOLUMNW
LVM_SETCOLUMN			equ	LVM_SETCOLUMNW
LVM_INSERTCOLUMN		equ	LVM_INSERTCOLUMNW
LVM_GETITEMTEXT	 		equ	LVM_GETITEMTEXTW
LVM_SETITEMTEXT 		equ	LVM_SETITEMTEXTW
LVM_GETISEARCHSTRING		equ	LVM_GETISEARCHSTRINGW
LVM_EDITLABEL			equ	LVM_EDITLABELW
				else
LVM_GETITEM			equ	LVM_GETITEMA
LVM_SETITEM			equ	LVM_SETITEMA
LVM_INSERTITEM			equ	LVM_INSERTITEMA
LVM_FINDITEM			equ	LVM_FINDITEMA
LVM_GETSTRINGWIDTH		equ	LVM_GETSTRINGWIDTHA
LVM_GETCOLUMN			equ	LVM_GETCOLUMNA
LVM_SETCOLUMN			equ	LVM_SETCOLUMNA
LVM_INSERTCOLUMN		equ	LVM_INSERTCOLUMNA
LVM_GETITEMTEXT	 		equ	LVM_GETITEMTEXTA
LVM_SETITEMTEXT 		equ	LVM_SETITEMTEXTA
LVM_GETISEARCHSTRING		equ	LVM_GETISEARCHSTRINGA
LVM_EDITLABEL			equ	LVM_EDITLABELA
				endif
;
;------------------------------------------------------------------------------
;
; =======================
; list view notifications
; =======================
;
LVN_FIRST			equ	-100
LVN_LAST			equ	LVN_FIRST-99
;
LVN_ITEMCHANGING		equ	LVN_FIRST-00
LVN_ITEMCHANGED			equ	LVN_FIRST-01
LVN_INSERTITEM			equ	LVN_FIRST-02
LVN_DELETEITEM			equ	LVN_FIRST-03
LVN_DELETEALLITEMS		equ	LVN_FIRST-04
LVN_BEGINLABELEDITA		equ	LVN_FIRST-05
LVN_ENDLABELEDITA		equ	LVN_FIRST-06
LVN_COLUMNCLICK			equ	LVN_FIRST-08
LVN_BEGINDRAG			equ	LVN_FIRST-09
LVN_BEGINRDRAG			equ	LVN_FIRST-11
LVN_GETDISPINFOA		equ	LVN_FIRST-50
LVN_SETDISPINFOA		equ	LVN_FIRST-51
;
LVN_BEGINLABELEDITW		equ	LVN_FIRST-75
LVN_ENDLABELEDITW		equ	LVN_FIRST-76
LVN_GETDISPINFOW		equ	LVN_FIRST-77
LVN_SETDISPINFOW		equ	LVN_FIRST-78
;
				if	UNICODE
LVN_BEGINLABELEDIT		equ	LVN_BEGINLABELEDITW
LVN_ENDLABELEDIT		equ	LVN_ENDLABELEDITW
LVN_GETDISPINFO			equ	LVN_GETDISPINFOW
LVN_SETDISPINFO			equ	LVN_SETDISPINFOW
				else
LVN_BEGINLABELEDIT		equ	LVN_BEGINLABELEDITA
LVN_ENDLABELEDIT		equ	LVN_ENDLABELEDITA
LVN_GETDISPINFO			equ	LVN_GETDISPINFOA
LVN_SETDISPINFO			equ	LVN_SETDISPINFOA
				endif
;
;------------------------------------------------------------------------------
;
; ================
; list view styles
; ================
;
LVS_TYPEMASK			equ	00000003h
LVS_ICON			equ	00000000h
LVS_REPORT			equ	00000001h
LVS_SMALLICON			equ	00000002h
LVS_LIST			equ	00000003h
;
LVS_SINGLESEL			equ	00000004h
LVS_SHOWSELALWAYS		equ	00000008h
LVS_SORTASCENDING		equ	00000010h
LVS_SORTDESCENDING		equ	00000020h
LVS_SHAREIMAGELISTS		equ	00000040h
LVS_NOLABELWRAP			equ	00000080h
LVS_AUTOARRANGE			equ	00000100h
LVS_EDITLABELS			equ	00000200h
;
LVS_TYPESTYLEMASK		equ	0000FC00h
;
LVS_ALIGNMASK			equ	00000C00h
LVS_ALIGNTOP			equ	00000000h
LVS_OWNERDRAWFIXED		equ	00000400h
LVS_ALIGNLEFT			equ	00000800h
;
LVS_NOSCROLL			equ	00002000h
LVS_NOCOLUMNHEADER		equ	00004000h
LVS_NOSORTHEADER		equ	00008000h
;
;------------------------------------------------------------------------------
;
; ============================
; internet gopher buffer sizes
; ============================
;
MAX_GOPHER_DISPLAY_TEXT		equ	128
MAX_GOPHER_SELECTOR_TEXT	equ	256
MAX_GOPHER_CATEGORY_NAME	equ	128
MAX_GOPHER_ATTRIBUTE_NAME	equ	128
MIN_GOPHER_ATTRIBUTE_LENGTH	equ	256
;
MAX_GOPHER_HOST_NAME		equ	INTERNET_MAX_HOST_NAME_LENGTH
;
MAX_GOPHER_LOCATOR_LENGTH	equ	1+MAX_GOPHER_DISPLAY_TEXT+\
					1+MAX_GOPHER_SELECTOR_TEXT+\
					1+MAX_GOPHER_HOST_NAME+\
					1+INTERNET_MAX_PORT_NUMBER_LENGTH+\
					1+1+2
;
;------------------------------------------------------------------------------
;
; ==================
; MessageBox() flags
; ==================
;
MB_OK				equ	00000000h
MB_OKCANCEL			equ	00000001h
MB_ABORTRETRYIGNORE		equ	00000002h
MB_YESNOCANCEL			equ	00000003h
MB_YESNO			equ	00000004h
MB_RETRYCANCEL			equ	00000005h
;
MB_ICONHAND			equ	00000010h
MB_ICONQUESTION			equ	00000020h
MB_ICONEXCLAMATION		equ	00000030h
MB_ICONASTERISK			equ	00000040h
;
MB_ICONWARNING			equ	MB_ICONEXCLAMATION
MB_ICONERROR			equ	MB_ICONHAND
MB_ICONINFORMATION		equ	MB_ICONASTERISK
MB_ICONSTOP			equ	MB_ICONHAND
;
MB_DEFBUTTON1			equ	00000000h
MB_DEFBUTTON2			equ	00000100h
MB_DEFBUTTON3			equ	00000200h
MB_DEFBUTTON4			equ	00000300h
;
MB_APPLMODAL			equ	00000000h
MB_SYSTEMMODAL			equ	00001000h
MB_TASKMODAL			equ	00002000h
MB_HELP				equ	00004000h
MB_RIGHT			equ	00080000h
MB_RTLREADING			equ	00100000h
;
MB_NOFOCUS			equ	00008000h
MB_SETFOREGROUND		equ	00010000h
MB_DEFAULT_DESKTOP_ONLY		equ	00020000h
MB_SERVICE_NOTIFICATION		equ	00040000h
;
MB_TYPEMASK			equ	0000000Fh
MB_USERICON			equ	00000080h
MB_ICONMASK			equ	000000F0h
MB_DEFMASK			equ	00000F00h
MB_MODEMASK			equ	00003000h
MB_MISCMASK			equ	0000C000h
;
;------------------------------------------------------------------------------
;
; ==========
; menu flags
; ==========
;
MF_INSERT			equ	00000000h
MF_CHANGE			equ	00000080h
MF_APPEND			equ	00000100h
MF_DELETE			equ	00000200h
MF_REMOVE			equ	00001000h
;
MF_BYCOMMAND			equ	00000000h
MF_BYPOSITION			equ	00000400h
;
MF_SEPARATOR			equ	00000800h
;
MF_ENABLED			equ	00000000h
MF_GRAYED			equ	00000001h
MF_DISABLED			equ	00000002h
;
MF_UNCHECKED			equ	00000000h
MF_CHECKED			equ	00000008h
MF_USECHECKBITMAPS		equ	00000200h
;
MF_STRING			equ	00000000h
MF_BITMAP			equ	00000004h
MF_OWNERDRAW			equ	00000100h
;
MF_POPUP			equ	00000010h
MF_MENUBARBREAK			equ	00000020h
MF_MENUBREAK			equ	00000040h
;
MF_UNHILITE			equ	00000000h
MF_HILITE			equ	00000080h
;
MF_DEFAULT			equ	00001000h
MF_SYSMENU			equ	00002000h
MF_HELP				equ	00004000h
MF_RIGHTJUSTIFY			equ	00004000h
;
MF_MOUSESELECT			equ	00008000h
MF_END				equ	00000080h	;obsolete
;
MFT_STRING			equ	MF_STRING
MFT_BITMAP			equ	MF_BITMAP
MFT_MENUBARBREAK		equ	MF_MENUBARBREAK
MFT_MENUBREAK			equ	MF_MENUBREAK
MFT_OWNERDRAW			equ	MF_OWNERDRAW
MFT_RADIOCHECK			equ	00000200h
MFT_SEPARATOR			equ	MF_SEPARATOR
MFT_RIGHTORDER			equ	00002000h
MFT_RIGHTJUSTIFY		equ	MF_RIGHTJUSTIFY
;
MFS_GRAYED			equ	00000003h
MFS_DISABLED			equ	MFS_GRAYED
MFS_CHECKED			equ	MF_CHECKED
MFS_HILITE			equ	MF_HILITE
MFS_ENABLED			equ	MF_ENABLED
MFS_UNCHECKED			equ	MF_UNCHECKED
MFS_UNHILITE			equ	MF_UNHILITE
MFS_DEFAULT			equ	MF_DEFAULT
;
;------------------------------------------------------------------------------
;
; ========================
; mouse message key states
; ========================
;
MK_LBUTTON			equ	0001h
MK_RBUTTON			equ	0002h
MK_SHIFT			equ	0004h
MK_CONTROL			equ	0008h
MK_MBUTTON			equ	0010h
;
;------------------------------------------------------------------------------
;
; =====================
; socket function flags
; =====================
;
MSG_OOB				equ	0001h
MSG_PEEK			equ	0002h
MSG_DONTROUTE			equ	0004h
MSG_PARTIAL			equ	8000h
;
MSG_MAXIOVLEN			equ	16
;
;------------------------------------------------------------------------------
;
; ==========================
; netware ncp function codes
; ==========================
;
NCP_ABORT_SERVICING_QUEUE_JOB_AND_FILE			 equ	00170084h
NCP_ABORT_SERVICING_QUEUE_JOB_AND_FILE_OLD		 equ	00170073h
NCP_ADD_AUDIT_PROPERTY					 equ	00580002h
NCP_ADD_BINDERY_OBJECT_TO_SET				 equ	00170041h
NCP_ADD_TRUSTEE_SET_TO_NS_ENTRY				 equ	0057000Ah
NCP_ADD_TRUSTEE_TO_DIRECTORY				 equ	0016000Dh
NCP_AFP_ALLOC_TEMPORARY_DIR_HANDLE			 equ	0023000Bh
NCP_AFP_CREATE_DIRECTORY				 equ	00230001h
NCP_AFP_CREATE_FILE					 equ	00230002h
NCP_AFP_DELETE						 equ	00230003h
NCP_AFP_GET_ENTRY_ID_FROM_NAME				 equ	00230004h
NCP_AFP_GET_ENTRY_ID_FROM_NETWARE_HANDLE		 equ	00230006h
NCP_AFP_GET_ENTRY_ID_FROM_PATH_NAME			 equ	0023000Ch
NCP_AFP_GET_FILE_INFORMATION				 equ	00230005h
NCP_AFP_OPEN_FILE_FORK					 equ	00230008h
NCP_AFP_RENAME						 equ	00230007h
NCP_AFP_SCAN_FILE_INFORMATION				 equ	0023000Ah
NCP_AFP_SET_FILE_INFORMATION				 equ	00230009h
NCP_AFP20_CREATE_DIRECTORY				 equ	0023000Dh
NCP_AFP20_CREATE_FILE					 equ	0023000Eh
NCP_AFP20_GET_DOS_NAME_ENTRY_ID				 equ	00230012h
NCP_AFP20_GET_FILE					 equ	0023000Fh
NCP_AFP20_GET_MACINTOSH_INFO_ON_DELETED_FILE		 equ	00230013h
NCP_AFP20_SCAN_FILE_INFORMATION				 equ	00230011h
NCP_AFP20_SET_FILE_INFORMATION				 equ	00230010h
NCP_ALLOCATE_PERMANENT_DIRECTORY_HANDLE			 equ	00160012h
NCP_ALLOCATE_RESOURCE					 equ	000FFFFFh
NCP_ALLOCATE_SPECIAL_TEMPORARY_DIRECTORY_HANDLE		 equ	00160016h
NCP_ALLOCATE_TEMP_NS_DIR_HANDLE				 equ	0057000Ch
NCP_ALLOCATE_TEMPORARY_DIRECTORY_HANDLE			 equ	00160013h
NCP_ALLOW_TASK_ACCESS_TO_FILE				 equ	004EFFFFh
NCP_ATTACH_QUEUE_SERVER_TO_QUEUE			 equ	0017006Fh
NCP_BROADCAST_TO_CONSOLE				 equ	00150009h
NCP_CHANGE_AUDIT_LEVEL_TWO_PASSWORD			 equ	00580012h
NCP_CHANGE_AUDITOR_PASSWORD				 equ	00580004h
NCP_CHANGE_BINDERY_OBJECT_PASSWORD			 equ	00170040h
NCP_CHANGE_BINDERY_OBJECT_PASSWORD_ENCRYPTED		 equ	0017004Bh
NCP_CHANGE_BINDERY_OBJECT_SECURITY			 equ	00170038h
NCP_CHANGE_CONNECTION_STATE				 equ	0017001Dh
NCP_CHANGE_PROPERTY_SECURITY				 equ	0017003Bh
NCP_CHANGE_QUEUE_JOB_ENTRY				 equ	0017007Bh
NCP_CHANGE_QUEUE_JOB_ENTRY_OLD				 equ	0017006Dh
NCP_CHANGE_QUEUE_JOB_POSITION				 equ	0017007Ch
NCP_CHANGE_QUEUE_JOB_POSITION_OLD			 equ	0017006Eh
NCP_CHANGE_QUEUE_JOB_PRIORITY				 equ	00170082h
NCP_CHANGE_TO_CLIENT_RIGHTS				 equ	00170085h
NCP_CHANGE_TO_CLIENT_RIGHTS_OLD				 equ	00170074h
NCP_CHANGE_USER_PASSWORD				 equ	00170001h
NCP_CHECK_AUDIT_ACCESS					 equ	00580005h
NCP_CHECK_AUDIT_LEVEL_TWO_ACCESS			 equ	00580016h
NCP_CHECK_CONSOLE_PRIVILEGES				 equ	001700C8h
NCP_CHECK_PIPE_STATUS					 equ	00150008h
NCP_CLEAR_CONNECTION_NUMBER				 equ	001700FEh
NCP_CLEAR_CONNECTION_NUMBER_OLD				 equ	001700D2h
NCP_CLEAR_FILE						 equ	0007FFFFh
NCP_CLEAR_FILE_SET					 equ	0008FFFFh
NCP_CLEAR_LOGICAL_RECORD				 equ	000BFFFFh
NCP_CLEAR_LOGICAL_RECORD_SET				 equ	000EFFFFh
NCP_CLEAR_PHYSICAL_RECORD				 equ	001EFFFFh
NCP_CLEAR_PHYSICAL_RECORD_SET				 equ	001FFFFFh
NCP_CLEAR_VOLUME_RESTRICTIONS				 equ	00160022h
NCP_CLOSE_AND_QUEUE_CAPTURE_FILE			 equ	00110001h
NCP_CLOSE_BINDERY					 equ	00170044h
NCP_CLOSE_EXTENDED_ATTRIBUTE_HANDLE			 equ	00560001h
NCP_CLOSE_FILE_AND_START_JOB_QUEUE			 equ	0017007Fh
NCP_CLOSE_FILE_AND_START_JOB_QUEUE_OLD			 equ	00170069h
NCP_CLOSE_MESSAGE_PIPE					 equ	00150007h
NCP_CLOSE_OLD_AUDITING_FILE				 equ	00580014h
NCP_CLOSE_SEMAPHORE_OLD					 equ	00200004h
NCP_CLOSE_SEMAPHORE					 equ	006F0004h
NCP_COMMIT_FILE						 equ	003BFFFFh
NCP_CONVERT_PATH_TO_DIRECTORY_ENTRY			 equ	001700F4h
NCP_CREATE_BINDERY_OBJECT				 equ	00170032h
NCP_CREATE_DIRECTORY					 equ	0016000Ah
NCP_CREATE_NEW_FILE					 equ	004DFFFFh
NCP_CREATE_PROPERTY					 equ	00170039h
NCP_CREATE_QUEUE					 equ	00170064h
NCP_CREATE_QUEUE_JOB_AND_FILE				 equ	00170079h
NCP_CREATE_QUEUE_JOB_AND_FILE_OLD			 equ	00170068h
NCP_DEALLOCATE_DIRECTORY_HANDLE				 equ	00160014h
NCP_DEALLOCATE_RESOURCE					 equ	0010FFFFh
NCP_DELETE_BINDERY_OBJECT				 equ	00170033h
NCP_DELETE_BINDERY_OBJECT_FROM_SET			 equ	00170042h
NCP_DELETE_DIRECTORY					 equ	0016000Bh
NCP_DELETE_NS_ENTRY					 equ	00570008h
NCP_DELETE_OLD_AUDITING_FILE				 equ	00580015h
NCP_DELETE_OLD_AUDITING_FILE_2				 equ	0058001Ah
NCP_DELETE_PROPERTY					 equ	0017003Ah
NCP_DELETE_TRUSTEE					 equ	0016002Bh
NCP_DELETE_TRUSTEE_FROM_DIRECTORY			 equ	0016000Eh
NCP_DELETE_TRUSTEE_SET_FROM_NS_ENTRY			 equ	0057000Bh
NCP_DESTROY_QUEUE					 equ	00170065h
NCP_DETACH_QUEUE_SERVER_FROM_QUEUE			 equ	00170070h
NCP_DISABLE_AUDITING_ON_VOLUME				 equ	00580007h
NCP_DISABLE_STATION_BROADCASTS				 equ	00150002h
NCP_DISABLE_FILE_SERVER_LOGIN				 equ	001700CBh
NCP_DISABLE_TRANSACTION_TRACKING			 equ	001700CFh
NCP_DOWN_FILE_SERVER					 equ	001700D3h
NCP_DS_CHANGE_AUDIT_LEVEL_TWO_PASSWORD			 equ	006800D7h
NCP_DS_CHANGE_AUDITOR_PASSWORD				 equ	006800CBh
NCP_DS_CHANGE_OBJECT_AUDITED				 equ	006800DDh
NCP_DS_CHECK_AUDIT_ACCESS				 equ	006800CCh
NCP_DS_CHECK_AUDIT_LEVEL_TWO_ACCESS			 equ	006800DBh
NCP_DS_CHECK_OBJECT_AUDITED				 equ	006800DCh
NCP_DS_CLOSE_FRAGMENT					 equ	00680003h
NCP_DS_CLOSE_OLD_AUDITING_FILE				 equ	006800D9h
NCP_DS_DELETE_OLD_AUDITING_FILE				 equ	006800DAh
NCP_DS_DELETE_OLD_AUDITING_FILE_2			 equ	006800E1h
NCP_DS_DISABLE_AUDITING_ON_CONTAINER			 equ	006800CEh
NCP_DS_ENABLE_AUDITING_ON_CONTAINER			 equ	006800CFh
NCP_DS_GET_AUDIT_FILE_LIST				 equ	006800DEh
NCP_DS_GET_AUDITING_FLAGS				 equ	006800D8h
NCP_DS_GET_DS_STATISTICS				 equ	00680006h
NCP_DS_GET_CONTAINER_AUDIT_STATUS			 equ	006800C8h
NCP_DS_INIT_AUDIT_FILE_READ				 equ	006800DFh
NCP_DS_LOGIN_AS_CONTAINER_AUDITOR			 equ	006800CAh
NCP_DS_LOGOUT_AS_CONTAINER_AUDITOR			 equ	006800D3h
NCP_DS_MONITOR_CONNECTION				 equ	00680005h
NCP_DS_PING_FOR_NDS_NCP					 equ	00680001h
NCP_DS_READ_AUDIT_CONFIG_HEADER				 equ	006800D1h
NCP_DS_READ_AUDITING_FILE				 equ	006800D2h
NCP_DS_READ_AUDITING_FILE_2				 equ	006800E0h
NCP_DS_READ_AUDITING_FILES				 equ	00680015h
NCP_DS_RELOAD						 equ	00680008h
NCP_DS_RESET_AUDIT_HISTORY_FILE				 equ	006800D5h
NCP_DS_RESET_AUDITING_FILE				 equ	006800D4h
NCP_DS_RESET_DS_COUNTERS				 equ	00680007h
NCP_DS_RETURN_BINDERY_CONTEXT				 equ	00680004h
NCP_DS_SEND_FRAGMENTED_REQUEST_REPLY			 equ	00680002h
NCP_DS_SET_AUDIT_PASSWORD				 equ	006800E5h
NCP_DS_WRITE_AUDIT_CONFIG_HEADER			 equ	006800D6h
NCP_DUPLICATE_EXTENDED_ATTRIBUTE			 equ	00560005h
NCP_ENABLE_AUDITING_ON_VOLUME				 equ	00580008h
NCP_ENABLE_STATION_BROADCASTS				 equ	00150003h
NCP_ENABLE_FILE_SERVER_LOGIN				 equ	001700CCh
NCP_ENABLE_TRANSACTION_TRACKING				 equ	001700D0h
NCP_END_OF_JOB						 equ	0018FFFFh
NCP_ENTER_LOGIN_AREA					 equ	0017000Ah
NCP_ENUMERATE_EXTENDED_ATTRIBUTE			 equ	00560004h
NCP_ERASE_FILES						 equ	0044FFFFh
NCP_EXAMINE_SEMAPHORE_OLD				 equ	00200001h
NCP_EXAMINE_SEMAPHORE					 equ	006F0001h
NCP_FILE_CLOSE						 equ	0042FFFFh
NCP_FILE_COMMIT						 equ	003DFFFFh
NCP_FILE_COPY						 equ	004AFFFFh
NCP_FILE_CREATE						 equ	0043FFFFh
NCP_FILE_DM_REQUEST					 equ	005A0096h
NCP_FILE_OPEN						 equ	0041FFFFh
NCP_FILE_READ						 equ	0048FFFFh
NCP_FILE_RELEASE_LOCK					 equ	0002FFFFh
NCP_FILE_RENAME						 equ	0045FFFFh
NCP_FILE_SEARCH_CONTINUE				 equ	003FFFFFh
NCP_FILE_SEARCH_INITIALIZE				 equ	003EFFFFh
NCP_FILE_SET_LOCK					 equ	0001FFFFh
NCP_FILE_WRITE						 equ	0049FFFFh
NCP_FILL_NAME_SPACE_BUFFER				 equ	0016002Fh
NCP_FINISH_SERVICING_QUEUE_JOB_AND_FILE			 equ	00170083h
NCP_FINISH_SERVICING_QUEUE_JOB_AND_FILE_OLD		 equ	00170072h
NCP_GET_ACCOUNT_STATUS					 equ	00170096h
NCP_GET_ACTIVE_CONNECTION_LIST_BY_TYPE			 equ	007B000Eh
NCP_GET_ACTIVE_LAN_BOARD_LIST				 equ	007B0014h
NCP_GET_ACTIVE_PROTOCOL_STACKS				 equ	007B0028h
NCP_GET_AUDIT_FILE_LIST					 equ	00580017h
NCP_GET_AUDITING_FLAGS					 equ	00580013h
NCP_GET_BIG_PACKET_NCP_MAX_PACKET_SIZE			 equ	0061FFFFh
NCP_GET_BINDERY_ACCESS_LEVEL				 equ	00170046h
NCP_GET_BINDERY_OBJECT_ACCESS_LEVEL			 equ	00170048h
NCP_GET_BINDERY_OBJECT_DISK_SPACE_LEFT			 equ	001700E6h
NCP_GET_BINDERY_OBJECT_ID				 equ	00170035h
NCP_GET_BINDERY_OBJECT_NAME				 equ	00170036h
NCP_GET_BROADCAST_MESSAGE				 equ	00150001h
NCP_GET_BROADCAST_MESSAGE_EX				 equ	0015000Bh
NCP_GET_CACHE_INFORMATION				 equ	007B0001h
NCP_GET_CONNECTION_LIST_FROM_OBJECT			 equ	0017001Fh
NCP_GET_CONNECTION_OPEN_FILES				 equ	001700EBh
NCP_GET_CONNECTION_OPEN_FILES_OLD			 equ	001700DBh
NCP_GET_CONNECTION_SEMAPHORES				 equ	001700F1h
NCP_GET_CONNECTION_SEMAPHORES_OLD			 equ	001700E1h
NCP_GET_CONNECTION_TASK_INFORMATION			 equ	001700EAh
NCP_GET_CONNECTION_TASK_INFORMATION_OLD			 equ	001700DAh
NCP_GET_CONNECTION_USAGE_STATISTICS			 equ	001700E5h
NCP_GET_CONNECTIONS_USING_A_FILE			 equ	001700ECh
NCP_GET_CONNECTIONS_USING_A_FILE_OLD			 equ	001700DCh
NCP_GET_CPU_INFORMATION					 equ	007B0008h
NCP_GET_DIR_ENTRY					 equ	0016001Fh
NCP_GET_DIR_INFO					 equ	0016002Dh
NCP_GET_DIRECTORY_BASE					 equ	00570016h
NCP_GET_DIRECTORY_CACHE_INFORMATION			 equ	007B000Ch
NCP_GET_DIRECTORY_PATH					 equ	00160001h
NCP_GET_DISK_CACHE_STATISTICS				 equ	001700D6h
NCP_GET_DISK_CHANNEL_STATISTICS				 equ	001700D9h
NCP_GET_DISK_UTILIZATION				 equ	0017000Eh
NCP_GET_DM_INFO						 equ	005A0001h
NCP_GET_DM_FILE_INFO					 equ	005A0081h
NCP_GET_DM_STATUS_INFO					 equ	005A0083h
NCP_GET_DM_SUPPORT_MODULE_INFO				 equ	005A0084h
NCP_GET_DRIVE_MAPPING_TABLE				 equ	001700D7h
NCP_GET_EFFECTIVE_DIRECTORY_RIGHTS			 equ	00160003h
NCP_GET_EFFECTIVE_NS_DIRECTORY_RIGHTS			 equ	0057001Dh
NCP_GET_EFFECTIVE_RIGHTS				 equ	0016002Ah
NCP_GET_ENCRYPTION_KEY					 equ	00170017h
NCP_GET_EXTENDED_VOLUME_INFO				 equ	00160033h
NCP_GET_FILE_BIT_MAP					 equ	0055FFFFh
NCP_GET_FILE_SERVER_DATE_AND_TIME			 equ	0014FFFFh
NCP_GET_FILE_SERVER_DESCRIPTION_STRINGS			 equ	001700C9h
NCP_GET_FILE_SERVER_INFORMATION				 equ	00170011h
NCP_GET_FILE_SERVER_INFORMATION_EX			 equ	007B0002h
NCP_GET_FILE_SERVER_LAN_IO_STATISTICS			 equ	001700E7h
NCP_GET_FILE_SERVER_LOGIN_STATUS			 equ	001700CDh
NCP_GET_FILE_SERVER_MISC_INFORMATION			 equ	001700E8h
NCP_GET_FILE_SIZE					 equ	0047FFFFh
NCP_GET_FILE_SYSTEM_STATISTICS				 equ	001700D4h
NCP_GET_GARBAGE_COLLECTION_INFORMATION			 equ	007B0007h
NCP_GET_GENERAL_ROUTER_AND_SAP_INFORMATION		 equ	007B0032h
NCP_GET_INTERNET_ADDRESS				 equ	0017001Ah
NCP_GET_INTERNET_ADDRESS_OLD				 equ	00170013h
NCP_GET_IPX_SPX_INFORMATION				 equ	007B0006h
NCP_GET_KNOWN_NETWORKS_INFORMATION			 equ	007B0035h
NCP_GET_KNOWN_SERVERS_INFORMATION			 equ	007B0038h
NCP_GET_LAN_COMMON_COUNTERS_INFORMATION			 equ	007B0016h
NCP_GET_LAN_CONFIG_STRINGS				 equ	007B0018h
NCP_GET_LAN_CONFIGURATION_INFORMATION			 equ	007B0015h
NCP_GET_LAN_CUSTOM_COUNTERS_INFORMATION			 equ	007B0017h
NCP_GET_LAN_DRIVER_CONFIGURATION_INFORMATION		 equ	001700E3h
NCP_GET_LOADED_MEDIA_NUMBER_LIST			 equ	007B002Fh
NCP_GET_LOGICAL_RECORD_INFORMATION			 equ	001700F0h
NCP_GET_LOGICAL_RECORD_INFORMATION_OLD			 equ	001700E0h
NCP_GET_LOGICAL_RECORDS_BY_CONNECTION			 equ	001700EFh
NCP_GET_LOGICAL_RECORDS_BY_CONNECTION_OLD		 equ	001700DFh
NCP_GET_LSL_INFORMATION					 equ	007B0019h
NCP_GET_LSL_LOGICAL_BOARD_STATISTICS			 equ	007B001Ah
NCP_GET_MEDIA_MANAGER_OBJECT_CHILDREN_LIST		 equ	007B0020h
NCP_GET_MEDIA_MANAGER_OBJECT_INFORMATION		 equ	007B001Eh
NCP_GET_MEDIA_MANAGER_OBJECT_LIST			 equ	007B001Fh
NCP_GET_MEDIA_NAME_BY_MEDIA_NUMBER			 equ	007B002Eh
NCP_GET_MEMBER_SET_OF_GROUP				 equ	00170009h
NCP_GET_NAME_SPACE_ENTRY				 equ	00160030h
NCP_GET_NCP_EXTENSION_INFO				 equ	00240005h
NCP_GET_NCP_EXTENSIONS_LIST				 equ	00240004h
NCP_GET_NETWARE_FILE_SYSTEMS_INFORMATION		 equ	007B0003h
NCP_GET_NETWORK_ROUTER_INFORMATION			 equ	007B0033h
NCP_GET_NETWORK_ROUTERS_INFORMATION			 equ	007B0034h
NCP_GET_NETWORK_SERIAL_NUMBER				 equ	00170012h
NCP_GET_NLM_INFORMATION					 equ	007B000Bh
NCP_GET_NLM_LOADED_LIST					 equ	007B000Ah
NCP_GET_NLMS_RESOURCE_TAG_LIST				 equ	007B000Fh
NCP_GET_NS_DIR_HANDLE_PATH				 equ	00570015h
NCP_GET_NS_ENTRY_INFO					 equ	00570006h
NCP_GET_NS_INFO_FORMAT					 equ	00570017h
NCP_GET_NS_LOADED_LIST					 equ	00570018h
NCP_GET_NS_PATH						 equ	0057001Ch
NCP_GET_NUMBER_NCP_EXTENSIONS				 equ	00240003h
NCP_GET_OBJECT_CONNECTION_NUMBERS			 equ	0017001Bh
NCP_GET_OBJECT_CONNECTION_NUMBERS_OLD			 equ	00170015h
NCP_GET_OBJECT_DISK_RESTRICTIONS			 equ	00160029h
NCP_GET_OBJECT_EFFECTIVE_RIGHTS				 equ	00160032h
NCP_GET_OS_VERSION_INFORMATION				 equ	007B000Dh
NCP_GET_PACKET_BURST_INFORMATION			 equ	007B0005h
NCP_GET_PATH_FROM_DIRECTORY_BASE			 equ	001700F3h
NCP_GET_PATH_FROM_DIRECTORY_ENTRY			 equ	0016001Ah
NCP_GET_PERSONAL_MESSAGE				 equ	00150005h
NCP_GET_PHYSICAL_DISK_STATISTICS			 equ	001700D8h
NCP_GET_PHYSICAL_RECORD_LOCKS_BY_CONNECTION_AND_FILE	 equ	001700EDh
NCP_GET_PHYSICAL_RECORD_LOCKS_BY_CONNECTION_AND_FILE_OLD equ	001700DDh
NCP_GET_PHYSICAL_RECORD_LOCKS_BY_FILE			 equ	001700EEh
NCP_GET_PHYSICAL_RECORD_LOCKS_BY_FILE_OLD		 equ	001700DEh
NCP_GET_PRINTER_QUEUE					 equ	0011000Ah
NCP_GET_PRINTER_STATUS					 equ	00110006h
NCP_GET_PROTOCOL_STACK_CONFIGURATION_INFORMATION	 equ	007B0029h
NCP_GET_PROTOCOL_STACK_CUSTOM_INFORMATION		 equ	007B002Bh
NCP_GET_PROTOCOL_STACK_NUMBERS_BY_LAN_BOARD_NUMBER	 equ	007B002Dh
NCP_GET_PROTOCOL_STACK_NUMBERS_BY_MEDIA_NUMBER		 equ	007B002Ch
NCP_GET_PROTOCOL_STACK_STATISTICS_INFORMATION		 equ	007B002Ah
NCP_GET_QUEUE_JOB_LIST					 equ	00170081h
NCP_GET_QUEUE_JOB_LIST_OLD				 equ	0017006Bh
NCP_GET_QUEUE_JOB_FILE_SIZE				 equ	00170087h
NCP_GET_QUEUE_JOB_FILE_SIZE_OLD				 equ	00170078h
NCP_GET_QUEUE_JOBS_FROM_LIST				 equ	00170089h
NCP_GET_REFERENCE_COUNT_FROM_DIRECTORY_HANDLE		 equ	005A000Bh
NCP_GET_REFERENCE_COUNT_FROM_DIRECTORY_NUMBER		 equ	005A000Ah
NCP_GET_RELATIONOF_AN_OBJECT				 equ	0017004Ch
NCP_GET_SEMAPHORE_INFORMATION				 equ	001700F2h
NCP_GET_SEMAPHORE_INFORMATION_OLD			 equ	001700E2h
NCP_GET_SERVER_INFORMATION				 equ	007B0036h
NCP_GET_SERVER_SET_CATEGORIES				 equ	007B003Dh
NCP_GET_SERVER_SET_COMMANDS_INFORMATION			 equ	007B003Ch
NCP_GET_SERVER_SOURCES_INFORMATION			 equ	007B0037h
NCP_GET_SET_VOLUME_DM_STATUS				 equ	005A0086h
NCP_GET_SPOOL_QUEUE_ENTRY				 equ	00110004h
NCP_GET_STATION_NUMBER					 equ	0013FFFFh
NCP_GET_STATION_LOGGED_INFORMATION			 equ	0017001Ch
NCP_GET_STATION_LOGGED_INFORMATION_OLD			 equ	00170016h
NCP_GET_STATION_LOGGED_INFORMATION_EX			 equ	00170005h
NCP_GET_USER_INFORMATION				 equ	007B0004h
NCP_GET_UTC_TIME					 equ	00720001h
NCP_GET_VOLUME_AUDIT_STATISTICS				 equ	00580001h
NCP_GET_VOLUME_DM_STATUS				 equ	005A0082h
NCP_GET_VOLUME_INFO_WITH_HANDLE				 equ	00160015h
NCP_GET_VOLUME_INFO_WITH_NUMBER				 equ	0012FFFFh
NCP_GET_VOLUME_INFORMATION				 equ	001700E9h
NCP_GET_VOLUME_INFORMATION_BY_LEVEL			 equ	007B0022h
NCP_GET_VOLUME_NAME					 equ	00160006h
NCP_GET_VOLUME_NUMBER					 equ	00160005h
NCP_GET_VOLUME_SEGMENT_LIST				 equ	007B0021h
NCP_GET_VOLUME_SWITCH_INFORMATION			 equ	007B0009h
NCP_GET_VOLUME_USAGE					 equ	0016002Ch
NCP_INIT_AUDIT_FILE_READ				 equ	00580018h
NCP_INITIALIZE_NS_SCAN					 equ	00570002h
NCP_IS_BINDERY_OBJECT_IN_SET				 equ	00170043h
NCP_IS_STATION_A_MANAGER				 equ	00170049h
NCP_IS_USER_AUDITED					 equ	00580009h
NCP_LOCK_FILE_SET_OLD					 equ	0004FFFFh
NCP_LOCK_FILE_SET					 equ	006AFFFFh
NCP_LOCK_LOGICAL_RECORD_SET_OLD				 equ	000AFFFFh
NCP_LOCK_LOGICAL_RECORD_SET				 equ	006CFFFFh
NCP_LOCK_PHYSICAL_RECORD_SET_OLD			 equ	001BFFFFh
NCP_LOCK_PHYSICAL_RECORD_SET				 equ	006EFFFFh
NCP_LOG_FILE_OLD					 equ	0003FFFFh
NCP_LOG_FILE						 equ	0069FFFFh
NCP_LOG_LOGICAL_RECORD_OLD				 equ	0009FFFFh
NCP_LOG_LOGICAL_RECORD					 equ	006BFFFFh
NCP_LOG_NETWORK_MESSAGE					 equ	0017000Dh
NCP_LOG_PHYSICAL_RECORD_OLD				 equ	001AFFFFh
NCP_LOG_PHYSICAL_RECORD					 equ	006DFFFFh
NCP_LOGIN_AS_VOLUME_AUDITOR				 equ	00580003h
NCP_LOGIN_OBJECT					 equ	00170014h
NCP_LOGIN_OBJECT_ENCRYPTED				 equ	00170018h
NCP_LOGIN_USER_OBJECT					 equ	00170000h
NCP_LOGOUT						 equ	0019FFFFh
NCP_LOGOUT_AS_VOLUME_AUDITOR				 equ	0058000Dh
NCP_MAP_DIRECTORY_NUMBER_TO_PATH			 equ	001600F3h
NCP_MAP_GROUP_NAME_TO_NUMBER				 equ	00170007h
NCP_MAP_NUMBER_TO_GROUP_NAME				 equ	00170008h
NCP_MAP_NUMBER_TO_USER_NAME				 equ	00170004h
NCP_MAP_USER_NAME_TO_NUMBER				 equ	00170003h
NCP_MAP_USER_TO_STATION_SET				 equ	00170002h
NCP_MODIFY_MAXIMUM_RIGHTS_MASK				 equ	00160004h
NCP_MOVE_ENTRY						 equ	0016002Eh
NCP_MOVE_FILE_FROM_DM					 equ	005A0085h
NCP_MOVE_FILE_TO_DM					 equ	005A0080h
NCP_MOVE_QUEUE_JOB					 equ	00170088h
NCP_NEGOTIATE_BUFFER					 equ	0021FFFFh
NCP_OPEN_BINDERY					 equ	00170045h
NCP_OPEN_CREATE_FILE					 equ	0054FFFFh
NCP_OPEN_CREATE_NS_ENTRY				 equ	00570001h
NCP_OPEN_CREATE_NS_FILE_OR_DIRECTORY			 equ	0057001Eh
NCP_OPEN_DATA_STREAM					 equ	00160031h
NCP_OPEN_FILE						 equ	004CFFFFh
NCP_OPEN_MESSAGE_PIPE					 equ	00150006h
NCP_OPEN_SEMAPHORE_OLD					 equ	00200000h
NCP_OPEN_SEMAPHORE					 equ	006F0000h
NCP_PACKET_BURST_CONNECTION_REQUEST			 equ	0065FFFFh
NCP_PURGE_ALL_ERASED_FILES				 equ	001700CEh
NCP_PURGE_ERASED_FILES					 equ	00160010h
NCP_PURGE_NS_SALVAGEABLE_FILE				 equ	00570012h
NCP_PURGE_SALVAGEABLE_FILE				 equ	0016001Dh
NCP_READ_AUDIT_CONFIG_HEADER				 equ	0058000Bh
NCP_READ_AUDITING_BIT_MAP				 equ	0058000Ah
NCP_READ_AUDITING_FILE					 equ	0058000Ch
NCP_READ_AUDITING_FILE_2				 equ	00580019h
NCP_READ_EXTENDED_ATTRIBUTE				 equ	00560003h
NCP_READ_EXTENDED_NS_INFO				 equ	0057001Ah
NCP_READ_NS_INFO					 equ	00570013h
NCP_READ_PROPERTY_VALUE					 equ	0017003Dh
NCP_READ_QUEUE_CURRENT_STATUS				 equ	0017007Dh
NCP_READ_QUEUE_CURRENT_STATUS_OLD			 equ	00170066h
NCP_READ_QUEUE_JOB_ENTRY				 equ	0017007Ah
NCP_READ_QUEUE_JOB_ENTRY_OLD				 equ	0017006Ch
NCP_READ_QUEUE_SERVER_CURRENT_STATUS			 equ	00170086h
NCP_READ_QUEUE_SERVER_CURRENT_STATUS_OLD		 equ	00170076h
NCP_RECOVER_NS_SALVAGEABLE_FILE				 equ	00570011h
NCP_RECOVER_SALVAGEABLE_FILE				 equ	0016001Ch
NCP_RELEASE_A_RESOURCE					 equ	001700FCh
NCP_RELEASE_FILE					 equ	0005FFFFh
NCP_RELEASE_FILE_SET					 equ	0006FFFFh
NCP_RELEASE_LOGICAL_RECORD				 equ	000CFFFFh
NCP_RELEASE_LOGICAL_RECORD_SET				 equ	000DFFFFh
NCP_RELEASE_PHYSICAL_RECORD				 equ	001CFFFFh
NCP_RELEASE_PHYSICAL_RECORD_SET				 equ	001DFFFFh
NCP_REMOVE_AUDIT_PROPERTY				 equ	00580006h
NCP_REMOVE_ENTRY_FROM_SPOOL_QUEUE			 equ	00110005h
NCP_REMOVE_JOB_FROM_QUEUE				 equ	00170080h
NCP_REMOVE_JOB_FROM_QUEUE_OLD				 equ	0017006Ah
NCP_RENAME_BINDERY_OBJECT				 equ	00170034h
NCP_RENAME_DIRECTORY					 equ	0016000Fh
NCP_RENAME_NS_ENTRY					 equ	00570004h
NCP_RESET_AUDIT_HISTORY_FILE				 equ	0058000Fh
NCP_RESET_AUDITING_FILE					 equ	0058000Eh
NCP_RESTART_VOLUME_AUDITING				 equ	0058001Eh
NCP_RESTORE_DIRECTORY_HANDLE				 equ	00160018h
NCP_RESTORE_ERASED_FILE					 equ	00160011h
NCP_RESTORE_QUEUE_SERVER_RIGHTS				 equ	00170075h
NCP_SAVE_DIRECTORY_HANDLE				 equ	00160017h
NCP_SCAN_BINDERY_OBJECT					 equ	00170037h
NCP_SCAN_BINDERY_OBJECT_TRUSTEE_PATHS			 equ	00170047h
NCP_SCAN_DIR_ENTRY					 equ	0016001Eh
NCP_SCAN_DIR_RESTRICTIONS				 equ	00160023h
NCP_SCAN_DIRECTORY_FOR_TRUSTEES				 equ	0016000Ch
NCP_SCAN_DIRECTORY_INFORMATION				 equ	00160002h
NCP_SCAN_ENTRY_FOR_TRUSTEES				 equ	00160026h
NCP_SCAN_FILE_INFORMATION				 equ	0017000Fh
NCP_SCAN_FILE_PHYSICAL					 equ	00160028h
NCP_SCAN_NCP_EXTENSIONS					 equ	00240000h
NCP_SCAN_NCP_EXTENSIONS_BY_NAME				 equ	00240002h
NCP_SCAN_NS_ENTRY_FOR_TRUSTEES				 equ	00570005h
NCP_SCAN_NS_ENTRY_INFO					 equ	00570003h
NCP_SCAN_NS_NEXT_SET					 equ	00570014h
NCP_SCAN_NS_SALVAGEABLE_FILES				 equ	00570010h
NCP_SCAN_PROPERTY					 equ	0017003Ch
NCP_SCAN_SALVAGEABLE_FILES				 equ	0016001Bh
NCP_SCAN_VOLUME_FOR_RESTRICTIONS			 equ	00160020h
NCP_SEARCH_FILE						 equ	0040FFFFh
NCP_SEND_BROADCAST_MESSAGE				 equ	00150000h
NCP_SEND_BROADCAST_MESSAGE_EX				 equ	0015000Ah
NCP_SEND_CONSOLE_BROADCAST				 equ	001700FDh
NCP_SEND_CONSOLE_BROADCAST_OLD				 equ	001700D1h
NCP_SEND_PERSONAL_MESSAGE				 equ	00150004h
NCP_SERVICE_QUEUE_JOB_AND_OPEN_FILE_OLD			 equ	00170071h
NCP_SERVICE_QUEUE_JOB_LIST				 equ	0017008Ah
NCP_SET_AUDIT_PASSWORD					 equ	0058001Fh
NCP_SET_COMP_FILE_SIZE					 equ	005A000Ch
NCP_SET_DIR_RESTRICTION					 equ	00160024h
NCP_SET_DIRECTORY_HANDLE				 equ	00160000h
NCP_SET_DIRECTORY_INFORMATION				 equ	00160019h
NCP_SET_ENTRY						 equ	00160025h
NCP_SET_EXTENDED_FILE_ATTRIBUTES			 equ	004FFFFFh
NCP_SET_FILE_ATTRIBUTES					 equ	0046FFFFh
NCP_SET_FILE_INFORMATION				 equ	00170010h
NCP_SET_FILE_SERVER_DATE_AND_TIME			 equ	001700CAh
NCP_SET_FILE_TIME_AND_DATE				 equ	004BFFFFh
NCP_SET_NS_ENTRY_DOS_INFO				 equ	00570007h
NCP_SET_QUEUE_CURRENT_STATUS				 equ	0017007Eh
NCP_SET_QUEUE_CURRENT_STATUS_OLD			 equ	00170067h
NCP_SET_QUEUE_SERVER_CURRENT_STATUS			 equ	00170077h
NCP_SET_SPOOL_FLAGS					 equ	00110002h
NCP_SET_TEMP_NS_DIR_HANDLE				 equ	00570009h
NCP_SET_TRUSTEE						 equ	00160027h
NCP_SET_VOLUME_RESTRICTIONS				 equ	00160021h
NCP_SET_WATCHDOG_DELAY_INTERVAL				 equ	0017001Eh
NCP_SIGNAL_SEMAPHORE_OLD				 equ	00200003h
NCP_SIGNAL_SEMAPHORE					 equ	006F0003h
NCP_SPECIFY_CAPTURE_FILE				 equ	00110009h
NCP_SPOOL_DATA_TO_A_CAPTURE_FILE			 equ	00110000h
NCP_SPOOL_EXISTING_FILE					 equ	00110003h
NCP_SUBMIT_ACCOUNT_CHARGE				 equ	00170097h
NCP_SUBMIT_ACCOUNT_HOLD					 equ	00170098h
NCP_SUBMIT_ACCOUNT_NOTE					 equ	00170099h
NCP_SYNCHRONIZE_SCHEMA					 equ	00270000h
NCP_TTS_ABORT_TRANSACTION				 equ	00220003h
NCP_TTS_BEGIN_TRANSACTION				 equ	00220001h
NCP_TTS_END_TRANSACTION					 equ	00220002h
NCP_TTS_GET_APPLICATION_THRESHOLDS			 equ	00220005h
NCP_TTS_GET_CONTROL_FLAGS				 equ	00220009h
NCP_TTS_GET_STATISTICS					 equ	001700D5h
NCP_TTS_GET_WORKSTATION_THRESHOLDS			 equ	00220007h
NCP_TTS_IS_AVAILABLE					 equ	00220000h
NCP_TTS_SET_APPLICATION_THRESHOLDS			 equ	00220006h
NCP_TTS_SET_CONTROL_FLAGS				 equ	0022000Ah
NCP_TTS_SET_WORKSTATION_THRESHOLDS			 equ	00220008h
NCP_TTS_TRANSACTION_STATUS				 equ	00220004h
NCP_VERIFY_BINDERY_OBJECT_PASSWORD			 equ	0017003Fh
NCP_VERIFY_BINDERY_OBJECT_PASSWORD_ENCRYPTED		 equ	0017004Ah
NCP_VERIFY_NETWORK_SERIAL_NUMBER			 equ	0017000Ch
NCP_WAIT_ON_SEMAPHORE_OLD				 equ	00200002h
NCP_WAIT_ON_SEMAPHORE					 equ	006F0002h
NCP_WRITE_AUDIT_CONFIG_HEADER				 equ	00580011h
NCP_WRITE_AUDITING_BIT_MAP				 equ	00580010h
NCP_WRITE_EXTENDED_ATTRIBUTE				 equ	00560002h
NCP_WRITE_EXTENDED_NS_INFO				 equ	0057001Bh
NCP_WRITE_NS_INFO					 equ	00570019h
NCP_WRITE_PROPERTY_VALUE				 equ	0017003Eh
;
;------------------------------------------------------------------------------
;
; ===================
; network error codes
; ===================
;
NERR_Success			equ	   0
;
NERR_BASE			equ	2100
;
NERR_NetNotStarted		equ	NERR_BASE+002
NERR_UnknownServer		equ	NERR_BASE+003
NERR_ShareMem			equ	NERR_BASE+004
NERR_NoNetworkResource		equ	NERR_BASE+005
NERR_RemoteOnly			equ	NERR_BASE+006
NERR_DevNotRedirected		equ	NERR_BASE+007
NERR_ServerNotStarted		equ	NERR_BASE+014
NERR_ItemNotFound		equ	NERR_BASE+015
NERR_UnknownDevDir		equ	NERR_BASE+016
NERR_RedirectedPath		equ	NERR_BASE+017
NERR_DuplicateShare		equ	NERR_BASE+018
NERR_NoRoom			equ	NERR_BASE+019
NERR_TooManyItems		equ	NERR_BASE+021
NERR_InvalidMaxUsers		equ	NERR_BASE+022
NERR_BufTooSmall		equ	NERR_BASE+023
NERR_RemoteErr			equ	NERR_BASE+027
NERR_LanmanIniError		equ	NERR_BASE+031
NERR_NetworkError		equ	NERR_BASE+036
NERR_WkstaInconsistentState	equ	NERR_BASE+037
NERR_WkstaNotStarted		equ	NERR_BASE+038
NERR_BrowserNotStarted		equ	NERR_BASE+039
NERR_InternalError		equ	NERR_BASE+040
NERR_BadTransactConfig		equ	NERR_BASE+041
NERR_InvalidAPI			equ	NERR_BASE+042
NERR_BadEventName		equ	NERR_BASE+043
NERR_DupNameReboot		equ	NERR_BASE+044
;
NERR_CfgCompNotFound		equ	NERR_BASE+046
NERR_CfgParamNotFound		equ	NERR_BASE+047
NERR_LineTooLong		equ	NERR_BASE+049
;
NERR_QNotFound			equ	NERR_BASE+050
NERR_JobNotFound		equ	NERR_BASE+051
NERR_DestNotFound		equ	NERR_BASE+052
NERR_DestExists			equ	NERR_BASE+053
NERR_QExists			equ	NERR_BASE+054
NERR_QNoRoom			equ	NERR_BASE+055
NERR_JobNoRoom			equ	NERR_BASE+056
NERR_DestNoRoom			equ	NERR_BASE+057
NERR_DestIdle			equ	NERR_BASE+058
NERR_DestInvalidOp		equ	NERR_BASE+059
NERR_ProcNoRespond		equ	NERR_BASE+060
NERR_SpoolerNotLoaded		equ	NERR_BASE+061
NERR_DestInvalidState		equ	NERR_BASE+062
NERR_QInvalidState		equ	NERR_BASE+063
NERR_JobInvalidState		equ	NERR_BASE+064
NERR_SpoolNoMemory		equ	NERR_BASE+065
NERR_DriverNotFound		equ	NERR_BASE+066
NERR_DataTypeInvalid		equ	NERR_BASE+067
NERR_ProcNotFound		equ	NERR_BASE+068
;
NERR_ServiceTableLocked		equ	NERR_BASE+080
NERR_ServiceTableFull		equ	NERR_BASE+081
NERR_ServiceInstalled		equ	NERR_BASE+082
NERR_ServiceEntryLocked		equ	NERR_BASE+083
NERR_ServiceNotInstalled	equ	NERR_BASE+084
NERR_BadServiceName		equ	NERR_BASE+085
NERR_ServiceCtlTimeout		equ	NERR_BASE+086
NERR_ServiceCtlBusy		equ	NERR_BASE+087
NERR_BadServiceProgName		equ	NERR_BASE+088
NERR_ServiceNotCtrl		equ	NERR_BASE+089
NERR_ServiceKillProc		equ	NERR_BASE+090
NERR_ServiceCtlNotValid		equ	NERR_BASE+091
NERR_NotInDispatchTbl		equ	NERR_BASE+092
NERR_BadControlRecv		equ	NERR_BASE+093
NERR_ServiceNotStarting		equ	NERR_BASE+094
;
NERR_AlreadyLoggedOn		equ	NERR_BASE+100
NERR_NotLoggedOn		equ	NERR_BASE+101
NERR_BadUsername		equ	NERR_BASE+102
NERR_BadPassword		equ	NERR_BASE+103
NERR_UnableToAddName_W		equ	NERR_BASE+104
NERR_UnableToAddName_F		equ	NERR_BASE+105
NERR_UnableToDelName_W		equ	NERR_BASE+106
NERR_UnableToDelName_F		equ	NERR_BASE+107
NERR_LogonsPaused		equ	NERR_BASE+109
NERR_LogonServerConflict	equ	NERR_BASE+110
NERR_LogonNoUserPath		equ	NERR_BASE+111
NERR_LogonScriptError		equ	NERR_BASE+112
NERR_StandaloneLogon		equ	NERR_BASE+114
NERR_LogonServerNotFound	equ	NERR_BASE+115
NERR_LogonDomainExists		equ	NERR_BASE+116
NERR_NonValidatedLogon		equ	NERR_BASE+117
;
NERR_ACFNotFound		equ	NERR_BASE+119
NERR_GroupNotFound		equ	NERR_BASE+120
NERR_UserNotFound		equ	NERR_BASE+121
NERR_ResourceNotFound		equ	NERR_BASE+122
NERR_GroupExists		equ	NERR_BASE+123
NERR_UserExists			equ	NERR_BASE+124
NERR_ResourceExists		equ	NERR_BASE+125
NERR_NotPrimary			equ	NERR_BASE+126
NERR_ACFNotLoaded		equ	NERR_BASE+127
NERR_ACFNoRoom			equ	NERR_BASE+128
NERR_ACFFileIOFail		equ	NERR_BASE+129
NERR_ACFTooManyLists		equ	NERR_BASE+130
NERR_UserLogon			equ	NERR_BASE+131
NERR_ACFNoParent		equ	NERR_BASE+132
NERR_CanNotGrowSegment		equ	NERR_BASE+133
NERR_SpeGroupOp			equ	NERR_BASE+134
NERR_NotInCache			equ	NERR_BASE+135
NERR_UserInGroup		equ	NERR_BASE+136
NERR_UserNotInGroup		equ	NERR_BASE+137
NERR_AccountUndefined		equ	NERR_BASE+138
NERR_AccountExpired		equ	NERR_BASE+139
NERR_InvalidWorkstation		equ	NERR_BASE+140
NERR_InvalidLogonHours		equ	NERR_BASE+141
NERR_PasswordExpired		equ	NERR_BASE+142
NERR_PasswordCantChange		equ	NERR_BASE+143
NERR_PasswordHistConflict	equ	NERR_BASE+144
NERR_PasswordTooShort		equ	NERR_BASE+145
NERR_PasswordTooRecent		equ	NERR_BASE+146
NERR_InvalidDatabase		equ	NERR_BASE+147
NERR_DatabaseUpToDate		equ	NERR_BASE+148
NERR_SyncRequired		equ	NERR_BASE+149
;
NERR_UseNotFound		equ	NERR_BASE+150
NERR_BadAsgType			equ	NERR_BASE+151
NERR_DeviceIsShared		equ	NERR_BASE+152
;
NERR_NoComputerName		equ	NERR_BASE+170
NERR_MsgAlreadyStarted		equ	NERR_BASE+171
NERR_MsgInitFailed		equ	NERR_BASE+172
NERR_NameNotFound		equ	NERR_BASE+173
NERR_AlreadyForwarded		equ	NERR_BASE+174
NERR_AddForwarded		equ	NERR_BASE+175
NERR_AlreadyExists		equ	NERR_BASE+176
NERR_TooManyNames		equ	NERR_BASE+177
NERR_DelComputerName		equ	NERR_BASE+178
NERR_LocalForward		equ	NERR_BASE+179
NERR_GrpMsgProcessor		equ	NERR_BASE+180
NERR_PausedRemote		equ	NERR_BASE+181
NERR_BadReceive			equ	NERR_BASE+182
NERR_NameInUse			equ	NERR_BASE+183
NERR_MsgNotStarted		equ	NERR_BASE+184
NERR_NotLocalName		equ	NERR_BASE+185
NERR_NoForwardName		equ	NERR_BASE+186
NERR_RemoteFull			equ	NERR_BASE+187
NERR_NameNotForwarded		equ	NERR_BASE+188
NERR_TruncatedBroadcast		equ	NERR_BASE+189
NERR_InvalidDevice		equ	NERR_BASE+194
NERR_WriteFault			equ	NERR_BASE+195
NERR_DuplicateName		equ	NERR_BASE+197
NERR_DeleteLater		equ	NERR_BASE+198
NERR_IncompleteDel		equ	NERR_BASE+199
NERR_MultipleNets		equ	NERR_BASE+200
;
NERR_NetNameNotFound		equ	NERR_BASE+210
NERR_DeviceNotShared		equ	NERR_BASE+211
NERR_ClientNameNotFound		equ	NERR_BASE+212
NERR_FileIdNotFound		equ	NERR_BASE+214
NERR_ExecFailure		equ	NERR_BASE+215
NERR_TmpFile			equ	NERR_BASE+216
NERR_TooMuchData		equ	NERR_BASE+217
NERR_DeviceShareConflict	equ	NERR_BASE+218
NERR_BrowserTableIncomplete	equ	NERR_BASE+219
NERR_NotLocalDomain		equ	NERR_BASE+220
;
NERR_DevInvalidOpCode		equ	NERR_BASE+231
NERR_DevNotFound		equ	NERR_BASE+232
NERR_DevNotOpen			equ	NERR_BASE+233
NERR_BadQueueDevString		equ	NERR_BASE+234
NERR_BadQueuePriority		equ	NERR_BASE+235
NERR_NoCommDevs			equ	NERR_BASE+237
NERR_QueueNotFound		equ	NERR_BASE+238
NERR_BadDevString		equ	NERR_BASE+240
NERR_BadDev			equ	NERR_BASE+241
NERR_InUseBySpooler		equ	NERR_BASE+242
NERR_CommDevInUse		equ	NERR_BASE+243
;
NERR_InvalidComputer		equ	NERR_BASE+251
NERR_MaxLenExceeded		equ	NERR_BASE+254
NERR_BadComponent		equ	NERR_BASE+256
NERR_CantType			equ	NERR_BASE+257
NERR_TooManyEntries		equ	NERR_BASE+262
;
NERR_ProfileFileTooBig		equ	NERR_BASE+270
NERR_ProfileOffset		equ	NERR_BASE+271
NERR_ProfileCleanup		equ	NERR_BASE+272
NERR_ProfileUnknownCmd		equ	NERR_BASE+273
NERR_ProfileLoadErr		equ	NERR_BASE+274
NERR_ProfileSaveErr		equ	NERR_BASE+275
;
NERR_LogOverflow		equ	NERR_BASE+277
NERR_LogFileChanged		equ	NERR_BASE+278
NERR_LogFileCorrupt		equ	NERR_BASE+279
;
NERR_SourceIsDir		equ	NERR_BASE+280
NERR_BadSource			equ	NERR_BASE+281
NERR_BadDest			equ	NERR_BASE+282
NERR_DifferentServers		equ	NERR_BASE+283
NERR_RunSrvPaused		equ	NERR_BASE+285
NERR_ErrCommRunSrv		equ	NERR_BASE+289
NERR_ErrorExecingGhost		equ	NERR_BASE+291
NERR_ShareNotFound		equ	NERR_BASE+292
;
NERR_InvalidLana		equ	NERR_BASE+300
NERR_OpenFiles			equ	NERR_BASE+301
NERR_ActiveConns		equ	NERR_BASE+302
NERR_BadPasswordCore		equ	NERR_BASE+303
NERR_DevInUse			equ	NERR_BASE+304
NERR_LocalDrive			equ	NERR_BASE+305
;
NERR_AlertExists		equ	NERR_BASE+330
NERR_TooManyAlerts		equ	NERR_BASE+331
NERR_NoSuchAlert		equ	NERR_BASE+332
NERR_BadRecipient		equ	NERR_BASE+333
NERR_AcctLimitExceeded		equ	NERR_BASE+334
;
NERR_InvalidLogSeek		equ	NERR_BASE+340
;
NERR_BadUasConfig		equ	NERR_BASE+350
NERR_InvalidUASOp		equ	NERR_BASE+351
NERR_LastAdmin			equ	NERR_BASE+352
NERR_DCNotFound			equ	NERR_BASE+353
NERR_LogonTrackingError		equ	NERR_BASE+354
NERR_NetlogonNotStarted		equ	NERR_BASE+355
NERR_CanNotGrowUASFile		equ	NERR_BASE+356
NERR_TimeDiffAtDC		equ	NERR_BASE+357
NERR_PasswordMismatch		equ	NERR_BASE+358
;
NERR_NoSuchServer		equ	NERR_BASE+360
NERR_NoSuchSession		equ	NERR_BASE+361
NERR_NoSuchConnection		equ	NERR_BASE+362
NERR_TooManyServers		equ	NERR_BASE+363
NERR_TooManySessions		equ	NERR_BASE+364
NERR_TooManyConnections		equ	NERR_BASE+365
NERR_TooManyFiles		equ	NERR_BASE+366
NERR_NoAlternateServers		equ	NERR_BASE+367
NERR_TryDownLevel		equ	NERR_BASE+370
;
NERR_UPSDriverNotStarted	equ	NERR_BASE+380
NERR_UPSInvalidConfig		equ	NERR_BASE+381
NERR_UPSInvalidCommPort		equ	NERR_BASE+382
NERR_UPSSignalAsserted		equ	NERR_BASE+383
NERR_UPSShutdownFailed		equ	NERR_BASE+384
;
NERR_BadDosRetCode		equ	NERR_BASE+400
NERR_ProgNeedsExtraMem		equ	NERR_BASE+401
NERR_BadDosFunction		equ	NERR_BASE+402
NERR_RemoteBootFailed		equ	NERR_BASE+403
NERR_BadFileCheckSum		equ	NERR_BASE+404
NERR_NoRplBootSystem		equ	NERR_BASE+405
NERR_RplLoadrNetBiosErr		equ	NERR_BASE+406
NERR_RplLoadrDiskErr		equ	NERR_BASE+407
NERR_ImageParamErr		equ	NERR_BASE+408
NERR_TooManyImageParams		equ	NERR_BASE+409
NERR_NonDosFloppyUsed		equ	NERR_BASE+410
NERR_RplBootRestart		equ	NERR_BASE+411
NERR_RplSrvrCallFailed		equ	NERR_BASE+412
NERR_CantConnectRplSrvr		equ	NERR_BASE+413
NERR_CantOpenImageFile		equ	NERR_BASE+414
NERR_CallingRplSrvr		equ	NERR_BASE+415
NERR_StartingRplBoot		equ	NERR_BASE+416
NERR_RplBootServiceTerm		equ	NERR_BASE+417
NERR_RplBootStartFailed		equ	NERR_BASE+418
NERR_RPL_CONNECTED		equ	NERR_BASE+419
;
NERR_BrowserConfiguredToNotRun	equ	NERR_BASE+450
;
NERR_RplNoAdaptersStarted	equ	NERR_BASE+510
NERR_RplBadRegistry		equ	NERR_BASE+511
NERR_RplBadDatabase		equ	NERR_BASE+512
NERR_RplRplfilesShare		equ	NERR_BASE+513
NERR_RplNotRplServer		equ	NERR_BASE+514
NERR_RplCannotEnum		equ	NERR_BASE+515
NERR_RplWkstaInfoCorrupted	equ	NERR_BASE+516
NERR_RplWkstaNotFound		equ	NERR_BASE+517
NERR_RplWkstaNameUnavailable	equ	NERR_BASE+518
NERR_RplProfileInfoCorrupted	equ	NERR_BASE+519
NERR_RplProfileNotFound		equ	NERR_BASE+520
NERR_RplProfileNameUnavailable	equ	NERR_BASE+521
NERR_RplProfileNotEmpty		equ	NERR_BASE+522
NERR_RplConfigInfoCorrupted	equ	NERR_BASE+523
NERR_RplConfigNotFound		equ	NERR_BASE+524
NERR_RplAdapterInfoCorrupted	equ	NERR_BASE+525
NERR_RplInternal		equ	NERR_BASE+526
NERR_RplVendorInfoCorrupted	equ	NERR_BASE+527
NERR_RplBootInfoCorrupted	equ	NERR_BASE+528
NERR_RplWkstaNeedsUserAcct	equ	NERR_BASE+529
NERR_RplNeedsRPLUSERAcct	equ	NERR_BASE+530
NERR_RplBootNotFound		equ	NERR_BASE+531
NERR_RplIncompatibleProfile	equ	NERR_BASE+532
NERR_RplAdapterNameUnavailable	equ	NERR_BASE+533
NERR_RplConfigNotEmpty		equ	NERR_BASE+534
NERR_RplBootInUse		equ	NERR_BASE+535
NERR_RplBackupDatabase		equ	NERR_BASE+536
NERR_RplAdapterNotFound		equ	NERR_BASE+537
NERR_RplVendorNotFound		equ	NERR_BASE+538
NERR_RplVendorNameUnavailable	equ	NERR_BASE+539
NERR_RplBootNameUnavailable	equ	NERR_BASE+540
NERR_RplConfigNameUnavailable	equ	NERR_BASE+541
;
MAX_NERR			equ	NERR_BASE+899
;
;------------------------------------------------------------------------------
;
; =============================
; netware authentication states
; =============================
;
NWCC_AUTHENT_STATE_NONE			equ	0000h
NWCC_AUTHENT_STATE_BIND			equ	0001h
NWCC_AUTHENT_STATE_NDS			equ	0002h
;
;------------------------------------------------------------------------------
;
; ========================
; netware broadcast states
; ========================
;
NWCC_BCAST_PERMIT_ALL			equ	0000h
NWCC_BCAST_PERMIT_SYSTEM		equ	0001h
NWCC_BCAST_PERMIT_NONE			equ	0002h
NWCC_BCAST_PERMIT_POLL			equ	0003h
;
;------------------------------------------------------------------------------
;
; ==================
; netware info types
; ==================
;
NWCC_INFO_AUTHENT_STATE			equ	0001h
NWCC_INFO_BCAST_STATE			equ	0002h
NWCC_INFO_CONN_REF			equ	0003h
NWCC_INFO_TREE_NAME			equ	0004h
NWCC_INFO_CONN_NUMBER			equ	0005h
NWCC_INFO_USER_ID			equ	0006h
NWCC_INFO_SERVER_NAME			equ	0007h
NWCC_INFO_NDS_STATE			equ	0008h
NWCC_INFO_MAX_PACKET_SIZE		equ	0009h
NWCC_INFO_LICENSE_STATE			equ	0010h
NWCC_INFO_DISTANCE			equ	0011h
NWCC_INFO_SERVER_VERSION		equ	0012h
;
;------------------------------------------------------------------------------
;
; ====================
; netware name formats
; ====================
;
NWCC_NAME_FORMAT_NDS			equ	0001h
NWCC_NAME_FORMAT_BIND			equ	0002h
NWCC_NAME_FORMAT_PNW			equ	0004h
NWCC_NAME_FORMAT_NDS_TREE		equ	0008h
NWCC_NAME_FORMAT_WILD			equ	8000h
;
;------------------------------------------------------------------------------
;
; ==================
; netware nds states
; ==================
;
NWCC_NDS_NOT_CAPABLE			equ	0000h
NWCC_NDS_CAPABLE			equ	0001h
;
;------------------------------------------------------------------------------
;
; ===================
; netware open states
; ===================
;
NWCC_OPEN_LICENSED			equ	0001h
NWCC_OPEN_UNLICENSED			equ	0002h
;
;------------------------------------------------------------------------------
;
; ======================
; netware license states
; ======================
;
NWCC_NOT_LICENSED			equ	0000h
NWCC_CONNECTION_LICENSED		equ	0001h
NWCC_HANDLE_LICENSED			equ	0002h
;
;------------------------------------------------------------------------------
;
; ================================
; netware general completion codes
; ================================
;
NWCCODE_SUCCESSFUL			 equ	000000000h
NWCCODE_SUCCESS_CODE			 equ	000000000h
NWCCODE_UNDEFINED			 equ	00000FFFFh
;
;------------------------------------------------------------------------------
;
; ==================================
; netware requester completion codes
; ==================================
;
NWCCODE_ALREADY_ATTACHED		 equ	000008800h
NWCCODE_INVALID_CONNECTION		 equ	000008801h
NWCCODE_DRIVE_IN_USE			 equ	000008802h
NWCCODE_CANT_ADD_CDS			 equ	000008803h
NWCCODE_BAD_DRIVE_BASE			 equ	000008804h
NWCCODE_NET_RECV_ERROR			 equ	000008805h
NWCCODE_UNKNOWN_NET_ERROR		 equ	000008806h
NWCCODE_SERVER_INVALID_SLOT		 equ	000008807h
NWCCODE_NO_SERVER_SLOTS			 equ	000008808h
NWCCODE_SERVER_NO_ROUTE			 equ	00000880Ah
NWCCODE_BAD_LOCAL_TARGET		 equ	00000880Bh
NWCCODE_TOO_MANY_REQ_FRAGS		 equ	00000880Ch
NWCCODE_CONNECT_LIST_OVERFLOW		 equ	00000880Dh
NWCCODE_BUFFER_OVERFLOW			 equ	00000880Eh
NWCCODE_NO_CONNECTION_TO_SERVER		 equ	00000880Fh
NWCCODE_NO_ROUTER_FOUND			 equ	000008810h
NWCCODE_BAD_FUNC_ERROR			 equ	000008811h
NWCCODE_INVALID_SHELL_CALL		 equ	000008811h
NWCCODE_NO_MEMORY			 equ	00000881Ah
NWCCODE_NOT_SAME_CONNECTION		 equ	000008830h
NWCCODE_PRIMARY_CONNECTION_NOT_SET	 equ	000008831h
NWCCODE_INVALID_BUFFER_LENGTH		 equ	000008833h
NWCCODE_NO_USER_NAME			 equ	000008834h
NWCCODE_NO_NETWARE_PRINT_SPOOLER	 equ	000008835h
NWCCODE_INVALID_PARAMETER		 equ	000008836h
NWCCODE_CONFIG_FILE_OPEN_FAILED		 equ	000008837h
NWCCODE_NO_CONFIG_FILE			 equ	000008838h
NWCCODE_CONFIG_FILE_READ_FAILED		 equ	000008839h
NWCCODE_CONFIG_LINE_TOO_LONG		 equ	00000883Ah
NWCCODE_CONFIG_LINES_IGNORED		 equ	00000883Bh
NWCCODE_NOT_MY_RESOURCE			 equ	00000883Ch
NWCCODE_DAEMON_INSTALLED		 equ	00000883Dh
NWCCODE_SPOOLER_INSTALLED		 equ	00000883Eh
NWCCODE_CONNECTION_TABLE_FULL		 equ	00000883Fh
NWCCODE_CONFIG_SECTION_NOT_FOUND	 equ	000008840h
NWCCODE_INVALID_TRANSPORT_TYPE		 equ	000008841h
NWCCODE_TDS_TAG_IN_USE			 equ	000008842h
NWCCODE_TDS_OUT_OF_MEMORY		 equ	000008843h
NWCCODE_TDS_INVALID_TAG			 equ	000008844h
NWCCODE_TDS_WRITE_TRUNCATED		 equ	000008845h
NWCCODE_SERVICE_BUSY			 equ	000008846h
NWCCODE_NO_SERVER_ERROR			 equ	000008847h
NWCCODE_BAD_VLM_ERROR			 equ	000008848h
NWCCODE_NETWORK_DRIVE_IN_USE		 equ	000008849h
NWCCODE_LOCAL_DRIVE_IN_USE		 equ	00000884Ah
NWCCODE_NO_DRIVES_AVAILABLE		 equ	00000884Bh
NWCCODE_DEVICE_NOT_REDIRECTED		 equ	00000884Ch
NWCCODE_NO_MORE_SFT_ENTRIES		 equ	00000884Dh
NWCCODE_UNLOAD_ERROR			 equ	00000884Eh
NWCCODE_IN_USE_ERROR			 equ	00000884Fh
NWCCODE_TOO_MANY_REP_FRAGS		 equ	000008850h
NWCCODE_TABLE_FULL			 equ	000008851h
NWCCODE_SOCKET_NOT_OPEN			 equ	000008852h
NWCCODE_MEM_MGR_ERR			 equ	000008853h
NWCCODE_SFT3_ERROR			 equ	000008854h
NWCCODE_PREFERRED_NOT_FOUND		 equ	000008855h
NWCCODE_DEVICE_NOT_RECOGNIZED		 equ	000008856h
NWCCODE_BAD_NET_TYPE			 equ	000008857h
;
;------------------------------------------------------------------------------
;
; ===============================
; netware server completion codes
; ===============================
;
NWCCODE_FILE_IN_USE_ERROR		 equ	000008980h
NWCCODE_NO_MORE_FILE_HANDLES		 equ	000008981h
NWCCODE_NO_OPEN_PRIVILEGES		 equ	000008982h
NWCCODE_IO_ERROR_NETWORK_DISK		 equ	000008983h
NWCCODE_NO_CREATE_PRIVILEGES		 equ	000008984h
NWCCODE_NO_CREATE_DELETE_PRIVILEGES	 equ	000008985h
NWCCODE_CREATE_FILE_EXISTS_READ_ONLY	 equ	000008986h
NWCCODE_WILD_CARDS_IN_CREATE_FILE_NAME	 equ	000008987h
NWCCODE_INVALID_FILE_HANDLE		 equ	000008988h
NWCCODE_NO_SEARCH_PRIVILEGES		 equ	000008989h
NWCCODE_NO_DELETE_PRIVILEGES		 equ	00000898Ah
NWCCODE_NO_RENAME_PRIVILEGES		 equ	00000898Bh
NWCCODE_NO_MODIFY_PRIVILEGES		 equ	00000898Ch
NWCCODE_SOME_FILES_AFFECTED_IN_USE	 equ	00000898Dh
NWCCODE_NO_FILES_AFFECTED_IN_USE	 equ	00000898Eh
NWCCODE_SOME_FILES_AFFECTED_READ_ONLY	 equ	00000898Fh
NWCCODE_NO_FILES_AFFECTED_READ_ONLY	 equ	000008990h
NWCCODE_SOME_FILES_RENAMED_NAME_EXISTS	 equ	000008991h
NWCCODE_NO_FILES_RENAMED_NAME_EXISTS	 equ	000008992h
NWCCODE_NO_READ_PRIVILEGES		 equ	000008993h
NWCCODE_NO_WRITE_PRIVILEGES_OR_READ_ONLY equ	000008994h
NWCCODE_FILE_DETACHED			 equ	000008995h
NWCCODE_SERVER_OUT_OF_MEMORY		 equ	000008996h
NWCCODE_NO_DISK_SPACE_FOR_SPOOL_FILE	 equ	000008997h
NWCCODE_VOLUME_DOES_NOT_EXIST		 equ	000008998h
NWCCODE_DIRECTORY_FULL			 equ	000008999h
NWCCODE_RENAMING_ACROSS_VOLUMES		 equ	00000899Ah
NWCCODE_BAD_DIRECTORY_HANDLE		 equ	00000899Bh
NWCCODE_INVALID_PATH			 equ	00000899Ch
NWCCODE_NO_MORE_TRUSTEES		 equ	00000899Ch
NWCCODE_NO_MORE_ENTRIES			 equ	00000899Ch
NWCCODE_NO_MORE_DIRECTORY_HANDLES	 equ	00000899Dh
NWCCODE_INVALID_FILENAME		 equ	00000899Eh
NWCCODE_DIRECTORY_ACTIVE		 equ	00000899Fh
NWCCODE_DIRECTORY_NOT_EMPTY		 equ	0000089A0h
NWCCODE_DIRECTORY_IO_ERROR		 equ	0000089A1h
NWCCODE_READ_FILE_WITH_RECORD_LOCKED	 equ	0000089A2h
NWCCODE_LOGIN_DENIED_NO_ACCOUNT_BALANCE	 equ	0000089C1h
NWCCODE_LOGIN_DENIED_NO_CREDIT		 equ	0000089C2h
NWCCODE_INTRUDER_DETECTION_LOCK		 equ	0000089C5h
NWCCODE_NO_CONSOLE_OPERATOR		 equ	0000089C6h
NWCCODE_PASSWORD_NOT_UNIQUE		 equ	0000089D7h
NWCCODE_PASSWORD_TOO_SHORT		 equ	0000089D8h
NWCCODE_LOGIN_DENIED_NO_CONNECTION	 equ	0000089D9h
NWCCODE_UNAUTHORIZED_LOGIN_TIME		 equ	0000089DAh
NWCCODE_UNAUTHORIZED_LOGIN_STATION	 equ	0000089DBh
NWCCODE_ACCOUNT_DISABLED		 equ	0000089DCh
NWCCODE_PASSWORD_HAS_EXPIRED_NO_GRACE	 equ	0000089DEh
NWCCODE_PASSWORD_HAS_EXPIRED		 equ	0000089DFh
NWCCODE_NOT_ITEM_PROPERTY		 equ	0000089E8h
NWCCODE_WRITE_PROPERTY_TO_GROUP		 equ	0000089E8h
NWCCODE_MEMBER_ALREADY_EXISTS		 equ	0000089E9h
NWCCODE_NO_SUCH_MEMBER			 equ	0000089EAh
NWCCODE_NOT_GROUP_PROPERTY		 equ	0000089EBh
NWCCODE_NO_SUCH_SEGMENT			 equ	0000089ECh
NWCCODE_PROPERTY_ALREADY_EXISTS		 equ	0000089EDh
NWCCODE_OBJECT_ALREADY_EXISTS		 equ	0000089EEh
NWCCODE_INVALID_NAME			 equ	0000089EFh
NWCCODE_WILD_CARD_NOT_ALLOWED		 equ	0000089F0h
NWCCODE_INVALID_BINDERY_SECURITY	 equ	0000089F1h
NWCCODE_NO_OBJECT_READ_PRIVILEGE	 equ	0000089F2h
NWCCODE_NO_OBJECT_RENAME_PRIVILEGE	 equ	0000089F3h
NWCCODE_NO_OBJECT_DELETE_PRIVILEGE	 equ	0000089F4h
NWCCODE_NO_OBJECT_CREATE_PRIVILEGE	 equ	0000089F5h
NWCCODE_NO_PROPERTY_DELETE_PRIVILEGE	 equ	0000089F6h
NWCCODE_NO_PROPERTY_CREATE_PRIVILEGE	 equ	0000089F7h
NWCCODE_TARGET_DRIVE_NOT_LOCAL		 equ	0000089F7h
NWCCODE_ALREADY_ATTACHED_TO_SERVER	 equ	0000089F8h
NWCCODE_NO_PROPERTY_WRITE_PRIVILEGE	 equ	0000089F8h
NWCCODE_NOT_ATTACHED_TO_SERVER		 equ	0000089F8h
NWCCODE_NO_FREE_CONNECTION_SLOTS	 equ	0000089F9h
NWCCODE_NO_PROPERTY_READ_PRIVILEGE	 equ	0000089F9h
NWCCODE_NO_MORE_SERVER_SLOTS		 equ	0000089FAh
NWCCODE_TEMP_REMAP_ERROR		 equ	0000089FAh
NWCCODE_INVALID_PARAMETERS		 equ	0000089FBh
NWCCODE_NO_SUCH_PROPERTY		 equ	0000089FBh
NWCCODE_ACCESS_DENIED			 equ	0000089FBh
NWCCODE_INTERNET_PACKET_REQT_CANCELED	 equ	0000089FCh
NWCCODE_UNKNOWN_FILE_SERVER		 equ	0000089FCh
NWCCODE_MESSAGE_QUEUE_FULL		 equ	0000089FCh
NWCCODE_NO_SUCH_OBJECT			 equ	0000089FCh
NWCCODE_BAD_STATION_NUMBER		 equ	0000089FDh
NWCCODE_INVALID_PACKET_LENGTH		 equ	0000089FDh
NWCCODE_UNKNOWN_REQUEST			 equ	0000089FDh
NWCCODE_BINDERY_LOCKED			 equ	0000089FEh
NWCCODE_TRUSTEE_NOT_FOUND		 equ	0000089FEh
NWCCODE_DIRECTORY_LOCKED		 equ	0000089FEh
NWCCODE_INVALID_SEMAPHORE_NAME_LENGTH	 equ	0000089FEh
NWCCODE_PACKET_NOT_DELIVERABLE		 equ	0000089FEh
NWCCODE_SERVER_BINDERY_LOCKED		 equ	0000089FEh
NWCCODE_SOCKET_TABLE_FULL		 equ	0000089FEh
NWCCODE_SPOOL_DIRECTORY_ERROR		 equ	0000089FEh
NWCCODE_SUPERVISOR_HAS_DISABLED_LOGIN	 equ	0000089FEh
NWCCODE_TIMEOUT_FAILURE			 equ	0000089FEh
NWCCODE_BAD_PRINTER_ERROR		 equ	0000089FFh
NWCCODE_BAD_RECORD_OFFSET		 equ	0000089FFh
NWCCODE_CLOSE_FCB_ERROR			 equ	0000089FFh
NWCCODE_FILE_EXTENSION_ERROR		 equ	0000089FFh
NWCCODE_FILE_NAME_ERROR			 equ	0000089FFh
NWCCODE_HARDWARE_FAILURE		 equ	0000089FFh
NWCCODE_INVALID_DRIVE_NUMBER		 equ	0000089FFh
NWCCODE_DOS_INVALID_DRIVE		 equ	0000089FFh
NWCCODE_INVALID_INITIAL_SEMAPHORE_VALUE	 equ	0000089FFh
NWCCODE_INVALID_SEMAPHORE_HANDLE	 equ	0000089FFh
NWCCODE_IO_BOUND_ERROR			 equ	0000089FFh
NWCCODE_NO_FILES_FOUND_ERROR		 equ	0000089FFh
NWCCODE_NO_RESPONSE_FROM_SERVER		 equ	0000089FFh
NWCCODE_NO_SUCH_OBJECT_OR_BAD_PASSWORD	 equ	0000089FFh
NWCCODE_PATH_NOT_LOCATABLE		 equ	0000089FFh
NWCCODE_QUEUE_FULL_ERROR		 equ	0000089FFh
NWCCODE_SOCKET_ALREADY_OPEN		 equ	0000089FFh
NWCCODE_LOCK_ERROR			 equ	0000089FFh
;
;------------------------------------------------------------------------------
;
; =================
; object attributes
; =================
;
OBJ_INHERIT			equ	00000002h
OBJ_PERMANENT			equ	00000010h
OBJ_EXCLUSIVE			equ	00000020h
OBJ_CASE_INSENSITIVE		equ	00000040h
OBJ_OPENIF			equ	00000080h
OBJ_VALID_ATTRIBUTES		equ	000000F2h
;
;------------------------------------------------------------------------------
;
; ==================
; owner draw actions
; ==================
;
ODA_DRAWENTIRE			equ	0001h
ODA_SELECT			equ	0002h
ODA_FOCUS			equ	0004h
;
;------------------------------------------------------------------------------
;
; =================
; owner draw states
; =================
;
ODS_SELECTED			equ	0001h
ODS_GRAYED			equ	0002h
ODS_DISABLED			equ	0004h
ODS_CHECKED			equ	0008h
ODS_FOCUS			equ	0010h
ODS_DEFAULT			equ	0020h
ODS_COMBOBOXEDIT		equ	1000h
;
;------------------------------------------------------------------------------
;
; ================
; owner draw types
; ================
;
ODT_MENU			equ	1
ODT_LISTBOX			equ	2
ODT_COMBOBOX			equ	3
ODT_BUTTON			equ	4
ODT_STATIC			equ	5
;
;------------------------------------------------------------------------------
;
; ==================
; OPENFILENAME flags
; ==================
;
OFN_READONLY			equ	00000001h
OFN_OVERWRITEPROMPT		equ	00000002h
OFN_HIDEREADONLY		equ	00000004h
OFN_NOCHANGEDIR			equ	00000008h
OFN_SHOWHELP			equ	00000010h
OFN_ENABLEHOOK			equ	00000020h
OFN_ENABLETEMPLATE		equ	00000040h
OFN_ENABLETEMPLATEHANDLE	equ	00000080h
OFN_NOVALIDATE			equ	00000100h
OFN_ALLOWMULTISELECT		equ	00000200h
OFN_EXTENSIONDIFFERENT		equ	00000400h
OFN_PATHMUSTEXIST		equ	00000800h
OFN_FILEMUSTEXIST		equ	00001000h
OFN_CREATEPROMPT		equ	00002000h
OFN_SHAREAWARE			equ	00004000h
OFN_NOREADONLYRETURN		equ	00008000h
OFN_NOTESTFILECREATE		equ	00010000h
OFN_NONETWORKBUTTON		equ	00020000h
OFN_NOLONGNAMES			equ	00040000h
OFN_EXPLORER			equ	00080000h
OFN_NODEREFERENCELINKS		equ	00100000h
OFN_LONGNAMES			equ	00200000h
;
;------------------------------------------------------------------------------
;
; ==============================
; OPENFILENAME hook return codes
; ==============================
;
OFN_SHAREWARN			equ	0
OFN_SHARENOWARN			equ	1
OFN_SHAREFALLTHROUGH		equ	2
;
;------------------------------------------------------------------------------
;
; ====================
; netware object types
; ====================
;
OT_UNKNOWN			equ	0000h
OT_USER				equ	0001h
OT_USER_GROUP			equ	0002h
OT_PRINT_QUEUE			equ	0003h
OT_FILE_SERVER			equ	0004h
OT_JOB_SERVER			equ	0005h
OT_GATEWAY			equ	0006h
OT_PRINT_SERVER			equ	0007h
OT_ARCHIVE_QUEUE		equ	0008h
OT_ARCHIVE_SERVER		equ	0009h
OT_JOB_QUEUE			equ	000Ah
OT_ADMINISTRATION		equ	000Bh
OT_NAS_SNA_GATEWAY		equ	0021h
OT_REMOTE_BRIDGE_SERVER		equ	0026h
OT_TCPIP_GATEWAY		equ	0027h
;
OT_TIME_SYNCHRONIZATION_SERVER	equ	002Dh
OT_ARCHIVE_SERVER_DYNAMIC_SAP	equ	002Eh
OT_ADVERTISING_PRINT_SERVER	equ	0047h
OT_NETWARE_SQL			equ	004Ch
OT_BTRIEVE_VAP			equ	0050h
OT_PRINT_QUEUE_USER		equ	0053h
;
OT_WILD				equ	0FFFFh
;
;------------------------------------------------------------------------------
;
; ====================
; ip protocol families
; ====================
;
PF_UNSPEC			equ	AF_UNSPEC
PF_UNIX				equ	AF_UNIX
PF_INET				equ	AF_INET
PF_IMPLINK			equ	AF_IMPLINK
PF_PUP				equ	AF_PUP
PF_CHAOS			equ	AF_CHAOS
PF_NS				equ	AF_NS
PF_IPX				equ	AF_IPX
PF_ISO				equ	AF_ISO
PF_OSI				equ	AF_OSI
PF_ECMA				equ	AF_ECMA
PF_DATAKIT			equ	AF_DATAKIT
PF_CCITT			equ	AF_CCITT
PF_SNA				equ	AF_SNA
PF_DECnet			equ	AF_DECnet
PF_DLI				equ	AF_DLI
PF_LAT				equ	AF_LAT
PF_HYLINK			equ	AF_HYLINK
PF_APPLETALK			equ	AF_APPLETALK
PF_VOICEVIEW			equ	AF_VOICEVIEW
PF_FIREFOX			equ	AF_FIREFOX
PF_UNKNOWN1			equ	AF_UNKNOWN1
PF_BAN				equ	AF_BAN
;
PF_MAX				equ	AF_MAX
;
;------------------------------------------------------------------------------
;
; ================
; pipe definitions
; ================
;
PIPE_ACCESS_INBOUND		equ	00000001h
PIPE_ACCESS_OUTBOUND		equ	00000002h
PIPE_ACCESS_DUPLEX		equ	00000003h
;
PIPE_CLIENT_END			equ	00000000h
PIPE_SERVER_END			equ	00000001h
;
PIPE_WAIT			equ	00000000h
PIPE_NOWAIT			equ	00000001h
;
PIPE_READMODE_BYTE		equ	00000000h
PIPE_READMODE_MESSAGE		equ	00000002h
;
PIPE_TYPE_BYTE			equ	00000000h
PIPE_TYPE_MESSAGE		equ	00000004h
;
PIPE_UNLIMITED_INSTANCES	equ	255
;
;------------------------------------------------------------------------------
;
; ====================
; process access flags
; ====================
;
PROCESS_TERMINATE		equ	0001h
PROCESS_CREATE_THREAD		equ	0002h
PROCESS_VM_OPERATION		equ	0008h
PROCESS_VM_READ			equ	0010h
PROCESS_VM_WRITE		equ	0020h
PROCESS_DUP_HANDLE		equ	0040h
PROCESS_CREATE_PROCESS		equ	0080h
PROCESS_SET_QUOTA		equ	0100h
PROCESS_SET_INFORMATION		equ	0200h
PROCESS_QUERY_INFORMATION	equ	0400h
;
PROCESS_ALL_ACCESS		equ	STANDARD_RIGHTS_REQUIRED+\
					SYNCHRONIZE+\
					0FFFh
;
;------------------------------------------------------------------------------
;
; ========================
; binary raster operations
; ========================
;
R2_BLACK			equ	 1		;0
R2_NOTMERGEPEN			equ	 2		;DPon
R2_MASKNOTPEN			equ	 3		;DPna
R2_NOTCOPYPEN			equ	 4		;PN
R2_MASKPENNOT			equ	 5		;PDna
R2_NOT				equ	 6		;Dn
R2_XORPEN			equ	 7		;DPx
R2_NOTMASKPEN			equ	 8		;DPan
R2_MASKPEN			equ	 9		;DPa
R2_NOTXORPEN			equ	10		;DPxn
R2_NOP				equ	11		;D
R2_MERGENOTPEN			equ	12		;DPno
R2_COPYPEN			equ	13		;P
R2_MERGEPENNOT			equ	14		;PDno
R2_MERGEPEN			equ	15		;DPo
R2_WHITE			equ	16		;1
R2_LAST				equ	16
;
;------------------------------------------------------------------------------
;
; =================
; network resources
; =================
;
RESOURCE_CONNECTED		equ	00000001h
RESOURCE_GLOBALNET		equ	00000002h
RESOURCE_REMEMBERED		equ	00000003h
RESOURCE_RECENT			equ	00000004h
RESOURCE_CONTEXT		equ	00000005h
;
RESOURCETYPE_ANY		equ	00000000h
RESOURCETYPE_DISK		equ	00000001h
RESOURCETYPE_PRINT		equ	00000002h
RESOURCETYPE_RESERVED		equ	00000008h
RESOURCETYPE_UNKNOWN		equ	-1
;
RESOURCEUSAGE_CONNECTABLE	equ	00000001h
RESOURCEUSAGE_CONTAINER		equ	00000002h
RESOURCEUSAGE_NOLOCALDEVICE	equ	00000004h
RESOURCEUSAGE_SIBLING		equ	00000008h
RESOURCEUSAGE_RESERVED		equ	80000000h
;
RESOURCEUSAGE_ALL		equ	RESOURCEUSAGE_CONNECTABLE+\
					RESOURCEUSAGE_CONTAINER
;
RESOURCEDISPLAYTYPE_GENERIC	equ	00000000h
RESOURCEDISPLAYTYPE_DOMAIN	equ	00000001h
RESOURCEDISPLAYTYPE_SERVER	equ	00000002h
RESOURCEDISPLAYTYPE_SHARE	equ	00000003h
RESOURCEDISPLAYTYPE_FILE	equ	00000004h
RESOURCEDISPLAYTYPE_GROUP	equ	00000005h
RESOURCEDISPLAYTYPE_NETWORK	equ	00000006h
RESOURCEDISPLAYTYPE_ROOT	equ	00000007h
RESOURCEDISPLAYTYPE_SHAREADMIN	equ	00000008h
RESOURCEDISPLAYTYPE_DIRECTORY	equ	00000009h
RESOURCEDISPLAYTYPE_TREE	equ	0000000Ah
;
;------------------------------------------------------------------------------
;
; ==========
; rgb colors
; ==========
;
RGB_BLACK			equ	00000000h
RGB_VDKGRAY32			equ	00202020h
RGB_DKGRAY			equ	00404040h
RGB_SOLIDGRAY			equ	00808080h
RGB_SOLIDLTGRAY			equ	00C0C0C0h
RGB_EBONY			equ	00E0E0E0h
RGB_BLUE			equ	00FF0000h
RGB_GREEN			equ	0000FF00h
RGB_RED				equ	000000FFh
;
RGB_CYAN			equ	RGB_BLUE + RGB_GREEN
RGB_MAGENTA			equ	RGB_BLUE             + RGB_RED
RGB_YELLOW			equ	           RGB_GREEN + RGB_RED
RGB_WHITE			equ	RGB_BLUE + RGB_GREEN + RGB_RED
;
RGB_DKBLUE			equ	00800000h
RGB_DKGREEN			equ	00008000h
RGB_DKRED			equ	00000080h
;
RGB_DKCYAN			equ	RGB_DKBLUE + RGB_DKGREEN
RGB_DKMAGENTA			equ	RGB_DKBLUE               + RGB_DKRED
RGB_DKYELLOW			equ	             RGB_DKGREEN + RGB_DKRED
;
;------------------------------------------------------------------------------
;
; ===================
; CombineRgn() styles
; ===================
;
RGN_AND				equ	1
RGN_OR				equ	2
RGN_XOR				equ	3
RGN_DIFF			equ	4
RGN_COPY			equ	5
RGN_MIN				equ	RGN_AND
RGN_MAX				equ	RGN_COPY
;
;------------------------------------------------------------------------------
;
; ====================
; scroll bar constants
; ====================
;
SB_HORZ				equ	0
SB_VERT				equ	1
SB_CTL				equ	2
SB_BOTH				equ	3
;
;------------------------------------------------------------------------------
;
; ===================
; scroll bar commands
; ===================
;
SB_LINEUP			equ	0
SB_LINELEFT			equ	0
SB_LINEDOWN			equ	1
SB_LINERIGHT			equ	1
SB_PAGEUP			equ	2
SB_PAGELEFT			equ	2
SB_PAGEDOWN			equ	3
SB_PAGERIGHT			equ	3
SB_THUMBPOSITION		equ	4
SB_THUMBTRACK			equ	5
SB_TOP				equ	6
SB_LEFT				equ	6
SB_BOTTOM			equ	7
SB_RIGHT			equ	7
SB_ENDSCROLL			equ	8
;
;------------------------------------------------------------------------------
;
; ===================
; status bar messages
; ===================
;
SB_SETTEXTA			equ	WM_USER+01
SB_GETTEXTA			equ	WM_USER+02
SB_GETTEXTLENGTHA		equ	WM_USER+03
SB_SETPARTS			equ	WM_USER+04
SB_GETPARTS			equ	WM_USER+06
SB_GETBORDERS			equ	WM_USER+07
SB_SETMINHEIGHT			equ	WM_USER+08
SB_SIMPLE			equ	WM_USER+09
SB_GETRECT			equ	WM_USER+10
SB_SETTEXTW			equ	WM_USER+11
SB_GETTEXTLENGTHW		equ	WM_USER+12
SB_GETTEXTW			equ	WM_USER+13
;
				if	UNICODE
SB_GETTEXT			equ	SB_GETTEXTW
SB_SETTEXT			equ	SB_SETTEXTW
SB_GETTEXTLENGTH		equ	SB_GETTEXTLENGTHW
				else
SB_GETTEXT			equ	SB_GETTEXTA
SB_SETTEXT			equ	SB_SETTEXTA
SB_GETTEXTLENGTH		equ	SB_GETTEXTLENGTHA
				endif
;
;------------------------------------------------------------------------------
;
; ===================
; scroll bar messages
; ===================
;
SBM_SETPOS			equ	00E0h
SBM_GETPOS			equ	00E1h
SBM_SETRANGE			equ	00E2h
SBM_GETRANGE			equ	00E3h
SBM_ENABLE_ARROWS		equ	00E4h
SBM_SETRANGEREDRAW		equ	00E6h
SBM_SETSCROLLINFO		equ	00E9h
SBM_GETSCROLLINFO		equ	00EAh
;
;------------------------------------------------------------------------------
;
; =================
; scroll bar styles
; =================
;
SBS_HORZ			equ	0000h
SBS_VERT			equ	0001h
SBS_TOPALIGN			equ	0002h
SBS_LEFTALIGN			equ	0002h
SBS_BOTTOMALIGN			equ	0004h
SBS_RIGHTALIGN			equ	0004h
SBS_SIZEBOXTOPLEFTALIGN		equ	0002h
SBS_SIZEBOXBOTTOMRIGHTALIGN	equ	0004h
SBS_SIZEBOX			equ	0008h
SBS_SIZEGRIP			equ	0010h
;
;------------------------------------------------------------------------------
;
; ================
; status bar types
; ================
;
SBT_DEFAULT			equ	0000h
SBT_NOBORDERS			equ	0100h
SBT_POPOUT			equ	0200h
SBT_RTLREADING			equ	0400h
SBT_OWNERDRAW			equ	1000h
;
;------------------------------------------------------------------------------
;
; ===================
; security attributes
; ===================
;
SECURITY_ANONYMOUS		equ	00000000h
SECURITY_IDENTIFICATION		equ	00010000h
SECURITY_IMPERSONATION		equ	00020000h
SECURITY_DELEGATION		equ	00030000h
;
SECURITY_CONTEXT_TRACKING	equ	00040000h
SECURITY_EFFECTIVE_ONLY		equ	00080000h
;
SECURITY_SQOS_PRESENT		equ	00100000h
SECURITY_VALID_SQOS_FLAGS	equ	001F0000h
;
;------------------------------------------------------------------------------
;
; =====================
; WM_SIZE wParam values
; =====================
;
SIZE_RESTORED			equ	0
SIZE_MINIMIZED			equ	1
SIZE_MAXIMIZED			equ	2
SIZE_MAXSHOW			equ	3
SIZE_MAXHIDE			equ	4
;
SIZENORMAL			equ	SIZE_RESTORED
SIZEICONIC			equ	SIZE_MINIMIZED
SIZEFULLSCREEN			equ	SIZE_MAXIMIZED
SIZEZOOMSHOW			equ	SIZE_MAXSHOW
SIZEZOOMHIDE			equ	SIZE_MAXHIDE
;
;------------------------------------------------------------------------------
;
; ========================
; GetSystemMetrics() codes
; ========================
;
SM_CXSCREEN			equ	 0
SM_CYSCREEN			equ	 1
SM_CXVSCROLL			equ	 2
SM_CYHSCROLL			equ	 3
SM_CYCAPTION			equ	 4
SM_CXBORDER			equ	 5
SM_CYBORDER			equ	 6
SM_CXDLGFRAME			equ	 7
SM_CYDLGFRAME			equ	 8
SM_CYVTHUMB			equ	 9
SM_CXHTHUMB			equ	10
SM_CXICON			equ	11
SM_CYICON			equ	12
SM_CXCURSOR			equ	13
SM_CYCURSOR			equ	14
SM_CYMENU			equ	15
SM_CXFULLSCREEN			equ	16
SM_CYFULLSCREEN			equ	17
SM_CYKANJIWINDOW		equ	18
SM_MOUSEPRESENT			equ	19
SM_CYVSCROLL			equ	20
SM_CXHSCROLL			equ	21
SM_DEBUG			equ	22
SM_SWAPBUTTON			equ	23
SM_RESERVED1			equ	24
SM_RESERVED2			equ	25
SM_RESERVED3			equ	26
SM_RESERVED4			equ	27
SM_CXMIN			equ	28
SM_CYMIN			equ	29
SM_CXSIZE			equ	30
SM_CYSIZE			equ	31
SM_CXFRAME			equ	32
SM_CYFRAME			equ	33
SM_CXMINTRACK			equ	34
SM_CYMINTRACK			equ	35
SM_CXDOUBLECLK			equ	36
SM_CYDOUBLECLK			equ	37
SM_CXICONSPACING		equ	38
SM_CYICONSPACING		equ	39
SM_MENUDROPALIGNMENT		equ	40
SM_PENWINDOWS			equ	41
SM_DBCSENABLED			equ	42
SM_CMOUSEBUTTONS		equ	43
SM_SECURE			equ	44
SM_CXEDGE			equ	45
SM_CYEDGE			equ	46
SM_CXMINSPACING			equ	47
SM_CYMINSPACING			equ	48
SM_CXSMICON			equ	49
SM_CYSMICON			equ	50
SM_CYSMCAPTION			equ	51
SM_CXSMSIZE			equ	52
SM_CYSMSIZE			equ	53
SM_CXMENUSIZE			equ	54
SM_CYMENUSIZE			equ	55
SM_ARRANGE			equ	56
SM_CXMINIMIZED			equ	57
SM_CYMINIMIZED			equ	58
SM_CXMAXTRACK			equ	59
SM_CYMAXTRACK			equ	60
SM_CXMAXIMIZED			equ	61
SM_CYMAXIMIZED			equ	62
SM_NETWORK			equ	63
SM_CLEANBOOT			equ	67
SM_CXDRAG			equ	68
SM_CYDRAG			equ	69
SM_SHOWSOUNDS			equ	70
SM_CXMENUCHECK			equ	71
SM_CYMENUCHECK			equ	72
SM_SLOWMACHINE			equ	73
SM_MIDEASTENABLED		equ	74
;
SM_CXFIXEDFRAME			equ	SM_CXDLGFRAME
SM_CYFIXEDFRAME			equ	SM_CYDLGFRAME
SM_CXSIZEFRAME			equ	SM_CXFRAME
SM_CYSIZEFRAME			equ	SM_CYFRAME
;
;------------------------------------------------------------------------------
;
; ==============
; socket options
; ==============
;
SO_DEBUG			equ	0001h
SO_ACCEPTCONN			equ	0002h
SO_REUSEADDR			equ	0004h
SO_KEEPALIVE			equ	0008h
SO_DONTROUTE			equ	0010h
SO_BROADCAST			equ	0020h
SO_USELOOPBACK			equ	0040h
SO_LINGER			equ	0080h
SO_OOBINLINE			equ	0100h
;
SO_DONTLINGER			equ	not SO_LINGER
;
SO_SNDBUF			equ	1001h
SO_RCVBUF			equ	1002h
SO_SNDLOWAT			equ	1003h
SO_RCVLOWAT			equ	1004h
SO_SNDTIMEO			equ	1005h
SO_RCVTIMEO			equ	1006h
SO_ERROR			equ	1007h
SO_TYPE				equ	1008h
;
SO_CONNDATA			equ	7000h
SO_CONNOPT			equ	7001h
SO_DISCDATA			equ	7002h
SO_DISCOPT			equ	7003h
SO_CONNDATALEN			equ	7004h
SO_CONNOPTLEN			equ	7005h
SO_DISCDATALEN			equ	7006h
SO_DISCOPTLEN			equ	7007h
SO_OPENTYPE			equ	7008h
SO_MAXDG			equ	7009h
SO_MAXPATHDG			equ	700Ah
SO_UPDATE_ACCEPT_CONTEXT	equ	700Bh
SO_CONNECT_TIME			equ	700Ch
;
SO_SYNCHRONOUS_ALERT		equ	0010h
SO_SYNCHRONOUS_NONALERT		equ	0020h
;
SOL_SOCKET			equ	0FFFFh
;
;------------------------------------------------------------------------------
;
; ============
; socket types
; ============
;
SOCK_STREAM			equ	 1
SOCK_DGRAM			equ	 2
SOCK_RAW			equ	 3
SOCK_RDM			equ	 4
SOCK_SEQPACKET			equ	 5
;
INVALID_SOCKET			equ	-1
SOCKET_ERROR			equ	-1
;
;------------------------------------------------------------------------------
;
; =====================
; static control styles
; =====================
;
SS_LEFT				equ	0000h
SS_CENTER			equ	0001h
SS_RIGHT			equ	0002h
SS_ICON				equ	0003h
SS_BLACKRECT			equ	0004h
SS_GRAYRECT			equ	0005h
SS_WHITERECT			equ	0006h
SS_BLACKFRAME			equ	0007h
SS_GRAYFRAME			equ	0008h
SS_WHITEFRAME			equ	0009h
SS_USERITEM			equ	000Ah
SS_SIMPLE			equ	000Bh
SS_LEFTNOWORDWRAP		equ	000Ch
SS_BITMAP			equ	000Eh
SS_OWNERDRAW			equ	000Dh
SS_ENHMETAFILE			equ	000Fh
SS_ETCHEDHORZ			equ	0010h
SS_ETCHEDVERT			equ	0011h
SS_ETCHEDFRAME			equ	0012h
SS_TYPEMASK			equ	001Fh
SS_NOPREFIX			equ	0080h
SS_NOTIFY			equ	0100h
SS_CENTERIMAGE			equ	0200h
SS_RIGHTJUST			equ	0400h
SS_REALSIZEIMAGE		equ	0800h
SS_SUNKEN			equ	1000h
;
;------------------------------------------------------------------------------
;
; ================
; startup commands
; ================
;
STARTF_USESHOWWINDOW		equ	00000001h
STARTF_USESIZE			equ	00000002h
STARTF_USEPOSITION		equ	00000004h
STARTF_USECOUNTCHARS		equ	00000008h
STARTF_USEFILLATTRIBUTE		equ	00000010h
STARTF_RUNFULLSCREEN		equ	00000020h	;ignored for non-x86
STARTF_FORCEONFEEDBACK		equ	00000040h
STARTF_FORCEOFFFEEDBACK		equ	00000080h
STARTF_USESTDHANDLES		equ	00000100h
STARTF_USEHOTKEY		equ	00000200h
;
;------------------------------------------------------------------------------
;
; ============
; status codes
; ============
;
STATUS_SEVERITY_SUCCESS			 equ	000000000h
STATUS_SEVERITY_INFORMATIONAL		 equ	040000000h
STATUS_SEVERITY_WARNING			 equ	080000000h
STATUS_SEVERITY_ERROR			 equ	0C0000000h
STATUS_SEVERITY_MASK			 equ	0C0000000h
;
FACILITY_RPC_RUNTIME			 equ	000020000h
FACILITY_RPC_STUBS			 equ	000030000h
FACILITY_IO_ERROR_CODE			 equ	000040000h
FACILITY_MASK				 equ	00FFF0000h
;
STATUS_UNDEFINED			 equ	0FFFFFFFFh
;
STATUS_SUCCESS				 equ	000000000h
STATUS_WAIT_0				 equ	000000000h
STATUS_WAIT_1				 equ	000000001h
STATUS_WAIT_2				 equ	000000002h
STATUS_WAIT_3				 equ	000000003h
STATUS_WAIT_63				 equ	00000003Fh
STATUS_ABANDONED			 equ	000000080h
STATUS_ABANDONED_WAIT_0			 equ	000000080h
STATUS_ABANDONED_WAIT_63		 equ	0000000BFh
STATUS_USER_APC				 equ	0000000C0h
STATUS_KERNEL_APC			 equ	000000100h
STATUS_ALERTED				 equ	000000101h
STATUS_TIMEOUT				 equ	000000102h
STATUS_PENDING				 equ	000000103h
STATUS_REPARSE				 equ	000000104h
STATUS_MORE_ENTRIES			 equ	000000105h
STATUS_NOT_ALL_ASSIGNED			 equ	000000106h
STATUS_SOME_NOT_MAPPED			 equ	000000107h
STATUS_OPLOCK_BREAK_IN_PROGRESS		 equ	000000108h
STATUS_VOLUME_MOUNTED			 equ	000000109h
STATUS_RXACT_COMMITTED			 equ	00000010Ah
STATUS_NOTIFY_CLEANUP			 equ	00000010Bh
STATUS_NOTIFY_ENUM_DIR			 equ	00000010Ch
STATUS_NO_QUOTAS_FOR_ACCOUNT		 equ	00000010Dh
STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED	 equ	00000010Eh
STATUS_PAGE_FAULT_TRANSITION		 equ	000000110h
STATUS_PAGE_FAULT_DEMAND_ZERO		 equ	000000111h
STATUS_PAGE_FAULT_COPY_ON_WRITE		 equ	000000112h
STATUS_PAGE_FAULT_GUARD_PAGE		 equ	000000113h
STATUS_PAGE_FAULT_PAGING_FILE		 equ	000000114h
STATUS_CACHE_PAGE_LOCKED		 equ	000000115h
STATUS_CRASH_DUMP			 equ	000000116h
STATUS_BUFFER_ALL_ZEROS			 equ	000000117h
;
STATUS_OBJECT_NAME_EXISTS		 equ	040000000h
STATUS_THREAD_WAS_SUSPENDED		 equ	040000001h
STATUS_WORKING_SET_LIMIT_RANGE		 equ	040000002h
STATUS_IMAGE_NOT_AT_BASE		 equ	040000003h
STATUS_RXACT_STATE_CREATED		 equ	040000004h
STATUS_SEGMENT_NOTIFICATION		 equ	040000005h
STATUS_LOCAL_USER_SESSION_KEY		 equ	040000006h
STATUS_BAD_CURRENT_DIRECTORY		 equ	040000007h
STATUS_SERIAL_MORE_WRITES		 equ	040000008h
STATUS_REGISTRY_RECOVERED		 equ	040000009h
STATUS_FT_READ_RECOVERY_FROM_BACKUP	 equ	04000000Ah
STATUS_FT_WRITE_RECOVERY		 equ	04000000Bh
STATUS_SERIAL_COUNTER_TIMEOUT		 equ	04000000Ch
STATUS_NULL_LM_PASSWORD			 equ	04000000Dh
STATUS_IMAGE_MACHINE_TYPE_MISMATCH	 equ	04000000Eh
STATUS_RECEIVE_PARTIAL			 equ	04000000Fh
STATUS_RECEIVE_EXPEDITED		 equ	040000010h
STATUS_RECEIVE_PARTIAL_EXPEDITED	 equ	040000011h
STATUS_EVENT_DONE			 equ	040000012h
STATUS_EVENT_PENDING			 equ	040000013h
STATUS_CHECKING_FILE_SYSTEM		 equ	040000014h
STATUS_FATAL_APP_EXIT			 equ	040000015h
STATUS_PREDEFINED_HANDLE		 equ	040000016h
STATUS_WAS_UNLOCKED			 equ	040000017h
STATUS_SERVICE_NOTIFICATION		 equ	040000018h
STATUS_WAS_LOCKED			 equ	040000019h
STATUS_LOG_HARD_ERROR			 equ	04000001Ah
STATUS_ALREADY_WIN32			 equ	04000001Bh
;
STATUS_GUARD_PAGE_VIOLATION		 equ	080000001h
STATUS_DATATYPE_MISALIGNMENT		 equ	080000002h
STATUS_BREAKPOINT			 equ	080000003h
STATUS_SINGLE_STEP			 equ	080000004h
STATUS_BUFFER_OVERFLOW			 equ	080000005h
STATUS_NO_MORE_FILES			 equ	080000006h
STATUS_WAKE_SYSTEM_DEBUGGER		 equ	080000007h
STATUS_HANDLES_CLOSED			 equ	08000000Ah
STATUS_NO_INHERITANCE			 equ	08000000Bh
STATUS_GUID_SUBSTITUTION_MADE		 equ	08000000Ch
STATUS_PARTIAL_COPY			 equ	08000000Dh
STATUS_DEVICE_PAPER_EMPTY		 equ	08000000Eh
STATUS_DEVICE_POWERED_OFF		 equ	08000000Fh
STATUS_DEVICE_OFF_LINE			 equ	080000010h
STATUS_DEVICE_BUSY			 equ	080000011h
STATUS_NO_MORE_EAS			 equ	080000012h
STATUS_INVALID_EA_NAME			 equ	080000013h
STATUS_EA_LIST_INCONSISTENT		 equ	080000014h
STATUS_INVALID_EA_FLAG			 equ	080000015h
STATUS_VERIFY_REQUIRED			 equ	080000016h
STATUS_EXTRANEOUS_INFORMATION		 equ	080000017h
STATUS_RXACT_COMMIT_NECESSARY		 equ	080000018h
STATUS_NO_MORE_ENTRIES			 equ	08000001Ah
STATUS_FILEMARK_DETECTED		 equ	08000001Bh
STATUS_MEDIA_CHANGED			 equ	08000001Ch
STATUS_BUS_RESET			 equ	08000001Dh
STATUS_END_OF_MEDIA			 equ	08000001Eh
STATUS_BEGINNING_OF_MEDIA		 equ	08000001Fh
STATUS_MEDIA_CHECK			 equ	080000020h
STATUS_SETMARK_DETECTED			 equ	080000021h
STATUS_NO_DATA_DETECTED			 equ	080000022h
STATUS_REDIRECTOR_HAS_OPEN_HANDLES	 equ	080000023h
STATUS_SERVER_HAS_OPEN_HANDLES		 equ	080000024h
STATUS_ALREADY_DISCONNECTED		 equ	080000025h
STATUS_LONGJUMP				 equ	080000026h
;
STATUS_UNSUCCESSFUL			 equ	0C0000001h
STATUS_NOT_IMPLEMENTED			 equ	0C0000002h
STATUS_INVALID_INFO_CLASS		 equ	0C0000003h
STATUS_INFO_LENGTH_MISMATCH		 equ	0C0000004h
STATUS_ACCESS_VIOLATION			 equ	0C0000005h
STATUS_IN_PAGE_ERROR			 equ	0C0000006h
STATUS_PAGEFILE_QUOTA			 equ	0C0000007h
STATUS_INVALID_HANDLE			 equ	0C0000008h
STATUS_BAD_INITIAL_STACK		 equ	0C0000009h
STATUS_BAD_INITIAL_PC			 equ	0C000000Ah
STATUS_INVALID_CID			 equ	0C000000Bh
STATUS_TIMER_NOT_CANCELED		 equ	0C000000Ch
STATUS_INVALID_PARAMETER		 equ	0C000000Dh
STATUS_NO_SUCH_DEVICE			 equ	0C000000Eh
STATUS_NO_SUCH_FILE			 equ	0C000000Fh
STATUS_INVALID_DEVICE_REQUEST		 equ	0C0000010h
STATUS_END_OF_FILE			 equ	0C0000011h
STATUS_WRONG_VOLUME			 equ	0C0000012h
STATUS_NO_MEDIA_IN_DEVICE		 equ	0C0000013h
STATUS_UNRECOGNIZED_MEDIA		 equ	0C0000014h
STATUS_NONEXISTENT_SECTOR		 equ	0C0000015h
STATUS_MORE_PROCESSING_REQUIRED		 equ	0C0000016h
STATUS_NO_MEMORY			 equ	0C0000017h
STATUS_CONFLICTING_ADDRESSES		 equ	0C0000018h
STATUS_NOT_MAPPED_VIEW			 equ	0C0000019h
STATUS_UNABLE_TO_FREE_VM		 equ	0C000001Ah
STATUS_UNABLE_TO_DELETE_SECTION		 equ	0C000001Bh
STATUS_INVALID_SYSTEM_SERVICE		 equ	0C000001Ch
STATUS_ILLEGAL_INSTRUCTION		 equ	0C000001Dh
STATUS_INVALID_LOCK_SEQUENCE		 equ	0C000001Eh
STATUS_INVALID_VIEW_SIZE		 equ	0C000001Fh
STATUS_INVALID_FILE_FOR_SECTION		 equ	0C0000020h
STATUS_ALREADY_COMMITTED		 equ	0C0000021h
STATUS_ACCESS_DENIED			 equ	0C0000022h
STATUS_BUFFER_TOO_SMALL			 equ	0C0000023h
STATUS_OBJECT_TYPE_MISMATCH		 equ	0C0000024h
STATUS_NONCONTINUABLE_EXCEPTION		 equ	0C0000025h
STATUS_INVALID_DISPOSITION		 equ	0C0000026h
STATUS_UNWIND				 equ	0C0000027h
STATUS_BAD_STACK			 equ	0C0000028h
STATUS_INVALID_UNWIND_TARGET		 equ	0C0000029h
STATUS_NOT_LOCKED			 equ	0C000002Ah
STATUS_PARITY_ERROR			 equ	0C000002Bh
STATUS_UNABLE_TO_DECOMMIT_VM		 equ	0C000002Ch
STATUS_NOT_COMMITTED			 equ	0C000002Dh
STATUS_INVALID_PORT_ATTRIBUTES		 equ	0C000002Eh
STATUS_PORT_MESSAGE_TOO_LONG		 equ	0C000002Fh
STATUS_INVALID_PARAMETER_MIX		 equ	0C0000030h
STATUS_INVALID_QUOTA_LOWER		 equ	0C0000031h
STATUS_DISK_CORRUPT_ERROR		 equ	0C0000032h
STATUS_OBJECT_NAME_INVALID		 equ	0C0000033h
STATUS_OBJECT_NAME_NOT_FOUND		 equ	0C0000034h
STATUS_OBJECT_NAME_COLLISION		 equ	0C0000035h
STATUS_PORT_DISCONNECTED		 equ	0C0000037h
STATUS_DEVICE_ALREADY_ATTACHED		 equ	0C0000038h
STATUS_OBJECT_PATH_INVALID		 equ	0C0000039h
STATUS_OBJECT_PATH_NOT_FOUND		 equ	0C000003Ah
STATUS_OBJECT_PATH_SYNTAX_BAD		 equ	0C000003Bh
STATUS_DATA_OVERRUN			 equ	0C000003Ch
STATUS_DATA_LATE_ERROR			 equ	0C000003Dh
STATUS_DATA_ERROR			 equ	0C000003Eh
STATUS_CRC_ERROR			 equ	0C000003Fh
STATUS_SECTION_TOO_BIG			 equ	0C0000040h
STATUS_PORT_CONNECTION_REFUSED		 equ	0C0000041h
STATUS_INVALID_PORT_HANDLE		 equ	0C0000042h
STATUS_SHARING_VIOLATION		 equ	0C0000043h
STATUS_QUOTA_EXCEEDED			 equ	0C0000044h
STATUS_INVALID_PAGE_PROTECTION		 equ	0C0000045h
STATUS_MUTANT_NOT_OWNED			 equ	0C0000046h
STATUS_SEMAPHORE_LIMIT_EXCEEDED		 equ	0C0000047h
STATUS_PORT_ALREADY_SET			 equ	0C0000048h
STATUS_SECTION_NOT_IMAGE		 equ	0C0000049h
STATUS_SUSPEND_COUNT_EXCEEDED		 equ	0C000004Ah
STATUS_THREAD_IS_TERMINATING		 equ	0C000004Bh
STATUS_BAD_WORKING_SET_LIMIT		 equ	0C000004Ch
STATUS_INCOMPATIBLE_FILE_MAP		 equ	0C000004Dh
STATUS_SECTION_PROTECTION		 equ	0C000004Eh
STATUS_EAS_NOT_SUPPORTED		 equ	0C000004Fh
STATUS_EA_TOO_LARGE			 equ	0C0000050h
STATUS_NONEXISTENT_EA_ENTRY		 equ	0C0000051h
STATUS_NO_EAS_ON_FILE			 equ	0C0000052h
STATUS_EA_CORRUPT_ERROR			 equ	0C0000053h
STATUS_FILE_LOCK_CONFLICT		 equ	0C0000054h
STATUS_LOCK_NOT_GRANTED			 equ	0C0000055h
STATUS_DELETE_PENDING			 equ	0C0000056h
STATUS_CTL_FILE_NOT_SUPPORTED		 equ	0C0000057h
STATUS_UNKNOWN_REVISION			 equ	0C0000058h
STATUS_REVISION_MISMATCH		 equ	0C0000059h
STATUS_INVALID_OWNER			 equ	0C000005Ah
STATUS_INVALID_PRIMARY_GROUP		 equ	0C000005Bh
STATUS_NO_IMPERSONATION_TOKEN		 equ	0C000005Ch
STATUS_CANT_DISABLE_MANDATORY		 equ	0C000005Dh
STATUS_NO_LOGON_SERVERS			 equ	0C000005Eh
STATUS_NO_SUCH_LOGON_SESSION		 equ	0C000005Fh
STATUS_NO_SUCH_PRIVILEGE		 equ	0C0000060h
STATUS_PRIVILEGE_NOT_HELD		 equ	0C0000061h
STATUS_INVALID_ACCOUNT_NAME		 equ	0C0000062h
STATUS_USER_EXISTS			 equ	0C0000063h
STATUS_NO_SUCH_USER			 equ	0C0000064h
STATUS_GROUP_EXISTS			 equ	0C0000065h
STATUS_NO_SUCH_GROUP			 equ	0C0000066h
STATUS_MEMBER_IN_GROUP			 equ	0C0000067h
STATUS_MEMBER_NOT_IN_GROUP		 equ	0C0000068h
STATUS_LAST_ADMIN			 equ	0C0000069h
STATUS_WRONG_PASSWORD			 equ	0C000006Ah
STATUS_ILL_FORMED_PASSWORD		 equ	0C000006Bh
STATUS_PASSWORD_RESTRICTION		 equ	0C000006Ch
STATUS_LOGON_FAILURE			 equ	0C000006Dh
STATUS_ACCOUNT_RESTRICTION		 equ	0C000006Eh
STATUS_INVALID_LOGON_HOURS		 equ	0C000006Fh
STATUS_INVALID_WORKSTATION		 equ	0C0000070h
STATUS_PASSWORD_EXPIRED			 equ	0C0000071h
STATUS_ACCOUNT_DISABLED			 equ	0C0000072h
STATUS_NONE_MAPPED			 equ	0C0000073h
STATUS_TOO_MANY_LUIDS_REQUESTED		 equ	0C0000074h
STATUS_LUIDS_EXHAUSTED			 equ	0C0000075h
STATUS_INVALID_SUB_AUTHORITY		 equ	0C0000076h
STATUS_INVALID_ACL			 equ	0C0000077h
STATUS_INVALID_SID			 equ	0C0000078h
STATUS_INVALID_SECURITY_DESCR		 equ	0C0000079h
STATUS_PROCEDURE_NOT_FOUND		 equ	0C000007Ah
STATUS_INVALID_IMAGE_FORMAT		 equ	0C000007Bh
STATUS_NO_TOKEN				 equ	0C000007Ch
STATUS_BAD_INHERITANCE_ACL		 equ	0C000007Dh
STATUS_RANGE_NOT_LOCKED			 equ	0C000007Eh
STATUS_DISK_FULL			 equ	0C000007Fh
STATUS_SERVER_DISABLED			 equ	0C0000080h
STATUS_SERVER_NOT_DISABLED		 equ	0C0000081h
STATUS_TOO_MANY_GUIDS_REQUESTED		 equ	0C0000082h
STATUS_GUIDS_EXHAUSTED			 equ	0C0000083h
STATUS_INVALID_ID_AUTHORITY		 equ	0C0000084h
STATUS_AGENTS_EXHAUSTED			 equ	0C0000085h
STATUS_INVALID_VOLUME_LABEL		 equ	0C0000086h
STATUS_SECTION_NOT_EXTENDED		 equ	0C0000087h
STATUS_NOT_MAPPED_DATA			 equ	0C0000088h
STATUS_RESOURCE_DATA_NOT_FOUND		 equ	0C0000089h
STATUS_RESOURCE_TYPE_NOT_FOUND		 equ	0C000008Ah
STATUS_RESOURCE_NAME_NOT_FOUND		 equ	0C000008Bh
STATUS_ARRAY_BOUNDS_EXCEEDED		 equ	0C000008Ch
STATUS_FLOAT_DENORMAL_OPERAND		 equ	0C000008Dh
STATUS_FLOAT_DIVIDE_BY_ZERO		 equ	0C000008Eh
STATUS_FLOAT_INEXACT_RESULT		 equ	0C000008Fh
STATUS_FLOAT_INVALID_OPERATION		 equ	0C0000090h
STATUS_FLOAT_OVERFLOW			 equ	0C0000091h
STATUS_FLOAT_STACK_CHECK		 equ	0C0000092h
STATUS_FLOAT_UNDERFLOW			 equ	0C0000093h
STATUS_INTEGER_DIVIDE_BY_ZERO		 equ	0C0000094h
STATUS_INTEGER_OVERFLOW			 equ	0C0000095h
STATUS_PRIVILEGED_INSTRUCTION		 equ	0C0000096h
STATUS_TOO_MANY_PAGING_FILES		 equ	0C0000097h
STATUS_FILE_INVALID			 equ	0C0000098h
STATUS_ALLOTTED_SPACE_EXCEEDED		 equ	0C0000099h
STATUS_INSUFFICIENT_RESOURCES		 equ	0C000009Ah
STATUS_DFS_EXIT_PATH_FOUND		 equ	0C000009Bh
STATUS_DEVICE_DATA_ERROR		 equ	0C000009Ch
STATUS_DEVICE_NOT_CONNECTED		 equ	0C000009Dh
STATUS_DEVICE_POWER_FAILURE		 equ	0C000009Eh
STATUS_FREE_VM_NOT_AT_BASE		 equ	0C000009Fh
STATUS_MEMORY_NOT_ALLOCATED		 equ	0C00000A0h
STATUS_WORKING_SET_QUOTA		 equ	0C00000A1h
STATUS_MEDIA_WRITE_PROTECTED		 equ	0C00000A2h
STATUS_DEVICE_NOT_READY			 equ	0C00000A3h
STATUS_INVALID_GROUP_ATTRIBUTES		 equ	0C00000A4h
STATUS_BAD_IMPERSONATION_LEVEL		 equ	0C00000A5h
STATUS_CANT_OPEN_ANONYMOUS		 equ	0C00000A6h
STATUS_BAD_VALIDATION_CLASS		 equ	0C00000A7h
STATUS_BAD_TOKEN_TYPE			 equ	0C00000A8h
STATUS_BAD_MASTER_BOOT_RECORD		 equ	0C00000A9h
STATUS_INSTRUCTION_MISALIGNMENT		 equ	0C00000AAh
STATUS_INSTANCE_NOT_AVAILABLE		 equ	0C00000ABh
STATUS_PIPE_NOT_AVAILABLE		 equ	0C00000ACh
STATUS_INVALID_PIPE_STATE		 equ	0C00000ADh
STATUS_PIPE_BUSY			 equ	0C00000AEh
STATUS_ILLEGAL_FUNCTION			 equ	0C00000AFh
STATUS_PIPE_DISCONNECTED		 equ	0C00000B0h
STATUS_PIPE_CLOSING			 equ	0C00000B1h
STATUS_PIPE_CONNECTED			 equ	0C00000B2h
STATUS_PIPE_LISTENING			 equ	0C00000B3h
STATUS_INVALID_READ_MODE		 equ	0C00000B4h
STATUS_IO_TIMEOUT			 equ	0C00000B5h
STATUS_FILE_FORCED_CLOSED		 equ	0C00000B6h
STATUS_PROFILING_NOT_STARTED		 equ	0C00000B7h
STATUS_PROFILING_NOT_STOPPED		 equ	0C00000B8h
STATUS_COULD_NOT_INTERPRET		 equ	0C00000B9h
STATUS_FILE_IS_A_DIRECTORY		 equ	0C00000BAh
STATUS_NOT_SUPPORTED			 equ	0C00000BBh
STATUS_REMOTE_NOT_LISTENING		 equ	0C00000BCh
STATUS_DUPLICATE_NAME			 equ	0C00000BDh
STATUS_BAD_NETWORK_PATH			 equ	0C00000BEh
STATUS_NETWORK_BUSY			 equ	0C00000BFh
STATUS_DEVICE_DOES_NOT_EXIST		 equ	0C00000C0h
STATUS_TOO_MANY_COMMANDS		 equ	0C00000C1h
STATUS_ADAPTER_HARDWARE_ERROR		 equ	0C00000C2h
STATUS_INVALID_NETWORK_RESPONSE		 equ	0C00000C3h
STATUS_UNEXPECTED_NETWORK_ERROR		 equ	0C00000C4h
STATUS_BAD_REMOTE_ADAPTER		 equ	0C00000C5h
STATUS_PRINT_QUEUE_FULL			 equ	0C00000C6h
STATUS_NO_SPOOL_SPACE			 equ	0C00000C7h
STATUS_PRINT_CANCELLED			 equ	0C00000C8h
STATUS_NETWORK_NAME_DELETED		 equ	0C00000C9h
STATUS_NETWORK_ACCESS_DENIED		 equ	0C00000CAh
STATUS_BAD_DEVICE_TYPE			 equ	0C00000CBh
STATUS_BAD_NETWORK_NAME			 equ	0C00000CCh
STATUS_TOO_MANY_NAMES			 equ	0C00000CDh
STATUS_TOO_MANY_SESSIONS		 equ	0C00000CEh
STATUS_SHARING_PAUSED			 equ	0C00000CFh
STATUS_REQUEST_NOT_ACCEPTED		 equ	0C00000D0h
STATUS_REDIRECTOR_PAUSED		 equ	0C00000D1h
STATUS_NET_WRITE_FAULT			 equ	0C00000D2h
STATUS_PROFILING_AT_LIMIT		 equ	0C00000D3h
STATUS_NOT_SAME_DEVICE			 equ	0C00000D4h
STATUS_FILE_RENAMED			 equ	0C00000D5h
STATUS_VIRTUAL_CIRCUIT_CLOSED		 equ	0C00000D6h
STATUS_NO_SECURITY_ON_OBJECT		 equ	0C00000D7h
STATUS_CANT_WAIT			 equ	0C00000D8h
STATUS_PIPE_EMPTY			 equ	0C00000D9h
STATUS_CANT_ACCESS_DOMAIN_INFO		 equ	0C00000DAh
STATUS_CANT_TERMINATE_SELF		 equ	0C00000DBh
STATUS_INVALID_SERVER_STATE		 equ	0C00000DCh
STATUS_INVALID_DOMAIN_STATE		 equ	0C00000DDh
STATUS_INVALID_DOMAIN_ROLE		 equ	0C00000DEh
STATUS_NO_SUCH_DOMAIN			 equ	0C00000DFh
STATUS_DOMAIN_EXISTS			 equ	0C00000E0h
STATUS_DOMAIN_LIMIT_EXCEEDED		 equ	0C00000E1h
STATUS_OPLOCK_NOT_GRANTED		 equ	0C00000E2h
STATUS_INVALID_OPLOCK_PROTOCOL		 equ	0C00000E3h
STATUS_INTERNAL_DB_CORRUPTION		 equ	0C00000E4h
STATUS_INTERNAL_ERROR			 equ	0C00000E5h
STATUS_GENERIC_NOT_MAPPED		 equ	0C00000E6h
STATUS_BAD_DESCRIPTOR_FORMAT		 equ	0C00000E7h
STATUS_INVALID_USER_BUFFER		 equ	0C00000E8h
STATUS_UNEXPECTED_IO_ERROR		 equ	0C00000E9h
STATUS_UNEXPECTED_MM_CREATE_ERR		 equ	0C00000EAh
STATUS_UNEXPECTED_MM_MAP_ERROR		 equ	0C00000EBh
STATUS_UNEXPECTED_MM_EXTEND_ERR		 equ	0C00000ECh
STATUS_NOT_LOGON_PROCESS		 equ	0C00000EDh
STATUS_LOGON_SESSION_EXISTS		 equ	0C00000EEh
STATUS_INVALID_PARAMETER_1		 equ	0C00000EFh
STATUS_INVALID_PARAMETER_2		 equ	0C00000F0h
STATUS_INVALID_PARAMETER_3		 equ	0C00000F1h
STATUS_INVALID_PARAMETER_4		 equ	0C00000F2h
STATUS_INVALID_PARAMETER_5		 equ	0C00000F3h
STATUS_INVALID_PARAMETER_6		 equ	0C00000F4h
STATUS_INVALID_PARAMETER_7		 equ	0C00000F5h
STATUS_INVALID_PARAMETER_8		 equ	0C00000F6h
STATUS_INVALID_PARAMETER_9		 equ	0C00000F7h
STATUS_INVALID_PARAMETER_10		 equ	0C00000F8h
STATUS_INVALID_PARAMETER_11		 equ	0C00000F9h
STATUS_INVALID_PARAMETER_12		 equ	0C00000FAh
STATUS_REDIRECTOR_NOT_STARTED		 equ	0C00000FBh
STATUS_REDIRECTOR_STARTED		 equ	0C00000FCh
STATUS_STACK_OVERFLOW			 equ	0C00000FDh
STATUS_NO_SUCH_PACKAGE			 equ	0C00000FEh
STATUS_BAD_FUNCTION_TABLE		 equ	0C00000FFh
STATUS_VARIABLE_NOT_FOUND		 equ	0C0000100h
STATUS_DIRECTORY_NOT_EMPTY		 equ	0C0000101h
STATUS_FILE_CORRUPT_ERROR		 equ	0C0000102h
STATUS_NOT_A_DIRECTORY			 equ	0C0000103h
STATUS_BAD_LOGON_SESSION_STATE		 equ	0C0000104h
STATUS_LOGON_SESSION_COLLISION		 equ	0C0000105h
STATUS_NAME_TOO_LONG			 equ	0C0000106h
STATUS_FILES_OPEN			 equ	0C0000107h
STATUS_CONNECTION_IN_USE		 equ	0C0000108h
STATUS_MESSAGE_NOT_FOUND		 equ	0C0000109h
STATUS_PROCESS_IS_TERMINATING		 equ	0C000010Ah
STATUS_INVALID_LOGON_TYPE		 equ	0C000010Bh
STATUS_NO_GUID_TRANSLATION		 equ	0C000010Ch
STATUS_CANNOT_IMPERSONATE		 equ	0C000010Dh
STATUS_IMAGE_ALREADY_LOADED		 equ	0C000010Eh
STATUS_ABIOS_NOT_PRESENT		 equ	0C000010Fh
STATUS_ABIOS_LID_NOT_EXIST		 equ	0C0000110h
STATUS_ABIOS_LID_ALREADY_OWNED		 equ	0C0000111h
STATUS_ABIOS_NOT_LID_OWNER		 equ	0C0000112h
STATUS_ABIOS_INVALID_COMMAND		 equ	0C0000113h
STATUS_ABIOS_INVALID_LID		 equ	0C0000114h
STATUS_ABIOS_SELECTOR_NOT_AVAILABLE	 equ	0C0000115h
STATUS_ABIOS_INVALID_SELECTOR		 equ	0C0000116h
STATUS_NO_LDT				 equ	0C0000117h
STATUS_INVALID_LDT_SIZE			 equ	0C0000118h
STATUS_INVALID_LDT_OFFSET		 equ	0C0000119h
STATUS_INVALID_LDT_DESCRIPTOR		 equ	0C000011Ah
STATUS_INVALID_IMAGE_NE_FORMAT		 equ	0C000011Bh
STATUS_RXACT_INVALID_STATE		 equ	0C000011Ch
STATUS_RXACT_COMMIT_FAILURE		 equ	0C000011Dh
STATUS_MAPPED_FILE_SIZE_ZERO		 equ	0C000011Eh
STATUS_TOO_MANY_OPENED_FILES		 equ	0C000011Fh
STATUS_CANCELLED			 equ	0C0000120h
STATUS_CANNOT_DELETE			 equ	0C0000121h
STATUS_INVALID_COMPUTER_NAME		 equ	0C0000122h
STATUS_FILE_DELETED			 equ	0C0000123h
STATUS_SPECIAL_ACCOUNT			 equ	0C0000124h
STATUS_SPECIAL_GROUP			 equ	0C0000125h
STATUS_SPECIAL_USER			 equ	0C0000126h
STATUS_MEMBERS_PRIMARY_GROUP		 equ	0C0000127h
STATUS_FILE_CLOSED			 equ	0C0000128h
STATUS_TOO_MANY_THREADS			 equ	0C0000129h
STATUS_THREAD_NOT_IN_PROCESS		 equ	0C000012Ah
STATUS_TOKEN_ALREADY_IN_USE		 equ	0C000012Bh
STATUS_PAGEFILE_QUOTA_EXCEEDED		 equ	0C000012Ch
STATUS_COMMITMENT_LIMIT			 equ	0C000012Dh
STATUS_INVALID_IMAGE_LE_FORMAT		 equ	0C000012Eh
STATUS_INVALID_IMAGE_NOT_MZ		 equ	0C000012Fh
STATUS_INVALID_IMAGE_PROTECT		 equ	0C0000130h
STATUS_INVALID_IMAGE_WIN_16		 equ	0C0000131h
STATUS_LOGON_SERVER_CONFLICT		 equ	0C0000132h
STATUS_TIME_DIFFERENCE_AT_DC		 equ	0C0000133h
STATUS_SYNCHRONIZATION_REQUIRED		 equ	0C0000134h
STATUS_DLL_NOT_FOUND			 equ	0C0000135h
STATUS_OPEN_FAILED			 equ	0C0000136h
STATUS_IO_PRIVILEGE_FAILED		 equ	0C0000137h
STATUS_ORDINAL_NOT_FOUND		 equ	0C0000138h
STATUS_ENTRYPOINT_NOT_FOUND		 equ	0C0000139h
STATUS_CONTROL_C_EXIT			 equ	0C000013Ah
STATUS_LOCAL_DISCONNECT			 equ	0C000013Bh
STATUS_REMOTE_DISCONNECT		 equ	0C000013Ch
STATUS_REMOTE_RESOURCES			 equ	0C000013Dh
STATUS_LINK_FAILED			 equ	0C000013Eh
STATUS_LINK_TIMEOUT			 equ	0C000013Fh
STATUS_INVALID_CONNECTION		 equ	0C0000140h
STATUS_INVALID_ADDRESS			 equ	0C0000141h
STATUS_DLL_INIT_FAILED			 equ	0C0000142h
STATUS_MISSING_SYSTEMFILE		 equ	0C0000143h
STATUS_UNHANDLED_EXCEPTION		 equ	0C0000144h
STATUS_APP_INIT_FAILURE			 equ	0C0000145h
STATUS_PAGEFILE_CREATE_FAILED		 equ	0C0000146h
STATUS_NO_PAGEFILE			 equ	0C0000147h
STATUS_INVALID_LEVEL			 equ	0C0000148h
STATUS_WRONG_PASSWORD_CORE		 equ	0C0000149h
STATUS_ILLEGAL_FLOAT_CONTEXT		 equ	0C000014Ah
STATUS_PIPE_BROKEN			 equ	0C000014Bh
STATUS_REGISTRY_CORRUPT			 equ	0C000014Ch
STATUS_REGISTRY_IO_FAILED		 equ	0C000014Dh
STATUS_NO_EVENT_PAIR			 equ	0C000014Eh
STATUS_UNRECOGNIZED_VOLUME		 equ	0C000014Fh
STATUS_SERIAL_NO_DEVICE_INITED		 equ	0C0000150h
STATUS_NO_SUCH_ALIAS			 equ	0C0000151h
STATUS_MEMBER_NOT_IN_ALIAS		 equ	0C0000152h
STATUS_MEMBER_IN_ALIAS			 equ	0C0000153h
STATUS_ALIAS_EXISTS			 equ	0C0000154h
STATUS_LOGON_NOT_GRANTED		 equ	0C0000155h
STATUS_TOO_MANY_SECRETS			 equ	0C0000156h
STATUS_SECRET_TOO_LONG			 equ	0C0000157h
STATUS_INTERNAL_DB_ERROR		 equ	0C0000158h
STATUS_FULLSCREEN_MODE			 equ	0C0000159h
STATUS_TOO_MANY_CONTEXT_IDS		 equ	0C000015Ah
STATUS_LOGON_TYPE_NOT_GRANTED		 equ	0C000015Bh
STATUS_NOT_REGISTRY_FILE		 equ	0C000015Ch
STATUS_NT_CROSS_ENCRYPTION_REQUIRED	 equ	0C000015Dh
STATUS_DOMAIN_CTRLR_CONFIG_ERROR	 equ	0C000015Eh
STATUS_FT_MISSING_MEMBER		 equ	0C000015Fh
STATUS_ILL_FORMED_SERVICE_ENTRY		 equ	0C0000160h
STATUS_ILLEGAL_CHARACTER		 equ	0C0000161h
STATUS_UNMAPPABLE_CHARACTER		 equ	0C0000162h
STATUS_UNDEFINED_CHARACTER		 equ	0C0000163h
STATUS_FLOPPY_VOLUME			 equ	0C0000164h
STATUS_FLOPPY_ID_MARK_NOT_FOUND		 equ	0C0000165h
STATUS_FLOPPY_WRONG_CYLINDER		 equ	0C0000166h
STATUS_FLOPPY_UNKNOWN_ERROR		 equ	0C0000167h
STATUS_FLOPPY_BAD_REGISTERS		 equ	0C0000168h
STATUS_DISK_RECALIBRATE_FAILED		 equ	0C0000169h
STATUS_DISK_OPERATION_FAILED		 equ	0C000016Ah
STATUS_DISK_RESET_FAILED		 equ	0C000016Bh
STATUS_SHARED_IRQ_BUSY			 equ	0C000016Ch
STATUS_FT_ORPHANING			 equ	0C000016Dh
STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT	 equ	0C000016Eh
STATUS_PARTITION_FAILURE		 equ	0C0000172h
STATUS_INVALID_BLOCK_LENGTH		 equ	0C0000173h
STATUS_DEVICE_NOT_PARTITIONED		 equ	0C0000174h
STATUS_UNABLE_TO_LOCK_MEDIA		 equ	0C0000175h
STATUS_UNABLE_TO_UNLOAD_MEDIA		 equ	0C0000176h
STATUS_EOM_OVERFLOW			 equ	0C0000177h
STATUS_NO_MEDIA				 equ	0C0000178h
STATUS_NO_SUCH_MEMBER			 equ	0C000017Ah
STATUS_INVALID_MEMBER			 equ	0C000017Bh
STATUS_KEY_DELETED			 equ	0C000017Ch
STATUS_NO_LOG_SPACE			 equ	0C000017Dh
STATUS_TOO_MANY_SIDS			 equ	0C000017Eh
STATUS_LM_CROSS_ENCRYPTION_REQUIRED	 equ	0C000017Fh
STATUS_KEY_HAS_CHILDREN			 equ	0C0000180h
STATUS_CHILD_MUST_BE_VOLATILE		 equ	0C0000181h
STATUS_DEVICE_CONFIGURATION_ERROR	 equ	0C0000182h
STATUS_DRIVER_INTERNAL_ERROR		 equ	0C0000183h
STATUS_INVALID_DEVICE_STATE		 equ	0C0000184h
STATUS_IO_DEVICE_ERROR			 equ	0C0000185h
STATUS_DEVICE_PROTOCOL_ERROR		 equ	0C0000186h
STATUS_BACKUP_CONTROLLER		 equ	0C0000187h
STATUS_LOG_FILE_FULL			 equ	0C0000188h
STATUS_TOO_LATE				 equ	0C0000189h
STATUS_NO_TRUST_LSA_SECRET		 equ	0C000018Ah
STATUS_NO_TRUST_SAM_ACCOUNT		 equ	0C000018Bh
STATUS_TRUSTED_DOMAIN_FAILURE		 equ	0C000018Ch
STATUS_TRUSTED_RELATIONSHIP_FAILURE	 equ	0C000018Dh
STATUS_EVENTLOG_FILE_CORRUPT		 equ	0C000018Eh
STATUS_EVENTLOG_CANT_START		 equ	0C000018Fh
STATUS_TRUST_FAILURE			 equ	0C0000190h
STATUS_MUTANT_LIMIT_EXCEEDED		 equ	0C0000191h
STATUS_NETLOGON_NOT_STARTED		 equ	0C0000192h
STATUS_ACCOUNT_EXPIRED			 equ	0C0000193h
STATUS_POSSIBLE_DEADLOCK		 equ	0C0000194h
STATUS_NETWORK_CREDENTIAL_CONFLICT	 equ	0C0000195h
STATUS_REMOTE_SESSION_LIMIT		 equ	0C0000196h
STATUS_EVENTLOG_FILE_CHANGED		 equ	0C0000197h
STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT equ	0C0000198h
STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT equ	0C0000199h
STATUS_NOLOGON_SERVER_TRUST_ACCOUNT	 equ	0C000019Ah
STATUS_DOMAIN_TRUST_INCONSISTENT	 equ	0C000019Bh
STATUS_FS_DRIVER_REQUIRED		 equ	0C000019Ch
STATUS_NO_USER_SESSION_KEY		 equ	0C0000202h
STATUS_USER_SESSION_DELETED		 equ	0C0000203h
STATUS_RESOURCE_LANG_NOT_FOUND		 equ	0C0000204h
STATUS_INSUFF_SERVER_RESOURCES		 equ	0C0000205h
STATUS_INVALID_BUFFER_SIZE		 equ	0C0000206h
STATUS_INVALID_ADDRESS_COMPONENT	 equ	0C0000207h
STATUS_INVALID_ADDRESS_WILDCARD		 equ	0C0000208h
STATUS_TOO_MANY_ADDRESSES		 equ	0C0000209h
STATUS_ADDRESS_ALREADY_EXISTS		 equ	0C000020Ah
STATUS_ADDRESS_CLOSED			 equ	0C000020Bh
STATUS_CONNECTION_DISCONNECTED		 equ	0C000020Ch
STATUS_CONNECTION_RESET			 equ	0C000020Dh
STATUS_TOO_MANY_NODES			 equ	0C000020Eh
STATUS_TRANSACTION_ABORTED		 equ	0C000020Fh
STATUS_TRANSACTION_TIMED_OUT		 equ	0C0000210h
STATUS_TRANSACTION_NO_RELEASE		 equ	0C0000211h
STATUS_TRANSACTION_NO_MATCH		 equ	0C0000212h
STATUS_TRANSACTION_RESPONDED		 equ	0C0000213h
STATUS_TRANSACTION_INVALID_ID		 equ	0C0000214h
STATUS_TRANSACTION_INVALID_TYPE		 equ	0C0000215h
STATUS_NOT_SERVER_SESSION		 equ	0C0000216h
STATUS_NOT_CLIENT_SESSION		 equ	0C0000217h
STATUS_CANNOT_LOAD_REGISTRY_FILE	 equ	0C0000218h
STATUS_DEBUG_ATTACH_FAILED		 equ	0C0000219h
STATUS_SYSTEM_PROCESS_TERMINATED	 equ	0C000021Ah
STATUS_DATA_NOT_ACCEPTED		 equ	0C000021Bh
STATUS_NO_BROWSER_SERVERS_FOUND		 equ	0C000021Ch
STATUS_VDM_HARD_ERROR			 equ	0C000021Dh
STATUS_DRIVER_CANCEL_TIMEOUT		 equ	0C000021Eh
STATUS_REPLY_MESSAGE_MISMATCH		 equ	0C000021Fh
STATUS_MAPPED_ALIGNMENT			 equ	0C0000220h
STATUS_IMAGE_CHECKSUM_MISMATCH		 equ	0C0000221h
STATUS_LOST_WRITEBEHIND_DATA		 equ	0C0000222h
STATUS_CLIENT_SERVER_PARAMETERS_INVALID	 equ	0C0000223h
STATUS_PASSWORD_MUST_CHANGE		 equ	0C0000224h
STATUS_NOT_FOUND			 equ	0C0000225h
STATUS_NOT_TINY_STREAM			 equ	0C0000226h
STATUS_RECOVERY_FAILURE			 equ	0C0000227h
STATUS_STACK_OVERFLOW_READ		 equ	0C0000228h
STATUS_FAIL_CHECK			 equ	0C0000229h
STATUS_DUPLICATE_OBJECTID		 equ	0C000022Ah
STATUS_OBJECTID_EXISTS			 equ	0C000022Bh
STATUS_CONVERT_TO_LARGE			 equ	0C000022Ch
STATUS_RETRY				 equ	0C000022Dh
STATUS_FOUND_OUT_OF_SCOPE		 equ	0C000022Eh
STATUS_ALLOCATE_BUCKET			 equ	0C000022Fh
STATUS_PROPSET_NOT_FOUND		 equ	0C0000230h
STATUS_MARSHALL_OVERFLOW		 equ	0C0000231h
STATUS_INVALID_VARIANT			 equ	0C0000232h
STATUS_DOMAIN_CONTROLLER_NOT_FOUND	 equ	0C0000233h
STATUS_ACCOUNT_LOCKED_OUT		 equ	0C0000234h
STATUS_HANDLE_NOT_CLOSABLE		 equ	0C0000235h
STATUS_CONNECTION_REFUSED		 equ	0C0000236h
STATUS_GRACEFUL_DISCONNECT		 equ	0C0000237h
STATUS_ADDRESS_ALREADY_ASSOCIATED	 equ	0C0000238h
STATUS_ADDRESS_NOT_ASSOCIATED		 equ	0C0000239h
STATUS_CONNECTION_INVALID		 equ	0C000023Ah
STATUS_CONNECTION_ACTIVE		 equ	0C000023Bh
STATUS_NETWORK_UNREACHABLE		 equ	0C000023Ch
STATUS_HOST_UNREACHABLE			 equ	0C000023Dh
STATUS_PROTOCOL_UNREACHABLE		 equ	0C000023Eh
STATUS_PORT_UNREACHABLE			 equ	0C000023Fh
STATUS_REQUEST_ABORTED			 equ	0C0000240h
STATUS_CONNECTION_ABORTED		 equ	0C0000241h
STATUS_BAD_COMPRESSION_BUFFER		 equ	0C0000242h
STATUS_USER_MAPPED_FILE			 equ	0C0000243h
STATUS_AUDIT_FAILED			 equ	0C0000244h
STATUS_TIMER_RESOLUTION_NOT_SET		 equ	0C0000245h
STATUS_CONNECTION_COUNT_LIMIT		 equ	0C0000246h
STATUS_LOGIN_TIME_RESTRICTION		 equ	0C0000247h
STATUS_LOGIN_WKSTA_RESTRICTION		 equ	0C0000248h
STATUS_IMAGE_MP_UP_MISMATCH		 equ	0C0000249h
STATUS_INSUFFICIENT_LOGON_INFO		 equ	0C0000250h
STATUS_BAD_DLL_ENTRYPOINT		 equ	0C0000251h
STATUS_BAD_SERVICE_ENTRYPOINT		 equ	0C0000252h
STATUS_LPC_REPLY_LOST			 equ	0C0000253h
STATUS_IP_ADDRESS_CONFLICT1		 equ	0C0000254h
STATUS_IP_ADDRESS_CONFLICT2		 equ	0C0000255h
STATUS_REGISTRY_QUOTA_LIMIT		 equ	0C0000256h
STATUS_PATH_NOT_COVERED			 equ	0C0000257h
STATUS_NO_CALLBACK_ACTIVE		 equ	0C0000258h
STATUS_LICENSE_QUOTA_EXCEEDED		 equ	0C0000259h
STATUS_PWD_TOO_SHORT			 equ	0C000025Ah
STATUS_PWD_TOO_RECENT			 equ	0C000025Bh
STATUS_PWD_HISTORY_CONFLICT		 equ	0C000025Ch
STATUS_PLUGPLAY_NO_DEVICE		 equ	0C000025Eh
STATUS_UNSUPPORTED_COMPRESSION		 equ	0C000025Fh
STATUS_INVALID_HW_PROFILE		 equ	0C0000260h
STATUS_INVALID_PLUGPLAY_DEVICE_PATH	 equ	0C0000261h
STATUS_DRIVER_ORDINAL_NOT_FOUND		 equ	0C0000262h
STATUS_DRIVER_ENTRYPOINT_NOT_FOUND	 equ	0C0000263h
STATUS_RESOURCE_NOT_OWNED		 equ	0C0000264h
STATUS_WOW_ASSERTION			 equ	0C0009898h
;
RPC_NT_INVALID_STRING_BINDING		 equ	0C0020001h
RPC_NT_WRONG_KIND_OF_BINDING		 equ	0C0020002h
RPC_NT_INVALID_BINDING			 equ	0C0020003h
RPC_NT_PROTSEQ_NOT_SUPPORTED		 equ	0C0020004h
RPC_NT_INVALID_RPC_PROTSEQ		 equ	0C0020005h
RPC_NT_INVALID_STRING_UUID		 equ	0C0020006h
RPC_NT_INVALID_ENDPOINT_FORMAT		 equ	0C0020007h
RPC_NT_INVALID_NET_ADDR			 equ	0C0020008h
RPC_NT_NO_ENDPOINT_FOUND		 equ	0C0020009h
RPC_NT_INVALID_TIMEOUT			 equ	0C002000Ah
RPC_NT_OBJECT_NOT_FOUND			 equ	0C002000Bh
RPC_NT_ALREADY_REGISTERED		 equ	0C002000Ch
RPC_NT_TYPE_ALREADY_REGISTERED		 equ	0C002000Dh
RPC_NT_ALREADY_LISTENING		 equ	0C002000Eh
RPC_NT_NO_PROTSEQS_REGISTERED		 equ	0C002000Fh
RPC_NT_NOT_LISTENING			 equ	0C0020010h
RPC_NT_UNKNOWN_MGR_TYPE			 equ	0C0020011h
RPC_NT_UNKNOWN_IF			 equ	0C0020012h
RPC_NT_NO_BINDINGS			 equ	0C0020013h
RPC_NT_NO_PROTSEQS			 equ	0C0020014h
RPC_NT_CANT_CREATE_ENDPOINT		 equ	0C0020015h
RPC_NT_OUT_OF_RESOURCES			 equ	0C0020016h
RPC_NT_SERVER_UNAVAILABLE		 equ	0C0020017h
RPC_NT_SERVER_TOO_BUSY			 equ	0C0020018h
RPC_NT_INVALID_NETWORK_OPTIONS		 equ	0C0020019h
RPC_NT_NO_CALL_ACTIVE			 equ	0C002001Ah
RPC_NT_CALL_FAILED			 equ	0C002001Bh
RPC_NT_CALL_FAILED_DNE			 equ	0C002001Ch
RPC_NT_PROTOCOL_ERROR			 equ	0C002001Dh
RPC_NT_UNSUPPORTED_TRANS_SYN		 equ	0C002001Fh
RPC_NT_UNSUPPORTED_TYPE			 equ	0C0020021h
RPC_NT_INVALID_TAG			 equ	0C0020022h
RPC_NT_INVALID_BOUND			 equ	0C0020023h
RPC_NT_NO_ENTRY_NAME			 equ	0C0020024h
RPC_NT_INVALID_NAME_SYNTAX		 equ	0C0020025h
RPC_NT_UNSUPPORTED_NAME_SYNTAX		 equ	0C0020026h
RPC_NT_UUID_NO_ADDRESS			 equ	0C0020028h
RPC_NT_DUPLICATE_ENDPOINT		 equ	0C0020029h
RPC_NT_UNKNOWN_AUTHN_TYPE		 equ	0C002002Ah
RPC_NT_MAX_CALLS_TOO_SMALL		 equ	0C002002Bh
RPC_NT_STRING_TOO_LONG			 equ	0C002002Ch
RPC_NT_PROTSEQ_NOT_FOUND		 equ	0C002002Dh
RPC_NT_PROCNUM_OUT_OF_RANGE		 equ	0C002002Eh
RPC_NT_BINDING_HAS_NO_AUTH		 equ	0C002002Fh
RPC_NT_UNKNOWN_AUTHN_SERVICE		 equ	0C0020030h
RPC_NT_UNKNOWN_AUTHN_LEVEL		 equ	0C0020031h
RPC_NT_INVALID_AUTH_IDENTITY		 equ	0C0020032h
RPC_NT_UNKNOWN_AUTHZ_SERVICE		 equ	0C0020033h
EPT_NT_INVALID_ENTRY			 equ	0C0020034h
EPT_NT_CANT_PERFORM_OP			 equ	0C0020035h
EPT_NT_NOT_REGISTERED			 equ	0C0020036h
RPC_NT_NOTHING_TO_EXPORT		 equ	0C0020037h
RPC_NT_INCOMPLETE_NAME			 equ	0C0020038h
RPC_NT_INVALID_VERS_OPTION		 equ	0C0020039h
RPC_NT_NO_MORE_MEMBERS			 equ	0C002003Ah
RPC_NT_NOT_ALL_OBJS_UNEXPORTED		 equ	0C002003Bh
RPC_NT_INTERFACE_NOT_FOUND		 equ	0C002003Ch
RPC_NT_ENTRY_ALREADY_EXISTS		 equ	0C002003Dh
RPC_NT_ENTRY_NOT_FOUND			 equ	0C002003Eh
RPC_NT_NAME_SERVICE_UNAVAILABLE		 equ	0C002003Fh
RPC_NT_INVALID_NAF_ID			 equ	0C0020040h
RPC_NT_CANNOT_SUPPORT			 equ	0C0020041h
RPC_NT_NO_CONTEXT_AVAILABLE		 equ	0C0020042h
RPC_NT_INTERNAL_ERROR			 equ	0C0020043h
RPC_NT_ZERO_DIVIDE			 equ	0C0020044h
RPC_NT_ADDRESS_ERROR			 equ	0C0020045h
RPC_NT_FP_DIV_ZERO			 equ	0C0020046h
RPC_NT_FP_UNDERFLOW			 equ	0C0020047h
RPC_NT_FP_OVERFLOW			 equ	0C0020048h
RPC_NT_CALL_IN_PROGRESS			 equ	0C0020049h
RPC_NT_NO_MORE_BINDINGS			 equ	0C002004Ah
RPC_NT_GROUP_MEMBER_NOT_FOUND		 equ	0C002004Bh
EPT_NT_CANT_CREATE			 equ	0C002004Ch
RPC_NT_INVALID_OBJECT			 equ	0C002004Dh
RPC_NT_NO_INTERFACES			 equ	0C002004Fh
RPC_NT_CALL_CANCELLED			 equ	0C0020050h
RPC_NT_BINDING_INCOMPLETE		 equ	0C0020051h
RPC_NT_COMM_FAILURE			 equ	0C0020052h
RPC_NT_UNSUPPORTED_AUTHN_LEVEL		 equ	0C0020053h
RPC_NT_NO_PRINC_NAME			 equ	0C0020054h
RPC_NT_NOT_RPC_ERROR			 equ	0C0020055h
RPC_NT_UUID_LOCAL_ONLY			 equ	040020056h
RPC_NT_SEC_PKG_ERROR			 equ	0C0020057h
RPC_NT_NOT_CANCELLED			 equ	0C0020058h
;
RPC_NT_NO_MORE_ENTRIES			 equ	0C0030001h
RPC_NT_SS_CHAR_TRANS_OPEN_FAIL		 equ	0C0030002h
RPC_NT_SS_CHAR_TRANS_SHORT_FILE		 equ	0C0030003h
RPC_NT_SS_IN_NULL_CONTEXT		 equ	0C0030004h
RPC_NT_SS_CONTEXT_MISMATCH		 equ	0C0030005h
RPC_NT_SS_CONTEXT_DAMAGED		 equ	0C0030006h
RPC_NT_SS_HANDLES_MISMATCH		 equ	0C0030007h
RPC_NT_SS_CANNOT_GET_CALL_HANDLE	 equ	0C0030008h
RPC_NT_NULL_REF_POINTER			 equ	0C0030009h
RPC_NT_ENUM_VALUE_OUT_OF_RANGE		 equ	0C003000Ah
RPC_NT_BYTE_COUNT_TOO_SMALL		 equ	0C003000Bh
RPC_NT_BAD_STUB_DATA			 equ	0C003000Ch
RPC_NT_INVALID_ES_ACTION		 equ	0C0030059h
RPC_NT_WRONG_ES_VERSION			 equ	0C003005Ah
RPC_NT_WRONG_STUB_VERSION		 equ	0C003005Bh
;
;------------------------------------------------------------------------------
;
; ========================
; toolbar standard bitmaps
; ========================
;
STD_CUT				equ	 0
STD_COPY			equ	 1
STD_PASTE			equ	 2
STD_UNDO			equ	 3
STD_REDOW			equ	 4
STD_DELETE			equ	 5
STD_FILENEW			equ	 6
STD_FILEOPEN			equ	 7
STD_FILESAVE			equ	 8
STD_PRINTPRE			equ	 9
STD_PROPERTIES			equ	10
STD_HELP			equ	11
STD_FIND			equ	12
STD_REPLACE			equ	13
STD_PRINT			equ	14
;
;------------------------------------------------------------------------------
;
; =====================
; standard file handles
; =====================
;
STD_INPUT_HANDLE		equ	-10
STD_OUTPUT_HANDLE		equ	-11
STD_ERROR_HANDLE		equ	-12
;
;------------------------------------------------------------------------------
;
; ================
; sublanguage id's
; ================
;
SUBLANG_NEUTRAL			equ	0 * 0400h
SUBLANG_DEFAULT			equ	1 * 0400h
SUBLANG_SYS_DEFAULT		equ	2 * 0400h
;
SUBLANG_CHINESE_TRADITIONAL	equ	1 * 0400h
SUBLANG_CHINESE_SIMPLIFIED	equ	2 * 0400h
SUBLANG_CHINESE_HONGKONG	equ	3 * 0400h
SUBLANG_CHINESE_SINGAPORE	equ	4 * 0400h
;
SUBLANG_DUTCH			equ	1 * 0400h
SUBLANG_DUTCH_BELGIAN		equ	2 * 0400h
;
SUBLANG_ENGLISH_US		equ	1 * 0400h
SUBLANG_ENGLISH_UK		equ	2 * 0400h
SUBLANG_ENGLISH_AUS		equ	3 * 0400h
SUBLANG_ENGLISH_CAN		equ	4 * 0400h
SUBLANG_ENGLISH_NZ		equ	5 * 0400h
SUBLANG_ENGLISH_EIRE		equ	6 * 0400h
SUBLANG_ENGLISH_SAFRICA		equ	7 * 0400h
SUBLANG_ENGLISH_JAMAICA		equ	8 * 0400h
SUBLANG_ENGLISH_CARRIBEAN	equ	9 * 0400h
;
SUBLANG_FRENCH			equ	1 * 0400h
SUBLANG_FRENCH_BELGIAN		equ	2 * 0400h
SUBLANG_FRENCH_CANADIAN		equ	3 * 0400h
SUBLANG_FRENCH_SWISS		equ	4 * 0400h
;
SUBLANG_GERMAN			equ	1 * 0400h
SUBLANG_GERMAN_SWISS		equ	2 * 0400h
SUBLANG_GERMAN_AUSTRIAN		equ	3 * 0400h
SUBLANG_GERMAN_LUXEMBOURG	equ	4 * 0400h
SUBLANG_GERMAN_LIECHTENSTEIN	equ	5 * 0400h
;
SUBLANG_ITALIAN			equ	1 * 0400h
SUBLANG_ITALIAN_SWISS		equ	2 * 0400h
;
SUBLANG_NORWEGIAN_BOKMAL	equ	1 * 0400h
SUBLANG_NORWEGIAN_NYNORSK	equ	2 * 0400h
;
SUBLANG_PORTUGUESE_BRAZILIAN	equ	1 * 0400h
SUBLANG_PORTUGUESE		equ	2 * 0400h
;
SUBLANG_SPANISH			equ	1 * 0400h
SUBLANG_SPANISH_MEXICAN		equ	2 * 0400h
SUBLANG_SPANISH_MODERN		equ	3 * 0400h
;
;------------------------------------------------------------------------------
;
; =====================
; ShowWindow() commands
; =====================
;
SW_HIDE				equ	 0
SW_SHOWNORMAL			equ	 1
SW_NORMAL			equ	 1
SW_SHOWMINIMIZED		equ	 2
SW_SHOWMAXIMIZED		equ	 3
SW_MAXIMIZE			equ	 3
SW_SHOWNOACTIVATE		equ	 4
SW_SHOW				equ	 5
SW_MINIMIZE			equ	 6
SW_SHOWMINNOACTIVE		equ	 7
SW_SHOWNA			equ	 8
SW_RESTORE			equ	 9
SW_SHOWDEFAULT			equ	10
SW_MAX				equ	10
;
;------------------------------------------------------------------------------
;
; ====================
; SetWindowPos() flags
; ====================
;
SWP_NOSIZE			equ	0001h
SWP_NOMOVE			equ	0002h
SWP_NOZORDER			equ	0004h
SWP_NOREDRAW			equ	0008h
SWP_NOACTIVATE			equ	0010h
SWP_FRAMECHANGED		equ	0020h
SWP_SHOWWINDOW			equ	0040h
SWP_HIDEWINDOW			equ	0080h
SWP_NOCOPYBITS			equ	0100h
SWP_NOOWNERZORDER		equ	0200h
SWP_NOSENDCHANGING		equ	0400h
SWP_DEFERERASE			equ	2000h
SWP_ASYNCWINDOWPOS		equ	4000h
;
SWP_DRAWFRAME			equ	SWP_FRAMECHANGED
SWP_NOREPOSITION		equ	SWP_NOOWNERZORDER
;
;------------------------------------------------------------------------------
;
; ======================
; text alignment options
; ======================
;
TA_NOUPDATECP			equ	0000h
TA_UPDATECP			equ	0001h
;
TA_LEFT				equ	0000h
TA_RIGHT			equ	0002h
TA_CENTER			equ	0006h
;
TA_TOP				equ	0000h
TA_BOTTOM			equ	0008h
TA_BASELINE			equ	0018h
TA_RTLREADING			equ	0100h
TA_MASK				equ	TA_BASELINE+TA_CENTER+TA_UPDATECP+\
					TA_RTLREADING
;
;------------------------------------------------------------------------------
;
; ================
; toolbar messages
; ================
;
TB_ENABLEBUTTON			equ	WM_USER+01
TB_CHECKBUTTON			equ	WM_USER+02
TB_PRESSBUTTON			equ	WM_USER+03
TB_HIDEBUTTON			equ	WM_USER+04
TB_INDETERMINATE		equ	WM_USER+05
TB_ISBUTTONENABLED		equ	WM_USER+09
TB_ISBUTTONCHECKED		equ	WM_USER+10
TB_ISBUTTONPRESSED		equ	WM_USER+11
TB_ISBUTTONHIDDEN		equ	WM_USER+12
TB_ISBUTTONINDETERMINATE	equ	WM_USER+13
TB_SETSTATE			equ	WM_USER+17
TB_GETSTATE			equ	WM_USER+18
TB_ADDBITMAP			equ	WM_USER+19
TB_ADDBUTTONS			equ	WM_USER+20
TB_INSERTBUTTON			equ	WM_USER+21
TB_DELETEBUTTON			equ	WM_USER+22
TB_GETBUTTON			equ	WM_USER+23
TB_BUTTONCOUNT			equ	WM_USER+24
TB_COMMANDTOINDEX		equ	WM_USER+25
TB_SAVERESTOREA			equ	WM_USER+26
TB_CUSTOMIZE			equ	WM_USER+27
TB_ADDSTRINGA			equ	WM_USER+28
TB_GETITEMRECT			equ	WM_USER+29
TB_BUTTONSTRUCTSIZE		equ	WM_USER+30
TB_SETBUTTONSIZE		equ	WM_USER+31
TB_SETBITMAPSIZE		equ	WM_USER+32
TB_AUTOSIZE			equ	WM_USER+33
TB_GETTOOLTIPS			equ	WM_USER+35
TB_SETTOOLTIPS			equ	WM_USER+36
TB_SETPARENT			equ	WM_USER+37
TB_SETROWS			equ	WM_USER+39
TB_GETROWS			equ	WM_USER+40
TB_GETBITMAPFLAGS		equ	WM_USER+41
TB_SETCMDID			equ	WM_USER+42
TB_CHANGEBITMAP			equ	WM_USER+43
TB_GETBITMAP			equ	WM_USER+44
TB_GETBUTTONTEXTA		equ	WM_USER+45
TB_REPLACEBITMAP		equ	WM_USER+46
;
TB_GETBUTTONTEXTW		equ	WM_USER+75
TB_SAVERESTOREW			equ	WM_USER+76
TB_ADDSTRINGW			equ	WM_USER+77
;
				if	UNICODE
TB_GETBUTTONTEXT		equ	TB_GETBUTTONTEXTW
TB_SAVERESTORE			equ	TB_SAVERESTOREW
TB_ADDSTRING			equ	TB_ADDSTRINGW
				else
TB_GETBUTTONTEXT		equ	TB_GETBUTTONTEXTA
TB_SAVERESTORE			equ	TB_SAVERESTOREA
TB_ADDSTRING			equ	TB_ADDSTRINGA
				endif
;
;------------------------------------------------------------------------------
;
; =====================
; toolbar notifications
; =====================
;
TBN_FIRST			equ	-700
TBN_LAST			equ	TBN_FIRST-20
;
TBN_GETBUTTONINFOA		equ	TBN_FIRST-00
TBN_BEGINDRAG			equ	TBN_FIRST-01
TBN_ENDDRAG			equ	TBN_FIRST-02
TBN_BEGINADJUST			equ	TBN_FIRST-03
TBN_ENDADJUST			equ	TBN_FIRST-04
TBN_RESET			equ	TBN_FIRST-05
TBN_QUERYINSERT			equ	TBN_FIRST-06
TBN_QUERYDELETE			equ	TBN_FIRST-07
TBN_TOOLBARCHANGE		equ	TBN_FIRST-08
TBN_CUSTHELP			equ	TBN_FIRST-09
TBN_GETBUTTONINFOW		equ	TBN_FIRST-20
;
;------------------------------------------------------------------------------
;
; ==============
; toolbar states
; ==============
;
TBSTATE_CHECKED			equ	0001h
TBSTATE_PRESSED			equ	0002h
TBSTATE_ENABLED			equ	0004h
TBSTATE_HIDDEN			equ	0008h
TBSTATE_INDETERMINATE		equ	0010h
TBSTATE_WRAP			equ	0020h
;
;------------------------------------------------------------------------------
;
; ==============
; toolbar styles
; ==============
;
TBSTYLE_BUTTON			equ	0000h
TBSTYLE_SEP			equ	0001h
TBSTYLE_CHECK			equ	0002h
TBSTYLE_GROUP			equ	0004h
TBSTYLE_TOOLTIPS		equ	0100h
TBSTYLE_WRAPABLE		equ	0200h
TBSTYLE_ALTDRAG			equ	0400h
;
TBSTYLE_CHECKGROUP		equ	TBSTYLE_GROUP+TBSTYLE_CHECK
;
;------------------------------------------------------------------------------
;
; ===========
; tcp options
; ===========
;
TCP_NODELAY			equ	0001h
TCP_BSDURGENT			equ	7000h
;
;------------------------------------------------------------------------------
;
; ===================
; transmit file codes
; ===================
;
TF_DISCONNECT			equ	0001h
TF_REUSE_SOCKET			equ	0002h
;
;------------------------------------------------------------------------------
;
; ===================
; thread access flags
; ===================
;
THREAD_TERMINATE		equ	0001h
THREAD_SUSPEND_RESUME		equ	0002h
THREAD_GET_CONTEXT		equ	0008h
THREAD_SET_CONTEXT		equ	0010h
THREAD_SET_INFORMATION		equ	0020h
THREAD_QUERY_INFORMATION	equ	0040h
THREAD_SET_THREAD_TOKEN		equ	0080h
THREAD_IMPERSONATE		equ	0100h
THREAD_DIRECT_IMPERSONATION	equ	0200h
;
THREAD_ALL_ACCESS		equ	STANDARD_RIGHTS_REQUIRED+\
					SYNCHRONIZE+\
					03FFh
;
;------------------------------------------------------------------------------
;
; =================
; thread priorities
; =================
;
THREAD_BASE_PRIORITY_IDLE	equ	-15
THREAD_BASE_PRIORITY_MIN	equ	 -2
THREAD_BASE_PRIORITY_MAX	equ	  2
THREAD_BASE_PRIORITY_LOWRT	equ	 15
;
THREAD_PRIORITY_LOWEST		equ	THREAD_BASE_PRIORITY_MIN
THREAD_PRIORITY_BELOW_NORMAL	equ	THREAD_PRIORITY_LOWEST+1
THREAD_PRIORITY_NORMAL		equ	  0
THREAD_PRIORITY_ABOVE_NORMAL	equ	THREAD_PRIORITY_HIGHEST-1
THREAD_PRIORITY_HIGHEST		equ	THREAD_BASE_PRIORITY_MAX
;
THREAD_PRIORITY_TIME_CRITICAL	equ	THREAD_BASE_PRIORITY_LOWRT
THREAD_PRIORITY_IDLE		equ	THREAD_BASE_PRIORITY_IDLE
;
THREAD_PRIORITY_ERROR_RETURN	equ	 -1
;
;------------------------------------------------------------------------------
;
; ==================
; tree view messages
; ==================
;
TVM_FIRST			equ	1100h
TV_FIRST			equ	TVM_FIRST
;
TVM_INSERTITEMA			equ	TVM_FIRST+00
TVM_DELETEITEM			equ	TVM_FIRST+01
TVM_EXPAND			equ	TVM_FIRST+02
TVM_GETITEMRECT			equ	TVM_FIRST+04
TVM_GETCOUNT			equ	TVM_FIRST+05
TVM_GETINDENT			equ	TVM_FIRST+06
TVM_SETINDENT			equ	TVM_FIRST+07
TVM_GETIMAGELIST		equ	TVM_FIRST+08
TVM_SETIMAGELIST		equ	TVM_FIRST+09
TVM_GETNEXTITEM			equ	TVM_FIRST+10
TVM_SELECTITEM			equ	TVM_FIRST+11
TVM_GETITEMA			equ	TVM_FIRST+12
TVM_SETITEMA			equ	TVM_FIRST+13
TVM_EDITLABELA			equ	TVM_FIRST+14
TVM_GETEDITCONTROL		equ	TVM_FIRST+15
TVM_GETVISIBLECOUNT		equ	TVM_FIRST+16
TVM_HITTEST			equ	TVM_FIRST+17
TVM_CREATEDRAGIMAGE		equ	TVM_FIRST+18
TVM_SORTCHILDREN		equ	TVM_FIRST+19
TVM_ENSUREVISIBLE		equ	TVM_FIRST+20
TVM_SORTCHILDRENCB		equ	TVM_FIRST+21
TVM_ENDEDITLABELNOW		equ	TVM_FIRST+22
TVM_GETISEARCHSTRINGA		equ	TVM_FIRST+23
;
TVM_INSERTITEMW			equ	TVM_FIRST+50
TVM_GETITEMW			equ	TVM_FIRST+62
TVM_SETITEMW			equ	TVM_FIRST+63
TVM_GETISEARCHSTRINGW		equ	TVM_FIRST+64
TVM_EDITLABELW			equ	TVM_FIRST+65
;
				if	UNICODE
TVM_INSERTITEM			equ	TVM_INSERTITEMW
TVM_GETITEM			equ	TVM_GETITEMW
TVM_SETITEM			equ	TVM_SETITEMW
TVM_GETISEARCHSTRING		equ	TVM_GETISEARCHSTRINGW
TVM_EDITLABEL			equ	TVM_EDITLABELW
				else
TVM_INSERTITEM			equ	TVM_INSERTITEMA
TVM_GETITEM			equ	TVM_GETITEMA
TVM_SETITEM			equ	TVM_SETITEMA
TVM_GETISEARCHSTRING		equ	TVM_GETISEARCHSTRINGA
TVM_EDITLABEL			equ	TVM_EDITLABELA
				endif
;
;------------------------------------------------------------------------------
;
; =======================
; tree view notifications
; =======================
;
TVN_FIRST			equ	-400
TVN_LAST			equ	TVN_FIRST-99
;
TVN_SELCHANGINGA		equ	TVN_FIRST-01
TVN_SELCHANGEDA			equ	TVN_FIRST-02
TVN_GETDISPINFOA		equ	TVN_FIRST-03
TVN_SETDISPINFOA		equ	TVN_FIRST-04
TVN_ITEMEXPANDINGA		equ	TVN_FIRST-05
TVN_ITEMEXPANDEDA		equ	TVN_FIRST-06
TVN_BEGINDRAGA			equ	TVN_FIRST-07
TVN_BEGINRDRAGA			equ	TVN_FIRST-08
TVN_DELETEITEMA			equ	TVN_FIRST-09
TVN_ENDLABELEDITA		equ	TVN_FIRST-11
TVN_KEYDOWN			equ	TVN_FIRST-12
;
TVN_SELCHANGINGW		equ	TVN_FIRST-50
TVN_SELCHANGEDW			equ	TVN_FIRST-51
TVN_GETDISPINFOW		equ	TVN_FIRST-52
TVN_SETDISPINFOW		equ	TVN_FIRST-53
TVN_ITEMEXPANDINGW		equ	TVN_FIRST-54
TVN_ITEMEXPANDEDW		equ	TVN_FIRST-55
TVN_BEGINDRAGW			equ	TVN_FIRST-56
TVN_BEGINRDRAGW			equ	TVN_FIRST-57
TVN_DELETEITEMW			equ	TVN_FIRST-58
TVN_BEGINLABELEDITA		equ	TVN_FIRST-10
TVN_BEGINLABELEDITW		equ	TVN_FIRST-59
TVN_ENDLABELEDITW		equ	TVN_FIRST-60
;
				if	UNICODE
TVN_SELCHANGING			equ	TVN_SELCHANGINGW
TVN_SELCHANGED			equ	TVN_SELCHANGEDW
TVN_GETDISPINFO			equ	TVN_GETDISPINFOW
TVN_SETDISPINFO			equ	TVN_SETDISPINFOW
TVN_ITEMEXPANDING		equ	TVN_ITEMEXPANDINGW
TVN_ITEMEXPANDED		equ	TVN_ITEMEXPANDEDW
TVN_BEGINDRAG			equ	TVN_BEGINDRAGW
TVN_BEGINRDRAG			equ	TVN_BEGINRDRAGW
TVN_DELETEITEM			equ	TVN_DELETEITEMW
TVN_BEGINLABELEDIT		equ	TVN_BEGINLABELEDITW
TVN_ENDLABELEDIT		equ	TVN_ENDLABELEDITW
				else
TVN_SELCHANGING			equ	TVN_SELCHANGINGA
TVN_SELCHANGED			equ	TVN_SELCHANGEDA
TVN_GETDISPINFO			equ	TVN_GETDISPINFOA
TVN_SETDISPINFO			equ	TVN_SETDISPINFOA
TVN_ITEMEXPANDING		equ	TVN_ITEMEXPANDINGA
TVN_ITEMEXPANDED		equ	TVN_ITEMEXPANDEDA
TVN_BEGINDRAG			equ	TVN_BEGINDRAGA
TVN_BEGINRDRAG			equ	TVN_BEGINRDRAGA
TVN_DELETEITEM			equ	TVN_DELETEITEMA
TVN_BEGINLABELEDIT		equ	TVN_BEGINLABELEDITA
TVN_ENDLABELEDIT		equ	TVN_ENDLABELEDITA
				endif
;
;------------------------------------------------------------------------------
;
; ================
; tree view styles
; ================
;
TVS_HASBUTTONS			equ	00000001h
TVS_HASLINES			equ	00000002h
TVS_LINESATROOT			equ	00000004h
TVS_EDITLABELS			equ	00000008h
TVS_DISABLEDRAGDROP		equ	00000010h
TVS_SHOWSELALWAYS		equ	00000020h
;
;------------------------------------------------------------------------------
;
; ================
; os platform id's
; ================
;
VER_PLATFORM_WIN32s		equ	0
VER_PLATFORM_WIN32_WINDOWS	equ	1
VER_PLATFORM_WIN32_NT		equ	2
;
;------------------------------------------------------------------------------
;
; ====================
; toolbar view bitmaps
; ====================
;
VIEW_LARGEICONS			equ	 0
VIEW_SMALLICONS			equ	 1
VIEW_LIST			equ	 2
VIEW_DETAILS			equ	 3
VIEW_SORTNAME			equ	 4
VIEW_SORTSIZE			equ	 5
VIEW_SORTDATE			equ	 6
VIEW_SORTTYPE			equ	 7
VIEW_PARENTFOLDER		equ	 8
VIEW_NETCONNECT			equ	 9
VIEW_NETDISCONNECT		equ	10
VIEW_NEWFOLDER			equ	11
;
;------------------------------------------------------------------------------
;
; =====================
; standard virtual keys
; =====================
;
VK_LBUTTON			equ	01h
VK_RBUTTON			equ	02h
VK_CANCEL			equ	03h
VK_MBUTTON			equ	04h
;
VK_BACK				equ	08h
VK_TAB				equ	09h
VK_CLEAR			equ	0Ch
VK_RETURN			equ	0Dh
VK_SHIFT			equ	10h
VK_CONTROL			equ	11h
VK_MENU				equ	12h
VK_PAUSE			equ	13h
VK_CAPITAL			equ	14h
VK_ESCAPE			equ	1Bh
;
VK_SPACE			equ	20h
VK_PRIOR			equ	21h
VK_NEXT				equ	22h
VK_END				equ	23h
VK_HOME				equ	24h
VK_LEFT				equ	25h
VK_UP				equ	26h
VK_RIGHT			equ	27h
VK_DOWN				equ	28h
VK_SELECT			equ	29h
VK_PRINT			equ	2Ah
VK_EXECUTE			equ	2Bh
VK_SNAPSHOT			equ	2Ch
VK_INSERT			equ	2Dh
VK_DELETE			equ	2Eh
VK_HELP				equ	2Fh
;
VK_LWIN				equ	5Bh
VK_RWIN				equ	5Ch
VK_APPS				equ	5Dh
;
VK_NUMPAD0			equ	60h
VK_NUMPAD1			equ	61h
VK_NUMPAD2			equ	62h
VK_NUMPAD3			equ	63h
VK_NUMPAD4			equ	64h
VK_NUMPAD5			equ	65h
VK_NUMPAD6			equ	66h
VK_NUMPAD7			equ	67h
VK_NUMPAD8			equ	68h
VK_NUMPAD9			equ	69h
VK_MULTIPLY			equ	6Ah
VK_ADD				equ	6Bh
VK_SEPARATOR			equ	6Ch
VK_SUBTRACT			equ	6Dh
VK_DECIMAL			equ	6Eh
VK_DIVIDE			equ	6Fh
VK_F1				equ	70h
VK_F2				equ	71h
VK_F3				equ	72h
VK_F4				equ	73h
VK_F5				equ	74h
VK_F6				equ	75h
VK_F7				equ	76h
VK_F8				equ	77h
VK_F9				equ	78h
VK_F10				equ	79h
VK_F11				equ	7Ah
VK_F12				equ	7Bh
VK_F13				equ	7Ch
VK_F14				equ	7Dh
VK_F15				equ	7Eh
VK_F16				equ	7Fh
VK_F17				equ	80h
VK_F18				equ	81h
VK_F19				equ	82h
VK_F20				equ	83h
VK_F21				equ	84h
VK_F22				equ	85h
VK_F23				equ	86h
VK_F24				equ	87h
;
VK_NUMLOCK			equ	90h
VK_SCROLL			equ	91h
;
;------------------------------------------------------------------------------
;
; ====================
; special virtual keys
; ====================
;
VK_LSHIFT			equ	0A0h
VK_RSHIFT			equ	0A1h
VK_LCONTROL			equ	0A2h
VK_RCONTROL			equ	0A3h
VK_LMENU			equ	0A4h
VK_RMENU			equ	0A5h
;
VK_PROCESSKEY			equ	0E5h
;
VK_ATTN				equ	0F6h
VK_CRSEL			equ	0F7h
VK_EXSEL			equ	0F8h
VK_EREOF			equ	0F9h
VK_PLAY				equ	0FAh
VK_ZOOM				equ	0FBh
VK_NONAME			equ	0FCh
VK_PA1				equ	0FDh
VK_OEM_CLEAR			equ	0FEh
;
;------------------------------------------------------------------------------
;
; ================
; netware vlm id's
; ================
;
VLM_ID_VLM				equ	0001h
VLM_ID_CONN				equ	0010h
VLM_ID_TRAN				equ	0020h
VLM_ID_IPXNCP				equ	0021h
VLM_ID_TCPNCP				equ	0022h
VLM_ID_NWP				equ	0030h
VLM_ID_BIND				equ	0031h
VLM_ID_NDS				equ	0032h
VLM_ID_PNW				equ	0033h
VLM_ID_RSA				equ	0034h
VLM_ID_REDIR				equ	0040h
VLM_ID_FIO				equ	0041h
VLM_ID_PRINT				equ	0042h
VLM_ID_GENERAL				equ	0043h
VLM_ID_NETX				equ	0050h
VLM_ID_AUTO				equ	0060h
VLM_ID_SECURITY				equ	0061h
VLM_ID_NMR				equ	0100h
;
;------------------------------------------------------------------------------
;
; =====================
; netware vlm functions
; =====================
;
VLM_TRAN_REQ				equ	0006h
;
;------------------------------------------------------------------------------
;
; =================
; wait status codes
; =================
;
WAIT_FAILED			equ	-1
WAIT_OBJECT_0			equ	STATUS_WAIT_0
;
WAIT_ABANDONED			equ	STATUS_ABANDONED_WAIT_0
WAIT_ABANDONED_0		equ	STATUS_ABANDONED_WAIT_0
;
WAIT_TIMEOUT			equ	STATUS_TIMEOUT
WAIT_IO_COMPLETION		equ	STATUS_USER_APC
STILL_ACTIVE			equ	STATUS_PENDING
;
MAXIMUM_WAIT_OBJECTS		equ	 64
MAXIMUM_SUSPEND_COUNT		equ	127
INFINITE			equ	 -1
;
;------------------------------------------------------------------------------
;
; ================
; winsock versions
; ================
;
WINSOCK_1_0			equ	0001h		;winsock 1.0
WINSOCK_1_1			equ	0101h		;winsock 1.1
WINSOCK_2_0			equ	0002h		;winsock 2.0
;
;------------------------------------------------------------------------------
;
; ===============
; window messages
; ===============
;
WM_NULL				equ	0000h
WM_CREATE			equ	0001h
WM_DESTROY			equ	0002h
WM_MOVE				equ	0003h
WM_SIZE				equ	0005h
WM_ACTIVATE			equ	0006h
WM_SETFOCUS			equ	0007h
WM_KILLFOCUS			equ	0008h
WM_ENABLE			equ	000Ah
WM_SETREDRAW			equ	000Bh
WM_SETTEXT			equ	000Ch
WM_GETTEXT			equ	000Dh
WM_GETTEXTLENGTH		equ	000Eh
WM_PAINT			equ	000Fh
WM_CLOSE			equ	0010h
WM_QUERYENDSESSION		equ	0011h
WM_QUIT				equ	0012h
WM_QUERYOPEN			equ	0013h
WM_ERASEBKGND			equ	0014h
WM_SYSCOLORCHANGE		equ	0015h
WM_ENDSESSION			equ	0016h
WM_SHOWWINDOW			equ	0018h
WM_WININICHANGE			equ	001Ah
WM_SETTINGCHANGE		equ	WM_WININICHANGE
WM_DEVMODECHANGE		equ	001Bh
WM_ACTIVATEAPP			equ	001Ch
WM_FONTCHANGE			equ	001Dh
WM_TIMECHANGE			equ	001Eh
WM_CANCELMODE			equ	001Fh
WM_SETCURSOR			equ	0020h
WM_MOUSEACTIVATE		equ	0021h
WM_CHILDACTIVATE		equ	0022h
WM_QUEUESYNC			equ	0023h
WM_GETMINMAXINFO		equ	0024h
WM_PAINTICON			equ	0026h
WM_ICONERASEBKGND		equ	0027h
WM_NEXTDLGCTL			equ	0028h
WM_SPOOLERSTATUS		equ	002Ah
WM_DRAWITEM			equ	002Bh
WM_MEASUREITEM			equ	002Ch
WM_DELETEITEM			equ	002Dh
WM_VKEYTOITEM			equ	002Eh
WM_CHARTOITEM			equ	002Fh
WM_SETFONT			equ	0030h
WM_GETFONT			equ	0031h
WM_SETHOTKEY			equ	0032h
WM_GETHOTKEY			equ	0033h
WM_QUERYDRAGICON		equ	0037h
WM_COMPAREITEM			equ	0039h
WM_COMPACTING			equ	0041h
WM_COMMNOTIFY			equ	0044h		;no longer suported
WM_WINDOWPOSCHANGING		equ	0046h
WM_WINDOWPOSCHANGED		equ	0047h
WM_POWER			equ	0048h
WM_COPYDATA			equ	004Ah
WM_CANCELJOURNAL		equ	004Bh
WM_NOTIFY			equ	004Eh
WM_INPUTLANGCHANGEREQUEST	equ	0050h
WM_INPUTLANGCHANGE		equ	0051h
WM_TCARD			equ	0052h
WM_HELP				equ	0053h
WM_USERCHANGED			equ	0054h
WM_NOTIFYFORMAT			equ	0055h
WM_CONTEXTMENU			equ	007Bh
WM_STYLECHANGING		equ	007Ch
WM_STYLECHANGED			equ	007Dh
WM_DISPLAYCHANGE		equ	007Eh
WM_GETICON			equ	007Fh
WM_SETICON			equ	0080h
WM_NCCREATE			equ	0081h
WM_NCDESTROY			equ	0082h
WM_NCCALCSIZE			equ	0083h
WM_NCHITTEST			equ	0084h
WM_NCPAINT			equ	0085h
WM_NCACTIVATE			equ	0086h
WM_GETDLGCODE			equ	0087h
;
WM_NCMOUSEMOVE			equ	00A0h
WM_NCLBUTTONDOWN		equ	00A1h
WM_NCLBUTTONUP			equ	00A2h
WM_NCLBUTTONDBLCLK		equ	00A3h
WM_NCRBUTTONDOWN		equ	00A4h
WM_NCRBUTTONUP			equ	00A5h
WM_NCRBUTTONDBLCLK		equ	00A6h
WM_NCMBUTTONDOWN		equ	00A7h
WM_NCMBUTTONUP			equ	00A8h
WM_NCMBUTTONDBLCLK		equ	00A9h
;
WM_KEYFIRST			equ	0100h
WM_KEYDOWN			equ	0100h
WM_KEYUP			equ	0101h
WM_CHAR				equ	0102h
WM_DEADCHAR			equ	0103h
WM_SYSKEYDOWN			equ	0104h
WM_SYSKEYUP			equ	0105h
WM_SYSCHAR			equ	0106h
WM_SYSDEADCHAR			equ	0107h
WM_KEYLAST			equ	0108h
;
WM_IME_STARTCOMPOSITION		equ	010Dh
WM_IME_ENDCOMPOSITION		equ	010Eh
WM_IME_COMPOSITION		equ	010Fh
WM_IME_KEYLAST			equ	010Fh
WM_INITDIALOG			equ	0110h
WM_COMMAND			equ	0111h
WM_SYSCOMMAND			equ	0112h
WM_TIMER			equ	0113h
WM_HSCROLL			equ	0114h
WM_VSCROLL			equ	0115h
WM_INITMENU			equ	0116h
WM_INITMENUPOPUP		equ	0117h
WM_MENUSELECT			equ	011Fh
WM_MENUCHAR			equ	0120h
WM_ENTERIDLE			equ	0121h
WM_CTLCOLORMSGBOX		equ	0132h
WM_CTLCOLOREDIT			equ	0133h
WM_CTLCOLORLISTBOX		equ	0134h
WM_CTLCOLORBTN			equ	0135h
WM_CTLCOLORDLG			equ	0136h
WM_CTLCOLORSCROLLBAR		equ	0137h
WM_CTLCOLORSTATIC		equ	0138h
;
WM_MOUSEFIRST			equ	0200h
WM_MOUSEMOVE			equ	0200h
WM_LBUTTONDOWN			equ	0201h
WM_LBUTTONUP			equ	0202h
WM_LBUTTONDBLCLK		equ	0203h
WM_RBUTTONDOWN			equ	0204h
WM_RBUTTONUP			equ	0205h
WM_RBUTTONDBLCLK		equ	0206h
WM_MBUTTONDOWN			equ	0207h
WM_MBUTTONUP			equ	0208h
WM_MBUTTONDBLCLK		equ	0209h
WM_MOUSELAST			equ	0209h
;
WM_PARENTNOTIFY			equ	0210h
WM_ENTERMENULOOP		equ	0211h
WM_EXITMENULOOP			equ	0212h
WM_NEXTMENU			equ	0213h
WM_SIZING			equ	0214h
WM_CAPTURECHANGED		equ	0215h
WM_MOVING			equ	0216h
WM_POWERBROADCAST		equ	0218h
WM_DEVICECHANGE			equ	0219h
WM_MDICREATE			equ	0220h
WM_MDIDESTROY			equ	0221h
WM_MDIACTIVATE			equ	0222h
WM_MDIRESTORE			equ	0223h
WM_MDINEXT			equ	0224h
WM_MDIMAXIMIZE			equ	0225h
WM_MDITILE			equ	0226h
WM_MDICASCADE			equ	0227h
WM_MDIICONARRANGE		equ	0228h
WM_MDIGETACTIVE			equ	0229h
WM_MDISETMENU			equ	0230h
WM_ENTERSIZEMOVE		equ	0231h
WM_EXITSIZEMOVE			equ	0232h
WM_DROPFILES			equ	0233h
WM_MDIREFRESHMENU		equ	0234h
;
WM_IME_SETCONTEXT		equ	0281h
WM_IME_NOTIFY			equ	0282h
WM_IME_CONTROL			equ	0283h
WM_IME_COMPOSITIONFULL		equ	0284h
WM_IME_SELECT			equ	0285h
WM_IME_CHAR			equ	0286h
WM_IME_KEYDOWN			equ	0290h
WM_IME_KEYUP			equ	0291h
;
WM_CUT				equ	0300h
WM_COPY				equ	0301h
WM_PASTE			equ	0302h
WM_CLEAR			equ	0303h
WM_UNDO				equ	0304h
WM_RENDERFORMAT			equ	0305h
WM_RENDERALLFORMATS		equ	0306h
WM_DESTROYCLIPBOARD		equ	0307h
WM_DRAWCLIPBOARD		equ	0308h
WM_PAINTCLIPBOARD		equ	0309h
WM_VSCROLLCLIPBOARD		equ	030Ah
WM_SIZECLIPBOARD		equ	030Bh
WM_ASKCBFORMATNAME		equ	030Ch
WM_CHANGECBCHAIN		equ	030Dh
WM_HSCROLLCLIPBOARD		equ	030Eh
WM_QUERYNEWPALETTE		equ	030Fh
WM_PALETTEISCHANGING		equ	0310h
WM_PALETTECHANGED		equ	0311h
WM_HOTKEY			equ	0312h
WM_PRINT			equ	0317h
WM_PRINTCLIENT			equ	0318h
;
WM_HANDHELDFIRST		equ	0358h
WM_HANDHELDLAST			equ	035Fh
;
WM_AFXFIRST			equ	0360h
WM_AFXLAST			equ	037Fh
;
WM_PENWINFIRST			equ	0380h
WM_PENWINLAST			equ	038Fh
;
WM_DDE_FIRST			equ	03E0h
WM_DDE_INITIATE			equ	WM_DDE_FIRST
WM_DDE_TERMINATE		equ	WM_DDE_FIRST+1
WM_DDE_ADVISE			equ	WM_DDE_FIRST+2
WM_DDE_UNADVISE			equ	WM_DDE_FIRST+3
WM_DDE_ACK			equ	WM_DDE_FIRST+4
WM_DDE_DATA			equ	WM_DDE_FIRST+5
WM_DDE_REQUEST			equ	WM_DDE_FIRST+6
WM_DDE_POKE			equ	WM_DDE_FIRST+7
WM_DDE_EXECUTE			equ	WM_DDE_FIRST+8
WM_DDE_LAST			equ	03E8h
;
WM_USER				equ	0400h
WM_APP				equ	8000h
;
;------------------------------------------------------------------------------
;
; ====================
; WNet*() status codes
; ====================
;
WN_SUCCESS			equ	NO_ERROR
WN_NO_ERROR			equ	NO_ERROR
;
WN_NOT_SUPPORTED		equ	ERROR_NOT_SUPPORTED
WN_CANCEL			equ	ERROR_CANCELLED
WN_RETRY			equ	ERROR_RETRY
WN_NET_ERROR			equ	ERROR_UNEXP_NET_ERR
WN_MORE_DATA			equ	ERROR_MORE_DATA
WN_BAD_POINTER			equ	ERROR_INVALID_ADDRESS
WN_BAD_VALUE			equ	ERROR_INVALID_PARAMETER
WN_BAD_USER			equ	ERROR_BAD_USERNAME
WN_BAD_PASSWORD			equ	ERROR_INVALID_PASSWORD
WN_ACCESS_DENIED		equ	ERROR_ACCESS_DENIED
WN_FUNCTION_BUSY		equ	ERROR_BUSY
WN_WINDOWS_ERROR		equ	ERROR_UNEXP_NET_ERR
WN_OUT_OF_MEMORY		equ	ERROR_NOT_ENOUGH_MEMORY
WN_NO_NETWORK			equ	ERROR_NO_NETWORK
WN_EXTENDED_ERROR		equ	ERROR_EXTENDED_ERROR
WN_BAD_LEVEL			equ	ERROR_INVALID_LEVEL
WN_BAD_HANDLE			equ	ERROR_INVALID_HANDLE
WN_NOT_INITIALIZING		equ	ERROR_ALREADY_INITIALIZED
WN_NO_MORE_DEVICES		equ	ERROR_NO_MORE_DEVICES
;
WN_NOT_CONNECTED		equ	ERROR_NOT_CONNECTED
WN_OPEN_FILES			equ	ERROR_OPEN_FILES
WN_DEVICE_IN_USE		equ	ERROR_DEVICE_IN_USE
WN_BAD_NETNAME			equ	ERROR_BAD_NET_NAME
WN_BAD_LOCALNAME		equ	ERROR_BAD_DEVICE
WN_ALREADY_CONNECTED		equ	ERROR_ALREADY_ASSIGNED
WN_DEVICE_ERROR			equ	ERROR_GEN_FAILURE
WN_CONNECTION_CLOSED		equ	ERROR_CONNECTION_UNAVAIL
WN_NO_NET_OR_BAD_PATH		equ	ERROR_NO_NET_OR_BAD_PATH
WN_BAD_PROVIDER			equ	ERROR_BAD_PROVIDER
WN_CANNOT_OPEN_PROFILE		equ	ERROR_CANNOT_OPEN_PROFILE
WN_BAD_PROFILE			equ	ERROR_BAD_PROFILE
WN_BAD_DEV_TYPE			equ	ERROR_BAD_DEV_TYPE
WN_DEVICE_ALREADY_REMEMBERED	equ	ERROR_DEVICE_ALREADY_REMEMBERED
;
WN_NO_MORE_ENTRIES		equ	ERROR_NO_MORE_ITEMS
WN_NOT_CONTAINER		equ	ERROR_NOT_CONTAINER
;
WN_NOT_AUTHENTICATED		equ	ERROR_NOT_AUTHENTICATED
WN_NOT_LOGGED_ON		equ	ERROR_NOT_LOGGED_ON
WN_NOT_VALIDATED		equ	ERROR_NO_LOGON_SERVERS
;
;------------------------------------------------------------------------------
;
; =============
; network types
; =============
;
WNNC_NET_MSNET			equ	00010000h
WNNC_NET_LANMAN			equ	00020000h
WNNC_NET_NETWARE		equ	00030000h
WNNC_NET_VINES			equ	00040000h
WNNC_NET_10NET			equ	00050000h
WNNC_NET_LOCUS			equ	00060000h
WNNC_NET_SUN_PC_NFS		equ	00070000h
WNNC_NET_LANSTEP		equ	00080000h
WNNC_NET_9TILES			equ	00090000h
WNNC_NET_LANTASTIC		equ	000A0000h
WNNC_NET_AS400			equ	000B0000h
WNNC_NET_FTP_NFS		equ	000C0000h
WNNC_NET_PATHWORKS		equ	000D0000h
WNNC_NET_LIFENET		equ	000E0000h
WNNC_NET_POWERLAN		equ	000F0000h
WNNC_NET_BWNFS			equ	00100000h
WNNC_NET_COGENT			equ	00110000h
WNNC_NET_FARALLON		equ	00120000h
WNNC_NET_APPLETALK		equ	00130000h
;
;------------------------------------------------------------------------------
;
; =============
; window styles
; =============
;
WS_OVERLAPPED			equ	00000000h
WS_TABSTOP			equ	00010000h
WS_GROUP			equ	00020000h
WS_MAXIMIZEBOX			equ	00010000h
WS_MINIMIZEBOX			equ	00020000h
WS_THICKFRAME			equ	00040000h
WS_SYSMENU			equ	00080000h
WS_HSCROLL			equ	00100000h
WS_VSCROLL			equ	00200000h
WS_DLGFRAME			equ	00400000h
WS_BORDER			equ	00800000h
WS_MAXIMIZE			equ	01000000h
WS_CLIPCHILDREN			equ	02000000h
WS_CLIPSIBLINGS			equ	04000000h
WS_DISABLED			equ	08000000h
WS_VISIBLE			equ	10000000h
WS_MINIMIZE			equ	20000000h
WS_CHILD			equ	40000000h
WS_POPUP			equ	80000000h
;
WS_CAPTION			equ	WS_BORDER+WS_DLGFRAME
WS_POPUPWINDOW			equ	WS_POPUP+WS_BORDER+WS_SYSMENU
WS_MODAL			equ	WS_CAPTION+WS_SYSMENU+WS_VISIBLE
WS_MODELESS			equ	WS_CAPTION+WS_SYSMENU+WS_VISIBLE
WS_CONTROL			equ	WS_CHILD+WS_VISIBLE
WS_OVERLAPPEDWINDOW		equ	WS_OVERLAPPED+WS_CAPTION+WS_SYSMENU+\
					WS_THICKFRAME+WS_MINIMIZEBOX+\
					WS_MAXIMIZEBOX
;
WS_TILED			equ	WS_OVERLAPPED
WS_CHILDWINDOW			equ	WS_CHILD
WS_ICONIC			equ	WS_MINIMIZE
WS_SIZEBOX			equ	WS_THICKFRAME
WS_TILEDWINDOW			equ	WS_OVERLAPPEDWINDOW
;
;------------------------------------------------------------------------------
;
; ======================
; extended window styles
; ======================
;
WS_EX_NONE			equ	00000000h
WS_EX_DLGMODALFRAME		equ	00000001h
WS_EX_NOPARENTNOTIFY		equ	00000004h
WS_EX_TOPMOST			equ	00000008h
WS_EX_ACCEPTFILES		equ	00000010h
WS_EX_TRANSPARENT		equ	00000020h
WS_EX_MDICHILD			equ	00000040h
WS_EX_TOOLWINDOW		equ	00000080h
WS_EX_WINDOWEDGE		equ	00000100h
WS_EX_CLIENTEDGE		equ	00000200h
WS_EX_CONTEXTHELP		equ	00000400h
WS_EX_RIGHT			equ	00001000h
WS_EX_LEFT			equ	00000000h
WS_EX_RTLREADING		equ	00002000h
WS_EX_LTRREADING		equ	00000000h
WS_EX_LEFTSCROLLBAR		equ	00004000h
WS_EX_RIGHTSCROLLBAR		equ	00000000h
WS_EX_CONTROLPARENT		equ	00010000h
WS_EX_STATICEDGE		equ	00020000h
WS_EX_APPWINDOW			equ	00040000h
;
WS_EX_OVERLAPPEDWINDOW		equ	00000300h
WS_EX_PALETTEWINDOW		equ	00000188h
;
;------------------------------------------------------------------------------
;
; ===================
; winsock error codes
; ===================
;
WSABASEERR			equ	10000
;
WSAEINTR			equ	WSABASEERR+0004
WSAEBADF			equ	WSABASEERR+0009
WSAEACCES			equ	WSABASEERR+0013
WSAEFAULT			equ	WSABASEERR+0014
WSAEINVAL			equ	WSABASEERR+0022
WSAEMFILE			equ	WSABASEERR+0024
;
WSAEWOULDBLOCK			equ	WSABASEERR+0035
WSAEINPROGRESS			equ	WSABASEERR+0036
WSAEALREADY			equ	WSABASEERR+0037
WSAENOTSOCK			equ	WSABASEERR+0038
WSAEDESTADDRREQ			equ	WSABASEERR+0039
WSAEMSGSIZE			equ	WSABASEERR+0040
WSAEPROTOTYPE			equ	WSABASEERR+0041
WSAENOPROTOOPT			equ	WSABASEERR+0042
WSAEPROTONOSUPPORT		equ	WSABASEERR+0043
WSAESOCKTNOSUPPORT		equ	WSABASEERR+0044
WSAEOPNOTSUPP			equ	WSABASEERR+0045
WSAEPFNOSUPPORT			equ	WSABASEERR+0046
WSAEAFNOSUPPORT			equ	WSABASEERR+0047
WSAEADDRINUSE			equ	WSABASEERR+0048
WSAEADDRNOTAVAIL		equ	WSABASEERR+0049
WSAENETDOWN			equ	WSABASEERR+0050
WSAENETUNREACH			equ	WSABASEERR+0051
WSAENETRESET			equ	WSABASEERR+0052
WSAECONNABORTED			equ	WSABASEERR+0053
WSAECONNRESET			equ	WSABASEERR+0054
WSAENOBUFS			equ	WSABASEERR+0055
WSAEISCONN			equ	WSABASEERR+0056
WSAENOTCONN			equ	WSABASEERR+0057
WSAESHUTDOWN			equ	WSABASEERR+0058
WSAETOOMANYREFS			equ	WSABASEERR+0059
WSAETIMEDOUT			equ	WSABASEERR+0060
WSAECONNREFUSED			equ	WSABASEERR+0061
WSAELOOP			equ	WSABASEERR+0062
WSAENAMETOOLONG			equ	WSABASEERR+0063
WSAEHOSTDOWN			equ	WSABASEERR+0064
WSAEHOSTUNREACH			equ	WSABASEERR+0065
WSAENOTEMPTY			equ	WSABASEERR+0066
WSAEPROCLIM			equ	WSABASEERR+0067
WSAEUSERS			equ	WSABASEERR+0068
WSAEDQUOT			equ	WSABASEERR+0069
WSAESTALE			equ	WSABASEERR+0070
WSAEREMOTE			equ	WSABASEERR+0071
WSAEDISCON			equ	WSABASEERR+0101
;
WSASYSNOTREADY			equ	WSABASEERR+0091
WSAVERNOTSUPPORTED		equ	WSABASEERR+0092
WSANOTINITIALISED		equ	WSABASEERR+0093
;
WSAHOST_NOT_FOUND		equ	WSABASEERR+1001
WSATRY_AGAIN			equ	WSABASEERR+1002
WSANO_RECOVERY			equ	WSABASEERR+1003
WSANO_DATA			equ	WSABASEERR+1004
;
WSANO_ADDRESS			equ	WSANO_DATA
;
HOST_NOT_FOUND			equ	WSAHOST_NOT_FOUND
TRY_AGAIN			equ	WSATRY_AGAIN
NO_RECOVERY			equ	WSANO_RECOVERY
NO_DATA				equ	WSANO_DATA
NO_ADDRESS			equ	WSANO_ADDRESS
;
;------------------------------------------------------------------------------
;
; ================
; background modes
; ================
;
TRANSPARENT			equ	1
OPAQUE				equ	2
BKMODE_LAST			equ	2
;
;------------------------------------------------------------------------------
;
; ====================
; CreateFile() actions
; ====================
;
CREATE_NEW			equ	1
CREATE_ALWAYS			equ	2
OPEN_EXISTING			equ	3
OPEN_ALWAYS			equ	4
TRUNCATE_EXISTING		equ	5
;
;------------------------------------------------------------------------------
;
; =====================
; CreateProcess() flags
; =====================
;
DEBUG_PROCESS			equ	00000001h
DEBUG_ONLY_THIS_PROCESS		equ	00000002h
CREATE_SUSPENDED		equ	00000004h
DETACHED_PROCESS		equ	00000008h
CREATE_NEW_CONSOLE		equ	00000010h
NORMAL_PRIORITY_CLASS		equ	00000020h
IDLE_PRIORITY_CLASS		equ	00000040h
HIGH_PRIORITY_CLASS		equ	00000080h
REALTIME_PRIORITY_CLASS		equ	00000100h
;
CREATE_NEW_PROCESS_GROUP	equ	00000200h
CREATE_UNICODE_ENVIRONMENT	equ	00000400h
CREATE_SEPARATE_WOW_VDM		equ	00000800h
CREATE_SHARED_WOW_VDM		equ	00001000h
CREATE_DEFAULT_ERROR_MODE	equ	04000000h
CREATE_NO_WINDOW		equ	08000000h
;
PROFILE_USER			equ	10000000h
PROFILE_KERNEL			equ	20000000h
PROFILE_SERVER			equ	40000000h
;
;------------------------------------------------------------------------------
;
; ===============
; gdi error codes
; ===============
;
GDI_ERROR			equ	-1
HGDI_ERROR			equ	-1
;
;------------------------------------------------------------------------------
;
; =====================
; internet access types
; =====================
;
PRE_CONFIG_INTERNET_ACCESS	equ	0
LOCAL_INTERNET_ACCESS		equ	1
GATEWAY_INTERNET_ACCESS		equ	2
CERN_PROXY_INTERNET_ACCESS	equ	3
;
;------------------------------------------------------------------------------
;
; =================
; memory attributes
; =================
;
PAGE_NOACCESS			equ	00000001h
PAGE_READONLY			equ	00000002h
PAGE_READWRITE			equ	00000004h
PAGE_WRITECOPY			equ	00000008h
PAGE_EXECUTE			equ	00000010h
PAGE_EXECUTE_READ		equ	00000020h
PAGE_EXECUTE_READWRITE		equ	00000040h
PAGE_EXECUTE_WRITECOPY		equ	00000080h
PAGE_GUARD			equ	00000100h
PAGE_NOCACHE			equ	00000200h
;
MEM_COMMIT			equ	00001000h
MEM_RESERVE			equ	00002000h
MEM_DECOMMIT			equ	00004000h
MEM_RELEASE			equ	00008000h
MEM_FREE			equ	00010000h
MEM_PRIVATE			equ	00020000h
MEM_MAPPED			equ	00040000h
MEM_TOP_DOWN			equ	00100000h
;
SEC_FILE			equ	00800000h
SEC_IMAGE			equ	01000000h
SEC_RESERVE			equ	04000000h
SEC_COMMIT			equ	08000000h
SEC_NOCACHE			equ	10000000h
;
MEM_IMAGE			equ	SEC_IMAGE
;
SECTION_QUERY			equ	00000001h
SECTION_MAP_WRITE		equ	00000002h
SECTION_MAP_READ		equ	00000004h
SECTION_MAP_EXECUTE		equ	00000008h
SECTION_EXTEND_SIZE		equ	00000010h
;
SECTION_ALL_ACCESS		equ	STANDARD_RIGHTS_REQUIRED+\
					SECTION_QUERY+\
					SECTION_MAP_WRITE+\
					SECTION_MAP_READ+\
					SECTION_MAP_EXECUTE+\
					SECTION_EXTEND_SIZE
;
FILE_MAP_COPY			equ	SECTION_QUERY
FILE_MAP_WRITE			equ	SECTION_MAP_WRITE
FILE_MAP_READ			equ	SECTION_MAP_READ
FILE_MAP_ALL_ACCESS		equ	SECTION_ALL_ACCESS
;
;------------------------------------------------------------------------------
;
; ================
; PolyFill() modes
; ================
;
ALTERNATE			equ	1
WINDING				equ	2
POLYFILL_LAST			equ	2
;
;------------------------------------------------------------------------------
;
; ============
; region flags
; ============
;
ERROR				equ	0
NULLREGION			equ	1
SIMPLEREGION			equ	2
COMPLEXREGION			equ	3
RGN_ERROR			equ	ERROR
;
;------------------------------------------------------------------------------
;
; =====================
; standard access types
; =====================
;
DELETE				equ	00010000h
READ_CONTROL			equ	00020000h
WRITE_DAC			equ	00040000h
WRITE_OWNER			equ	00080000h
SYNCHRONIZE			equ	00100000h
;
SPECIFIC_RIGHTS_ALL		equ	0000FFFFh
STANDARD_RIGHTS_REQUIRED	equ	000F0000h
STANDARD_RIGHTS_ALL		equ	001F0000h
;
STANDARD_RIGHTS_READ		equ	READ_CONTROL
STANDARD_RIGHTS_WRITE		equ	READ_CONTROL
STANDARD_RIGHTS_EXECUTE		equ	READ_CONTROL
;
;------------------------------------------------------------------------------
;
; =====================
; stock logical objects
; =====================
;
WHITE_BRUSH			equ	 0
LTGRAY_BRUSH			equ	 1
GRAY_BRUSH			equ	 2
DKGRAY_BRUSH			equ	 3
BLACK_BRUSH			equ	 4
NULL_BRUSH			equ	 5
WHITE_PEN			equ	 6
BLACK_PEN			equ	 7
NULL_PEN			equ	 8
OEM_FIXED_FONT			equ	10
ANSI_FIXED_FONT			equ	11
ANSI_VAR_FONT			equ	12
SYSTEM_FONT			equ	13
DEVICE_DEFAULT_FONT		equ	14
DEFAULT_PALETTE			equ	15
SYSTEM_FIXED_FONT		equ	16
DEFAULT_GUI_FONT		equ	17
;
HOLLOW_BRUSH			equ	NULL_BRUSH
;
;------------------------------------------------------------------------------
;
; ==================
; StretchBlt() modes
; ==================
;
BLACKONWHITE			equ	1
WHITEONBLACK			equ	2
COLORONCOLOR			equ	3
HALFTONE			equ	4
MAXSTRETCHBLTMODE		equ	4
;
STRETCH_ANDSCANS		equ	BLACKONWHITE
STRETCH_ORSCANS			equ	WHITEONBLACK
STRETCH_DELETESCANS		equ	COLORONCOLOR
STRETCH_HALFTONE		equ	HALFTONE
;
;------------------------------------------------------------------------------
;
; =========================
; ternary raster operations
; =========================
;
SRCCOPY				equ	00CC0020h	;dest = src
SRCPAINT			equ	00EE0086h	;dest = src or dest
SRCAND				equ	008800C6h	;dest = src and dest
SRCINVERT			equ	00660046h	;dest = src xor dest
SRCERASE			equ	00440328h	;dest = src and -dest
NOTSRCCOPY			equ	00330008h	;dest = -src
NOTSRCERASE			equ	001100A6h	;dest = -src and -dest
MERGECOPY			equ	00C000CAh	;dest = src and pat
MERGEPAINT			equ	00BB0226h	;dest = -src or dest
PATCOPY				equ	00F00021h	;dest = pat
PATPAINT			equ	00FB0A09h	;dest = DPSnoo
PATINVERT			equ	005A0049h	;dest = pat xor dest
DSTINVERT			equ	00550009h	;dest = -dest
BLACKNESS			equ	00000042h	;dest = black
WHITENESS			equ	00FF0062h	;dest = white
;

;==============================================================================
;
;	MACROS
;
;==============================================================================
;
Win32		macro	Win32API,\
			p00,p01,p02,p03,p04,p05,p06,p07,p08,p09,\
			p10,p11,p12,p13,p14,p15,p16,p17,p18,p19
;
		irp	pxx,<p19,p18,p17,p16,p15,p14,p13,p12,p11,p10,\
			     p09,p08,p07,p06,p05,p04,p03,p02,p01,p00>
		ifnb	<pxx>
		pushd	pxx			;;push parameters
		endif
		endm
;
		ifidn		<Win32API>, <eax>
		elseifidn	<Win32API>, <ebx>
		elseifidn	<Win32API>, <ecx>
		elseifidn	<Win32API>, <edx>
		elseifidn	<Win32API>, <esi>
		elseifidn	<Win32API>, <edi>
		elseifidn	<Win32API>, <ebp>
		else
		extern	Win32API:
		endif
;
		call	Win32API		;;call win32 api
		endm
;
;------------------------------------------------------------------------------
;
Call32		macro	FuncName,\
			p00,p01,p02,p03,p04,p05,p06,p07,p08,p09,\
			p10,p11,p12,p13,p14,p15,p16,p17,p18,p19
;
		irp	pxx,<p19,p18,p17,p16,p15,p14,p13,p12,p11,p10,\
			     p09,p08,p07,p06,p05,p04,p03,p02,p01,p00>
		ifnb	<pxx>
		pushd	pxx			;;push parameters
		endif
		endm
;
		call	FuncName		;;call function
		endm
;
;------------------------------------------------------------------------------
;
Forward		macro	FwdMod, FwdFunc
;
		if	WIN95
;
public		@CatStr (<@>,<FwdFunc>)
		@CatStr (<@>,<FwdFunc>,<:>)
		extern	FwdFunc:
		jmp	FwdFunc
;
		else
;
public		@CatStr (<FwdMod>,<@>,<FwdFunc>)
		@CatStr (<FwdMod>,<@>,<FwdFunc>,<:>)
;
		endif
;
		endm
;
;------------------------------------------------------------------------------
;
Export		macro	ExpFunc
;
public		@CatStr (<@>,<ExpFunc>)
		@CatStr (<@>,<ExpFunc>,<:>)
		@CatStr (    <ExpFunc>,<:>)
;
		endm
;
;------------------------------------------------------------------------------
;
BeginImage	macro	ImgName, SecCode, SecData
;
_IMAGE_		textequ	<ImgName>
_CODE_		textequ	<SecCode>
_DATA_		textequ	<SecData>
;
		_IMAGE_	segment	byte private use32 _CLASS_
			assume	cs:_IMAGE_, ds:_IMAGE_
;
		DWORD	_ICODE_-_BCODE_, _UCODE_-_BCODE_
;
_COUNT_		=	0
		repeat	8
		if	_COUNT_ eq 0
_CHAR_		textequ	<".">
		elseif	_COUNT_ LE @SizeStr(SecCode)
_CHAR_		catstr	<">,@SubStr(SecCode,_COUNT_,1),<">
		else
_CHAR_		textequ	<0>
		endif
		BYTE	_CHAR_
_COUNT_		=	_COUNT_ + 1
		endm
;
		DWORD	_IDATA_-_UCODE_, _UDATA_-_UCODE_
;
_COUNT_		=	0
		repeat	8
		if	_COUNT_ eq 0
_CHAR_		textequ	<".">
		elseif	_COUNT_ LE @SizeStr(SecData)
_CHAR_		catstr	<">,@SubStr(SecData,_COUNT_,1),<">
		else
_CHAR_		textequ	<0>
		endif
		BYTE	_CHAR_
_COUNT_		=	_COUNT_ + 1
		endm
;
_BCODE_		equ	$
;
		endm
;
;------------------------------------------------------------------------------
;
EndImage	macro
;
		_IMAGE_	ends
			end	_Win32Startup
;
		endm
;
;------------------------------------------------------------------------------
;
BeginCode	macro
;
_ICODE_		catstr	<_i_>,_CODE_,<_>
_UCODE_		catstr	<_u_>,_CODE_,<_>
;
		endm
;
;------------------------------------------------------------------------------
;
EndCode		macro
;
		_ICODE_	label ptr near
		_UCODE_	label ptr near
;
		endm
;
;------------------------------------------------------------------------------
;
BeginData	macro
;
_IDATA_		catstr	<_i_>,_DATA_,<_>
_UDATA_		catstr	<_u_>,_DATA_,<_>
;
		endm
;
;------------------------------------------------------------------------------
;
EndData		macro
;
		_IDATA_	label ptr near
		_UDATA_	label ptr near
;
		endm
;
;------------------------------------------------------------------------------
;
EndIData	macro
;
		_IDATA_	label ptr near
;
		endm
;
;------------------------------------------------------------------------------
;
EndUData	macro
;
		_UDATA_	label ptr near
;
		endm
;
;==============================================================================
;
;	PROLOGUES/EPILOGUES
;
;==============================================================================
;
WinMainPrologue		macro
;
			push	ebp
			mov	ebp,esp
			push	ebx
			push	esi
			push	edi
;
			endm
;
;------------------------------------------------------------------------------
;
WinMainEpilogue		macro
;
			pop	edi
			pop	esi
			pop	ebx
			pop	ebp
			ret	WinMainArguments_
;
			endm
;
;------------------------------------------------------------------------------
;
LibMainPrologue		macro
;
			push	ebp
			mov	ebp,esp
			push	ebx
			push	esi
			push	edi
;
			endm
;
;------------------------------------------------------------------------------
;
LibMainEpilogue		macro
;
			pop	edi
			pop	esi
			pop	ebx
			pop	ebp
			ret	LibMainArguments_
;
			endm
;
;------------------------------------------------------------------------------
;
CallbackPrologue	macro
;
			push	ebp
			mov	ebp,esp
			push	ebx
			push	esi
			push	edi
;
			endm
;
;------------------------------------------------------------------------------
;
CallbackEpilogue	macro
;
			pop	edi
			pop	esi
			pop	ebx
			pop	ebp
			ret	CallbackArguments_
;
			endm
;
;------------------------------------------------------------------------------
;
ThreadPrologue	macro
;
			push	ebp
			mov	ebp,esp
			push	ebx
			push	esi
			push	edi
;
			endm
;
;------------------------------------------------------------------------------
;
ThreadEpilogue	macro
;
			pop	edi
			pop	esi
			pop	ebx
			pop	ebp
			ret	ThreadArguments_
;
			endm
;
;------------------------------------------------------------------------------
;
ApiPrologue		macro
;
			push	ebp
			mov	ebp,esp
			push	ebx
			push	esi
			push	edi
;
			endm
;
;------------------------------------------------------------------------------
;
ApiEpilogue		macro	_NumArgs
;
			pop	edi
			pop	esi
			pop	ebx
			pop	ebp
			ret	_NumArgs*4
;
			endm
;
;------------------------------------------------------------------------------
;
SimplePrologue		macro
;
			push	ebx
			push	esi
			push	edi
;
			endm
;
;------------------------------------------------------------------------------
;
SimpleEpilogue		macro
;
			pop	edi
			pop	esi
			pop	ebx
			ret
;
			endm
;
IF ARGUMENTS
;==============================================================================
;
;	ARGUMENTS
;
;==============================================================================
;
WinMainArguments_	equ	4+4+4+4		;size of argument stack
;
hInstance		textequ	<[ebp+08]>	;instance handle
pEnvironment		textequ	<[ebp+12]>	;environment data
pCmdLine		textequ	<[ebp+16]>	;command line
dCmdShow		textequ	<[ebp+20]>	;window display
;
;------------------------------------------------------------------------------
;
LibMainArguments_	equ	4+4+4		;size of argument stack
;
hInstDLL		textequ	<[ebp+08]>	;dll instance handle
dReason			textequ	<[ebp+12]>	;reason called
dParamDLL		textequ	<[ebp+16]>	;additional parameter
;
;------------------------------------------------------------------------------
;
CallbackArguments_	equ	4+4+4+4		;size of argument stack
;
hWnd			textequ	<[ebp+08]>	;window handle
hDlg			textequ	<[ebp+08]>	;dialog handle
dMsg			textequ	<[ebp+12]>	;message id
dParam1			textequ	<[ebp+16]>	;additional parameter
dParam2			textequ	<[ebp+20]>	;additional parameter
;
;------------------------------------------------------------------------------
;
ThreadArguments_	equ	4		;size of argument stack
;
dThreadParam		textequ	<[ebp+08]>	;thread parameter
;
;------------------------------------------------------------------------------
;
dArg01			textequ	<[ebp+08]>	;argument #01
dArg02			textequ	<[ebp+12]>	;argument #02
dArg03			textequ	<[ebp+16]>	;argument #03
dArg04			textequ	<[ebp+20]>	;argument #04
dArg05			textequ	<[ebp+24]>	;argument #05
dArg06			textequ	<[ebp+28]>	;argument #06
dArg07			textequ	<[ebp+32]>	;argument #07
dArg08			textequ	<[ebp+36]>	;argument #08
dArg09			textequ	<[ebp+40]>	;argument #09
dArg10			textequ	<[ebp+44]>	;argument #10
dArg11			textequ	<[ebp+48]>	;argument #11
dArg12			textequ	<[ebp+52]>	;argument #12
dArg13			textequ	<[ebp+56]>	;argument #13
dArg14			textequ	<[ebp+60]>	;argument #14
dArg15			textequ	<[ebp+64]>	;argument #15
dArg16			textequ	<[ebp+68]>	;argument #16
dArg17			textequ	<[ebp+72]>	;argument #17
dArg18			textequ	<[ebp+76]>	;argument #18
dArg19			textequ	<[ebp+80]>	;argument #19
dArg20			textequ	<[ebp+84]>	;argument #20
;
ENDIF
;==============================================================================
;
;	STRUCTURES
;
;==============================================================================
;
INTERNET_ASYNC_RESULT	struct
ar_dwResult		DWORD	  0		;result
ar_dwError		DWORD	  0		;error code
INTERNET_ASYNC_RESULT	ends
INTERNET_ASYNC_RESULT_	equ	  4+4
;
;------------------------------------------------------------------------------
;
ANSI_STRING		struct
as_Length		USHORT	  0		;string length (bytes)
as_MaximumLength	USHORT	  0		;buffer length (bytes)
as_Buffer		PASTR	  0		;buffer pointer
ANSI_STRING		ends
ANSI_STRING_		equ	  2+2+4
;
;------------------------------------------------------------------------------
;
BITMAPFILEHEADER	struct
bf_bfType		WORD	  0		;file type
bf_bfSize		DWORD	  0		;file size
bf_bfReserved1		WORD	  0		;(reserved)
bf_bfReserved2		WORD	  0		;(reserved)
bf_bfOffBits		DWORD	  0		;data offset
BITMAPFILEHEADER	ends
BITMAPFILEHEADER_	equ	  2+4+2+2+4
;
;------------------------------------------------------------------------------
;
BITMAPINFOHEADER	struct
bi_biSize		DWORD	  0		;structure size
bi_biWidth		LONG	  0		;bitmap width
bi_biHeight		LONG	  0		;bitmap height
bi_biPlanes		WORD	  0		;number of color planes
bi_biBitCount		WORD	  0		;number of bits per pixel
bi_biCompression	DWORD	  0		;compression type
bi_biSizeImage		DWORD	  0		;number of data bytes
bi_biXPelsPerMeter	LONG	  0		;horizontal resolution
bi_biYPelsPerMeter	LONG	  0		;vertical resolution
bi_biClrUsed		DWORD	  0		;number of used colors
bi_biClrImportant	DWORD	  0		;number of important colors
BITMAPINFOHEADER	ends
BITMAPINFOHEADER_	equ	  4+4+4+2+2+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
BITMAP			struct
bm_bmType		LONG	  0		;bitmap type
bm_bmWidth		LONG	  0		;bitmap width
bm_bmHeight		LONG	  0		;bitmap height
bm_bmWidthBytes		LONG	  0		;bytes per scan line
bm_bmPlanes		WORD	  0		;number of color planes
bm_bmBitsPixel		WORD	  0		;number of bits per pixel
bm_bmBits		LPVOID	  0		;data pointer
BITMAP			ends
BITMAP_			equ	  4+4+4+4+2+2+4
;
;------------------------------------------------------------------------------
;
COPYDATASTRUCT		struct
cd_dwData		DWORD	  0		;32-bit data
cd_cbData		DWORD	  0		;number of data bytes
cd_lpData		PVOID	  0		;data bytes
COPYDATASTRUCT		ends
COPYDATASTRUCT_		equ	  4+4+4
;
;------------------------------------------------------------------------------
;
NWCONN_HANDLE_STRUCTURE	struct
ch_Handle		DWORD	  0		;device handle
ch_Length		WORD	  0		;server name length
ch_MaximumLength	WORD	  0		;server name buffer length
ch_Buffer		PSTR	  0		;server name buffer
NWCONN_HANDLE_STRUCTURE	ends
NWCONN_HANDLE_STRUCTURE_ equ	  4+2+2+4
;
;------------------------------------------------------------------------------
;
CONTEXT			struct
;
cx_ContextFlags		DWORD	  0		;context flags
;
; CONTEXT_DEBUG_REGISTERS
;
cx_Dr0			DWORD	  0		;debug register #0
cx_Dr1			DWORD	  0		;debug register #1
cx_Dr2			DWORD	  0		;debug register #2
cx_Dr3			DWORD	  0		;debug register #3
cx_Dr6			DWORD	  0		;debug register #6
cx_Dr7			DWORD	  0		;debug register #7
;
; CONTEXT_FLOATING_POINT
;
cx_ControlWord		DWORD	  0		;fpu context
cx_StatusWord		DWORD	  0
cx_TagWord		DWORD	  0
cx_ErrorOffset		DWORD	  0
cx_ErrorSelector	DWORD	  0
cx_DataOffset		DWORD	  0
cx_DataSelector		DWORD	  0
cx_RegisterArea		BYTE	  SIZE_OF_80387_REGISTERS dup (0)
cx_Cr0NpxState		DWORD	  0
;
; CONTEXT_SEGMENTS
;
cx_SegGs		DWORD	  0		;gs register
cx_SegFs		DWORD	  0		;fs register
cx_SegEs		DWORD	  0		;es register
cx_SegDs		DWORD	  0		;ds register
;
; CONTEXT_INTEGER
;
cx_Edi			DWORD	  0		;edi register
cx_Esi			DWORD	  0		;esi register
cx_Ebx			DWORD	  0		;ebx register
cx_Edx			DWORD	  0		;edx register
cx_Ecx			DWORD	  0		;ecx register
cx_Eax			DWORD	  0		;eax register
;
; CONTEXT_CONTROL
;
cx_Ebp			DWORD	  0		;ebp register
cx_Eip			DWORD	  0		;eip register
cx_SegCs		DWORD	  0		;cs register
cx_EFlags		DWORD	  0		;eflags register
cx_Esp			DWORD	  0		;esp register
cx_SegSs		DWORD	  0		;ss register
;
CONTEXT			ends
;
CONTEXT_FLAGS_			equ	4
CONTEXT_DEBUG_REGISTERS_	equ	4+4+4+4+4+4
CONTEXT_FLOATING_POINT_		equ	4+4+4+4+4+4+4+SIZE_OF_80387_REGISTERS+4
CONTEXT_SEGMENTS_		equ	4+4+4+4
CONTEXT_INTEGER_		equ	4+4+4+4+4+4
CONTEXT_CONTROL_		equ	4+4+4+4+4+4
;
CONTEXT_FULL_			equ	CONTEXT_FLAGS_+\
					CONTEXT_SEGMENTS_+\
					CONTEXT_INTEGER_+\
					CONTEXT_CONTROL_
;
;------------------------------------------------------------------------------
;
DIALOGATTRIBUTES	struct
da_Palette		DWORD	  0		;palette pointer
da_TextBox		DWORD	  0		;text box list pointer
DIALOGATTRIBUTES	ends
DIALOGATTRIBUTES_	equ	  4+4
;
;------------------------------------------------------------------------------
;
DIALOGPALETTE		struct
dp_DlgText		COLORREF  0		;dialog text color
dp_DlgBk		COLORREF  0		;dialog background color
dp_StaticText		COLORREF  0		;static text color
dp_StaticBk		COLORREF  0		;static background color
dp_TextBoxText		COLORREF  0		;text box text color
dp_TextBoxBk		COLORREF  0		;text box background color
dp_EditText		COLORREF  0		;edit text color
dp_EditBk		COLORREF  0		;edit background color
dp_ListBoxText		COLORREF  0		;list box text color
dp_ListBoxBk		COLORREF  0		;list box background color
dp_Aux1Text		COLORREF  0		;auxiliary text color #1
dp_Aux1Bk		COLORREF  0		;auxiliary background color #1
dp_Aux2Text		COLORREF  0		;auxiliary text color #2
dp_Aux2Bk		COLORREF  0		;auxiliary background color #2
dp_Aux3Text		COLORREF  0		;auxiliary text color #3
dp_Aux3Bk		COLORREF  0		;auxiliary background color #3
DIALOGPALETTE		ends
DIALOGPALETTE_		equ	  4+4+4+4+4+4+4+4+4+4+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
DIALOGRECORD		struct
dr_hWnd			HWND	  0		;dialog window handle
dr_fModeless		BOOL	  FALSE		;mode flag
dr_Attributes		DWORD	  0		;dialog window attributes list
dr_Data			DWORD	  0		;dialog data
dr_hDlgBrush		HBRUSH	  0		;dialog brush handle
dr_hStaticBrush		HBRUSH	  0		;static brush handle
dr_hTextBoxBrush	HBRUSH	  0		;text box brush handle
dr_hEditBrush		HBRUSH	  0		;edit brush handle
dr_hListBoxBrush	HBRUSH	  0		;list box brush handle
dr_hAux1Brush		HBRUSH	  0		;auxiliary brush handle #1
dr_hAux2Brush		HBRUSH	  0		;auxiliary brush handle #2
dr_hAux3Brush		HBRUSH	  0		;auxiliary brush handle #3
DIALOGRECORD		ends
DIALOGRECORD_		equ	  4+4+4+4+4+4+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
NWDATE_TIME		struct
dt_Year			BYTE	  0		;year
dt_Month		BYTE	  0		;month
dt_Day			BYTE	  0		;day
dt_Hour			BYTE	  0		;hour
dt_Minute		BYTE	  0		;minute
dt_Second		BYTE	  0		;second
dt_DayOfWeek		BYTE	  0		;day of week
NWDATE_TIME		ends
NWDATE_TIME_		equ	  1+1+1+1+1+1+1
;
;------------------------------------------------------------------------------
;
WIN32_FIND_DATA		struct
fd_dwFileAttributes	DWORD	  0		;file attributes
fd_ftCreationTime	DWORD	  0, 0		;time of file creation
fd_ftLastAccessTime	DWORD	  0, 0		;time of last file access
fd_ftLastWriteTime	DWORD	  0, 0		;time of last write access
fd_nFileSizeHigh	DWORD	  0		;high-order word of file size
fd_nFileSizeLow		DWORD	  0		;low-order word of file size
fd_dwReserved0		DWORD	  0		;(reserved)
fd_dwReserved1		DWORD	  0		;(reserved)
fd_cFileName		CHAR	  MAX_PATH dup (0) ;matching file name
fd_cAlternateFileName	CHAR	  14 dup (0)	;8.3 alias name
WIN32_FIND_DATA		ends
WIN32_FIND_DATA_	equ	  4+8+8+8+4+4+4+4+(MAX_PATH*CHAR_)+(14*CHAR_)
;
;------------------------------------------------------------------------------
;
BY_HANDLE_FILE_INFORMATION struct
fi_dwFileAttributes	DWORD	  0		;file attributes
fi_ftCreationTime	DWORD	  0, 0		;time of file creation
fi_ftLastAccessTime	DWORD	  0, 0		;time of last file access
fi_ftLastWriteTime	DWORD	  0, 0		;time of last write access
fi_dwVolumeSerialNumber	DWORD	  0		;volume serial number
fi_nFileSizeHigh	DWORD	  0		;high-order word of file size
fi_nFileSizeLow		DWORD	  0		;low-order word of file size
fi_nNumberOfLinks	DWORD	  0		;number of links to the file
fi_nFileIndexHigh	DWORD	  0		;high-order word of identifier
fi_nFileIndexLow	DWORD	  0		;low-order word of identifier
BY_HANDLE_FILE_INFORMATION  ends
BY_HANDLE_FILE_INFORMATION_ equ	  4+8+8+8+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
FILETIME		struct
ft_dwLowDateTime	DWORD	  0		;low-order 32 bits
ft_dwHighDateTime	DWORD	  0		;high-order 32 bits
FILETIME		ends
FILETIME_		equ	  4+4
;
;------------------------------------------------------------------------------
;
NWINET_ADDR		struct
ia_networkAddr		BYTE	  4 dup (0)	;network address
ia_netNodeAddr		BYTE	  6 dup (0)	;network node address
ia_socket		WORD	  0		;network socket
ia_connType		WORD	  0		;connection type
NWINET_ADDR		ends
NWINET_ADDR_		equ	  4+6+2+2
;
;------------------------------------------------------------------------------
;
NWINTERNET_ADDR		struct
in_networkAddr		BYTE	  4 dup (0)	;network address
in_netNodeAddr		BYTE	  6 dup (0)	;network node address
in_socket		WORD	  0		;network socket
NWINTERNET_ADDR		ends
NWINTERNET_ADDR_	equ	  4+6+2
;
;------------------------------------------------------------------------------
;
IO_STATUS_BLOCK		struct
io_Status		NTSTATUS  0		;completion status
io_Information		ULONG	  0		;request-dependent value
IO_STATUS_BLOCK		ends
IO_STATUS_BLOCK_	equ	  4+4
;
;------------------------------------------------------------------------------
;
NWLOGIN_DATA		struct
ld_ObjectId		DWORD	  0		;object id
ld_Key			BYTE	  8 dup (0)	;login key
ld_HashBuffer		BYTE	  16 dup (0)	;hash buffer
ld_Password		BYTE	  NW_MAX_PASSWORD_LEN dup (0)
NWLOGIN_DATA		ends
NWLOGIN_DATA_		equ	  4+8+16+NW_MAX_PASSWORD_LEN
;
;------------------------------------------------------------------------------
;
NWLOGIN_KEY		struct
lk_Key			BYTE	  8 dup (0)	;login key
NWLOGIN_KEY		ends
NWLOGIN_KEY_		equ	  8
;
;------------------------------------------------------------------------------
;
MEMORYINDEX		struct
mi_Base			DWORD	  0		;base address
mi_Next			DWORD	  0		;next address
mi_End			DWORD	  0		;end address
mi_Granularity		DWORD	  0		;allocation granularity
mi_Properties		DWORD	  0		;user-defined properties
mi_Data			DWORD	  0		;data handle
mi_Size			DWORD	  0		;data size
MEMORYINDEX		ends
MEMORYINDEX_		equ	  4+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
MSG			struct
ms_hwnd			HWND	  0		;window handle
ms_message		UINT	  0		;message id
ms_wParam		WPARAM	  0		;additional parameter
ms_lParam		LPARAM	  0		;additional parameter
ms_time			DWORD	  0		;time stamp
ms_x			LONGINT	  0		;x coordinate
ms_y			LONGINT	  0		;y coordinate
MSG			ends
MSG_			equ	  4+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
NETRESOURCE		struct
nr_dwScope		DWORD	  0		;resource scope
nr_dwType		DWORD	  0		;resource type
nr_dwDisplayType	DWORD	  0		;display type
nr_dwUsage		DWORD	  0		;resource usage
nr_lpLocalName		LPSTR	  0		;redirected local device
nr_lpRemoteName		LPSTR	  0		;remote name
nr_lpComment		LPSTR	  0		;provider supplied comment
nr_lpProvider		LPSTR	  0		;name of provider
NETRESOURCE		ends
NETRESOURCE_		equ	  4+4+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
OBJECT_ATTRIBUTES	struct
oa_Length		ULONG	  0		;structure size
oa_RootDirectory	HANDLE	  0		;root directory handle
oa_ObjectName		PVOID	  0		;object name
oa_Attributes		ULONG	  0		;attributes
oa_SecurityDescriptor	PVOID	  0		;security descriptor
oa_SecurityQualityOfService PVOID 0		;quality of service
OBJECT_ATTRIBUTES	ends
OBJECT_ATTRIBUTES_	equ	  4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
OFSTRUCT		struct
of_cBytes		BYTE	  0		;structure size
of_fFixedDisk		BYTE	  0		;fixed-disk flag
of_nErrCode		WORD	  0		;error code
of_Reserved1		WORD	  0		;(reserved)
of_Reserved2		WORD	  0		;(reserved)
of_szPathName		BYTE	  OFS_MAXPATHNAME dup (0) ;path name
OFSTRUCT		ends
OFSTRUCT_		equ	  1+1+2+2+2+OFS_MAXPATHNAME
;
;------------------------------------------------------------------------------
;
OPENFILENAME		struct
on_lStructSize		DWORD	  OPENFILENAME_	;number of bytes
on_hwndOwner		HWND	  0		;dialog box owner
on_hInstance		HINSTANCE 0		;dialog box template id
on_lpstrFilter		LPCSTR	  0		;filter strings
on_lpstrCustomFilter	LPSTR	  0		;user-defined filter stings
on_nMaxCustFilter	DWORD	  0		;size of custom filter buffer
on_nFilterIndex		DWORD	  0		;index into the filter buffer
on_lpstrFile		LPSTR	  0		;default file name buffer
on_nMaxFile		DWORD	  0		;size of the file name buffer
on_lpstrFileTitle	LPSTR	  0		;file title buffer
on_nMaxFileTitle	DWORD	  0		;size of the file title buffer
on_lpstrInitialDir	LPCSTR	  0		;initial directory
on_lpstrTitle		LPCSTR	  0		;dialog box title
on_Flags		DWORD	  0		;dialog box creation flags
on_nFileOffset		WORD	  0		;file name offset in lpstrFile
on_nFileExtension	WORD	  0		;file ext offset in lpstrFile
on_lpstrDefExt		LPCSTR	  0		;default extension
on_lCustData		LPARAM	  0		;application-defined hook data
on_lpfnHook		LPFN	  0		;hook function
on_lpTemplateName	LPCSTR	  0		;dialog box template name
OPENFILENAME		ends
OPENFILENAME_		equ	  4+4+4+4+4+4+4+4+4+4+4+4+4+4+2+2+4+4+4+4
;
;------------------------------------------------------------------------------
;
OSVERSIONINFO		struct
ov_dwOSVersionInfoSize	DWORD	OSVERSIONINFO_	;structure size
ov_dwMajorVersion	DWORD	0		;major version number
ov_dwMinorVersion	DWORD	0		;minor version number
ov_dwBuildNumber	DWORD	0		;build number
ov_dwPlatformId		DWORD	0		;platform id
ov_szCSDVersion		CHAR	128 dup (0)	;info string
OSVERSIONINFO		ends
OSVERSIONINFO_		equ	4+4+4+4+4+(128*CHAR_)
;
;------------------------------------------------------------------------------
;
PAINTSTRUCT		struct
ps_hdc			HDC	  0		;device context handle
ps_fErase		BOOL	  FALSE		;background erase flag
ps_leftPaint		LONGINT	  0		;left margin of clipping rect
ps_topPaint		LONGINT	  0		;top margin of clipping rect
ps_rightPaint		LONGINT	  0		;right margin of clipping rect
ps_bottomPaint		LONGINT	  0		;bottom margin of clipping rect
ps_fRestore		BOOL	  FALSE		;(reserved)
ps_fIncUpdate		BOOL	  FALSE		;(reserved)
ps_rgbReserved		BYTE	  32 dup (0)	;(reserved)
PAINTSTRUCT		ends
PAINTSTRUCT_		equ	  4+4+4+4+4+4+4+4+32
;
;------------------------------------------------------------------------------
;
PROCESS_INFORMATION	struct
pi_hProcess		HANDLE	  0		;process handle
pi_hThread		HANDLE	  0		;thread handle
pi_dwProcessId		DWORD	  0		;process id
pi_dwThreadId		DWORD	  0		;thread id
PROCESS_INFORMATION	ends
PROCESS_INFORMATION_	equ	  4+4+4+4
;
;------------------------------------------------------------------------------
;
POINT			struct
pt_x			LONGINT	  0		;x coordinate
pt_y			LONGINT	  0		;y coordinate
POINT			ends
POINT_			equ	  4+4
;
;------------------------------------------------------------------------------
;
RECT			struct
rc_left			LONGINT	  0		;left margin
rc_top			LONGINT	  0		;top margin
rc_right		LONGINT	  0		;right margin
rc_bottom		LONGINT	  0		;bottom margin
RECT			ends
RECT_			equ	  4+4+4+4
;
;------------------------------------------------------------------------------
;
RGBQUAD			struct
rq_rgbBlue		BYTE	  0		;intensity of blue component
rq_rgbGreen		BYTE	  0		;intensity of green component
rq_rgbRed		BYTE	  0		;intensity of red component
rq_rgbReserved		BYTE	  0		;(reserved)
RGBQUAD			ends
RGBQUAD_		equ	  1+1+1+1
;
;------------------------------------------------------------------------------
;
REQUEST_RECORD		struct
rr_RequestCode		DWORD	  0		;request code
rr_RequestBufferSize	DWORD	  0		;request buffer size
rr_ReplyBufferSize	DWORD	  0		;reply buffer size
rr_InfoText		DWORD	  NULL		;information text
rr_MemoryHandle		HLOCAL	  NULL		;memory handle
rr_InBufferAddress	DWORD	  NULL		;input buffer address
rr_OutBufferAddress	DWORD	  NULL		;output buffer address
REQUEST_RECORD		ends
REQUEST_RECORD_		equ	  4+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
SECURITY_ATTRIBUTES	struct
sa_nLength		DWORD	  SECURITY_ATTRIBUTES_ ;structure size
sa_lpSecurityDescriptor	LPVOID	  0		;security descriptor
sa_bInheritHandle	BOOL	  FALSE		;handle inheritance flag
SECURITY_ATTRIBUTES	ends
SECURITY_ATTRIBUTES_	equ	  4+4+4
;
;------------------------------------------------------------------------------
;
STRINGCONTROL		struct
sc_Next			DWORD	  0		;next offset
sc_Marker		DWORD	  0		;marked offset
sc_Length		DWORD	  0		;table length
STRINGCONTROL		ends
STRINGCONTROL_		equ	  4+4+4
;
;------------------------------------------------------------------------------
;
STARTUPINFO		struct
si_cb			DWORD	  0		;structure size
si_lpReserved		LPSTR	  0		;(reserved)
si_lpDesktop		LPSTR	  0		;desktop name
si_lpTitle		LPSTR	  0		;console window title
si_dwX			DWORD	  0		;window origin (column)
si_dwY			DWORD	  0		;window origin (row)
si_dwXSize		DWORD	  0		;window width
si_dwYSize		DWORD	  0		;window height
si_dwXCountChars	DWORD	  0		;screen buffer width
si_dwYCountChars	DWORD	  0		;screen buffer height
si_dwFillAttribute	DWORD	  0		;console window initialization
si_dwFlags		DWORD	  0		;structure member flags
si_wShowWindow		WORD	  0		;ShowWindow() parameter
si_cbReserved2		WORD	  0		;(reserved)
si_lpReserved2		LPBYTE	  0		;(reserved)
si_hStdInput		HANDLE	  0		;standard input handle
si_hStdOutput		HANDLE	  0		;standard output handle
si_hStdError		HANDLE	  0		;standard error handle
STARTUPINFO		ends
STARTUPINFO_		equ	  4+4+4+4+4+4+4+4+4+4+4+4+2+2+4+4+4+4
;
;------------------------------------------------------------------------------
;
STRING_STRUCTURE	struct
ss_Length		USHORT	  0		;string length (bytes)
ss_MaximumLength	USHORT	  0		;buffer length (bytes)
ss_Buffer		PSTR	  0		;buffer pointer
STRING_STRUCTURE	ends
STRING_STRUCTURE_	equ	  2+2+4
;
;------------------------------------------------------------------------------
;
SYSTEMTIME		struct
st_wYear		WORD	  0		;current year
st_wMonth		WORD	  0		;current month (1..12)
st_wDayOfWeek		WORD	  0		;day of week (0 = sunday)
st_wDay			WORD	  0		;current day of the month
st_wHour		WORD	  0		;current hour
st_wMinute		WORD	  0		;current minute
st_wSecond		WORD	  0		;current second
st_wMilliseconds	WORD	  0		;current millisecond
SYSTEMTIME		ends
SYSTEMTIME_		equ	  2+2+2+2+2+2+2+2
;
;------------------------------------------------------------------------------
;
TBADDBITMAP		struct
ta_hInst		HINSTANCE 0		;resource module instance
ta_nID			UINT	  0		;resource id
TBADDBITMAP		ends
TBADDBITMAP_		equ	  4+4
;
;------------------------------------------------------------------------------
;
TBBUTTON 		struct
tb_iBitmap		INTEGER	  0		;zero-based button image index
tb_idCommand		INTEGER	  0		;button command id
tb_fsState		BYTE	  0		;button state flags
tb_fsStyle		BYTE	  0		;button style
tb_bReserved		BYTE	  0, 0		;(reserved)
tb_dwData		DWORD	  0		;application defined value
tb_iString		INTEGER	  0		;zero-based button string index
TBBUTTON		ends
TBBUTTON_		equ	  4+4+1+1+(1+1)+4+4
;
;------------------------------------------------------------------------------
;
TEXTMETRIC		struct
tm_tmHeight		LONGINT	  0		;char height (ascent+descent)
tm_tmAscent		LONGINT	  0		;units above baseline
tm_tmDescent		LONGINT	  0		;units below baseline
tm_tmInternalLeading	LONGINT	  0		;space included in tmHeight
tm_tmExternalLeading	LONGINT	  0		;extra space between rows
tm_tmAveCharWidth	LONGINT	  0		;average character width ('x')
tm_tmMaxCharWidth	LONGINT	  0		;maximum character width
tm_tmWeight		LONGINT	  0		;font weight
tm_tmOverhang		LONGINT	  0		;italic flag
tm_tmDigitizedAspectX	LONGINT	  0		;horizontal device aspect
tm_tmDigitizedAspectY	LONGINT	  0		;vertical device aspect
tm_tmFirstChar		CHAR	  0		;first font character value
tm_tmLastChar		CHAR	  0		;last font character value
tm_tmDefaultChar	CHAR	  0		;default substitution character
tm_tmBreakChar		CHAR	  0		;word break character
tm_tmItalic		BYTE	  0		;italic font
tm_tmUnderlined		BYTE	  0		;underline font
tm_tmStruckOut		BYTE	  0		;strikeout font
tm_tmPitchAndFamily	BYTE	  0		;font pitch/family
tm_tmCharSet		BYTE	  0		;font character set
TEXTMETRIC		ends
TEXTMETRIC_		equ	  4+4+4+4+4+4+4+4+4+4+4+\
				  CHAR_+CHAR_+CHAR_+CHAR_+\
				  1+1+1+1+1
;
;------------------------------------------------------------------------------
;
UNICODE_STRING		struct
us_Length		USHORT	  0		;string length (bytes)
us_MaximumLength	USHORT	  0		;buffer length (bytes)
us_Buffer		PWSTR	  0		;buffer pointer
UNICODE_STRING		ends
UNICODE_STRING_		equ	  2+2+4
;
;------------------------------------------------------------------------------
;
VERSION_INFO			struct
vi_serverName			BYTE	  48 dup (0) ;server name
vi_fileServiceVersion		BYTE	  0	;file service version
vi_fileServiceSubVersion	BYTE	  0	;file service subversion
vi_maximumServiceConnections	WORD	  0	;max # of service connections
vi_connectionsInUse		WORD	  0	;# of connections in use
vi_maxNumberVolumes		WORD	  0	;max # of volumes
vi_revision			BYTE	  0	;revision
vi_SFTLevel			BYTE	  0	;sft level
vi_TTSLevel			BYTE	  0	;transaction tracking sys level
vi_maxConnectionsEverUsed	WORD	  0	;max # of connections ever used
vi_accountVersion		BYTE	  0	;account version
vi_VAPVersion			BYTE	  0	;vap version
vi_queueVersion			BYTE	  0	;queue version
vi_printVersion			BYTE	  0	;print version
vi_virtualConsoleVersion	BYTE	  0	;virtual console version
vi_restrictionLevel		BYTE	  0	;restriction level
vi_internetBridge		BYTE	  0	;internet bridge
vi_reserved			BYTE	  60 dup (0) ;(reserved)
VERSION_INFO			ends
VERSION_INFO_			equ	  48+1+1+2+2+2+1+1+1+2+1+1+1+1+1+1+1+60
;
;------------------------------------------------------------------------------
;
WNDCLASS		struct
wc_style		UINT	  0		;class style
wc_lpfnWndProc		WNDPROC	  0		;window procedure
wc_cbClsExtra		INTEGER	  0		;class extra data
wc_cbWndExtra		INTEGER	  0		;window extra data
wc_hInstance		HINSTANCE 0		;class owner
wc_hIcon		HICON	  0		;icon handle
wc_hCursor		HCURSOR	  0		;cursor handle
wc_hbrBackground	HBRUSH	  0		;background color
wc_lpszMenuName		LPCSTR	  0		;menu name
wc_lpszClassName	LPCSTR	  0		;class name
WNDCLASS		ends
WNDCLASS_		equ	  4+4+4+4+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
WNDPARAMETERS		struct
wp_hWnd			HWND	  0		;window handle
wp_FontId		DWORD	  0		;font id
wp_TextColor		COLORREF  0		;text color
wp_BkColor		COLORREF  0		;background color
wp_BkMode		DWORD	  0		;background mode
WNDPARAMETERS		ends
WNDPARAMETERS_		equ	  4+4+4+4+4
;
;==============================================================================
;
;	DDE STRUCTURES
;
;==============================================================================
;
DDEACK			struct
ddeack_Status		WORD	  0		;status
DDEACK			ends
DDEACK_			equ	  2
;
;------------------------------------------------------------------------------
;
DDEADVISE		struct
ddeadvise_Status	WORD	  0		;status
ddeadvise_cfFormat	WORD	  0		;clipboard data format
DDEADVISE		ends
DDEADVISE_		equ	  2+2
;
;------------------------------------------------------------------------------
;
DDEDATA			struct
ddedata_Status		WORD	  0		;status
ddedata_cfFormat	WORD	  0		;clipboard data format
ddedata_Value		BYTE	  0		;data item
DDEDATA			ends
DDEDATA_		equ	  2+2+1
;
;------------------------------------------------------------------------------
;
DDEPOKE			struct
ddepoke_Status		WORD	  0		;status
ddepoke_cfFormat	WORD	  0		;clipboard data format
ddepoke_Value		BYTE	  0		;data item
DDEPOKE			ends
DDEPOKE_		equ	  2+2+1
;
;==============================================================================
;
;	LAN MANAGER STRUCTURES
;
;==============================================================================
;
USE_INFO_0		struct
ui0_local		LPTSTR	  0		;local name
ui0_remote		LPTSTR	  0		;remote name
USE_INFO_0		ends
USE_INFO_0_		equ	  4+4
;
;------------------------------------------------------------------------------
;
USE_INFO_1		struct
ui1_local		LPTSTR	  0		;local name
ui1_remote		LPTSTR	  0		;remote name
ui1_password		LPTSTR	  0		;password
ui1_status		DWORD	  0		;status
ui1_asg_type		DWORD	  0		;asg type
ui1_refcount		DWORD	  0		;reference count
ui1_usecount		DWORD	  0		;usage count
USE_INFO_1		ends
USE_INFO_1_		equ	  4+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
USE_INFO_2		struct
ui2_local		LPTSTR	  0		;local name
ui2_remote		LPTSTR	  0		;remote name
ui2_password		LPTSTR	  0		;password
ui2_status		DWORD	  0		;status
ui2_asg_type		DWORD	  0		;asg type
ui2_refcount		DWORD	  0		;reference count
ui2_usecount		DWORD	  0		;usage count
ui2_username		LPTSTR	  0		;user name
ui2_domainname		LPTSTR	  0		;domain name
USE_INFO_2		ends
USE_INFO_2_		equ	  4+4+4+4+4+4+4+4+4
;
;------------------------------------------------------------------------------
;
WKSTA_USER_INFO_0	struct
wkui0_username		LPTSTR	  0		;user name
WKSTA_USER_INFO_0	ends
WKSTA_USER_INFO_0_	equ	  4
;
;------------------------------------------------------------------------------
;
WKSTA_USER_INFO_1	struct
wkui1_username		LPTSTR	  0		;user name
wkui1_logon_domain	LPTSTR	  0		;logon domain
wkui1_oth_domains	LPTSTR	  0		;other domains
wkui1_logon_server	LPTSTR	  0		;logon server
WKSTA_USER_INFO_1	ends
WKSTA_USER_INFO_1_	equ	  4+4+4+4
;
;------------------------------------------------------------------------------
;
WKSTA_USER_INFO_1101	struct
wkui1101_oth_domains	LPTSTR	  0		;other domains
WKSTA_USER_INFO_1101	ends
WKSTA_USER_INFO_1101_	equ	  4
;
;==============================================================================
;
;	WINSOCK STRUCTURES
;
;==============================================================================
;
FD_SET			struct
fd_count		DWORD	  0			;socket count
fd_array		SOCKET	  FD_SETSIZE dup (0)	;socket array
FD_SET			ends
FD_SET_			equ	  4+(FD_SETSIZE*4)
;
;------------------------------------------------------------------------------
;
HOSTENT			struct
h_name			PASTR	  0		;official name of host
h_aliases		PPASTR	  0		;alias list
h_addrtype		WORD	  0		;host address type
h_length		WORD	  0		;length of address
h_addr_list		PPADDR	  0		;list of addresses
HOSTENT			ends
HOSTENT_		equ	  4+4+2+2+4
;
;------------------------------------------------------------------------------
;
ICMP_HDR		struct
icmp_type		BYTE	  0		;type of message
icmp_code		BYTE	  0		;type sub code
icmp_cksum		WORD	  0		;checksum
icmp_id			WORD	  0		;identifier
icmp_seq		WORD	  0		;sequence number
ICMP_HDR		ends
ICMP_HDR_		equ	  1+1+2+2+2
;
;------------------------------------------------------------------------------
;
IP_MREQ			struct
imr_multiaddr		BYTE	  4 dup (0)	;ip multicast address of group
imr_interface		BYTE	  4 dup (0)	;local ip address of interface
IP_MREQ			ends
IP_MREQ_		equ	  4+4
;
;------------------------------------------------------------------------------
;
IP_HDR			struct
ip_hl			BYTE	  0		;header length
ip_v			BYTE	  0		;version
ip_tos			BYTE	  0		;type of service
ip_len			WORD	  0		;total length
ip_id			WORD	  0		;identification
ip_off			WORD	  0		;fragment offset
ip_ttl			BYTE	  0		;time to live
ip_p			BYTE	  0		;protocol
ip_cksum		WORD	  0		;checksum
ip_ipsrc		BYTE	  4 dup (0)	;source address
ip_ipdst		BYTE	  4 dup (0)	;destination address
IP_HDR			ends
IP_HDR_			equ	  1+1+1+2+2+2+1+1+2+4+4
;
;------------------------------------------------------------------------------
;
LINGER			struct
l_onoff			WORD	  0		;option on/off
l_linger		WORD	  0		;linger time
LINGER			ends
LINGER_			equ	  2+2
;
;------------------------------------------------------------------------------
;
NETENT			struct
n_name			PASTR	  0		;official name of net
n_aliases		PPASTR	  0		;alias list
n_addrtype		WORD	  0		;net address type
n_net			DWORD	  0		;network number
NETENT			ends
NETENT_			equ	  4+4+2+4
;
;------------------------------------------------------------------------------
;
PROTOENT		struct
p_name			PASTR	  0		;official protocol name
p_aliases		PPASTR	  0		;alias list
p_proto			WORD	  0		;protocol number
PROTOENT		ends
PROTOENT_		equ	  4+4+2
;
;------------------------------------------------------------------------------
;
SERVENT			struct
s_name			PASTR	  0		;official service name
s_aliases		PPASTR	  0		;alias list
s_port			WORD	  0		;port number
s_proto			PASTR	  0		;protocol to use
SERVENT			ends
SERVENT_		equ	  4+4+2+4
;
;------------------------------------------------------------------------------
;
IN_ADDR			struct
s_b1			BYTE	  0		;byte #1
s_b2			BYTE	  0		;byte #2
s_b3			BYTE	  0		;byte #3
s_b4			BYTE	  0		;byte #4
IN_ADDR			ends
IN_ADDR_		equ	  1+1+1+1
;
;------------------------------------------------------------------------------
;
SOCKADDR		struct
sa_family		WORD	  0		;address family
sa_data			BYTE	  14 dup (0)	;direct address
SOCKADDR		ends
SOCKADDR_		equ	  2+14
;
;------------------------------------------------------------------------------
;
SOCKADDR_IN		struct
sin_family		WORD	  0		;address family
sin_port		WORD	  0		;port number
sin_addr		BYTE	  4 dup (0)	;internet address
sin_zero		BYTE	  8 dup (0)	;zero padding
SOCKADDR_IN		ends
SOCKADDR_IN_		equ	  2+2+4+8
;
;------------------------------------------------------------------------------
;
SOCKPROTO		struct
sp_family		WORD	  0		;address family
sp_protocol		WORD	  0		;protocol number
SOCKPROTO		ends
SOCKPROTO_		equ	  2+2
;
;------------------------------------------------------------------------------
;
TIMEVAL			struct
tv_sec			DWORD	  0		;seconds
tv_usec			DWORD	  0		;microseconds
TIMEVAL			ends
TIMEVAL_		equ	  4+4
;
;------------------------------------------------------------------------------
;
WSADATA			struct
wsa_wVersion		WORD	  0		;expected caller version
wsa_wHighVersion	WORD	  0		;highest version supported
wsa_szDescription	BYTE	  WSADESCRIPTION_LEN+1 dup (0)	;description
wsa_szSystemStatus	BYTE	  WSASYS_STATUS_LEN+1 dup (0)	;system status
wsa_iMaxSockets		WORD	  0		;maximum # of sockets
wsa_iMaxUdpDg		WORD	  0		;maximum udp datagram size
wsa_lpVendorInfo	POINTER	  0		;vendor info structure
WSADATA			ends
WSADATA_		equ	  2+2+\
				  (WSADESCRIPTION_LEN+1)+\
				  (WSASYS_STATUS_LEN+1)+\
				  2+2+4
;
;==============================================================================


cWin32		macro	label,p00,p01,p02,p03,p04,p05,p06,p07,p08,p09,p10,p11,p12,p13,p14,p15,p16,p17,p18,p19
                npar =  0
		irp	pxx,<p19,p18,p17,p16,p15,p14,p13,p12,p11,p10,p09,p08,p07,p06,p05,p04,p03,p02,p01,p00>
		ifnb	<pxx>
		pushD	pxx
                npar =  npar + 4
		endif
		endm
		CALL    label
                ADD     ESP, npar
                endm

sWin32		macro	label,p00,p01,p02,p03,p04,p05,p06,p07,p08,p09,p10,p11,p12,p13,p14,p15,p16,p17,p18,p19
		irp	pxx,<p19,p18,p17,p16,p15,p14,p13,p12,p11,p10,p09,p08,p07,p06,p05,p04,p03,p02,p01,p00>
		ifnb	<pxx>
		pushD	pxx
		endif
		endm
		CALL    label
                endm

PUSHL		macro	p00,p01,p02,p03,p04,p05,p06,p07,p08,p09,p10,p11,p12,p13,p14,p15,p16,p17,p18,p19
		irp	pxx,<p19,p18,p17,p16,p15,p14,p13,p12,p11,p10,p09,p08,p07,p06,p05,p04,p03,p02,p01,p00>
		ifnb	<pxx>
		pushD	pxx
		endif
                endm
		endm

POPL		macro	p00,p01,p02,p03,p04,p05,p06,p07,p08,p09,p10,p11,p12,p13,p14,p15,p16,p17,p18,p19
		irp	pxx,<p19,p18,p17,p16,p15,p14,p13,p12,p11,p10,p09,p08,p07,p06,p05,p04,p03,p02,p01,p00>
		ifnb	<pxx>
		popD	pxx
		endif
                endm
		endm
