COMMENT #
RDMSR/WRMSR access KMD - last updated: 17th April 2004

This is the driver that does all the fun work on NT. You will need Four-F's
KMDKit to assemble this - and note that I do *NOT* use retarded masm32-style
absolute paths, you will need to set up INCLUDE and LIB environment paths.

See the included msr_license.txt for, well, the license. Basically: no GPL.
Copyright by f0dder - f0dder(at)flork(dot)dk - http://f0dder.has.it
#

.586p
.model flat,stdcall
option casemap:none
option proc:private
ASSUME FS:NOTHING

include	<macros.inc>
include	<w2k\ntstatus.inc>
include <w2k\ntddk.inc>
include <Strings.mac>

include	<w2k\ntoskrnl.inc>
include	<w2k\hal.inc>

includelib <ntoskrnl.lib>
includelib <hal.lib>


IOCTL_MSR_READ  equ CTL_CODE(FILE_DEVICE_UNKNOWN, 0800h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_MSR_WRITE	equ CTL_CODE(FILE_DEVICE_UNKNOWN, 0900h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)

PUBLIC DriverEntry	; export DriverEntry

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; CONST section
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.const
CCOUNTED_UNICODE_STRING	"\\Device\\Drvf0dd_msr", g_usDeviceName, 4			; device name
CCOUNTED_UNICODE_STRING	"\\DosDevices\\f0dd_msr", g_usSymbolicLinkName, 4	; symbolic link, accessed by ring3 apps

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; CODE section
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.code

DispatchCreateClose proc pDeviceObject:PDEVICE_OBJECT, pIrp:PIRP
;invoke DbgPrint, $CTA0("f0dd_msr: DispatchCreateClose\n")
	mov		eax, pIrp
	mov		[eax]._IRP.IoStatus.Status, STATUS_SUCCESS
	mov		[eax]._IRP.IoStatus.Information, 0

	fastcall IofCompleteRequest, pIrp, IO_NO_INCREMENT

	mov		eax, STATUS_SUCCESS
	ret
DispatchCreateClose endp



DispatchControl proc uses ebx esi edi pDeviceObject:PDEVICE_OBJECT, pIrp:PIRP
local dwContext:DWORD

;invoke DbgPrint, $CTA0("f0dd_msr: DispatchControl\n")

	mov		esi, pIrp
	mov		[esi]._IRP.IoStatus.Status, STATUS_UNSUCCESSFUL
	and		[esi]._IRP.IoStatus.Information, 0

	IoGetCurrentIrpStackLocation esi
	mov		edi, eax

	; handle supported IOCTL's
	cmp		[edi].IO_STACK_LOCATION.Parameters.DeviceIoControl.IoControlCode, IOCTL_MSR_READ
	je		@@MSR_READ
	cmp		[edi].IO_STACK_LOCATION.Parameters.DeviceIoControl.IoControlCode, IOCTL_MSR_WRITE
	je		@@MSR_WRITE

	; unhandled request, indicate failure and jmp to exit
	mov		[esi]._IRP.IoStatus.Status, STATUS_INVALID_DEVICE_REQUEST
	jmp		@@exit


	;============================================================
	;MSR_READ: read a MSR and return results to usermode.
	;		input buffer:	DWORD msr_index
	;		output buffer:	DWORD msr_reg_high, DWORD msr_reg_low
@@MSR_READ:
	.if [edi].IO_STACK_LOCATION.Parameters.DeviceIoControl.InputBufferLength < 4
		mov		[esi]._IRP.IoStatus.Status, STATUS_BUFFER_TOO_SMALL
		jmp		@@exit
	.endif
	.if [edi].IO_STACK_LOCATION.Parameters.DeviceIoControl.OutputBufferLength < 8
		mov		[esi]._IRP.IoStatus.Status, STATUS_BUFFER_TOO_SMALL
		jmp		@@exit
	.endif
	mov		ebx, [esi]._IRP.AssociatedIrp.SystemBuffer
	mov		ecx, [ebx + 00] ; msr_index
	rdmsr
	mov		[ebx + 00], edx	; msr_reg_high
	mov		[ebx + 04], eax ; msr_reg_low

	mov		[esi]._IRP.IoStatus.Information, 8		; copy back 8 bytes
	mov		[esi]._IRP.IoStatus.Status, STATUS_SUCCESS
	jmp		@@exit


	;============================================================
	;MSR_WRITE: write a MSR
	;		input buffer:	DWORD msr_index, DWORD msr_reg_high, DWORD msr_reg_low
	;		output buffer:	not used
@@MSR_WRITE:
	.if [edi].IO_STACK_LOCATION.Parameters.DeviceIoControl.InputBufferLength < 12
		mov		[esi]._IRP.IoStatus.Status, STATUS_BUFFER_TOO_SMALL
		jmp		@@exit
	.endif
	mov		ebx, [esi]._IRP.AssociatedIrp.SystemBuffer
	mov		ecx, [ebx + 00]		; msr_index
	mov		edx, [ebx + 04]		; msr_reg_high
	mov		eax, [ebx + 08]		; msr_reg_low
	wrmsr

	mov		[esi]._IRP.IoStatus.Information, 0		; don't copy back anything
	mov		[esi]._IRP.IoStatus.Status, STATUS_SUCCESS
	; fallthrough to exit

@@exit:
	; complete IRP and return to system
	fastcall IofCompleteRequest, esi, IO_NO_INCREMENT
	mov eax, [esi]._IRP.IoStatus.Status

	ret
DispatchControl endp



DriverUnload proc pDriverObject:PDRIVER_OBJECT
;invoke DbgPrint, $CTA0("f0dd_msr: DriverUnload\n")
	; clean up
	invoke	IoDeleteSymbolicLink, addr g_usSymbolicLinkName
	mov		eax, pDriverObject
	invoke	IoDeleteDevice, (DRIVER_OBJECT PTR [eax]).DeviceObject

	ret
DriverUnload endp



;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; DISCARDABLE CODE section
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.code INIT

DriverEntry proc pDriverObject:PDRIVER_OBJECT, pusRegistryPath:PUNICODE_STRING
local status:NTSTATUS
local pDeviceObject:PDEVICE_OBJECT

;invoke DbgPrint, $CTA0("f0dd_msr: DriverEntry\n")
	mov status, STATUS_DEVICE_CONFIGURATION_ERROR

	; Create device
	invoke	IoCreateDevice, pDriverObject, 0, addr g_usDeviceName, FILE_DEVICE_UNKNOWN, 0, TRUE, addr pDeviceObject
	cmp		eax, STATUS_SUCCESS
	jne		@@exit

	;
	; Set up symbolic link and initialize the driver function table
	;
	invoke	IoCreateSymbolicLink, addr g_usSymbolicLinkName, addr g_usDeviceName
	.if eax == STATUS_SUCCESS
		mov eax, pDriverObject
		assume eax:ptr DRIVER_OBJECT
		mov [eax].MajorFunction[IRP_MJ_CREATE*(sizeof PVOID)],			offset DispatchCreateClose
		mov [eax].MajorFunction[IRP_MJ_CLOSE*(sizeof PVOID)],			offset DispatchCreateClose
		mov [eax].MajorFunction[IRP_MJ_DEVICE_CONTROL*(sizeof PVOID)],	offset DispatchControl
		mov [eax].DriverUnload,											offset DriverUnload
		assume eax:nothing
		mov status, STATUS_SUCCESS
	.else
		invoke IoDeleteDevice, pDeviceObject
	.endif

@@exit:
	mov		eax, status
	ret
DriverEntry endp

END DriverEntry
