//////////////////////////////////////////////////
//
// armadillo 4.20 nanomites core emulator
// written by andreageddon
//
// functions, data is in coredata.cpp
//////////////////////////////////////////////////
#include "core.h"

///////////////////////////
// BLOCK 2
//////////////////////////
__declspec(naked) void Block2Func2(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 cmp     dword ptr [ebp+0Ch], 0
                 jnz     short ProcessAddress
                 xor     eax, eax
                 jmp     ZeroQuit
 ProcessAddress:
                 mov     eax, [ebp+8]
                 xor     eax, 0FFFFFFFFh
                 mov     [ebp+8], eax

 CalculusLoop:
                 cmp     dword ptr [ebp+10h], 8
                 jb      EightBytesAddress
                 mov     ecx, [ebp+0Ch]
                 xor     edx, edx
                 mov     dl, [ecx]
                 mov     eax, [ebp+8]
                 xor     eax, edx
                 and     eax, 0FFh
                 mov     ecx, [ebp+8]
                 shr     ecx, 8
                 mov     edx, dword ptr Block2Func2Data1[eax*4]
                 xor     edx, ecx
                 mov     [ebp+8], edx
                 mov     eax, [ebp+0Ch]
                 add     eax, 1
                 mov     [ebp+0Ch], eax
                 mov     ecx, [ebp+0Ch]
                 xor     edx, edx
                 mov     dl, [ecx]
                 mov     eax, [ebp+8]
                 xor     eax, edx
                 and     eax, 0FFh
                 mov     ecx, [ebp+8]
                 shr     ecx, 8
                 mov     edx, dword ptr Block2Func2Data1[eax*4]
                 xor     edx, ecx
                 mov     [ebp+8], edx
                 mov     eax, [ebp+0Ch]
                 add     eax, 1
                 mov     [ebp+0Ch], eax
                 mov     ecx, [ebp+0Ch]
                 xor     edx, edx
                 mov     dl, [ecx]
                 mov     eax, [ebp+8]
                 xor     eax, edx
                 and     eax, 0FFh
                 mov     ecx, [ebp+8]
                 shr     ecx, 8
                 mov     edx, dword ptr Block2Func2Data1[eax*4]
                 xor     edx, ecx
                 mov     [ebp+8], edx
                 mov     eax, [ebp+0Ch]
                 add     eax, 1
                 mov     [ebp+0Ch], eax
                 mov     ecx, [ebp+0Ch]
                 xor     edx, edx
                 mov     dl, [ecx]
                 mov     eax, [ebp+8]
                 xor     eax, edx
                 and     eax, 0FFh
                 mov     ecx, [ebp+8]
                 shr     ecx, 8
                 mov     edx, dword ptr Block2Func2Data1[eax*4]
                 xor     edx, ecx
                 mov     [ebp+8], edx
                 mov     eax, [ebp+0Ch]
                 add     eax, 1
                 mov     [ebp+0Ch], eax
                 mov     ecx, [ebp+0Ch]
                 xor     edx, edx
                 mov     dl, [ecx]
                 mov     eax, [ebp+8]
                 xor     eax, edx
                 and     eax, 0FFh
                 mov     ecx, [ebp+8]
                 shr     ecx, 8
                 mov     edx, dword ptr Block2Func2Data1[eax*4]
                 xor     edx, ecx
                 mov     [ebp+8], edx
                 mov     eax, [ebp+0Ch]
                 add     eax, 1
                 mov     [ebp+0Ch], eax
                 mov     ecx, [ebp+0Ch]
                 xor     edx, edx
                 mov     dl, [ecx]
                 mov     eax, [ebp+8]
                 xor     eax, edx
                 and     eax, 0FFh
                 mov     ecx, [ebp+8]
                 shr     ecx, 8
                 mov     edx, dword ptr Block2Func2Data1[eax*4]
                 xor     edx, ecx
                 mov     [ebp+8], edx
                 mov     eax, [ebp+0Ch]
                 add     eax, 1
                 mov     [ebp+0Ch], eax
                 mov     ecx, [ebp+0Ch]
                 xor     edx, edx
                 mov     dl, [ecx]
                 mov     eax, [ebp+8]
                 xor     eax, edx
                 and     eax, 0FFh
                 mov     ecx, [ebp+8]
                 shr     ecx, 8
                 mov     edx, dword ptr Block2Func2Data1[eax*4]
                 xor     edx, ecx
                 mov     [ebp+8], edx
                 mov     eax, [ebp+0Ch]
                 add     eax, 1
                 mov     [ebp+0Ch], eax
                 mov     ecx, [ebp+0Ch]
                 xor     edx, edx
                 mov     dl, [ecx]
                 mov     eax, [ebp+8]
                 xor     eax, edx
                 and     eax, 0FFh
                 mov     ecx, [ebp+8]
                 shr     ecx, 8
                 mov     edx, dword ptr Block2Func2Data1[eax*4]
                 xor     edx, ecx
                 mov     [ebp+8], edx
                 mov     eax, [ebp+0Ch]
                 add     eax, 1
                 mov     [ebp+0Ch], eax
                 mov     ecx, [ebp+10h]
                 sub     ecx, 8
                 mov     [ebp+10h], ecx
                 jmp     CalculusLoop
 EightBytesAddress:
                 cmp     dword ptr [ebp+10h], 0
                 jz      short ZeroByteAddr

 FourByteAddress:
                 mov     edx, [ebp+0Ch]
                 xor     eax, eax
                 mov     al, [edx]
                 mov     ecx, [ebp+8]
                 xor     ecx, eax
                 and     ecx, 0FFh
                 mov     edx, [ebp+8]
                 shr     edx, 8
                 mov     eax, dword ptr Block2Func2Data1[ecx*4]
                 xor     eax, edx
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+0Ch]
                 add     ecx, 1
                 mov     [ebp+0Ch], ecx
                 mov     edx, [ebp+10h]
                 sub     edx, 1
                 mov     [ebp+10h], edx
                 cmp     dword ptr [ebp+10h], 0
                 jnz     short FourByteAddress
 ZeroByteAddr:
                 mov     eax, [ebp+8]
                 xor     eax, 0FFFFFFFFh
 ZeroQuit:
                 pop     ebp
                 retn
	}
}

__declspec(naked) DWORD Block2Func1(DWORD *Address, DWORD Param1, DWORD Param2)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+0Ch]
                 push    eax
                 mov     ecx, [ebp+8]
                 push    ecx
                 mov     edx, [ebp+10h]
                 xor     edx, 0FFFFFFFFh
                 push    edx
                 call    Block2Func2
                 add     esp, 0Ch
                 xor     eax, 0FFFFFFFFh
                 pop     ebp
                 retn
	}
}

//////////////////////////
// block 3
//////////////////////////

__declspec(naked) void SubFunc0(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 14h
                 mov     eax, 1
                 mov     ecx, [ebp+0Ch]
                 shl     eax, cl
                 sub     eax, 1
                 mov     ecx, [ebp+10h]
                 shl     eax, cl
                 mov     dword ptr [ebp-10h], eax
                 mov     ecx, [ebp-10h]
                 not     ecx
                 mov     edx, [ebp+8]
                 and     edx, ecx
                 mov     [ebp-4], edx
                 mov     eax, 1
                 mov     ecx, [ebp+10h]
                 shl     eax, cl
                 mov     [ebp-0Ch], eax
                 mov     ecx, [ebp+0Ch]
                 mov     edx, [ebp+10h]
                 lea     ecx, [edx+ecx-1]
                 mov     eax, 1
                 shl     eax, cl
                 mov     dword ptr [ebp-14h], eax
                 mov     dword ptr [ebp-8], 0
                 jmp     short SubFunc0_1

 SubFunc0_2:
                 mov     ecx, [ebp-8]
                 add     ecx, 1
                 mov     [ebp-8], ecx

 SubFunc0_1: 
                 mov     edx, [ebp-8]
                 cmp     edx, [ebp+0Ch]
                 jge     short SubFunc0_4
                 mov     eax, [ebp+8]
                 and     eax, [ebp-0Ch]
                 test    eax, eax
                 jz      short SubFunc0_3
                 mov     ecx, [ebp-4]
                 or      ecx, [ebp-14h]
                 mov     [ebp-4], ecx

 SubFunc0_3:
                 mov     edx, [ebp-0Ch]
                 shl     edx, 1
                 mov     [ebp-0Ch], edx
                 mov     eax, [ebp-14h]
                 shr     eax, 1
                 mov     dword ptr [ebp-14h], eax
                 jmp     short SubFunc0_2

 SubFunc0_4:
                 mov     eax, [ebp-4]
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SubFunc1(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 10h
                 mov     eax, 1
                 mov     ecx, [ebp+0Ch]
                 shl     eax, cl
                 sub     eax, 1
                 mov     [ebp-4], eax
                 mov     edx, [ebp-4]
                 mov     ecx, [ebp+10h]
                 shl     edx, cl
                 mov     [ebp-0Ch], edx
                 mov     eax, [ebp+8]
                 and     eax, [ebp-4]
                 mov     dword ptr [ebp-10h], eax
                 mov     edx, [ebp+8]
                 and     edx, [ebp-0Ch]
                 mov     ecx, [ebp+10h]
                 shr     edx, cl
                 mov     [ebp-8], edx
                 mov     eax, [ebp-4]
                 or      eax, [ebp-0Ch]
                 not     eax
                 mov     ecx, [ebp+8]
                 and     ecx, eax
                 mov     [ebp+8], ecx
                 mov     edx, [ebp-10h]
                 mov     ecx, [ebp+10h]
                 shl     edx, cl
                 or      edx, [ebp-8]
                 mov     eax, [ebp+8]
                 or      eax, edx
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SubFunc2(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 8
                 cmp     dword ptr [ebp+14h], 0
                 jge     short SubFunc2_1
                 mov     eax, [ebp+14h]
                 add     eax, [ebp+0Ch]
                 mov     [ebp+14h], eax
 SubFunc2_1:
                 mov     edx, 1
                 mov     ecx, [ebp+0Ch]
                 shl     edx, cl
                 sub     edx, 1
                 mov     [ebp-8], edx
                 mov     eax, [ebp+8]
                 mov     ecx, [ebp+10h]
                 shr     eax, cl
                 and     eax, [ebp-8]
                 mov     [ebp-4], eax
                 mov     edx, [ebp-4]
                 mov     ecx, [ebp+14h]
                 shr     edx, cl
                 mov     ecx, [ebp+0Ch]
                 sub     ecx, [ebp+14h]
                 mov     eax, [ebp-4]
                 shl     eax, cl
                 or      edx, eax
                 and     edx, [ebp-8]
                 mov     [ebp-4], edx
                 mov     edx, [ebp-8]
                 mov     ecx, [ebp+10h]
                 shl     edx, cl
                 not     edx
                 mov     eax, [ebp+8]
                 and     eax, edx
                 mov     [ebp+8], eax
                 mov     edx, [ebp-4]
                 mov     ecx, [ebp+10h]
                 shl     edx, cl
                 mov     eax, [ebp+8]
                 or      eax, edx
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SubFunc3(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 cmp     dword ptr [ebp+0Ch], 0
                 jge     short SubFunc3_1
                 mov     eax, [ebp+0Ch]
                 add     eax, 20h
                 mov     [ebp+0Ch], eax

 SubFunc3_1:
                 mov     eax, [ebp+8]
                 mov     ecx, [ebp+0Ch]
                 shr     eax, cl
                 mov     ecx, 20h
                 sub     ecx, [ebp+0Ch]
                 mov     edx, [ebp+8]
                 shl     edx, cl
                 or      eax, edx
                 pop     ebp
                 retn
	}
}

__declspec(naked) void Block3Func0(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 6E4957A8h
                 mov     [ebp+8], eax
                 push    5
                 push    15h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Dh
                 push    2
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Ch
                 push    9
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 4B487412h
                 mov     [ebp+8], ecx
                 push    5
                 push    0Eh
                 push    7
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    13h
                 push    8
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 0D972B853h
                 mov     [ebp+8], ecx
                 push    7
                 push    16h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void  Block3Func1(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 0FB1E52AFh
                 mov     [ebp+8], eax
                 push    1Ah
                 push    5
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    16h
                 push    0
                 push    1Ch
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Ah
                 push    0Ah
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Dh
                 push    2
                 push    14h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 8B9D36E9h
                 mov     [ebp+8], edx
                 push    1Ah
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    7
                 push    14h
                 push    0Bh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 0A52B3D68h
                 mov     [ebp+8], edx
                 push    14h
                 push    1
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0
                 push    1Eh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Ch
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 40174D5Bh
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void  Block3Func2(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 0FBBD38E7h
                 mov     [ebp+8], eax
                 push    17h
                 push    4
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    11h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    6
                 push    9
                 push    0Eh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    1Ah
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 81A5E699h
                 mov     [ebp+8], edx
                 push    0Bh
                 push    0
                 push    18h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0
                 push    11h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Eh
                 push    8
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    9
                 push    1
                 push    1Eh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    9
                 push    2
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    4
                 push    17h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Fh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    2
                 push    0Fh
                 push    9
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 0F185A47Ch
                 mov     [ebp+8], edx
                 push    0Fh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void  Block3Func3(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 5C2ACD4Dh
                 mov     [ebp+8], eax
                 push    0Ah
                 push    3
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    6
                 push    0Ah
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    5
                 push    7
                 push    11h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Bh
                 push    7
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    7
                 push    8
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    7
                 push    0Ah
                 push    0Bh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    16h
                 push    2
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    5
                 push    7
                 push    8
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Fh
                 push    5
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    12h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    6
                 push    3
                 push    0Dh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void  Block3Func4(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 47D8FFBDh
                 mov     [ebp+8], eax
                 push    4
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    17h
                 push    0
                 push    1Ch
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    7
                 push    0Fh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    13h
                 push    5
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    1Bh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    3
                 push    0Dh
                 push    8
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Ah
                 push    7
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0
                 push    1Fh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    14h
                 push    1
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    6
                 push    12h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    12h
                 push    5
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    15h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    15h
                 push    4
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    3
                 push    0Fh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    9
                 push    8
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 89C7C9A6h
                 mov     [ebp+8], ecx
                 push    0Eh
                 push    1
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Ch
                 push    0Fh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    13h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    5
                 push    7
                 push    17h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void  Block3Func5(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 24A4A3B5h
                 mov     [ebp+8], eax
                 push    17h
                 push    8
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    10h
                 push    2
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    13h
                 push    0
                 push    1Fh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 8B465658h
                 mov     [ebp+8], ecx
                 push    0Eh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 5BFB6B28h
                 mov     [ebp+8], eax
                 push    0Eh
                 push    1
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    5
                 push    1
                 push    1Eh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    5
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    1Bh
                 push    0
                 push    1Ch
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Bh
                 push    1
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    9
                 push    0
                 push    0Dh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    14h
                 push    4
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    15h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 7C3547F7h
                 mov     [ebp+8], eax
                 push    0Bh
                 push    4
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    4
                 push    0Bh
                 push    6
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Ch
                 push    1
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    6
                 push    3
                 push    16h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0
                 push    1Fh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void  Block3Func6(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 34473F96h
                 mov     [ebp+8], eax
                 push    11h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 5ED8936Ch
                 mov     [ebp+8], edx
                 push    0Ch
                 push    8
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Ah
                 push    12h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 6BA330BFh
                 mov     [ebp+8], edx
                 push    4
                 push    8
                 push    13h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Eh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0Bh
                 push    4
                 push    19h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    3
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 251AFCFEh
                 mov     [ebp+8], ecx
                 push    0Fh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0Dh
                 push    0Bh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void  Block3Func7(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 5A07B2A1h
                 mov     [ebp+8], eax
                 push    10h
                 push    0Bh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Bh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0Dh
                 push    6
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 70648B0Dh
                 mov     [ebp+8], ecx
                 push    3
                 push    11h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 3773D297h
                 mov     [ebp+8], eax
                 push    0
                 push    1Eh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 49253F31h
                 mov     [ebp+8], edx
                 push    0Fh
                 push    2
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    10h
                 push    0
                 push    1Fh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    11h
                 push    5
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    11h
                 push    9
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 0ABA4CE9Ah
                 mov     [ebp+8], ecx
                 push    0Dh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 0F6547803h
                 mov     [ebp+8], eax
                 push    13h
                 push    4
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 3A22CD09h
                 mov     [ebp+8], edx
                 push    4
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    5
                 push    0Ah
                 push    0Fh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    1Fh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0
                 push    7
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void  Block3Func8(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 949D26F0h
                 mov     [ebp+8], eax
                 push    7
                 push    9
                 push    10h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 58887477h
                 mov     [ebp+8], edx
                 push    5
                 push    5
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    1Dh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0Ch
                 push    6
                 push    0Fh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    15h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 0A8DB534Eh
                 mov     [ebp+8], ecx
                 push    10h
                 push    5
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    5
                 push    19h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Bh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn

	}
}

__declspec(naked) void  Block3Func9(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 0EECED199h
                 mov     [ebp+8], eax
                 push    6
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    2
                 push    17h
                 push    3
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Eh
                 push    0Fh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Eh
                 push    2
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 0F097965Dh
                 mov     [ebp+8], edx
                 push    15h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 247C11F6h
                 mov     [ebp+8], ecx
                 push    14h
                 push    1
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Ah
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    19h
                 push    1
                 push    1Eh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Bh
                 push    8
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    2
                 push    1Dh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 71B455A8h
                 mov     [ebp+8], ecx
                 push    0Eh
                 push    2
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void  Block3FuncA(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 0FDEB38C7h
                 mov     [ebp+8], eax
                 push    1
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    2
                 push    8
                 push    4
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Ch
                 push    7
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    10h
                 push    7
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 0DCA20F48h
                 mov     [ebp+8], edx
                 push    16h
                 push    8
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    7
                 push    4
                 push    1Ah
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Fh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    2
                 push    7
                 push    5
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    3
                 push    1Bh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 4A7BFE98h
                 mov     [ebp+8], edx
                 push    8
                 push    15h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 71912DB8h
                 mov     [ebp+8], ecx
                 push    9
                 push    1
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    9
                 push    8
                 push    17h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void  Block3FuncB(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 3F4C93CAh
                 mov     [ebp+8], eax
                 push    12h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0Ah
                 push    9
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 16F12999h
                 mov     [ebp+8], eax
                 push    3
                 push    4
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    4
                 push    5
                 push    0Bh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    1
                 push    18h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    15h
                 push    2
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    9
                 push    5
                 push    18h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    3
                 push    12h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Bh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0Eh
                 push    8
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    1
                 push    1Bh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    8
                 push    5
                 push    16h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 0A59EEE9Ah
                 mov     [ebp+8], edx
                 push    0Eh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    19h
                 push    3
                 push    1Bh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void  Block3FuncC(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 10AFC3E4h
                 mov     [ebp+8], eax
                 push    8
                 push    6
                 push    0Bh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    4
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    2
                 push    0Ah
                 push    8
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 8C6C2052h
                 mov     [ebp+8], ecx
                 push    0Bh
                 push    3
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    2
                 push    3
                 push    7
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Eh
                 push    6
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    19h
                 push    2
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 2ACA701Ah
                 mov     [ebp+8], eax
                 push    0Ah
                 push    4
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    9
                 push    2
                 push    0Eh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Ch
                 push    6
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void  Block3FuncD(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 96174FB5h
                 mov     [ebp+8], eax
                 push    0Ch
                 push    7
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Ch
                 push    0Dh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    14h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0
                 push    0Fh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    17h
                 push    4
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    6
                 push    1
                 push    14h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 0B4324752h
                 mov     [ebp+8], ecx
                 push    0Ch
                 push    3
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    1Fh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    6
                 push    19h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    5
                 push    8
                 push    10h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Dh
                 push    7
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 414B8E93h
                 mov     [ebp+8], ecx
                 push    16h
                 push    0
                 push    1Dh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    12h
                 push    0Bh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    14h
                 push    3
                 push    1Bh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    18h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    7
                 push    0Eh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    1Bh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void  Block3FuncE(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 8B8BAF82h
                 mov     [ebp+8], eax
                 push    16h
                 push    7
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    11h
                 push    0Bh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    14h
                 push    5
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    4
                 push    13h
                 push    0Bh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 0DDF185A2h
                 mov     [ebp+8], edx
                 push    5
                 push    9
                 push    12h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Eh
                 push    10h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    16h
                 push    8
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    2
                 push    1
                 push    7
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    14h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    2
                 push    0Bh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Bh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    3
                 push    4
                 push    15h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    15h
                 push    7
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void  Block3FuncF(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 6760502h
                 mov     [ebp+8], eax
                 push    13h
                 push    7
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 17019638h
                 mov     [ebp+8], edx
                 push    4
                 push    2
                 push    0Eh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    5
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    1Ah
                 push    4
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    16h
                 push    6
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    7
                 push    8
                 push    17h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    1
                 push    1Dh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    4
                 push    5
                 push    17h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    12h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 87E29F3Ch
                 mov     [ebp+8], edx
                 push    1
                 push    1Ah
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    9
                 push    2
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Bh
                 push    0
                 push    1Fh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    3
                 push    15h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 1AD7F4D0h
                 mov     [ebp+8], ecx
                 push    0Eh
                 push    6
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    3
                 push    18h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 0552CA9h
                 mov     [ebp+8], ecx
                 push    0Ah
                 push    0
                 push    12h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    2
                 push    1Bh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}


/////////////////////////////////////////
// block 6
/////////////////////////////////////////

//
// called by the asm dispatcher, this routine finds
// the address where the execution will be routed
//
DWORD Dispatcher(DWORD Address)
{
	int i = 0;

	while(true)
	{
		if(Address == B6OriginalFuncs[i])
		{
			return (DWORD)Block6DynamicFuncs[i];
		}
		i++;
	}
	//
	// we should never get here
	//
	return NULL;
}


//
// static routines will dispatch their dynamic calls towards this
// asm routine. Dynamic calls originally were  CALL [EBP - 8], that
// is the address to be checked in the lookaside arrays
//
__declspec(naked) void AsmDispatcher(void)
{
	__asm
	{
		mov		eax, dword ptr [ebp - 8]
		push	eax
		call	Dispatcher
		add		esp, 4
		jmp		eax
		retn		//we should never get here
	}
}



__declspec(naked) void sub_48DC2D(void) { 	__asm	{





                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 5Eh
                mov     dword ptr [ebp-2Ch], 0Bh
                mov     dword ptr [ebp-28h], 0D5h
                mov     dword ptr [ebp-24h], 60h
                mov     dword ptr [ebp-20h], 0E5h
                mov     dword ptr [ebp-1Ch], 0E8h
                mov     dword ptr [ebp-18h], 0C5h
                mov     dword ptr [ebp-14h], 5Eh
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48DCA8
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48DCA8:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48DCC9
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48DCC6
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48DCC6:                             
                mov     [ebp-38h], ecx

loc_48DCC9:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
	}
}






__declspec(naked) void sub_48DD35(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E3h
                mov     dword ptr [ebp-2Ch], 0F9h
                mov     dword ptr [ebp-28h], 54h
                mov     dword ptr [ebp-24h], 90h
                mov     dword ptr [ebp-20h], 15h
                mov     dword ptr [ebp-1Ch], 0BFh
                mov     dword ptr [ebp-18h], 35h
                mov     dword ptr [ebp-14h], 27h
                mov     dword ptr [ebp-10h], 10h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 10h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48DDB0
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48DDB0:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48DDD1
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48DDCE
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48DDCE:                             
                mov     [ebp-38h], ecx

loc_48DDD1:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48DE3D(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0F4h
                mov     dword ptr [ebp-2Ch], 7Eh
                mov     dword ptr [ebp-28h], 0C6h
                mov     dword ptr [ebp-24h], 0A1h
                mov     dword ptr [ebp-20h], 5Ah
                mov     dword ptr [ebp-1Ch], 0A6h
                mov     dword ptr [ebp-18h], 6Fh
                mov     dword ptr [ebp-14h], 8Bh
                mov     dword ptr [ebp-10h], 6
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 6
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48DEB8
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48DEB8:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48DED9
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48DED6
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48DED6:                             
                mov     [ebp-38h], ecx

loc_48DED9:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48DF45(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 23h
                mov     dword ptr [ebp-2Ch], 1Dh
                mov     dword ptr [ebp-28h], 0AAh
                mov     dword ptr [ebp-24h], 0D3h
                mov     dword ptr [ebp-20h], 0B5h
                mov     dword ptr [ebp-1Ch], 35h
                mov     dword ptr [ebp-18h], 2Eh
                mov     dword ptr [ebp-14h], 6Dh
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48DFC0
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48DFC0:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48DFE1
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48DFDE
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48DFDE:                             
                mov     [ebp-38h], ecx

loc_48DFE1:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48E04D(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 83h
                mov     dword ptr [ebp-2Ch], 0C7h
                mov     dword ptr [ebp-28h], 2Dh
                mov     dword ptr [ebp-24h], 89h
                mov     dword ptr [ebp-20h], 0D5h
                mov     dword ptr [ebp-1Ch], 0A3h
                mov     dword ptr [ebp-18h], 39h
                mov     dword ptr [ebp-14h], 0DAh
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48E0C8
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48E0C8:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48E0E9
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48E0E6
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48E0E6:                             
                mov     [ebp-38h], ecx

loc_48E0E9:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48E155(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0F1h
                mov     dword ptr [ebp-2Ch], 0Eh
                mov     dword ptr [ebp-28h], 15h
                mov     dword ptr [ebp-24h], 0F6h
                mov     dword ptr [ebp-20h], 0D5h
                mov     dword ptr [ebp-1Ch], 0A6h
                mov     dword ptr [ebp-18h], 5Dh
                mov     dword ptr [ebp-14h], 2Ch
                mov     dword ptr [ebp-10h], 2
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 2
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48E1D0
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48E1D0:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48E1F1
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48E1EE
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48E1EE:                             
                mov     [ebp-38h], ecx

loc_48E1F1:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48E25D(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 17h
                mov     dword ptr [ebp-2Ch], 0A0h
                mov     dword ptr [ebp-28h], 36h
                mov     dword ptr [ebp-24h], 7Eh
                mov     dword ptr [ebp-20h], 3Ah
                mov     dword ptr [ebp-1Ch], 0B6h
                mov     dword ptr [ebp-18h], 2Bh
                mov     dword ptr [ebp-14h], 0AEh
                mov     dword ptr [ebp-10h], 1
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 1
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48E2D7
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48E2D7:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48E2F8
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48E2F5
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48E2F5:                             
                mov     [ebp-38h], ecx

loc_48E2F8:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48E364(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0F0h
                mov     dword ptr [ebp-2Ch], 56h
                mov     dword ptr [ebp-28h], 0D3h
                mov     dword ptr [ebp-24h], 47h
                mov     dword ptr [ebp-20h], 20h
                mov     dword ptr [ebp-1Ch], 5Ah
                mov     dword ptr [ebp-18h], 15h
                mov     dword ptr [ebp-14h], 0DCh
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48E3DF
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48E3DF:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48E400
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48E3FD
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48E3FD:                             
                mov     [ebp-38h], ecx

loc_48E400:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48E46C(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 6Eh
                mov     dword ptr [ebp-2Ch], 0B1h
                mov     dword ptr [ebp-28h], 0AEh
                mov     dword ptr [ebp-24h], 0E4h
                mov     dword ptr [ebp-20h], 4Dh
                mov     dword ptr [ebp-1Ch], 4
                mov     dword ptr [ebp-18h], 76h
                mov     dword ptr [ebp-14h], 0B8h
                mov     dword ptr [ebp-10h], 3
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 3
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48E4E7
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48E4E7:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48E508
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48E505
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48E505:                             
                mov     [ebp-38h], ecx

loc_48E508:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48E574(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 58h
                mov     dword ptr [ebp-2Ch], 8Dh
                mov     dword ptr [ebp-28h], 8Bh
                mov     dword ptr [ebp-24h], 44h
                mov     dword ptr [ebp-20h], 64h
                mov     dword ptr [ebp-1Ch], 57h
                mov     dword ptr [ebp-18h], 48h
                mov     dword ptr [ebp-14h], 0DAh
                mov     dword ptr [ebp-10h], 0Ch
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ch
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48E5EF
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48E5EF:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48E610
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48E60D
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48E60D:                             
                mov     [ebp-38h], ecx

loc_48E610:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48E67C(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 91h
                mov     dword ptr [ebp-2Ch], 24h
                mov     dword ptr [ebp-28h], 3
                mov     dword ptr [ebp-24h], 6
                mov     dword ptr [ebp-20h], 0B7h
                mov     dword ptr [ebp-1Ch], 0B0h
                mov     dword ptr [ebp-18h], 26h
                mov     dword ptr [ebp-14h], 0E3h
                mov     dword ptr [ebp-10h], 1
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 1
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48E6F6
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48E6F6:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48E717
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48E714
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48E714:                             
                mov     [ebp-38h], ecx

loc_48E717:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48E783(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 99h
                mov     dword ptr [ebp-2Ch], 71h
                mov     dword ptr [ebp-28h], 8Ah
                mov     dword ptr [ebp-24h], 65h
                mov     dword ptr [ebp-20h], 0A4h
                mov     dword ptr [ebp-1Ch], 4Ah
                mov     dword ptr [ebp-18h], 0D9h
                mov     dword ptr [ebp-14h], 3Fh
                mov     dword ptr [ebp-10h], 13h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 13h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48E7FE
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48E7FE:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48E81F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48E81C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48E81C:                             
                mov     [ebp-38h], ecx

loc_48E81F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48E88B(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 38h
                mov     dword ptr [ebp-2Ch], 29h
                mov     dword ptr [ebp-28h], 5Ch
                mov     dword ptr [ebp-24h], 7Fh
                mov     dword ptr [ebp-20h], 0E4h
                mov     dword ptr [ebp-1Ch], 60h
                mov     dword ptr [ebp-18h], 3Dh
                mov     dword ptr [ebp-14h], 0B8h
                mov     dword ptr [ebp-10h], 6
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 6
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48E906
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48E906:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48E927
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48E924
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48E924:                             
                mov     [ebp-38h], ecx

loc_48E927:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48E993(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0
                mov     dword ptr [ebp-2Ch], 85h
                mov     dword ptr [ebp-28h], 0BAh
                mov     dword ptr [ebp-24h], 39h
                mov     dword ptr [ebp-20h], 0A0h
                mov     dword ptr [ebp-1Ch], 99h
                mov     dword ptr [ebp-18h], 0D9h
                mov     dword ptr [ebp-14h], 47h
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48EA0E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48EA0E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48EA2F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48EA2C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48EA2C:                             
                mov     [ebp-38h], ecx

loc_48EA2F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48EA9B(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E8h
                mov     dword ptr [ebp-2Ch], 0B7h
                mov     dword ptr [ebp-28h], 64h
                mov     dword ptr [ebp-24h], 0BBh
                mov     dword ptr [ebp-20h], 0ACh
                mov     dword ptr [ebp-1Ch], 0E9h
                mov     dword ptr [ebp-18h], 6Ch
                mov     dword ptr [ebp-14h], 2Eh
                mov     dword ptr [ebp-10h], 0Eh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Eh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48EB16
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48EB16:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48EB37
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48EB34
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48EB34:                             
                mov     [ebp-38h], ecx

loc_48EB37:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48EBA3(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E7h
                mov     dword ptr [ebp-2Ch], 0B4h
                mov     dword ptr [ebp-28h], 71h
                mov     dword ptr [ebp-24h], 21h
                mov     dword ptr [ebp-20h], 9Dh
                mov     dword ptr [ebp-1Ch], 0D3h
                mov     dword ptr [ebp-18h], 4Dh
                mov     dword ptr [ebp-14h], 0Fh
                mov     dword ptr [ebp-10h], 3
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 3
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48EC1E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48EC1E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48EC3F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48EC3C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48EC3C:                             
                mov     [ebp-38h], ecx

loc_48EC3F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48ECAB(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E2h
                mov     dword ptr [ebp-2Ch], 71h
                mov     dword ptr [ebp-28h], 48h
                mov     dword ptr [ebp-24h], 22h
                mov     dword ptr [ebp-20h], 42h
                mov     dword ptr [ebp-1Ch], 13h
                mov     dword ptr [ebp-18h], 0B1h
                mov     dword ptr [ebp-14h], 8Bh
                mov     dword ptr [ebp-10h], 0Eh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Eh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48ED26
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48ED26:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48ED47
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48ED44
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48ED44:                             
                mov     [ebp-38h], ecx

loc_48ED47:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48EDB3(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 8Bh
                mov     dword ptr [ebp-2Ch], 1
                mov     dword ptr [ebp-28h], 43h
                mov     dword ptr [ebp-24h], 4
                mov     dword ptr [ebp-20h], 2Eh
                mov     dword ptr [ebp-1Ch], 0C6h
                mov     dword ptr [ebp-18h], 0A2h
                mov     dword ptr [ebp-14h], 0C9h
                mov     dword ptr [ebp-10h], 2
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 2
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48EE2E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48EE2E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48EE4F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48EE4C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48EE4C:                             
                mov     [ebp-38h], ecx

loc_48EE4F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48EEBB(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0C9h
                mov     dword ptr [ebp-2Ch], 4Fh
                mov     dword ptr [ebp-28h], 0E8h
                mov     dword ptr [ebp-24h], 58h
                mov     dword ptr [ebp-20h], 8Eh
                mov     dword ptr [ebp-1Ch], 37h
                mov     dword ptr [ebp-18h], 64h
                mov     dword ptr [ebp-14h], 9Eh
                mov     dword ptr [ebp-10h], 0Eh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Eh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48EF36
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48EF36:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48EF57
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48EF54
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48EF54:                             
                mov     [ebp-38h], ecx

loc_48EF57:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48EFC3(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0FAh
                mov     dword ptr [ebp-2Ch], 0D3h
                mov     dword ptr [ebp-28h], 8Dh
                mov     dword ptr [ebp-24h], 0DAh
                mov     dword ptr [ebp-20h], 0B9h
                mov     dword ptr [ebp-1Ch], 0E3h
                mov     dword ptr [ebp-18h], 16h
                mov     dword ptr [ebp-14h], 7Fh
                mov     dword ptr [ebp-10h], 10h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 10h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48F03E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48F03E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48F05F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48F05C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48F05C:                             
                mov     [ebp-38h], ecx

loc_48F05F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48F0CB(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 74h
                mov     dword ptr [ebp-2Ch], 7Fh
                mov     dword ptr [ebp-28h], 21h
                mov     dword ptr [ebp-24h], 77h
                mov     dword ptr [ebp-20h], 0C3h
                mov     dword ptr [ebp-1Ch], 76h
                mov     dword ptr [ebp-18h], 6Bh
                mov     dword ptr [ebp-14h], 0F8h
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48F146
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48F146:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48F167
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48F164
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48F164:                             
                mov     [ebp-38h], ecx

loc_48F167:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48F1D3(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 59h
                mov     dword ptr [ebp-2Ch], 90h
                mov     dword ptr [ebp-28h], 0B0h
                mov     dword ptr [ebp-24h], 0C0h
                mov     dword ptr [ebp-20h], 73h
                mov     dword ptr [ebp-1Ch], 86h
                mov     dword ptr [ebp-18h], 0A0h
                mov     dword ptr [ebp-14h], 0D2h
                mov     dword ptr [ebp-10h], 10h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 10h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48F24E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48F24E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48F26F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48F26C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48F26C:                             
                mov     [ebp-38h], ecx

loc_48F26F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48F2DB(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 77h
                mov     dword ptr [ebp-2Ch], 32h
                mov     dword ptr [ebp-28h], 3Dh
                mov     dword ptr [ebp-24h], 32h
                mov     dword ptr [ebp-20h], 78h
                mov     dword ptr [ebp-1Ch], 89h
                mov     dword ptr [ebp-18h], 0F9h
                mov     dword ptr [ebp-14h], 0C1h
                mov     dword ptr [ebp-10h], 8
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 8
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48F356
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48F356:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48F377
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48F374
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48F374:                             
                mov     [ebp-38h], ecx

loc_48F377:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48F3E3(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0CBh
                mov     dword ptr [ebp-2Ch], 13h
                mov     dword ptr [ebp-28h], 34h
                mov     dword ptr [ebp-24h], 28h
                mov     dword ptr [ebp-20h], 0F8h
                mov     dword ptr [ebp-1Ch], 0AEh
                mov     dword ptr [ebp-18h], 50h
                mov     dword ptr [ebp-14h], 30h
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48F45E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48F45E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48F47F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48F47C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48F47C:                             
                mov     [ebp-38h], ecx

loc_48F47F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48F4EB(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0CEh
                mov     dword ptr [ebp-2Ch], 48h
                mov     dword ptr [ebp-28h], 4Dh
                mov     dword ptr [ebp-24h], 3Bh
                mov     dword ptr [ebp-20h], 0B3h
                mov     dword ptr [ebp-1Ch], 0C5h
                mov     dword ptr [ebp-18h], 0BBh
                mov     dword ptr [ebp-14h], 0C4h
                mov     dword ptr [ebp-10h], 0Eh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Eh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48F566
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48F566:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48F587
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48F584
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48F584:                             
                mov     [ebp-38h], ecx

loc_48F587:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48F5F3(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 7Fh
                mov     dword ptr [ebp-2Ch], 0EDh
                mov     dword ptr [ebp-28h], 0Eh
                mov     dword ptr [ebp-24h], 53h
                mov     dword ptr [ebp-20h], 45h
                mov     dword ptr [ebp-1Ch], 11h
                mov     dword ptr [ebp-18h], 0D3h
                mov     dword ptr [ebp-14h], 0CDh
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48F66E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48F66E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48F68F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48F68C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48F68C:                             
                mov     [ebp-38h], ecx

loc_48F68F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48F6FB(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 1Bh
                mov     dword ptr [ebp-2Ch], 0Dh
                mov     dword ptr [ebp-28h], 0F6h
                mov     dword ptr [ebp-24h], 97h
                mov     dword ptr [ebp-20h], 42h
                mov     dword ptr [ebp-1Ch], 11h
                mov     dword ptr [ebp-18h], 0C6h
                mov     dword ptr [ebp-14h], 0DEh
                mov     dword ptr [ebp-10h], 4
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 4
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48F776
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48F776:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48F797
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48F794
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48F794:                             
                mov     [ebp-38h], ecx

loc_48F797:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48F803(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 74h
                mov     dword ptr [ebp-2Ch], 0C1h
                mov     dword ptr [ebp-28h], 9
                mov     dword ptr [ebp-24h], 0Eh
                mov     dword ptr [ebp-20h], 9
                mov     dword ptr [ebp-1Ch], 0D4h
                mov     dword ptr [ebp-18h], 5Fh
                mov     dword ptr [ebp-14h], 29h
                mov     dword ptr [ebp-10h], 14h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 14h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48F87E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48F87E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48F89F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48F89C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48F89C:                             
                mov     [ebp-38h], ecx

loc_48F89F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48F90B(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E5h
                mov     dword ptr [ebp-2Ch], 6Fh
                mov     dword ptr [ebp-28h], 85h
                mov     dword ptr [ebp-24h], 16h
                mov     dword ptr [ebp-20h], 0Bh
                mov     dword ptr [ebp-1Ch], 0D1h
                mov     dword ptr [ebp-18h], 45h
                mov     dword ptr [ebp-14h], 0BBh
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48F986
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48F986:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48F9A7
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48F9A4
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48F9A4:                             
                mov     [ebp-38h], ecx

loc_48F9A7:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48FA13(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0DDh
                mov     dword ptr [ebp-2Ch], 4Ah
                mov     dword ptr [ebp-28h], 0B6h
                mov     dword ptr [ebp-24h], 11h
                mov     dword ptr [ebp-20h], 55h
                mov     dword ptr [ebp-1Ch], 9Fh
                mov     dword ptr [ebp-18h], 0F6h
                mov     dword ptr [ebp-14h], 76h
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48FA8E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48FA8E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48FAAF
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48FAAC
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48FAAC:                             
                mov     [ebp-38h], ecx

loc_48FAAF:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48FB1B(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0D7h
                mov     dword ptr [ebp-2Ch], 47h
                mov     dword ptr [ebp-28h], 0EFh
                mov     dword ptr [ebp-24h], 36h
                mov     dword ptr [ebp-20h], 0F1h
                mov     dword ptr [ebp-1Ch], 0B2h
                mov     dword ptr [ebp-18h], 57h
                mov     dword ptr [ebp-14h], 47h
                mov     dword ptr [ebp-10h], 0
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48FB93
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48FB93:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48FBB4
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48FBB1
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48FBB1:                             
                mov     [ebp-38h], ecx

loc_48FBB4:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48FC20(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0F1h
                mov     dword ptr [ebp-2Ch], 22h
                mov     dword ptr [ebp-28h], 52h
                mov     dword ptr [ebp-24h], 0E0h
                mov     dword ptr [ebp-20h], 34h
                mov     dword ptr [ebp-1Ch], 79h
                mov     dword ptr [ebp-18h], 0D9h
                mov     dword ptr [ebp-14h], 2
                mov     dword ptr [ebp-10h], 12h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 12h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48FC9B
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48FC9B:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48FCBC
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48FCB9
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48FCB9:                             
                mov     [ebp-38h], ecx

loc_48FCBC:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48FD28(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 45h
                mov     dword ptr [ebp-2Ch], 39h
                mov     dword ptr [ebp-28h], 9Fh
                mov     dword ptr [ebp-24h], 83h
                mov     dword ptr [ebp-20h], 51h
                mov     dword ptr [ebp-1Ch], 48h
                mov     dword ptr [ebp-18h], 2Dh
                mov     dword ptr [ebp-14h], 71h
                mov     dword ptr [ebp-10h], 1
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 1
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48FDA2
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48FDA2:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48FDC3
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48FDC0
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48FDC0:                             
                mov     [ebp-38h], ecx

loc_48FDC3:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48FE2F(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 53h
                mov     dword ptr [ebp-2Ch], 57h
                mov     dword ptr [ebp-28h], 9Ah
                mov     dword ptr [ebp-24h], 62h
                mov     dword ptr [ebp-20h], 14h
                mov     dword ptr [ebp-1Ch], 8Bh
                mov     dword ptr [ebp-18h], 2Ah
                mov     dword ptr [ebp-14h], 19h
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48FEAA
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48FEAA:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48FECB
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48FEC8
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48FEC8:                             
                mov     [ebp-38h], ecx

loc_48FECB:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_48FF37(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 6
                mov     dword ptr [ebp-2Ch], 0Ah
                mov     dword ptr [ebp-28h], 19h
                mov     dword ptr [ebp-24h], 3Ah
                mov     dword ptr [ebp-20h], 0A0h
                mov     dword ptr [ebp-1Ch], 0B1h
                mov     dword ptr [ebp-18h], 0D5h
                mov     dword ptr [ebp-14h], 9Dh
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_48FFB2
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_48FFB2:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_48FFD3
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_48FFD0
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_48FFD0:                             
                mov     [ebp-38h], ecx

loc_48FFD3:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49003F(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0C4h
                mov     dword ptr [ebp-2Ch], 0EAh
                mov     dword ptr [ebp-28h], 4Eh
                mov     dword ptr [ebp-24h], 0BDh
                mov     dword ptr [ebp-20h], 29h
                mov     dword ptr [ebp-1Ch], 9Bh
                mov     dword ptr [ebp-18h], 0ECh
                mov     dword ptr [ebp-14h], 0F6h
                mov     dword ptr [ebp-10h], 6
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 6
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4900BA
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4900BA:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4900DB
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4900D8
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4900D8:                             
                mov     [ebp-38h], ecx

loc_4900DB:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_490147(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 6Fh
                mov     dword ptr [ebp-2Ch], 0A9h
                mov     dword ptr [ebp-28h], 0B8h
                mov     dword ptr [ebp-24h], 9Ch
                mov     dword ptr [ebp-20h], 2Eh
                mov     dword ptr [ebp-1Ch], 21h
                mov     dword ptr [ebp-18h], 0AFh
                mov     dword ptr [ebp-14h], 0D5h
                mov     dword ptr [ebp-10h], 14h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 14h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4901C2
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4901C2:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4901E3
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4901E0
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4901E0:                             
                mov     [ebp-38h], ecx

loc_4901E3:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49024F(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 28h
                mov     dword ptr [ebp-2Ch], 0AAh
                mov     dword ptr [ebp-28h], 60h
                mov     dword ptr [ebp-24h], 8Dh
                mov     dword ptr [ebp-20h], 0A8h
                mov     dword ptr [ebp-1Ch], 77h
                mov     dword ptr [ebp-18h], 2Ah
                mov     dword ptr [ebp-14h], 99h
                mov     dword ptr [ebp-10h], 1
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 1
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4902C9
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4902C9:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4902EA
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4902E7
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4902E7:                             
                mov     [ebp-38h], ecx

loc_4902EA:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_490356(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0A3h
                mov     dword ptr [ebp-2Ch], 4Ah
                mov     dword ptr [ebp-28h], 46h
                mov     dword ptr [ebp-24h], 46h
                mov     dword ptr [ebp-20h], 0B8h
                mov     dword ptr [ebp-1Ch], 0E5h
                mov     dword ptr [ebp-18h], 3Bh
                mov     dword ptr [ebp-14h], 0A0h
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4903D1
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4903D1:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4903F2
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4903EF
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4903EF:                             
                mov     [ebp-38h], ecx

loc_4903F2:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49045E(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0D3h
                mov     dword ptr [ebp-2Ch], 0E2h
                mov     dword ptr [ebp-28h], 15h
                mov     dword ptr [ebp-24h], 0D7h
                mov     dword ptr [ebp-20h], 98h
                mov     dword ptr [ebp-1Ch], 8Dh
                mov     dword ptr [ebp-18h], 10h
                mov     dword ptr [ebp-14h], 0F2h
                mov     dword ptr [ebp-10h], 0Bh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Bh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4904D9
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4904D9:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4904FA
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4904F7
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4904F7:                             
                mov     [ebp-38h], ecx

loc_4904FA:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_490566(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 1Eh
                mov     dword ptr [ebp-2Ch], 0D3h
                mov     dword ptr [ebp-28h], 6Fh
                mov     dword ptr [ebp-24h], 0E4h
                mov     dword ptr [ebp-20h], 34h
                mov     dword ptr [ebp-1Ch], 0F7h
                mov     dword ptr [ebp-18h], 22h
                mov     dword ptr [ebp-14h], 43h
                mov     dword ptr [ebp-10h], 11h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 11h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4905E1
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4905E1:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_490602
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4905FF
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4905FF:                             
                mov     [ebp-38h], ecx

loc_490602:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49066E(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E2h
                mov     dword ptr [ebp-2Ch], 0A7h
                mov     dword ptr [ebp-28h], 0C5h
                mov     dword ptr [ebp-24h], 0
                mov     dword ptr [ebp-20h], 0DFh
                mov     dword ptr [ebp-1Ch], 37h
                mov     dword ptr [ebp-18h], 85h
                mov     dword ptr [ebp-14h], 93h
                mov     dword ptr [ebp-10h], 13h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 13h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4906E9
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4906E9:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49070A
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_490707
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_490707:                             
                mov     [ebp-38h], ecx

loc_49070A:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_490776(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0EDh
                mov     dword ptr [ebp-2Ch], 71h
                mov     dword ptr [ebp-28h], 6Ch
                mov     dword ptr [ebp-24h], 5Bh
                mov     dword ptr [ebp-20h], 7Fh
                mov     dword ptr [ebp-1Ch], 7Ch
                mov     dword ptr [ebp-18h], 1Eh
                mov     dword ptr [ebp-14h], 20h
                mov     dword ptr [ebp-10h], 0Dh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Dh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4907F1
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4907F1:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_490812
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49080F
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49080F:                             
                mov     [ebp-38h], ecx

loc_490812:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49087E(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 9Fh
                mov     dword ptr [ebp-2Ch], 60h
                mov     dword ptr [ebp-28h], 0CAh
                mov     dword ptr [ebp-24h], 0C8h
                mov     dword ptr [ebp-20h], 80h
                mov     dword ptr [ebp-1Ch], 62h
                mov     dword ptr [ebp-18h], 0DFh
                mov     dword ptr [ebp-14h], 53h
                mov     dword ptr [ebp-10h], 0
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4908F6
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4908F6:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_490917
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_490914
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_490914:                             
                mov     [ebp-38h], ecx

loc_490917:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_490983(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 84h
                mov     dword ptr [ebp-2Ch], 0A7h
                mov     dword ptr [ebp-28h], 0CAh
                mov     dword ptr [ebp-24h], 54h
                mov     dword ptr [ebp-20h], 37h
                mov     dword ptr [ebp-1Ch], 0C7h
                mov     dword ptr [ebp-18h], 0C4h
                mov     dword ptr [ebp-14h], 51h
                mov     dword ptr [ebp-10h], 14h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 14h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4909FE
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4909FE:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_490A1F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_490A1C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_490A1C:                             
                mov     [ebp-38h], ecx

loc_490A1F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_490A8B(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 36h
                mov     dword ptr [ebp-2Ch], 7Fh
                mov     dword ptr [ebp-28h], 0B5h
                mov     dword ptr [ebp-24h], 0AFh
                mov     dword ptr [ebp-20h], 0ACh
                mov     dword ptr [ebp-1Ch], 65h
                mov     dword ptr [ebp-18h], 0CFh
                mov     dword ptr [ebp-14h], 0D2h
                mov     dword ptr [ebp-10h], 4
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 4
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_490B06
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_490B06:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_490B27
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_490B24
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_490B24:                             
                mov     [ebp-38h], ecx

loc_490B27:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_490B93(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0CFh
                mov     dword ptr [ebp-2Ch], 5Dh
                mov     dword ptr [ebp-28h], 5Ah
                mov     dword ptr [ebp-24h], 0DBh
                mov     dword ptr [ebp-20h], 9
                mov     dword ptr [ebp-1Ch], 0BEh
                mov     dword ptr [ebp-18h], 65h
                mov     dword ptr [ebp-14h], 77h
                mov     dword ptr [ebp-10h], 2
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 2
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_490C0E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_490C0E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_490C2F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_490C2C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_490C2C:                             
                mov     [ebp-38h], ecx

loc_490C2F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_490C9B(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 91h
                mov     dword ptr [ebp-2Ch], 6Ah
                mov     dword ptr [ebp-28h], 42h
                mov     dword ptr [ebp-24h], 7Dh
                mov     dword ptr [ebp-20h], 0DBh
                mov     dword ptr [ebp-1Ch], 0Ch
                mov     dword ptr [ebp-18h], 89h
                mov     dword ptr [ebp-14h], 89h
                mov     dword ptr [ebp-10h], 12h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 12h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_490D16
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_490D16:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_490D37
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_490D34
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_490D34:                             
                mov     [ebp-38h], ecx

loc_490D37:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_490DA3(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 24h
                mov     dword ptr [ebp-2Ch], 0DBh
                mov     dword ptr [ebp-28h], 0A0h
                mov     dword ptr [ebp-24h], 0AFh
                mov     dword ptr [ebp-20h], 74h
                mov     dword ptr [ebp-1Ch], 0DCh
                mov     dword ptr [ebp-18h], 52h
                mov     dword ptr [ebp-14h], 34h
                mov     dword ptr [ebp-10h], 7
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 7
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_490E1E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_490E1E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_490E3F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_490E3C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_490E3C:                             
                mov     [ebp-38h], ecx

loc_490E3F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_490EAB(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 6Eh
                mov     dword ptr [ebp-2Ch], 4Bh
                mov     dword ptr [ebp-28h], 79h
                mov     dword ptr [ebp-24h], 0D0h
                mov     dword ptr [ebp-20h], 24h
                mov     dword ptr [ebp-1Ch], 0CFh
                mov     dword ptr [ebp-18h], 2Ah
                mov     dword ptr [ebp-14h], 58h
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_490F26
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_490F26:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_490F47
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_490F44
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_490F44:                             
                mov     [ebp-38h], ecx

loc_490F47:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_490FB3(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 96h
                mov     dword ptr [ebp-2Ch], 12h
                mov     dword ptr [ebp-28h], 0CDh
                mov     dword ptr [ebp-24h], 0EDh
                mov     dword ptr [ebp-20h], 47h
                mov     dword ptr [ebp-1Ch], 87h
                mov     dword ptr [ebp-18h], 9Ah
                mov     dword ptr [ebp-14h], 0Ch
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49102E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49102E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49104F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49104C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49104C:                             
                mov     [ebp-38h], ecx

loc_49104F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4910BB(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 32h
                mov     dword ptr [ebp-2Ch], 26h
                mov     dword ptr [ebp-28h], 9Eh
                mov     dword ptr [ebp-24h], 16h
                mov     dword ptr [ebp-20h], 3Dh
                mov     dword ptr [ebp-1Ch], 94h
                mov     dword ptr [ebp-18h], 0C9h
                mov     dword ptr [ebp-14h], 0B9h
                mov     dword ptr [ebp-10h], 0Eh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Eh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_491136
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_491136:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_491157
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_491154
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_491154:                             
                mov     [ebp-38h], ecx

loc_491157:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4911C3(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0C1h
                mov     dword ptr [ebp-2Ch], 42h
                mov     dword ptr [ebp-28h], 49h
                mov     dword ptr [ebp-24h], 1Bh
                mov     dword ptr [ebp-20h], 54h
                mov     dword ptr [ebp-1Ch], 0EAh
                mov     dword ptr [ebp-18h], 4Ch
                mov     dword ptr [ebp-14h], 0Bh
                mov     dword ptr [ebp-10h], 11h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 11h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49123E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49123E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49125F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49125C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49125C:                             
                mov     [ebp-38h], ecx

loc_49125F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4912CB(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0EBh
                mov     dword ptr [ebp-2Ch], 11h
                mov     dword ptr [ebp-28h], 82h
                mov     dword ptr [ebp-24h], 7
                mov     dword ptr [ebp-20h], 4Eh
                mov     dword ptr [ebp-1Ch], 0F5h
                mov     dword ptr [ebp-18h], 4
                mov     dword ptr [ebp-14h], 0A1h
                mov     dword ptr [ebp-10h], 2
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 2
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_491346
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_491346:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_491367
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_491364
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_491364:                             
                mov     [ebp-38h], ecx

loc_491367:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4913D3(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 44h
                mov     dword ptr [ebp-2Ch], 2Fh
                mov     dword ptr [ebp-28h], 0Eh
                mov     dword ptr [ebp-24h], 8
                mov     dword ptr [ebp-20h], 36h
                mov     dword ptr [ebp-1Ch], 81h
                mov     dword ptr [ebp-18h], 60h
                mov     dword ptr [ebp-14h], 63h
                mov     dword ptr [ebp-10h], 4
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 4
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49144E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49144E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49146F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49146C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49146C:                             
                mov     [ebp-38h], ecx

loc_49146F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4914DB(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0EFh
                mov     dword ptr [ebp-2Ch], 10h
                mov     dword ptr [ebp-28h], 9
                mov     dword ptr [ebp-24h], 9Ch
                mov     dword ptr [ebp-20h], 6Eh
                mov     dword ptr [ebp-1Ch], 0F6h
                mov     dword ptr [ebp-18h], 0B4h
                mov     dword ptr [ebp-14h], 0B1h
                mov     dword ptr [ebp-10h], 15h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 15h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_491556
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_491556:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_491577
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_491574
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_491574:                             
                mov     [ebp-38h], ecx

loc_491577:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4915E3(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0EAh
                mov     dword ptr [ebp-2Ch], 0F7h
                mov     dword ptr [ebp-28h], 55h
                mov     dword ptr [ebp-24h], 74h
                mov     dword ptr [ebp-20h], 8Ah
                mov     dword ptr [ebp-1Ch], 0ECh
                mov     dword ptr [ebp-18h], 83h
                mov     dword ptr [ebp-14h], 0Fh
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49165E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49165E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49167F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49167C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49167C:                             
                mov     [ebp-38h], ecx

loc_49167F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4916EB(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E6h
                mov     dword ptr [ebp-2Ch], 75h
                mov     dword ptr [ebp-28h], 8Fh
                mov     dword ptr [ebp-24h], 0B6h
                mov     dword ptr [ebp-20h], 0C5h
                mov     dword ptr [ebp-1Ch], 0A1h
                mov     dword ptr [ebp-18h], 0C1h
                mov     dword ptr [ebp-14h], 53h
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_491766
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_491766:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_491787
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_491784
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_491784:                             
                mov     [ebp-38h], ecx

loc_491787:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4917F3(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0Ch
                mov     dword ptr [ebp-2Ch], 0A3h
                mov     dword ptr [ebp-28h], 0D6h
                mov     dword ptr [ebp-24h], 0C0h
                mov     dword ptr [ebp-20h], 0F2h
                mov     dword ptr [ebp-1Ch], 31h
                mov     dword ptr [ebp-18h], 0C5h
                mov     dword ptr [ebp-14h], 17h
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49186E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49186E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49188F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49188C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49188C:                             
                mov     [ebp-38h], ecx

loc_49188F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4918FB(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 2Fh
                mov     dword ptr [ebp-2Ch], 75h
                mov     dword ptr [ebp-28h], 9Bh
                mov     dword ptr [ebp-24h], 55h
                mov     dword ptr [ebp-20h], 8Ah
                mov     dword ptr [ebp-1Ch], 0A9h
                mov     dword ptr [ebp-18h], 3Ah
                mov     dword ptr [ebp-14h], 72h
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_491976
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_491976:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_491997
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_491994
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_491994:                             
                mov     [ebp-38h], ecx

loc_491997:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_491A03(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 7Fh
                mov     dword ptr [ebp-2Ch], 0F7h
                mov     dword ptr [ebp-28h], 2Dh
                mov     dword ptr [ebp-24h], 70h
                mov     dword ptr [ebp-20h], 7Fh
                mov     dword ptr [ebp-1Ch], 0B7h
                mov     dword ptr [ebp-18h], 73h
                mov     dword ptr [ebp-14h], 0B4h
                mov     dword ptr [ebp-10h], 10h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 10h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_491A7E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_491A7E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_491A9F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_491A9C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_491A9C:                             
                mov     [ebp-38h], ecx

loc_491A9F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_491B0B(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0F4h
                mov     dword ptr [ebp-2Ch], 0E2h
                mov     dword ptr [ebp-28h], 50h
                mov     dword ptr [ebp-24h], 37h
                mov     dword ptr [ebp-20h], 57h
                mov     dword ptr [ebp-1Ch], 0CCh
                mov     dword ptr [ebp-18h], 61h
                mov     dword ptr [ebp-14h], 0BBh
                mov     dword ptr [ebp-10h], 4
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 4
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_491B86
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_491B86:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_491BA7
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_491BA4
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_491BA4:                             
                mov     [ebp-38h], ecx

loc_491BA7:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_491C13(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 5Eh
                mov     dword ptr [ebp-2Ch], 0DEh
                mov     dword ptr [ebp-28h], 6
                mov     dword ptr [ebp-24h], 0BCh
                mov     dword ptr [ebp-20h], 0C7h
                mov     dword ptr [ebp-1Ch], 0F0h
                mov     dword ptr [ebp-18h], 42h
                mov     dword ptr [ebp-14h], 66h
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_491C8E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_491C8E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_491CAF
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_491CAC
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_491CAC:                             
                mov     [ebp-38h], ecx

loc_491CAF:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_491D1B(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0F8h
                mov     dword ptr [ebp-2Ch], 67h
                mov     dword ptr [ebp-28h], 0C4h
                mov     dword ptr [ebp-24h], 0C9h
                mov     dword ptr [ebp-20h], 66h
                mov     dword ptr [ebp-1Ch], 0E6h
                mov     dword ptr [ebp-18h], 0ACh
                mov     dword ptr [ebp-14h], 4Ah
                mov     dword ptr [ebp-10h], 0
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_491D93
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_491D93:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_491DB4
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_491DB1
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_491DB1:                             
                mov     [ebp-38h], ecx

loc_491DB4:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_491E20(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 17h
                mov     dword ptr [ebp-2Ch], 0A1h
                mov     dword ptr [ebp-28h], 82h
                mov     dword ptr [ebp-24h], 1Eh
                mov     dword ptr [ebp-20h], 8Dh
                mov     dword ptr [ebp-1Ch], 72h
                mov     dword ptr [ebp-18h], 6Ah
                mov     dword ptr [ebp-14h], 0F1h
                mov     dword ptr [ebp-10h], 7
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 7
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_491E9B
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_491E9B:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_491EBC
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_491EB9
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_491EB9:                             
                mov     [ebp-38h], ecx

loc_491EBC:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_491F28(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0BBh
                mov     dword ptr [ebp-2Ch], 5Ch
                mov     dword ptr [ebp-28h], 0Ah
                mov     dword ptr [ebp-24h], 51h
                mov     dword ptr [ebp-20h], 0A0h
                mov     dword ptr [ebp-1Ch], 8Eh
                mov     dword ptr [ebp-18h], 17h
                mov     dword ptr [ebp-14h], 0C0h
                mov     dword ptr [ebp-10h], 0Ch
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ch
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_491FA3
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_491FA3:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_491FC4
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_491FC1
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_491FC1:                             
                mov     [ebp-38h], ecx

loc_491FC4:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_492030(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 6Ch
                mov     dword ptr [ebp-2Ch], 79h
                mov     dword ptr [ebp-28h], 87h
                mov     dword ptr [ebp-24h], 0F9h
                mov     dword ptr [ebp-20h], 0A1h
                mov     dword ptr [ebp-1Ch], 0C0h
                mov     dword ptr [ebp-18h], 0Ah
                mov     dword ptr [ebp-14h], 9Bh
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4920AB
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4920AB:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4920CC
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4920C9
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4920C9:                             
                mov     [ebp-38h], ecx

loc_4920CC:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_492138(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 14h
                mov     dword ptr [ebp-2Ch], 0B2h
                mov     dword ptr [ebp-28h], 62h
                mov     dword ptr [ebp-24h], 31h
                mov     dword ptr [ebp-20h], 0D2h
                mov     dword ptr [ebp-1Ch], 28h
                mov     dword ptr [ebp-18h], 0BBh
                mov     dword ptr [ebp-14h], 66h
                mov     dword ptr [ebp-10h], 13h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 13h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4921B3
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4921B3:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4921D4
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4921D1
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4921D1:                             
                mov     [ebp-38h], ecx

loc_4921D4:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_492240(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 4
                mov     dword ptr [ebp-2Ch], 94h
                mov     dword ptr [ebp-28h], 6
                mov     dword ptr [ebp-24h], 0E0h
                mov     dword ptr [ebp-20h], 47h
                mov     dword ptr [ebp-1Ch], 0A7h
                mov     dword ptr [ebp-18h], 67h
                mov     dword ptr [ebp-14h], 67h
                mov     dword ptr [ebp-10h], 0
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4922B8
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4922B8:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4922D9
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4922D6
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4922D6:                             
                mov     [ebp-38h], ecx

loc_4922D9:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_492345(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0A2h
                mov     dword ptr [ebp-2Ch], 41h
                mov     dword ptr [ebp-28h], 51h
                mov     dword ptr [ebp-24h], 18h
                mov     dword ptr [ebp-20h], 5Ch
                mov     dword ptr [ebp-1Ch], 5Dh
                mov     dword ptr [ebp-18h], 0F6h
                mov     dword ptr [ebp-14h], 0C3h
                mov     dword ptr [ebp-10h], 11h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 11h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4923C0
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4923C0:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4923E1
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4923DE
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4923DE:                             
                mov     [ebp-38h], ecx

loc_4923E1:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49244D(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 73h
                mov     dword ptr [ebp-2Ch], 43h
                mov     dword ptr [ebp-28h], 7Dh
                mov     dword ptr [ebp-24h], 0F9h
                mov     dword ptr [ebp-20h], 65h
                mov     dword ptr [ebp-1Ch], 3Fh
                mov     dword ptr [ebp-18h], 0EEh
                mov     dword ptr [ebp-14h], 0F2h
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4924C8
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4924C8:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4924E9
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4924E6
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4924E6:                             
                mov     [ebp-38h], ecx

loc_4924E9:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_492555(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0AEh
                mov     dword ptr [ebp-2Ch], 68h
                mov     dword ptr [ebp-28h], 57h
                mov     dword ptr [ebp-24h], 34h
                mov     dword ptr [ebp-20h], 0D7h
                mov     dword ptr [ebp-1Ch], 0B6h
                mov     dword ptr [ebp-18h], 36h
                mov     dword ptr [ebp-14h], 5Dh
                mov     dword ptr [ebp-10h], 1
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 1
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4925CF
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4925CF:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4925F0
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4925ED
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4925ED:                             
                mov     [ebp-38h], ecx

loc_4925F0:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49265C(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 2Ah
                mov     dword ptr [ebp-2Ch], 0F6h
                mov     dword ptr [ebp-28h], 0BBh
                mov     dword ptr [ebp-24h], 0BDh
                mov     dword ptr [ebp-20h], 0EEh
                mov     dword ptr [ebp-1Ch], 61h
                mov     dword ptr [ebp-18h], 0ECh
                mov     dword ptr [ebp-14h], 95h
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4926D7
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4926D7:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4926F8
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4926F5
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4926F5:                             
                mov     [ebp-38h], ecx

loc_4926F8:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_492764(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 67h
                mov     dword ptr [ebp-2Ch], 0ACh
                mov     dword ptr [ebp-28h], 20h
                mov     dword ptr [ebp-24h], 8Ch
                mov     dword ptr [ebp-20h], 0C4h
                mov     dword ptr [ebp-1Ch], 47h
                mov     dword ptr [ebp-18h], 0
                mov     dword ptr [ebp-14h], 9
                mov     dword ptr [ebp-10h], 0Ch
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ch
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4927DF
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4927DF:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_492800
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4927FD
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4927FD:                             
                mov     [ebp-38h], ecx

loc_492800:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49286C(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 83h
                mov     dword ptr [ebp-2Ch], 5Bh
                mov     dword ptr [ebp-28h], 2
                mov     dword ptr [ebp-24h], 0B1h
                mov     dword ptr [ebp-20h], 26h
                mov     dword ptr [ebp-1Ch], 0A6h
                mov     dword ptr [ebp-18h], 50h
                mov     dword ptr [ebp-14h], 46h
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4928E7
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4928E7:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_492908
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_492905
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_492905:                             
                mov     [ebp-38h], ecx

loc_492908:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_492974(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 77h
                mov     dword ptr [ebp-2Ch], 79h
                mov     dword ptr [ebp-28h], 0FBh
                mov     dword ptr [ebp-24h], 47h
                mov     dword ptr [ebp-20h], 5Bh
                mov     dword ptr [ebp-1Ch], 0E2h
                mov     dword ptr [ebp-18h], 1
                mov     dword ptr [ebp-14h], 0C9h
                mov     dword ptr [ebp-10h], 6
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 6
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4929EF
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4929EF:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_492A10
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_492A0D
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_492A0D:                             
                mov     [ebp-38h], ecx

loc_492A10:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_492A7C(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E5h
                mov     dword ptr [ebp-2Ch], 47h
                mov     dword ptr [ebp-28h], 7Ch
                mov     dword ptr [ebp-24h], 4
                mov     dword ptr [ebp-20h], 26h
                mov     dword ptr [ebp-1Ch], 66h
                mov     dword ptr [ebp-18h], 4Bh
                mov     dword ptr [ebp-14h], 9Bh
                mov     dword ptr [ebp-10h], 0
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_492AF4
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_492AF4:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_492B15
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_492B12
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_492B12:                             
                mov     [ebp-38h], ecx

loc_492B15:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_492B81(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 90h
                mov     dword ptr [ebp-2Ch], 0Eh
                mov     dword ptr [ebp-28h], 0A5h
                mov     dword ptr [ebp-24h], 1Ch
                mov     dword ptr [ebp-20h], 3Fh
                mov     dword ptr [ebp-1Ch], 38h
                mov     dword ptr [ebp-18h], 92h
                mov     dword ptr [ebp-14h], 0DCh
                mov     dword ptr [ebp-10h], 3
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 3
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_492BFC
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_492BFC:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_492C1D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_492C1A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_492C1A:                             
                mov     [ebp-38h], ecx

loc_492C1D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_492C89(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 36h
                mov     dword ptr [ebp-2Ch], 0B0h
                mov     dword ptr [ebp-28h], 38h
                mov     dword ptr [ebp-24h], 2Ch
                mov     dword ptr [ebp-20h], 13h
                mov     dword ptr [ebp-1Ch], 37h
                mov     dword ptr [ebp-18h], 99h
                mov     dword ptr [ebp-14h], 97h
                mov     dword ptr [ebp-10h], 3
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 3
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_492D04
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_492D04:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_492D25
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_492D22
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_492D22:                             
                mov     [ebp-38h], ecx

loc_492D25:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_492D91(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 78h
                mov     dword ptr [ebp-2Ch], 0C0h
                mov     dword ptr [ebp-28h], 60h
                mov     dword ptr [ebp-24h], 0D3h
                mov     dword ptr [ebp-20h], 0EFh
                mov     dword ptr [ebp-1Ch], 2Dh
                mov     dword ptr [ebp-18h], 0B4h
                mov     dword ptr [ebp-14h], 0C9h
                mov     dword ptr [ebp-10h], 0Eh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Eh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_492E0C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_492E0C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_492E2D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_492E2A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_492E2A:                             
                mov     [ebp-38h], ecx

loc_492E2D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_492E99(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0Fh
                mov     dword ptr [ebp-2Ch], 56h
                mov     dword ptr [ebp-28h], 4Dh
                mov     dword ptr [ebp-24h], 0CDh
                mov     dword ptr [ebp-20h], 73h
                mov     dword ptr [ebp-1Ch], 0D1h
                mov     dword ptr [ebp-18h], 20h
                mov     dword ptr [ebp-14h], 87h
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_492F14
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_492F14:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_492F35
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_492F32
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_492F32:                             
                mov     [ebp-38h], ecx

loc_492F35:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_492FA1(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 35h
                mov     dword ptr [ebp-2Ch], 8Ah
                mov     dword ptr [ebp-28h], 0D8h
                mov     dword ptr [ebp-24h], 0A6h
                mov     dword ptr [ebp-20h], 0EDh
                mov     dword ptr [ebp-1Ch], 54h
                mov     dword ptr [ebp-18h], 0A6h
                mov     dword ptr [ebp-14h], 0BBh
                mov     dword ptr [ebp-10h], 15h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 15h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49301C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49301C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49303D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49303A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49303A:                             
                mov     [ebp-38h], ecx

loc_49303D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4930A9(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0A8h
                mov     dword ptr [ebp-2Ch], 0D7h
                mov     dword ptr [ebp-28h], 16h
                mov     dword ptr [ebp-24h], 0AFh
                mov     dword ptr [ebp-20h], 77h
                mov     dword ptr [ebp-1Ch], 2Dh
                mov     dword ptr [ebp-18h], 0CCh
                mov     dword ptr [ebp-14h], 9Bh
                mov     dword ptr [ebp-10h], 8
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 8
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_493124
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_493124:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_493145
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_493142
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_493142:                             
                mov     [ebp-38h], ecx

loc_493145:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4931B1(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0B3h
                mov     dword ptr [ebp-2Ch], 74h
                mov     dword ptr [ebp-28h], 6Eh
                mov     dword ptr [ebp-24h], 0F6h
                mov     dword ptr [ebp-20h], 91h
                mov     dword ptr [ebp-1Ch], 9Bh
                mov     dword ptr [ebp-18h], 0A7h
                mov     dword ptr [ebp-14h], 64h
                mov     dword ptr [ebp-10h], 3
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 3
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49322C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49322C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49324D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49324A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49324A:                             
                mov     [ebp-38h], ecx

loc_49324D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4932B9(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 7Ah
                mov     dword ptr [ebp-2Ch], 5
                mov     dword ptr [ebp-28h], 0Bh
                mov     dword ptr [ebp-24h], 0D6h
                mov     dword ptr [ebp-20h], 5Fh
                mov     dword ptr [ebp-1Ch], 7Bh
                mov     dword ptr [ebp-18h], 72h
                mov     dword ptr [ebp-14h], 0E0h
                mov     dword ptr [ebp-10h], 14h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 14h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_493334
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_493334:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_493355
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_493352
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_493352:                             
                mov     [ebp-38h], ecx

loc_493355:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4933C1(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0C8h
                mov     dword ptr [ebp-2Ch], 0C7h
                mov     dword ptr [ebp-28h], 0EBh
                mov     dword ptr [ebp-24h], 0E4h
                mov     dword ptr [ebp-20h], 7Fh
                mov     dword ptr [ebp-1Ch], 0F5h
                mov     dword ptr [ebp-18h], 34h
                mov     dword ptr [ebp-14h], 0Ah
                mov     dword ptr [ebp-10h], 8
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 8
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49343C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49343C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49345D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49345A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49345A:                             
                mov     [ebp-38h], ecx

loc_49345D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4934C9(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E6h
                mov     dword ptr [ebp-2Ch], 14h
                mov     dword ptr [ebp-28h], 72h
                mov     dword ptr [ebp-24h], 47h
                mov     dword ptr [ebp-20h], 0F7h
                mov     dword ptr [ebp-1Ch], 91h
                mov     dword ptr [ebp-18h], 0E9h
                mov     dword ptr [ebp-14h], 0E1h
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_493544
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_493544:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_493565
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_493562
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_493562:                             
                mov     [ebp-38h], ecx

loc_493565:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4935D1(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 3Ah
                mov     dword ptr [ebp-2Ch], 0Ah
                mov     dword ptr [ebp-28h], 0CAh
                mov     dword ptr [ebp-24h], 38h
                mov     dword ptr [ebp-20h], 90h
                mov     dword ptr [ebp-1Ch], 85h
                mov     dword ptr [ebp-18h], 33h
                mov     dword ptr [ebp-14h], 4Bh
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49364C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49364C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49366D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49366A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49366A:                             
                mov     [ebp-38h], ecx

loc_49366D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4936D9(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0A5h
                mov     dword ptr [ebp-2Ch], 1Fh
                mov     dword ptr [ebp-28h], 1Dh
                mov     dword ptr [ebp-24h], 6Bh
                mov     dword ptr [ebp-20h], 5Bh
                mov     dword ptr [ebp-1Ch], 1Ah
                mov     dword ptr [ebp-18h], 1Ah
                mov     dword ptr [ebp-14h], 0E1h
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_493754
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_493754:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_493775
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_493772
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_493772:                             
                mov     [ebp-38h], ecx

loc_493775:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4937E1(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 31h
                mov     dword ptr [ebp-2Ch], 77h
                mov     dword ptr [ebp-28h], 0D3h
                mov     dword ptr [ebp-24h], 35h
                mov     dword ptr [ebp-20h], 9Bh
                mov     dword ptr [ebp-1Ch], 65h
                mov     dword ptr [ebp-18h], 6Fh
                mov     dword ptr [ebp-14h], 0F5h
                mov     dword ptr [ebp-10h], 8
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 8
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49385C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49385C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49387D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49387A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49387A:                             
                mov     [ebp-38h], ecx

loc_49387D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4938E9(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0Dh
                mov     dword ptr [ebp-2Ch], 22h
                mov     dword ptr [ebp-28h], 52h
                mov     dword ptr [ebp-24h], 0AEh
                mov     dword ptr [ebp-20h], 65h
                mov     dword ptr [ebp-1Ch], 86h
                mov     dword ptr [ebp-18h], 9Ch
                mov     dword ptr [ebp-14h], 28h
                mov     dword ptr [ebp-10h], 0Eh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Eh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_493964
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_493964:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_493985
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_493982
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_493982:                             
                mov     [ebp-38h], ecx

loc_493985:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4939F1(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 5
                mov     dword ptr [ebp-2Ch], 32h
                mov     dword ptr [ebp-28h], 0C6h
                mov     dword ptr [ebp-24h], 2Ch
                mov     dword ptr [ebp-20h], 55h
                mov     dword ptr [ebp-1Ch], 0F3h
                mov     dword ptr [ebp-18h], 2Ch
                mov     dword ptr [ebp-14h], 0DAh
                mov     dword ptr [ebp-10h], 15h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 15h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_493A6C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_493A6C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_493A8D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_493A8A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_493A8A:                             
                mov     [ebp-38h], ecx

loc_493A8D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_493AF9(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 6Dh
                mov     dword ptr [ebp-2Ch], 62h
                mov     dword ptr [ebp-28h], 61h
                mov     dword ptr [ebp-24h], 0C6h
                mov     dword ptr [ebp-20h], 39h
                mov     dword ptr [ebp-1Ch], 0A4h
                mov     dword ptr [ebp-18h], 0ACh
                mov     dword ptr [ebp-14h], 56h
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_493B74
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_493B74:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_493B95
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_493B92
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_493B92:                             
                mov     [ebp-38h], ecx

loc_493B95:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_493C01(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 61h
                mov     dword ptr [ebp-2Ch], 7Eh
                mov     dword ptr [ebp-28h], 6Ah
                mov     dword ptr [ebp-24h], 21h
                mov     dword ptr [ebp-20h], 0EFh
                mov     dword ptr [ebp-1Ch], 0D6h
                mov     dword ptr [ebp-18h], 0ABh
                mov     dword ptr [ebp-14h], 7Fh
                mov     dword ptr [ebp-10h], 3
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 3
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_493C7C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_493C7C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_493C9D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_493C9A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_493C9A:                             
                mov     [ebp-38h], ecx

loc_493C9D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_493D09(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 57h
                mov     dword ptr [ebp-2Ch], 0C9h
                mov     dword ptr [ebp-28h], 0BBh
                mov     dword ptr [ebp-24h], 7Ah
                mov     dword ptr [ebp-20h], 0C1h
                mov     dword ptr [ebp-1Ch], 95h
                mov     dword ptr [ebp-18h], 9Eh
                mov     dword ptr [ebp-14h], 1Ah
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_493D84
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_493D84:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_493DA5
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_493DA2
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_493DA2:                             
                mov     [ebp-38h], ecx

loc_493DA5:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_493E11(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 75h
                mov     dword ptr [ebp-2Ch], 0B2h
                mov     dword ptr [ebp-28h], 85h
                mov     dword ptr [ebp-24h], 0AFh
                mov     dword ptr [ebp-20h], 4Ah
                mov     dword ptr [ebp-1Ch], 8Fh
                mov     dword ptr [ebp-18h], 0D6h
                mov     dword ptr [ebp-14h], 0F1h
                mov     dword ptr [ebp-10h], 4
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 4
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_493E8C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_493E8C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_493EAD
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_493EAA
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_493EAA:                             
                mov     [ebp-38h], ecx

loc_493EAD:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_493F19(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E6h
                mov     dword ptr [ebp-2Ch], 85h
                mov     dword ptr [ebp-28h], 0C7h
                mov     dword ptr [ebp-24h], 72h
                mov     dword ptr [ebp-20h], 12h
                mov     dword ptr [ebp-1Ch], 5Dh
                mov     dword ptr [ebp-18h], 6Ch
                mov     dword ptr [ebp-14h], 1Dh
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_493F94
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_493F94:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_493FB5
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_493FB2
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_493FB2:                             
                mov     [ebp-38h], ecx

loc_493FB5:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494021(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0CAh
                mov     dword ptr [ebp-2Ch], 0DFh
                mov     dword ptr [ebp-28h], 52h
                mov     dword ptr [ebp-24h], 27h
                mov     dword ptr [ebp-20h], 3Bh
                mov     dword ptr [ebp-1Ch], 28h
                mov     dword ptr [ebp-18h], 76h
                mov     dword ptr [ebp-14h], 87h
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49409C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49409C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4940BD
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4940BA
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4940BA:                             
                mov     [ebp-38h], ecx

loc_4940BD:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494129(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 9
                mov     dword ptr [ebp-2Ch], 1Dh
                mov     dword ptr [ebp-28h], 5Eh
                mov     dword ptr [ebp-24h], 7Ch
                mov     dword ptr [ebp-20h], 86h
                mov     dword ptr [ebp-1Ch], 36h
                mov     dword ptr [ebp-18h], 5Ch
                mov     dword ptr [ebp-14h], 21h
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4941A4
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4941A4:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4941C5
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4941C2
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4941C2:                             
                mov     [ebp-38h], ecx

loc_4941C5:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494231(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0FBh
                mov     dword ptr [ebp-2Ch], 0CBh
                mov     dword ptr [ebp-28h], 24h
                mov     dword ptr [ebp-24h], 97h
                mov     dword ptr [ebp-20h], 73h
                mov     dword ptr [ebp-1Ch], 0C5h
                mov     dword ptr [ebp-18h], 10h
                mov     dword ptr [ebp-14h], 8
                mov     dword ptr [ebp-10h], 12h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 12h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4942AC
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4942AC:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4942CD
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4942CA
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4942CA:                             
                mov     [ebp-38h], ecx

loc_4942CD:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494339(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0FBh
                mov     dword ptr [ebp-2Ch], 0D2h
                mov     dword ptr [ebp-28h], 9Bh
                mov     dword ptr [ebp-24h], 5Eh
                mov     dword ptr [ebp-20h], 65h
                mov     dword ptr [ebp-1Ch], 52h
                mov     dword ptr [ebp-18h], 0CCh
                mov     dword ptr [ebp-14h], 7
                mov     dword ptr [ebp-10h], 14h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 14h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4943B4
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4943B4:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4943D5
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4943D2
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4943D2:                             
                mov     [ebp-38h], ecx

loc_4943D5:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494441(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 98h
                mov     dword ptr [ebp-2Ch], 0CCh
                mov     dword ptr [ebp-28h], 47h
                mov     dword ptr [ebp-24h], 0F6h
                mov     dword ptr [ebp-20h], 86h
                mov     dword ptr [ebp-1Ch], 66h
                mov     dword ptr [ebp-18h], 63h
                mov     dword ptr [ebp-14h], 71h
                mov     dword ptr [ebp-10h], 8
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 8
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4944BC
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4944BC:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4944DD
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4944DA
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4944DA:                             
                mov     [ebp-38h], ecx

loc_4944DD:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494549(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 61h
                mov     dword ptr [ebp-2Ch], 91h
                mov     dword ptr [ebp-28h], 6Bh
                mov     dword ptr [ebp-24h], 0D6h
                mov     dword ptr [ebp-20h], 75h
                mov     dword ptr [ebp-1Ch], 0AAh
                mov     dword ptr [ebp-18h], 0F6h
                mov     dword ptr [ebp-14h], 0F5h
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4945C4
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4945C4:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4945E5
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4945E2
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4945E2:                             
                mov     [ebp-38h], ecx

loc_4945E5:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494651(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E9h
                mov     dword ptr [ebp-2Ch], 7
                mov     dword ptr [ebp-28h], 0
                mov     dword ptr [ebp-24h], 0Fh
                mov     dword ptr [ebp-20h], 0B9h
                mov     dword ptr [ebp-1Ch], 8
                mov     dword ptr [ebp-18h], 0B7h
                mov     dword ptr [ebp-14h], 25h
                mov     dword ptr [ebp-10h], 3
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 3
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4946CC
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4946CC:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4946ED
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4946EA
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4946EA:                             
                mov     [ebp-38h], ecx

loc_4946ED:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494759(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 7Fh
                mov     dword ptr [ebp-2Ch], 63h
                mov     dword ptr [ebp-28h], 0C5h
                mov     dword ptr [ebp-24h], 3Dh
                mov     dword ptr [ebp-20h], 6Eh
                mov     dword ptr [ebp-1Ch], 0B1h
                mov     dword ptr [ebp-18h], 31h
                mov     dword ptr [ebp-14h], 5Ch
                mov     dword ptr [ebp-10h], 10h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 10h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4947D4
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4947D4:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4947F5
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4947F2
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4947F2:                             
                mov     [ebp-38h], ecx

loc_4947F5:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494861(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 1Ch
                mov     dword ptr [ebp-2Ch], 68h
                mov     dword ptr [ebp-28h], 9
                mov     dword ptr [ebp-24h], 10h
                mov     dword ptr [ebp-20h], 0BDh
                mov     dword ptr [ebp-1Ch], 57h
                mov     dword ptr [ebp-18h], 53h
                mov     dword ptr [ebp-14h], 88h
                mov     dword ptr [ebp-10h], 13h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 13h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4948DC
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4948DC:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4948FD
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4948FA
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4948FA:                             
                mov     [ebp-38h], ecx

loc_4948FD:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494969(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0CDh
                mov     dword ptr [ebp-2Ch], 94h
                mov     dword ptr [ebp-28h], 0FBh
                mov     dword ptr [ebp-24h], 2
                mov     dword ptr [ebp-20h], 49h
                mov     dword ptr [ebp-1Ch], 0BCh
                mov     dword ptr [ebp-18h], 6
                mov     dword ptr [ebp-14h], 0D5h
                mov     dword ptr [ebp-10h], 2
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 2
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4949E4
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4949E4:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_494A05
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_494A02
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_494A02:                             
                mov     [ebp-38h], ecx

loc_494A05:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494A71(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0B2h
                mov     dword ptr [ebp-2Ch], 3Ah
                mov     dword ptr [ebp-28h], 11h
                mov     dword ptr [ebp-24h], 5Ah
                mov     dword ptr [ebp-20h], 6Eh
                mov     dword ptr [ebp-1Ch], 0EBh
                mov     dword ptr [ebp-18h], 93h
                mov     dword ptr [ebp-14h], 4Ah
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_494AEC
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_494AEC:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_494B0D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_494B0A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_494B0A:                             
                mov     [ebp-38h], ecx

loc_494B0D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494B79(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0F6h
                mov     dword ptr [ebp-2Ch], 32h
                mov     dword ptr [ebp-28h], 0AAh
                mov     dword ptr [ebp-24h], 17h
                mov     dword ptr [ebp-20h], 90h
                mov     dword ptr [ebp-1Ch], 83h
                mov     dword ptr [ebp-18h], 0BDh
                mov     dword ptr [ebp-14h], 1Bh
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_494BF4
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_494BF4:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_494C15
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_494C12
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_494C12:                             
                mov     [ebp-38h], ecx

loc_494C15:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494C81(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0A4h
                mov     dword ptr [ebp-2Ch], 3Bh
                mov     dword ptr [ebp-28h], 30h
                mov     dword ptr [ebp-24h], 28h
                mov     dword ptr [ebp-20h], 8
                mov     dword ptr [ebp-1Ch], 0C5h
                mov     dword ptr [ebp-18h], 6Fh
                mov     dword ptr [ebp-14h], 35h
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_494CFC
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_494CFC:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_494D1D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_494D1A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_494D1A:                             
                mov     [ebp-38h], ecx

loc_494D1D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494D89(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0B9h
                mov     dword ptr [ebp-2Ch], 0A6h
                mov     dword ptr [ebp-28h], 50h
                mov     dword ptr [ebp-24h], 0ADh
                mov     dword ptr [ebp-20h], 82h
                mov     dword ptr [ebp-1Ch], 0E0h
                mov     dword ptr [ebp-18h], 59h
                mov     dword ptr [ebp-14h], 0ABh
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_494E04
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_494E04:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_494E25
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_494E22
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_494E22:                             
                mov     [ebp-38h], ecx

loc_494E25:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494E91(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0B5h
                mov     dword ptr [ebp-2Ch], 0B6h
                mov     dword ptr [ebp-28h], 0C7h
                mov     dword ptr [ebp-24h], 6Fh
                mov     dword ptr [ebp-20h], 0F6h
                mov     dword ptr [ebp-1Ch], 99h
                mov     dword ptr [ebp-18h], 11h
                mov     dword ptr [ebp-14h], 8Dh
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_494F0C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_494F0C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_494F2D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_494F2A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_494F2A:                             
                mov     [ebp-38h], ecx

loc_494F2D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_494F99(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 9Dh
                mov     dword ptr [ebp-2Ch], 32h
                mov     dword ptr [ebp-28h], 37h
                mov     dword ptr [ebp-24h], 0A8h
                mov     dword ptr [ebp-20h], 0B8h
                mov     dword ptr [ebp-1Ch], 0Bh
                mov     dword ptr [ebp-18h], 3Bh
                mov     dword ptr [ebp-14h], 0C9h
                mov     dword ptr [ebp-10h], 0Dh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Dh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_495014
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_495014:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_495035
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_495032
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_495032:                             
                mov     [ebp-38h], ecx

loc_495035:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4950A1(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 98h
                mov     dword ptr [ebp-2Ch], 1Bh
                mov     dword ptr [ebp-28h], 0F4h
                mov     dword ptr [ebp-24h], 3Ah
                mov     dword ptr [ebp-20h], 33h
                mov     dword ptr [ebp-1Ch], 0EEh
                mov     dword ptr [ebp-18h], 82h
                mov     dword ptr [ebp-14h], 78h
                mov     dword ptr [ebp-10h], 14h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 14h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49511C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49511C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49513D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49513A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49513A:                             
                mov     [ebp-38h], ecx

loc_49513D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4951A9(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 17h
                mov     dword ptr [ebp-2Ch], 0DEh
                mov     dword ptr [ebp-28h], 3Fh
                mov     dword ptr [ebp-24h], 0D5h
                mov     dword ptr [ebp-20h], 2Bh
                mov     dword ptr [ebp-1Ch], 44h
                mov     dword ptr [ebp-18h], 72h
                mov     dword ptr [ebp-14h], 63h
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_495224
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_495224:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_495245
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_495242
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_495242:                             
                mov     [ebp-38h], ecx

loc_495245:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4952B1(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0F5h
                mov     dword ptr [ebp-2Ch], 0C9h
                mov     dword ptr [ebp-28h], 31h
                mov     dword ptr [ebp-24h], 2
                mov     dword ptr [ebp-20h], 0ECh
                mov     dword ptr [ebp-1Ch], 0C5h
                mov     dword ptr [ebp-18h], 0
                mov     dword ptr [ebp-14h], 0E1h
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49532C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49532C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49534D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49534A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49534A:                             
                mov     [ebp-38h], ecx

loc_49534D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4953B9(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 5Eh
                mov     dword ptr [ebp-2Ch], 56h
                mov     dword ptr [ebp-28h], 49h
                mov     dword ptr [ebp-24h], 0C3h
                mov     dword ptr [ebp-20h], 0EEh
                mov     dword ptr [ebp-1Ch], 0A3h
                mov     dword ptr [ebp-18h], 71h
                mov     dword ptr [ebp-14h], 43h
                mov     dword ptr [ebp-10h], 0
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_495431
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_495431:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_495452
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49544F
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49544F:                             
                mov     [ebp-38h], ecx

loc_495452:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4954BE(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 6Ah
                mov     dword ptr [ebp-2Ch], 9Ch
                mov     dword ptr [ebp-28h], 2Fh
                mov     dword ptr [ebp-24h], 0A6h
                mov     dword ptr [ebp-20h], 6Eh
                mov     dword ptr [ebp-1Ch], 8Fh
                mov     dword ptr [ebp-18h], 0Dh
                mov     dword ptr [ebp-14h], 0ADh
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_495539
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_495539:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49555A
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_495557
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_495557:                             
                mov     [ebp-38h], ecx

loc_49555A:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4955C6(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E2h
                mov     dword ptr [ebp-2Ch], 65h
                mov     dword ptr [ebp-28h], 0E7h
                mov     dword ptr [ebp-24h], 72h
                mov     dword ptr [ebp-20h], 4Bh
                mov     dword ptr [ebp-1Ch], 0DBh
                mov     dword ptr [ebp-18h], 0A7h
                mov     dword ptr [ebp-14h], 12h
                mov     dword ptr [ebp-10h], 0Ch
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ch
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_495641
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_495641:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_495662
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49565F
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49565F:                             
                mov     [ebp-38h], ecx

loc_495662:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4956CE(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 70h
                mov     dword ptr [ebp-2Ch], 0B4h
                mov     dword ptr [ebp-28h], 0C2h
                mov     dword ptr [ebp-24h], 98h
                mov     dword ptr [ebp-20h], 1Ah
                mov     dword ptr [ebp-1Ch], 0DFh
                mov     dword ptr [ebp-18h], 22h
                mov     dword ptr [ebp-14h], 0C6h
                mov     dword ptr [ebp-10h], 0Eh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Eh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_495749
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_495749:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49576A
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_495767
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_495767:                             
                mov     [ebp-38h], ecx

loc_49576A:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4957D6(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 53h
                mov     dword ptr [ebp-2Ch], 0F2h
                mov     dword ptr [ebp-28h], 65h
                mov     dword ptr [ebp-24h], 93h
                mov     dword ptr [ebp-20h], 82h
                mov     dword ptr [ebp-1Ch], 62h
                mov     dword ptr [ebp-18h], 34h
                mov     dword ptr [ebp-14h], 0Bh
                mov     dword ptr [ebp-10h], 6
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 6
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_495851
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_495851:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_495872
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49586F
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49586F:                             
                mov     [ebp-38h], ecx

loc_495872:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4958DE(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0D7h
                mov     dword ptr [ebp-2Ch], 27h
                mov     dword ptr [ebp-28h], 62h
                mov     dword ptr [ebp-24h], 10h
                mov     dword ptr [ebp-20h], 0D0h
                mov     dword ptr [ebp-1Ch], 18h
                mov     dword ptr [ebp-18h], 79h
                mov     dword ptr [ebp-14h], 6Ah
                mov     dword ptr [ebp-10h], 14h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 14h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_495959
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_495959:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49597A
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_495977
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_495977:                             
                mov     [ebp-38h], ecx

loc_49597A:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4959E6(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E1h
                mov     dword ptr [ebp-2Ch], 6Dh
                mov     dword ptr [ebp-28h], 30h
                mov     dword ptr [ebp-24h], 36h
                mov     dword ptr [ebp-20h], 0F9h
                mov     dword ptr [ebp-1Ch], 0C9h
                mov     dword ptr [ebp-18h], 77h
                mov     dword ptr [ebp-14h], 4Ah
                mov     dword ptr [ebp-10h], 10h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 10h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_495A61
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_495A61:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_495A82
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_495A7F
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_495A7F:                             
                mov     [ebp-38h], ecx

loc_495A82:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_495AEE(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 6Dh
                mov     dword ptr [ebp-2Ch], 42h
                mov     dword ptr [ebp-28h], 14h
                mov     dword ptr [ebp-24h], 63h
                mov     dword ptr [ebp-20h], 59h
                mov     dword ptr [ebp-1Ch], 0B7h
                mov     dword ptr [ebp-18h], 0EAh
                mov     dword ptr [ebp-14h], 9Eh
                mov     dword ptr [ebp-10h], 10h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 10h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_495B69
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_495B69:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_495B8A
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_495B87
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_495B87:                             
                mov     [ebp-38h], ecx

loc_495B8A:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_495BF6(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 3Ch
                mov     dword ptr [ebp-2Ch], 21h
                mov     dword ptr [ebp-28h], 36h
                mov     dword ptr [ebp-24h], 2Eh
                mov     dword ptr [ebp-20h], 0A3h
                mov     dword ptr [ebp-1Ch], 80h
                mov     dword ptr [ebp-18h], 0F0h
                mov     dword ptr [ebp-14h], 0B0h
                mov     dword ptr [ebp-10h], 0Eh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Eh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_495C71
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_495C71:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_495C92
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_495C8F
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_495C8F:                             
                mov     [ebp-38h], ecx

loc_495C92:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_495CFE(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 5
                mov     dword ptr [ebp-2Ch], 0A9h
                mov     dword ptr [ebp-28h], 0E9h
                mov     dword ptr [ebp-24h], 83h
                mov     dword ptr [ebp-20h], 81h
                mov     dword ptr [ebp-1Ch], 36h
                mov     dword ptr [ebp-18h], 69h
                mov     dword ptr [ebp-14h], 2Dh
                mov     dword ptr [ebp-10h], 15h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 15h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_495D79
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_495D79:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_495D9A
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_495D97
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_495D97:                             
                mov     [ebp-38h], ecx

loc_495D9A:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_495E06(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 2
                mov     dword ptr [ebp-2Ch], 3Dh
                mov     dword ptr [ebp-28h], 0CFh
                mov     dword ptr [ebp-24h], 0DFh
                mov     dword ptr [ebp-20h], 24h
                mov     dword ptr [ebp-1Ch], 0B0h
                mov     dword ptr [ebp-18h], 0BEh
                mov     dword ptr [ebp-14h], 47h
                mov     dword ptr [ebp-10h], 11h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 11h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_495E81
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_495E81:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_495EA2
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_495E9F
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_495E9F:                             
                mov     [ebp-38h], ecx

loc_495EA2:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_495F0E(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0BFh
                mov     dword ptr [ebp-2Ch], 24h
                mov     dword ptr [ebp-28h], 32h
                mov     dword ptr [ebp-24h], 0C3h
                mov     dword ptr [ebp-20h], 0FBh
                mov     dword ptr [ebp-1Ch], 64h
                mov     dword ptr [ebp-18h], 87h
                mov     dword ptr [ebp-14h], 0CAh
                mov     dword ptr [ebp-10h], 4
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 4
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_495F89
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_495F89:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_495FAA
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_495FA7
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_495FA7:                             
                mov     [ebp-38h], ecx

loc_495FAA:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_496016(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 2Dh
                mov     dword ptr [ebp-2Ch], 44h
                mov     dword ptr [ebp-28h], 0C1h
                mov     dword ptr [ebp-24h], 4Bh
                mov     dword ptr [ebp-20h], 46h
                mov     dword ptr [ebp-1Ch], 8Ch
                mov     dword ptr [ebp-18h], 0B6h
                mov     dword ptr [ebp-14h], 0FBh
                mov     dword ptr [ebp-10h], 3
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 3
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_496091
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_496091:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4960B2
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4960AF
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4960AF:                             
                mov     [ebp-38h], ecx

loc_4960B2:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49611E(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 83h
                mov     dword ptr [ebp-2Ch], 0EEh
                mov     dword ptr [ebp-28h], 36h
                mov     dword ptr [ebp-24h], 7
                mov     dword ptr [ebp-20h], 0E0h
                mov     dword ptr [ebp-1Ch], 0EFh
                mov     dword ptr [ebp-18h], 0A8h
                mov     dword ptr [ebp-14h], 0A9h
                mov     dword ptr [ebp-10h], 0Ch
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ch
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_496199
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_496199:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4961BA
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4961B7
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4961B7:                             
                mov     [ebp-38h], ecx

loc_4961BA:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_496226(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0CAh
                mov     dword ptr [ebp-2Ch], 0E2h
                mov     dword ptr [ebp-28h], 0B7h
                mov     dword ptr [ebp-24h], 51h
                mov     dword ptr [ebp-20h], 0F6h
                mov     dword ptr [ebp-1Ch], 34h
                mov     dword ptr [ebp-18h], 8Dh
                mov     dword ptr [ebp-14h], 0DCh
                mov     dword ptr [ebp-10h], 15h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 15h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4962A1
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4962A1:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4962C2
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4962BF
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4962BF:                             
                mov     [ebp-38h], ecx

loc_4962C2:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49632E(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 90h
                mov     dword ptr [ebp-2Ch], 2Ch
                mov     dword ptr [ebp-28h], 0BEh
                mov     dword ptr [ebp-24h], 34h
                mov     dword ptr [ebp-20h], 36h
                mov     dword ptr [ebp-1Ch], 28h
                mov     dword ptr [ebp-18h], 8Bh
                mov     dword ptr [ebp-14h], 0B6h
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4963A9
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4963A9:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4963CA
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4963C7
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4963C7:                             
                mov     [ebp-38h], ecx

loc_4963CA:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_496436(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 7Bh
                mov     dword ptr [ebp-2Ch], 0D2h
                mov     dword ptr [ebp-28h], 0F7h
                mov     dword ptr [ebp-24h], 0Ch
                mov     dword ptr [ebp-20h], 84h
                mov     dword ptr [ebp-1Ch], 0B3h
                mov     dword ptr [ebp-18h], 0BAh
                mov     dword ptr [ebp-14h], 92h
                mov     dword ptr [ebp-10h], 8
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 8
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4964B1
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4964B1:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4964D2
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4964CF
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4964CF:                             
                mov     [ebp-38h], ecx

loc_4964D2:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49653E(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 44h
                mov     dword ptr [ebp-2Ch], 6Eh
                mov     dword ptr [ebp-28h], 0D2h
                mov     dword ptr [ebp-24h], 44h
                mov     dword ptr [ebp-20h], 0CBh
                mov     dword ptr [ebp-1Ch], 88h
                mov     dword ptr [ebp-18h], 9Bh
                mov     dword ptr [ebp-14h], 0C9h
                mov     dword ptr [ebp-10h], 1
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 1
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4965B8
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4965B8:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4965D9
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4965D6
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4965D6:                             
                mov     [ebp-38h], ecx

loc_4965D9:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_496645(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0A5h
                mov     dword ptr [ebp-2Ch], 73h
                mov     dword ptr [ebp-28h], 8Ah
                mov     dword ptr [ebp-24h], 51h
                mov     dword ptr [ebp-20h], 2Bh
                mov     dword ptr [ebp-1Ch], 0F0h
                mov     dword ptr [ebp-18h], 0C0h
                mov     dword ptr [ebp-14h], 96h
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4966C0
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4966C0:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4966E1
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4966DE
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4966DE:                             
                mov     [ebp-38h], ecx

loc_4966E1:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49674D(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0F9h
                mov     dword ptr [ebp-2Ch], 8Ch
                mov     dword ptr [ebp-28h], 1Ch
                mov     dword ptr [ebp-24h], 6Eh
                mov     dword ptr [ebp-20h], 0E3h
                mov     dword ptr [ebp-1Ch], 0F5h
                mov     dword ptr [ebp-18h], 0E4h
                mov     dword ptr [ebp-14h], 81h
                mov     dword ptr [ebp-10h], 2
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 2
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4967C8
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4967C8:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4967E9
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4967E6
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4967E6:                             
                mov     [ebp-38h], ecx

loc_4967E9:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_496855(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 20h
                mov     dword ptr [ebp-2Ch], 8Eh
                mov     dword ptr [ebp-28h], 0D9h
                mov     dword ptr [ebp-24h], 67h
                mov     dword ptr [ebp-20h], 0B9h
                mov     dword ptr [ebp-1Ch], 88h
                mov     dword ptr [ebp-18h], 71h
                mov     dword ptr [ebp-14h], 90h
                mov     dword ptr [ebp-10h], 1
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 1
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4968CF
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4968CF:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4968F0
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4968ED
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4968ED:                             
                mov     [ebp-38h], ecx

loc_4968F0:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49695C(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 5Fh
                mov     dword ptr [ebp-2Ch], 0F9h
                mov     dword ptr [ebp-28h], 0EFh
                mov     dword ptr [ebp-24h], 5Ah
                mov     dword ptr [ebp-20h], 12h
                mov     dword ptr [ebp-1Ch], 8Bh
                mov     dword ptr [ebp-18h], 5Dh
                mov     dword ptr [ebp-14h], 37h
                mov     dword ptr [ebp-10h], 11h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 11h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4969D7
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4969D7:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4969F8
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4969F5
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4969F5:                             
                mov     [ebp-38h], ecx

loc_4969F8:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_496A64(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0DDh
                mov     dword ptr [ebp-2Ch], 0DAh
                mov     dword ptr [ebp-28h], 71h
                mov     dword ptr [ebp-24h], 58h
                mov     dword ptr [ebp-20h], 51h
                mov     dword ptr [ebp-1Ch], 96h
                mov     dword ptr [ebp-18h], 60h
                mov     dword ptr [ebp-14h], 8Dh
                mov     dword ptr [ebp-10h], 7
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 7
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_496ADF
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_496ADF:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_496B00
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_496AFD
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_496AFD:                             
                mov     [ebp-38h], ecx

loc_496B00:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_496B6C(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 9Bh
                mov     dword ptr [ebp-2Ch], 0D1h
                mov     dword ptr [ebp-28h], 43h
                mov     dword ptr [ebp-24h], 55h
                mov     dword ptr [ebp-20h], 89h
                mov     dword ptr [ebp-1Ch], 5Fh
                mov     dword ptr [ebp-18h], 33h
                mov     dword ptr [ebp-14h], 0E4h
                mov     dword ptr [ebp-10h], 8
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 8
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_496BE7
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_496BE7:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_496C08
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_496C05
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_496C05:                             
                mov     [ebp-38h], ecx

loc_496C08:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_496C74(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0CFh
                mov     dword ptr [ebp-2Ch], 76h
                mov     dword ptr [ebp-28h], 0Dh
                mov     dword ptr [ebp-24h], 0E5h
                mov     dword ptr [ebp-20h], 6Fh
                mov     dword ptr [ebp-1Ch], 19h
                mov     dword ptr [ebp-18h], 73h
                mov     dword ptr [ebp-14h], 0AAh
                mov     dword ptr [ebp-10h], 8
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 8
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_496CEF
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_496CEF:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_496D10
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_496D0D
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_496D0D:                             
                mov     [ebp-38h], ecx

loc_496D10:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_496D7C(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 19h
                mov     dword ptr [ebp-2Ch], 0Ah
                mov     dword ptr [ebp-28h], 8
                mov     dword ptr [ebp-24h], 0A0h
                mov     dword ptr [ebp-20h], 3Dh
                mov     dword ptr [ebp-1Ch], 97h
                mov     dword ptr [ebp-18h], 0D7h
                mov     dword ptr [ebp-14h], 94h
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_496DF7
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_496DF7:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_496E18
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_496E15
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_496E15:                             
                mov     [ebp-38h], ecx

loc_496E18:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_496E84(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 38h
                mov     dword ptr [ebp-2Ch], 0BDh
                mov     dword ptr [ebp-28h], 0BEh
                mov     dword ptr [ebp-24h], 46h
                mov     dword ptr [ebp-20h], 2Fh
                mov     dword ptr [ebp-1Ch], 0C6h
                mov     dword ptr [ebp-18h], 54h
                mov     dword ptr [ebp-14h], 0BFh
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_496EFF
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_496EFF:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_496F20
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_496F1D
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_496F1D:                             
                mov     [ebp-38h], ecx

loc_496F20:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_496F8C(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 26h
                mov     dword ptr [ebp-2Ch], 47h
                mov     dword ptr [ebp-28h], 84h
                mov     dword ptr [ebp-24h], 0F4h
                mov     dword ptr [ebp-20h], 1
                mov     dword ptr [ebp-1Ch], 2Fh
                mov     dword ptr [ebp-18h], 0C0h
                mov     dword ptr [ebp-14h], 0E8h
                mov     dword ptr [ebp-10h], 8
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 8
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_497007
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_497007:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_497028
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_497025
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_497025:                             
                mov     [ebp-38h], ecx

loc_497028:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_497094(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 65h
                mov     dword ptr [ebp-2Ch], 65h
                mov     dword ptr [ebp-28h], 7Bh
                mov     dword ptr [ebp-24h], 0Bh
                mov     dword ptr [ebp-20h], 0DFh
                mov     dword ptr [ebp-1Ch], 0CBh
                mov     dword ptr [ebp-18h], 0Ah
                mov     dword ptr [ebp-14h], 36h
                mov     dword ptr [ebp-10h], 4
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 4
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49710F
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49710F:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_497130
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49712D
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49712D:                             
                mov     [ebp-38h], ecx

loc_497130:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49719C(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 84h
                mov     dword ptr [ebp-2Ch], 19h
                mov     dword ptr [ebp-28h], 7Eh
                mov     dword ptr [ebp-24h], 95h
                mov     dword ptr [ebp-20h], 5Eh
                mov     dword ptr [ebp-1Ch], 6Fh
                mov     dword ptr [ebp-18h], 94h
                mov     dword ptr [ebp-14h], 0B3h
                mov     dword ptr [ebp-10h], 10h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 10h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_497217
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_497217:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_497238
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_497235
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_497235:                             
                mov     [ebp-38h], ecx

loc_497238:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4972A4(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0C6h
                mov     dword ptr [ebp-2Ch], 87h
                mov     dword ptr [ebp-28h], 24h
                mov     dword ptr [ebp-24h], 78h
                mov     dword ptr [ebp-20h], 92h
                mov     dword ptr [ebp-1Ch], 0ABh
                mov     dword ptr [ebp-18h], 0BBh
                mov     dword ptr [ebp-14h], 0ADh
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49731F
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49731F:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_497340
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49733D
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49733D:                             
                mov     [ebp-38h], ecx

loc_497340:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4973AC(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 8
                mov     dword ptr [ebp-2Ch], 37h
                mov     dword ptr [ebp-28h], 68h
                mov     dword ptr [ebp-24h], 13h
                mov     dword ptr [ebp-20h], 7Ch
                mov     dword ptr [ebp-1Ch], 27h
                mov     dword ptr [ebp-18h], 16h
                mov     dword ptr [ebp-14h], 5Ah
                mov     dword ptr [ebp-10h], 15h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 15h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_497427
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_497427:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_497448
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_497445
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_497445:                             
                mov     [ebp-38h], ecx

loc_497448:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4974B4(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 8Bh
                mov     dword ptr [ebp-2Ch], 0B4h
                mov     dword ptr [ebp-28h], 45h
                mov     dword ptr [ebp-24h], 94h
                mov     dword ptr [ebp-20h], 52h
                mov     dword ptr [ebp-1Ch], 5Fh
                mov     dword ptr [ebp-18h], 0DBh
                mov     dword ptr [ebp-14h], 84h
                mov     dword ptr [ebp-10h], 0Dh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Dh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49752F
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49752F:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_497550
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49754D
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49754D:                             
                mov     [ebp-38h], ecx

loc_497550:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4975BC(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 6Bh
                mov     dword ptr [ebp-2Ch], 0Bh
                mov     dword ptr [ebp-28h], 64h
                mov     dword ptr [ebp-24h], 0F6h
                mov     dword ptr [ebp-20h], 0B0h
                mov     dword ptr [ebp-1Ch], 3Bh
                mov     dword ptr [ebp-18h], 0F4h
                mov     dword ptr [ebp-14h], 0B7h
                mov     dword ptr [ebp-10h], 0
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_497634
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_497634:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_497655
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_497652
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_497652:                             
                mov     [ebp-38h], ecx

loc_497655:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4976C1(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 36h
                mov     dword ptr [ebp-2Ch], 92h
                mov     dword ptr [ebp-28h], 7Eh
                mov     dword ptr [ebp-24h], 7Dh
                mov     dword ptr [ebp-20h], 0FBh
                mov     dword ptr [ebp-1Ch], 0E3h
                mov     dword ptr [ebp-18h], 85h
                mov     dword ptr [ebp-14h], 5Dh
                mov     dword ptr [ebp-10h], 0Bh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Bh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49773C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49773C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49775D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49775A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49775A:                             
                mov     [ebp-38h], ecx

loc_49775D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4977C9(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 30h
                mov     dword ptr [ebp-2Ch], 0DEh
                mov     dword ptr [ebp-28h], 0EDh
                mov     dword ptr [ebp-24h], 8
                mov     dword ptr [ebp-20h], 38h
                mov     dword ptr [ebp-1Ch], 8
                mov     dword ptr [ebp-18h], 0Ch
                mov     dword ptr [ebp-14h], 1
                mov     dword ptr [ebp-10h], 12h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 12h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_497844
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_497844:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_497865
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_497862
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_497862:                             
                mov     [ebp-38h], ecx

loc_497865:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4978D1(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E3h
                mov     dword ptr [ebp-2Ch], 89h
                mov     dword ptr [ebp-28h], 6
                mov     dword ptr [ebp-24h], 1Ch
                mov     dword ptr [ebp-20h], 0B9h
                mov     dword ptr [ebp-1Ch], 3Bh
                mov     dword ptr [ebp-18h], 42h
                mov     dword ptr [ebp-14h], 1Eh
                mov     dword ptr [ebp-10h], 8
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 8
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49794C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49794C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49796D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49796A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49796A:                             
                mov     [ebp-38h], ecx

loc_49796D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4979D9(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 6
                mov     dword ptr [ebp-2Ch], 0E8h
                mov     dword ptr [ebp-28h], 14h
                mov     dword ptr [ebp-24h], 0B8h
                mov     dword ptr [ebp-20h], 4
                mov     dword ptr [ebp-1Ch], 0Bh
                mov     dword ptr [ebp-18h], 0FAh
                mov     dword ptr [ebp-14h], 28h
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_497A54
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_497A54:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_497A75
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_497A72
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_497A72:                             
                mov     [ebp-38h], ecx

loc_497A75:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_497AE1(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 44h
                mov     dword ptr [ebp-2Ch], 6Ch
                mov     dword ptr [ebp-28h], 0A5h
                mov     dword ptr [ebp-24h], 0F3h
                mov     dword ptr [ebp-20h], 5Bh
                mov     dword ptr [ebp-1Ch], 0C8h
                mov     dword ptr [ebp-18h], 0E9h
                mov     dword ptr [ebp-14h], 0ABh
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_497B5C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_497B5C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_497B7D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_497B7A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_497B7A:                             
                mov     [ebp-38h], ecx

loc_497B7D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_497BE9(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 8Ch
                mov     dword ptr [ebp-2Ch], 51h
                mov     dword ptr [ebp-28h], 7Dh
                mov     dword ptr [ebp-24h], 4Ch
                mov     dword ptr [ebp-20h], 48h
                mov     dword ptr [ebp-1Ch], 0D8h
                mov     dword ptr [ebp-18h], 19h
                mov     dword ptr [ebp-14h], 0A3h
                mov     dword ptr [ebp-10h], 7
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 7
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_497C64
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_497C64:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_497C85
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_497C82
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_497C82:                             
                mov     [ebp-38h], ecx

loc_497C85:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_497CF1(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0Dh
                mov     dword ptr [ebp-2Ch], 22h
                mov     dword ptr [ebp-28h], 18h
                mov     dword ptr [ebp-24h], 0C3h
                mov     dword ptr [ebp-20h], 0F8h
                mov     dword ptr [ebp-1Ch], 1Dh
                mov     dword ptr [ebp-18h], 0A1h
                mov     dword ptr [ebp-14h], 8
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_497D6C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_497D6C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_497D8D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_497D8A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_497D8A:                             
                mov     [ebp-38h], ecx

loc_497D8D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_497DF9(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 65h
                mov     dword ptr [ebp-2Ch], 8Ch
                mov     dword ptr [ebp-28h], 75h
                mov     dword ptr [ebp-24h], 58h
                mov     dword ptr [ebp-20h], 4
                mov     dword ptr [ebp-1Ch], 6
                mov     dword ptr [ebp-18h], 0A5h
                mov     dword ptr [ebp-14h], 48h
                mov     dword ptr [ebp-10h], 6
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 6
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_497E74
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_497E74:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_497E95
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_497E92
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_497E92:                             
                mov     [ebp-38h], ecx

loc_497E95:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_497F01(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0Ch
                mov     dword ptr [ebp-2Ch], 46h
                mov     dword ptr [ebp-28h], 9Ah
                mov     dword ptr [ebp-24h], 0C1h
                mov     dword ptr [ebp-20h], 0EEh
                mov     dword ptr [ebp-1Ch], 0DBh
                mov     dword ptr [ebp-18h], 0E0h
                mov     dword ptr [ebp-14h], 0B1h
                mov     dword ptr [ebp-10h], 7
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 7
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_497F7C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_497F7C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_497F9D
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_497F9A
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_497F9A:                             
                mov     [ebp-38h], ecx

loc_497F9D:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498009(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0C4h
                mov     dword ptr [ebp-2Ch], 0CCh
                mov     dword ptr [ebp-28h], 95h
                mov     dword ptr [ebp-24h], 0BBh
                mov     dword ptr [ebp-20h], 2Eh
                mov     dword ptr [ebp-1Ch], 0C4h
                mov     dword ptr [ebp-18h], 2Ch
                mov     dword ptr [ebp-14h], 42h
                mov     dword ptr [ebp-10h], 2
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 2
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_498084
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_498084:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4980A5
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4980A2
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4980A2:                             
                mov     [ebp-38h], ecx

loc_4980A5:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498111(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 7Dh
                mov     dword ptr [ebp-2Ch], 0D4h
                mov     dword ptr [ebp-28h], 0B0h
                mov     dword ptr [ebp-24h], 20h
                mov     dword ptr [ebp-20h], 0B8h
                mov     dword ptr [ebp-1Ch], 0C0h
                mov     dword ptr [ebp-18h], 0F4h
                mov     dword ptr [ebp-14h], 0E1h
                mov     dword ptr [ebp-10h], 13h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 13h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49818C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49818C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4981AD
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4981AA
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4981AA:                             
                mov     [ebp-38h], ecx

loc_4981AD:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498219(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 3Ch
                mov     dword ptr [ebp-2Ch], 7Fh
                mov     dword ptr [ebp-28h], 56h
                mov     dword ptr [ebp-24h], 58h
                mov     dword ptr [ebp-20h], 42h
                mov     dword ptr [ebp-1Ch], 52h
                mov     dword ptr [ebp-18h], 0D7h
                mov     dword ptr [ebp-14h], 0F9h
                mov     dword ptr [ebp-10h], 15h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 15h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_498294
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_498294:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4982B5
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4982B2
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4982B2:                             
                mov     [ebp-38h], ecx

loc_4982B5:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498321(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0B3h
                mov     dword ptr [ebp-2Ch], 0B9h
                mov     dword ptr [ebp-28h], 64h
                mov     dword ptr [ebp-24h], 8
                mov     dword ptr [ebp-20h], 0C3h
                mov     dword ptr [ebp-1Ch], 0B3h
                mov     dword ptr [ebp-18h], 95h
                mov     dword ptr [ebp-14h], 39h
                mov     dword ptr [ebp-10h], 6
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 6
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49839C
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49839C:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4983BD
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4983BA
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4983BA:                             
                mov     [ebp-38h], ecx

loc_4983BD:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498429(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 4Ah
                mov     dword ptr [ebp-2Ch], 49h
                mov     dword ptr [ebp-28h], 1
                mov     dword ptr [ebp-24h], 93h
                mov     dword ptr [ebp-20h], 9
                mov     dword ptr [ebp-1Ch], 0A2h
                mov     dword ptr [ebp-18h], 24h
                mov     dword ptr [ebp-14h], 66h
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4984A4
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4984A4:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4984C5
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4984C2
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4984C2:                             
                mov     [ebp-38h], ecx

loc_4984C5:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498531(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0ABh
                mov     dword ptr [ebp-2Ch], 0D4h
                mov     dword ptr [ebp-28h], 23h
                mov     dword ptr [ebp-24h], 44h
                mov     dword ptr [ebp-20h], 3Ch
                mov     dword ptr [ebp-1Ch], 6Dh
                mov     dword ptr [ebp-18h], 9Bh
                mov     dword ptr [ebp-14h], 9Eh
                mov     dword ptr [ebp-10h], 6
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 6
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4985AC
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4985AC:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4985CD
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4985CA
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4985CA:                             
                mov     [ebp-38h], ecx

loc_4985CD:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498639(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 8Eh
                mov     dword ptr [ebp-2Ch], 0BFh
                mov     dword ptr [ebp-28h], 6Bh
                mov     dword ptr [ebp-24h], 0B2h
                mov     dword ptr [ebp-20h], 2Ch
                mov     dword ptr [ebp-1Ch], 40h
                mov     dword ptr [ebp-18h], 97h
                mov     dword ptr [ebp-14h], 47h
                mov     dword ptr [ebp-10h], 1
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 1
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4986B3
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4986B3:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4986D4
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4986D1
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4986D1:                             
                mov     [ebp-38h], ecx

loc_4986D4:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498740(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0CAh
                mov     dword ptr [ebp-2Ch], 0E1h
                mov     dword ptr [ebp-28h], 55h
                mov     dword ptr [ebp-24h], 0AFh
                mov     dword ptr [ebp-20h], 0E5h
                mov     dword ptr [ebp-1Ch], 9Eh
                mov     dword ptr [ebp-18h], 3Fh
                mov     dword ptr [ebp-14h], 53h
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4987BB
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4987BB:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4987DC
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4987D9
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4987D9:                             
                mov     [ebp-38h], ecx

loc_4987DC:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498848(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 3Fh
                mov     dword ptr [ebp-2Ch], 2Fh
                mov     dword ptr [ebp-28h], 0Eh
                mov     dword ptr [ebp-24h], 19h
                mov     dword ptr [ebp-20h], 7Eh
                mov     dword ptr [ebp-1Ch], 37h
                mov     dword ptr [ebp-18h], 2Fh
                mov     dword ptr [ebp-14h], 0B4h
                mov     dword ptr [ebp-10h], 0Bh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Bh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4988C3
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4988C3:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4988E4
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4988E1
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4988E1:                             
                mov     [ebp-38h], ecx

loc_4988E4:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498950(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 16h
                mov     dword ptr [ebp-2Ch], 8Eh
                mov     dword ptr [ebp-28h], 37h
                mov     dword ptr [ebp-24h], 92h
                mov     dword ptr [ebp-20h], 58h
                mov     dword ptr [ebp-1Ch], 29h
                mov     dword ptr [ebp-18h], 0A1h
                mov     dword ptr [ebp-14h], 89h
                mov     dword ptr [ebp-10h], 4
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 4
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_4989CB
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_4989CB:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_4989EC
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_4989E9
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_4989E9:                             
                mov     [ebp-38h], ecx

loc_4989EC:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498A58(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0A4h
                mov     dword ptr [ebp-2Ch], 58h
                mov     dword ptr [ebp-28h], 0EBh
                mov     dword ptr [ebp-24h], 0E5h
                mov     dword ptr [ebp-20h], 50h
                mov     dword ptr [ebp-1Ch], 25h
                mov     dword ptr [ebp-18h], 44h
                mov     dword ptr [ebp-14h], 6Eh
                mov     dword ptr [ebp-10h], 0
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_498AD0
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_498AD0:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_498AF1
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_498AEE
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_498AEE:                             
                mov     [ebp-38h], ecx

loc_498AF1:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498B5D(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 6
                mov     dword ptr [ebp-2Ch], 7
                mov     dword ptr [ebp-28h], 0AAh
                mov     dword ptr [ebp-24h], 0A0h
                mov     dword ptr [ebp-20h], 7Dh
                mov     dword ptr [ebp-1Ch], 12h
                mov     dword ptr [ebp-18h], 7Ah
                mov     dword ptr [ebp-14h], 21h
                mov     dword ptr [ebp-10h], 10h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 10h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_498BD8
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_498BD8:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_498BF9
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_498BF6
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_498BF6:                             
                mov     [ebp-38h], ecx

loc_498BF9:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498C65(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0BDh
                mov     dword ptr [ebp-2Ch], 0A9h
                mov     dword ptr [ebp-28h], 85h
                mov     dword ptr [ebp-24h], 0A9h
                mov     dword ptr [ebp-20h], 0ECh
                mov     dword ptr [ebp-1Ch], 0E1h
                mov     dword ptr [ebp-18h], 0F9h
                mov     dword ptr [ebp-14h], 25h
                mov     dword ptr [ebp-10h], 4
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 4
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_498CE0
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_498CE0:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_498D01
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_498CFE
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_498CFE:                             
                mov     [ebp-38h], ecx

loc_498D01:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498D6D(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 1Eh
                mov     dword ptr [ebp-2Ch], 7Eh
                mov     dword ptr [ebp-28h], 0DBh
                mov     dword ptr [ebp-24h], 36h
                mov     dword ptr [ebp-20h], 14h
                mov     dword ptr [ebp-1Ch], 23h
                mov     dword ptr [ebp-18h], 95h
                mov     dword ptr [ebp-14h], 83h
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_498DE8
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_498DE8:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_498E09
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_498E06
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_498E06:                             
                mov     [ebp-38h], ecx

loc_498E09:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498E75(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 43h
                mov     dword ptr [ebp-2Ch], 0AEh
                mov     dword ptr [ebp-28h], 11h
                mov     dword ptr [ebp-24h], 5Dh
                mov     dword ptr [ebp-20h], 0A7h
                mov     dword ptr [ebp-1Ch], 9Dh
                mov     dword ptr [ebp-18h], 0DBh
                mov     dword ptr [ebp-14h], 14h
                mov     dword ptr [ebp-10h], 6
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 6
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_498EF0
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_498EF0:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_498F11
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_498F0E
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_498F0E:                             
                mov     [ebp-38h], ecx

loc_498F11:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_498F7D(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 90h
                mov     dword ptr [ebp-2Ch], 0A1h
                mov     dword ptr [ebp-28h], 0C3h
                mov     dword ptr [ebp-24h], 37h
                mov     dword ptr [ebp-20h], 0E8h
                mov     dword ptr [ebp-1Ch], 0B6h
                mov     dword ptr [ebp-18h], 3Eh
                mov     dword ptr [ebp-14h], 0A1h
                mov     dword ptr [ebp-10h], 0Bh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Bh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_498FF8
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_498FF8:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_499019
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_499016
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_499016:                             
                mov     [ebp-38h], ecx

loc_499019:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_499085(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0EDh
                mov     dword ptr [ebp-2Ch], 0B1h
                mov     dword ptr [ebp-28h], 0FAh
                mov     dword ptr [ebp-24h], 6Fh
                mov     dword ptr [ebp-20h], 76h
                mov     dword ptr [ebp-1Ch], 49h
                mov     dword ptr [ebp-18h], 7Ah
                mov     dword ptr [ebp-14h], 6Dh
                mov     dword ptr [ebp-10h], 3
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 3
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_499100
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_499100:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_499121
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49911E
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49911E:                             
                mov     [ebp-38h], ecx

loc_499121:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49918D(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 79h
                mov     dword ptr [ebp-2Ch], 0A3h
                mov     dword ptr [ebp-28h], 0CCh
                mov     dword ptr [ebp-24h], 38h
                mov     dword ptr [ebp-20h], 3
                mov     dword ptr [ebp-1Ch], 0B6h
                mov     dword ptr [ebp-18h], 50h
                mov     dword ptr [ebp-14h], 0E7h
                mov     dword ptr [ebp-10h], 0Dh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Dh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_499208
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_499208:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_499229
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_499226
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_499226:                             
                mov     [ebp-38h], ecx

loc_499229:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_499295(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 99h
                mov     dword ptr [ebp-2Ch], 75h
                mov     dword ptr [ebp-28h], 8Bh
                mov     dword ptr [ebp-24h], 0F5h
                mov     dword ptr [ebp-20h], 0F2h
                mov     dword ptr [ebp-1Ch], 0E1h
                mov     dword ptr [ebp-18h], 4Eh
                mov     dword ptr [ebp-14h], 1Dh
                mov     dword ptr [ebp-10h], 10h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 10h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_499310
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_499310:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_499331
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49932E
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49932E:                             
                mov     [ebp-38h], ecx

loc_499331:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49939D(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0D3h
                mov     dword ptr [ebp-2Ch], 8Fh
                mov     dword ptr [ebp-28h], 0F9h
                mov     dword ptr [ebp-24h], 0B3h
                mov     dword ptr [ebp-20h], 0DCh
                mov     dword ptr [ebp-1Ch], 69h
                mov     dword ptr [ebp-18h], 37h
                mov     dword ptr [ebp-14h], 9Eh
                mov     dword ptr [ebp-10h], 2
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 2
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_499418
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_499418:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_499439
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_499436
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_499436:                             
                mov     [ebp-38h], ecx

loc_499439:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4994A5(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 2Ch
                mov     dword ptr [ebp-2Ch], 0CDh
                mov     dword ptr [ebp-28h], 37h
                mov     dword ptr [ebp-24h], 3Fh
                mov     dword ptr [ebp-20h], 4Fh
                mov     dword ptr [ebp-1Ch], 63h
                mov     dword ptr [ebp-18h], 33h
                mov     dword ptr [ebp-14h], 0AAh
                mov     dword ptr [ebp-10h], 0
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49951D
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49951D:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49953E
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49953B
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49953B:                             
                mov     [ebp-38h], ecx

loc_49953E:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4995AA(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0D7h
                mov     dword ptr [ebp-2Ch], 19h
                mov     dword ptr [ebp-28h], 0E0h
                mov     dword ptr [ebp-24h], 71h
                mov     dword ptr [ebp-20h], 76h
                mov     dword ptr [ebp-1Ch], 0B4h
                mov     dword ptr [ebp-18h], 78h
                mov     dword ptr [ebp-14h], 0CAh
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_499625
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_499625:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_499646
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_499643
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_499643:                             
                mov     [ebp-38h], ecx

loc_499646:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4996B2(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 8Ch
                mov     dword ptr [ebp-2Ch], 0A4h
                mov     dword ptr [ebp-28h], 0E3h
                mov     dword ptr [ebp-24h], 0C5h
                mov     dword ptr [ebp-20h], 0E6h
                mov     dword ptr [ebp-1Ch], 8Fh
                mov     dword ptr [ebp-18h], 0EBh
                mov     dword ptr [ebp-14h], 0D9h
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49972D
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49972D:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49974E
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49974B
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49974B:                             
                mov     [ebp-38h], ecx

loc_49974E:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4997BA(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 7
                mov     dword ptr [ebp-2Ch], 0DBh
                mov     dword ptr [ebp-28h], 5Eh
                mov     dword ptr [ebp-24h], 2Eh
                mov     dword ptr [ebp-20h], 0AAh
                mov     dword ptr [ebp-1Ch], 0B4h
                mov     dword ptr [ebp-18h], 0
                mov     dword ptr [ebp-14h], 98h
                mov     dword ptr [ebp-10h], 4
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 4
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_499835
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_499835:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_499856
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_499853
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_499853:                             
                mov     [ebp-38h], ecx

loc_499856:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4998C2(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E0h
                mov     dword ptr [ebp-2Ch], 0C3h
                mov     dword ptr [ebp-28h], 0A1h
                mov     dword ptr [ebp-24h], 1Dh
                mov     dword ptr [ebp-20h], 3Dh
                mov     dword ptr [ebp-1Ch], 77h
                mov     dword ptr [ebp-18h], 0F0h
                mov     dword ptr [ebp-14h], 0CFh
                mov     dword ptr [ebp-10h], 11h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 11h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49993D
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49993D:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49995E
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49995B
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49995B:                             
                mov     [ebp-38h], ecx

loc_49995E:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_4999CA(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 6
                mov     dword ptr [ebp-2Ch], 12h
                mov     dword ptr [ebp-28h], 0F6h
                mov     dword ptr [ebp-24h], 5Bh
                mov     dword ptr [ebp-20h], 13h
                mov     dword ptr [ebp-1Ch], 2Eh
                mov     dword ptr [ebp-18h], 2Dh
                mov     dword ptr [ebp-14h], 56h
                mov     dword ptr [ebp-10h], 13h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 13h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_499A45
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_499A45:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_499A66
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_499A63
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_499A63:                             
                mov     [ebp-38h], ecx

loc_499A66:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_499AD2(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 17h
                mov     dword ptr [ebp-2Ch], 0CFh
                mov     dword ptr [ebp-28h], 3
                mov     dword ptr [ebp-24h], 0DEh
                mov     dword ptr [ebp-20h], 82h
                mov     dword ptr [ebp-1Ch], 68h
                mov     dword ptr [ebp-18h], 29h
                mov     dword ptr [ebp-14h], 5Fh
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_499B4D
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_499B4D:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_499B6E
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_499B6B
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_499B6B:                             
                mov     [ebp-38h], ecx

loc_499B6E:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_499BDA(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0B8h
                mov     dword ptr [ebp-2Ch], 40h
                mov     dword ptr [ebp-28h], 69h
                mov     dword ptr [ebp-24h], 21h
                mov     dword ptr [ebp-20h], 0F7h
                mov     dword ptr [ebp-1Ch], 67h
                mov     dword ptr [ebp-18h], 0EDh
                mov     dword ptr [ebp-14h], 0AAh
                mov     dword ptr [ebp-10h], 0
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_499C52
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_499C52:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_499C73
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_499C70
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_499C70:                             
                mov     [ebp-38h], ecx

loc_499C73:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_499CDF(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 92h
                mov     dword ptr [ebp-2Ch], 0BCh
                mov     dword ptr [ebp-28h], 3Ch
                mov     dword ptr [ebp-24h], 0F6h
                mov     dword ptr [ebp-20h], 0CDh
                mov     dword ptr [ebp-1Ch], 28h
                mov     dword ptr [ebp-18h], 68h
                mov     dword ptr [ebp-14h], 84h
                mov     dword ptr [ebp-10h], 0Eh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Eh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_499D5A
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_499D5A:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_499D7B
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_499D78
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_499D78:                             
                mov     [ebp-38h], ecx

loc_499D7B:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_499DE7(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0DEh
                mov     dword ptr [ebp-2Ch], 43h
                mov     dword ptr [ebp-28h], 2Fh
                mov     dword ptr [ebp-24h], 31h
                mov     dword ptr [ebp-20h], 54h
                mov     dword ptr [ebp-1Ch], 71h
                mov     dword ptr [ebp-18h], 0Ah
                mov     dword ptr [ebp-14h], 0A8h
                mov     dword ptr [ebp-10h], 10h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 10h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_499E62
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_499E62:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_499E83
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_499E80
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_499E80:                             
                mov     [ebp-38h], ecx

loc_499E83:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_499EEF(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 5Dh
                mov     dword ptr [ebp-2Ch], 5Eh
                mov     dword ptr [ebp-28h], 8Eh
                mov     dword ptr [ebp-24h], 2Ch
                mov     dword ptr [ebp-20h], 40h
                mov     dword ptr [ebp-1Ch], 86h
                mov     dword ptr [ebp-18h], 0D1h
                mov     dword ptr [ebp-14h], 9Bh
                mov     dword ptr [ebp-10h], 8
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 8
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_499F6A
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_499F6A:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_499F8B
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_499F88
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_499F88:                             
                mov     [ebp-38h], ecx

loc_499F8B:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_499FF7(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 3Ah
                mov     dword ptr [ebp-2Ch], 8Eh
                mov     dword ptr [ebp-28h], 5Bh
                mov     dword ptr [ebp-24h], 87h
                mov     dword ptr [ebp-20h], 0Ah
                mov     dword ptr [ebp-1Ch], 6Ch
                mov     dword ptr [ebp-18h], 6Ah
                mov     dword ptr [ebp-14h], 4Ch
                mov     dword ptr [ebp-10h], 8
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 8
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49A072
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49A072:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49A093
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49A090
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49A090:                             
                mov     [ebp-38h], ecx

loc_49A093:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49A0FF(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 13h
                mov     dword ptr [ebp-2Ch], 0C4h
                mov     dword ptr [ebp-28h], 0FAh
                mov     dword ptr [ebp-24h], 0E2h
                mov     dword ptr [ebp-20h], 7
                mov     dword ptr [ebp-1Ch], 69h
                mov     dword ptr [ebp-18h], 2Dh
                mov     dword ptr [ebp-14h], 0FAh
                mov     dword ptr [ebp-10h], 4
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 4
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49A17A
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49A17A:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49A19B
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49A198
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49A198:                             
                mov     [ebp-38h], ecx

loc_49A19B:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49A207(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0F3h
                mov     dword ptr [ebp-2Ch], 84h
                mov     dword ptr [ebp-28h], 71h
                mov     dword ptr [ebp-24h], 3
                mov     dword ptr [ebp-20h], 0CCh
                mov     dword ptr [ebp-1Ch], 34h
                mov     dword ptr [ebp-18h], 32h
                mov     dword ptr [ebp-14h], 6Bh
                mov     dword ptr [ebp-10h], 13h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 13h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49A282
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49A282:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49A2A3
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49A2A0
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49A2A0:                             
                mov     [ebp-38h], ecx

loc_49A2A3:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49A30F(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 37h
                mov     dword ptr [ebp-2Ch], 0EBh
                mov     dword ptr [ebp-28h], 46h
                mov     dword ptr [ebp-24h], 0ADh
                mov     dword ptr [ebp-20h], 0B3h
                mov     dword ptr [ebp-1Ch], 39h
                mov     dword ptr [ebp-18h], 4Ah
                mov     dword ptr [ebp-14h], 9Dh
                mov     dword ptr [ebp-10h], 14h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 14h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49A38A
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49A38A:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49A3AB
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49A3A8
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49A3A8:                             
                mov     [ebp-38h], ecx

loc_49A3AB:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49A417(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0E0h
                mov     dword ptr [ebp-2Ch], 72h
                mov     dword ptr [ebp-28h], 74h
                mov     dword ptr [ebp-24h], 4Eh
                mov     dword ptr [ebp-20h], 48h
                mov     dword ptr [ebp-1Ch], 0D8h
                mov     dword ptr [ebp-18h], 4Eh
                mov     dword ptr [ebp-14h], 57h
                mov     dword ptr [ebp-10h], 7
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 7
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49A492
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49A492:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49A4B3
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49A4B0
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49A4B0:                             
                mov     [ebp-38h], ecx

loc_49A4B3:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49A51F(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 8Bh
                mov     dword ptr [ebp-2Ch], 0D9h
                mov     dword ptr [ebp-28h], 0E7h
                mov     dword ptr [ebp-24h], 4
                mov     dword ptr [ebp-20h], 9Bh
                mov     dword ptr [ebp-1Ch], 58h
                mov     dword ptr [ebp-18h], 5Bh
                mov     dword ptr [ebp-14h], 0E6h
                mov     dword ptr [ebp-10h], 13h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 13h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49A59A
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49A59A:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49A5BB
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49A5B8
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49A5B8:                             
                mov     [ebp-38h], ecx

loc_49A5BB:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49A627(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 8Ah
                mov     dword ptr [ebp-2Ch], 49h
                mov     dword ptr [ebp-28h], 0CDh
                mov     dword ptr [ebp-24h], 0C3h
                mov     dword ptr [ebp-20h], 0ABh
                mov     dword ptr [ebp-1Ch], 0D3h
                mov     dword ptr [ebp-18h], 5Ah
                mov     dword ptr [ebp-14h], 0D2h
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49A6A2
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49A6A2:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49A6C3
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49A6C0
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49A6C0:                             
                mov     [ebp-38h], ecx

loc_49A6C3:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49A72F(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 8
                mov     dword ptr [ebp-2Ch], 0C5h
                mov     dword ptr [ebp-28h], 0C5h
                mov     dword ptr [ebp-24h], 0FAh
                mov     dword ptr [ebp-20h], 26h
                mov     dword ptr [ebp-1Ch], 0CCh
                mov     dword ptr [ebp-18h], 13h
                mov     dword ptr [ebp-14h], 9
                mov     dword ptr [ebp-10h], 1
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 1
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49A7A9
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49A7A9:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49A7CA
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49A7C7
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49A7C7:                             
                mov     [ebp-38h], ecx

loc_49A7CA:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49A836(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 81h
                mov     dword ptr [ebp-2Ch], 0A8h
                mov     dword ptr [ebp-28h], 9Ch
                mov     dword ptr [ebp-24h], 78h
                mov     dword ptr [ebp-20h], 68h
                mov     dword ptr [ebp-1Ch], 17h
                mov     dword ptr [ebp-18h], 2Eh
                mov     dword ptr [ebp-14h], 0CEh
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49A8B1
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49A8B1:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49A8D2
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49A8CF
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49A8CF:                             
                mov     [ebp-38h], ecx

loc_49A8D2:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49A93E(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0F7h
                mov     dword ptr [ebp-2Ch], 8Dh
                mov     dword ptr [ebp-28h], 8Ah
                mov     dword ptr [ebp-24h], 0E8h
                mov     dword ptr [ebp-20h], 0F9h
                mov     dword ptr [ebp-1Ch], 2
                mov     dword ptr [ebp-18h], 0FBh
                mov     dword ptr [ebp-14h], 39h
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49A9B9
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49A9B9:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49A9DA
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49A9D7
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49A9D7:                             
                mov     [ebp-38h], ecx

loc_49A9DA:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49AA46(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 6Ah
                mov     dword ptr [ebp-2Ch], 4Bh
                mov     dword ptr [ebp-28h], 0B4h
                mov     dword ptr [ebp-24h], 90h
                mov     dword ptr [ebp-20h], 0
                mov     dword ptr [ebp-1Ch], 2Ch
                mov     dword ptr [ebp-18h], 0DBh
                mov     dword ptr [ebp-14h], 47h
                mov     dword ptr [ebp-10h], 6
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 6
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49AAC1
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49AAC1:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49AAE2
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49AADF
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49AADF:                             
                mov     [ebp-38h], ecx

loc_49AAE2:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49AB4E(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 5Fh
                mov     dword ptr [ebp-2Ch], 69h
                mov     dword ptr [ebp-28h], 9Ch
                mov     dword ptr [ebp-24h], 5Bh
                mov     dword ptr [ebp-20h], 2Ch
                mov     dword ptr [ebp-1Ch], 0C6h
                mov     dword ptr [ebp-18h], 0B7h
                mov     dword ptr [ebp-14h], 0D5h
                mov     dword ptr [ebp-10h], 0Ch
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ch
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49ABC9
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49ABC9:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49ABEA
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49ABE7
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49ABE7:                             
                mov     [ebp-38h], ecx

loc_49ABEA:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49AC56(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 39h
                mov     dword ptr [ebp-2Ch], 59h
                mov     dword ptr [ebp-28h], 45h
                mov     dword ptr [ebp-24h], 0DEh
                mov     dword ptr [ebp-20h], 4Fh
                mov     dword ptr [ebp-1Ch], 0D4h
                mov     dword ptr [ebp-18h], 94h
                mov     dword ptr [ebp-14h], 2Ch
                mov     dword ptr [ebp-10h], 14h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 14h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49ACD1
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49ACD1:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49ACF2
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49ACEF
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49ACEF:                             
                mov     [ebp-38h], ecx

loc_49ACF2:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49AD5E(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 5Dh
                mov     dword ptr [ebp-2Ch], 0E0h
                mov     dword ptr [ebp-28h], 6Fh
                mov     dword ptr [ebp-24h], 5Fh
                mov     dword ptr [ebp-20h], 49h
                mov     dword ptr [ebp-1Ch], 62h
                mov     dword ptr [ebp-18h], 2Eh
                mov     dword ptr [ebp-14h], 0B4h
                mov     dword ptr [ebp-10h], 7
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 7
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49ADD9
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49ADD9:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49ADFA
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49ADF7
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49ADF7:                             
                mov     [ebp-38h], ecx

loc_49ADFA:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49AE66(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 8Dh
                mov     dword ptr [ebp-2Ch], 0F6h
                mov     dword ptr [ebp-28h], 0A1h
                mov     dword ptr [ebp-24h], 0D1h
                mov     dword ptr [ebp-20h], 14h
                mov     dword ptr [ebp-1Ch], 0BCh
                mov     dword ptr [ebp-18h], 7Eh
                mov     dword ptr [ebp-14h], 0A7h
                mov     dword ptr [ebp-10h], 15h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 15h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49AEE1
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49AEE1:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49AF02
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49AEFF
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49AEFF:                             
                mov     [ebp-38h], ecx

loc_49AF02:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49AF6E(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0A3h
                mov     dword ptr [ebp-2Ch], 2Ch
                mov     dword ptr [ebp-28h], 88h
                mov     dword ptr [ebp-24h], 0Fh
                mov     dword ptr [ebp-20h], 0E1h
                mov     dword ptr [ebp-1Ch], 38h
                mov     dword ptr [ebp-18h], 8Fh
                mov     dword ptr [ebp-14h], 7Eh
                mov     dword ptr [ebp-10h], 6
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 6
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49AFE9
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49AFE9:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49B00A
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49B007
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49B007:                             
                mov     [ebp-38h], ecx

loc_49B00A:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49B076(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 55h
                mov     dword ptr [ebp-2Ch], 0FBh
                mov     dword ptr [ebp-28h], 85h
                mov     dword ptr [ebp-24h], 0B9h
                mov     dword ptr [ebp-20h], 8
                mov     dword ptr [ebp-1Ch], 0A1h
                mov     dword ptr [ebp-18h], 0EEh
                mov     dword ptr [ebp-14h], 56h
                mov     dword ptr [ebp-10h], 14h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 14h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49B0F1
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49B0F1:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49B112
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49B10F
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49B10F:                             
                mov     [ebp-38h], ecx

loc_49B112:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49B17E(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0D0h
                mov     dword ptr [ebp-2Ch], 6Dh
                mov     dword ptr [ebp-28h], 18h
                mov     dword ptr [ebp-24h], 0E9h
                mov     dword ptr [ebp-20h], 50h
                mov     dword ptr [ebp-1Ch], 7Fh
                mov     dword ptr [ebp-18h], 42h
                mov     dword ptr [ebp-14h], 0C5h
                mov     dword ptr [ebp-10h], 0Eh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Eh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49B1F9
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49B1F9:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49B21A
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49B217
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49B217:                             
                mov     [ebp-38h], ecx

loc_49B21A:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49B286(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 7Fh
                mov     dword ptr [ebp-2Ch], 42h
                mov     dword ptr [ebp-28h], 6Bh
                mov     dword ptr [ebp-24h], 54h
                mov     dword ptr [ebp-20h], 9Bh
                mov     dword ptr [ebp-1Ch], 74h
                mov     dword ptr [ebp-18h], 5Fh
                mov     dword ptr [ebp-14h], 84h
                mov     dword ptr [ebp-10h], 8
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 8
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49B301
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49B301:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49B322
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49B31F
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49B31F:                             
                mov     [ebp-38h], ecx

loc_49B322:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49B38E(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 2Ah
                mov     dword ptr [ebp-2Ch], 0F4h
                mov     dword ptr [ebp-28h], 0D2h
                mov     dword ptr [ebp-24h], 25h
                mov     dword ptr [ebp-20h], 0F0h
                mov     dword ptr [ebp-1Ch], 45h
                mov     dword ptr [ebp-18h], 78h
                mov     dword ptr [ebp-14h], 0C1h
                mov     dword ptr [ebp-10h], 10h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 10h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49B409
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49B409:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49B42A
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49B427
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49B427:                             
                mov     [ebp-38h], ecx

loc_49B42A:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49B496(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 16h
                mov     dword ptr [ebp-2Ch], 28h
                mov     dword ptr [ebp-28h], 21h
                mov     dword ptr [ebp-24h], 0EFh
                mov     dword ptr [ebp-20h], 5Dh
                mov     dword ptr [ebp-1Ch], 60h
                mov     dword ptr [ebp-18h], 8Dh
                mov     dword ptr [ebp-14h], 76h
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49B511
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49B511:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49B532
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49B52F
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49B52F:                             
                mov     [ebp-38h], ecx

loc_49B532:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49B59E(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0EDh
                mov     dword ptr [ebp-2Ch], 0C9h
                mov     dword ptr [ebp-28h], 5Eh
                mov     dword ptr [ebp-24h], 64h
                mov     dword ptr [ebp-20h], 5Dh
                mov     dword ptr [ebp-1Ch], 3Ch
                mov     dword ptr [ebp-18h], 0AFh
                mov     dword ptr [ebp-14h], 0B0h
                mov     dword ptr [ebp-10h], 0Dh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Dh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49B619
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49B619:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49B63A
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49B637
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49B637:                             
                mov     [ebp-38h], ecx

loc_49B63A:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49B6A6(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 1Eh
                mov     dword ptr [ebp-2Ch], 0DBh
                mov     dword ptr [ebp-28h], 8Fh
                mov     dword ptr [ebp-24h], 0C6h
                mov     dword ptr [ebp-20h], 7Ah
                mov     dword ptr [ebp-1Ch], 89h
                mov     dword ptr [ebp-18h], 0BFh
                mov     dword ptr [ebp-14h], 2Ch
                mov     dword ptr [ebp-10h], 0Dh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Dh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49B721
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49B721:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49B742
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49B73F
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49B73F:                             
                mov     [ebp-38h], ecx

loc_49B742:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49B7AE(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 52h
                mov     dword ptr [ebp-2Ch], 0B9h
                mov     dword ptr [ebp-28h], 46h
                mov     dword ptr [ebp-24h], 24h
                mov     dword ptr [ebp-20h], 89h
                mov     dword ptr [ebp-1Ch], 0B4h
                mov     dword ptr [ebp-18h], 23h
                mov     dword ptr [ebp-14h], 0C9h
                mov     dword ptr [ebp-10h], 12h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 12h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49B829
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49B829:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49B84A
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49B847
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49B847:                             
                mov     [ebp-38h], ecx

loc_49B84A:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49B8B6(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 75h
                mov     dword ptr [ebp-2Ch], 13h
                mov     dword ptr [ebp-28h], 0D3h
                mov     dword ptr [ebp-24h], 0DBh
                mov     dword ptr [ebp-20h], 57h
                mov     dword ptr [ebp-1Ch], 13h
                mov     dword ptr [ebp-18h], 0E8h
                mov     dword ptr [ebp-14h], 8Ah
                mov     dword ptr [ebp-10h], 0Ch
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ch
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49B931
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49B931:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49B952
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49B94F
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49B94F:                             
                mov     [ebp-38h], ecx

loc_49B952:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49B9BE(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 38h
                mov     dword ptr [ebp-2Ch], 0D9h
                mov     dword ptr [ebp-28h], 0C0h
                mov     dword ptr [ebp-24h], 1Fh
                mov     dword ptr [ebp-20h], 26h
                mov     dword ptr [ebp-1Ch], 78h
                mov     dword ptr [ebp-18h], 0F7h
                mov     dword ptr [ebp-14h], 0D2h
                mov     dword ptr [ebp-10h], 14h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 14h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49BA39
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49BA39:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49BA5A
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49BA57
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49BA57:                             
                mov     [ebp-38h], ecx

loc_49BA5A:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49BAC6(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0BFh
                mov     dword ptr [ebp-2Ch], 6Dh
                mov     dword ptr [ebp-28h], 30h
                mov     dword ptr [ebp-24h], 0B2h
                mov     dword ptr [ebp-20h], 0DEh
                mov     dword ptr [ebp-1Ch], 0E0h
                mov     dword ptr [ebp-18h], 0
                mov     dword ptr [ebp-14h], 0EFh
                mov     dword ptr [ebp-10h], 11h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 11h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49BB41
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49BB41:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49BB62
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49BB5F
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49BB5F:                             
                mov     [ebp-38h], ecx

loc_49BB62:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49BBCE(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0ECh
                mov     dword ptr [ebp-2Ch], 0EEh
                mov     dword ptr [ebp-28h], 0F9h
                mov     dword ptr [ebp-24h], 94h
                mov     dword ptr [ebp-20h], 75h
                mov     dword ptr [ebp-1Ch], 70h
                mov     dword ptr [ebp-18h], 16h
                mov     dword ptr [ebp-14h], 85h
                mov     dword ptr [ebp-10h], 15h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 15h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49BC49
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49BC49:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49BC6A
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49BC67
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49BC67:                             
                mov     [ebp-38h], ecx

loc_49BC6A:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49BCD6(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 89h
                mov     dword ptr [ebp-2Ch], 0AEh
                mov     dword ptr [ebp-28h], 9
                mov     dword ptr [ebp-24h], 44h
                mov     dword ptr [ebp-20h], 36h
                mov     dword ptr [ebp-1Ch], 0D9h
                mov     dword ptr [ebp-18h], 0A7h
                mov     dword ptr [ebp-14h], 0B1h
                mov     dword ptr [ebp-10h], 14h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 14h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49BD51
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49BD51:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49BD72
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49BD6F
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49BD6F:                             
                mov     [ebp-38h], ecx

loc_49BD72:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49BDDE(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 1Eh
                mov     dword ptr [ebp-2Ch], 0C7h
                mov     dword ptr [ebp-28h], 50h
                mov     dword ptr [ebp-24h], 18h
                mov     dword ptr [ebp-20h], 89h
                mov     dword ptr [ebp-1Ch], 0EDh
                mov     dword ptr [ebp-18h], 0DDh
                mov     dword ptr [ebp-14h], 14h
                mov     dword ptr [ebp-10h], 0Dh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Dh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49BE59
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49BE59:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49BE7A
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49BE77
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49BE77:                             
                mov     [ebp-38h], ecx

loc_49BE7A:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49BEE6(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0D9h
                mov     dword ptr [ebp-2Ch], 45h
                mov     dword ptr [ebp-28h], 0C5h
                mov     dword ptr [ebp-24h], 0CFh
                mov     dword ptr [ebp-20h], 0C9h
                mov     dword ptr [ebp-1Ch], 8Dh
                mov     dword ptr [ebp-18h], 0E3h
                mov     dword ptr [ebp-14h], 0DCh
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49BF61
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49BF61:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49BF82
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49BF7F
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49BF7F:                             
                mov     [ebp-38h], ecx

loc_49BF82:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49BFEE(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 75h
                mov     dword ptr [ebp-2Ch], 70h
                mov     dword ptr [ebp-28h], 70h
                mov     dword ptr [ebp-24h], 49h
                mov     dword ptr [ebp-20h], 7
                mov     dword ptr [ebp-1Ch], 33h
                mov     dword ptr [ebp-18h], 6Eh
                mov     dword ptr [ebp-14h], 3Eh
                mov     dword ptr [ebp-10h], 0Dh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Dh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49C069
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49C069:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49C08A
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49C087
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49C087:                             
                mov     [ebp-38h], ecx

loc_49C08A:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49C0F6(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 2Ch
                mov     dword ptr [ebp-2Ch], 34h
                mov     dword ptr [ebp-28h], 0E6h
                mov     dword ptr [ebp-24h], 96h
                mov     dword ptr [ebp-20h], 0D8h
                mov     dword ptr [ebp-1Ch], 7Bh
                mov     dword ptr [ebp-18h], 0EBh
                mov     dword ptr [ebp-14h], 3Fh
                mov     dword ptr [ebp-10h], 0
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49C16E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49C16E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49C18F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49C18C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49C18C:                             
                mov     [ebp-38h], ecx

loc_49C18F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49C1FB(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 36h
                mov     dword ptr [ebp-2Ch], 0DEh
                mov     dword ptr [ebp-28h], 76h
                mov     dword ptr [ebp-24h], 6Ah
                mov     dword ptr [ebp-20h], 97h
                mov     dword ptr [ebp-1Ch], 87h
                mov     dword ptr [ebp-18h], 0CDh
                mov     dword ptr [ebp-14h], 4
                mov     dword ptr [ebp-10h], 6
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 6
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49C276
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49C276:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49C297
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49C294
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49C294:                             
                mov     [ebp-38h], ecx

loc_49C297:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49C303(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0A3h
                mov     dword ptr [ebp-2Ch], 0E0h
                mov     dword ptr [ebp-28h], 7Ah
                mov     dword ptr [ebp-24h], 0EEh
                mov     dword ptr [ebp-20h], 37h
                mov     dword ptr [ebp-1Ch], 5
                mov     dword ptr [ebp-18h], 12h
                mov     dword ptr [ebp-14h], 44h
                mov     dword ptr [ebp-10h], 7
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 7
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49C37E
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49C37E:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49C39F
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49C39C
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49C39C:                             
                mov     [ebp-38h], ecx

loc_49C39F:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49C40B(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 2Bh
                mov     dword ptr [ebp-2Ch], 0BEh
                mov     dword ptr [ebp-28h], 0E2h
                mov     dword ptr [ebp-24h], 9
                mov     dword ptr [ebp-20h], 51h
                mov     dword ptr [ebp-1Ch], 0E7h
                mov     dword ptr [ebp-18h], 0B4h
                mov     dword ptr [ebp-14h], 0C9h
                mov     dword ptr [ebp-10h], 1
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 1
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49C485
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49C485:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49C4A6
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49C4A3
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49C4A3:                             
                mov     [ebp-38h], ecx

loc_49C4A6:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49C512(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 89h
                mov     dword ptr [ebp-2Ch], 23h
                mov     dword ptr [ebp-28h], 46h
                mov     dword ptr [ebp-24h], 92h
                mov     dword ptr [ebp-20h], 0B6h
                mov     dword ptr [ebp-1Ch], 0E8h
                mov     dword ptr [ebp-18h], 0BDh
                mov     dword ptr [ebp-14h], 2Ch
                mov     dword ptr [ebp-10h], 0Dh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Dh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49C58D
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49C58D:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49C5AE
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49C5AB
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49C5AB:                             
                mov     [ebp-38h], ecx

loc_49C5AE:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49C61A(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0Ch
                mov     dword ptr [ebp-2Ch], 72h
                mov     dword ptr [ebp-28h], 13h
                mov     dword ptr [ebp-24h], 3Dh
                mov     dword ptr [ebp-20h], 67h
                mov     dword ptr [ebp-1Ch], 48h
                mov     dword ptr [ebp-18h], 0AFh
                mov     dword ptr [ebp-14h], 0B3h
                mov     dword ptr [ebp-10h], 12h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 12h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49C695
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49C695:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49C6B6
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49C6B3
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49C6B3:                             
                mov     [ebp-38h], ecx

loc_49C6B6:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49C722(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 94h
                mov     dword ptr [ebp-2Ch], 20h
                mov     dword ptr [ebp-28h], 5Ch
                mov     dword ptr [ebp-24h], 0D6h
                mov     dword ptr [ebp-20h], 20h
                mov     dword ptr [ebp-1Ch], 89h
                mov     dword ptr [ebp-18h], 0Fh
                mov     dword ptr [ebp-14h], 79h
                mov     dword ptr [ebp-10h], 10h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 10h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49C79D
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49C79D:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49C7BE
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49C7BB
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49C7BB:                             
                mov     [ebp-38h], ecx

loc_49C7BE:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49C82A(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0D8h
                mov     dword ptr [ebp-2Ch], 0FAh
                mov     dword ptr [ebp-28h], 0A9h
                mov     dword ptr [ebp-24h], 1Fh
                mov     dword ptr [ebp-20h], 0F5h
                mov     dword ptr [ebp-1Ch], 4Dh
                mov     dword ptr [ebp-18h], 6Eh
                mov     dword ptr [ebp-14h], 9Fh
                mov     dword ptr [ebp-10h], 8
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 8
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49C8A5
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49C8A5:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49C8C6
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49C8C3
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49C8C3:                             
                mov     [ebp-38h], ecx

loc_49C8C6:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49C932(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0B7h
                mov     dword ptr [ebp-2Ch], 0Ch
                mov     dword ptr [ebp-28h], 0DDh
                mov     dword ptr [ebp-24h], 0E1h
                mov     dword ptr [ebp-20h], 0C6h
                mov     dword ptr [ebp-1Ch], 0Ch
                mov     dword ptr [ebp-18h], 7Dh
                mov     dword ptr [ebp-14h], 43h
                mov     dword ptr [ebp-10h], 0Eh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Eh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49C9AD
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49C9AD:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49C9CE
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49C9CB
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49C9CB:                             
                mov     [ebp-38h], ecx

loc_49C9CE:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49CA3A(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 4
                mov     dword ptr [ebp-2Ch], 4Ch
                mov     dword ptr [ebp-28h], 35h
                mov     dword ptr [ebp-24h], 6Bh
                mov     dword ptr [ebp-20h], 31h
                mov     dword ptr [ebp-1Ch], 4Dh
                mov     dword ptr [ebp-18h], 8Bh
                mov     dword ptr [ebp-14h], 0B0h
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49CAB5
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49CAB5:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49CAD6
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49CAD3
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49CAD3:                             
                mov     [ebp-38h], ecx

loc_49CAD6:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49CB42(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0CEh
                mov     dword ptr [ebp-2Ch], 78h
                mov     dword ptr [ebp-28h], 8Dh
                mov     dword ptr [ebp-24h], 0EBh
                mov     dword ptr [ebp-20h], 62h
                mov     dword ptr [ebp-1Ch], 7Ch
                mov     dword ptr [ebp-18h], 4Ah
                mov     dword ptr [ebp-14h], 0CCh
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49CBBD
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49CBBD:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49CBDE
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49CBDB
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49CBDB:                             
                mov     [ebp-38h], ecx

loc_49CBDE:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49CC4A(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 63h
                mov     dword ptr [ebp-2Ch], 9Ch
                mov     dword ptr [ebp-28h], 19h
                mov     dword ptr [ebp-24h], 85h
                mov     dword ptr [ebp-20h], 0D1h
                mov     dword ptr [ebp-1Ch], 24h
                mov     dword ptr [ebp-18h], 0A8h
                mov     dword ptr [ebp-14h], 93h
                mov     dword ptr [ebp-10h], 9
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 9
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49CCC5
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49CCC5:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49CCE6
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49CCE3
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49CCE3:                             
                mov     [ebp-38h], ecx

loc_49CCE6:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49CD52(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 5Ah
                mov     dword ptr [ebp-2Ch], 62h
                mov     dword ptr [ebp-28h], 48h
                mov     dword ptr [ebp-24h], 0CBh
                mov     dword ptr [ebp-20h], 4Fh
                mov     dword ptr [ebp-1Ch], 6Bh
                mov     dword ptr [ebp-18h], 0E0h
                mov     dword ptr [ebp-14h], 2
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49CDCD
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49CDCD:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49CDEE
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49CDEB
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49CDEB:                             
                mov     [ebp-38h], ecx

loc_49CDEE:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49CE5A(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 60h
                mov     dword ptr [ebp-2Ch], 0BAh
                mov     dword ptr [ebp-28h], 3
                mov     dword ptr [ebp-24h], 64h
                mov     dword ptr [ebp-20h], 0DDh
                mov     dword ptr [ebp-1Ch], 4Ch
                mov     dword ptr [ebp-18h], 4
                mov     dword ptr [ebp-14h], 7Bh
                mov     dword ptr [ebp-10h], 11h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 11h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49CED5
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49CED5:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49CEF6
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49CEF3
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49CEF3:                             
                mov     [ebp-38h], ecx

loc_49CEF6:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49CF62(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 67h
                mov     dword ptr [ebp-2Ch], 0E9h
                mov     dword ptr [ebp-28h], 22h
                mov     dword ptr [ebp-24h], 0F6h
                mov     dword ptr [ebp-20h], 5Bh
                mov     dword ptr [ebp-1Ch], 0E7h
                mov     dword ptr [ebp-18h], 0A2h
                mov     dword ptr [ebp-14h], 0F9h
                mov     dword ptr [ebp-10h], 12h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 12h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49CFDD
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49CFDD:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49CFFE
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49CFFB
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49CFFB:                             
                mov     [ebp-38h], ecx

loc_49CFFE:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49D06A(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 7Eh
                mov     dword ptr [ebp-2Ch], 0F7h
                mov     dword ptr [ebp-28h], 3Ch
                mov     dword ptr [ebp-24h], 4
                mov     dword ptr [ebp-20h], 35h
                mov     dword ptr [ebp-1Ch], 4Dh
                mov     dword ptr [ebp-18h], 0ADh
                mov     dword ptr [ebp-14h], 0CDh
                mov     dword ptr [ebp-10h], 11h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 11h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49D0E5
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49D0E5:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49D106
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49D103
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49D103:                             
                mov     [ebp-38h], ecx

loc_49D106:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49D172(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 6Eh
                mov     dword ptr [ebp-2Ch], 0D8h
                mov     dword ptr [ebp-28h], 0B5h
                mov     dword ptr [ebp-24h], 0A6h
                mov     dword ptr [ebp-20h], 84h
                mov     dword ptr [ebp-1Ch], 5Bh
                mov     dword ptr [ebp-18h], 0CAh
                mov     dword ptr [ebp-14h], 8Ch
                mov     dword ptr [ebp-10h], 8
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 8
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49D1ED
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49D1ED:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49D20E
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49D20B
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49D20B:                             
                mov     [ebp-38h], ecx

loc_49D20E:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49D27A(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 92h
                mov     dword ptr [ebp-2Ch], 76h
                mov     dword ptr [ebp-28h], 0D1h
                mov     dword ptr [ebp-24h], 91h
                mov     dword ptr [ebp-20h], 0FBh
                mov     dword ptr [ebp-1Ch], 1Bh
                mov     dword ptr [ebp-18h], 0DCh
                mov     dword ptr [ebp-14h], 0FBh
                mov     dword ptr [ebp-10h], 0Eh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Eh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49D2F5
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49D2F5:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49D316
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49D313
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49D313:                             
                mov     [ebp-38h], ecx

loc_49D316:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49D382(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 4Ah
                mov     dword ptr [ebp-2Ch], 95h
                mov     dword ptr [ebp-28h], 4
                mov     dword ptr [ebp-24h], 0C4h
                mov     dword ptr [ebp-20h], 0D5h
                mov     dword ptr [ebp-1Ch], 6
                mov     dword ptr [ebp-18h], 97h
                mov     dword ptr [ebp-14h], 80h
                mov     dword ptr [ebp-10h], 14h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 14h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49D3FD
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49D3FD:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49D41E
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49D41B
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49D41B:                             
                mov     [ebp-38h], ecx

loc_49D41E:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49D48A(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 8Bh
                mov     dword ptr [ebp-2Ch], 33h
                mov     dword ptr [ebp-28h], 99h
                mov     dword ptr [ebp-24h], 0D3h
                mov     dword ptr [ebp-20h], 0D1h
                mov     dword ptr [ebp-1Ch], 9Bh
                mov     dword ptr [ebp-18h], 1Ch
                mov     dword ptr [ebp-14h], 4Fh
                mov     dword ptr [ebp-10h], 14h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 14h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49D505
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49D505:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49D526
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49D523
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49D523:                             
                mov     [ebp-38h], ecx

loc_49D526:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49D592(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0ECh
                mov     dword ptr [ebp-2Ch], 0E4h
                mov     dword ptr [ebp-28h], 0D6h
                mov     dword ptr [ebp-24h], 0C3h
                mov     dword ptr [ebp-20h], 0B3h
                mov     dword ptr [ebp-1Ch], 46h
                mov     dword ptr [ebp-18h], 0BFh
                mov     dword ptr [ebp-14h], 0D9h
                mov     dword ptr [ebp-10h], 6
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 6
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49D60D
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49D60D:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49D62E
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49D62B
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49D62B:                             
                mov     [ebp-38h], ecx

loc_49D62E:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49D69A(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 5Eh
                mov     dword ptr [ebp-2Ch], 23h
                mov     dword ptr [ebp-28h], 5Ch
                mov     dword ptr [ebp-24h], 2Ch
                mov     dword ptr [ebp-20h], 0BBh
                mov     dword ptr [ebp-1Ch], 7Ch
                mov     dword ptr [ebp-18h], 9
                mov     dword ptr [ebp-14h], 58h
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49D715
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49D715:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49D736
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49D733
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49D733:                             
                mov     [ebp-38h], ecx

loc_49D736:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49D7A2(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 15h
                mov     dword ptr [ebp-2Ch], 0EFh
                mov     dword ptr [ebp-28h], 89h
                mov     dword ptr [ebp-24h], 58h
                mov     dword ptr [ebp-20h], 15h
                mov     dword ptr [ebp-1Ch], 0D3h
                mov     dword ptr [ebp-18h], 0
                mov     dword ptr [ebp-14h], 0F5h
                mov     dword ptr [ebp-10h], 3
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 3
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49D81D
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49D81D:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49D83E
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49D83B
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49D83B:                             
                mov     [ebp-38h], ecx

loc_49D83E:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49D8AA(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0D0h
                mov     dword ptr [ebp-2Ch], 1Bh
                mov     dword ptr [ebp-28h], 62h
                mov     dword ptr [ebp-24h], 31h
                mov     dword ptr [ebp-20h], 0B9h
                mov     dword ptr [ebp-1Ch], 19h
                mov     dword ptr [ebp-18h], 4Bh
                mov     dword ptr [ebp-14h], 62h
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49D925
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49D925:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49D946
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49D943
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49D943:                             
                mov     [ebp-38h], ecx

loc_49D946:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49D9B2(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 4Fh
                mov     dword ptr [ebp-2Ch], 0A7h
                mov     dword ptr [ebp-28h], 0B8h
                mov     dword ptr [ebp-24h], 45h
                mov     dword ptr [ebp-20h], 0A2h
                mov     dword ptr [ebp-1Ch], 76h
                mov     dword ptr [ebp-18h], 0F3h
                mov     dword ptr [ebp-14h], 0A6h
                mov     dword ptr [ebp-10h], 2
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 2
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49DA2D
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49DA2D:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49DA4E
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49DA4B
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49DA4B:                             
                mov     [ebp-38h], ecx

loc_49DA4E:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49DABA(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 61h
                mov     dword ptr [ebp-2Ch], 0D6h
                mov     dword ptr [ebp-28h], 0BDh
                mov     dword ptr [ebp-24h], 16h
                mov     dword ptr [ebp-20h], 15h
                mov     dword ptr [ebp-1Ch], 0E7h
                mov     dword ptr [ebp-18h], 0B1h
                mov     dword ptr [ebp-14h], 75h
                mov     dword ptr [ebp-10h], 5
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 5
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49DB35
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49DB35:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49DB56
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49DB53
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49DB53:                             
                mov     [ebp-38h], ecx

loc_49DB56:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49DBC2(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0B1h
                mov     dword ptr [ebp-2Ch], 0DFh
                mov     dword ptr [ebp-28h], 21h
                mov     dword ptr [ebp-24h], 41h
                mov     dword ptr [ebp-20h], 40h
                mov     dword ptr [ebp-1Ch], 7Ch
                mov     dword ptr [ebp-18h], 0FAh
                mov     dword ptr [ebp-14h], 4Dh
                mov     dword ptr [ebp-10h], 0Ah
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Ah
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49DC3D
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49DC3D:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49DC5E
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49DC5B
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49DC5B:                             
                mov     [ebp-38h], ecx

loc_49DC5E:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49DCCA(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 90h
                mov     dword ptr [ebp-2Ch], 68h
                mov     dword ptr [ebp-28h], 53h
                mov     dword ptr [ebp-24h], 0E7h
                mov     dword ptr [ebp-20h], 0EEh
                mov     dword ptr [ebp-1Ch], 57h
                mov     dword ptr [ebp-18h], 8
                mov     dword ptr [ebp-14h], 2Fh
                mov     dword ptr [ebp-10h], 6
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 6
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49DD45
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49DD45:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49DD66
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49DD63
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49DD63:                             
                mov     [ebp-38h], ecx

loc_49DD66:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49DDD2(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0C9h
                mov     dword ptr [ebp-2Ch], 6Ah
                mov     dword ptr [ebp-28h], 9Ch
                mov     dword ptr [ebp-24h], 0B7h
                mov     dword ptr [ebp-20h], 0A8h
                mov     dword ptr [ebp-1Ch], 0D6h
                mov     dword ptr [ebp-18h], 79h
                mov     dword ptr [ebp-14h], 20h
                mov     dword ptr [ebp-10h], 0
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49DE4A
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49DE4A:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49DE6B
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49DE68
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49DE68:                             
                mov     [ebp-38h], ecx

loc_49DE6B:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49DED7(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 1Fh
                mov     dword ptr [ebp-2Ch], 7Dh
                mov     dword ptr [ebp-28h], 0B8h
                mov     dword ptr [ebp-24h], 60h
                mov     dword ptr [ebp-20h], 0B5h
                mov     dword ptr [ebp-1Ch], 11h
                mov     dword ptr [ebp-18h], 0DAh
                mov     dword ptr [ebp-14h], 9
                mov     dword ptr [ebp-10h], 6
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 6
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49DF52
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49DF52:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49DF73
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49DF70
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49DF70:                             
                mov     [ebp-38h], ecx

loc_49DF73:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49DFDF(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 74h
                mov     dword ptr [ebp-2Ch], 2
                mov     dword ptr [ebp-28h], 75h
                mov     dword ptr [ebp-24h], 90h
                mov     dword ptr [ebp-20h], 79h
                mov     dword ptr [ebp-1Ch], 0DCh
                mov     dword ptr [ebp-18h], 50h
                mov     dword ptr [ebp-14h], 6
                mov     dword ptr [ebp-10h], 0Fh
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 0Fh
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49E05A
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49E05A:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49E07B
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49E078
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49E078:                             
                mov     [ebp-38h], ecx

loc_49E07B:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49E0E7(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0Ah
                mov     dword ptr [ebp-2Ch], 0FBh
                mov     dword ptr [ebp-28h], 6Fh
                mov     dword ptr [ebp-24h], 3
                mov     dword ptr [ebp-20h], 67h
                mov     dword ptr [ebp-1Ch], 6Ah
                mov     dword ptr [ebp-18h], 36h
                mov     dword ptr [ebp-14h], 8Eh
                mov     dword ptr [ebp-10h], 7
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 7
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49E162
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49E162:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49E183
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49E180
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49E180:                             
                mov     [ebp-38h], ecx

loc_49E183:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49E1EF(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 0DDh
                mov     dword ptr [ebp-2Ch], 33h
                mov     dword ptr [ebp-28h], 5
                mov     dword ptr [ebp-24h], 79h
                mov     dword ptr [ebp-20h], 66h
                mov     dword ptr [ebp-1Ch], 4Bh
                mov     dword ptr [ebp-18h], 0B1h
                mov     dword ptr [ebp-14h], 3Eh
                mov     dword ptr [ebp-10h], 11h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 11h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49E26A
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49E26A:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49E28B
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49E288
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49E288:                             
                mov     [ebp-38h], ecx

loc_49E28B:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                /*call    [ebp-8]*/ call AsmDispatcher
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}






__declspec(naked) void sub_49E2F7(void) {  __asm  {               
                                        





















                push    ebp
                mov     ebp, esp
                sub     esp, 40h
                mov     dword ptr [ebp-30h], 5Eh
                mov     dword ptr [ebp-2Ch], 5Fh
                mov     dword ptr [ebp-28h], 8Fh
                mov     dword ptr [ebp-24h], 0E7h
                mov     dword ptr [ebp-20h], 0E0h
                mov     dword ptr [ebp-1Ch], 97h
                mov     dword ptr [ebp-18h], 0E5h
                mov     dword ptr [ebp-14h], 0CFh
                mov     dword ptr [ebp-10h], 12h
                mov     dword ptr [ebp-40h], 7
                mov     eax, [ebp+8]
                shr     eax, 12h
                and     eax, 7
                mov     ecx, [ebp+eax*4-30h]
                mov     [ebp-3Ch], ecx
                mov     eax, [ebp-3Ch]
                cdq
                and     edx, 0Fh
                add     eax, edx
                sar     eax, 4
                mov     [ebp-34h], eax
                mov     edx, [ebp-3Ch]
                and     edx, 8000000Fh
                jns     short loc_49E372
                dec     edx
                or      edx, 0FFFFFFF0h
                inc     edx

loc_49E372:                             
                mov     [ebp-38h], edx
                mov     eax, [ebp-34h]
                cmp     eax, [ebp-38h]
                jnz     short loc_49E393
                mov     ecx, [ebp-38h]
                add     ecx, 1
                and     ecx, 8000000Fh
                jns     short loc_49E390
                dec     ecx
                or      ecx, 0FFFFFFF0h
                inc     ecx

loc_49E390:                             
                mov     [ebp-38h], ecx

loc_49E393:                             
                mov     edx, [ebp-3Ch]
                mov     eax, [ebp-34h]
                mov     ecx, dword ptr dword_4DF3C0[edx*4]
                xor     ecx, dword ptr dword_4D92CC[eax*4]
                mov     edx, [ebp-38h]
                xor     ecx, dword ptr dword_4D92CC[edx*4]
                mov     [ebp-8], ecx
                mov     eax, [ebp+0Ch]
                push    eax
                mov     ecx, [ebp-3Ch]
                movsx   edx, dword ptr byte_4DDBA0[ecx]
                call    dword ptr Block3Func1Data1[edx*4]
                add     esp, 4
                mov     [ebp-4], eax
                mov     eax, [ebp+10h]
                push    eax
                mov     ecx, [ebp-4]
                push    ecx
                add     esp, 8
                push    eax
                mov     edx, [ebp-3Ch]
                movsx   eax, dword ptr byte_4DDBA0[edx]
                call    dword ptr off_4DDCDC[eax*4]
                add     esp, 4
                mov     [ebp-0Ch], eax
                mov     eax, [ebp-0Ch]
                and     eax, 1
                mov     esp, ebp
                pop     ebp
                retn
}}

// block 6 sixteen functions array

__declspec(naked) void SixBlock0(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 push    7
                 push    16h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 0D972B853h
                 mov     [ebp+8], ecx
                 push    13h
                 push    8
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFFBh
                 push    0Eh
                 push    7
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 4B487412h
                 mov     [ebp+8], ecx
                 push    0Ch
                 push    9
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Dh
                 push    2
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    5
                 push    15h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 6E4957A8h
                 mov     [ebp+8], edx
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SixBlock1(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 mov     eax, [ebp+8]
                 xor     eax, 40174D5Bh
                 mov     [ebp+8], eax
                 push    0FFFFFFF4h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0
                 push    1Eh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    14h
                 push    1
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 0A52B3D68h
                 mov     [ebp+8], ecx
                 push    0FFFFFFF9h
                 push    14h
                 push    0Bh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFE6h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 8B9D36E9h
                 mov     [ebp+8], ecx
                 push    0FFFFFFF3h
                 push    2
                 push    14h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Ah
                 push    0Ah
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFEAh
                 push    0
                 push    1Ch
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    1Ah
                 push    5
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 0FB1E52AFh
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SixBlock2(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 push    0FFFFFFF1h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 0F185A47Ch
                 mov     [ebp+8], ecx
                 push    0FFFFFFFEh
                 push    0Fh
                 push    9
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFF1h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    4
                 push    17h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    9
                 push    2
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFF7h
                 push    1
                 push    1Eh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Eh
                 push    8
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0
                 push    11h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFF5h
                 push    0
                 push    18h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 81A5E699h
                 mov     [ebp+8], ecx
                 push    0FFFFFFE6h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0FFFFFFFAh
                 push    9
                 push    0Eh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFEFh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    17h
                 push    4
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 0FBBD38E7h
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SixBlock3(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 push    0FFFFFFFAh
                 push    3
                 push    0Dh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFEEh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0Fh
                 push    5
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFFBh
                 push    7
                 push    8
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    16h
                 push    2
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFF9h
                 push    0Ah
                 push    0Bh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    7
                 push    8
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Bh
                 push    7
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFFBh
                 push    7
                 push    11h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    6
                 push    0Ah
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Ah
                 push    3
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 5C2ACD4Dh
                 mov     [ebp+8], edx
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SixBlock4(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 push    0FFFFFFFBh
                 push    7
                 push    17h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFEDh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0Ch
                 push    0Fh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Eh
                 push    1
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 89C7C9A6h
                 mov     [ebp+8], ecx
                 push    9
                 push    8
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    3
                 push    0Fh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    15h
                 push    4
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFEBh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    12h
                 push    5
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    6
                 push    12h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    14h
                 push    1
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0
                 push    1Fh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Ah
                 push    7
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFFDh
                 push    0Dh
                 push    8
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFE5h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    13h
                 push    5
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    7
                 push    0Fh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFE9h
                 push    0
                 push    1Ch
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFFCh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 47D8FFBDh
                 mov     [ebp+8], edx
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SixBlock5(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 push    0
                 push    1Fh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFFAh
                 push    3
                 push    16h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Ch
                 push    1
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFFCh
                 push    0Bh
                 push    6
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Bh
                 push    4
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 7C3547F7h
                 mov     [ebp+8], edx
                 push    0FFFFFFEBh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    14h
                 push    4
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFF7h
                 push    0
                 push    0Dh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Bh
                 push    1
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFE5h
                 push    0
                 push    1Ch
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFFBh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0FFFFFFFBh
                 push    1
                 push    1Eh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Eh
                 push    1
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 5BFB6B28h
                 mov     [ebp+8], edx
                 push    0FFFFFFF2h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 8B465658h
                 mov     [ebp+8], ecx
                 push    0FFFFFFEDh
                 push    0
                 push    1Fh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    10h
                 push    2
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    17h
                 push    8
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 24A4A3B5h
                 mov     [ebp+8], edx
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SixBlock6(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 push    0Dh
                 push    0Bh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFF1h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 251AFCFEh
                 mov     [ebp+8], edx
                 push    0FFFFFFFDh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0FFFFFFF5h
                 push    4
                 push    19h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFF2h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0FFFFFFFCh
                 push    8
                 push    13h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 6BA330BFh
                 mov     [ebp+8], ecx
                 push    0Ah
                 push    12h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Ch
                 push    8
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 5ED8936Ch
                 mov     [ebp+8], ecx
                 push    0FFFFFFEFh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 34473F96h
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SixBlock7(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 push    0
                 push    7
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFE1h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0FFFFFFFBh
                 push    0Ah
                 push    0Fh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFFCh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 3A22CD09h
                 mov     [ebp+8], ecx
                 push    13h
                 push    4
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 0F6547803h
                 mov     [ebp+8], eax
                 push    0FFFFFFF3h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 0ABA4CE9Ah
                 mov     [ebp+8], edx
                 push    11h
                 push    9
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    11h
                 push    5
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFF0h
                 push    0
                 push    1Fh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Fh
                 push    2
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 49253F31h
                 mov     [ebp+8], ecx
                 push    0
                 push    1Eh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 3773D297h
                 mov     [ebp+8], eax
                 push    3
                 push    11h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 70648B0Dh
                 mov     [ebp+8], edx
                 push    0Dh
                 push    6
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFF5h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    10h
                 push    0Bh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 5A07B2A1h
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SixBlock8(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 push    0FFFFFFF5h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    5
                 push    19h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    10h
                 push    5
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 0A8DB534Eh
                 mov     [ebp+8], eax
                 push    0FFFFFFEBh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0FFFFFFF4h
                 push    6
                 push    0Fh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFE3h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    5
                 push    5
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 58887477h
                 mov     [ebp+8], edx
                 push    0FFFFFFF9h
                 push    9
                 push    10h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 949D26F0h
                 mov     [ebp+8], ecx
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SixBlock9(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 push    0Eh
                 push    2
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 71B455A8h
                 mov     [ebp+8], ecx
                 push    2
                 push    1Dh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Bh
                 push    8
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFE7h
                 push    1
                 push    1Eh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFF6h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    14h
                 push    1
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 247C11F6h
                 mov     [ebp+8], ecx
                 push    0FFFFFFEBh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 0F097965Dh
                 mov     [ebp+8], eax
                 push    0Eh
                 push    2
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Eh
                 push    0Fh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFFEh
                 push    17h
                 push    3
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFFAh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 0EECED199h
                 mov     [ebp+8], edx
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SixBlockA(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 push    0FFFFFFF7h
                 push    8
                 push    17h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    9
                 push    1
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 71912DB8h
                 mov     [ebp+8], edx
                 push    8
                 push    15h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 4A7BFE98h
                 mov     [ebp+8], ecx
                 push    3
                 push    1Bh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFFEh
                 push    7
                 push    5
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFF1h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0FFFFFFF9h
                 push    4
                 push    1Ah
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    16h
                 push    8
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 0DCA20F48h
                 mov     [ebp+8], ecx
                 push    10h
                 push    7
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Ch
                 push    7
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFFEh
                 push    8
                 push    4
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFFFh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 0FDEB38C7h
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SixBlockB(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 push    0FFFFFFE7h
                 push    3
                 push    1Bh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFF2h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 0A59EEE9Ah
                 mov     [ebp+8], edx
                 push    0FFFFFFF8h
                 push    5
                 push    16h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    1
                 push    1Bh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Eh
                 push    8
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFF5h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    3
                 push    12h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFF7h
                 push    5
                 push    18h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    15h
                 push    2
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    1
                 push    18h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFFCh
                 push    5
                 push    0Bh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    3
                 push    4
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 16F12999h
                 mov     [ebp+8], ecx
                 push    0Ah
                 push    9
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFEEh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 3F4C93CAh
                 mov     [ebp+8], ecx
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SixBlockC(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 push    0Ch
                 push    6
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFF7h
                 push    2
                 push    0Eh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Ah
                 push    4
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 2ACA701Ah
                 mov     [ebp+8], eax
                 push    19h
                 push    2
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Eh
                 push    6
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFFEh
                 push    3
                 push    7
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0Bh
                 push    3
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 8C6C2052h
                 mov     [ebp+8], edx
                 push    0FFFFFFFEh
                 push    0Ah
                 push    8
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFFCh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0FFFFFFF8h
                 push    6
                 push    0Bh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 10AFC3E4h
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SixBlockD(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 push    0FFFFFFE5h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    7
                 push    0Eh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFE8h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0FFFFFFECh
                 push    3
                 push    1Bh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    12h
                 push    0Bh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFEAh
                 push    0
                 push    1Dh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 414B8E93h
                 mov     [ebp+8], eax
                 push    0Dh
                 push    7
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFFBh
                 push    8
                 push    10h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    6
                 push    19h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFE1h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0Ch
                 push    3
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 0B4324752h
                 mov     [ebp+8], eax
                 push    0FFFFFFFAh
                 push    1
                 push    14h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    17h
                 push    4
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0
                 push    0Fh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFECh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0Ch
                 push    0Dh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Ch
                 push    7
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 96174FB5h
                 mov     [ebp+8], ecx
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SixBlockE(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 push    15h
                 push    7
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFFDh
                 push    4
                 push    15h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    0FFFFFFF5h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    2
                 push    0Bh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFECh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0FFFFFFFEh
                 push    1
                 push    7
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    16h
                 push    8
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Eh
                 push    10h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFFBh
                 push    9
                 push    12h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 0DDF185A2h
                 mov     [ebp+8], eax
                 push    0FFFFFFFCh
                 push    13h
                 push    0Bh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    14h
                 push    5
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    11h
                 push    0Bh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    16h
                 push    7
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 8B8BAF82h
                 mov     [ebp+8], edx
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}

__declspec(naked) void SixBlockF(void)
{
	__asm {
                 push    ebp
                 mov     ebp, esp
                 push    2
                 push    1Bh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFF6h
                 push    0
                 push    12h
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, offset dword_552CA9
                 mov     [ebp+8], edx
                 push    3
                 push    18h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0Eh
                 push    6
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     edx, [ebp+8]
                 xor     edx, 1AD7F4D0h
                 mov     [ebp+8], edx
                 push    3
                 push    15h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFF5h
                 push    0
                 push    1Fh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    9
                 push    2
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    1
                 push    1Ah
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 87E29F3Ch
                 mov     [ebp+8], ecx
                 push    0FFFFFFEEh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0FFFFFFFCh
                 push    5
                 push    17h
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    1
                 push    1Dh
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFF9h
                 push    8
                 push    17h
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 push    16h
                 push    6
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    1Ah
                 push    4
                 mov     ecx, [ebp+8]
                 push    ecx
                 call    SubFunc0
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 push    0FFFFFFFBh
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc3
                 add     esp, 8
                 mov     [ebp+8], eax
                 push    0FFFFFFFCh
                 push    2
                 push    0Eh
                 mov     eax, [ebp+8]
                 push    eax
                 call    SubFunc2
                 add     esp, 10h
                 mov     [ebp+8], eax
                 mov     ecx, [ebp+8]
                 xor     ecx, 17019638h
                 mov     [ebp+8], ecx
                 push    13h
                 push    7
                 mov     edx, [ebp+8]
                 push    edx
                 call    SubFunc1
                 add     esp, 0Ch
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 xor     eax, 6760502h
                 mov     [ebp+8], eax
                 mov     eax, [ebp+8]
                 pop     ebp
                 retn
	}
}


// block 6 dynamic functions

__declspec(naked) void sub_48D4EE(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDCDC_2
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    edx
                 mov     edx, [ebp+0Ch]
                 mov     edx, 0FFFFh
                 and     eax, edx
                 push    ebx
                 push    eax
                 mov     bh, 7
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 and     eax, 800h
                 bswap   ecx
                 pop     eax
                 bswap   ecx
                 and     ah, bh
                 mov     bl, 86h
                 sub     bl, 7
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 sub     bl, 1Ah
                 sub     bl, 20h
                 not     bx
                 bswap   eax
                 not     bx
                 bswap   eax
                 and     al, bl
                 mov     eax, eax
                 test    eax, eax
                 jnz     loc_48D60C
                 pop     ebx
                 pop     edx
                 mov     eax, [ebp-4]
                 push    edx
                 mov     edx, 0FFFFh
                 and     eax, edx
                 push    ebx
                 push    eax
                 mov     bh, 7
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 and     eax, 800h
                 bswap   ecx
                 pop     eax
                 bswap   ecx
                 and     ah, bh
                 mov     bl, 98h
                 sub     bl, 5
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 sub     bl, 0Ch
                 not     bx
                 bswap   eax
                 not     bx
                 bswap   eax
                 and     al, bl
                 mov     eax, eax
                 pop     ebx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 pop     edx
                 mov     ecx, eax
                 push    ecx
                 mov     eax, [ebp-4]
                 push    edx
                 mov     edx, 0FFFFh
                 and     eax, edx
                 push    ebx
                 push    0Dh
                 pop     ebx
                 jo      short loc_48D5D1
                 jl      short loc_48D5CF

 loc_48D5CA:
                 jmp     short loc_48D5D3

 loc_48D5CF:
                 jz      short loc_48D5CA

 loc_48D5D1:
                 jmp     short loc_48D5CA


 loc_48D5D3:
                 sub     bl, 5
                 dec     bl
                 push    eax
                 dec     bl
                 dec     bl
                 and     eax, 41h
                 dec     bl
                 sub     bl, 3
                 pop     eax
                 dec     bl
                 and     al, bl
                 mov     edx, 2500h
                 dec     dh
                 sub     dh, 3
                 dec     dh
                 sub     dh, 18h
                 and     ah, dh
                 pop     ebx
                 pop     edx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 pop     ecx
                 cmp     ecx, eax
                 jnz     short loc_48D60C
                 and     eax, 0
                 jmp     short loc_48D610

 loc_48D60C:
                 and     eax, 0
                 inc     eax

 loc_48D610:
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D9370
                 xor     ecx, ds:dword_4D9374
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_48D633
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_48D633:
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDC9C
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	 }
 }


__declspec(naked) void sub_48D2A4(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDCE8
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    ebx
                 mov     ebx, 0FFFFh
                 and     eax, ebx
                 push    ecx
                 mov     ch, 2Dh
                 dec     ch
                 sub     ch, 1
                 sub     ch, 20h
                 dec     ch
                 dec     ch
                 sub     ch, 7
                 dec     ch
                 dec     ch
                 and     ah, ch
                 mov     cl, 77h
                 sub     cl, 2
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 not     cl
                 bswap   edx
                 not     cl
                 bswap   edx
                 dec     cl
                 dec     cl
                 push    eax
                 dec     cl
                 dec     cl
                 sub     cl, 12h
                 dec     cl
                 jo      short loc_48D30C
                 jl      short loc_48D30A

 loc_48D307:                             

                 jmp     short loc_48D30E

 loc_48D30A:                             
                 jz      short loc_48D307

 loc_48D30C:                             
                 jmp     short loc_48D307

 loc_48D30E:                             
                 dec     cl
                 and     eax, 40h
                 dec     cl
                 dec     cl
                 dec     cl
                 add     cl, 0Eh
                 dec     cl
                 dec     cl
                 and     eax, 800h
                 sub     cl, 1Fh
                 dec     cl
                 dec     cl
                 dec     cl
                 not     ecx
                 bswap   eax
                 not     ecx
                 bswap   eax
                 pop     eax
                 and     al, cl
                 mov     eax, eax
                 pop     ecx
                 neg     eax
                 sbb     eax, eax
                 neg     eax
                 pop     ebx
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D937C
                 xor     ecx, ds:dword_4D9380
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_48D366
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_48D366:                             
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCA8
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	 }
}


__declspec(naked) void sub_482654(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 8
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 dec     bh
                 and     eax, 800h
                 jo      short loc_482670
                 jl      short loc_48266E

 loc_48266B:                             
                                         
                 jmp     short loc_482672
 loc_48266E:                             
                 jz      short loc_48266B

 loc_482670:                             
                 jmp     short loc_48266B

 loc_482672:                             
                 mov     ebx, 4
                 and     eax, ebx
                 mov     ch, 52h
                 dec     ch
                 mov     ebx, [ebp+0Ch]
                 test    ebx, ebx
                 jo      short loc_48268B
                 jl      short loc_482689

 loc_482686:                             
                                         
                 jmp     short loc_48268D

 loc_482689:                             
                 jz      short loc_482686

 loc_48268B:                             
                 jmp     short loc_482686

 loc_48268D:                             
                 jz      short loc_482698
                 dec     edi
                 sub     ch, 3
                 and     eax, 0
                 jmp     short loc_4826B9

 loc_482698:                             
                 dec     edi
                 dec     ecx
                 sub     ch, 2
                 dec     ch
                 dec     ch
                 sub     ch, 8
                 jo      short loc_4826AD
                 jl      short loc_4826AB

 loc_4826A8:                             
                                         
                 jmp     short loc_4826AF

 loc_4826AB:                             
                 jz      short loc_4826A8

 loc_4826AD:                             
                 jmp     short loc_4826A8

 loc_4826AF:                             
                 and     eax, 0
                 dec     ecx
                 sub     ch, 2
                 inc     eax
                 dec     ch

 loc_4826B9:                             
                 mov     [ebp-8], eax
                 mov     eax, ds:dword_4D93AC
                 xor     eax, ds:dword_4D93B0
                 shl     eax, 1
                 mov     [ebp-4], eax
                 cmp     dword ptr [ebp-8], 0
                 jz      short loc_4826DB
                 mov     ecx, [ebp-4]
                 or      ecx, 1
                 mov     [ebp-4], ecx

 loc_4826DB:                             
                 mov     edx, [ebp-4]
                 push    edx
                 call    ds:off_4DDCD8
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
 }


__declspec(naked) void sub_48A696(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDD14
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    ecx
                 mov     ecx, 800h
                 mov     ecx, 0Ah
                 not     ecx
                 bswap   eax
                 not     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 dec     edx
                 inc     ecx
                 inc     ecx
                 dec     edx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 dec     edx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     cl
                 dec     edx
                 inc     ecx
                 inc     ecx
                 dec     edx
                 inc     ecx
                 inc     ecx
                 inc     cl
                 dec     edx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 dec     ecx
                 dec     edx
                 dec     edx
                 inc     ecx
                 inc     cl
                 inc     cl
                 dec     dl
                 inc     cl
                 add     ecx, 0Bh
                 inc     cl
                 inc     cl
                 inc     cl
                 inc     cl
                 inc     cl
                 add     ecx, 0Ah
                 dec     ecx
                 push    edx
                 mov     edx, 4
                 add     ecx, edx
                 inc     ecx
                 pop     edx
                 bswap   eax
                 and     eax, ecx
                 pop     ecx
                 neg     eax
                 sbb     eax, eax
                 neg     eax
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D93A8
                 xor     ecx, ds:dword_4D93AC
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_48A735
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_48A735:
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCD4
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}



__declspec(naked) void sub_48B8EB(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDCE4
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    ebx
                 mov     ebx, 0FFFFh
                 and     eax, ebx
                 push    ecx
                 mov     ch, 2Dh
                 dec     ch
                 sub     ch, 1
                 sub     ch, 20h
                 dec     ch
                 dec     ch
                 sub     ch, 7
                 dec     ch
                 dec     ch
                 and     ah, ch
                 mov     cl, 0BDh
                 sub     cl, 2
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 not     cl
                 bswap   edx
                 not     cl
                 bswap   edx
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 push    eax
                 dec     cl
                 dec     cl
                 sub     cl, 12h
                 dec     cl
                 dec     cl
                 sub     cl, 3
                 dec     cl
                 and     eax, 40h
                 dec     cl
                 dec     cl
                 dec     cl
                 add     cl, 0Eh
                 dec     cl
                 dec     cl
                 and     eax, 80h
                 sub     cl, 1Fh
                 dec     cl
                 dec     cl
                 dec     cl
                 not     ecx
                 bswap   eax
                 not     ecx
                 bswap   eax
                 pop     eax
                 inc     cl
                 inc     cl
                 inc     cl
                 and     al, cl
                 mov     eax, eax
                 pop     ecx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 pop     ebx
                 push    eax
                 mov     eax, [ebp-4]
                 mov     edx, 0C00h
                 sub     dh, 1
                 dec     dh
                 dec     dh
                 dec     dh
                 and     eax, edx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 mov     edx, eax
                 pop     eax
                 xor     ecx, ecx
                 cmp     eax, edx
                 setz    cl
                 mov     al, cl
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D9378
                 xor     ecx, ds:dword_4D937C
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_48B9DB
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_48B9DB:
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCA4
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	 }
}



__declspec(naked) void sub_48B4C8(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDD10
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    ecx
                 mov     ecx, 41h
                 not     ecx
                 bswap   eax
                 not     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 add     ecx, 0Dh
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 dec     ecx
                 inc     ecx
                 inc     cl
                 inc     cl
                 inc     cl
                 add     ecx, 0Fh
                 inc     cl
                 inc     cl
                 inc     cl
                 add     ecx, 0Ah
                 dec     ecx
                 push    edx
                 mov     edx, 4
                 add     ecx, edx
                 inc     ecx
                 pop     edx
                 bswap   eax
                 add     ecx, 3
                 and     eax, ecx
                 pop     ecx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 pop     edx
                 push    eax
                 mov     eax, [ebp-4]
                 mov     edx, 0F00h
                 sub     dh, 1
                 dec     dh
                 dec     dh
                 dec     dh
                 dec     dh
                 dec     dh
                 dec     dh
                 and     eax, edx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 mov     edx, eax
                 pop     eax
                 xor     ecx, ecx
                 jo      short loc_48B559
                 jl      short loc_48B557

 loc_48B554:                             

                 jmp     short loc_48B55B



 loc_48B557:                             
                 jz      short loc_48B554

 loc_48B559:                             
                 jmp     short loc_48B554


 loc_48B55B:                             
                 cmp     eax, edx
                 jo      short loc_48B566
                 jl      short loc_48B564

 loc_48B561:                             

                 jmp     short loc_48B568



 loc_48B564:                             
                 jz      short loc_48B561

 loc_48B566:                             
                 jmp     short loc_48B561


 loc_48B568:                             
                 jz      short loc_48B57B
                 and     eax, 0
                 jo      short loc_48B576
                 jl      short loc_48B574

 loc_48B571:                             

                 jmp     short loc_48B578


 loc_48B574:                             
                 jz      short loc_48B571

 loc_48B576:                             
                 jmp     short loc_48B571


 loc_48B578:                             
                 inc     eax
                 jmp     short loc_48B57E


 loc_48B57B:                             
                 and     eax, 0

 loc_48B57E:                             
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D93A4
                 xor     ecx, ds:dword_4D93A8
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_48B5A1
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_48B5A1:                             
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCD0
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	 }
}





__declspec(naked) void sub_47F71C(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDCF4
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    edx
                 mov     edx, 0FFFFh
                 and     eax, edx
                 push    ebx
                 push    1E00h
                 pop     ebx
                 jo      short loc_47F752
                 jl      short loc_47F750

 loc_47F74B:                             
                                         
                 jmp     short loc_47F754

 loc_47F750:                             
                 jz      short loc_47F74B

 loc_47F752:                             
                 jmp     short loc_47F74B

 loc_47F754:                             
                 sub     bh, 4
                 dec     bh
                 push    eax
                 dec     bh
                 dec     bh
                 jo      short loc_47F769
                 jl      short loc_47F767

 loc_47F762:                             
                                         
                 jmp     short loc_47F76B

 loc_47F767:                             
                 jz      short loc_47F762

 loc_47F769:                             
                 jmp     short loc_47F762

 loc_47F76B:                             
                 and     eax, 40h
                 sub     bh, 13h
                 sub     bh, 3
                 pop     eax
                 dec     bh
                 and     ah, bh
                 mov     edx, 12h
                 dec     dl
                 jo      short loc_47F78B
                 jl      short loc_47F789

 loc_47F784:                             
                                         
                 jmp     short loc_47F78D

 loc_47F789:                             
                 jz      short loc_47F784

 loc_47F78B:                             
                 jmp     short loc_47F784

 loc_47F78D:                             
                 sub     dl, 1
                 dec     dl
                 sub     dl, 7
                 dec     dl
                 dec     dl
                 sub     dl, 2
                 jo      short loc_47F7A7
                 jl      short loc_47F7A5

 loc_47F7A0:                             
                                         
                 jmp     short loc_47F7A9

 loc_47F7A5:                             
                 jz      short loc_47F7A0

 loc_47F7A7:                             
                 jmp     short loc_47F7A0

 loc_47F7A9:                             
                 and     al, dl
                 pop     ebx
                 pop     edx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D9388
                 xor     ecx, ds:dword_4D938C
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_47F7D5
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_47F7D5:                             
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCB4
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}




__declspec(naked) void sub_48DA6B(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDD10
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    ebx
                 mov     ebx, 80h
                 jmp     short loc_48DA94
                 mov     ebx, 4
 loc_48DA94:
                 mov     ebx, 32h
                 not     ebx
                 bswap   eax
                 not     ebx
                 inc     ebx
                 inc     ebx
                 add     ebx, 8
                 dec     ebx
                 push    ecx
                 mov     ecx, 4
                 add     ebx, ecx
                 inc     ebx
                 pop     ecx
                 bswap   eax
                 and     eax, ebx
                 pop     ebx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 pop     edx
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D93A4
                 xor     ecx, ds:dword_4D93A8
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_48DADD
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx
loc_48DADD:
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCD0
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}



__declspec(naked) void sub_48A34A(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDCE8
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    edx
                 mov     edx, 0FFFFh
                 and     eax, edx
                 push    ebx
                 push    5
                 pop     ebx
                 dec     bl
                 dec     bl
                 sub     bl, 2
                 dec     bl
                 and     al, bl
                 mov     dh, 0Dh
                 and     dl, 0
                 sub     dh, 3
                 dec     dh
                 sub     dh, 1
                 and     ah, dh
                 pop     ebx
                 pop     edx
                 test    eax, eax
                 jz      short loc_48A39A
                 not     eax
                 add     eax, 1
                 stc
                 jmp     short loc_48A3A0

 loc_48A39A:
                 not     eax
                 add     eax, 1
                 clc

 loc_48A3A0:
                 sbb     eax, eax
                 neg     eax
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D937C
                 xor     ecx, ds:dword_4D9380
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_48A3C7
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_48A3C7:
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCA8
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}



__declspec(naked) void sub_48778D(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDD00
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    ebx
                 mov     ebx, 0FFFFh
                 and     eax, ebx
                 push    ecx
                 mov     ch, 2Dh
                 dec     ch
                 sub     ch, 1
                 sub     ch, 20h
                 dec     ch
                 dec     ch
                 sub     ch, 7
                 dec     ch
                 dec     ch
                 and     ah, ch
                 mov     cl, 75h
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 not     cl
                 bswap   edx
                 not     cl
                 bswap   edx
                 dec     cl
                 dec     cl
                 push    eax
                 dec     cl
                 dec     cl
                 sub     cl, 12h
                 dec     cl
                 jo      short loc_4877F2
                 jl      short loc_4877F0

 loc_4877ED:
                 jmp     short loc_4877F4

 loc_4877F0:
                 jz      short loc_4877ED

 loc_4877F2:
                 jmp     short loc_4877ED

 loc_4877F4:
                 dec     cl
                 and     eax, 40h
                 dec     cl
                 dec     cl
                 dec     cl
                 add     cl, 0Eh
                 dec     cl
                 dec     cl
                 and     eax, 800h
                 sub     cl, 1Fh
                 dec     cl
                 dec     cl
                 dec     cl
                 not     ecx
                 bswap   eax
                 not     ecx
                 bswap   eax
                 pop     eax
                 and     al, cl
                 mov     eax, eax
                 pop     ecx
                 pop     ebx
                 test    eax, eax
                 jnz     loc_4878DB
                 mov     eax, [ebp-4]
                 push    edx
                 mov     edx, 0FFFFh
                 and     eax, edx
                 push    ebx
                 push    eax
                 mov     bh, 7
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 inc     bh
                 inc     bh
                 inc     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 and     eax, 80h
                 bswap   ecx
                 pop     eax
                 bswap   ecx
                 and     ah, bh
                 mov     bl, 98h
                 sub     bl, 5
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 sub     bl, 0Ch
                 not     bx
                 bswap   eax
                 not     bx
                 bswap   eax
                 and     al, bl
                 mov     eax, eax
                 pop     ebx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 pop     edx
                 mov     ecx, eax
                 push    ecx
                 mov     eax, [ebp-4]
                 push    ebx
                 mov     ebx, 0FFFFh
                 and     eax, ebx
                 push    ecx
                 push    4
                 pop     ecx
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 and     al, cl
                 mov     bh, 0Fh
                 and     bl, 0
                 sub     bh, 4
                 dec     bh
                 sub     bh, 1
                 dec     bh
                 and     ah, bh
                 pop     ecx
                 pop     ebx
                 test    eax, eax
                 jz      short loc_4878C6
                 not     eax
                 add     eax, 1
                 stc
                 jmp     short loc_4878CC

 loc_4878C6:
                 not     eax
                 add     eax, 1
                 clc

 loc_4878CC:
                 sbb     eax, eax
                 add     eax, 1
                 pop     ecx
                 cmp     ecx, eax
                 jnz     short loc_4878DB
                 and     eax, 0
                 jmp     short loc_4878DF

 loc_4878DB:
                 and     eax, 0
                 inc     eax

 loc_4878DF:
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D9394
                 xor     ecx, ds:dword_4D9398
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_487902
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_487902:
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCC0
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}






__declspec(naked) void sub_48BCA8(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDCE8
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    edx
                 mov     edx, [ebp+0Ch]
                 mov     edx, 0FFFFh
                 and     eax, edx
                 push    ebx
                 push    eax
                 mov     bh, 7
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 and     eax, 800h
                 bswap   ecx
                 pop     eax
                 bswap   ecx
                 and     ah, bh
                 mov     bl, 86h
                 sub     bl, 5
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 sub     bl, 3Ah
                 not     bx
                 bswap   eax
                 not     bx
                 bswap   eax
                 and     al, bl
                 pop     ebx
                 pop     edx
                 test    eax, eax
                 jnz     loc_48BDFA
                 mov     eax, [ebp-4]
                 push    edx
                 mov     edx, 0FFFFh
                 and     eax, edx
                 push    ebx
                 push    eax
                 mov     bh, 4
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 and     eax, 800h
                 bswap   ecx
                 pop     eax
                 bswap   ecx
                 and     ah, bh
                 mov     bl, 98h
                 sub     bl, 5
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 sub     bl, 0Ch
                 not     bx
                 bswap   eax
                 not     bx
                 bswap   eax
                 and     al, bl
                 mov     eax, eax
                 pop     ebx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 pop     edx
                 mov     ecx, eax
                 push    ecx
                 mov     eax, [ebp-4]
                 push    edx
                 mov     edx, 0FFFFh
                 and     eax, edx
                 push    ebx
                 push    1Fh
                 pop     ebx
                 jo      short loc_48BD84
                 jl      short loc_48BD82

 loc_48BD7D:                             

                 jmp     short loc_48BD86

 loc_48BD82:                             
                 jz      short loc_48BD7D

 loc_48BD84:                             
                 jmp     short loc_48BD7D

 loc_48BD86:                             
                 sub     bl, 5
                 dec     bl
                 push    eax
                 dec     bl
                 dec     bl
                 jo      short loc_48BD99
                 jl      short loc_48BD97

 loc_48BD94:                             

                 jmp     short loc_48BD9B

 loc_48BD97:                             
                 jz      short loc_48BD94

 loc_48BD99:                             
                 jmp     short loc_48BD94

 loc_48BD9B:                             
                 and     eax, 40h
                 dec     bl
                 sub     bl, 12h
                 sub     bl, 3
                 pop     eax
                 dec     bl
                 and     al, bl
                 mov     edx, 1200h
                 dec     dh
                 sub     dh, 1
                 dec     dh
                 sub     dh, 7
                 and     ah, dh
                 pop     ebx
                 pop     edx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 dec     eax
                 jo      short loc_48BDCF
                 jl      short loc_48BDCD

 loc_48BDC8:                             

                 jmp     short loc_48BDD1

 loc_48BDCD:                             
                 jz      short loc_48BDC8

 loc_48BDCF:                             
                 jmp     short loc_48BDC8

 loc_48BDD1:                             
                 inc     eax
                 dec     eax
                 jo      short loc_48BDDE
                 jl      short loc_48BDDC

 loc_48BDD7:                             

                 jmp     short loc_48BDE0

 loc_48BDDC:                             
                 jz      short loc_48BDD7

 loc_48BDDE:                             
                 jmp     short loc_48BDD7

 loc_48BDE0:                             
                 inc     eax
                 dec     eax
                 inc     eax
                 dec     eax
                 jo      short loc_48BDED
                 jl      short loc_48BDEB

 loc_48BDE8:                             

                 jmp     short loc_48BDEF

 loc_48BDEB:                             
                 jz      short loc_48BDE8

 loc_48BDED:                             
                 jmp     short loc_48BDE8

 loc_48BDEF:                             
                 inc     eax
                 pop     ecx
                 cmp     ecx, eax
                 jnz     short loc_48BDFA
                 and     eax, 0
                 jmp     short loc_48BDFE

 loc_48BDFA:                             
 
                 and     eax, 0
                 inc     eax

 loc_48BDFE:                             
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D937C
                 xor     ecx, ds:dword_4D9380
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_48BE21
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_48BE21:                             
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCA8
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}




__declspec(naked) void sub_489D38(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDD08
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    ebx
                 mov     ebx, 0FFFFh
                 and     eax, ebx
                 push    ecx
                 mov     ch, 2Dh
                 dec     ch
                 sub     ch, 1
                 sub     ch, 20h
                 dec     ch
                 dec     ch
                 sub     ch, 7
                 dec     ch
                 dec     ch
                 and     ah, ch
                 mov     cl, 77h
                 sub     cl, 2
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 not     cl
                 bswap   edx
                 not     cl
                 bswap   edx
                 dec     cl
                 dec     cl
                 push    eax
                 dec     cl
                 dec     cl
                 sub     cl, 12h
                 dec     cl
                 jo      short loc_489DA0
                 jl      short loc_489D9E

 loc_489D9B:
                 jmp     short loc_489DA2

 loc_489D9E:
                 jz      short loc_489D9B

 loc_489DA0:
                 jmp     short loc_489D9B
 loc_489DA2: 
                 dec     cl
                 and     eax, 40h
                 dec     cl
                 dec     cl
                 dec     cl
                 add     cl, 0Eh
                 dec     cl
                 dec     cl
                 and     eax, 800h
                 sub     cl, 1Fh
                 dec     cl
                 dec     cl
                 dec     cl
                 not     ecx
                 bswap   eax
                 not     ecx
                 bswap   eax
                 pop     eax
                 and     al, cl
                 mov     eax, eax
                 pop     ecx
                 pop     ebx
                 test    eax, eax
                 jnz     loc_489E7F
                 mov     eax, [ebp-4]
                 push    edx
                 mov     edx, 0FFFFh
                 and     eax, edx
                 push    ebx
                 push    eax
                 mov     bh, 7
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 and     eax, 800h
                 bswap   ecx
                 pop     eax
                 bswap   ecx
                 and     ah, bh
                 mov     bl, 98h
                 sub     bl, 5
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 sub     bl, 0Ch
                 not     bx
                 bswap   eax
                 not     bx
                 bswap   eax
                 and     al, bl
                 mov     eax, eax
                 pop     ebx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 pop     edx
                 mov     ecx, eax
                 push    ecx
                 mov     eax, [ebp-4]
                 push    ebx
                 mov     ebx, 0FFFFh
                 and     eax, ebx
                 push    ecx
                 push    4
                 pop     ecx
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 and     al, cl
                 mov     bh, 0Fh
                 and     bl, 0
                 dec     bh
                 sub     bh, 3
                 dec     bh
                 sub     bh, 1
                 dec     bh
                 and     ah, bh
                 pop     ecx
                 pop     ebx
                 test    eax, eax
                 jz      short loc_489E6A
                 not     eax
                 add     eax, 1
                 stc
                 jmp     short loc_489E70
 loc_489E6A:
                 not     eax
                 add     eax, 1
                 clc

 loc_489E70: 
                 sbb     eax, eax
                 add     eax, 1
                 pop     ecx
                 cmp     ecx, eax
                 jnz     short loc_489E7F
                 and     eax, 0
                 jmp     short loc_489E83

 loc_489E7F:
                 and     eax, 0
                 inc     eax

 loc_489E83: 
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D939C
                 xor     ecx, ds:dword_4D93A0
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_489EA6
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_489EA6:
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCC8
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}




__declspec(naked) void sub_486E92(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDD0C
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    ecx
                 mov     ecx, 800h
                 mov     ecx, 0Ch
                 not     ecx
                 bswap   eax
                 not     ecx
                 inc     ecx
                 dec     ecx
                 inc     ecx
                 dec     ecx
                 dec     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 dec     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 inc     ecx
                 dec     ecx
                 inc     ecx
                 dec     ecx
                 inc     ecx
                 dec     ecx
                 inc     ecx
                 dec     ecx
                 inc     ecx
                 dec     ecx
                 inc     ecx
                 dec     ecx
                 inc     ecx
                 inc     ecx
                 inc     cl
                 inc     cl
                 inc     cl
                 add     ecx, 0Dh
                 inc     cl
                 inc     cl
                 inc     cl
                 inc     cl
                 inc     cl
                 add     ecx, 0Ah
                 dec     ecx
                 push    edx
                 mov     edx, 4
                 add     ecx, edx
                 inc     ecx
                 pop     edx
                 bswap   eax
                 and     eax, ecx
                 pop     ecx
                 pop     edx
                 test    eax, eax
                 jnz     loc_487009
                 mov     eax, [ebp-4]
                 push    ebx
                 mov     ebx, 0FFFFh
                 and     eax, ebx
                 push    ecx
                 mov     ch, 2Ch
                 sub     ch, 1
                 sub     ch, 20h
                 dec     ch
                 dec     ch
                 sub     ch, 4
                 dec     ch
                 sub     ch, 3
                 dec     ch
                 and     ah, ch
                 mov     cl, 0AEh
                 sub     cl, 2
                 dec     cl
                 dec     cl
                 sub     cl, 6
                 not     al
                 bswap   ecx
                 not     al
                 bswap   ecx
                 dec     cl
                 dec     cl
                 sub     cl, 10h
                 dec     cl
                 dec     cl
                 add     cl, 0Ch
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 sub     cl, 10h
                 sub     cl, 1
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 not     ecx
                 bswap   eax
                 not     ecx
                 bswap   eax
                 inc     cl
                 add     cl, 2
                 jo      short loc_486F93
                 jl      short loc_486F91

 loc_486F8C:
                 jmp     short loc_486F95

 loc_486F91: 
                 jz      short loc_486F8C

 loc_486F93:
                 jmp     short loc_486F8C

 loc_486F95:
                 and     al, cl
                 pop     ecx
                 pop     ebx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 mov     ecx, eax
                 push    ecx
                 mov     eax, [ebp-4]
                 push    edx
                 mov     edx, 0FFFFh
                 and     eax, edx
                 push    ebx
                 push    1Fh
                 pop     ebx
                 jo      short loc_486FBB
                 jl      short loc_486FB9

 loc_486FB4: 
                 jmp     short loc_486FBD

 loc_486FB9: 
                 jz      short loc_486FB4

 loc_486FBB: 
                 jmp     short loc_486FB4

 loc_486FBD: 
                 sub     bl, 5
                 dec     bl
                 push    eax
                 dec     bl
                 dec     bl
                 and     eax, 41h
                 dec     bl
                 sub     bl, 12h
                 sub     bl, 3
                 pop     eax
                 dec     bl
                 and     al, bl
                 mov     edx, 1500h
                 dec     dh
                 sub     dh, 7
                 dec     dh
                 sub     dh, 3
                 dec     dh
                 jo      short loc_486FF3
                 jl      short loc_486FF1

 loc_486FEC:
                 jmp     short loc_486FF5

 loc_486FF1:
                 jz      short loc_486FEC

 loc_486FF3: 
                 jmp     short loc_486FEC

 loc_486FF5: 
                 and     ah, dh
                 pop     ebx
                 pop     edx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 pop     ecx
                 cmp     ecx, eax
                 jnz     short loc_487009
                 and     eax, 0
                 inc     eax
                 jmp     short loc_48700C

 loc_487009: 
                 and     eax, 0

 loc_48700C: 
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D93A0
                 xor     ecx, ds:dword_4D93A4
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_48702F
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_48702F: 
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCCC
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}






__declspec(naked) void sub_485AD2(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDD0C
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    ebx
                 mov     ebx, 0FFFFh
                 and     eax, ebx
                 push    ecx
                 mov     ch, 2Dh
                 dec     ch
                 sub     ch, 1
                 sub     ch, 20h
                 dec     ch
                 dec     ch
                 sub     ch, 7
                 dec     ch
                 dec     ch
                 and     ah, ch
                 mov     cl, 0BDh
                 sub     cl, 2
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 not     cl
                 bswap   edx
                 not     cl
                 bswap   edx
                 dec     cl
                 dec     cl
                 dec     cl
                 dec     cl
                 push    eax
                 dec     cl
                 dec     cl
                 sub     cl, 12h
                 dec     cl
                 dec     cl
                 sub     cl, 3
                 dec     cl
                 and     eax, 40h
                 dec     cl
                 dec     cl
                 dec     cl
                 add     cl, 0Eh
                 dec     cl
                 dec     cl
                 and     eax, 80h
                 sub     cl, 1Fh
                 dec     cl
                 dec     cl
                 dec     cl
                 not     ecx
                 bswap   eax
                 not     ecx
                 bswap   eax
                 pop     eax
                 inc     cl
                 inc     cl
                 inc     cl
                 and     al, cl
                 mov     eax, eax
                 pop     ecx
                 neg     eax
                 sbb     eax, eax
                 neg     eax
                 pop     ebx
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D93A0
                 xor     ecx, ds:dword_4D93A4
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_485B9E
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_485B9E:
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCCC
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}




 __declspec(naked) void sub_48A4A6(void)
 {
	 __asm
	 {
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDCF4
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    ebx
                 mov     ebx, 800h
                 jmp     short loc_48A4CF
                 mov     ebx, 80h

 loc_48A4CF:
                 mov     ebx, 72h
                 not     ebx
                 bswap   eax
                 not     ebx
                 inc     ebx
                 inc     ebx
                 add     ebx, 8
                 dec     ebx
                 push    ecx
                 mov     ecx, 4
                 add     ebx, ecx
                 inc     ebx
                 pop     ecx
                 bswap   eax
                 and     eax, ebx
                 pop     ebx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 pop     edx
                 push    eax
                 mov     eax, [ebp-4]
                 mov     edx, 0F00h
                 sub     dh, 1
                 dec     dh
                 dec     dh
                 dec     dh
                 dec     dh
                 dec     dh
                 dec     dh
                 and     eax, edx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 mov     edx, eax
                 pop     eax
                 xor     ecx, ecx
                 jo      short loc_48A522
                 jl      short loc_48A520

 loc_48A51D:
                 jmp     short loc_48A524

 loc_48A520: 
                 jz      short loc_48A51D

 loc_48A522:
                 jmp     short loc_48A51D

 loc_48A524:
                 cmp     eax, edx
                 jo      short loc_48A52F
                 jl      short loc_48A52D

 loc_48A52A:
                 jmp     short loc_48A531

 loc_48A52D: 
                 jz      short loc_48A52A

 loc_48A52F:
                 jmp     short loc_48A52A

 loc_48A531: 
                 jnz     short loc_48A543
                 jo      short loc_48A53C
                 jl      short loc_48A53A

 loc_48A537:
                 jmp     short loc_48A53E

 loc_48A53A: 
                 jz      short loc_48A537

 loc_48A53C:
                 jmp     short loc_48A537

 loc_48A53E: 
                 and     eax, 0
                 jmp     short loc_48A552

 loc_48A543:
                 and     eax, 0
                 jo      short loc_48A54F
                 jl      short loc_48A54D

 loc_48A54A: 
                 jmp     short loc_48A551

 loc_48A54D: 
                 jz      short loc_48A54A

 loc_48A54F:  
                 jmp     short loc_48A54A

 loc_48A551: 
                 inc     eax

 loc_48A552:  
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D9388
                 xor     ecx, ds:dword_4D938C
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_48A575
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_48A575: 
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCB4
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}




__declspec(naked) void sub_484B20(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDCE0
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    edx
                 mov     edx, 0FFFFh
                 and     eax, edx
                 push    ebx
                 push    eax
                 mov     bh, 7
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 dec     bh
                 and     eax, 800h
                 bswap   ecx
                 pop     eax
                 bswap   ecx
                 and     ah, bh
                 mov     bl, 87h
                 sub     bl, 5
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 sub     bl, 1Ah
                 dec     bl
                 sub     bl, 1Fh
                 not     bx
                 bswap   eax
                 not     bx
                 bswap   eax
                 and     al, bl
                 mov     eax, eax
                 pop     ebx
                 neg     eax
                 sbb     eax, eax
                 neg     eax
                 pop     edx
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D9374
                 xor     ecx, ds:dword_4D9378
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_484BB6
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_484BB6:
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCA0
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}





__declspec(naked) void sub_48873D(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDD10
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 jo      short loc_488762
                 jl      short loc_488760

 loc_48875D:
                 jmp     short loc_488764

 loc_488760:
                 jz      short loc_48875D

 loc_488762:
                 jmp     short loc_48875D

 loc_488764:
                 push    edx
                 mov     edx, 0FFFFh
                 and     eax, edx
                 push    ebx
                 push    eax
                 mov     bh, 7
                 xor     bh, 7
                 and     eax, 800h
                 bswap   ecx
                 pop     eax
                 bswap   ecx
                 and     ah, bh
                 jo      short loc_488788
                 jl      short loc_488786

 loc_488783:
                 jmp     short loc_48878A
 loc_488786:  
                 jz      short loc_488783

 loc_488788: 
                 jmp     short loc_488783

 loc_48878A: 
                 mov     bl, 0C6h
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     bl
                 sub     bl, 1Ah
                 dec     bl
                 sub     bl, 1Fh
                 not     bx
                 bswap   eax
                 not     bx
                 bswap   eax
                 jo      short loc_4887BF
                 jl      short loc_4887BD

 loc_4887BA:
                 jmp     short loc_4887C1

 loc_4887BD: 
                 jz      short loc_4887BA

 loc_4887BF:
                 jmp     short loc_4887BA

 loc_4887C1:
                 and     al, bl
                 mov     eax, eax
                 pop     ebx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 pop     edx
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D93A4
                 xor     ecx, ds:dword_4D93A8
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_4887EF
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_4887EF:
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCD0
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}





 __declspec(naked) void sub_48D647(void)
 {
	 __asm
	 {
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDCF8
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    ebx
                 mov     ebx, 800h
                 jmp     short loc_48D670
                 mov     ebx, 80h

 loc_48D670: 
                 mov     ebx, 72h
                 not     ebx
                 bswap   eax
                 not     ebx
                 inc     ebx
                 inc     ebx
                 add     ebx, 8
                 dec     ebx
                 push    ecx
                 mov     ecx, 4
                 add     ebx, ecx
                 inc     ebx
                 pop     ecx
                 bswap   eax
                 and     eax, ebx
                 pop     ebx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 pop     edx
                 push    eax
                 mov     eax, [ebp-4]
                 mov     edx, 0F00h
                 sub     dh, 1
                 dec     dh
                 dec     dh
                 dec     dh
                 dec     dh
                 dec     dh
                 dec     dh
                 and     eax, edx
                 neg     eax
                 sbb     eax, eax
                 inc     eax
                 mov     edx, eax
                 pop     eax
                 xor     ecx, ecx
                 cmp     eax, edx
                 setz    cl
                 mov     al, cl
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D938C
                 xor     ecx, ds:dword_4D9390
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_48D6E4
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_48D6E4:
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCB8
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}





__declspec(naked) void sub_48649F(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDCEC
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    edx
                 mov     edx, 0FFFFh
                 and     eax, edx
                 push    ebx
                 push    eax
                 mov     bh, 5
                 dec     bh
                 sub     bh, 1
                 dec     bh
                 sub     bh, 2
                 and     eax, 80h
                 bswap   ecx
                 pop     eax
                 bswap   ecx
                 and     ah, bh
                 mov     bl, 0A1h
                 dec     bl
                 dec     esi
                 dec     bl
                 sub     bl, 0Eh
                 dec     bl
                 dec     bl
                 dec     bl
                 dec     edi
                 dec     bl
                 dec     bl
                 sub     bl, 0Fh
                 dec     bl
                 dec     bl
                 dec     edi
                 sub     bl, 1Ah
                 dec     bl
                 sub     bl, 1Fh
                 not     bx
                 bswap   eax
                 not     bx
                 bswap   eax
                 and     al, bl
                 mov     eax, eax
                 pop     ebx
                 neg     eax
                 sbb     eax, eax
                 neg     eax
                 pop     edx
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D9380
                 xor     ecx, ds:dword_4D9384
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword ptr [ebp-0Ch], 0
                 jz      short loc_48653B
                 mov     edx, [ebp-8]
                 or      edx, 1
                 mov     [ebp-8], edx

 loc_48653B:
                 mov     eax, [ebp-8]
                 push    eax
                 call    ds:off_4DDCAC
                 add     esp, 4
                 pop     edi
                 pop     esi
                 pop     ebx
                 mov     esp, ebp
                 pop     ebp
                 retn
	}
}






__declspec(naked) void sub_4857D3(void)
{
	__asm
	{
                 push    ebp
                 mov     ebp, esp
                 sub     esp, 0Ch
                 push    ebx
                 push    esi
                 push    edi
                 mov     eax, [ebp+8]
                 push    eax
                 call    ds:off_4DDD10
                 add     esp, 4
                 mov     [ebp-4], eax
                 mov     eax, [ebp-4]
                 push    edx
                 mov     edx, 0FFFFh
                 and     eax, edx
                 push    ebx
                 push    100h
                 pop     ebx
                 dec     bh
                 jo      short loc_485809
                 jl      short loc_485807

 loc_485804:
                 jmp     short loc_48580B

 loc_485807: 
                 jz      short loc_485804

 loc_485809: 
                 jmp     short loc_485804

 loc_48580B:  
                 add     bh, 0FFh
                 add     bh, 0FFh
                 add     bh, 0FFh
                 add     bh, 0FFh
                 inc     bh
                 inc     bh
                 inc     bh
                 inc     bh
                 and     ah, bh
                 jo      short loc_48582A
                 jl      short loc_485828

 loc_485825: 
                 jmp     short loc_48582C

 loc_485828: 
                 jz      short loc_485825

 loc_48582A: 
                 jmp     short loc_485825

 loc_48582C: 
                 mov     bl, 14h
                 dec     bl
                 sub     bl, 5
                 dec     bl
                 dec     bl
                 dec     bl
                 sub     bl, 1
                 dec     bl
                 dec     bl
                 dec     bl
                 sub     bl, 3
                 and     al, bl
                 pop     ebx
                 pop     edx
                 test    eax, eax
                 jz      short loc_485855
                 not     eax
                 add     eax, 1
                 stc
                 jmp     short loc_48585B

 loc_485855: 
                 not     eax
                 add     eax, 1
                 clc

 loc_48585B:
                 sbb     eax, eax
                 neg     eax
                 neg     eax
                 mov     [ebp-0Ch], eax
                 mov     ecx, ds:dword_4D93A4
                 xor     ecx, ds:dword_4D93A8
                 shl     ecx, 1
                 mov     [ebp-8], ecx
                 cmp     dword