#include "HDLCore.h"
#include "FingerPrintLocator.h"

BOOL FingerPrintLocator::LocateFingerPrint(char *FingerPrint, unsigned long PatternLen)
{

	unsigned long i, BufferLen, EndOfSearch;
	LPBYTE Buffer = 0;
	LPWORD PatternBuffer = 0;

	this->ImageLocator.LocateImage((char *)VictimFileName);
	Buffer = (LPBYTE)this->ImageLocator.GetBaseAddress();
	BufferLen = this->ImageLocator.GetImageSize();
	
	PatternBuffer = this->PreparePattern(FingerPrint);
	PatternLen = PatternLen / 2;

	EndOfSearch = BufferLen - PatternLen;

	for(i=0; i <= EndOfSearch; i++) {

		if (this->CheckPattern((LPBYTE)&Buffer[i], PatternBuffer, PatternLen)) {
			delete[] PatternBuffer;

			this->m_FingerPrintAddress = &Buffer[i];
			return TRUE;
		}
	}

	delete[] PatternBuffer;

	this->m_FingerPrintAddress = NULL;
	return FALSE;
}

BOOL FingerPrintLocator::CheckPattern(LPBYTE Buffer, LPWORD Pattern, DWORD PatternLen) {

	unsigned char TempByte;

	for (unsigned int i = 0; i < PatternLen; i++) {
		TempByte = LOBYTE(Pattern[i]);

		switch ((Pattern[i] & 0xff00)>>8) {
			//ignore on
			case 0x00:
				break;

			//ignore off
			case 0xff:
				if(TempByte != Buffer[i]) 
					return FALSE;

				break;

			default:
				__assume(0);
		}

	}

	return TRUE;
}

LPWORD FingerPrintLocator::PreparePattern(char *String)
{
	struct CharMap {
		char Character;
		int CharValue;
	};

	CharMap HexMap[16] =
	{
		{'0', 0}, {'1', 1},
		{'2', 2}, {'3', 3},
		{'4', 4}, {'5', 5},
		{'6', 6}, {'7', 7},
		{'8', 8}, {'9', 9},
		{'A', 10}, {'B', 11},
		{'C', 12}, {'D', 13},
		{'E', 14}, {'F', 15}
	};

	char *StringPtr = String;
	WORD *ReturnValue = NULL;
	ReturnValue = new WORD[strlen(String)>>1];

	short int Index = 0;
	char TempByte = 0;
	bool FirstChar = true;

	while( *StringPtr )
	{
		for( int i = 0; i < 16; i++ )
		{
			if( *StringPtr == 'x' )
			{
				if( FirstChar )
				{
					FirstChar = false;
					break;
				} else {
					FirstChar = true;
					ReturnValue[Index] = 0;
					Index += 1;
					break;
				}
			}
			else if( *StringPtr == HexMap[i].Character )
			{
				if( FirstChar )
				{
					FirstChar = false;
					ReturnValue[Index] = 0xFF00;
					TempByte = HexMap[i].CharValue;
					TempByte <<= 4;
					break;
				} else {
					FirstChar = true;
					TempByte |= HexMap[i].CharValue;
					ReturnValue[Index] |= TempByte;
					Index += 1;
					break;
				}
			}
		}

		StringPtr += 1;
	}

	return ReturnValue;
}

