#include "LocateImageByName.h"

LocateImageByName::~LocateImageByName()
{

}

LPVOID LocateImageByName::GetBaseAddress()
{
	return this->Image.ImageInformation.lpBaseOfDll;
}

DWORD LocateImageByName::GetImageSize()
{
	return this->Image.ImageInformation.SizeOfImage;
}

bool LocateImageByName::LocateImage(char *ImageName )
{
    DWORD ProcessIDs[ MAX_PROCESSES ];
    DWORD ProcessIDSize = 0;
    DWORD ProcessNumber;

    HANDLE CurrentProcessHandle;
    HMODULE ModuleHandles[ MAX_MODULES ];
    DWORD ModuleHandleSize = 0;
    MODULEINFO ModuleInformation;

    char ModuleBaseName[ MAX_BASENAME ];

	unsigned int i;
 

    // Enumerate the running processes
    if( !EnumProcesses( ProcessIDs, MAX_PROCESSES * sizeof( DWORD ), &ProcessIDSize ) )
    {
        return false;
    } else {
        ProcessNumber = ProcessIDSize / sizeof( DWORD );
    }

    // Loop through the processes
    for( i = 0; i < ProcessNumber; i++ )
    {
        CurrentProcessHandle = OpenProcess( PROCESS_ALL_ACCESS, false, ProcessIDs[ i ] );

        // If we have access to the process
        if( CurrentProcessHandle )
        {
			// Processes identified by IDs here

            // Get the loaded modules within the process
            if( EnumProcessModules( CurrentProcessHandle, ModuleHandles, ProcessNumber * sizeof( HMODULE ), &ModuleHandleSize ) )
            {
                for( unsigned int j = 0; j < ModuleHandleSize / sizeof( HMODULE ); j++ )
                {
                    // Grab module information
                    if( GetModuleInformation( CurrentProcessHandle, ModuleHandles[ j ], &ModuleInformation, sizeof( MODULEINFO ) )  )
                    {
                        if( !GetModuleBaseName( CurrentProcessHandle, ModuleHandles[ j ], ModuleBaseName, MAX_BASENAME - 1 ) )
                        {
							// Could not get the module name
                        }

						if( !stricmp( ModuleBaseName, ImageName ) )
						{
							strcpy( this->Image.ImageName, ModuleBaseName );
							this->Image.ImageInformation.EntryPoint = ModuleInformation.EntryPoint;
							this->Image.ImageInformation.lpBaseOfDll = ModuleInformation.lpBaseOfDll;
							this->Image.ImageInformation.SizeOfImage = ModuleInformation.SizeOfImage;

							CloseHandle( CurrentProcessHandle );
							return true;
						}
                    }
                }
            }

            CloseHandle( CurrentProcessHandle );
        }
    }

	return false;
}