#include "HDLCore.h"
#include "Patch.h"

Patch::Patch()
	: m_PreviousData(NULL), m_RefCount(new DWORD(1))
{
}

Patch::Patch(const Patch& Source)
	: m_BaseAddress(Source.m_BaseAddress), m_ReplaceWith(Source.m_ReplaceWith),
	  m_Length(Source.m_Length), m_PreviousData(Source.m_PreviousData), m_RefCount(Source.m_RefCount)
{
	++*m_RefCount;
}

Patch::~Patch()
{
	if(!--*m_RefCount) {
		delete m_RefCount;

		if(m_PreviousData)
			delete[] m_PreviousData;
	}
}

#ifdef YONI_HEADERS_AVAILABLE
	#pragma intrinsic(memcpy) // Avoid linker error
#endif

void Patch::Apply()
{
	// Sanity check and apply check
	if(m_PreviousData || !GetPatchInfo(m_BaseAddress, m_ReplaceWith, m_Length))
		return;

	// Allocate memory for previous data
	m_PreviousData = new BYTE[m_Length];
	if(!m_PreviousData)
		return;


	DWORD Old = Protect(PAGE_EXECUTE_READWRITE); // Best protect type - covers everything
	memcpy(m_PreviousData, m_BaseAddress, m_Length); // Preserve previous data
	memcpy(m_BaseAddress, m_ReplaceWith, m_Length); // Patch data
	Protect(Old); // Unprotect

	PostApply();
}

void Patch::Remove()
{
	// Sanity check
	if(!m_PreviousData)
		return;

	PreRemove();

	DWORD Old = Protect(PAGE_EXECUTE_READWRITE); // Best protect type - covers everything
	memcpy(m_BaseAddress, m_PreviousData, m_Length); // Copy old data (unpatch)
	Protect(Old); // Unprotect

	// Free memory used by previous data
	delete[] m_PreviousData;
	m_PreviousData = NULL;

	PostRemove();
}

void Patch::PostApply()
{
}

void Patch::PreRemove()
{
}

void Patch::PostRemove()
{
}

DWORD Patch::Protect(DWORD ProtectType)
{
	DWORD OldProtectType;
	VirtualProtect(m_BaseAddress, m_Length, ProtectType, &OldProtectType);
	return OldProtectType;
}