#ifndef _PATCH_H_INCLUDED
#define _PATCH_H_INCLUDED

class Patch
{
public:
	Patch();
	Patch(const Patch& Source);
	virtual ~Patch();
	
	void Apply();
	void Remove();

protected:
	virtual bool GetPatchInfo(LPVOID& BaseAddress, LPVOID& ReplaceWith, DWORD& Length) = 0;
		// Called before patch is applied, and gets information regarding the patch
		// Return true to apply, false to cancel the applying
	virtual void PostApply();
		// Called after patch is applied
	virtual void PreRemove();
		// Called before patch is removed
	virtual void PostRemove();
		// Called after patch is removed

private:
	LPVOID m_BaseAddress;
	LPVOID m_ReplaceWith;
	DWORD m_Length;

	LPBYTE m_PreviousData;
	LPDWORD m_RefCount;
	
	DWORD Protect(DWORD ProtectType);
		// Protects memory and returns previous protect type
};

#endif // _PATCH_H_INCLUDED