#include "HDLCore.h"
#include "Patch.h"
#include "PatchList.h"

PatchListBase::PatchListBase() : m_Start(NULL), m_End(NULL)
{
}

PatchListBase::~PatchListBase()
{
	if(m_Start)
		delete m_Start;
}

void PatchListBase::RegisterPatch(Patch* PatchToRegister)
{
	if(m_End)
		m_End = m_End->Insert(PatchToRegister);
	else
		m_Start = m_End = new Node(PatchToRegister);
}

void PatchListBase::ApplyAll()
{
	for(Node* N = m_Start; N; N = N->NextNode)
		N->NodeData->Apply();
}

void PatchListBase::RemoveAll()
{
	for(Node* N = m_Start; N; N = N->NextNode)
		N->NodeData->Remove();
}

PatchListBase::Node::Node(Patch* Data) : NodeData(Data), NextNode(NULL)
{
}

PatchListBase::Node::~Node()
{
	delete NodeData;
	
	if(NextNode)
		delete NextNode;
}

PatchListBase::Node* PatchListBase::Node::Insert(Patch* Data)
{
	Node* TempNext = NextNode;
	NextNode = new Node(Data);
	NextNode->NextNode = TempNext;
	return NextNode;
}