#ifndef _PATCHLIST_H_INCLUDED
#define _PATCHLIST_H_INCLUDED

class PatchListBase
{
protected:
	PatchListBase(); // Protected constructor - not creatable (except when using derived class)

public:
	~PatchListBase();
	
	void RegisterPatch(Patch* PatchToRegister);
		// Registers a patch.
		// When the HDL is applied, this patch will be added.
		// When the PatchList is destructed, all the patches will be freed with the 'delete' keyword.
		// (The patches must be created with 'new').

	void ApplyAll();
		// Applies all registered patches.

	void RemoveAll();
		// Removes all registered patches.

private:
	class Node
	{
	public:
		Node(Patch* Data);
		~Node();

		Node* Insert(Patch* Data);

		Patch* NodeData;
		Node* NextNode;
	};

	Node* m_Start;
	Node* m_End;
};

class PatchList : public PatchListBase
{
public:
	PatchList();
		// Registers all patches. The user implements this function.
		// The user must call RegisterPatch with patches created with the 'new' keyword.
		// For example:
		// PatchList::PatchList()
		// {
		//		RegisterPatch(new MyPatch1);
		//		RegisterPatch(new MyPatch2);
		// }
};

#endif // _PATCHLIST_H_INCLUDED