#ifndef _THREADLOCATOR_H_INCLUDED
#define _THREADLOCATOR_H_INCLUDED

class ThreadLocator
{
public:
	virtual bool LocateThread(DWORD& ThreadID) = 0;
		// Returns true if the thread was found, or false if it was not.
		// Sets ThreadID to the thread ID of the found thread.

	virtual LPCTSTR GetErrorMessage() = 0;

	virtual ~ThreadLocator() {}

	static ThreadLocator* GetThreadLocator();
		// Creates a thread locator of a specific type.
		// This is implemented by the user.
		// The thread locator must be created using the 'new' keyword.
};

#endif // _THREADLOCATOR_H_INCLUDED