/*
 * uncc - The ultimate C decompiler
 * Copyright (C) 2003  Megabug <megabug@autistici.org>,
 *                     Little-John <littlejohn@autistici.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>

#include "debug.h"

static int verbosity = 0;

void set_verbosity(int i)
{
	verbosity = i;
}

void verbose( FILE *out, char *fmt, ... )
{
#define MAXC 100
	char tmp[MAXC];
	char *i;
	int tmpc;
	va_list ap;

	if (verbosity==0) return;

	va_start(ap,fmt);
	
	tmpc=0;
	for (i=fmt; *i; i++)
	{
		switch (*i) {
			case '%':
				if (tmpc) {
					tmp[tmpc]='\0';
					fprintf(out,"%s",tmp);
					tmpc=0;
				}
				i++;
				switch (*i) {
					case 'd':
						fprintf(out,"%d",va_arg(ap,int));
						break;
					case 'e':
						EXPR_print_tree(va_arg(ap,Expr*),out);
						break;
					case 'r':
						EXPR_print_tree(REGS_expr(va_arg(ap,Register*)),out);
						break;
					case 's':
						fprintf(out,"%s",va_arg(ap,char *));
						break;
					default:
						fprintf(out,"Unknown format type for verbose\n");
				}
				break;
			default:
				tmp[tmpc++]=*i;
				if (tmpc==MAXC-1) {
					tmp[tmpc]='\0';
					fprintf(out,"%s",tmp);
					tmpc=0;
				}
		}
	}
	
	if (tmpc) {
		tmp[tmpc]='\0';
		fprintf(out,"%s",tmp);
	}

	va_end(ap);
}

// vi:ts=4
