/*
 * uncc - The ultimate C decompiler
 * Copyright (C) 2003  Megabug <megabug@autistici.org>,
 *                     Little-John <littlejohn@autistici.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include <stdlib.h>

#include "stack.h"
#include "expressions.h"

static Stack *stack = NULL;


void STACK_push(Expr *e)
{
	Stack *n = (Stack *) malloc(sizeof(Stack));
	n->expr = e;
	n->next = stack;
	stack = n;
}

Expr *STACK_pop()
{
	Expr *e;
	Stack *s;
	s = stack;
	stack = stack->next;
	e = s->expr;
	free(s);
	return e;
}

void STACK_flush()
{
	Stack *i;
	for (i=stack; i; )
	{
		Stack *t;
		t=i;
		i=i->next;
		EXPR_free(t->expr);
		free(t);
	}
}

void STACK_print()
{
	Stack *s;
	for (s=stack; s; s=s->next)
		verbose(stdout,"- %e\n",s->expr);
}

