unit receiver;

{
*****************************************************************************
*                      VxDCall Monitor 1.0b                                 *
*                                                                           *
*                          Viewer Part                                      *
*                                                                           *
*                       Written By GEnius                                   *
*                                                                           *
*                       Italy 29/03/1999                                    *
*                                                                           *
*****************************************************************************
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, ComCtrls;

Type
    NameService = record
                  name: string; //name of vmmservice
                  ID: string[4]; //service number
                  end;
    VMData = record
             name: string; //name of VM
             ID: string[4]; //id of VM
             DeclService: array of NameService; //list of all service
                                                // of current VM
             len: integer; //length of DeclService
             end;
    ServiceData = array of VMData;  // List of all Vm and their service
    rec = record a,b,c,d:integer end;
    DataBuffer = array [1..500] of rec;

type
  THookGEnius = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    Image1: TImage;
    Timer1: TTimer;
    RichEdit1: TRichEdit;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SaveDialog1: TSaveDialog;
    Image2: TImage;
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure Image2Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
  private
    { Private declarations }
    procedure GetHookMsg(var msg:Tmessage); message wm_user + 666;
    procedure WriteService(sn,pname1,pname2,address:integer);
  public
    { Public declarations }
    S: ServiceData;
    Slen: integer; //length of S
    Buff: ^DataBuffer;
    iBuf: integer;
    ShowTitle: boolean;
    MonitorStarted: boolean;
    EventHandle: integer;
  end;


var
  HookGEnius: THookGEnius;

implementation

{$R *.DFM}

procedure THookGEnius.GetHookMsg(var msg:Tmessage);
begin
// Receive the hook buffer
Buff:=pointer(msg.lparam);
msg.Result:=666;
end;

procedure THookGEnius.FormCreate(Sender: TObject);
var
   f:textfile;
   str,tmp:string;
   tmpVM: VMData;
   ns: NameService;
begin
//initializing...
MonitorStarted:=false;
showTitle:=true;
slen:=0; Buff:=nil; iBuf:=0;
AssignFile(f,'Services.dat');
reset(f);
while not eof(f) do
  begin
   readln(f,str);
   if length(str)>8 then
      begin
       tmp:=copy(str,1,4);
       if tmp<>'FFFF' then
          begin
          inc(S[slen-1].len);
          setlength(s[slen-1].declService,s[slen-1].len);
          ns.ID:=copy(str,5,8);
          ns.name:=TrimLeft(Copy(str,9,length(str)));
          S[slen-1].declService[s[slen-1].len-1]:=ns;
          end
        else //new VM
         begin
         inc(slen);
         setlength(s,slen);
         tmpVM.name:=TrimLeft(Copy(str,9,length(str)));
         tmpVM.ID:=copy(str,5,8);
         tmpVM.len:=0;
         S[slen-1]:= tmpVM;
         end;
      end;
  end;
  closefile(f);
end;

procedure THookGEnius.SpeedButton1Click(Sender: TObject);
var
   attrib: _SECURITY_ATTRIBUTES;
begin
// Start o Stop the VxdCall Hook
if not MonitorStarted then
  begin
  attrib.nLength:=sizeof(_SECURITY_ATTRIBUTES);
  attrib.lpSecurityDescriptor:=nil;
  attrib.bInheritHandle:=true;
  EventHandle:=CreateEvent(@attrib,false,false,'CloseEvent');
  Winexec('hkVxdCal.EXE',SW_HIDE);
  SpeedButton1.Caption:='Stop';
  MonitorStarted:=true;
  end
  else
      begin
      MonitorStarted:=false;
      buff:=nil;
      SpeedButton1.Caption:='Start';
      SetEvent(EventHandle);
      CloseHandle(EventHandle);
      end;
end;

procedure THookGEnius.SpeedButton2Click(Sender: TObject);
begin
close;
end;

procedure THookGEnius.Image1Click(Sender: TObject);
begin
application.messagebox('uh..it''s my name!','VxDCall Monitor',mb_ok);
end;

procedure THookGEnius.Image2Click(Sender: TObject);
begin
application.messagebox('it''s only a beta!','VxDCall Monitor',mb_ok);
end;

procedure THookGEnius.WriteService(sn,pname1,pname2,address:integer);
type pip = record loW,hiW:word; end;
type pn = array [1..4] of char;
var str,str1,str2,str3,str4,strtmp:string;
    i,j:integer;
    found:boolean;
//write a line to richedit
begin
str1:=format('%x',[pip(sn).hiW]);
if length(str1)<4 then
   for i:=length(str1) to 3 do str1:='0'+str1;
str2:=format('%x',[pip(sn).loW]);
if length(str2)<4 then
   for i:=length(str2) to 3 do str2:='0'+str2;

//Creating process name form the 2 integer value
str3:='    ';
for i:=1 to 4 do
    if pn(pname1)[i]<>#0 then
       str3[i]:=pn(pname1)[i];
str4:='    ';
for i:=1 to 4 do
    if pn(pname2)[i]<>#0 then
       str4[i]:=pn(pname2)[i];
//search the VM ID
found:=false;
j:=0;
for i:=0 to slen-1 do
  if s[i].ID=str1 then
    begin
    found:=true;
    break;
    end;
if found then
  begin
  found:=false; //search the Service ID
  for j:=0 to s[i].len-1 do
   if s[i].declService[j].ID=str2 then
     begin
     found:=true;
     break;
     end;
  end;
strtmp:=inttostr(48-length(s[i].name)); //only to align
//formatting the output string
  if found then
  str:= format('%s %s %s->%-'+strtmp+'s %s%s   %-x',[str1,str2,s[i].name,s[i].declService[j].name,str3,str4,address])
  else
  str:=format('%s %s %-50s %s%s   %x',[str1,str2,'I don''t Know this service :-((',str3,str4,address]);
Richedit1.lines.add(str); //add it to Richedit
end;

procedure THookGEnius.Timer1Timer(Sender: TObject);
var x:integer;
begin
// timer event... display the log buffer
if (buff=nil) or (not MonitorStarted) then exit;
repeat
inc(ibuf);
if ibuf>= 500 then ibuf:=1;
x:=buff[ibuf].a;
if x=0 then
    dec(ibuf)
   else
    begin
     buff[ibuf].a:=0;
     WriteService(x,buff[ibuf].b,buff[ibuf].c,buff[ibuf].d);
    end;
until x=0;
end;

procedure THookGEnius.FormShow(Sender: TObject);
var
   t: TOSVersionInfo;
begin
//show the title
if showTitle then
   begin
   GetVersionEx(t);
   if t.dwPlatformId=VER_PLATFORM_WIN32_NT then
   begin
   application.MessageBox('This application work only in win9x','VxDCall Monitor',mb_ok);
   close;
   end;

   Richedit1.SelStart:=0;
   Richedit1.SelLength:=80;
   RichEdit1.SelAttributes.Style:=[fsBold];
   showTitle:=false;
   Richedit1.SelLength:=0;
   end;
end;

procedure THookGEnius.FormClose(Sender: TObject; var Action: TCloseAction);
begin
//resetting event object
  buff:=nil;
  SetEvent(EventHandle);
  CloseHandle(EventHandle);
end;

procedure THookGEnius.SpeedButton3Click(Sender: TObject);
var str:string;
begin
//clear Richedit & show title
str:='VMM  SERV SERVICE NAME                                       PROCESS    ADDRESS';
RichEdit1.Clear;
RichEdit1.Lines.Add(str);
   Richedit1.SelStart:=0;
   Richedit1.SelLength:=80;
   RichEdit1.SelAttributes.Style:=[fsBold];
   showTitle:=false;
   Richedit1.SelLength:=0;

end;

procedure THookGEnius.SpeedButton4Click(Sender: TObject);
var nf:string;
begin
// Show Savedialog & Save the log
nf:=GetCurrentDir;
SaveDialog1.InitialDir:=nf;
if SaveDialog1.Execute then
 begin
 nf:=SaveDialog1.FileName;
 RichEdit1.Lines.SaveToFile(nf);
 end;
end;

end.
