;==============================================================================
;       Test Department's WINDOWS 32 BIT x86 ASSEMBLY EXAMPLE's     320
;==============================================================================

;==============================================================================
; ==> Part 320 : WRONG Main Window Procedure
;------------------------------------------------------------------------------
; 

;==============================================================================
; Assembler directives
;------------------------------------------------------------------------------
.386                    ; specifies the processor our program want run on
.Model Flat ,StdCall    ; Flat for Win9x (32 Bit), Calling Convention
option casemap:none     ; case sensitive !

;==============================================================================
; Include all files where API functins resist you want use, set correct path
;------------------------------------------------------------------------------
include \masm32\include\windows.inc
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\gdi32.lib

;==============================================================================
; Declaration of used API functions,take a look into WIN32.HLP and *.inc files
;------------------------------------------------------------------------------
GetModuleHandleA        PROTO :DWORD
CreateSolidBrush        PROTO :DWORD
LoadIconA               PROTO :DWORD,:DWORD
LoadCursorA             PROTO :DWORD,:DWORD
RegisterClassExA        PROTO :DWORD
CreateWindowExA         PROTO :DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,
                              :DWORD,:DWORD,:DWORD,:DWORD,:DWORD
ShowWindow              PROTO :DWORD,:DWORD
UpdateWindow            PROTO :DWORD
GetMessageA             PROTO :DWORD,:DWORD,:DWORD,:DWORD
TranslateMessage        PROTO :DWORD
DispatchMessageA        PROTO :DWORD
PostQuitMessage         PROTO :DWORD
DefWindowProcA          PROTO :DWORD,:DWORD,:DWORD,:DWORD
ExitProcess             PROTO :DWORD
MessageBoxA             PROTO :DWORD,:DWORD,:DWORD,:DWORD
SendMessageA            PROTO :DWORD,:DWORD,:DWORD,:DWORD

;==============================================================================
; .const    = the constants area starts here, constants are defined + fixed
;------------------------------------------------------------------------------
.const

;==============================================================================
; .Data     = the data area starts here, datas are defined but not fixed
;------------------------------------------------------------------------------
.Data
IconName                db "TDIcon",0           ;icon name in rc file
MenuName                db "TDMenu",0           ;menu name in rc file
Class                   db "TDWinClass",0       ;name of window class
WindowName              db "Test Department Error",0  ;text in title bar

ClassStatic             db "STATIC",0           ;predefined ClassName
NameStatic              db ".data?",13,10
                        db "WP1_CallBack   dd ?",13,10
                        db "WP1_hWnd        dd ?",13,10
                        db "WP1_uMsg        dd ?",13,10
                        db "WP1_wParam    dd ?",13,10
                        db "WP1_lParam      dd ?",13,10,13,10
                        db "WP1:",13,10
                        db "pop      WP1_CallBack",13,10
                        db "pop      WP1_hWnd",13,10
                        db "pop      WP1_uMsg",13,10
                        db "pop      WP1_wParam",13,10
                        db "pop      WP1_lParam",13,10
                        db "push    WP1_CallBack",13,10
                        db "pushad",13,10,13,10
                        db "cmp     WP1_uMsg,2h",13,10
                        db "jne       WP1_return",13,10
                        db "push    0h",13,10
                        db "call      PostQuitMessage",13,10
                        db "popad",13,10
                        db "xor       eax,eax",13,10
                        db "ret",13,10,13,10
                        db "WP1_return:",13,10
                        db "popad",13,10
                        db "push    WP1_lParam",13,10
                        db "push    WP1_wParam",13,10
                        db "push    WP1_uMsg",13,10
                        db "push    WP1_hWnd",13,10
                        db "call      DefWindowProcA",13,10
                        db "ret",0

ClassButton             db "BUTTON",0           ;predefined ClassName
NameButton              db "SendMessage",0      ;button1 window text

table_ASCII             db 48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70
table_HEX               db 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15

MB1_Title               db "Error in WinProc",0 
MB1_Text                db "before API SendMessage",13,10
                        db "====================",13,10
before_CallBack         db "Return..--------",13,10
before_hWnd             db "hWnd....--------",13,10
before_uMsg             db "uMsg....--------",13,10
before_wParam           db "wParam..--------",13,10
before_lParam           db "lParam..--------",13,10,13,10
                        db "while API SendMessage",13,10
                        db "====================",13,10
while_CallBack          db "Return..--------",13,10
while_hWnd              db "hWnd....--------",13,10
while_uMsg              db "uMsg....--------",13,10
while_wParam            db "wParam..--------",13,10
while_lParam            db "lParam..--------",13,10,13,10
                        db "after API SendMessage",13,10
                        db "====================",13,10
after_CallBack          db "Return..--------",13,10
after_hWnd              db "hWnd....--------",13,10
after_uMsg              db "uMsg....--------",13,10
after_wParam            db "wParam..--------",13,10
after_lParam            db "lParam..--------",13,10,13,10
                        db "Register on Proc return",13,10
                        db "====================",13,10
register_EBP            db "[EBP]...--------",13,10
register_ESP            db "[ESP]...--------",0

;==============================================================================
; .Data?    = the data? area starts here, not defined and not fixed
;------------------------------------------------------------------------------
.data?
handleStatic            dd ?            ;handle static window
handleButton            dd ?            ;handle button window

; - WndClassEx Structure ( API=RegisterClassExA ) -
cbSize                  dd ?            ;size in bytes of this structure
style                   dd ?            ;window style
lpfnWndProc             dd ?            ;address of user proc function
cbclsExtra              dd ?            ;extra bytes to allocate set to 0
cbWndExtra              dd ?            ;extra bytes class directive, rc file
hInstance               dd ?            ;program handle(API=GetModuleHandleA)
hIcon                   dd ?            ;handle of icon (API=LoadIconA)
hcursor                 dd ?            ;handle of cursor (API=LoadCursor)
hbrBackground           dd ?            ;background color, 0=transparent
lpszMenuName            dd ?            ;name of menu class in resource file
lpszClassName           dd ?            ;name of windows this window class
hIconSm                 dd ?            ;iconhandle 0=search in resource file
hdcDest                 dd ?            ;handle of dest. device context

; - Msg Structure ( API=GetMessageA ) - member POINT = POINT structure
hWnd                    dd ?            ;handle of window who receives message
message                 dd ?            ;the message number
wParam                  dd ?            ;extra info about the message
lParam                  dd ?            ;extra info about the message
time                    dd ?            ;time the message was posted
xpt                     dd ?            ;cursor x-position, POINT struc
ypt                     dd ?            ;cursor x-position, POINT struc

; - Push Parameter MAIN WINDOW CallBack procedure ( API=RegisterClassExA ) -
WP1_CallBack            dd ?            ;return address of calling routine
WP1_hWnd                dd ?            ;handle of window who receives message
WP1_uMsg                dd ?            ;the message number
WP1_wParam              dd ?            ;extra info about the message
WP1_lParam              dd ?            ;extra info about the message

;==============================================================================
; .CODE     = our code area starts here     Main = label of our program code
;------------------------------------------------------------------------------
.Code
Main:

;==============================================================================
; Always get your program ID first (API=GetModuleHandleA)
;------------------------------------------------------------------------------
push    0h                          ;lpModuleHandle, 0=get program handle
call    GetModuleHandleA            ;- API Function -
mov     hInstance,eax               ;return value in eax=handle of program

;==============================================================================
; The API function "RegisterClassExA" registers a window class.
; This API needs a "WNDCLASSEX" structure so we fill it with correct values.
;------------------------------------------------------------------------------
mov     cbSize,30h                  ;size in bytes of WNDCLASSEX structure
mov     style,3h                    ;window style
mov     lpfnWndProc,OFFSET WP1      ;address of user lpfnWndProc function
mov     cbclsExtra,0h               ;extra bytes to allocate set to 0
mov     cbWndExtra,0h               ;class directive in rc file
;------------------------------------------------------------------------------
; API "CreateSolidBrush" creates a logical brush with the specified solid color
;------------------------------------------------------------------------------
push    000000FFh                   ;crColor, brush color value
call    CreateSolidBrush            ;- API Function -
mov     hbrBackground,eax           ;background color
mov     lpszMenuName,0h             ;menu name in resource file,0=no menu
mov     lpszClassName,OFFSET Class  ;name of windows class
mov     hIconSm,0h                  ;iconhandle 0=search in rc file
;------------------------------------------------------------------------------
; API "LoadIconA" loads an icon defined in the resource file and stores the
; handle in the "WNDCLASSEX" structure
;------------------------------------------------------------------------------
push    OFFSET IconName             ;icon-string or icon resource id
push    hInstance                   ;our program handle
call    LoadIconA                   ;- API Function -
mov     hIcon,eax                   ;store handle of newly loaded icon
;------------------------------------------------------------------------------
; API "LoadCursorA" loads a default system cursor, in this case we must set
; hInstance to 0 and lpCursorName to a default system cursor value, here 32512
; Then we store the cursor handle in the "WNDCLASSEX" structure
;------------------------------------------------------------------------------
push    32512                       ;lpCursorName, default value in dezimal
push    0h                          ;hInstance, 0=default system cursor
call    LoadCursorA                 ;- API Function -
mov     hcursor,eax                 ;store handle of the cursor
;------------------------------------------------------------------------------
; Now, after filled the "WNDCLASSEX" structure we call API "RegisterClassEx"
;------------------------------------------------------------------------------
push    OFFSET cbSize               ;pointer to WNDCLASSEX structure
call    RegisterClassExA            ;- API Function -

;==============================================================================
; API "CreateWindowExA" creates an overlapped, pop-up, or child window with an
; extended style. The return value in EAX is the handle of the new window.
; This API sends a WM_CREATE message to the window procedure (WP1).
;------------------------------------------------------------------------------
push    0h                          ;lpParam, extra pointer data 0=no data
push    hInstance                   ;hInstance, handle of our program
push    0h                          ;hMenu, handle window menu 0=class menu
push    0h                          ;hWndParent, handle parent window 0=no
push    00000240h                   ;intnHeight, window height pixel
push    000000E4h                   ;intnWidth, window width pixel
push    00000008h                   ;inty, vertical position window
push    00000008h                   ;intx, horizontal position window
push    04CA0000h                   ;dwStyle, look into WIN32.HLP
push    OFFSET WindowName           ;lpWindowName, pointer to window name
push    OFFSET Class                ;lpClassName, pointer to class name
push    100h                        ;dwExStyle, extra window style 0=no
call    CreateWindowExA             ;- API Function -
mov     hWnd,eax                    ;hwnd,return value=handle of window

;==============================================================================
; API "ShowWindow" function sets the specified window's show state. 
;------------------------------------------------------------------------------
push    1h                          ;nCmdShow, show state 1=SW_SHOWNORMAL
push    hWnd                        ;hwnd, handle of window
call    ShowWindow                  ;- API Function -

;==============================================================================
; API "UpdateWindow" updates the area of the specified window by sending a
; WM_PAINT message to the window if the window's update region is not empty.
;------------------------------------------------------------------------------
push    hWnd                        ;hwnd, handle of window
call    UpdateWindow                ;- API Function -

LoopGetMessage:
;==============================================================================
; API "GetMessageA" retrieves a message + places it in the specified structure.
;------------------------------------------------------------------------------
push    0h                          ;wMsgFilterMax, highest message value
push    0h                          ;wMsgFilterMin, lowest message value
push    0h                          ;hWnd, handle of window who gets msg.
push    OFFSET hWnd                 ;lpMsg, pointer to MSG structure
call    GetMessageA                 ;- API Function -
cmp     eax,0h                      ;check if return value=0 (exit)
je      ExitPrg                     ;if return value is 0 goto LABEL

;==============================================================================
; API "TranslateMessage" translates virtual-key messages in character messages
;------------------------------------------------------------------------------
push    OFFSET hWnd                 ;lpMSG, pointer to msg structure
call    TranslateMessage            ;- API Function - keyboard code

;==============================================================================
; API "DispatchMessageA" function dispatches a message to a window procedure.
;------------------------------------------------------------------------------
push    OFFSET hWnd                 ;lpMSG, pointer to msg structure
call    DispatchMessageA            ;- API Function -
jmp     LoopGetMessage              ;check for message again, goto LABEL

ExitPrg:
;==============================================================================
; Next we terminate our program (API=ExitProcess)
;------------------------------------------------------------------------------
push    hInstance                   ;push our programm handle to exit
call    ExitProcess                 ;- API Function -

;##############################################################################
; The Window Procedure (API=RegisterClassExA) for this registered window.
;------------------------------------------------------------------------------
WP1:
pop     WP1_CallBack                ;POP return address lpfnWndProc
pop     WP1_hWnd                    ;handle of window who receives message
pop     WP1_uMsg                    ;the message number
pop     WP1_wParam                  ;extra info about the message
pop     WP1_lParam                  ;extra info about the message
push    WP1_CallBack                ;PUSH return address lpfnWndProc !!!!!
pushad                              ;push all register to the stack

mov     eax,WP1_uMsg                ;move the message number to eax
;==============================================================================
; WM_CREATE (value=01h) message received ?
;------------------------------------------------------------------------------
WP1_uMsg_01h:
cmp     eax,1h                      ;check if WM_CREATE message recieved
jne     WP1_uMsg_02h                ;if not goto LABEL
;------------------------------------------------------------------------------
; API "CreateWindowExA" creates a window with a predefined class name (STATIC).
;------------------------------------------------------------------------------
push    0h                          ;lpParam, extra pointer data 0=no data
push    hInstance                   ;hInstance, handle of our program
push    0h                          ;hMenu, handle window menu 0=class menu
push    WP1_hWnd                    ;hWndParent, handle parent window 0=no
push    00000208h                   ;intnHeight, window height pixel
push    000000D7h                   ;intnWidth, window width pixel
push    0000001Ch                   ;inty, vertical position window
push    00000004h                   ;intx, horizontal position window
push    54000000h                   ;dwStyle, look WIN32.HLP + windows.inc
push    OFFSET NameStatic           ;lpWindowName, pointer to window name
push    OFFSET ClassStatic          ;lpClassName, pointer to class name
push    1h                          ;dwExStyle,look WIN32.HLP + windows.inc
call    CreateWindowExA             ;- API Function -
mov     handleStatic,eax            ;hwnd,return value=handle of window
;------------------------------------------------------------------------------
; API "CreateWindowExA" creates a window with a predefined class name (BUTTON).
;------------------------------------------------------------------------------
push    0h                          ;lpParam, extra pointer data 0=no data
push    hInstance                   ;hInstance, handle of our program
push    0100h                       ;hMenu, the child-window ID
push    WP1_hWnd                    ;hWndParent, handle parent window 0=no
push    00000014h                   ;intnHeight, window height pixel
push    000000AFh                   ;intnWidth, window width pixel
push    00000004h                   ;inty, vertical position window
push    00000018h                   ;intx, horizontal position window
push    50000001h                   ;dwStyle, style ( BS_DEFPUSHBUTTON )
push    OFFSET NameButton           ;lpWindowName, pointer to window name
push    OFFSET ClassButton          ;lpClassName, pointer to class name
push    0h                          ;dwExStyle,
call    CreateWindowExA             ;- API Function -
mov     handleButton,eax            ;return value=handle of window
jmp     WP1_return

;==============================================================================
; WM_DESTROY (value=02h) message received ?
;------------------------------------------------------------------------------
WP1_uMsg_02h:
cmp     eax,2h                      ;check if value=2h (WM_DESTROY)
jne     WP1_uMsg_0500h              ;if not 2h go to LABEL
;------------------------------------------------------------------------------
; API "PostQuitMessage" indicates to Windows a request to terminate
;------------------------------------------------------------------------------
push    0h                          ;nExitCode, exit code=wParam
call    PostQuitMessage             ;- API Function -
popad                               ;pop all register back from stack
xor     eax,eax                     ;set eax to 0 to exit our program
ret                                 ;return

;==============================================================================
; WM_USER+X (value=0500h) message received
;------------------------------------------------------------------------------
WP1_uMsg_0500h:
cmp     eax,0500h                   ;check if WM_USER+X message recieved
jne     WP1_uMsg_111h               ;if not goto label
;------------------------------------------------------------------------------
; Convert the "while" parameter to an ASCII string
;------------------------------------------------------------------------------
mov     esi,WP1_CallBack            ;pointer to parameter
mov     edi,OFFSET while_CallBack   ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
mov     esi,WP1_hWnd                ;pointer to parameter
mov     edi,OFFSET while_hWnd       ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
mov     esi,WP1_uMsg                ;pointer to parameter
mov     edi,OFFSET while_uMsg       ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
mov     esi,WP1_wParam              ;pointer to parameter
mov     edi,OFFSET while_wParam     ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
mov     esi,WP1_lParam              ;pointer to parameter
mov     edi,OFFSET while_lParam     ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
jmp     WP1_return

;db 10000h dup (90h)                 ;some NOP's to obtain RAM ...

;==============================================================================
; WM_COMMAND (value=111h) message recieved ?
;------------------------------------------------------------------------------
WP1_uMsg_111h:
cmp     eax,111h                    ;check if WM_COMMAND message recieved
jne     WP1_return                  ;if not goto label
;------------------------------------------------------------------------------
; Check extra message, button (SendMessage, ID=0100h) clicked ?
;------------------------------------------------------------------------------
mov     eax,WP1_wParam              ;extra info about the message in ax
cmp     ax,0100h                    ;ID of button, child window
jne     WP1_return                  ;
;------------------------------------------------------------------------------
; Convert the "before" parameter to an ASCII string
;------------------------------------------------------------------------------
mov     esi,WP1_CallBack            ;pointer to parameter
mov     edi,OFFSET before_CallBack  ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
mov     esi,WP1_hWnd                ;pointer to parameter
mov     edi,OFFSET before_hWnd      ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
mov     esi,WP1_uMsg                ;pointer to parameter
mov     edi,OFFSET before_uMsg      ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
mov     esi,WP1_wParam              ;pointer to parameter
mov     edi,OFFSET before_wParam    ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
mov     esi,WP1_lParam              ;pointer to parameter
mov     edi,OFFSET before_lParam    ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
;------------------------------------------------------------------------------
; API "SendMessageA" sends a message to the Window Procedure
;------------------------------------------------------------------------------
push    0h                          ;lParam,
push    0h                          ;wParam,
push    0500h                       ;uMsg, message to send ( WM_USER+X )
push    WP1_hWnd                    ;hWnd, handle of destination window
call    SendMessageA                ;- API Function -
;------------------------------------------------------------------------------
; Convert the "after" parameter to an ASCII string
;------------------------------------------------------------------------------
mov     esi,WP1_CallBack            ;pointer to parameter
mov     edi,OFFSET after_CallBack   ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
mov     esi,WP1_hWnd                ;pointer to parameter
mov     edi,OFFSET after_hWnd       ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
mov     esi,WP1_uMsg                ;pointer to parameter
mov     edi,OFFSET after_uMsg       ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
mov     esi,WP1_wParam              ;pointer to parameter
mov     edi,OFFSET after_wParam     ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
mov     esi,WP1_lParam              ;pointer to parameter
mov     edi,OFFSET after_lParam     ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
;==============================================================================
; API "DefWindowProcA" calls the window procedure to provide default processing
; for any window messages that an application does not process.
; This function ensures that every message is processed.
; It is called with the same parameters received by the window procedure.
;------------------------------------------------------------------------------
popad                               ;pop all register from stack
push    WP1_lParam                  ;extra info about the message
push    WP1_wParam                  ;extra info about the message
push    WP1_uMsg                    ;the message number
push    WP1_hWnd                    ;handle of window who receives message
call    DefWindowProcA              ;- API Function -
;------------------------------------------------------------------------------
; Convert the "register" value to an ASCII string
;------------------------------------------------------------------------------
mov     eax,ebp                     ;get EBP
pushad
mov     esi,[eax]                   ;register to convert
mov     edi,OFFSET register_EBP     ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
popad
mov     eax,esp                     ;get ESP
pushad
mov     esi,[eax]                   ;register to convert
mov     edi,OFFSET register_ESP     ;pointer to message box text area
call    My_MBTextOut                ;- SubRoutine -
popad
;------------------------------------------------------------------------------
; API "MessageBoxA" creates a message box to visualize all parameter blocks !
;------------------------------------------------------------------------------
push    0h                          ;uType, style, 0=MB_OK Button
push    OFFSET MB1_Title            ;lpCaption,pointer to title text
push    OFFSET MB1_Text             ;lpText,pointer to text message box
push    WP1_hWnd                    ;handle of owner window 0=no owner
call    MessageBoxA                 ;- API Function -
ret                                 ;return

;==============================================================================
; API "DefWindowProcA" calls the window procedure to provide default processing
; for any window messages that an application does not process.
; This function ensures that every message is processed.
; It is called with the same parameters received by the window procedure.
;------------------------------------------------------------------------------
WP1_return:
popad                               ;pop all register from stack
push    WP1_lParam                  ;extra info about the message
push    WP1_wParam                  ;extra info about the message
push    WP1_uMsg                    ;the message number
push    WP1_hWnd                    ;handle of window who receives message
call    DefWindowProcA              ;- API Function -
ret                                 ;return

;##############################################################################

;******************************************************************************
; My own subroutine(s) for a compacter code resist here ...
;------------------------------------------------------------------------------
My_MBTextOut:
;------------------------------------------------------------------------------
; Converts a 32 bit value in ESI into an ascii string to OFFSET EDI !
;------------------------------------------------------------------------------
mov     ecx,0h
loop_1:
mov     edx,OFFSET table_HEX
add     edx,ecx
mov     ebx,OFFSET table_ASCII
add     ebx,ecx
inc     ecx
cmp     ecx,11h
jae     My_MBTextOut_return
mov     eax,esi
shr     eax,28
and     eax,15
cmp     al,[edx]
jne     loop_1
mov     eax,edi
add     eax,08
mov     dl,[ebx]
mov     [eax],dl

mov     ecx,0h
loop_2:
mov     edx,OFFSET table_HEX
add     edx,ecx
mov     ebx,OFFSET table_ASCII
add     ebx,ecx
inc     ecx
cmp     ecx,11h
jae     My_MBTextOut_return
mov     eax,esi
shr     eax,24
and     eax,15
cmp     al,[edx]
jne     loop_2
mov     eax,edi
add     eax,9
mov     dl,[ebx]
mov     [eax],dl

mov     ecx,0h
loop_3:
mov     edx,OFFSET table_HEX
add     edx,ecx
mov     ebx,OFFSET table_ASCII
add     ebx,ecx
inc     ecx
cmp     ecx,11h
jae     My_MBTextOut_return
mov     eax,esi
shr     eax,20
and     eax,15
cmp     al,[edx]
jne     loop_3
mov     eax,edi
add     eax,10
mov     dl,[ebx]
mov     [eax],dl

mov     ecx,0h
loop_4:
mov     edx,OFFSET table_HEX
add     edx,ecx
mov     ebx,OFFSET table_ASCII
add     ebx,ecx
inc     ecx
cmp     ecx,11h
jae     My_MBTextOut_return
mov     eax,esi
shr     eax,16
and     eax,15
cmp     al,[edx]
jne     loop_4
mov     eax,edi
add     eax,11
mov     dl,[ebx]
mov     [eax],dl

mov     ecx,0h
loop_5:
mov     edx,OFFSET table_HEX
add     edx,ecx
mov     ebx,OFFSET table_ASCII
add     ebx,ecx
inc     ecx
cmp     ecx,11h
jae     My_MBTextOut_return
mov     eax,esi
shr     eax,12
and     eax,15
cmp     al,[edx]
jne     loop_5
mov     eax,edi
add     eax,12
mov     dl,[ebx]
mov     [eax],dl

mov     ecx,0h
loop_6:
mov     edx,OFFSET table_HEX
add     edx,ecx
mov     ebx,OFFSET table_ASCII
add     ebx,ecx
inc     ecx
cmp     ecx,11h
jae     My_MBTextOut_return
mov     eax,esi
shr     eax,8
and     eax,15
cmp     al,[edx]
jne     loop_6
mov     eax,edi
add     eax,13
mov     dl,[ebx]
mov     [eax],dl

mov     ecx,0h
loop_7:
mov     edx,OFFSET table_HEX
add     edx,ecx
mov     ebx,OFFSET table_ASCII
add     ebx,ecx
inc     ecx
cmp     ecx,11h
jae     My_MBTextOut_return
mov     eax,esi
shr     eax,4
and     eax,15
cmp     al,[edx]
jne     loop_7
mov     eax,edi
add     eax,14
mov     dl,[ebx]
mov     [eax],dl

mov     ecx,0h
loop_8:
mov     edx,OFFSET table_HEX
add     edx,ecx
mov     ebx,OFFSET table_ASCII
add     ebx,ecx
inc     ecx
cmp     ecx,11h
jae     My_MBTextOut_return
mov     eax,esi
shr     eax,0
and     eax,15
cmp     al,[edx]
jne     loop_8
mov     eax,edi
add     eax,15
mov     dl,[ebx]
mov     [eax],dl
My_MBTextOut_return:
ret
;******************************************************************************

;==============================================================================
; end Main	= end of our program code
;------------------------------------------------------------------------------
end Main                            ;end of our program code, entry point

;==============================================================================
; To create the exe file use this commands with your Microsoft Assembler/Linker
;------------------------------------------------------------------------------
; ml.exe /c /coff td__320.asm                           ;asm command
; rc.exe /v rsrc.rc                                     ;rc command
; cvtres.exe /machine:ix86 rsrc.res
; link.exe /subsystem:windows td__320.obj rsrc.obj      ;link command
;==============================================================================