
;                       DirectDraw Structures and Equates
; 
; Author : Ewald Snel
; Copyright (C) 1999, Diamond Crew
; 
; http://here.is/diamond/ ;



[DDBLTFX:
 dwSize: D ?
 dwDDFX: D ?
 dwROP: D ?
 dwDDROP: D ?
 dwRotationAngle: D ?
 dwZBufferOpCode: D ?
 dwZBufferLow: D ?
 dwZBufferHigh: D ?
 dwZBufferBaseDest: D ?
 dwZDestConstBitDepth: D ?

 dwZDestConst: lpDDSZBufferDest: D ?

 dwZSrcConstBitDepth: D ?

 dwZSrcConst: lpDDSZBufferSrc: D ?

 dwAlphaEdgeBlendBitDepth: D ?
 dwAlphaEdgeBlend: D ?
 dwReserved: D ?
 dwAlphaDestConstBitDepth: D ?

 dwAlphaDestConst: lpDDSAlphaDest: D ?

 dwAlphaSrcConstBitDepth: D ?

 dwAlphaSrcConst: lpDDSAlphaSrc: D ?

 dwFillColor: dwFillDepth: lpDDSPattern: D ?

 ddckDestColorkey.dwColorSpaceLowValue: D ?
 ddckDestColorkey.dwColorSpaceHighValue: D ?

 ddckSrcColorkey.dwColorSpaceLowValue: D ?
 ddckSrcColorkey.dwColorSpaceHighValue: D ?]



[DDCAPS:
 dwSize: D ?
 dwCaps: D ?
 dwCaps2: D ?
 dwCKeyCaps: D ?
 dwFXCaps: D ?
 dwFXAlphaCaps: D ?
 dwPalCaps: D ?
 dwSVCaps: D ?
 dwAlphaBltConstBitDepths: D ?
 dwAlphaBltPixelBitDepths: D ?
 dwAlphaBltSurfaceBitDepths: D ?
 dwAlphaOverlayConstBitDepths: D ?
 dwAlphaOverlayPixelBitDepths: D ?
 dwAlphaOverlaySurfaceBitDepths: D ?
 dwZBufferBitDepths: D ?
 dwVidMemTotal: D ?
 dwVidMemFree: D ?
 dwMaxVisibleOverlays: D ?
 dwCurrVisibleOverlays: D ?
 dwNumFourCCCodes: D ?
 dwAlignBoundarySrc: D ?
 dwAlignSizeSrc: D ?
 dwAlignBoundaryDest: D ?
 dwAlignSizeDest: D ?
 dwAlignStrideAlign: D ?
 dwRops: D 8 DUP (?)
 ddsCaps.dwCaps: ?
 dwMinOverlayStretch: D ?
 dwMaxOverlayStretch: D ?
 dwMinLiveVideoStretch: D ?
 dwMaxLiveVideoStretch: D ?
 dwMinHwCodecStretch: D ?
 dwMaxHwCodecStretch: D ?
 dwReserved1: D ?
 dwReserved2: D ?
 dwReserved3: D ?
 dwSVBCaps: D ?
 dwSVBCKeyCaps: D ?
 dwSVBFXCaps: D ?
 dwSVBRops: D 8 DUP (?)
 dwVSBCaps: D ?
 dwVSBCKeyCaps: D ?
 dwVSBFXCaps: D ?
 dwVSBRops: D 8 DUP (?)
 dwSSBCaps: D ?
 dwSSBCKeyCaps: D ?
 dwSSBFXCaps: D ?
 dwSSBRops: D 8 DUP (?)
 dwReserved4: D ?
 dwReserved5: D ?
 dwReserved6: D ?]


[DDOVERLAYFX:
 dwSize: D ?
 dwAlphaEdgeBlendBitDepth: D ?
 dwAlphaEdgeBlend: D ?
 dwReserved: D ?
 dwAlphaDestConstBitDepth: D ?

 dwAlphaDestConst: lpDDSAlphaDest: D ?

 dwAlphaSrcConstBitDepth: D ?

 dwAlphaSrcConst: lpDDSAlphaSrc: D ?

 dckDestColorkey.dwColorSpaceLowValue: D ?
 dckDestColorkey.dwColorSpaceHighValue: D ?

 dckSrcColorkey.dwColorSpaceLowValue: D ?
 dckSrcColorkey.dwColorSpaceHighValue: D ?

 dwDDFX: D ?
 dwFlags: D ?]


[DDPIXELFORMAT:
 dwSize: D ?
 dwFlags: D ?
 dwFourCC: D ?

 dwRGBBitCount: dwYUVBitCount: dwZBufferBitDepth: dwAlphaBitDepth: D ?

 dwRBitMask: dwYBitMask: D ?

 dwGBitMask: dwUBitMask: D ?

 dwBBitMask: dwVBitMask: D ?

 dwRGBAlphaBitMask: dwYUVAlphaBitMask: D ?]


[DDSURFACEDESC:
 dwSize: D ?
 dwFlags: D ?
 dwHeight: D ?
 dwWidth: D ?
 lPitch: D ?
 dwBackBufferCount: D ?

 dwMipMapCount: dwZBufferBitDepth: dwRefreshRate: D ?

 dwAlphaBitDepth: D ?
 dwReserved: D ?
 lpSurface: D ?

 ddckCKDestOverlay.dwColorSpaceLowValue: D ?
 ddckCKDestOverlay.dwColorSpaceHighValue: D ?

 ddckCKDestBlt.dwColorSpaceLowValue: D ?
 ddckCKDestBlt.dwColorSpaceHighValue: D ?

 ddckCKSrcOverlay.dwColorSpaceLowValue: D ?
 ddckCKSrcOverlay.dwColorSpaceHighValue: D ?

 ddckCKSrcBlt.dwColorSpaceLowValue: D ?
 ddckCKSrcBlt.dwColorSpaceHighValue: D ?

 ddpfPixelFormat.dwSize: D ?
 ddpfPixelFormat.dwFlags: D ?
 ddpfPixelFormat.dwFourCC: D ?

 ddpfPixelFormat.dwRGBBitCount: 
 ddpfPixelFormat.dwYUVBitCount: 
 ddpfPixelFormat.dwZBufferBitDepth: 
 ddpfPixelFormat.dwAlphaBitDepth: D ?

 ddpfPixelFormat.dwRBitMask: ddpfPixelFormat.dwYBitMask: D ?

 ddpfPixelFormat.dwGBitMask: ddpfPixelFormat.dwUBitMask: D ?

 ddpfPixelFormat.dwBBitMask: ddpfPixelFormat.dwVBitMask: D ?

 ddpfPixelFormat.dwRGBAlphaBitMask: ddpfPixelFormat.dwYUVAlphaBitMask: D ?

 ddsCaps.dwCaps: ?]


[DDBLTBATCH:
 lprDest LPRECT ?
 lpDDSSrc LPDIRECTDRAWSURFACE ?
 lprSrc LPRECT ?
 dwFlags: D ?
 lpDDBltFx LPDDBLTFX ?]


IDirectDrawVtbl:
 ; IUnknown methods
 STDMETHOD QueryInterface, :PTR IDirectDraw, :PTR, :PTR PTR
 STDMETHOD AddRef, :PTR IDirectDraw
 STDMETHOD Release, :PTR IDirectDraw
 ; IDirectDraw methods
 STDMETHOD Compact, :PTR IDirectDraw
 STDMETHOD CreateClipper, :PTR IDirectDraw, :DWORD, :PTR LPDIRECTDRAWCLIPPER, :PTR IUnknown
 STDMETHOD CreatePalette, :PTR IDirectDraw, :DWORD, :LPPALETTEENTRY, :PTR LPDIRECTDRAWPALETTE, :PTR IUnknown
 STDMETHOD CreateSurface, :PTR IDirectDraw, :LPDDSURFACEDESC, :PTR LPDIRECTDRAWSURFACE, :PTR IUnknown
 STDMETHOD DuplicateSurface, :PTR IDirectDraw, :LPDIRECTDRAWSURFACE, :PTR LPDIRECTDRAWSURFACE
 STDMETHOD EnumDisplayModes, :PTR IDirectDraw, :DWORD, :LPDDSURFACEDESC, :PTR , :PTR
 STDMETHOD EnumSurfaces, :PTR IDirectDraw, :DWORD, :LPDDSURFACEDESC, :PTR , :PTR
 STDMETHOD FlipToGDISurface, :PTR IDirectDraw
 STDMETHOD GetCaps, :PTR IDirectDraw, :LPDDCAPS, :LPDDCAPS
 STDMETHOD GetDisplayMode, :PTR IDirectDraw, :LPDDSURFACEDESC
 STDMETHOD GetFourCCCodes, :PTR IDirectDraw, :PTR DWORD, :PTR DWORD
 STDMETHOD GetGDISurface, :PTR IDirectDraw, :PTR LPDIRECTDRAWSURFACE
 STDMETHOD GetMonitorFrequency, :PTR IDirectDraw, :DWORD
 STDMETHOD GetScanLine, :PTR IDirectDraw, :DWORD
 STDMETHOD GetVerticalBlankStatus, :PTR IDirectDraw, :PTR SWORD
 STDMETHOD Initialize, :PTR IDirectDraw, :PTR GUID
 STDMETHOD RestoreDisplayMode, :PTR IDirectDraw
 STDMETHOD SetCooperativeLevel, :PTR IDirectDraw, :HWND, :DWORD
 STDMETHOD SetDisplayMode, :PTR IDirectDraw, :DWORD, :DWORD, :DWORD
 STDMETHOD WaitForVerticalBlank, :PTR IDirectDraw, :DWORD, :PTR
IDirectDrawVtbl ENDS


IDirectDrawPaletteVtbl:
 ; IUnknown methods
 STDMETHOD QueryInterface, :PTR IDirectDrawPalette, :PTR, :PTR PTR
 STDMETHOD AddRef, :PTR IDirectDrawPalette
 STDMETHOD Release, :PTR IDirectDrawPalette
 ; IDirectDrawPalette methods
 STDMETHOD GetCaps, :PTR IDirectDrawPalette, :PTR DWORD
 STDMETHOD GetEntries, :PTR IDirectDrawPalette, :DWORD, :DWORD, :DWORD, :LPPALETTEENTRY
 STDMETHOD Initialize, :PTR IDirectDrawPalette, :LPDIRECTDRAW, :DWORD, :LPPALETTEENTRY
 STDMETHOD SetEntries, :PTR IDirectDrawPalette, :DWORD, :DWORD, :DWORD, :LPPALETTEENTRY
IDirectDrawPaletteVtbl ENDS


IDirectDrawClipperVtbl:
 ; IUnknown methods
 STDMETHOD QueryInterface, :PTR IDirectDrawClipper, :PTR, :PTR PTR
 STDMETHOD AddRef, :PTR IDirectDrawClipper
 STDMETHOD Release, :PTR IDirectDrawClipper
 ; IDirectDrawClipper methods
 STDMETHOD GetClipList, :PTR IDirectDrawClipper, :LPRECT, :LPRGNDATA, :PTR DWORD
 STDMETHOD GetHWnd, :PTR IDirectDrawClipper, :PTR HWND
 STDMETHOD Initialize, :PTR IDirectDrawClipper, :LPDIRECTDRAW, :DWORD
 STDMETHOD IsClipListChanged, :PTR IDirectDrawClipper, :PTR SWORD
 STDMETHOD SetClipList, :PTR IDirectDrawClipper, :LPRGNDATA, :DWORD
 STDMETHOD SetHWnd, :PTR IDirectDrawClipper, :DWORD, :HWND
IDirectDrawClipperVtbl ENDS


IDirectDrawSurfaceVtbl:
 ; IUnknown methods
 STDMETHOD QueryInterface, :PTR IDirectDrawSurface, :PTR, :PTR PTR
 STDMETHOD AddRef, :PTR IDirectDrawSurface
 STDMETHOD Release, :PTR IDirectDrawSurface
 ; IDirectDrawSurface methods
 STDMETHOD AddAttachedSurface, :PTR IDirectDrawSurface, :LPDIRECTDRAWSURFACE
 STDMETHOD AddOverlayDirtyRect, :PTR IDirectDrawSurface, :LPRECT
 STDMETHOD Blt, :PTR IDirectDrawSurface, :LPRECT, :LPDIRECTDRAWSURFACE, :LPRECT, :DWORD, :LPDDBLTFX
 STDMETHOD BltBatch, :PTR IDirectDrawSurface, :LPDDBLTBATCH, :DWORD, :DWORD
 STDMETHOD BltFast, :PTR IDirectDrawSurface, :DWORD, :DWORD, :LPDIRECTDRAWSURFACE, :LPRECT, :DWORD
 STDMETHOD DeleteAttachedSurface, :PTR IDirectDrawSurface, :DWORD, :LPDIRECTDRAWSURFACE
 STDMETHOD EnumAttachedSurfaces, :PTR IDirectDrawSurface, :PTR , :PTR
 STDMETHOD EnumOverlayZOrders, :PTR IDirectDrawSurface, :DWORD, :PTR , :PTR
 STDMETHOD Flip, :PTR IDirectDrawSurface, :LPDIRECTDRAWSURFACE, :DWORD
 STDMETHOD GetAttachedSurface, :PTR IDirectDrawSurface, :LPDDSCAPS, :PTR LPDIRECTDRAWSURFACE
 STDMETHOD GetBltStatus, :PTR IDirectDrawSurface, :DWORD
 STDMETHOD GetCaps, :PTR IDirectDrawSurface, :LPDDSCAPS
 STDMETHOD GetClipper, :PTR IDirectDrawSurface, :PTR LPDIRECTDRAWCLIPPER
 STDMETHOD GetColorKey, :PTR IDirectDrawSurface, :DWORD, :LPDDCOLORKEY
 STDMETHOD GetDC, :PTR IDirectDrawSurface, :PTR HDC
 STDMETHOD GetFlipStatus, :PTR IDirectDrawSurface, :DWORD
 STDMETHOD GetOverlayPosition, :PTR IDirectDrawSurface, :PTR DWORD, :PTR DWORD
 STDMETHOD GetPalette, :PTR IDirectDrawSurface, :PTR LPDIRECTDRAWPALETTE
 STDMETHOD GetPixelFormat, :PTR IDirectDrawSurface, :LPDDPIXELFORMAT
 STDMETHOD GetSurfaceDesc, :PTR IDirectDrawSurface, :LPDDSURFACEDESC
 STDMETHOD Initialize, :PTR IDirectDrawSurface, :LPDIRECTDRAW, :LPDDSURFACEDESC
 STDMETHOD IsLost, :PTR IDirectDrawSurface
 STDMETHOD mLock, :PTR IDirectDrawSurface, :LPRECT, :LPDDSURFACEDESC, :DWORD, :PTR 
 STDMETHOD ReleaseDC, :PTR IDirectDrawSurface, :HDC
 STDMETHOD Restore, :PTR IDirectDrawSurface
 STDMETHOD SetClipper, :PTR IDirectDrawSurface, :LPDIRECTDRAWCLIPPER
 STDMETHOD SetColorKey, :PTR IDirectDrawSurface, :DWORD, :LPDDCOLORKEY
 STDMETHOD SetOverlayPosition, :PTR IDirectDrawSurface, :SDWORD, :SDWORD
 STDMETHOD SetPalette, :PTR IDirectDrawSurface, :LPDIRECTDRAWPALETTE
 STDMETHOD Unlock, :PTR IDirectDrawSurface, :PTR 
 STDMETHOD UpdateOverlay, :PTR IDirectDrawSurface, :LPRECT, :LPDIRECTDRAWSURFACE, :LPRECT, :DWORD, :LPDDOVERLAYFX
 STDMETHOD UpdateOverlayDisplay, :PTR IDirectDrawSurface, :DWORD
 STDMETHOD UpdateOverlayZOrder, :PTR IDirectDrawSurface, :DWORD, :LPDIRECTDRAWSURFACE
IDirectDrawSurfaceVtbl ENDS


; Direct Draw Capability Flags:

[DDSD_CAPS 01
 DDSD_HEIGHT 02
 DDSD_WIDTH 04
 DDSD_PITCH 08
 DDSD_BACKBUFFERCOUNT 020
 DDSD_ZBUFFERBITDEPTH 040
 DDSD_ALPHABITDEPTH 080
 DDSD_PIXELFORMAT 01000
 DDSD_CKDESTOVERLAY 02000
 DDSD_CKDESTBLT 04000
 DDSD_CKSRCOVERLAY 08000
 DDSD_CKSRCBLT 010000
 DDSD_MIPMAPCOUNT 020000
 DDSD_REFRESHRATE 040000
 DDSD_ALL 07f9ee] ; all input field are valid 

; DIRECTDRAWSURFACE CAPABILITY FLAGS:

[DDSCAPS_3D 01
 DDSCAPS_ALPHA 02
 DDSCAPS_BACKBUFFER 04
 DDSCAPS_COMPLEX 08
 DDSCAPS_FLIP 010
 DDSCAPS_FRONTBUFFER 020
 DDSCAPS_OFFSCREENPLAIN 040
 DDSCAPS_OVERLAY 080
 DDSCAPS_PALETTE 0100
 DDSCAPS_PRIMARYSURFACE 0200
 DDSCAPS_PRIMARYSURFACELEFT 0400
 DDSCAPS_SYSTEMMEMORY 0800
 DDSCAPS_TEXTURE 01000
 DDSCAPS_3DDEVICE 02000
 DDSCAPS_VIDEOMEMORY 04000
 DDSCAPS_VISIBLE 08000
 DDSCAPS_WRITEONLY 010000
 DDSCAPS_ZBUFFER 020000
 DDSCAPS_OWNDC 040000
 DDSCAPS_LIVEVIDEO 080000
 DDSCAPS_HWCODEC 0100000
 DDSCAPS_MODEX 0200000
 DDSCAPS_MIPMAP 0400000
 DDSCAPS_ALLOCONLOAD 04000000]

; DIRECTDRAW DRIVER CAPABILITY FLAGS:

[DDCAPS_3D 01
 DDCAPS_ALIGNBOUNDARYDEST 02
 DDCAPS_ALIGNSIZEDEST 04
 DDCAPS_ALIGNBOUNDARYSRC 08
 DDCAPS_ALIGNSIZESRC 010
 DDCAPS_ALIGNSTRIDE 020
 DDCAPS_BLT 040
 DDCAPS_BLTQUEUE 080
 DDCAPS_BLTFOURCC 0100
 DDCAPS_BLTSTRETCH 0200
 DDCAPS_GDI 0400
 DDCAPS_OVERLAY 0800
 DDCAPS_OVERLAYCANTCLIP 01000
 DDCAPS_OVERLAYFOURCC 02000
 DDCAPS_OVERLAYSTRETCH 04000
 DDCAPS_PALETTE 08000
 DDCAPS_PALETTEVSYNC 010000
 DDCAPS_READSCANLINE 020000
 DDCAPS_STEREOVIEW 040000
 DDCAPS_VBI 080000
 DDCAPS_ZBLTS 0100000
 DDCAPS_ZOVERLAYS 0200000
 DDCAPS_COLORKEY 0400000
 DDCAPS_ALPHA 0800000
 DDCAPS_COLORKEYHWASSIST 01000000
 DDCAPS_NOHARDWARE 02000000
 DDCAPS_BLTCOLORFILL 04000000
 DDCAPS_BANKSWITCHED 08000000
 DDCAPS_BLTDEPTHFILL 010000000
 DDCAPS_CANCLIP 020000000
 DDCAPS_CANCLIPSTRETCHED 040000000
 DDCAPS_CANBLTSYSMEM 080000000]

; DIRECTDRAW FX ALPHA CAPABILITY FLAGS:

[DDFXALPHACAPS_BLTALPHAEDGEBLEND 01
 DDFXALPHACAPS_BLTALPHAPIXELS 02
 DDFXALPHACAPS_BLTALPHAPIXELSNEG 04
 DDFXALPHACAPS_BLTALPHASURFACES 08
 DDFXALPHACAPS_BLTALPHASURFACESNEG 010
 DDFXALPHACAPS_OVERLAYALPHAEDGEBLEND 020
 DDFXALPHACAPS_OVERLAYALPHAPIXELS 040
 DDFXALPHACAPS_OVERLAYALPHAPIXELSNEG 080
 DDFXALPHACAPS_OVERLAYALPHASURFACES 0100
 DDFXALPHACAPS_OVERLAYALPHASURFACESNEG 0200]

; DIRECTDRAW FX CAPABILITY FLAGS:

[DDFXCAPS_BLTARITHSTRETCHY 020
 DDFXCAPS_BLTARITHSTRETCHYN 010
 DDFXCAPS_BLTMIRRORLEFTRIGHT 040
 DDFXCAPS_BLTMIRRORUPDOWN 080
 DDFXCAPS_BLTROTATION 0100
 DDFXCAPS_BLTROTATION90 0200
 DDFXCAPS_BLTSHRINKX 0400
 DDFXCAPS_BLTSHRINKXN 0800
 DDFXCAPS_BLTSHRINKY 01000
 DDFXCAPS_BLTSHRINKYN 02000
 DDFXCAPS_BLTSTRETCHX 04000
 DDFXCAPS_BLTSTRETCHXN 08000
 DDFXCAPS_BLTSTRETCHY 010000
 DDFXCAPS_BLTSTRETCHYN 020000
 DDFXCAPS_OVERLAYARITHSTRETCHY 040000
 DDFXCAPS_OVERLAYARITHSTRETCHYN 08
 DDFXCAPS_OVERLAYSHRINKX 080000
 DDFXCAPS_OVERLAYSHRINKXN 0100000
 DDFXCAPS_OVERLAYSHRINKY 0200000
 DDFXCAPS_OVERLAYSHRINKYN 0400000
 DDFXCAPS_OVERLAYSTRETCHX 0800000
 DDFXCAPS_OVERLAYSTRETCHXN 01000000
 DDFXCAPS_OVERLAYSTRETCHY 02000000
 DDFXCAPS_OVERLAYSTRETCHYN 04000000
 DDFXCAPS_OVERLAYMIRRORLEFTRIGHT 08000000
 DDFXCAPS_OVERLAYMIRRORUPDOWN 010000000]

; DIRECTDRAW STEREO VIEW CAPABILITIES:

[DDSVCAPS_ENIGMA 01
 DDSVCAPS_FLICKER 02
 DDSVCAPS_REDBLUE 04
 DDSVCAPS_SPLIT 08]

; DIRECTDRAWPALETTE CAPABILITIES:

[DDPCAPS_4BIT 01
 DDPCAPS_8BITENTRIES 02
 DDPCAPS_8BIT 04
 DDPCAPS_INITIALIZE 08
 DDPCAPS_PRIMARYSURFACE 010
 DDPCAPS_PRIMARYSURFACELEFT 020
 DDPCAPS_ALLOW256 040
 DDPCAPS_VSYNC 080
 DDPCAPS_1BIT 0100
 DDPCAPS_2BIT 0200]

; DIRECTDRAW BITDEPTH CONSTANTS:

[DDBD_1 04000
 DDBD_2 02000
 DDBD_4 01000
 DDBD_8 0800
 DDBD_16 0400
 DDBD_24 0200
 DDBD_32 0100]

; DIRECTDRAWSURFACE SET/GET COLOR KEY FLAGS:

[DDCKEY_COLORSPACE 01
 DDCKEY_DESTBLT 02
 DDCKEY_DESTOVERLAY 04
 DDCKEY_SRCBLT 08
 DDCKEY_SRCOVERLAY 010]

; DIRECTDRAW COLOR KEY CAPABILITY FLAGS:

[DDCKEYCAPS_DESTBLT 01
 DDCKEYCAPS_DESTBLTCLRSPACE 02
 DDCKEYCAPS_DESTBLTCLRSPACEYUV 04
 DDCKEYCAPS_DESTBLTYUV 08
 DDCKEYCAPS_DESTOVERLAY 010
 DDCKEYCAPS_DESTOVERLAYCLRSPACE 020
 DDCKEYCAPS_DESTOVERLAYCLRSPACEYUV 040
 DDCKEYCAPS_DESTOVERLAYONEACTIVE 080
 DDCKEYCAPS_DESTOVERLAYYUV 0100
 DDCKEYCAPS_SRCBLT 0200
 DDCKEYCAPS_SRCBLTCLRSPACE 0400
 DDCKEYCAPS_SRCBLTCLRSPACEYUV 0800
 DDCKEYCAPS_SRCBLTYUV 01000
 DDCKEYCAPS_SRCOVERLAY 02000
 DDCKEYCAPS_SRCOVERLAYCLRSPACE 04000
 DDCKEYCAPS_SRCOVERLAYCLRSPACEYUV 08000
 DDCKEYCAPS_SRCOVERLAYONEACTIVE 010000
 DDCKEYCAPS_SRCOVERLAYYUV 020000
 DDCKEYCAPS_NOCOSTOVERLAY 040000]

; DIRECTDRAW PIXELFORMAT FLAGS:

[DDPF_ALPHAPIXELS 01
 DDPF_ALPHA 02
 DDPF_FOURCC 04
 DDPF_PALETTEINDEXED4 08
 DDPF_PALETTEINDEXEDTO8 010
 DDPF_PALETTEINDEXED8 020
 DDPF_RGB 040
 DDPF_COMPRESSED 080
 DDPF_RGBTOYUV 0100
 DDPF_YUV 0200
 DDPF_ZBUFFER 0400
 DDPF_PALETTEINDEXED1 0800
 DDPF_PALETTEINDEXED2 01000]

; DIRECTDRAW ENUMSURFACES FLAGS:

[DDENUMSURFACES_ALL 01
 DDENUMSURFACES_MATCH 02
 DDENUMSURFACES_NOMATCH 04
 DDENUMSURFACES_CANBECREATED 08
 DDENUMSURFACES_DOESEXIST 010]

; DIRECTDRAW ENUMDISPLAYMODES FLAGS:

[DDEDM_REFRESHRATES 01]

; DIRECTDRAW SETCOOPERATIVELEVEL FLAGS:

[DDSCL_FULLSCREEN 01
 DDSCL_ALLOWREBOOT 02
 DDSCL_NOWINDOWCHANGES 04
 DDSCL_NORMAL 08
 DDSCL_EXCLUSIVE 010
 DDSCL_ALLOWMODEX 040]

; DIRECTDRAW BLT FLAGS:

[DDBLT_ALPHADEST 01
 DDBLT_ALPHADESTCONSTOVERRIDE 02
 DDBLT_ALPHADESTNEG 04
 DDBLT_ALPHADESTSURFACEOVERRIDE 08
 DDBLT_ALPHAEDGEBLEND 010
 DDBLT_ALPHASRC 020
 DDBLT_ALPHASRCCONSTOVERRIDE 040
 DDBLT_ALPHASRCNEG 080
 DDBLT_ALPHASRCSURFACEOVERRIDE 0100
 DDBLT_ASYNC 0200
 DDBLT_COLORFILL 0400
 DDBLT_DDFX 0800
 DDBLT_DDROPS 01000
 DDBLT_KEYDEST 02000
 DDBLT_KEYDESTOVERRIDE 04000
 DDBLT_KEYSRC 08000
 DDBLT_KEYSRCOVERRIDE 010000
 DDBLT_ROP 020000
 DDBLT_ROTATIONANGLE 040000
 DDBLT_ZBUFFER 080000
 DDBLT_ZBUFFERDESTCONSTOVERRIDE 0100000
 DDBLT_ZBUFFERDESTOVERRIDE 0200000
 DDBLT_ZBUFFERSRCCONSTOVERRIDE 0400000
 DDBLT_ZBUFFERSRCOVERRIDE 0800000
 DDBLT_WAIT 01000000
 DDBLT_DEPTHFILL 02000000]

; BLTFAST FLAGS:

[DDBLTFAST_NOCOLORKEY 0
 DDBLTFAST_SRCCOLORKEY 01
 DDBLTFAST_DESTCOLORKEY 02
 DDBLTFAST_WAIT 010]

; FLIP FLAGS:

[DDFLIP_WAIT 01]

; DIRECTDRAW SURFACE OVERLAY FLAGS:

[DDOVER_ALPHADEST 01
 DDOVER_ALPHADESTCONSTOVERRIDE 02
 DDOVER_ALPHADESTNEG 04
 DDOVER_ALPHADESTSURFACEOVERRIDE 08
 DDOVER_ALPHAEDGEBLEND 010
 DDOVER_ALPHASRC 020
 DDOVER_ALPHASRCCONSTOVERRIDE 040
 DDOVER_ALPHASRCNEG 080
 DDOVER_ALPHASRCSURFACEOVERRIDE 0100
 DDOVER_HIDE 0200
 DDOVER_KEYDEST 0400
 DDOVER_KEYDESTOVERRIDE 0800
 DDOVER_KEYSRC 01000
 DDOVER_KEYSRCOVERRIDE 02000
 DDOVER_SHOW 04000
 DDOVER_ADDDIRTYRECT 08000
 DDOVER_REFRESHDIRTYRECTS 010000
 DDOVER_REFRESHALL 020000
 DDOVER_DDFX 080000]

; DIRECTDRAWSURFACE LOCK FLAGS:

[DDLOCK_SURFACEMEMORYPTR 0
 DDLOCK_WAIT 01
 DDLOCK_EVENT 02
 DDLOCK_READONLY 010
 DDLOCK_WRITEONLY 020]

; DIRECTDRAWSURFACE BLT FX FLAGS:

[DDBLTFX_ARITHSTRETCHY 01
 DDBLTFX_MIRRORLEFTRIGHT 02
 DDBLTFX_MIRRORUPDOWN 04
 DDBLTFX_NOTEARING 08
 DDBLTFX_ROTATE180 010
 DDBLTFX_ROTATE270 020
 DDBLTFX_ROTATE90 040
 DDBLTFX_ZBUFFERRANGE 080
 DDBLTFX_ZBUFFERBASEDEST 0100]

; DIRECTDRAWSURFACE OVERLAY FX FLAGS:

[DDOVERFX_ARITHSTRETCHY 01
 DDOVERFX_MIRRORLEFTRIGHT 02
 DDOVERFX_MIRRORUPDOWN 04]

; DIRECTDRAW WAITFORVERTICALBLANK FLAGS:

[DDWAITVB_BLOCKBEGIN 01
 DDGFS_CANFLIP 01
 DDGFS_ISFLIPDONE 02]

; DIRECTDRAW GETBLTSTATUS FLAGS:

[DDGBS_CANBLT 01
 DDGBS_ISBLTDONE 02]

; DIRECTDRAW ENUMOVERLAYZORDER FLAGS:

[DDENUMOVERLAYZ_BACKTOFRONT 0
 DDENUMOVERLAYZ_FRONTTOBACK 01]

; DIRECTDRAW UPDATEOVERLAYZORDER FLAGS:

[DDOVERZ_SENDTOFRONT 0
 DDOVERZ_SENDTOBACK 01
 DDOVERZ_MOVEFORWARD 02
 DDOVERZ_MOVEBACKWARD 03
 DDOVERZ_INSERTINFRONTOF 04
 DDOVERZ_INSERTINBACKOF 05]


; DIRECTDRAW RETURN CODES

; Issued by: DirectDraw Commands and all callbacks:

[DD_OK 0] ; Status is OK

; DIRECTDRAW ENUMCALLBACK RETURN VALUES:

[DDENUMRET_CANCEL 0 ; stop the enumeration
 DDENUMRET_OK 1] ; continue the enumeration

; DIRECTDRAW ERRORS:

[DDERR_ALREADYINITIALIZED 088760005h
 DDERR_CANNOTATTACHSURFACE 08876000a
 DDERR_CANNOTDETACHSURFACE 088760014
 DDERR_CURRENTLYNOTAVAIL 088760028
 DDERR_EXCEPTION 088760037
 DDERR_GENERIC 080004005
 DDERR_HEIGHTALIGN 08876005a
 DDERR_INCOMPATIBLEPRIMARY 08876005f
 DDERR_INVALIDCAPS 088760064
 DDERR_INVALIDCLIPLIST 08876006e
 DDERR_INVALIDMODE 088760078
 DDERR_INVALIDOBJECT 088760082
 DDERR_INVALIDPARAMS 080070057
 DDERR_INVALIDPIXELFORMAT 088760091
 DDERR_INVALIDRECT 088760096
 DDERR_LOCKEDSURFACES 0887600a0
 DDERR_NO3D 0887600aa
 DDERR_NOALPHAHW 0887600b4
 DDERR_NOCLIPLIST 0887600cd
 DDERR_NOCOLORCONVHW 0887600d2
 DDERR_NOCOOPERATIVELEVELSET 0887600d4
 DDERR_NOCOLORKEY 0887600d7
 DDERR_NOCOLORKEYHW 0887600dc
 DDERR_NODIRECTDRAWSUPPORT 0887600de
 DDERR_NOEXCLUSIVEMODE 0887600e1
 DDERR_NOFLIPHW 0887600e6
 DDERR_NOGDI 0887600f0
 DDERR_NOMIRRORHW 0887600fa
 DDERR_NOTFOUND 0887600ff
 DDERR_NOOVERLAYHW 088760104
 DDERR_NORASTEROPHW 088760118
 DDERR_NOROTATIONHW 088760122
 DDERR_NOSTRETCHHW 088760136
 DDERR_NOT4BITCOLOR 08876013c
 DDERR_NOT4BITCOLORINDEX 08876013d
 DDERR_NOT8BITCOLOR 088760140
 DDERR_NOTEXTUREHW 08876014a
 DDERR_NOVSYNCHW 08876014f
 DDERR_NOZBUFFERHW 088760154
 DDERR_NOZOVERLAYHW 08876015e
 DDERR_OUTOFCAPS 088760168
 DDERR_OUTOFMEMORY 08007000e
 DDERR_OUTOFVIDEOMEMORY 08876017c
 DDERR_OVERLAYCANTCLIP 08876017e
 DDERR_OVERLAYCOLORKEYONLYONEACTIVE 088760180
 DDERR_PALETTEBUSY 088760183
 DDERR_COLORKEYNOTSET 088760190
 DDERR_SURFACEALREADYATTACHED 08876019a
 DDERR_SURFACEALREADYDEPENDENT 0887601a4
 DDERR_SURFACEBUSY 0887601ae
 DDERR_CANTLOCKSURFACE 0887601b3
 DDERR_SURFACEISOBSCURED 0887601b8
 DDERR_SURFACELOST 0887601c2
 DDERR_SURFACENOTATTACHED 0887601cc
 DDERR_TOOBIGHEIGHT 0887601d6
 DDERR_TOOBIGSIZE 0887601e0
 DDERR_TOOBIGWIDTH 0887601ea
 DDERR_UNSUPPORTED 080004001
 DDERR_UNSUPPORTEDFORMAT 0887601fe
 DDERR_UNSUPPORTEDMASK 088760208
 DDERR_VERTICALBLANKINPROGRESS 088760219
 DDERR_WASSTILLDRAWING 08876021c
 DDERR_XALIGN 088760230
 DDERR_INVALIDDIRECTDRAWGUID 088760231
 DDERR_DIRECTDRAWALREADYCREATED 088760232
 DDERR_NODIRECTDRAWHW 088760233
 DDERR_PRIMARYSURFACEALREADYEXISTS 088760234
 DDERR_NOEMULATION 088760235
 DDERR_REGIONTOOSMALL 088760236
 DDERR_CLIPPERISUSINGHWND 088760237
 DDERR_NOCLIPPERATTACHED 088760238
 DDERR_NOHWND 088760239
 DDERR_HWNDSUBCLASSED 08876023a
 DDERR_HWNDALREADYSET 08876023b
 DDERR_NOPALETTEATTACHED 08876023c
 DDERR_NOPALETTEHW 08876023d
 DDERR_BLTFASTCANTCLIP 08876023e
 DDERR_NOBLTHW 08876023f
 DDERR_NODDROPSHW 088760240
 DDERR_OVERLAYNOTVISIBLE 088760241
 DDERR_NOOVERLAYDEST 088760242
 DDERR_INVALIDPOSITION 088760243
 DDERR_NOTAOVERLAYSURFACE 088760244
 DDERR_EXCLUSIVEMODEALREADYSET 088760245
 DDERR_NOTFLIPPABLE 088760246
 DDERR_CANTDUPLICATE 088760247
 DDERR_NOTLOCKED 088760248
 DDERR_CANTCREATEDC 088760249
 DDERR_NODC 08876024a
 DDERR_WRONGMODE 08876024b
 DDERR_IMPLICITLYCREATED 08876024c
 DDERR_NOTPALETTIZED 08876024d
 DDERR_UNSUPPORTEDMODE 08876024e
 DDERR_NOMIPMAPHW 08876024f
 DDERR_INVALIDSURFACETYPE 088760250
 DDERR_DCALREADYCREATED 08876026c
 DDERR_CANTPAGELOCK 088760280
 DDERR_CANTPAGEUNLOCK 088760294
 DDERR_NOTPAGELOCKED 0887602a8
 DDERR_NOTINITIALIZED 0800401f0]

