;
; ProExec - Protected Execution - (c)1998 By Virogen
;
; Well I wrote this utility in about 15 minutes, so there's not
; much to it. What it does do is simply executes the specified
; program (in PROEXEC.INI) and monitors the applications status.
; If the program crashes, then ProExec attempts asks the user
; if they wish to reload it. This is especially handy for
; win32 shells such as litestep.
;
; The PROEXEC.INI file should contain the section "[proexec]"
; and the value "execute". Set the execute value to the full
; path and filename of the proggie you want to protect from
; crashing.
;
;
.386
locals
jumps
.model flat,STDCALL
L equ <LARGE>                 

; our needed APIs
extrn WinExec:PROC
extrn ExitProcess:PROC
extrn MessageBoxA:PROC                  
extrn GetPrivateProfileStringA:PROC
extrn CreateProcessA:PROC
extrn GetStartupInfoA:PROC
extrn WaitForSingleObject:PROC
extrn CloseHandle:PROC

; our equates
MB_ICONEXCLAMATION equ 30h        
MB_YESNO equ 4
MB_ICONQUESTION equ 32
IDYES equ 6
INFINITE equ 4294967295                

.data

profile_name db 'PROEXEC.INI',0
default_name db 'd',0
key_name db 'execute',0
app_name db 'proexec',0
bad_ini_text db 'Error: PROEXEC.INI is not properly set up. Perhaps it''s not in a directory contained in your %path% environment?',0,0
bad_exec_text db 'Error executing: '
mb_pname2 db 255 dup(0)
caption db 'Protected Execution - (c)1998 By Virogen',0
re_exec_text db 'Program terminated. Do you wish to re-execute '
mb_pname db 255 dup(0)
prog_name db 260 dup(0)
sinfo dd 20 dup(0) ; big nuff i think
pinfo:
hprocess dd 0                   
hthread dd 0
pid dd 0
tid dd 0

.code
start:
        
        push offset profile_name
        push 260
        push offset prog_name
        push offset default_name
        push offset key_name
        push offset app_name
        call GetPrivateProfileStringA
        cmp eax,1
        jz exit_bad_ini
       
        push offset sinfo
        call GetStartupInfoA          
        
exec_loop:
        push offset pinfo
        push offset sinfo
        push 0                        
        push 0                        
        push 0                          ; flags - may need to set 'em
        push 0
        push 0
        push 0
        push 0
        push offset prog_name
        call CreateProcessA
        or eax,eax
        jz exit_exec

        push INFINITE
        push hprocess
        call WaitForSingleObject

        lea esi,prog_name
        lea edi,mb_pname
        call copy_str
        call set_q

        push MB_ICONQUESTION or MB_YESNO
        push offset caption
        push offset re_exec_text
        push 0
        call MessageBoxA
        cmp eax,IDYES
        jz exec_loop

        push hprocess
        call CloseHandle
        jmp _exit


exit_bad_ini:
        lea esi,bad_ini_text
        jmp _exitmb
exit_exec:
        lea esi,prog_name
        lea edi,mb_pname2
        call copy_str

        lea esi,bad_exec_text
_exitmb:
        push MB_ICONEXCLAMATION
        push offset caption
        push esi
        push 0
        call MessageBoxA
_exit:
        push 0
        call ExitProcess

copy_str:
        mov ecx,0FFh                            
copystr:
        lodsb
        stosb
        cmp al,0
        jz copystrdone
        loop copystr
copystrdone:
        ret

set_q:
        dec edi
        mov al,'?'
        stosb
        xor eax,eax
        stosb
        ret

ends
end start
        








