comment %
	This is test file for TR.
	%
model tiny
locals
.data
	begmsg	db	'???? Test Begin $'
	okmsg	db	'OK',13,10,'$'
	badmsg	db	'Bad =????',13,10,'$'
	buffer	db	200h	dup(?)
mac	MACRO   fname,nn
	dw	fname
	dw	nn
ENDM

	test_list:
;---- basic opcode test 001~0ff-----
	mac	test_001,1
	mac	test_002,2
	mac	test_003,3	;seta
	mac	test_004,4	;E8,E9
	mac	test_005,5	;sub ecx
	mac	test_006,6	;jump in code
	mac	test_008,8	;call far
	mac	test_009,9	;jmp bx
	mac	test_00a,0ah	;rep movsb
	mac	test_00b,0bh	;ret[f]
	mac	test_00c,0ch	;d6 setalc
	mac	test_00d,0dh	;
;---- anti debug trick test 101~7ff-----
	mac	test_101,101h	;div small again
	mac	test_102,102h	;TF test
	mac	test_103,103h	;F1
	mac	test_104,104h	;TF
	mac	test_105,105h	;keyboard off
	mac	test_106,106h	;div 0
	mac	test_107,107h	;flag
	mac	test_108,108h	;Crx Drx
	mac	test_109,109h	;Crx Drx
	mac	test_110,110h	;empty stack
	mac	test_111,111h	;if TF
	mac	test_112,112h	;new int21
	mac	test_113,113h	;port 21
	mac	test_114,114h	;fs:[46c]
	mac	test_115,115h	;int21/4c
	mac	test_116,116h	;
;---- tem save & compatible problem test 801~-----
	;mac	test_801,801h	;int c
	;mac	test_802,802h	;ff ff
	;mac	test_803,803h	;highmem
	mac	test_804,804h	;int 8,win95 not support ?
	;mac	test_805,805h	;in 36c

	test_list_end:
.code
.386p
	org	100h
start:	jmp	begin
;for unasm test
	db	0fh,21h,0f8h	;mov eax,dr7
	db	0fh,23h,0ebh	;mov dr5,ebx
	db	0fh,0a0h	;push	fs
	db	0fh,0a1h	;pop	fs
begin:
;	mov	ax,@data
;	mov	ds,ax
	lea	dx,okmsg
	mov	ah,9
	int	21h
	call	test_proc
	int	20h

test_proc	proc
	mov	bx,offset test_list
@@1:	
	call	disp_begin_msg

	push	bx ds es
	call	[bx]		;return ax=0 means test OK
	pop	es ds
	call	disp_ifOK
	pop	bx

	add	bx,4
	cmp	bx,offset test_list_end
	jb	@@1
	
	ret
	endp
	;-----------------------------
disp_begin_msg	proc
	mov	ax,[bx+2]
	lea	di,begmsg
	call	word2hex
	lea	dx,begmsg
	mov	ah,9
	int	21h
	ret
	endp
	;-----------------------------
disp_ifOK:
	test	ax,ax
	jz	@@ok
	lea	di,badmsg+5
	call	word2hex
	lea	dx,badmsg
	jmp	@@2
@@ok:	lea	dx,okmsg
@@2:
	mov	ah,9
	int	21h
	ret
	;-----------------------------
word2hex:
	cld
	PUSH	AX
	MOV	AL,AH
	CALL	BYTE2HEX
	POP	AX
RER:
BYTE2HEX:
	AAM	10H
	CALL	@@1
@@1:	XCHG	AL,AH
	ADD 	AL,90H
	DAA
	ADC 	AL,40H
	DAA
	STOSB
	RET
	
	ret
hook	macro	n,addr,savaddr
	ifb	<savaddr>
		call	hookproc0 C,n*4,offset addr
	else
		call	hookproc C,n*4,offset addr,offset savaddr
	endif
	endm
unhook	macro	n,savaddr
	ifb	<n>
		call	unhookproc0
	else
		call	unhookproc C,n*4, offset savaddr
	endif
	endm
;###############################################################
;-----------------------------------------------
test_116:		  
	xor	ax,ax
	ret
;-----------------------------------------------
test_00d:
	mov	di,offset @@e
	mov	cx,100h
	mov	bl,25h
	xor	dx,dx
	xor	ax,ax
@@1:
	MOV	AL,cs:[DI]
	NOT	AL
	ROL	AL,0DDh
	XOR	AL,0BEh
	ROR	AL,03Ah
	XOR	AL,BL  
	add	dx,ax    
	inc	di
	LOOP	@@1
	mov	ax,dx
	sub	ax,7bd4h
@@e:	ret
;-----------------------------------------------
test_00c:		;d6 setalc
	mov	ax,33h
	clc
	db	0d6h	;setalc
	test	al,al
	jnz	@@1
	stc
	db	0d6h
	xor	al,0ffh
@@1:
	ret

;-----------------------------------------------
test_805:		;in 36ch
	xor	ax,ax
	MOV	DX,036Ch
	IN	AL,DX
	CMP	AL,00
	JNE	@@1	
	;somebody say: TR_AND_WINDOWS_FOUND
	;but I find even in pure DOS al=0ff
@@1:	ret
;-----------------------------------------------
test_115:		;int21/4c 
	xor	ax,ax	;Zenix, shall I add here ?
	ret
;-----------------------------------------------
test_101:		;test div small
	hook	0,@@new0

	call	@@test_proc

	mov	ax,bx
	sub	ax,1103h
	unhook
	ret
@@new0:
	inc	bx
	iret
@@test_proc:
	mov	ax,4fdh
	mov	dx,1102h
	mov	bx,1000h
	div	bx
	nop
	nop
	ret
;-----------------------------------------------
test_005:		;test sub ecx
	push	1234h
	push	5432h
	pop	ecx
	sub	ecx,22223333h
	mov	eax,ecx
	shr	ecx,16
	sub	ax,cx
	sub	ax,30edh
	ret
	
;-----------------------------------------------
test_004:		;test E8,E9
	MOV	AX,1
	DB	0E8h,2,0	;call	next+2
	inc	ax
	inc	ax

	pop	bx
	DB	0E9h,2,0	;call	next+2
	inc	ax
	inc	ax
	dec	ax
	RET
;-----------------------------------------------
test_00a:		;test rep movsd
	mov	si,offset @@1
	mov	di,offset buffer
	mov	cx,10h
	rep	movsd
	mov	ax,offset buffer
	jmp	ax
@@1:
	mov	ax,cx
	nop
	nop
	ret
;-----------------------------------------------
test_102:		;test TF
;	call	hookproc C,4,offset @@new1,offset @@sav1
	hook	1,@@new1
	hook	4,@@new4

	call	@@test_proc

	mov	ax,bx
	sub	ax,115h
	unhook	
	unhook	
	ret
@@new1:
	inc	bx
	iret
@@new4:
	inc	bh
	iret
F_TF    equ       100H

@@test_proc:
	sti
        xor	bx,bx	;counter
	pushf

	pushf
        pop	ax
        or	ax,F_TF
        push	ax
        popf
        nop
        nop
        int	1ch
        nop
        mov	al,7fh
        inc	al	;make OF(overflow flag)
        into
        nop
        mov	cx,6
        push	si
        rep	lodsb
        nop
        nop
        lodsb
        nop
        pop	si
        nop

        popf
	ret

;-----------------------------------------------
cint	dw	0
intn	dw	30	dup(0)
intbase	dd	30	dup(0)

hookproc0	proc	C n:word,addr:word
	push	ax bx
	mov	bx,cint
	mov	ax,n
	shl	bx,1
	mov	intn[bx],ax
	shl	bx,1
	call	hookproc C,n,addr,intbase[bx]
	inc	cint
	pop	bx ax
	ret
	endp
unhookproc0	proc
	push	ax bx
	dec	cint
	mov	bx,cint
	shl	bx,1
	mov	ax,intn[bx]
	shl	bx,1
	call	unhookproc C,ax,intbase[bx]
	pop	bx ax
	ret
	endp
hookproc	proc	C n:word,addr:word,savaddr:word
	push	ds ax bx si
	push 0
        pop	ds
	mov	bx,n
        mov	eax,ds:[bx]
	mov	si,savaddr
        mov	cs:[si],eax
        mov	ax,addr
        cli
        mov	ds:[bx],ax
        mov	ax,cs
        mov	ds:[bx+2],ax
        sti
        pop	si bx ax ds	
	ret
	endp
unhookproc	proc	C,n:word,savaddr:word
	push	ds ax bx dx
	push 0
        pop	ds
	mov	bx,savaddr
        mov	eax,cs:[bx]
	mov	bx,n
        mov	ds:[bx],eax
        pop	dx bx ax ds	
	ret
	endp
;-----------------------------------------------
test_801:		;test int c
intnum = 0ch
	push	ds
	push 0
        pop	ds
        mov	eax,[ds:intnum*4]
        mov	[cs:saveint],eax
        mov	ax,offset @@newint
        cli
        mov	[ds:intnum*4],ax
        mov	ax,cs
        mov	[ds:intnum*4+2],ax
        sti
        pop	ds

        call	@@testmain

	mov	ax,bx
	push	ds
	push 0
        pop	ds
        mov	ebx,[cs:saveint]
        mov	[ds:intnum*4],ebx
        pop	ds
	ret
@@testmain:
	xor	bx,bx

	xor	cx,cx
@@1:	nop
	sti
	loop	@@1

        sub	bx,1234h
	ret

@@newint:
	mov	bx,1234h
        iret
;-----------------------------------------------
test_802:		;test Ff ff
intnum = 6
	push	ds
	push 0
        pop	ds
        mov	eax,[ds:intnum*4]
        mov	[cs:saveint],eax
        mov	ax,offset @@newint
        cli
        mov	[ds:intnum*4],ax
        mov	ax,cs
        mov	[ds:intnum*4+2],ax
        sti
        pop	ds

        call	@@testmain

	mov	ax,bx
	push	ds
	push 0
        pop	ds
        mov	ebx,[cs:saveint]
        mov	[ds:intnum*4],ebx
        pop	ds
	ret
@@testmain:
	xor	bx,bx

        db	0ffh,0ffh	;!!!

        sub	bx,1234h
	ret

@@newint:
	mov	bx,1234h
        iret
;-----------------------------------------------
test_103:		;test F1
intnum = 1
	hook	1,@@newint,saveint

        call	@@testmain

	mov	ax,bx
	unhook	1,saveint
	ret
@@testmain:
	xor	bx,bx

        db	0f1h		;!!!

        sub	bx,1234h
	ret

@@newint:
	mov	bx,1234h
        iret
saveint	dd	0

;-----------------------------------------------
test_803:		;test highmem
	push	0
        pop	es
        mov	ax,word ptr [es:300h]
        add	ax,1234h

        mov     bx,0ff00h
        mov     ds,bx
        mov     si,01300h
        add     [si],word ptr 1234h
        int	1ch
        sub     ax,[es:300h]
  	sub     [si],word ptr 1234h
	ret
;-----------------------------------------------
test_00b:		;test ret[f] ??
	mov	dx,0
	push	ax
	push	ax
	push	offset @@1
	ret	4
	inc	dx
	inc	dx
@@1:	inc	dx
	inc	dx
	push	ax
	push	ax
	push	ax
	push	ax
	push	cs
	push	offset @@2
	retf	8
	inc	dx
	inc	dx
@@2:	inc	dx
	inc	dx
	mov	ax,dx
	sub	ax,4
	ret

;-----------------------------------------------
test_804:		;test int8
	PUSH      ES
	XOR       AX,AX
	MOV       ES,AX
	MOV       EAX,dword ptr [ES:0020h]
	MOV       dword ptr [CS:@@2],EAX
	MOV       BX,offset @@newint8
	MOV       [ES:0020h],BX
	MOV       [ES:0022h],CS
	POP       ES

	STI
	xor	cx,cx
@@1:	NOP
;	JMP       @@1
	nop
	loop	@@1
	xor	cx,cx
@@3:	NOP
	nop
	loop	@@3
	push	0
	pop	es
	mov	eax,dword ptr cs:[@@2]
	mov	dword ptr es:[20h],eax
	mov	ax,1
	ret

@@2:	dd	0
@@newint8:
	pop	ax
	pop	ax
	pop	ax
	push	0
	pop	es
	mov	eax,dword ptr cs:[@@2]
	mov	dword ptr es:[20h],eax
	xor	ax,ax
	ret
;-----------------------------------------------
test_104:		;test TF
	call	@@1
@@1:	pop	si
	XOR	AX,AX
	MOV	DS,AX
	PUSH	word ptr ds:[4]
	PUSH	word ptr ds:[6]
	ADD	SI,@@newint1-@@1
	MOV	ds:[4],SI
	MOV	ds:[6],CS
	mov	dx,0
	PUSHF

	MOV	AX,0100h
	PUSH	AX
	POPF
	CLI
	nop
	nop
	nop
	popf
	pop	word ptr ds:[6]
	Pop	word ptr ds:[4]

	mov	ax,dx
	sub	ax,5
	ret

@@newint1:
	inc	dx
	iret
;-----------------------------------------------
test_001:
	xor	ax,ax
	ret
test_002:	mov	ax,1234h
	ret
;-----------------------------------------------
test_105:
	cli			; interrupts OFF
	in	al, 64h 	; keyboard OFF
	or	al, 040h
	out	64h, al
	nop
	nop
	nop
	in	al, 64h 	; keyboard ON
	and	al, 0BFh
	out	64h, al
	sti			; interrupts ON
	xor	ax,ax
	ret
;-----------------------------------------------
test_106:		;test div 0
	mov	ax, 0040h	; BIOS segment address
	mov	es, ax		; ES = 0040h


	mov	di,20h		;mov to 40:20h
	mov	si,offset @@int00
	mov	cx,@@int00end-@@int00
	cld
	rep	movsb

	xor	ax, ax		; change the INT-table at 0000:0000
	mov	es, ax
	mov	cx, es:[0000h]	; save the INT 00h handler
	push	cx
	mov	cx, es:[0002h]
	push	cx

	mov	Word Ptr es:[0002h], 0040h  ; Set segment...
	mov	Word Ptr es:[0000h], 0020h  ; and offset of the new
					    ; INT handler.

@@Div_here:
	div	ax		; AX = 0000h => division by ZERO!
				; ==> INT 00h call!!
	; BX points now to "New_Entry_Point:".

	pop	word ptr es:[0002h]
	pop	word ptr es:[0000h]
	mov	ax,bx
	sub	ax,offset @@Div_here+2
	ret
@@int00:
	pop	bx
	inc	bx
	inc	bx
	push	bx
	iret
@@int00end:
;-----------------------------------------------
test_107:	;test flag
	PUSHF
	POP	AX
	PUSH	AX
	
	AND	AX,0FFFh
	PUSH	AX
	POPF
	PUSHF
	POP	AX
	TEST	AX,0F000h

	JE	@@error
	
	POP	AX
	PUSH	AX
	OR	AX,0F000h
	PUSH	AX
	POPF
	PUSHF
	POP	AX
	AND	AX,0F000h
	CMP	AX,0F000h
	JE	@@error

	POPF
	xor	ax,ax
	ret
@@error:
	popf
	mov	ax,1
	ret
;-----------------------------------------------
test_108:	;test Drx Crx
	MOV	EAX,CR2
	MOV	EBX,CR3
	XOR	EBX,EBX
	MOV	EAX,EBX
	MOV	EBX,FS
	MOV	EAX,00010000h
	MOV	FS,AX
	MOV	EAX,FS
	MOV	FS,BX
	ADD	EAX,00004BB9h
	CMP	EAX,00029385h
	JE	@@error
	MOV	ECX,00000500h
	MOV	EBX,DR7
	MOV	DR7,ECX
	MOV	EAX,DR7
	CMP	EAX,00000400h
	JE	@@error
	MOV	DR7,EBX
	XOR	EBX,EBX
	XOR	EAX,EAX
	XOR	EDX,EDX
	XOR	ECX,ECX
	ret
@@error:mov	ax,1
	ret
;-----------------------------------------------
test_109:	;test Drx Crx
	XOR	DX,DX
	PUSH	AX
	POP	AX
	DEC	SP
	DEC	SP
	POP	BX
	CMP	AX,BX
	JNE	@@error
	XOR	EDX,EDX
@@1ae:	ADD	EDX,01
	MOV	EAX,00000100h
	db	0fh,21h,0ebh
	db	0fh,23h,0e8h
	db	0fh,21h,0e9h
	db	0fh,23h,0ebh
;	MOV       EBX,DR5                  ;37BC:01B8  0F21EB          
;	MOV       DR5,EAX                  ;37BC:01BB  0F23E8          
;	MOV       ECX,DR5                  ;37BC:01BE  0F21E9          
;	MOV       DR5,EBX                  ;37BC:01C1  0F23EB          
	CMP	ECX,00000400h
	JNE	@@1f4
	MOV	ECX,CR0
	CMP	ECX,11h
	JNE	@@1f4
	MOV	ECX,DR7
	CMP	ECX,00000400h
	JNE	@@1f4
	MOV	ECX,00002000h
	db	0fh,23h,0e9h
	db	0fh,23h,0ebh
;	MOV       DR5,ECX                  ;37BC:01EE  0F23E9          
;	MOV       DR5,EBX                  ;37BC:01F1  0F23EB          
@@1f4:	CMP	EDX,10h
	JNE	@@1ae
	MOV	EBX,FS
	MOV	EAX,00010000h
	MOV	FS,AX
	MOV	EAX,FS
	MOV	FS,BX
	ADD	EAX,00018352h
	CMP	EAX,00028352h
	JE	@@error
	MOV	ECX,00000500h
	MOV	EBX,DR7
	MOV	DR7,ECX
	MOV	EAX,DR7
	CMP	EAX,00000400h
	JE	@@error
	MOV	DR7,EBX
	MOV	AX,1600h
	INT	2Fh
	OR	AL,AL
	JNE	@@271
	MOV	EBX,CR0
	CMP	EBX,10h
	JNE	@@271
	MOV	EAX,DR0
	CMP	EAX,00001000h
	JBE	@@271
	MOV	AX,DS
	MOV	BX,ES
	MOV	CX,GS
	MOV	DX,FS
	SUB	AX,BX
	SUB	CX,DX
	ADD	AX,CX
	CMP	AX,0000
	JNE	@@271
	JMP	@@error
@@271:	MOV	EAX,CR2
	MOV	EBX,CR3
	XOR	EBX,EBX
	MOV	EAX,EBX
	XOR	EBX,EBX
	XOR	EAX,EAX
	XOR	EDX,EDX
	XOR	ECX,ECX
	ret
@@error:mov	ax,1
	ret
;-----------------------------------------------
test_008:		;test jmp far	(ea)
	push	8000h
	pop	ds
	mov	ax,-2

	mov	ebx,ds:[23h]
	mov	byte ptr ds:[23h],40h	;inc ax
	mov	byte ptr ds:[24h],0cbh	;retf
	push	cs
	push	offset @@1
	db	0eah,23h,0,0,80h
@@1:	nop
	mov	ds:[23h],ebx

	mov	ebx,ds:[23h]
	mov	byte ptr ds:[23h],40h	;inc ax
	mov	byte ptr ds:[24h],0cfh	;iret
	pushf
	push	cs
	push	offset @@2
	db	0eah,23h,0,0,80h	;call far 8000:23
@@2:	nop
	mov	ds:[23h],ebx

	ret
;-----------------------------------------------
test_009:		;test jmp bx
	mov	bx,offset @@1
	mov	ax,2
	jmp	bx
	inc	ax
	inc	ax
@@1:	sub	ax,2
	ret
	
;-----------------------------------------------
test_110:		;test empty stack
	MOV	EAX,CR0
	CMP	AX,0011h
	JE	@@1
	NOP
	NOP
	MOV	EAX,0000FFFFh
	MOV	EDX,CR0
	MOV	CR0,EAX
	MOV	CR0,EDX
@@1:
	MOV	AH,48h
	MOV	BX,-01
	MOV	CX,27EBh
	MOV	BP,SP
	INT	21h		;ret ax=8
@@2:
	CLI
	CLD
	mov	bx,0
	ADD	AX,[BP-06]	;test empty stack
	ADD	AX,@@3-@@2-8
	JMP	AX
	inc	bx
	inc	bx
@@3:	inc	bx
	inc	bx
	lea	ax,[bx-2]
	ret
;-----------------------------------------------
test_111:		;if TF
	pushf
	pop	ax
	test	ax,100h
	jz	@@1
	ret
@@1:	mov	ax,ss
	mov	ss,ax
	pushf
	pop	ax
	test	ax,100h
	jz	@@2
	ret
@@2:	db	2eh,0f3h,2eh	;cs:repz cs:
	pushf	
	pop	ax
	test	ax,100h
	jz	@@3
	ret
@@3:
	xor	ax,ax
	ret
;-----------------------------------------------
test_112:		;test new int21
	push	0
	pop	ds
	mov	ax,ds:[21h*4]
	mov	word ptr cs:[@@1+1],ax
	mov	ax,ds:[21h*4+2]
	mov	word ptr cs:[@@1+3],ax

	mov	ah,30h
	int	21h
	mov	bx,ax
	
	push	bx
	mov	ah,30h
	pushf
@@1:	db	9ah	;call	far
	dd	0
	pop	bx

	sub	ax,bx
	jnz	@@bad

	mov	word ptr ds:[21h*4],offset @@newint21
	mov	ax,cs
	mov	ds:[21h*4+2],ax

	mov	dx,0
	mov	ah,4ch
	int	21h
	
	mov	ax,2521h
	int	21h
	mov	ax,1
@@bad:
	ret


@@newint21:
	cmp	ax,2521h
	jz	@@11
	inc	dx
	iret
@@11:
	pop	ax
	pop	ax
	pop	ax
	mov	ax,word ptr cs:[@@1+1]
	mov	ds:[21h*4],ax
	mov	ax,word ptr cs:[@@1+3]
	mov	ds:[21h*4+2],ax
	mov	ax,dx
	dec	ax
	ret
;-----------------------------------------------
test_113:		;test port 21
	in	al,21h
	mov	ah,al
	mov	al,0ffh
	out	21h,al
	nop
	nop
	nop
	mov	al,ah
	out	21h,al
	xor	ax,ax
	ret
;-----------------------------------------------
test_114:		;test fs:[46c]
	push	0
	pop	fs
	sti
	mov	ax,fs:[46ch]
@@1:	cmp	ax,fs:[46ch]
	jz	@@1
	xor	ax,ax
	ret
;-----------------------------------------------
test_003:		;test seta
	mov	cx,-1
	or	cx,cx
	mov	bx,cx
	seta	ah
	xor	cx,cx
	seta	al
	sub	ax,100h
	ret
;-----------------------------------------------
test_006:		;test jump in code

	mov	cx,09EBh
	mov	ax,0FE05h
	jmp	$-2
	add	ah,03Bh
	jmp	$-10	

	xor	ax,ax
	ret


end	start
