// Serial generator for Phrozen Crew crackme #1 by TSCube 24/06/2000

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int check(const char* serial);
int bruteforce(const char* letters);
int iseven(const unsigned int number);


int main(void)
{
	char letters[20];

	puts("Serial generator for Phrozen Crew crackme #1 by TSCube 24/06/2000\n");

	printf("Type any letters : ");
	gets(letters);

	puts("Bruteforcing...");
	bruteforce(letters);

	puts("<enter> to finish");
	getchar();

	return 0;
}


//////////////////////////////////////////
//////////////////////////////////////////

// displays all possible serials for string 'letters'

int bruteforce(const char* letters)
{
	unsigned int first_number;
	unsigned int second_number;
	unsigned int xor_value;

	xor_value=0;
	for (unsigned int i=0;i<strlen(letters);i++) xor_value ^= letters[i];

	// first_number ^ second_number = xor_value*X + 13

	for (first_number=0;first_number<10000;first_number++)
	{
		if (!iseven(first_number))
		{
			for (second_number=0;second_number<10000;second_number++)
			{
				if (!iseven(second_number))
				{
					if ( (first_number ^ second_number) % xor_value == 13)
					{
						printf("Possible serial : %04u%s%04u\n",first_number,letters,second_number);
					}
										
				}
			
			}
					
		}
	}


	return 0;

}

//////////////////////////////////////////
//////////////////////////////////////////


// checks if number is composed of even numbers (0,2,4,6,8)

// return value : 0 if number is composed of even numbers
//                1 otherwise

int iseven(const unsigned int number)
{
	char buffer[20];

	sprintf(buffer,"%u",number);

	for (unsigned int i=0;i<strlen(buffer);i++)
	{
		if ((buffer[i]!='0') && (buffer[i]!='2') && (buffer[i]!='4') && 
			(buffer[i]!='6') && (buffer[i]!='8'))
			return 1;
	}
	return 0;

}


//////////////////////////////////////////
//////////////////////////////////////////

// serial check routine, extracted from crackme
// (maybe buggy, but it's just to understand what's happening)

// return value : 1 if serial is correct
//                0 if serial is not correct

int check(const char* serial)
{
	char string1[50];
	char string2[50];
	char buffer[50];
	unsigned int length1=0;
	unsigned int length2=0;
	unsigned int xor_value=0;
	unsigned int magic1,magic2;

	// splits serials into 2 strings
	for (unsigned int i=0;i<strlen(serial);i++)
	{
		char temp=serial[i];

		if ( (temp=='0') || (temp=='2') || (temp=='4') || (temp=='6') || (temp=='8') )
		{
			string1[length1++] = temp;
		}
		else string2[length2++] = temp;
	
	}

	for (i=0;i<length2;i++) xor_value = xor_value ^ string2[i];
	if (xor_value==0) return 1;
	
	// adds '0' until length = 8
	string1[length1]=0x00;
	for (i=length1;i<8;i++) strcat(string1,"0");

	// converts first 4 chars to integer
	buffer[4]=0x00;
	for (i=0;i<4;i++) buffer[i] = string1[i]; 
	magic1 = atoi(buffer);

	// converts last 4 chars to integer
	for (i=0;i<4;i++) buffer[i] = string1[i+4];
	 magic2 = atoi(buffer);

	magic1 = magic1 ^ magic2;
	if (magic1 % xor_value != 13) return 1;

	return 0;

}