// Keygen for Phrozen Crew crackme #2 by TSCube 26/06/2000

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int check(const char* szname,const char* szserial);
int bruteforce(const char* szname,unsigned int* serial);
unsigned int chars2dword(unsigned char* array);

int main(void)
{
	unsigned int serial;
	char name[50];

	puts("Keygen for Phrozen Crew crackme #2 by TSCube 26/06/2000\n");

	printf("Name : ");
	gets(name);

	if(bruteforce(name,&serial)) puts("I can't find a serial for this name !");
	else printf("Serial : %u",serial);

	puts("\n<enter> to finish");
	getchar();

	return 0;
}

///////////////////////////////////////////////////
///////////////////////////////////////////////////

// serial check routine extracted from crackme

int check(const char* szname,const char* szserial)
{
	unsigned char magic[] = "PhroZenQ";
	unsigned char buffer[50];
	unsigned int serial,result1,result2;

	// 1st part : a few operations with the name
	strcpy((char*)buffer,szname);
	if (strlen(szname)<8) strncat((char*)buffer,"01234567",8-strlen(szname));
	buffer[0] = buffer[0] + buffer[7];
	buffer[1] = buffer[1] + buffer[6];
	buffer[2] = buffer[2] + buffer[5];
	buffer[3] = buffer[3] + buffer[4];

	for (unsigned int i=0;i<4;i++) buffer[i+4] = buffer[i];
	for (i=0;i<8;i++) buffer[i] = buffer[i] ^ magic[i];

	// second part : a few operations with the serial
	serial = atoi(szserial);
	result1 = _rotl(serial,buffer[0]);
	result1 = result1 ^ chars2dword(&buffer[5]);

	result2 = _rotr(chars2dword(&buffer[1]),(char)result1);

	if (result1!=result2) return 1;

	return 0;

}


/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////

// bruteforce method : 3 ways to do it, only 1 is good

int bruteforce(const char* szname,unsigned int* serial)
{
	unsigned char magic[] = "PhroZenQ";
	unsigned char buffer[50];
	unsigned int dword1,dword2;

	strcpy((char*)buffer,szname);
	if (strlen(szname)<8) strncat((char*)buffer,"01234567",8-strlen(szname));

	buffer[0] = buffer[0] + buffer[7];
	buffer[1] = buffer[1] + buffer[6];
	buffer[2] = buffer[2] + buffer[5];
	buffer[3] = buffer[3] + buffer[4];

	for (unsigned int i=0;i<4;i++) buffer[i+4] = buffer[i];
	for (i=0;i<8;i++) buffer[i] = buffer[i] ^ magic[i];


	dword1 = chars2dword(&buffer[5]);
	dword2 = chars2dword(&buffer[1]);


	// FIRST BRUTEFORCE METHOD : 10/20
	/*for (unsigned int brute=0;brute<0xFFFFFFFF;brute++)
	{
		unsigned int result1,result2;

		result1 = _rotl(brute,buffer[0]);
		result1 = result1 ^ dword1;
		result2 = _rotr(dword2,(char)result1);
		
		if (result1==result2) {*serial=brute; return 0; }
	}*/


	// SECOND BRUTE FORCE METHOD : 15/20
	/*for (unsigned int brute=0;brute<0xFFFFFFFF;brute++)
	{
		if (_rotl(brute,brute & 0xFF) == dword2)
		{
			*serial = _rotr(brute ^ dword1,buffer[0]);
			return 0;
		}
	}*/

	// THIRD BRUTEFORCE METHOD : 19/20 (maybe there's a better way ;)
	for (unsigned int brute=0;brute<256;brute++)
	{
		unsigned int temp = _rotr(dword2,brute); 
		if ( (temp & 0xFF) == brute)
		{
			*serial = _rotr(temp ^ dword1,buffer[0]);
			return 0;
		}
	}



	return 1;
}



//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////

// this function is easy to do in ASM : it converts 4 chars to a DWORD value
//
// example
// argument :     unsigned char array[]={0x12,0x34,0x56,0x78};
// return value : 0x78563412

unsigned int chars2dword(unsigned char* array)
{
	unsigned int dword = 0;
	
	for (int i=3;i>=0;i--) 
	{
		dword = dword << 8;
		dword = dword | (int)array[i];
	}

	return dword;
}