// Keygen for Wilse Artemis crackme by TSCube 02/07/2000

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

int check(const char* name, const char* serial, const char* clipboard);
int generate(const char* name);
unsigned int chars2dword(const unsigned char* array);
int checkstring(const char* string);


int main(void)
{
	char name[50] ;

	puts("Keygen for Wilse Artemis crackme by TSCube 02/07/2000\n");
	printf("Name (at least 8 letters) : ");
	gets(name);

	if (strlen(name)<8)
	{
		puts("I said : AT LEAST 8 LETTERS !!!");
		return 1;
	}

	generate(name);
	puts("\n<enter> to finish");

	return 0;
}


//////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////

// serial check routine (extracted from crackme but not used in keygen)

// returns 0 if serial/clipboard_content are correct
// returns 1 otherwise

int check(const char* name, const char* serial, const char* clipboard)
{
	if ( (strlen(name)<8) || (strlen(serial)<8) || (strlen(clipboard)<8)) return 1;

	unsigned int magic =0;
	for (int i=0;i<8;i++)
	{
		unsigned int aam,aad;

		aam = ((name[i]/10) << 8) + name[i]%10; // simulates the 'AAM' instruction
		magic += aam;
		aad = (clipboard[i]*10+clipboard[i]) % 256; // simulates the 'AAD' instruction
		aad *= magic;
		magic += aad;
	}

	magic ^= chars2dword((const unsigned char*)clipboard);
	magic ^= chars2dword((const unsigned char*)serial);

	if (magic) return 1;

	// if we land here, that means that magic==0, so this also means that we're 
	// registered if :
	// serial[4] == clipboard[4]
	// serial[5] == clipboard[5]
	// serial[6] == clipboard[6]
	// serial[4] == clipboard[7]
	magic ^= chars2dword((const unsigned char*)&clipboard[4]);
	magic ^= chars2dword((const unsigned char*)&serial[4]);

	if (magic) return 1;

	return 0; // registered !
}



////////////////////////////////////////////////////////
////////////////////////////////////////////////////////

// serial generation routine : uses bruteforce to find all possible solutions

int generate(const char* name)
{
	char serial[10];
	char clipboard[10];

	for (unsigned int brute=0;brute<99999999;brute++) // clipboard will only contain numbers
	{
		sprintf(clipboard,"%08u",brute); // clipboard will always contain 8 numbers

		unsigned int magic =0;
		for (int i=0;i<8;i++)
		{
			unsigned int aam,aad;

			aam = ((name[i]/10) << 8) + name[i]%10;
			magic += aam;
			aad = (clipboard[i]*10+clipboard[i]) % 256;
			aad *= magic;
			magic += aad;
		}

		magic ^= chars2dword((const unsigned char*)clipboard);

		// the following lines convert the serial to a string
		serial[0] = magic & 0xFF;
		serial[1] = (magic >> 8) & 0xFF;
		serial[2] = (magic >> 16) & 0xFF;
		serial[3] = (magic >> 24) & 0xFF;
		serial[4]=0x00;

		strcat(serial,&clipboard[4]);

		// we only display serials composed of letters or numbers
		if (!checkstring(serial) && (strlen(serial)==8))
		{
			printf("Clipboard value: %s     Serial : %s",clipboard,serial);
			puts("\n\n<enter> to continue...");
			getchar();
		}
	
	}

	return 0;

}


/////////////////////////////////////////////////////////
////////////////////////////////////////////////////////

// converts to a DWORD value the 4 bytes pointed to by 'array'

unsigned int chars2dword(const unsigned char* array)
{
	unsigned int dword = 0;
	
	for (int i=3;i>=0;i--) 
	{
		dword = dword << 8;
		dword = dword | (int)array[i];
	}

	return dword;
}


/////////////////////////////////////////////////////////
////////////////////////////////////////////////////////

// returns 0 if string is only composed of letters or numbers
// returns 1 otherwise

int checkstring(const char* string)
{
	for (unsigned int i=0;i<strlen(string);i++)
	{
		unsigned int car = string[i];
		if (!( ((car >= 'A') && (car <= 'Z')) || ((car >= 'a') && (car <= 'z')) || ((car >= '1') && (car <= '9')))) return 1;
	}

	return 0;
}
