//////////////////////////////////////////////////////////////////////
//
// MeltICE - SoftICE '95 version 3 detection - Made by David Eriksson
// ==================================================================
//
// Disclaimer
// ~~~~~~~~~~
// I take no responsibility for the authenticity of this information,
// or the results of the use or misuse of the source code.
// 
// SoftICE is a trademark of NuMega Technologies, Inc.
// 
#include <stdio.h>
#define WIN32_LEAN_AND_MEAN
#include <windows.h>

//////////////////////////////////////////////////////////////////////
//
// See if SoftICE version 3.x for Windows 95 is loaded
//
BOOL IsSoftIce95Loaded()
{
	HANDLE hFile;  
 
	// "\\.\SICE" without escape stuff
	hFile = CreateFile( "\\\\.\\SICE",	
						GENERIC_READ | GENERIC_WRITE,
						FILE_SHARE_READ | FILE_SHARE_WRITE,
						NULL,
						OPEN_EXISTING,
						FILE_ATTRIBUTE_NORMAL,
						NULL);

	if( hFile != INVALID_HANDLE_VALUE )
	{
		CloseHandle(hFile);
		return TRUE;
	}

	return FALSE;
}

//////////////////////////////////////////////////////////////////////
//
// See if SoftICE version 3.x for Windows NT is loaded
//
BOOL IsSoftIceNTLoaded()
{
	HANDLE hFile;  
 
	// "\\.\NTICE" without escape stuff
	hFile = CreateFile( "\\\\.\\NTICE",
						GENERIC_READ | GENERIC_WRITE,
						FILE_SHARE_READ | FILE_SHARE_WRITE,
						NULL,
						OPEN_EXISTING,
						FILE_ATTRIBUTE_NORMAL,
						NULL);

	if( hFile != INVALID_HANDLE_VALUE )
	{
		CloseHandle(hFile);
		return TRUE;
	}

	return FALSE;
}

//////////////////////////////////////////////////////////////////////
//
// Example code for calling these functions
//
int main(void)
{
	if( IsSoftIce95Loaded() )
		printf("SoftICE for Windows 95 is active!\n");
	else if( IsSoftIceNTLoaded() )
		printf("SoftICE for Windows NT is active!\n");
	else
		printf("Can't find SoftICE with this method!\n");

	return 0;
}