; Authors   : Christoph Gabler / Ali
; Procedure : Hardware breakpoints
; Date      : 17.3.2000
; Notice    : HW breaking is not possible under Windows

code segment
org  100h
assume cs:code,ds:code

.386p

HW_BREAKING:

; [1] Set a hw breakpoint

Mov Dx, Cs
Mov Bx, 103h              ; CS:103h
Mov Ax, 0303h             ; On memory access, use DR3
Call SetBreak             ; Call routine
Mov Ax, 0003h             ; Enable DR3
Call EnableBreak          ; Call routine

; [2] Set new INT1 handler
Push Ds
Push 0
Pop Ds
Mov DS:word ptr [4*1], offset INT1_Handler
Mov DS:word ptr [4*1+2], Cs
Pop Ds

Cmp CS:byte ptr [103h], 6 ; By accessing CS:103h a INT1 eccours  

Cmp Ax, 0C0DEh
Jne BreakError

; [3] Disable hw breakpoints
Call DisableBreak
Mov Ah, 9
Call Get_DeltaOffs1
db 'Breaking with hardware breakpoints was successfull.$'
Get_DeltaOffs1: Pop Dx
Int 21h
Int 20h
BreakError:
Call DisableBreak
Mov Ah, 9
Call Get_DeltaOffs
db 'Breaking with hardware breakpoints was NOT successfull.$'
Get_DeltaOffs: Pop Dx
Int 21h
Int 20h

;++
; Set hardware breakpoint
; Entry:
;	DX:BX	- segment:offset
;	AL	- num
;	AH	- type
;		    = 0 - execution
;		    = 1 - write
;		    = 3 - access
; Return:
;	NC	- if no error
;	CY	- if error occured
;--

        SetBreak proc

	pushad
	movzx	esi,dx
	shl	esi,4
	movzx	edi,bx
	add	esi,edi
	cmp	al,0
	jne	@@10
	mov	dr0,esi
@@10:	cmp	al,1
	jne	@@20
	mov	dr1,esi
@@20:	cmp	al,2
	jne	@@30
	mov	dr2,esi
@@30:	cmp	al,3
	ja	@@Err
	jne	@@40
	mov	dr3,esi
@@40:	mov	cl,al
	and	ah,0Fh			; Leave cond and len only
	movzx	ebx,ax
	xor	bl,bl
	shl	ebx,8
	mov	edx,0FFF0FFFFh
	shl	cl,2
	shl	ebx,cl
	shl	edx,cl			; Shift mask
	mov	bl,02h			; Global enable
	mov	dl,03h			; Mask both G&L enable bits
	shr	cl,1
	shl	bl,cl
	shl	dl,cl
	xor	dl,0FFh			; Invert mask
	mov	bh,2			; By setting this bit we make
					; CPU to point CS:IP exactly to
					; instruction that cause
					; breakpoint interrupt
	mov	dh,0FCh			; Mask is ready

	mov	eax,dr7
	and	eax,edx
	or	eax,ebx
	mov	dr7,eax
	popad
	clc
	ret
@@Err:	stc
	ret
	endp

;++
; Enable hardware breakpoint
; Entry:
;	AL	- num
; Return:
;	NC	- if no error
;	CY	- if error occured
; This procedure doesn't return error if al exceeds 3 and just
; enables nothing in this case.
;--

        EnableBreak proc
	push	eax			;
	push	ecx			;

	xor	ah,ah			;
	movzx	ecx,al			;
	shl	ecx,1			;
	inc	ecx			;
	mov	eax,dr7			;
	bts	eax,ecx			;
	mov	dr7,eax			;

	pop	ecx			;
	pop	eax			;
	ret				;
	endp				;

; Disables the breakpoints
DisableBreak:
Sub Eax, Eax
Mov Dr7, Eax
Mov Dr6, Eax
Ret

; INT1 handler which eccours as soon as the break condition is true
INT1_Handler:
Mov Ax, 0C0DEh
Iret

Code Ends
End HW_BREAKING

